/*************************************************************************************
CMTTS - TTS voice.

begun 27/9/03 by Mike Rozak.
Copyright 2003 by Mike Rozak. All rights reserved
*/

#include <windows.h>
#include <crtdbg.h>
#include "escarpment.h"
#include "..\M3D.h"
#include "resource.h"
#include "m3dwave.h"


// BUGFIX - Take these out, make Roger Blizzard2008 sound better without them
// since he has large variation in pitch and volume
#define NOMODS_GLOTTALPULSECHANGE   // glottal pulse change for energy
#define NOMODS_ENERGYPERPITCHGET // energy per pitch
#define NOMODS_ENERGYPERVOLUMEGET   // energyper volume
#define NOMODS_ENERGYPERVOLUMETUNE  // fine-tune energy per volume to keep same energy afterwards

// BUGFIX - Turn off phase interpolation since trying to do exact phase match per
// frame of PCM
#define NOMODS_INTERPPHASEDETAILED    // interpolate phase when adding unit
#define NOMODS_INTERPPHASE    // phase interpolation as stretch

// BUGFIX - Must have TURNOFFPHASEBEND OFF since doing no code with SRDETAILEDPHASE
#define NOMODS_TURNOFFPHASEBEND // turn off phase bend for SRDETAILEDPHASE

// BUGFIX - Take out BLURPHASE because shouldnt be necessary since have NOMODS_ALIGNPCM
// BUGFIX - turn off blurphase disable because not doing NOMODS_ALIGNPCM if not full PCM
// BUGFIX - Turn off THIS blurphase because will have a blurphase for SRDETAILEDPHASE
#define NOMODS_BLURPHASE      // blur phase

// #define USEPROSODYTREND       // turn this on to use prosdy trend - BUGFIX - off because done elsewhere

#ifdef _DEBUG
#define TURNOFFRANDOM         // so dont have to worry about random errors
#define NOMODS       // if defined this won't do any modifications to the original TTS voice units
#endif // _DEBUG

#ifdef NOMODS
#define TURNOFFRANDOM         // so dont have to worry about random errors


// phase effects
// #define NOMODS_INTERPPHASEDETAILED    // interpolate phase when adding unit
// #define NOMODS_SRDETAILEDPHASE // turn off detailed phase
// #define NOMODS_INTERPPHASE    // phase interpolation as stretch
// #define NOMODS_TURNOFFPHASEBEND // turn off phase bend for SRDETAILEDPHASE

// #define NOMODS_DISABLEUNITCONTINUITY   // disable unit-continuity score, encouring left units to have similar characteristics
// #define NOMODS_DISABLEPCM     // disable PCM for testing
// #define NOMODS_CANSKIP        // cant skip end /star of phoneme
// #define NOMODS_BLENDUNITS     // blend units together
// #define NOMODS_GLOTTALPULSECHANGE   // glottal pulse change for energy
// #define NOMODS_BLURPHASE      // blur phase
// #define NOMODS_BLURPHASEDETAILED // blur phsae using detailed SRFeatures
// #define NOMODS_BENDPHASEDETAILED   // bend phases up/down for better match
// #define NOMODS_VOICEDISGUISE  // voice disguise
// #define NOMODS_SHOUTWHISPER   // shout/whisper effect
// #define NOMODS_CHANGEDURATION // change the duration
// #define NOMODS_ENERGYPERPITCHGET // energy per pitch
// #define NOMODS_ENERGYPERVOLUMEGET   // energyper volume
// #define NOMODS_ENERGYPERVOLUMETUNE  // fine-tune energy per volume to keep same energy afterwards
// #define NOMODS_LOWPASS        // low-passs blurring of pitch and volume
// #define NOMODS_ORIGPITCH      // use original pitch
// #define NOMODS_SNAPTODURATION // snap-to-duration enables
// #define NOMODS_SNAPTOPITCH    // snap to pitch enabled
// #define NOMODS_DISABLERESIDUAL    // prosody, disable residual
// #define NOMODS_DISABLETRIPHONEPITCH // disable pitch bulge
// #define NOMODS_DISABLETYPICALSYLINFO // prosody, disable typical syl info
// #define NOMODS_DISABLEWORDSYL     // prosody, disable word syl
// #define NOMODS_DISABLEPHONEMOD      // prosody - disable phonemod values
// #define NOMODS_DISABLEPROSODYNGRAM   // prosody - disable ngram
// #define NOMODS_DISABLEPROSODYWORDMATCH // prosody - only accept matches in original speech, let phrase matches pass
// #define NOMODS_DISABLEPROSODYWORDRESIDUAL // prosody - if set then disable word-based residual prosody and use syllable-based instead
// #define NOMODS_DISABLEPROSODYMERGEMATCH   // prosody - combine the top two matches to reduce prosody noise
// #define NOMODS_VOLUME         // no volume adjust
// #define NOMODS_STRETCH        // non-linear stretch of phonemes
// #define NOMODS_ALIGNPCM       // align PCM for fullPCM audio
// #define NOMODS_DISABLEFUNCWORDGROUP   // if set then disable function word group for the scoring
#endif


#define TEMPLATEPROOSDYMODEL     // use the new template prosody model, that relies on matches

#ifdef TEMPLATEPROOSDYMODEL
// don't want the N-gram used at all with the template model
#define NOMODS_DISABLEPROSODYNGRAM   // prosody - disable ngram
#endif

#define USEPSOLA     // if set, then use psola, with different weights

// #define HOWMUCHSYNTHLIKEPCM      0.5      // how much of the PCM-oriented mods/values are used for spectrum synthesis
// #define HOWMUCHSYNTHLIKEPCM      0.2      // how much of the PCM-oriented mods/values are used for spectrum synthesis
   // BUGFIX - Fine-tuned to 0.2 using roger voice


#define USEDURSYL                // set to using syllable duration

#define DURPHONEPOW           0.5      // so not as much duration variation, so easier to understand
                                 // BUGFIX - Put in because of roger voice, but should make all voices clearer
#define VOLUMEPOW             0.5      // reduce the variability in volume, so easier to understand
                                 // BUGFIX - Put in here because of roger voice, but should make all voices clearer
#define PITCHPOW              1.0      // reduce the variability in pitch, so easier to understand
                                 // NOTE: Keeping this as 1.0 since doesn't make the voice any easier to understand
                                 // but removes some of the personality

#define PITCHSWEEPCOSTSCALE      2.0      // pitch sweeps are more costly than just pitch shifts... to try and
                                          // encourage same matches... since I think that F0 follows one of the formants.

// BUGFIX - Volume adjust up
#define TTSOUTPUTVOLUMESCALE     2.0     // how much the output volume is scaled, so TTS speaks loudly enough
         // Doing this since THEORETICALMAXENERGY seems to be too low
         // BUGFIX - Was sqrt((fp)2.0) but upped to 2.0

#define SNAPTOSCALEPITCH            ((fp)SRCOMPAREWEIGHT / 8.0)      // controls how much unit pitch/duration will snap to
#define SNAPTOSCALEDURATION         ((fp)SNAPTOSCALEPITCH / 2.0)     // duration much more likely to snap since doesn't affect prosody perception as much
                                 // the original. Seems like 10 is a good value.

#define SNAPTOSCALEBYUNITS          sqrt((fp)m_dwUnits / 10000.0)

// BUGFIX - Extra penalties since PSOLA also affecting phase, and since pitch detect NOT 100% accurate,
// and since stretching PSOLA sounds bad
// BUGFIX - Make relative to PCM pitch
// #define EXTRAPSOLAPITCHPENALTY        ((fp)SRCOMPAREWEIGHT / 12.0)  // extra penalty for pitch if using PSOLA, around 6
#define EXTRAPSOLAPITCHPENALTY         0.5      // when multiplied by PCMpitch, around 5

#define EXTRAPSOLADURATIONPENALTY     ((fp)EXTRAPSOLAPITCHPENALTY / 2.0)  // extra penalty for duration if using PSOLA, half that of pitch since not as bad

#define MODDURATION_UNITS_START        50000     // point at which duraton/pitch mod to exact copies of original starts
#define MODDURATION_UNITS_STOP         200000    // point at which duration/pitch mod at max

#define JOINFINDBESTRANGE              3        // can wiggle the range by 1/3 of a demiphone
   // BUGFIX - Was 1/2 of a demiphone, but think too much, cause some units to stretch out a lot

// BUGFIX - Turn this off just in case signficantly affecting voices, since NOT minor
// effect. Blizzard voice came out lousy, but probably because of bug, but still putting off
// BUGFIX - Reenabling to test out
// #define NOMODS_ENERGYPERPITCHGET // energy per pitch
// #define NOMODS_ENERGYPERVOLUMEGET   // energyper volume
// #define NOMODS_ENERGYPERVOLUMETUNE  // fine-tune energy per volume to keep same energy afterwards

// #define SNAPTOPITCH_10000     0.3   // snap to pitch at 10,000 units
// #define SNAPTOPITCH_100000    0.85   // snap to pitch at 100,000 units

// #define FULLPCM_PITCHERRORADD  50.0   // if full PCM, then pitch errors are increased in importance.
         // BUGFIX - hack from 20 to 50
         // BUGFIX - Changed to an addition so would do plosives too
         // BUGFIX - Actually caclulated and stored in gafUnitScorePCMPitch

// #define SNAPTODURATION_10000  0.2   // how much snap to duration with 10,000 units
// #define SNAPTODURATION_100000 0.6   // how much snap to duration with 100K units

#define TTSVERSION_DERIVED    0     // to make sure can't load in bad format
#define TTSVERSION_MASTER     11     // to make sure can't load in bad format
   // BUGFIX - Upped to 2 since just changed file format
   // BUGFIX - Upped to 4 since changed format of SRFEATURESMALL
   // BUGFIX - Upped to 5 because addid bDurSkew

#define OPTIMALNUMUNITS       10000  // optimal number of units that tested for
#define MAXPHONEHYP           (MAXUNITOPTION*2)   // maximum hypothesis for entire sentence, at OPTIMALNUMUNITS
#define MAXUNITOPTION         50    // maximum unit options, at OPTIMALNUMUNITS
                                    // BUGFIX - Lowered from 100 to 50 as speed optimization
                                    // Tried to lower to 25 but too many changes resulted
                                    // NOTE: Sounds slightly better with MAXUNITOPTION of 100, but too slow, using 50
#define MAXUNITOPTIONTOTAL    200   // no matter how large the voice, never have any more than this number of units
#define FIRSTPASSMAXUNITOPTIONSSCALE      4     // 4x as many units in first pass

#define PROSODYNGRAMRANGE     (POS_MAJOR_NUMPLUSONE*pLexTTS->Stresses())      // since need to handle stressed and unstressed

#define MINPROSODYSAMPLES     5     // must have 5 copies of a sample used for prosody calculation
#define MAXSUBVOICES          9     // maximum number of subvoices in a tts voice

#define COMPAREREGIONSIZE        3     // left/right by 3 syllables
// #define MAXCOMPAREREGIONERR      (256 * 4)   // maximum error per
// #define MAXCOMPAREREGIONERRTOTAL (MAXCOMPAREREGIONERR * COMPAREREGIONSIZE * COMPAREREGIONSIZE)

// #define COMPARESINGLESYLLABLE_CROSSSENTENCEPENALTY 12    // penalty for crossing a sentence boundary
// #define COMPARESINGLESYLLABLE_RANDOMIZE   6     // how much to randomize every value
         // BUGFIX - Upped from 4 to 6 to increase the amount of randomization
#define COMPARESINGLESYLLABLE_NOMATCH     (SRCOMPAREWEIGHT*100000)    // error if no match at all

#define FINDBESTMATCH_BEAMSEARCHNUM       10       // do 10 passes of beam searhc
#define FINDBESTMATCH_SEARCHGROUP         3        // group FINDBESTMATCH_BEAMSEARCHNUM together to find best version

// #define BEAMSEARCHSWITCHPENALTY           5       // how much penalty to include for switching sentences. This is a DIVISOR
      // 5 or 10 both seems to be ok. Choosing 5 so that will try to keep entire sentences together more
// #define BEAMSEARCHSWITCHSENTENCEPENALTY_LESSFORPOS 20 // include only a slight penalty for switching POS

                                                   // previous one chosen, then some penality

#define WORDSENTSYL_MINEXAMPLES           4        // must have 4 examples minimum


// SENTSYLHEADER - Header for binary version
typedef struct {
   DWORD             dwNum;      // number of syllables
   DWORD             dwPhrases;  // number of phrases in m_lSENTSYLPHRASE
} SENTSYLHEADER, *PSENTSYLHEADER;


// TTSMMP - For storing information passed to dialog
typedef struct {
   PCMTTS               pTTS;       // TTS working on
   PCM3DWave            pWave;      // wave for testing
   PCMTTSSubVoice       pSubVoice;  // subvoice to use
   WCHAR                szTTSImport[256]; // TTS to import
   PCMTTS               pTTSImport; // TTS to import
} TTSMMP, *PTTSMMP;


// PHONEHYP - Hypothesis about what triphone is used
#define PHONEHISTORY    (TTSDEMIPHONES+3 + TTSDEMIPHONES*5)        // number of phonemes in past that remember history
                                 // for hypothesis
                  // Since may make score change based on one complete phone back, and then a little bit
                  // BUGFIX - Make the phone history go 5 (or 6) phonmems back. Used to be TTSDEMIPHONES+3 (or 2 phonemes)

typedef struct {
   PCMTTSTriPhoneAudio  aPCMTTSTriPhoneAudio[PHONEHISTORY];   // previous triphones
   double               fScoreWithEnergy;    // score so far, lower = better
   double               fScoreNoEnergy;   // score so far, excluding eneryg
   DWORD                dwPreviousIndex;  // previous index into UNITOPTION list
   BOOL                 fEndSilence;   // set to TRUE if the last phoneme ended in a silence
} PHONEHYP, *PPHONEHYP;

// UNITOPTION - For storing information about potential unit
typedef struct {
   double               fScore;          // score to sort on
   PCMTTSTriPhoneAudio  pTPA;        // triphone audio to use. Can be NULL if silence
} UNITOPTION, *PUNITOPTION;


// FBMSUBSENT - Subsentnece information for find best match
typedef struct {
   DWORD                dwSubSentence;    // subsentence number
   DWORD                dwIndex;          // index into subsentence
   DWORD                dwSubSentenceLength; // number of (spoken) syllables in subsentence
   DWORD                dwSentenceType;   // TYPICALSYLINFO_XXX
} FBMSUBSENT, *PFBMSUBSENT;

#define TCEVALUEBITS       10                   // store 10 bits for value
#define TCEUNIQUEIDBITS    (32 - TCEVALUEBITS)
#define TCEVALUEMAXASFP    (SRCOMPAREWEIGHT)    // maximum error that expect to get
#define TCEVALUEMAXASINT   ((1 << TCEVALUEBITS) - 1)                // maximum value as integer

#define TCEVALUEEXTRACT(x)    ((x) >> TCEUNIQUEIDBITS)  // extract a value from dwTCECompact
#define TCEUNIQUEIDEXTRACT(x) ((x) & ((1 << TCEUNIQUEIDBITS) - 1) )  // extract unique ID from dwTCECompact
#define TCECOMPACTCREATE(x,y) (((x) << TCEUNIQUEIDBITS) | (y))

#define USESMALLTPACONNECTIONERROR        // so save memory
// TPACONNECTIONERROR - Stor information about the quality of a conneciton
#ifdef USESMALLTPACONNECTIONERROR
typedef struct {
   DWORD                      dwTCECompact;     // high 10 bits (TCEVALUEEXTRACT) have value, lower bits have uniqueID
//   WORD                       wTriPhoneIndex;       // triphone that associated with
//   BYTE                       bPhone;     // phoneme
//   BYTE                       bValue;     // value stored, 0 = 0.0, TCEVALUEMAXASINT = TCEVALUEMAX
} TPACONNECTIONERROR, *PTPACONNECTIONERROR;
#else
typedef struct {
   PCMTTSTriPhoneAudio        pTPA;       // triphone that associated with
   fp                         fValue;     // value stored
} TPACONNECTIONERROR, *PTPACONNECTIONERROR;
#endif

// TTSFEATURECOMPPCM - Extra PCM information
typedef struct {
   BYTE           bPCMHarmFadeStart;         // harmonic number where the fading starts, 0 = DC, 1= fund, 2 = 1st harm, etc.
   BYTE           bPCMHarmFadeFull;          // harmonic number where fading is full
   BYTE           bPCMHarmNyquist;           // harmonic number where the nyquist limit kicks in. If 0, then no data in features
   BYTE           bPCMFill;                  // nothing
   float          fPCMScale;                 // how much to scale the PCM values by
#ifdef SRFEATUREINCLUDEPCM_SHORT
   short          asPCM[SRFEATUREPCM];       // points to store
#else
   char           acPCM[SRFEATUREPCM];       // points to store
#endif
} TTSFEATURECOMPPCM, *PTTSFEATURECOMPPCM;



// MATCHRANKFILTER - For filtering
typedef struct {
   PBESTSENTSWEEP       pBest;         // pointer to original data stored here
   fp                   fRank;         // rank at the time
} MATCHRANKFILTER, *PMATCHRANKFILTER;

// BEAMDIFFERENCE - Structure where can store the beams and difference them
typedef struct {
   PCSentenceSyllable   pSS;           // sentence
   fp                   fScore;        // SR score
   fp                   fCompareRegion;     // from CompareRegion()
} BEAMDIFFERENCE, *PBEAMDIFFERENCE;




#ifndef TEMPLATEPROOSDYMODEL
// EMTFINDBESTMATCH - Prosody beam search info
typedef struct {
   // on all EMTCxxx
   DWORD          dwStart;       // start count
   DWORD          dwEnd;         // end count
   DWORD          dwType;        // type

   // specific
   PCListFixed    plPerSyl;
   fp             fAccuracy;
   DWORD          dwRandomness;  // how much to randomize. usually 1, but may be more
   PCSentenceSyllable pThis;
   CTTSProsody    **ppCTTSProsody;
   DWORD          dwNum;
   PCListFixed    plBEAMDIFFERENCE;
   PCOMPARESYLINFO   pInfo; // paramter info for penalties
   DWORD          dwMultiPass;
   PCMLexicon     pLexTTS;

} EMTFINDBESTMATCH, *PEMTFINDBESTMATCH;
#endif

// EMTSENTENCEMATCH - Fills in PCSentenceMatch
typedef struct {
   // on all EMTCxxx
   DWORD          dwStart;       // start count
   DWORD          dwEnd;         // end count
   DWORD          dwType;        // type

   // specific
   PCListFixed    plPCSentenceMatch;   // list of sentence matches, evaluate from start to end
   PCSentenceSyllable pSS;
   CTTSProsody    **ppCTTSProsody;
   DWORD          dwNum;
   PCOMPARESYLINFO   pInfo; // paramter info for penalties
   int            iTTSQuality;
   DWORD          dwMultiPass;
   BOOL           fWord;
   WORD           wPeriod;
   PCMLexicon     pLexTTS; // tts with phonemes in it

} EMTSENTENCEMATCH, *PEMTSENTENCEMATCH;


#define JOINHALFWINDOWSIZE                   (SRSAMPLESPERSEC / 20)  // 1/20th of a second on either side
#define MAXJOINRANGE                         (SRSAMPLESPERSEC / 50)  // join isn't allowed to be stretched any more than this

#define SCORECALCDISCONTINUITYSCALE                0.5      // if the previous unit to the proposed one is different than the

// #define  SCORECALCWEIGHTBOUNDARY_LONG        (128)         // how much the boundary is weighted compared to the
                                                // "self" score. 0 = none, 128 = 50%, 256 = 100%
      // BUGFIX - changed long from 64 to 128 so not that much difference
      // BUGFIX - returned SCORECALCWEIGHTBOUNDARY_XXX after fixed bug in scores. Was 128 and 128+64
      // BUGFIX - restored do 128 and 128+64 since contiguous phonemes important (from 128-32 and 128+32)
// #define  SCORECALCWEIGHTBOUNDARY_SHORT       (128+64)         // how much the boundary is weighted compared to the
// #define  LONGPHONEME                         (SRSAMPLESPERSEC/10)
// #define  SHORTPHONEME                        (SRSAMPLESPERSEC/25)
      // NOTE: weighting boundary as less important for long phonemes than short

// BUGFIX - Was 0.2, but should really be 1/SRSAMPLESPERSEC so negates * SRSAMPLESPERSEC
// BUGFIX - Was 0.2, but put in better phase so make dependent on non-PCM like
// BUGGFIX - Changed to 1 frame so that it's technically correct, with new substitution costs for mismatched context
// #define  SCORECALCWEIGHTBOUNDARY             (1.0/(fp)SRSAMPLESPERSEC)     // a change in unit affects the sound of the surround 0.2 second
// #define  SCORECALCWEIGHTBOUNDARY             (1.0/(fp)SRSAMPLESPERSEC + HOWMUCHSYNTHLIKEPCM / 0.5 * 0.2)     // a change in unit affects the sound of the surround 0.2 second
                                                      // SRFEATUREs signficantly
//#define  SCORECALCWEIGHTBOUNDARY_SCALEPLOSIVE   4.0   // encourage plosives to stick
//#define  SCORECALCWEIGHTBOUNDARY_SCALEUNVOICED  0.25  // don't need unvoiced (non-plosive) to stick

// BUGFIX - Changed to 0 so it's technically correct, with new substitution costs for mismatched context
#define  SCORECALCWEIGHTTHEORETICALBOUNDARY  0.0 // how much the theoretical boundary is weighted compared
// #define  SCORECALCWEIGHTTHEORETICALBOUNDARY  0.25 // how much the theoretical boundary is weighted compared
   // BUGFIX - Was 0.5. Theoertically should be 0, but think will stick with 0.25
// #define  SCORECALCWEIGHTTHEORETICALBOUNDARY  0.5 // how much the theoretical boundary is weighted compared
                                                // to the calculated boundar. 0 = none, 128=50%, 256=100%
                                                // BUGFIX - CHanged from (128+64) to 128
                                                // BUGFIX - Changed to fp
                                                // BUGFIX - Was 0.5, but thought issue through and should be 0

#define  MAXBORDERERROR    (BORDERDBSCALE * 60.0) // maximum error from border, for each side. so total is 2x this

// #define  HYPBADMEGAGROUP   MAXBORDERERROR       // error if found crossing megagroup
// #define  HYPBADGROUP       (MAXBORDERERROR/4)   // if bad group then this is the error
// #define  HYPBADSTRESS      (MAXBORDERERROR/16)   // error if found with same phoneme, but wrong stress
   // BUGFIX - changed from /8 to /16

// #define  HYPCONTIGUOUSUNITS      (MAXBORDERERROR/4)   // encourage contigous units
   // BUGFIX - Was MAXBORDERERROR/2, but decreased to MAXBORDERERROR/4 so that pitch would be relatively more important
// #define  MAXNOTCONTGIOUSNUM       0              // maximum count for not contious
   // BUGFIX - Can go up to NUMPHONECONTIGOUS, but puts way too much emphasis on contigous units
   // NOTE - Not sure if this should be any value at all, should probably all be in hypcontiguous
   // BUGFIX - Made 0 since I don't think this is right thing to do
// #define  HYPNOTCONTIGUOUS  (3*(fPlosive ? (MAXBORDERERROR*1) : (fVoiced ? (MAXBORDERERROR/4) : (MAXBORDERERROR/16))))   // error if same phoneme, but not contiguous
   // BUGFIX - Upped HYPNOTCONTIGUOUS to encourage contiguous chunks
   // Note: Plosive check is really high to make sure plosives stay attached to other stuff
   // BUGFIX - Multiply all by 4 to encourage contiguous
   // BUGFIX - Was multiplied by 4, but changed to 2 so that pitch would be relatively more important
   // BUGFIX - Reduced error for unvoiced non-plosive to 1/32 (from 1/8) to encourage cutting there
   // BUGGIX - was 2 - upped to 8 and improved quality of voice somewhat
   // BUGFIX - Lowered back to 3 since was going for long sequences, but at the expense of pitch and stretching. Seems to be between 2 and 4
   // BUGFIX - Was plosive w *2, unvoiced w/ /32, changed to *1 and /16 so not so severe

//#define  HYPBADWORD        (MAXBORDERERROR/16)  // error is same phoneme, contiguous, but from wrong word
#if 0 // no longer used
#define  HYPBADWORD        0  // error is same phoneme, contiguous, but from wrong word
#endif
   // BUGFIX - Remove this since no longer storing word number
#define  HYPINSERTSILENCE  (MAXBORDERERROR/2)   // penalty for coming out of or going into silence
   // BUGFIX - Used to include HYPBADSTRESS but it's no longer a define
#define  AVERAGEUNITLENGTH (SRSAMPLESPERSEC / 10)   // one fifth of a second for the averag length of a phoneme
   // BUGFIX - Was 1/5 of a second, should really be 1/10th of a second, which halves HYPAUTOCULL
#define  HYPAUTOCULL       (MAXBORDERERROR *2 * fEnergyAverage * AVERAGEUNITLENGTH)         // if a score is this much worse than the best one then cull
   // BUGFIX - Increase from HYPBADGROUP to HYPBADGROUP*2
   // BUGFIX - Moved back to HYPBADGROUP*1 because too slow
   // BUGFIX - Just changed to 3/2 just to be paranoid
   // NOTE - scaling HYPAUTOCULL by TTSDEMIPHONES since related to PHONEHISTORY
   // BUGFIX - Changed from 3/2 to *3 to make sure doesn't autocull too quickly
   // BUGFIX - Remove  * TTSDEMIPHONES since now enery is always sclaed by averageunitlength, independent of TTSDEMIPHONE
   // BUGFIX - Changed from MAXBORDERERROR*3 to MAXBORDERROR*2 because no difference



#define  ATSTARTOFPHONE                      ((dwTime%TTSDEMIPHONES)==0)
#define  ATENDOFPHONE                        ((dwTime%TTSDEMIPHONES)==(TTSDEMIPHONES-1))
//#define  CROSSWORDLESSPENALTYLEFT(x)         (fWordStart ? (x)/2 : (fSylStart ? (x)*2/3 : (x) ))
//#define  CROSSWORDLESSPENALTYRIGHT(x)        (fWordEnd ? (x)/2 : (fSylEnd ? (x)*2/3 : (x) ))
   // BUGFIX - take into account syllable boundary, and less penalty if bad units across words
   // BUGFIX - Maks ure CROSSWORDLESSPENALTYxxx takes into account demiphone... changed so doesnt
// #define  HYPBADWORDPOS     (10.0)          // penalty for bad word position, 5 db for each side off
// #define  HYPSCOREPITCHDELTAPEROCTAVE (HYPPITCHPENALTYPEROCTAVE)  // one octave difference in pitch is this bad
//#define  HYPSCOREPITCHDELTAPEROCTAVEFORGIVE (HYPPITCHPENALTYPEROCTAVEFORGIVE)  // forgive pitch errors very close
//#define  HYPSCOREDURDELTA  (HYPDURATIONPENALTYPERDOUBLE)   // doubling or halving of duration



// Values for gafUnitScoreXXX from MikeRozak analysis of unit costs
// old: Values for gafUnitScoreXXX from RMS analysis of unit costs

static float gafUnitScorePitch[PIS_PHONEGROUPNUM*2] = {
   // positive (target octave above), negative
	5.3512, 3.55162, // group <s>
	9.81302, 0.449239, // group ch, jh
	7.84784, 2.97665, // group w, y
	5.17531, 3.89925, // group l, r
	4.68591, 3.94159, // group m, n, ng
	11.5288, 0.00001, // group sh, zh
	2.36516, 5.11992, // group s, z
	2.63745, 0.00001, // group v, f
	4.51178, 1.48282, // group th, dh
	5.7301, 0.921601, // group hh
	4.277, 0.00001, // group k, g
	4.99237, 0.53784, // group t, d
	2.00449, 0.00001, // group p, b
	8.66692, 8.85124, // group ow0, oy0, aw0
	7.5846, 7.75416, // group iy0, ey0, ay0
	5.69806, 5.57257, // group ah0, er0, uw0, ao0, uh0
	6.46263, 4.38275, // group ih0, eh0, aa0, ae0

#if 0 // old
   3.26134, 6.97613,     // unvoiced, non-plosive
   2.53838, 1.1399,     // unvoiced, plosive
   5.43694, 6.5242,      // voiced, non-plosive
   3.76254, 3.71848      // voiced, plosive
#endif

#if 0 // old
   0.137398, 4.95881,     // unvoiced, non-plosive
   1.02145, 0.616936,     // unvoiced, plosive
   4.57858, 5.82458,      // voiced, non-plosive
   1.43473, 0.431937      // voiced, plosive
#endif

#if 0 // old
   16.824, 9.52332,     // unvoiced, non-plosive
   17.1924, 7.35937,     // unvoiced, plosive
   11.76, 26.1753,    // voiced, non-plosive
   16.6739, 22.7337     // voiced, plosive
#endif

#if 0 // old
   16.586, 15.2075,     // unvoiced, non-plosive
   19.214, 13.8033,     // unvoiced, plosive
   15.0329, 27.5951,    // voiced, non-plosive
   21.5957, 24.9832     // voiced, plosive
#endif
};


static float gafUnitScorePCMPitch[PIS_PHONEGROUPNUM*2] = {   // how much PCM affects score per HALF octave
   // positive (target octave above), negative
	9.47401, 9.78981, // group <s>
	13.2022, 13.7908, // group ch, jh
	8.01235, 8.58931, // group w, y
	9.76989, 9.95899, // group l, r
	7.24503, 7.53879, // group m, n, ng
	14.7098, 16.4177, // group sh, zh
	12.601, 12.734, // group s, z
	3.42164, 3.87679, // group v, f
	5.76587, 5.90601, // group th, dh
	7.35052, 7.1316, // group hh
	6.3378, 5.69456, // group k, g
	6.29245, 5.24131, // group t, d
	4.66741, 4.1101, // group p, b
	10.96, 12.0066, // group ow0, oy0, aw0
	13.9559, 14.8703, // group iy0, ey0, ay0
	11.6225, 12.5521, // group ah0, er0, uw0, ao0, uh0
	11.2024, 12.1957, // group ih0, eh0, aa0, ae0

#if 0 // old
   9.15072, 9.41169,     // unvoiced, non-plosive
   5.53668, 3.72535,     // unvoiced, plosive
   10.47, 9.90704,    // voiced, non-plosive
   5.45292, 4.40828     // voiced, plosive
#endif

#if 0 // old
   9.12921, 9.39481,     // unvoiced, non-plosive
   5.15381, 3.43388,     // unvoiced, plosive
   10.0669, 9.54803,    // voiced, non-plosive
   4.99302, 3.97431     // voiced, plosive
#endif
};

static float gafUnitScorePCMPitchPSOLA[PIS_PHONEGROUPNUM*2] = {
   // positive (target octave above), negative
	0.28196, 0.395767, // group <s>
	0.00001, 0.0229623, // group ch, jh
	0.00538001, 0.612696, // group w, y
	0.00001, 0.57605, // group l, r
	1.56261, 0.927349, // group m, n, ng
	0.00001, 0.00614441, // group sh, zh
	0.00001, 0.00001, // group s, z
	0.209889, 0.0351777, // group v, f
	0.364171, 0.283269, // group th, dh
	0.00001, 0.283104, // group hh
	0.229771, 0.00001, // group k, g
	0.400364, 0.00001, // group t, d
	0.373337, 0.143253, // group p, b
	0.00001, 0.637643, // group ow0, oy0, aw0
	0.57421, 0.586822, // group iy0, ey0, ay0
	0.0686841, 0.615227, // group ah0, er0, uw0, ao0, uh0
	0.00444149, 0.506777, // group ih0, eh0, aa0, ae0
};

static float gafUnitScoreEnergy[PIS_PHONEGROUPNUM*2] = {
   // positive (target 2x energy), negative
	5.35561, 6.09594, // group <s>
	6.53091, 6.04676, // group ch, jh
	5.41236, 6.09047, // group w, y
	4.96716, 9.03322, // group l, r
	4.12632, 4.16632, // group m, n, ng
	5.65364, 5.39794, // group sh, zh
	5.52195, 5.10629, // group s, z
	4.58884, 4.96796, // group v, f
	4.79743, 6.44916, // group th, dh
	4.42425, 5.27695, // group hh
	5.01105, 2.39952, // group k, g
	7.7055, 3.22596, // group t, d
	5.28637, 3.2111, // group p, b
	4.83504, 6.88279, // group ow0, oy0, aw0
	5.0229, 6.61428, // group iy0, ey0, ay0
	5.46553, 8.89122, // group ah0, er0, uw0, ao0, uh0
	5.15907, 8.35347, // group ih0, eh0, aa0, ae0

#if 0
   5.95421, 4.94055,     // unvoiced, non-plosive
   6.58129, 1.62313,     // unvoiced, plosive
   4.04076, 6.37049,    // voiced, non-plosive
   7.11288, 3.13895     // voiced, plosive
#endif // 0

#if 0 // old
   4.4046, 4.73545,     // unvoiced, non-plosive
   6.25073, 1.79535,     // unvoiced, plosive
   4.30057, 5.93665,    // voiced, non-plosive
   6.44539, 3.77563     // voiced, plosive
#endif

#if 0 // old
   6.14636, 4.2053,     // unvoiced, non-plosive
   9.21886, 2.82694,     // unvoiced, plosive
   5.47192, 8.80455,    // voiced, non-plosive
   8.9868, 6.1696     // voiced, plosive
#endif

#if 0 // old
   6.25005, 5.93238,     // unvoiced, non-plosive
   10.0495, 4.47909,     // unvoiced, plosive
   6.09601, 9.12716,    // voiced, non-plosive
   10.0854, 7.41321     // voiced, plosive
#endif
};

static float gafUnitScoreDuration[PIS_PHONEGROUPNUM*2] = {
   // positive (target 2x duration), negative
	2.37512, 6.91579, // group <s>
	3.21904, 8.03973, // group ch, jh
	1.9838, 3.6124, // group w, y
	2.22423, 5.22773, // group l, r
	1.52342, 3.58369, // group m, n, ng
	2.93666, 4.64788, // group sh, zh
	1.77808, 9.04257, // group s, z
	2.35137, 2.75222, // group v, f
	0.819525, 7.5093, // group th, dh
	2.40942, 4.81662, // group hh
	2.65018, 6.97895, // group k, g
	2.32915, 13.2614, // group t, d
	5.39286, 3.84855, // group p, b
	3.85484, 5.5534, // group ow0, oy0, aw0
	2.63104, 5.86035, // group iy0, ey0, ay0
	3.09662, 7.17445, // group ah0, er0, uw0, ao0, uh0
	1.83578, 7.45219, // group ih0, eh0, aa0, ae0

#if 0
   0.0516373, 1.50337,     // unvoiced, non-plosive
   3.02086, 15.5357,     // unvoiced, plosive
   1.04669, 5.04231,    // voiced, non-plosive
   4.45005, 4.81766     // voiced, plosive
#endif // 0

#if 0 // old
   0.651673, 2.33879,     // unvoiced, non-plosive
   2.25217, 11.0722,     // unvoiced, plosive
   1.25198, 4.24762,    // voiced, non-plosive
   3.58974, 4.33331     // voiced, plosive
#endif

#if 0 // old
   4.1431, 5.77113,     // unvoiced, non-plosive
   6.35849, 16.062,     // unvoiced, plosive
   5.00621, 7.21856,    // voiced, non-plosive
   9.59825, 11.8832     // voiced, plosive
#endif

#if 0 // old
   8.12401, 8.97243,     // unvoiced, non-plosive
   8.5188, 16.644,     // unvoiced, plosive
   5.87906, 7.86509,    // voiced, non-plosive
   10.4373, 11.419     // voiced, plosive
#endif
};

static float gafUnitScoreMismatchedWordPos[4] = {
	0.00001, // mismatch 0
	4.0098, // mismatch 1
	3.88608, // mismatch 2
	6.00878, // mismatch 3

#if 0
   0.0,        // no mismatch
   3.54646,    // start-of-word mismatch
   3.38406,    // end-of-word mismatch
   5.61296     // both start and end mismatch
#endif

#if 0 // old
   0.0,        // no mismatch
   3.24835,    // start-of-word mismatch
   2.99784,    // end-of-word mismatch
   5.0055     // both start and end mismatch
#endif

#if 0 // old
   0.0,        // no mismatch
   5.44,    // start-of-word mismatch
   4.94347,    // end-of-word mismatch
   8.46338     // both start and end mismatch
#endif

#if 0 // old
   6.06872,    // start-of-word mismatch
   5.78336,    // end-of-word mismatch
   9.32487     // both start and end mismatch
#endif
};

// mid phoneme unit score
static float gafUnitScoreNonContiguousMid[PIS_PHONEGROUPNUM] = {
	15.8106, // <s>
	18.3906, // ch, jh
	10.6717, // w, y
	14.3928, // l, r
	10.7931, // m, n, ng
	16.6794, // sh, zh
	13.8119, // s, z
	16.5607, // v, f
	16.3612, // th, dh
	18.4114, // hh
	25.1465, // k, g
	27.794, // t, d
	20.6398, // p, b
	9.14923, // ow0, oy0, aw0
	12.9469, // iy0, ey0, ay0
	13.2329, // ah0, er0, uw0, ao0, uh0
	13.1467, // ih0, eh0, aa0, ae0
};

static float gafUnitScoreNonContiguous[PIS_PHONEGROUPNUM*PIS_PHONEGROUPNUM] = {
   // Right-unvoiced-unplosive, Right-unvoiced-plosive, Right-voiced-unplosive, Right-voice-plosive
	13.6487, 13.6487, 13.6487, 13.6487, 13.6487, 13.6487, 13.6487, 13.6487, 13.6487, 13.6487, 13.6487, 13.6487, 13.6487, 13.6487, 13.6487, 13.6487, 13.6487,  // <s>
	13.6487, 15.9025, 13.7865, 14.7212, 14.9666, 16.8394, 12.9094, 15.4933, 16.4496, 14.0707, 14.7131, 23.394, 20.5118, 8.65315, 10.9964, 12.1306, 10.8953,  // ch, jh
	13.6487, 17.4446, 9.55423, 9.13812, 9.55423, 17.4446, 17.4446, 17.4446, 17.4446, 17.4446, 14.9651, 14.9651, 14.9651, 6.93246, 10.1433, 10.7016, 9.80379,  // w, y
	13.6487, 15.2591, 9.58885, 8.72742, 11.0234, 15.6341, 18.9582, 14.0631, 12.1666, 13.2039, 16.1371, 17.0049, 15.7499, 8.00566, 10.4482, 9.15078, 9.47289,  // l, r
	13.6487, 20.8603, 9.6351, 8.91981, 8.66736, 21.2579, 22.9313, 15.8514, 10.5402, 14.0537, 14.4059, 15.2468, 8.82158, 10.6002, 12.1796, 11.596, 11.7659,  // m, n, ng
	13.6487, 17.2756, 14.2479, 18.7049, 14.2153, 15.3851, 12.915, 14.8786, 15.7302, 14.817, 18.7109, 16.311, 13.8646, 13.853, 13.7079, 13.9428, 17.2009,  // sh, zh
	13.6487, 15.1466, 16.4637, 18.0284, 20.1109, 17.2746, 9.42271, 15.3914, 19.8543, 18.7383, 15.8974, 14.6519, 10.6749, 23.4207, 19.8527, 22.0907, 21.2321,  // s, z
	13.6487, 15.8599, 12.684, 14.6004, 10.3148, 16.4382, 20.2985, 12.3193, 11.7482, 16.6089, 10.8304, 20.0078, 9.9136, 9.08132, 9.618, 10.4029, 10.0965,  // v, f
	13.6487, 15.3851, 13.01, 10.8543, 14.5307, 16.1172, 11.0881, 14.081, 24.176, 16.5408, 17.2978, 15.9625, 16.5633, 8.60338, 12.2975, 12.2725, 8.20366,  // th, dh
	13.6487, 15.3851, 12.0102, 15.4916, 13.2254, 15.3851, 15.3851, 15.3851, 15.3851, 15.3851, 15.1539, 15.1539, 15.1539, 7.47082, 10.8035, 7.99872, 9.12222,  // hh
	13.6487, 22.3924, 16.2774, 14.3126, 16.3136, 14.464, 19.733, 19.2175, 19.8445, 17.6731, 19.0522, 22.9193, 20.1132, 10.7575, 13.5693, 13.5363, 11.812,  // k, g
	13.6487, 18.6594, 14.1208, 12.9147, 11.6269, 19.7848, 16.5149, 17.806, 17.1027, 18.667, 23.0472, 22.2863, 9.27995, 12.2201, 12.7826, 13.1697, 13.5594,  // t, d
	13.6487, 22.4642, 16.2873, 12.8433, 10.7876, 15.8735, 16.6523, 13.6813, 17.2173, 16.68, 21.3654, 29.2098, 21.1152, 7.63645, 11.9721, 9.87113, 9.88694,  // p, b
	13.6487, 15.1651, 7.49525, 8.86766, 10.9774, 15.4616, 17.5916, 9.75503, 15.4175, 13.9735, 15.2186, 19.9807, 13.5325, 16.539, 10.6721, 9.65533, 14.4762,  // ow0, oy0, aw0
	13.6487, 12.697, 8.1624, 11.2776, 10.3095, 13.863, 18.311, 13.3497, 14.5435, 12.2895, 16.0088, 19.1127, 13.9478, 16.5861, 12.3308, 14.9657, 14.7412,  // iy0, ey0, ay0
	13.6487, 14.773, 8.36912, 10.351, 11.7301, 14.795, 17.7615, 12.6276, 12.9718, 12.4949, 15.1822, 20.0702, 13.3612, 13.7821, 11.5878, 14.3294, 15.9483,  // ah0, er0, uw0, ao0, uh0
	13.6487, 15.6133, 8.07568, 8.46574, 12.1809, 15.8569, 18.8298, 14.7545, 16.4916, 14.2134, 16.9964, 21.4296, 15.8906, 10.5723, 10.3104, 10.9248, 14.6569,  // ih0, eh0, aa0, ae0

#if 0
   20.983,	17.3898,	17.8827,	13.7553, // Left-unvoiced-unplosive
   23.4204,	25.6705,	16.5138,	22.2021, // Left-unvoiced-plosive
   21.4237,	22.5253,	11.8014,	15.8964, // Left-voiced-unplosive
   24.7182,	31.301,	12.5925,	13.4632  // Left-voiced-plosive
#endif // 0


#if 0 // old
   15.0238,	12.2848,	13.4534,	7.32044, // Left-unvoiced-unplosive
   17.3766,	20.3705,	12.3427,	18.031, // Left-unvoiced-plosive
   15.7108,	15.8773,	9.69134,	11.0925, // Left-voiced-unplosive
   18.952,	21.4906,	10.4567,	9.86464  // Left-voiced-plosive
#endif

#if 0 // old
   17.5863,	19.8294,	10.7563,	18.57391, // Left-unvoiced-unplosive
   19.4647,	23.9222,	9.99214,	11.59, // Left-unvoiced-plosive
   19.6008,	18.1509,	9.79536,	10.9659, // Left-voiced-unplosive
   19.8675,	16.2664,	9.22927,	12.0881  // Left-voiced-plosive
#endif

#if 0 // old
   13.0327, 15.651, 8.77554, 14.8071, // Left-unvoiced-unplosive
   13.8531, 17.515, 7.75443, 8.59038, // Left-unvoiced-plosive
   14.5702, 13.3115, 7.48536, 8.08102, // Left-voiced-unplosive
   14.9595, 14.3236, 7.06577, 8.44248  // Left-voiced-plosive
#endif
};

static float gafUnitScoreLRMismatch[PIS_PHONEGROUPNUM*5*2*6] = {
   // Exact Match, Same triphone, Bad-stress, Right-group but bad phoneme, Bad-group, Bad-megagroup

	3.75086, 10.6968, 0.876978, 1.6523, 2.22296, 3.66536,  // Center context = <s>, left context mega group = 0
	3.75086, 10.6968, 2.98342, 5.53341, 5.25288, 7.31309,  // Center context = <s>, right context mega group = 0
	3.75086, 10.6968, 0.876978, 1.6523, 2.22296, 3.66536,  // Center context = <s>, left context mega group = 1
	3.75086, 10.6968, 2.98342, 5.53341, 5.25288, 7.31309,  // Center context = <s>, right context mega group = 1
	3.75086, 10.6968, 0.876978, 1.6523, 2.22296, 3.66536,  // Center context = <s>, left context mega group = 2
	3.75086, 10.6968, 2.98342, 5.53341, 5.25288, 7.31309,  // Center context = <s>, right context mega group = 2
	3.75086, 10.6968, 0.876978, 1.6523, 2.22296, 3.66536,  // Center context = <s>, left context mega group = 3
	3.75086, 10.6968, 2.98342, 5.53341, 5.25288, 7.31309,  // Center context = <s>, right context mega group = 3
	3.75086, 10.6968, 0.876978, 1.6523, 2.22296, 3.66536,  // Center context = <s>, left context mega group = 4
	3.75086, 10.6968, 2.98342, 5.53341, 5.25288, 7.31309,  // Center context = <s>, right context mega group = 4
	8.54003, 9.00489, 0.876978, 1.6523, 2.22296, 3.7004,  // Center context = ch, jh, left context mega group = 0
	8.78771, 11.4012, 2.98342, 5.53341, 5.25288, 3.93748,  // Center context = ch, jh, right context mega group = 0
	7.43839, 9.23848, 0.876978, 4.0321, 3.59037, 4.05659,  // Center context = ch, jh, left context mega group = 1
	8.75255, 11.3724, 2.98342, 8.78398, 12.5179, 9.40945,  // Center context = ch, jh, right context mega group = 1
	8.91479, 10.1127, 0.876978, 8.0198, 8.41581, 5.06579,  // Center context = ch, jh, left context mega group = 2
	7.8441, 8.80989, 2.98342, 8.83215, 12.3208, 10.3326,  // Center context = ch, jh, right context mega group = 2
	7.61081, 10.9528, 0.876978, 5.02661, 6.06517, 3.59213,  // Center context = ch, jh, left context mega group = 3
	7.98447, 8.78948, 2.98342, 15.9974, 11.4276, 12.8682,  // Center context = ch, jh, right context mega group = 3
	8.73232, 10.6216, 3.84169, 2.82322, 2.12141, 5.23503,  // Center context = ch, jh, left context mega group = 4
	8.34757, 8.92547, 4.0417, 3.54223, 3.04061, 9.27848,  // Center context = ch, jh, right context mega group = 4
	3.16096, 7.38967, 0.876978, 1.6523, 2.22296, 2.2543,  // Center context = w, y, left context mega group = 0
	2.80629, 8.55667, 2.98342, 5.53341, 5.25288, 4.91069,  // Center context = w, y, right context mega group = 0
	2.74848, 9.01347, 0.876978, 1.59678, 3.15781, 2.587,  // Center context = w, y, left context mega group = 1
	2.09068, 10.4066, 2.98342, 2.56119, 3.39559, 3.8225,  // Center context = w, y, right context mega group = 1
	2.2071, 8.74565, 0.876978, 1.29254, 2.41395, 2.95352,  // Center context = w, y, left context mega group = 2
	2.20942, 9.09404, 2.98342, 1.62901, 3.27855, 4.36585,  // Center context = w, y, right context mega group = 2
	1.73219, 8.03465, 0.876978, 1.41282, 2.72979, 2.95403,  // Center context = w, y, left context mega group = 3
	1.18188, 7.6608, 2.98342, 7.04348, 5.67983, 26.7447,  // Center context = w, y, right context mega group = 3
	2.39309, 6.99037, 1.5603, 2.42609, 2.21712, 2.92531,  // Center context = w, y, left context mega group = 4
	2.60213, 7.54649, 2.86005, 4.24993, 3.3883, 32.6269,  // Center context = w, y, right context mega group = 4
	2.71842, 7.10742, 0.876978, 1.6523, 2.22296, 10.4274,  // Center context = l, r, left context mega group = 0
	3.27003, 9.06762, 2.98342, 5.53341, 5.25288, 5.48256,  // Center context = l, r, right context mega group = 0
	0.882831, 8.05836, 0.876978, 2.45449, 2.76811, 5.27146,  // Center context = l, r, left context mega group = 1
	2.34267, 9.26792, 2.98342, 2.15115, 6.09311, 5.93625,  // Center context = l, r, right context mega group = 1
	1.26456, 8.30162, 0.876978, 2.89623, 5.49467, 4.58279,  // Center context = l, r, left context mega group = 2
	2.43706, 8.8713, 2.98342, 2.44529, 5.09667, 6.83701,  // Center context = l, r, right context mega group = 2
	1.30354, 8.80887, 0.876978, 1.81472, 2.38662, 4.11782,  // Center context = l, r, left context mega group = 3
	1.48797, 8.6942, 2.98342, 8.87294, 7.22795, 10.5147,  // Center context = l, r, right context mega group = 3
	2.18517, 9.03117, 2.90548, 2.63751, 3.25124, 5.27349,  // Center context = l, r, left context mega group = 4
	1.40816, 8.32641, 3.68327, 11.2267, 5.7561, 8.95769,  // Center context = l, r, right context mega group = 4
	2.88768, 7.38103, 0.876978, 1.6523, 2.22296, 3.08119,  // Center context = m, n, ng, left context mega group = 0
	2.57407, 8.38125, 2.98342, 5.53341, 5.25288, 4.63995,  // Center context = m, n, ng, right context mega group = 0
	1.96043, 8.28628, 0.876978, 1.43388, 9.22722, 2.98186,  // Center context = m, n, ng, left context mega group = 1
	2.01217, 10.4564, 2.98342, 2.61113, 1.75932, 3.15371,  // Center context = m, n, ng, right context mega group = 1
	2.48574, 6.89889, 0.876978, 2.40031, 3.60838, 3.64563,  // Center context = m, n, ng, left context mega group = 2
	2.08977, 9.17249, 2.98342, 1.34141, 2.37832, 3.22612,  // Center context = m, n, ng, right context mega group = 2
	1.70925, 7.39297, 0.876978, 2.7173, 2.60441, 2.87643,  // Center context = m, n, ng, left context mega group = 3
	1.01679, 7.96467, 2.98342, 2.33741, 2.37825, 4.24535,  // Center context = m, n, ng, right context mega group = 3
	2.1276, 9.77508, 0.777769, 1.17002, 1.22666, 3.54586,  // Center context = m, n, ng, left context mega group = 4
	2.31338, 8.54132, 2.7149, 3.70977, 2.84431, 5.59027,  // Center context = m, n, ng, right context mega group = 4
	8.81969, 8.94442, 0.876978, 1.6523, 2.22296, 1.8788,  // Center context = sh, zh, left context mega group = 0
	7.72079, 10.9318, 2.98342, 5.53341, 5.25288, 3.13187,  // Center context = sh, zh, right context mega group = 0
	8.47601, 9.50341, 0.876978, 1.41919, 2.71462, 1.78782,  // Center context = sh, zh, left context mega group = 1
	8.77546, 10.0986, 2.98342, 4.76751, 15.3724, 8.36449,  // Center context = sh, zh, right context mega group = 1
	8.88064, 6.83804, 0.876978, 7.32923, 5.49494, 4.95664,  // Center context = sh, zh, left context mega group = 2
	6.76706, 4.51792, 2.98342, 8.85142, 20.5918, 14.3654,  // Center context = sh, zh, right context mega group = 2
	8.64968, 9.23305, 0.876978, 5.16194, 5.8265, 2.87294,  // Center context = sh, zh, left context mega group = 3
	8.43976, 8.74871, 2.98342, 12.8638, 16.0751, 10.2879,  // Center context = sh, zh, right context mega group = 3
	8.22659, 9.6493, 2.1294, 2.18595, 1.923, 2.27815,  // Center context = sh, zh, left context mega group = 4
	8.47807, 9.41895, 4.12616, 3.49086, 2.7931, 6.29861,  // Center context = sh, zh, right context mega group = 4
	7.14564, 7.15128, 0.876978, 1.6523, 2.22296, 3.77095,  // Center context = s, z, left context mega group = 0
	6.64115, 10.2219, 2.98342, 5.53341, 5.25288, 3.51393,  // Center context = s, z, right context mega group = 0
	6.14312, 8.95596, 0.876978, 1.42239, 1.18512, 1.38233,  // Center context = s, z, left context mega group = 1
	7.04851, 9.16558, 2.98342, 4.52098, 2.88186, 5.82457,  // Center context = s, z, right context mega group = 1
	6.67505, 8.38521, 0.876978, 1.14388, 3.18406, 2.1589,  // Center context = s, z, left context mega group = 2
	6.1501, 10.2534, 2.98342, 12.1761, 12.3934, 9.21611,  // Center context = s, z, right context mega group = 2
	7.41957, 8.65098, 0.876978, 2.44877, 1.85806, 2.18224,  // Center context = s, z, left context mega group = 3
	7.90525, 11.4998, 2.98342, 7.01902, 7.70868, 8.48485,  // Center context = s, z, right context mega group = 3
	7.24964, 10.5613, 0.848046, 1.81486, 2.29447, 2.28558,  // Center context = s, z, left context mega group = 4
	7.53789, 7.68716, 1.79648, 2.48112, 1.93418, 6.77617,  // Center context = s, z, right context mega group = 4
	4.75839, 11.0962, 0.876978, 1.6523, 2.22296, 7.54214,  // Center context = v, f, left context mega group = 0
	4.0722, 10.5873, 2.98342, 5.53341, 5.25288, 7.18656,  // Center context = v, f, right context mega group = 0
	6.00889, 8.03592, 0.876978, 1.06609, 3.51108, 5.51992,  // Center context = v, f, left context mega group = 1
	4.95821, 11.4215, 2.98342, 18.881, 9.29323, 7.42012,  // Center context = v, f, right context mega group = 1
	5.34204, 9.05311, 0.876978, 2.33413, 4.41801, 6.2163,  // Center context = v, f, left context mega group = 2
	2.80188, 9.48704, 2.98342, 6.68265, 5.08115, 6.38153,  // Center context = v, f, right context mega group = 2
	5.50899, 9.53366, 0.876978, 1.92102, 2.12345, 4.8737,  // Center context = v, f, left context mega group = 3
	5.03134, 8.92535, 2.98342, 6.88764, 8.6802, 8.35174,  // Center context = v, f, right context mega group = 3
	4.36325, 9.61336, 0.340781, 2.31171, 2.23504, 6.05694,  // Center context = v, f, left context mega group = 4
	4.95949, 10.2489, 1.72986, 6.48725, 7.00493, 9.86442,  // Center context = v, f, right context mega group = 4
	4.0543, 11.7449, 0.876978, 1.6523, 2.22296, 0.380943,  // Center context = th, dh, left context mega group = 0
	4.71298, 10.9554, 2.98342, 5.53341, 5.25288, 6.79957,  // Center context = th, dh, right context mega group = 0
	3.67624, 10.6172, 0.876978, 1.32968, 8.68927, 1.42788,  // Center context = th, dh, left context mega group = 1
	5.0797, 7.75442, 2.98342, 4.76751, 10.8481, 8.70912,  // Center context = th, dh, right context mega group = 1
	3.95696, 11.2236, 0.876978, 5.56591, 5.45137, 3.03797,  // Center context = th, dh, left context mega group = 2
	4.80427, 10.2727, 2.98342, 7.79154, 5.66863, 5.37695,  // Center context = th, dh, right context mega group = 2
	3.58465, 10.2767, 0.876978, 1.1749, 1.94421, 2.96264,  // Center context = th, dh, left context mega group = 3
	7.37991, 7.83412, 2.98342, 13.1621, 11.2687, 11.3754,  // Center context = th, dh, right context mega group = 3
	4.43169, 9.74735, 1.31862, 1.58332, 1.59548, 3.06281,  // Center context = th, dh, left context mega group = 4
	3.84526, 11.5339, 2.8602, 3.35686, 1.48281, 9.23816,  // Center context = th, dh, right context mega group = 4
	3.57118, 10.2719, 0.876978, 1.6523, 2.22296, 2.08564,  // Center context = hh, left context mega group = 0
	6.27224, 10.3298, 2.98342, 5.53341, 5.25288, 4.19461,  // Center context = hh, right context mega group = 0
	3.73101, 9.13669, 0.876978, 0.650218, 3.75329, 2.44711,  // Center context = hh, left context mega group = 1
	6.89571, 9.33421, 2.98342, 4.76751, 2.92365, 5.96803,  // Center context = hh, right context mega group = 1
	3.95567, 10.1255, 0.876978, 1.21673, 3.57091, 2.69924,  // Center context = hh, left context mega group = 2
	5.01992, 9.78819, 2.98342, 8.85142, 9.74705, 8.39203,  // Center context = hh, right context mega group = 2
	2.93129, 8.50402, 0.876978, 3.32432, 4.10723, 4.5564,  // Center context = hh, left context mega group = 3
	6.37516, 7.84038, 2.98342, 6.98291, 12.5032, 16.8104,  // Center context = hh, right context mega group = 3
	3.49777, 7.55323, 0.856141, 1.91451, 4.52263, 4.60273,  // Center context = hh, left context mega group = 4
	3.49418, 9.93856, 4.92863, 10.532, 13.1338, 17.8618,  // Center context = hh, right context mega group = 4
	6.21445, 10.7241, 0.876978, 1.6523, 2.22296, 8.59525,  // Center context = k, g, left context mega group = 0
	5.58018, 10.5456, 2.98342, 5.53341, 5.25288, 7.01104,  // Center context = k, g, right context mega group = 0
	7.26044, 6.51594, 0.876978, 2.86182, 6.24597, 7.25883,  // Center context = k, g, left context mega group = 1
	4.30737, 12.8406, 2.98342, 7.46997, 8.15965, 8.01349,  // Center context = k, g, right context mega group = 1
	6.70658, 9.20652, 0.876978, 4.99203, 6.28868, 5.49402,  // Center context = k, g, left context mega group = 2
	5.27246, 10.3907, 2.98342, 8.9261, 7.80438, 8.37026,  // Center context = k, g, right context mega group = 2
	6.26795, 10.4724, 0.876978, 3.93991, 5.63827, 4.33844,  // Center context = k, g, left context mega group = 3
	5.7081, 9.58616, 2.98342, 11.8577, 14.3144, 14.5637,  // Center context = k, g, right context mega group = 3
	5.97371, 10.0052, 1.09629, 1.48959, 2.63819, 8.20951,  // Center context = k, g, left context mega group = 4
	6.7759, 10.1458, 3.44039, 6.44497, 9.62914, 11.8842,  // Center context = k, g, right context mega group = 4
	7.90267, 12.8578, 0.876978, 1.6523, 2.22296, 9.33993,  // Center context = t, d, left context mega group = 0
	6.24725, 16.8309, 2.98342, 5.53341, 5.25288, 7.52449,  // Center context = t, d, right context mega group = 0
	6.61681, 15.1098, 0.876978, 4.62065, 1.62456, 4.28578,  // Center context = t, d, left context mega group = 1
	3.52188, 11.983, 2.98342, 5.0679, 4.34999, 8.45032,  // Center context = t, d, right context mega group = 1
	7.77032, 13.2353, 0.876978, 3.37138, 3.93452, 5.70551,  // Center context = t, d, left context mega group = 2
	4.31466, 12.5832, 2.98342, 6.77285, 9.59206, 11.8755,  // Center context = t, d, right context mega group = 2
	5.83733, 18.1034, 0.876978, 2.99423, 2.75044, 2.86551,  // Center context = t, d, left context mega group = 3
	5.18123, 10.9522, 2.98342, 10.4312, 8.42748, 11.824,  // Center context = t, d, right context mega group = 3
	5.8274, 14.628, 0.874979, 1.87877, 2.11045, 5.59708,  // Center context = t, d, left context mega group = 4
	7.38182, 12.7611, 2.36101, 5.44951, 4.69152, 11.3158,  // Center context = t, d, right context mega group = 4
	3.45432, 11.5747, 0.876978, 1.6523, 2.22296, 10.4634,  // Center context = p, b, left context mega group = 0
	2.79985, 7.77556, 2.98342, 5.53341, 5.25288, 17.4627,  // Center context = p, b, right context mega group = 0
	4.68719, 5.18961, 0.876978, 3.41333, 6.34717, 10.6883,  // Center context = p, b, left context mega group = 1
	3.79918, 12.5919, 2.98342, 12.0102, 8.17745, 7.37887,  // Center context = p, b, right context mega group = 1
	4.74548, 4.93833, 0.876978, 3.5822, 8.16044, 11.0895,  // Center context = p, b, left context mega group = 2
	4.13794, 7.48855, 2.98342, 6.17581, 11.2026, 13.5523,  // Center context = p, b, right context mega group = 2
	4.97516, 7.66769, 0.876978, 2.76686, 3.44458, 6.45516,  // Center context = p, b, left context mega group = 3
	4.93686, 10.6107, 2.98342, 10.7442, 19.5651, 7.8624,  // Center context = p, b, right context mega group = 3
	4.23691, 6.44529, 3.01359, 1.85993, 1.91781, 10.6708,  // Center context = p, b, left context mega group = 4
	3.98172, 10.3347, 3.79768, 9.66354, 7.76276, 10.1947,  // Center context = p, b, right context mega group = 4
	3.51393, 7.10544, 0.876978, 1.6523, 2.22296, 3.65354,  // Center context = ow0, oy0, aw0, left context mega group = 0
	3.83289, 7.47368, 2.98342, 5.53341, 5.25288, 3.31458,  // Center context = ow0, oy0, aw0, right context mega group = 0
	2.74633, 6.77508, 0.876978, 1.75776, 2.75807, 2.56645,  // Center context = ow0, oy0, aw0, left context mega group = 1
	3.50239, 6.40656, 2.98342, 2.44999, 5.00607, 5.00544,  // Center context = ow0, oy0, aw0, right context mega group = 1
	2.84928, 6.65989, 0.876978, 3.35721, 3.82345, 2.82949,  // Center context = ow0, oy0, aw0, left context mega group = 2
	3.00988, 6.61738, 2.98342, 2.48211, 5.38302, 6.07025,  // Center context = ow0, oy0, aw0, right context mega group = 2
	2.87724, 6.94845, 0.876978, 3.29948, 3.02912, 2.76813,  // Center context = ow0, oy0, aw0, left context mega group = 3
	1.83432, 6.85514, 2.98342, 3.11532, 4.13627, 5.21998,  // Center context = ow0, oy0, aw0, right context mega group = 3
	3.31699, 6.57218, 2.98804, 4.60468, 5.39876, 4.25179,  // Center context = ow0, oy0, aw0, left context mega group = 4
	3.1063, 6.81413, 8.00936, 5.87742, 4.976, 5.79778,  // Center context = ow0, oy0, aw0, right context mega group = 4
	4.28157, 7.88865, 0.876978, 1.6523, 2.22296, 3.34314,  // Center context = iy0, ey0, ay0, left context mega group = 0
	3.47673, 9.89414, 2.98342, 5.53341, 5.25288, 5.21934,  // Center context = iy0, ey0, ay0, right context mega group = 0
	2.37796, 8.99937, 0.876978, 0.944972, 1.94067, 2.34109,  // Center context = iy0, ey0, ay0, left context mega group = 1
	3.46901, 7.96913, 2.98342, 3.23786, 3.09462, 5.97023,  // Center context = iy0, ey0, ay0, right context mega group = 1
	2.40238, 9.27385, 0.876978, 1.93918, 2.29673, 2.52471,  // Center context = iy0, ey0, ay0, left context mega group = 2
	2.81616, 8.37152, 2.98342, 2.43048, 3.89511, 6.71208,  // Center context = iy0, ey0, ay0, right context mega group = 2
	2.64383, 9.00239, 0.876978, 1.47291, 2.46353, 2.39917,  // Center context = iy0, ey0, ay0, left context mega group = 3
	1.52374, 8.86746, 2.98342, 4.47967, 7.00228, 8.78995,  // Center context = iy0, ey0, ay0, right context mega group = 3
	2.50946, 8.8556, 1.64129, 2.05615, 2.82716, 3.33732,  // Center context = iy0, ey0, ay0, left context mega group = 4
	3.14169, 7.84029, 3.30662, 3.61287, 3.37519, 7.77708,  // Center context = iy0, ey0, ay0, right context mega group = 4
	3.69599, 8.23248, 0.876978, 1.6523, 2.22296, 3.24023,  // Center context = ah0, er0, uw0, ao0, uh0, left context mega group = 0
	3.43294, 9.64339, 2.98342, 5.53341, 5.25288, 3.76254,  // Center context = ah0, er0, uw0, ao0, uh0, right context mega group = 0
	2.32488, 9.63463, 0.876978, 1.43909, 3.10649, 2.64192,  // Center context = ah0, er0, uw0, ao0, uh0, left context mega group = 1
	3.46273, 9.97012, 2.98342, 2.18889, 4.83831, 7.04019,  // Center context = ah0, er0, uw0, ao0, uh0, right context mega group = 1
	2.44304, 10.1909, 0.876978, 2.01013, 3.45136, 2.65356,  // Center context = ah0, er0, uw0, ao0, uh0, left context mega group = 2
	2.65988, 10.6227, 2.98342, 3.2398, 5.85406, 7.8543,  // Center context = ah0, er0, uw0, ao0, uh0, right context mega group = 2
	2.33678, 10.1232, 0.876978, 5.67607, 4.51129, 3.6302,  // Center context = ah0, er0, uw0, ao0, uh0, left context mega group = 3
	1.50818, 9.46362, 2.98342, 6.27012, 6.50877, 8.05329,  // Center context = ah0, er0, uw0, ao0, uh0, right context mega group = 3
	3.01885, 8.88214, 3.37825, 4.75121, 5.71241, 4.71274,  // Center context = ah0, er0, uw0, ao0, uh0, left context mega group = 4
	2.66208, 8.57033, 5.68326, 5.66, 5.08369, 8.4762,  // Center context = ah0, er0, uw0, ao0, uh0, right context mega group = 4
	3.76486, 9.78682, 0.876978, 1.6523, 2.22296, 3.32593,  // Center context = ih0, eh0, aa0, ae0, left context mega group = 0
	3.75355, 5.25387, 2.98342, 5.53341, 5.25288, 6.8701,  // Center context = ih0, eh0, aa0, ae0, right context mega group = 0
	2.45197, 9.97472, 0.876978, 1.03069, 2.23353, 2.50488,  // Center context = ih0, eh0, aa0, ae0, left context mega group = 1
	3.62836, 8.92997, 2.98342, 2.72809, 5.7109, 5.31602,  // Center context = ih0, eh0, aa0, ae0, right context mega group = 1
	2.30648, 9.73108, 0.876978, 1.19573, 3.04246, 3.62795,  // Center context = ih0, eh0, aa0, ae0, left context mega group = 2
	3.02576, 9.28108, 2.98342, 3.72223, 6.08878, 7.0674,  // Center context = ih0, eh0, aa0, ae0, right context mega group = 2
	2.65009, 8.92908, 0.876978, 3.14476, 2.67047, 3.59079,  // Center context = ih0, eh0, aa0, ae0, left context mega group = 3
	1.84988, 10.0574, 2.98342, 2.915, 8.58518, 6.92079,  // Center context = ih0, eh0, aa0, ae0, right context mega group = 3
	3.00944, 9.23108, 2.24525, 3.1862, 4.06885, 3.70816,  // Center context = ih0, eh0, aa0, ae0, left context mega group = 4
	2.66156, 3.02352, 6.40961, 6.0777, 10.8373, 11.7256,  // Center context = ih0, eh0, aa0, ae0, right context mega group = 4

#if 0
   0,	7.10275,	8.16902,	9.49628,	9.80523,	10.1494, // Left-unvoiced-unplosive
   0,	12.1435,	14.0719,	16.4526,	16.3558,	18.386, // Left-unvoiced-plosive
   0,	6.27066,	7.4617,	7.78172,	8.39252,	8.58548, // Left-voiced-unplosive
   0,	11.1495,	11.3497,	12.4729,	12.9176,	17.6884, // Left-voiced-plosive
   0,	7.10275,	11.3979,	14.0036,	15.0203,	12.643, // Right-unvoiced-unplosive
   0,	12.1435,	13.8527,	16.045,	16.2163,	23.8805, // Right-unvoiced-plosive
   0,	6.27066,	10.2875,	9.3183,	9.02072,	10.7925, // Right-voiced-unplosive
   0,	11.1495,	13.9198,	17.3506,	15.3796,	20.0688 // Right-voiced-plosive
#endif

#if 0 // old
   0.0, 0.679239,	1.30189,	1.67891,	2.90097, // Left-unvoiced-unplosive
   0.0, 0.0344689,	1.47429,	2.13354,	4.84023, // Left-unvoiced-plosive
   0.0, 0.439287,	0.998834,	1.51325,	2.22377, // Left-voiced-unplosive
   0.0, 0.515721,	1.02838,	1.60112,	5.76503, // Left-voiced-plosive
   0.0, 1.28548,	7.41827,	7.44867,	5.8721, // Right-unvoiced-unplosive
   0.0, 2.1615,	4.83523,	5.2944,	11.2103, // Right-unvoiced-plosive
   0.0, 2.71055,	3.30296,	2.62354,	4.3666, // Right-voiced-unplosive
   0.0, 3.02542,	7.46419,	5.615,	8.54378 // Right-voiced-plosive
#endif

#if 0 // old
   0.0, 0.708672,	1.34516,	1.53677,	2.40028, // Left-unvoiced-unplosive
   0.0, 0.368567,	1.22345,	1.71805,	3.74872, // Left-unvoiced-plosive
   0.0, 0.370962,	0.870423,	1.33029,	1.96968, // Left-voiced-unplosive
   0.0, 0.863352,	0.868759,	1.16547,	4.24172, // Left-voiced-plosive
   0.0, 1.1602,	5.73891,	6.22755,	5.01181, // Right-unvoiced-unplosive
   0.0, 1.77662,	4.98339,	5.55817,	10.7113, // Right-unvoiced-plosive
   0.0, 2.45565,	2.95764,	2.46089,	4.17409, // Right-voiced-unplosive
   0.0, 2.85855,	6.18551,	4.82366,	7.82891 // Right-voiced-plosive
#endif

#if 0 // old
   0.0, 2.29749,	2.67614,	2.7285,	3.66712, // Left-unvoiced-unplosive
   0.0, 2.28432,	2.6869,	3.13135,	5.06784, // Left-unvoiced-plosive
   0.0, 2.1833,	2.5162,	3.25946,	3.76826, // Left-voiced-unplosive
   0.0, 4.92307,	4.35489,	4.10025,	5.86267, // Left-voiced-plosive
   0.0, 4.97514,	7.26868,	6.13874,	5.80121, // Right-unvoiced-unplosive
   0.0, 3.5093,	5.84264,	6.33702,	12.2687, // Right-unvoiced-plosive
   0.0, 3.75096,	3.46354,	3.71729,	5.1184, // Right-voiced-unplosive
   0.0, 3.31006,	8.37524,	6.11292,	8.99412 // Right-voiced-plosive
#endif

#if 0 // old
   0.0, 2.59737,	3.13112,	2.99481,	4.00619, // Left-unvoiced-unplosive
   0.0, 3.62783,	3.37635,	4.0131,	5.98038, // Left-unvoiced-plosive
   0.0, 2.52534,	2.79459,	3.67427,	4.02458, // Left-voiced-unplosive
   0.0, 5.46902,	5.05528,	4.58008,	6.24641, // Left-voiced-plosive
   0.0, 5.82101,	7.69119,	6.11952,	6.35129, // Right-unvoiced-unplosive
   0.0, 4.32569,	6.11982,	6.76842,	11.3711, // Right-unvoiced-plosive
   0.0, 4.33169,	3.83635,	3.88489,	5.20379, // Right-voiced-unplosive
   0.0, 4.53714,	9.11982,	6.4027,	8.69404 // Right-voiced-plosive
#endif
};


static float gafUnitScoreFunc[PIS_PHONEGROUPNUM] = {
	0.306966, // group <s>
	0.839691, // group ch, jh
	0.384379, // group w, y
	0.587789, // group l, r
	0.240755, // group m, n, ng
	0.800328, // group sh, zh
	8.95132e-005, // group s, z
	0.367169, // group v, f
	0.000196727, // group th, dh
	0.616702, // group hh
	1.37855, // group k, g
	0.211486, // group t, d
	0.522837, // group p, b
	0.388374, // group ow0, oy0, aw0
	0.322707, // group iy0, ey0, ay0
	0.122324, // group ah0, er0, uw0, ao0, uh0
	0.0874421, // group ih0, eh0, aa0, ae0

#if 0 // from RMS
	0.708721, // group <s>
	2.7861, // group ch, jh
	0.538644, // group w, y
	2.1762, // group l, r
	0.605615, // group m, n, ng
	1.76178, // group sh, zh
	0.433396, // group s, z
	0.676774, // group v, f
	0.0041192, // group th, dh
	0.418904, // group hh
	2.82297, // group k, g
	0.500252, // group t, d
	0.942747, // group p, b
	0.6702, // group ow0, oy0, aw0
	0.699507, // group iy0, ey0, ay0
	0.202086, // group ah0, er0, uw0, ao0, uh0
	0.197609, // group ih0, eh0, aa0, ae0
#endif // 0
};


/*************************************************************************************
CProgressWaveTTSToWave::TTSWaveData - As per standard callback
*/
BOOL CProgressWaveTTSToWave::TTSWaveData (PCM3DWave pWave)
{
   if (pWave) {
      if (!m_pWave->AppendWave (pWave))
         return FALSE;
   }

   return TRUE;
}

/*************************************************************************************
UnitScoreScoreLRMismatch - Returns unit-score for non-contiguous units

inputs
   PCMTTS         pTTS - If not NULL, used to get voice-specific target costs
   DWORD          dwPhoneCenter - Phoneme at the center context
   DWORD          dwPhoneLR - Phoneme at the left/right context (see fRightContext)
   PCMLexicon     pLex - Lexicon
   BOOL           fRightContext - TRUE if right context, FALSE if left context
   DWORD          dwMismatch - 0 for exact match, 1 for trihonematch, 2 for bad stress, 3 right group but bad phone, 4 bad group, 5 bad megagroup
returns
   fp - Error
*/
__inline fp UnitScoreScoreLRMismatch (PCMTTS pTTS, DWORD dwPhoneCenter, DWORD dwPhoneLR, PCMLexicon pLex, BOOL fRightContext, DWORD dwMismatch)
{
   DWORD dwGroupCenter = pLex->PhonemeToGroup (dwPhoneCenter);
   DWORD dwMegaGroupLR = pLex->PhonemeToMegaGroup (dwPhoneLR);

   PTTSTARGETCOSTS pTarget = (pTTS && (pTTS->m_memTTSTARGETCOSTS.m_dwCurPosn == sizeof(TTSTARGETCOSTS))) ?
      (PTTSTARGETCOSTS)pTTS->m_memTTSTARGETCOSTS.p : NULL;
   float *pafUnitScoreLRMismatch = pTarget ? &pTarget->afUnitScoreLRMismatch[0][0][0][0] : &gafUnitScoreLRMismatch[0];

   return pafUnitScoreLRMismatch[
      (dwGroupCenter * PIS_PHONEMEGAGROUPNUM * 2 * 6) +
      (dwMegaGroupLR * 2 * 6) +
      (fRightContext ? (1*6) : 0) +
      dwMismatch];
}


/*************************************************************************************
UnitScoreScoreNonContiguous - Returns unit-score for non-contiguous units

inputs
   PCMTTS         pTTS - If not NULL, used to get voice-specific target costs
   DWORD       dwLeftPhone - Left phoneme
   DWORD       dwRightPhone - RIght phoneme
   BOOL        fMidPhone - If TRUE then dwLeftPhone == dwRightPhone, and this is a mid-phone split
   PCMLexicon  pLex - Lexicon
returns
   fp - Error
*/
__inline fp UnitScoreScoreNonContiguous (PCMTTS pTTS, DWORD dwLeftPhone, DWORD dwRightPhone, BOOL fMidPhone, PCMLexicon pLex)
{
   DWORD dwLeftPhoneGroup = pLex->PhonemeToGroup(dwLeftPhone);
   DWORD dwRightPhoneGroup = pLex->PhonemeToGroup(dwRightPhone);

   PTTSTARGETCOSTS pTarget = (pTTS && (pTTS->m_memTTSTARGETCOSTS.m_dwCurPosn == sizeof(TTSTARGETCOSTS))) ?
      (PTTSTARGETCOSTS)pTTS->m_memTTSTARGETCOSTS.p : NULL;
   float *pafUnitScoreNonContiguousMid = pTarget ? &pTarget->afUnitScoreNonContiguousMid[0] : &gafUnitScoreNonContiguousMid[0];
   float *pafUnitScoreNonContiguous = pTarget ? &pTarget->afUnitScoreNonContiguous[0][0] : &gafUnitScoreNonContiguous[0];

   if (fMidPhone) {
      _ASSERTE (dwLeftPhoneGroup == dwRightPhoneGroup);
      return pafUnitScoreNonContiguousMid[dwLeftPhoneGroup];
   }
   else
      return pafUnitScoreNonContiguous[dwLeftPhoneGroup * PIS_PHONEGROUPNUM + dwRightPhoneGroup];
}


/*************************************************************************************
UnitScoreJoinEstimate - Estimate the cost of a join.

inputs
   PCMTTS         pTTS - If not NULL, used to get voice-specific target costs
   DWORD       dwPhoneLeft - Left phoneme
   DWORD       dwPhoneRight - Right phoneme
   BOOL        fMidPhone - Set to TRUE if middle of phoneme, FALSE if dwPhoneLeft and dwPhoneRight straddle boundary
   PCMLexicon  pLex - Lexicon
returns
   fp - Total error over all frames.
*/
__inline fp UnitScoreJoinEstimate (PCMTTS pTTS, DWORD dwPhoneLeft, DWORD dwPhoneRight, BOOL fMidPhone, PCMLexicon pLex)
{
   return
      4.0 * UnitScoreScoreNonContiguous (pTTS, dwPhoneLeft, dwPhoneRight, fMidPhone, pLex) +  // match, but not contiguous
      (JOINHALFWINDOWSIZE - 2) / 2.0 * UnitScoreScoreLRMismatch (pTTS, dwPhoneLeft, dwPhoneRight, pLex, TRUE, 1) + // mismatch from left to right
      (JOINHALFWINDOWSIZE - 2) / 2.0 * UnitScoreScoreLRMismatch (pTTS, dwPhoneRight, dwPhoneLeft, pLex, FALSE, 1); // mismatch from right to right
}

/*************************************************************************************
UnitScorePitch - Returns unit-score based on pitch (per octave).

inputs
   PCMTTS         pTTS - If not NULL, used to get voice-specific target costs
   DWORD          dwPhone - Phoneme
   PCMLexicon     pLex - Lexicon
   BOOL           fHigher - TRUE if the target pitch is higher than the original unit pitch
   BOOL           fFullPCM - If full PCM then greatly increase this since large pitch error with PCM
returns
   fp - Error per octave
*/
__inline fp UnitScorePitch (PCMTTS pTTS, DWORD dwPhone, PCMLexicon pLex, BOOL fHigher, BOOL fFullPCM)
{
   DWORD dwIndex = (pLex->PhonemeToGroup (dwPhone) * 2) + (fHigher ? 0 : 1);
         // BUGFIX - Had (fHigher ? 1 : 0), which was opposite

   PTTSTARGETCOSTS pTarget = (pTTS && (pTTS->m_memTTSTARGETCOSTS.m_dwCurPosn == sizeof(TTSTARGETCOSTS))) ?
      (PTTSTARGETCOSTS)pTTS->m_memTTSTARGETCOSTS.p : NULL;
   float *pafUnitScorePitch = pTarget ? &pTarget->afUnitScorePitch[0][0] : &gafUnitScorePitch[0];
   float *pafUnitScorePCMPitchPSOLA = pTarget ? &pTarget->afUnitScorePCMPitchPSOLA[0][0] : &gafUnitScorePCMPitchPSOLA[0];
   float *pafUnitScorePCMPitch = pTarget ? &pTarget->afUnitScorePCMPitch[0][0] : &gafUnitScorePCMPitch[0];

   if (fFullPCM)
#ifdef USEPSOLA
      return pafUnitScorePitch[dwIndex] + pafUnitScorePCMPitchPSOLA[dwIndex] * 2.0 /* since half octave*/ +
         EXTRAPSOLAPITCHPENALTY * pafUnitScorePCMPitch[dwIndex];
            // BUGFIX - Changed meaning of EXTRAPSOLAPITCHPENALITY slightly
#else
      return pafUnitScorePitch[dwIndex] + pafUnitScorePCMPitch[dwIndex] * 2.0 /* since half octave*/;
#endif
   else
      return pafUnitScorePitch[dwIndex];
         // BUGFIX - removed this so using proper score.  + gafUnitScorePCMPitch[dwIndex] * 2.0 /* since half octave*/* (HOWMUCHSYNTHLIKEPCM / 2.0);
         // BUGFIX - Hack in add PCMPitch error to account for phase problems that occur with pitch shift
         // BUGFIX - Was /2.0, but changed to /4.0 so not as strong, since "roughly" PCM pitch shift sounds 4x as bad
         // bugfix - Was /4.0, but fixed phase a bit, so put into a more global adjustment
}


/*************************************************************************************
UnitScoreEnergy - Returns unit-score based on Energy (per doubling of energy).

inputs
   PCMTTS         pTTS - If not NULL, used to get voice-specific target costs
   DWORD          dwPhone - Phoneme
   PCMLexicon     pLex - Lexicon
   BOOL           fHigher - TRUE if the target energy is higher than the original unit energy
returns
   fp - Error per octave
*/
fp UnitScoreEnergy (PCMTTS pTTS, DWORD dwPhone, PCMLexicon pLex, BOOL fHigher)
{
   PTTSTARGETCOSTS pTarget = (pTTS && (pTTS->m_memTTSTARGETCOSTS.m_dwCurPosn == sizeof(TTSTARGETCOSTS))) ?
      (PTTSTARGETCOSTS)pTTS->m_memTTSTARGETCOSTS.p : NULL;
   float *pafUnitScoreEnergy = pTarget ? &pTarget->afUnitScoreEnergy[0][0] : &gafUnitScoreEnergy[0];

   return pafUnitScoreEnergy[(pLex->PhonemeToGroup (dwPhone) * 2) + (fHigher ? 0 : 1)];
      // BUGFIX - Had (fHigher ? 1 : 0)
}


/*************************************************************************************
UnitScoreDuration - Returns unit-score based on duration (per doubling of duration).

inputs
   PCMTTS         pTTS - If not NULL, used to get voice-specific target costs
   DWORD          dwPhone - Phoneme
   PCMLexicon     pLex - Lexicon
   BOOL           fHigher - TRUE if the target duration is higher than the original unit duration
   BOOL           fFullPCM - If full PCM then greatly increase this since large pitch error with PCM
returns
   fp - Error per octave
*/
__inline fp UnitScoreDuration (PCMTTS pTTS, DWORD dwPhone, PCMLexicon pLex, BOOL fHigher, BOOL fFullPCM)
{
   PTTSTARGETCOSTS pTarget = (pTTS && (pTTS->m_memTTSTARGETCOSTS.m_dwCurPosn == sizeof(TTSTARGETCOSTS))) ?
      (PTTSTARGETCOSTS)pTTS->m_memTTSTARGETCOSTS.p : NULL;
   float *pafUnitScoreDuration = pTarget ? &pTarget->afUnitScoreDuration[0][0] : &gafUnitScoreDuration[0];

   DWORD dwIndex = (pLex->PhonemeToGroup (dwPhone) * 2) + (fHigher ? 0 : 1);
         // BUGFIX - Had (fHigher ? 1 : 0), which was opposite

   // BUGFIX - If full PCM, include some of the PCM pitch penalty in duration since
   // TD-PSOLA doesn't sound very good when stretched
   float *pafUnitScorePCMPitch = pTarget ? &pTarget->afUnitScorePCMPitch[0][0] : &gafUnitScorePCMPitch[0];


   fp fRet = pafUnitScoreDuration[dwIndex];
   if (fFullPCM)
      fRet += (EXTRAPSOLADURATIONPENALTY * pafUnitScorePCMPitch[dwIndex]);
   return fRet;
      // BUGFIX - Had (fHigher ? 1 : 0)
}


/*************************************************************************************
UnitScoreFunc - Returns unit-score based on function word differnce.

NOTE: This is ignoring the fact that function words are already slightly penalized
with a bad SR score because based SR score on overweighted with non-function units

inputs
   PCMTTS         pTTS - If not NULL, used to get voice-specific target costs
   DWORD          dwPhone - Phoneme
   PCMLexicon     pLex - Lexicon
   DWORD          dwFuncWordGroupOrig - Function word group of the original unit.
   DWORD          dwFuncWordGroupTarget - Function word group of the unit that trying to create
returns
   fp - Error
*/
fp UnitScoreFunc (PCMTTS pTTS, DWORD dwPhone, PCMLexicon pLex, DWORD dwFuncWordGroupOrig, DWORD dwFuncWordGroupTarget)
{
   PTTSTARGETCOSTS pTarget = (pTTS && (pTTS->m_memTTSTARGETCOSTS.m_dwCurPosn == sizeof(TTSTARGETCOSTS))) ?
      (PTTSTARGETCOSTS)pTTS->m_memTTSTARGETCOSTS.p : NULL;
   float *pafUnitScoreFunc = pTarget ? &pTarget->afUnitScoreFunc[0] : &gafUnitScoreFunc[0];

   return pafUnitScoreFunc[pLex->PhonemeToGroup (dwPhone)] * (fp)abs((int)dwFuncWordGroupOrig - (int)dwFuncWordGroupTarget);
}



/*************************************************************************************
UnitScoreMismatchedWordPos - Returns unit-score caused by a mismatched word position.

inputs
   PCMTTS         pTTS - If not NULL, used to get voice-specific target costs
   DWORD          dwTarget - Target word position, bit 0x01 is start of word, bit 0x02 is end of word
   DWORD          dwOrig - Original word position, bit 0x01 is start of word, bit 0x02 is end of word
returns
   fp - Error per octave
*/
__inline fp UnitScoreMismatchedWordPos (PCMTTS pTTS, DWORD dwTarget, DWORD dwOrig)
{
   PTTSTARGETCOSTS pTarget = (pTTS && (pTTS->m_memTTSTARGETCOSTS.m_dwCurPosn == sizeof(TTSTARGETCOSTS))) ?
      (PTTSTARGETCOSTS)pTTS->m_memTTSTARGETCOSTS.p : NULL;
   float *pafUnitScoreMismatchedWordPos = pTarget ? &pTarget->afUnitScoreMismatchedWordPos[0] : &gafUnitScoreMismatchedWordPos[0];

   return pafUnitScoreMismatchedWordPos[(dwTarget ^ dwOrig) & 0x03];
}



/*************************************************************************************
TTS tags - this is a list of the TTS tags supported:

<phoneme ph="hh eh1 l oe0">Hello</phoneme> - Uses the given phonemes.

<emphasis xyz>Hello</emphasis> - Emphasized the word(s)
   If xyz is none then default to "level=moderate"
   If xyz is level=xxx, then xxx is strong, moderate, none, reduced
   Can also have PitchRel=, VolRel=, DurRel= for relative pitch, volume, and duration
      where 1.0 is no change
   Or can have PitchAbs=x (x is in hz), VolAbs=x (x is what?, DurAbs=x (x is in seconds)
   VolAbs = sum of SRFEATUREEnergy()/# features

<punct text="PUNCT" durabs=SEC/> - Punctuation notation

<break/> - Puts a break between words
   Can have "time=xxx", where xxx = "none", "x-small", "small", "medium" (default),
   "large", and "x-large". Can also be "XXXms" or "XXXs".

<TransPros>...</TransPros> - Indicate transplanted prosody
   Can contain <OrigText>xxx</OrigText> to indicate original text
   Can contain other stuff too.. tppitchrel, tppitchabs, tpvolrel, tpvolabs, tpdurrel, tpdurabs

<prosody xyz>...</prosody> - Controls how the text is read within the prosody tag.
   XYZ can be:
   pitch=XXX. Can be a number followed by hz, percent (100% = norm pitch),
      a relative change (+/- number or percent, or "st" for semitones),
      or x-high, high, medium, low, x-low, or default
   range=xxx. Can be a percent (100% = normal), +/- percent, or x-high,high,medium,
      low, x-low, or default
   rate=xxx. Can be a number (wpm), percent (as percent of wpm), +/- percent,
      +/- number, or x-fast, fast,medium,slow,x-slow, or default
   volume=xxx. Can be a number (100 = def volume), percent (100% = def percent),
      +/- percent, +/- number, or silent, x-soft, soft, medium, loud, x-loud, default

<pos major=xxx>...</pos> - Sets the pos for the words, disambiguate "invalid" (in-vuh-lid or in-val-id)
   XXX can be: n/noun, pron/pronoun, adj/adjective, prep/preposition, art/article,
   v/verb, adv/adverb, aux v/auxiliary verb, conj/conjunction, interj/interjection

<subvoice attribs/> - Can occur anywhere in the text and affects the subvoice for everything (for now)
   subvoice=x - If used, this uses subvoice 1..9 (or however many). Otherise, mix...
   mixvoice=x - Number. Use each of the digits to determine a mix
   mixpros=x - Number. Mixes the prosody.
   mixpron=x - Number. Mixes pronunciations. At the moment, only takes the least-signficant digit
               NOTE: Mixing for all of these is based on a series of digits. Repeating a digit
               increases the weight.

<emotion attribs>...</emotion> - Sets the emotion
   whisper=x - If wispering, 0..100
   shout=x - If shouting, 0..100
   quiet=x - If quiet, 0..100 (opposite of shout)
   happy=x - 0..100
   sad=x - 0..100
   afraid=x - 0..100
   drunk=x - 0..100
*/



// globals
static CListFixed  glPCMTTS;       // list of tts voices cached
static BOOL gfPCMTTSValid = FALSE; // set to TRUE if initalized
static PWSTR gpszPunctPros = L"PunctPros";
static PWSTR gpszPunct = L"Punct";
static PWSTR gpszFuncWord = L"FuncWord";
static PWSTR gpszEmphasis = L"Emphasis";
static PWSTR gpszTransPros = L"TransPros";
static PWSTR gpszOrigText = L"OrigText";
static PWSTR gpszLevel = L"Level";
static PWSTR gpszStrong = L"Strong";
static PWSTR gpszModerate = L"Moderate";
static PWSTR gpszNone = L"None";
static PWSTR gpszReduced = L"Reduced";

static PWSTR gpszPitchRel = L"PitchRel";
static PWSTR gpszVolRel = L"VolRel";
static PWSTR gpszDurRel = L"DurRel";
static PWSTR gpszPitchAbs = L"PitchAbs";
static PWSTR gpszVolAbs = L"VolAbs";
static PWSTR gpszDurAbs = L"DurAbs";
static PWSTR gpszInflectPoint = L"InflectPoint";
static PWSTR gpszBreak = L"Break";
static PWSTR gpszTime = L"Time";
static PWSTR gpszPh = L"ph";

static PWSTR gpszPauseLeft = L"PauseLeft";
static PWSTR gpszSylDurPhone = L"SylDurPhone";
static PWSTR gpszSylDurSyl = L"SylDurSyl";
static PWSTR gpszSylDurSkew = L"SylDurSkew";
static PWSTR gpszSylPitch = L"SylPitch";
static PWSTR gpszSylPitchSweep = L"SylPitchSweep";
static PWSTR gpszSylPitchBulge = L"SylPitchBulge";
static PWSTR gpszSylVol = L"SylVol";
static PWSTR gpszSyllables = L"Syllables";
static PWSTR gpszDerMicropauses = L"DerMicropauses";

static PWSTR gpszTPDurRel = L"TPDurRel";
static PWSTR gpszTPDurAbs = L"TPDurAbs";
static PWSTR gpszTPVolRel = L"TPVolRel";
static PWSTR gpszTPVolAbs = L"TPVolAbs";
static PWSTR gpszTPPitchRel = L"TPPitchRel";
static PWSTR gpszTPPitchAbs = L"TPPitchAbs";

static PWSTR gpszEmotion = L"Emotion";
static PWSTR gpszWhisper = L"Whisper";
static PWSTR gpszShout = L"Shout";
static PWSTR gpszQuiet = L"Quiet";
static PWSTR gpszHappy = L"Happy";
static PWSTR gpszSad = L"Sad";
static PWSTR gpszAfraid = L"Afraid";
static PWSTR gpszDrunk = L"Drunk";

static PWSTR gpszTTSGlobalState = L"TTSGlobalState";
static PWSTR gpszAvgPitch = L"AvgPitch";
static PWSTR gpszAvgSyllableDur = L"AvgSyllableDur";
static PWSTR gpszWPM = L"WPM";
static PWSTR gpszVol = L"Vol";
static PWSTR gpszPitchExpress = L"PitchExpress";
static PWSTR gpszEmotionWhisper = L"EmotionWhisper";
static PWSTR gpszEmotionShout = L"EmotionShout";
static PWSTR gpszEmotionQuiet = L"EmotionQuiet";
static PWSTR gpszEmotionHappy = L"EmotionHappy";
static PWSTR gpszEmotionSad = L"EmotionSad";
static PWSTR gpszEmotionAfraid = L"EmotionAfraid";
static PWSTR gpszEmotionDrunk = L"EmotionDrunk";

static PWSTR gpszProsody = L"Prosody";
static PWSTR gpszPitch = L"Pitch";
static PWSTR gpszRange = L"Range";
static PWSTR gpszRate = L"Rate";
static PWSTR gpszVolume = L"Volume";

static PWSTR gpszPOS = L"POS";
static PWSTR gpszMajor = L"Major";

static char gszKeyTTSFile[] = "TTSFile";

static PCM3DWave     gpTTSCacheSpeakWave = NULL;

/*************************************************************************************
SentenceLengthToBin - Given a sentence length (in syllables), this returns
the bin to use, as well as the average length for the sentence.

inputs
   DWORD       dwLength - Length in syllables
   DWORD       *pdwAvgLength - If not NULL, filled in with the average length of the bin sentence
returns
   DWORD - Bin number, from 0 to SENTENCELENGTHTOBINNUM-1
*/
DWORD SentenceLengthToBin (DWORD dwLength)
{
   DWORD dwRet = 0;
   //BYTE bLastBit = 0;
   while (dwLength) {
      //bLastBit <<= 1;
      //bLastBit |= (BYTE)(dwLength & 0x01);
      dwLength /= 2;
      dwRet++;
   }
   if (dwRet)
      dwRet--; // since should always be at least one bit

   dwRet = dwRet; //  * 2 + ((bLastBit & 0x2) ? 1 : 0);
   dwRet = min(dwRet, SENTENCELENGTHTOBINNUM-1);

   return dwRet;
}


/*************************************************************************************
SentenceLengthFromBin - Given a bin number (for SentenceLengthToBin()), this
returns the average sentence length.

inputs
   DWORD       dwBin - From 0 .. SENTENCELENGTHTOBINNUM-1
returns
   DWORD - Average sentence length
*/
DWORD SentenceLengthFromBin (DWORD dwBin)
{
   //*pdwAvgLength = (1 << (dwRet/2));
   //if (dwRet % 3)
   //   *pdwAvgLength += (*pdwAvgLength)/2;
   DWORD dwRet = (1 << dwBin);
   dwRet += dwRet/2; // so mid-way between this and the next

   return dwRet;
}


/*************************************************************************************
SentenceLengthTotal - Returns the total number of entries for all the
sentences. This is the sum of SentenceLengthFromBin() over 0 .. SENTENCELENGTHTOBINNUM-1

inputs
   DWORD          dwNum - If -1 (default) then sums up over all bins.
                        If less than, then sums up to the given bin; used to
                        index into m_amemTYPICALSYLINFO.
returns
   DWORD - Number
*/
DWORD SentenceLengthTotal (DWORD dwNum)
{
   if (dwNum >= SENTENCELENGTHTOBINNUM)
      dwNum = SENTENCELENGTHTOBINNUM;

   DWORD i;
   DWORD dwSum = 0;
   for (i = 0; i < dwNum; i++)
      dwSum += SentenceLengthFromBin(i);

   return dwSum;
}


/*************************************************************************************
CTTSProsody::ProsodyNGramInfoCount - Returns the number of elements stored for the Ngrams

inputs
   PCListFixed       pLexTTS - Lexicon with all the phonemes in it.
returns
   DWORD - Number
*/
#ifndef NOMODS_DISABLEPROSODYNGRAM
DWORD CTTSProsody::ProsodyNGramInfoCount (PCMLexicon pLexTTS)
{
   DWORD dwRet = 1;
   DWORD i;
   for (i = 0; i <= PROSODYNGRAMNUM*2; i++)
      dwRet *= PROSODYNGRAMRANGE;

   return dwRet;
}
#endif



/*************************************************************************************
AttribGetArray - Gets an array of DWORDs from an attribute.

inputs
   PCMMLNode2     pNode - Node
   PWSTR          pszName - Attribute name
   PCListFixed    plDWORD - Initialized to sizeof(DWORD) and then values are gotten
returns
   BOOL - TRUE if found, FALSE if not
*/
BOOL AttribGetArray (PCMMLNode2 pNode, PWSTR pszName, PCListFixed plDWORD)
{
   size_t dwSize = 0;
   PBYTE pb = (PBYTE) pNode->AttribGetBinary (pszName, &dwSize);
   dwSize /= sizeof(DWORD);
   if (!pb || !dwSize) {
      plDWORD->Clear();
      return FALSE;
   }

   plDWORD->Init (sizeof(DWORD), pb, (DWORD) dwSize);
   return TRUE;
}



/*************************************************************************************
AttribSetArray - Sets an array of DWORDs from an attribute.

inputs
   PCMMLNode2     pNode - Node
   PWSTR          pszName - Attribute name
   DWORD          dwNum - Number of values
   DWORD          *pdwVal - Values
returns
   BOOL - TRUE if found, FALSE if not
*/
BOOL AttribSetArray (PCMMLNode2 pNode, PWSTR pszName, DWORD dwNum, DWORD *pdwVal)
{
   return pNode->AttribSetBinary (pszName, pdwVal, dwNum*sizeof(DWORD));
}


#if 0 // not ued
/*************************************************************************************
CTTSProsody::LexiconSet - Sets the lexicon to use for TTS.

inputs
   PCMLexicon        pLexTTS - Lexicon to use, from TTS. Should have all the phonemes defined.

*/
void CTTSProsody::LexiconSet (PCMLexicon pLexTTS)
{
   m_pLexTTS = pLexTTS;
}


/*************************************************************************************
CTTSProsody::LexiconGet - Gets the lexicon to use for TTS.

*/
PCMLexicon CTTSProsody::LexiconGet (void)
{
   return m_pLexTTS;
}
#endif // 0


/*************************************************************************************
CTTSProsody::Construcor and destructor
*/
CTTSProsody::CTTSProsody (void)
{
   m_lPCSentenceSyllable.Init (sizeof(PCSentenceSyllable));
   m_lPCSentenceSyllableWord.Init (sizeof(PCSentenceSyllable));
   m_pPCSSRandom.Init (sizeof(PCSentenceSyllable));
   m_lPCHashStringWordSyl.Init (sizeof(PCHashString));
   m_pLexInProsody = new CMLexicon;
   // m_pLexTTS = NULL;
   // m_memPhonemePause - Do nothing

   InitializeCriticalSection (&m_csProsody);

   m_fSENTENCEINDEXValid = FALSE;
   m_fSENTENCEINDEXValidWord = FALSE;

   memset (m_aplSENTENCEINDEX, 0, sizeof(m_aplSENTENCEINDEX));
   memset (m_aplSENTENCEINDEXWord, 0, sizeof(m_aplSENTENCEINDEXWord));
   //DWORD i;
   //for (i = 0; i < sizeof(m_alSENTENCEINDEX) / sizeof(m_alSENTENCEINDEX[0][0][0][0]); i++) {
   //   (&m_alSENTENCEINDEX[0][0][0][0])[i].Init (sizeof(SENTENCEINDEX));
   //   (&m_alSENTENCEINDEXWord[0][0][0][0])[i].Init (sizeof(SENTENCEINDEX));
   //}

}

CTTSProsody::~CTTSProsody (void)
{
   DeleteCriticalSection (&m_csProsody);

   // free sentece syllables
   PCSentenceSyllable *ppss = (PCSentenceSyllable*)m_lPCSentenceSyllable.Get(0);
   DWORD i;
   for (i = 0; i < m_lPCSentenceSyllable.Num(); i++)
      if (ppss[i])
         delete ppss[i];
   m_lPCSentenceSyllable.Clear();

   // free sentece syllables
   ppss = (PCSentenceSyllable*)m_lPCSentenceSyllableWord.Get(0);
   for (i = 0; i < m_lPCSentenceSyllableWord.Num(); i++)
      if (ppss[i])
         delete ppss[i];
   m_lPCSentenceSyllableWord.Clear();

   // free hashes
   PCHashString *pphd = (PCHashString*)m_lPCHashStringWordSyl.Get(0);
   for (i = 0; i < m_lPCHashStringWordSyl.Num(); i++)
      if (pphd[i])
         delete pphd[i];


   if (m_pLexInProsody)
      delete m_pLexInProsody;

   // free the lists
   for (i = 0; i < sizeof(m_aplSENTENCEINDEX) / sizeof(m_aplSENTENCEINDEX[0][0][0][0]); i++)
      if ((&m_aplSENTENCEINDEX[0][0][0][0])[i])
         delete (&m_aplSENTENCEINDEX[0][0][0][0])[i];
   for (i = 0; i < sizeof(m_aplSENTENCEINDEXWord) / sizeof(m_aplSENTENCEINDEXWord[0][0][0][0]); i++)
      if ((&m_aplSENTENCEINDEXWord[0][0][0][0])[i])
         delete (&m_aplSENTENCEINDEXWord[0][0][0][0])[i];
   memset (m_aplSENTENCEINDEX, 0, sizeof(m_aplSENTENCEINDEX));
   memset (m_aplSENTENCEINDEXWord, 0, sizeof(m_aplSENTENCEINDEXWord));
}

static PWSTR gpszTTSProsody = L"TTSProsody";
static PWSTR gpszSentenceSyllable = L"SentenceSyllable";
static PWSTR gpszLexicon = L"Lexicon";
static PWSTR gpszPhonemePause = L"PhonemePause";
// static PWSTR gpszTYPICALSYLINFO = L"TYPICALSYLINFO";
static PWSTR gpszPROSODYNGRAMINFO = L"PROSODYNGRAMINFO";
static PWSTR gpszHashDWORDWordSyl = L"HashDWORDWordSyl";

/*************************************************************************************
CTTSProsody::MemoryTouch - Call this to ensure that TTS stays in memory
*/
DWORD CTTSProsody::MemoryTouch (void)
{
   DWORD dwRet = 0;

   if (m_pLexInProsody)
      dwRet += m_pLexInProsody->MemoryTouch();

   DWORD dwIndex;
   if (m_lPCSentenceSyllable.Num()) {
      dwIndex = (DWORD)rand() % m_lPCSentenceSyllable.Num();
      PCSentenceSyllable *ppss = (PCSentenceSyllable*)m_lPCSentenceSyllable.Get(dwIndex);
      if (ppss)
         dwRet += ppss[0]->MemoryTouch();
   }
   if (m_lPCSentenceSyllableWord.Num()) {
      dwIndex = (DWORD)rand() % m_lPCSentenceSyllableWord.Num();
      PCSentenceSyllable *ppss = (PCSentenceSyllable*)m_lPCSentenceSyllableWord.Get(dwIndex);
      if (ppss)
         dwRet += ppss[0]->MemoryTouch();
   }

   DWORD *pdw;
   if (m_memPhonemePause.m_dwCurPosn / sizeof(DWORD)) {
      dwIndex = (DWORD)rand() % (DWORD)(m_memPhonemePause.m_dwCurPosn / sizeof(DWORD));
      pdw = (DWORD*)m_memPhonemePause.p;
      dwRet += pdw[dwIndex];
   }

   if (m_memPauseNGram.m_dwCurPosn / sizeof(DWORD)) {
      dwIndex = (DWORD)rand() % (DWORD)(m_memPauseNGram.m_dwCurPosn / sizeof(DWORD));
      pdw = (DWORD*)m_memPauseNGram.p;
      dwRet += pdw[dwIndex];
   }

   if (m_memPROSODYTRENDS.m_dwCurPosn / sizeof(DWORD)) {
      dwIndex = (DWORD)rand() % (DWORD)(m_memPROSODYTRENDS.m_dwCurPosn / sizeof(DWORD));
      pdw = (DWORD*)m_memPROSODYTRENDS.p;
      dwRet += pdw[dwIndex];
   }

   DWORD dwIndex2 = (DWORD)rand() % TYPICALSYLINFO_NUM;
   if (m_amemTYPICALSYLINFO[dwIndex2].m_dwCurPosn / sizeof(DWORD)) {
      dwIndex = (DWORD)rand() % (DWORD)(m_amemTYPICALSYLINFO[dwIndex2].m_dwCurPosn / sizeof(DWORD));
      pdw = (DWORD*)m_amemTYPICALSYLINFO[dwIndex2].p;
      dwRet += pdw[dwIndex];
   }

   if (m_memPROSODYNGRAMINFO.m_dwCurPosn / sizeof(DWORD)) {
      dwIndex = (DWORD)rand() % (DWORD)(m_memPROSODYNGRAMINFO.m_dwCurPosn / sizeof(DWORD));
      pdw = (DWORD*)m_memPROSODYNGRAMINFO.p;
      dwRet += pdw[dwIndex];
   }

   if (m_lPCHashStringWordSyl.Num()) {
      dwIndex = (DWORD)rand() % m_lPCHashStringWordSyl.Num();
      PCHashString *pphd = (PCHashString*)m_lPCHashStringWordSyl.Get(dwIndex);
      PCHashString phd;
      phd = pphd ? pphd[0] : NULL;
      if (phd) {
         DWORD dwIndex2 = (DWORD)rand() % phd->Num();
         PTTSPWORDSYLHEADER pwsh = (PTTSPWORDSYLHEADER) phd->Get(dwIndex2);
         if (pwsh)
            dwRet += pwsh->dwSyllables;

      }
   }

   dwIndex = (DWORD)rand() % (sizeof(m_aplSENTENCEINDEX) / sizeof(m_aplSENTENCEINDEX[0][0][0][0]));
   if (m_aplSENTENCEINDEX[0][0][0][dwIndex] && m_aplSENTENCEINDEX[0][0][0][dwIndex]->Num()) {
      dwIndex2 = (DWORD)rand() % m_aplSENTENCEINDEX[0][0][0][dwIndex]->Num();

      PSENTENCEINDEX pSI = (PSENTENCEINDEX)m_aplSENTENCEINDEX[0][0][0][dwIndex]->Get(dwIndex2);

      if (pSI)
         dwRet += pSI->iStart;
   }

   dwIndex = (DWORD)rand() % (sizeof(m_aplSENTENCEINDEXWord) / sizeof(m_aplSENTENCEINDEXWord[0][0][0][0]));
   if (m_aplSENTENCEINDEXWord[0][0][0][dwIndex] && m_aplSENTENCEINDEXWord[0][0][0][dwIndex]->Num()) {
      dwIndex2 = (DWORD)rand() % m_aplSENTENCEINDEXWord[0][0][0][dwIndex]->Num();

      PSENTENCEINDEX pSI = (PSENTENCEINDEX)m_aplSENTENCEINDEXWord[0][0][0][dwIndex]->Get(dwIndex2);

      if (pSI)
         dwRet += pSI->iStart;
   }

   return dwRet;
}

/*************************************************************************************
CTTSProsody::MMLTo - Standard API
*/
PCMMLNode2 CTTSProsody::MMLTo (void)
{
   PCMMLNode2 pNode = new CMMLNode2;
   if (!pNode)
      return NULL;
   pNode->NameSet (gpszTTSProsody);

   // convert to sentence syllables
   CMem mem;
   PCSentenceSyllable *ppss = (PCSentenceSyllable*)m_lPCSentenceSyllable.Get(0);
   mem.m_dwCurPosn = 0;
   DWORD i;
   for (i = 0; i < m_lPCSentenceSyllable.Num(); i++)
      ppss[i]->MMLToBinary (&mem);
   MMLValueSet (pNode, gpszSentenceSyllable, (PBYTE)mem.p, mem.m_dwCurPosn);

   // NOTE: DON'T bother saving m_lPCSentenceSyllableWord

   // save the prosody
   if (m_memPhonemePause.m_dwCurPosn)
      MMLValueSet (pNode, gpszPhonemePause, (PBYTE)m_memPhonemePause.p, m_memPhonemePause.m_dwCurPosn);

   // save the default length
   WCHAR szTemp[64];
   for (i = 0; i < TYPICALSYLINFO_NUM; i++) {
      swprintf (szTemp, L"TypicalSylInfo%d", (int)i);
      if (m_amemTYPICALSYLINFO[i].m_dwCurPosn)
         MMLValueSet (pNode, szTemp, (PBYTE)m_amemTYPICALSYLINFO[i].p, m_amemTYPICALSYLINFO[i].m_dwCurPosn);
   } // i

   // save the NGram
   CMem  memRLE;
#ifndef NOMODS_DISABLEPROSODYNGRAM
   if (m_memPROSODYNGRAMINFO.m_dwCurPosn) {
      // convert to RLE
      memRLE.m_dwCurPosn = 0;
      if (RLEEncode ((PBYTE)m_memPROSODYNGRAMINFO.p, m_memPROSODYNGRAMINFO.m_dwCurPosn / sizeof(float), sizeof(float), &memRLE))
         return FALSE;
      size_t dwRLESize = memRLE.m_dwCurPosn;
      if (!dwRLESize)
         return FALSE;

      // write to MML
      MMLValueSet (pNode, gpszPROSODYNGRAMINFO, (PBYTE)memRLE.p, memRLE.m_dwCurPosn);
   }
#endif

   // save the hash
   DWORD j;
   mem.m_dwCurPosn = 0;
   PCHashString *pphd = (PCHashString*)m_lPCHashStringWordSyl.Get(0);
   for (i = 0; i < m_lPCHashStringWordSyl.Num(); i++) {
      PCHashString phd = pphd[i];
      for (j = 0; j < phd->Num(); j++) {
         PTTSPWORDSYLHEADER pwsh = (PTTSPWORDSYLHEADER) phd->Get(j);
         if (!pwsh)
            continue;

         PWSTR pszWord = phd->GetString (j);
         if (!pszWord)
            continue;

         DWORD dwSizeHeader = sizeof(DWORD) + (DWORD)(wcslen(pszWord)+1) * sizeof(WCHAR);
         DWORD dwSize = dwSizeHeader + sizeof(*pwsh) + pwsh->dwSyllables * sizeof(PROSODYTREND);
         if (!mem.Required (mem.m_dwCurPosn + dwSize))
            continue;

         DWORD *pdwSizeInfo = (DWORD*) ((PBYTE)mem.p + mem.m_dwCurPosn);
         *pdwSizeInfo = (DWORD)(wcslen(pszWord)+1) * sizeof(WCHAR);
         memcpy (pdwSizeInfo+1, pszWord, (wcslen(pszWord)+1)*sizeof(WCHAR));

         memcpy ((PBYTE)mem.p + (mem.m_dwCurPosn + dwSizeHeader), pwsh, dwSize - dwSizeHeader);

         mem.m_dwCurPosn += dwSize;
      } // j
   } // i
   MMLValueSet (pNode, gpszHashDWORDWordSyl, (PBYTE)mem.p, mem.m_dwCurPosn);


   // save the lexicon
   PCMMLNode2 pSub = m_pLexInProsody->MMLTo ();
   if (pSub) {
      pSub->NameSet (gpszLexicon);
      pNode->ContentAdd (pSub);
   }

   return pNode;
}


/*************************************************************************************
CTTSProsody::MMLFrom - Standard API
*/
BOOL CTTSProsody::MMLFrom (PCMMLNode2 pNode, PWSTR pszSrcFile)
{
   Clear();

   // get the sentence syllables
   CMem memRLE;
   memRLE.m_dwCurPosn = 0;
   MMLValueGetBinary (pNode, gpszSentenceSyllable, &memRLE);
   if (memRLE.m_dwCurPosn) {
      // found sentences
      PBYTE pbCur = (PBYTE)memRLE.p;
      size_t dwLeft = memRLE.m_dwCurPosn;
      size_t dwUsed;
      while (dwLeft) {
         PCSentenceSyllable pss = new CSentenceSyllable;
         if (!pss)
            break;

         dwUsed = pss->MMLFromBinary (pbCur, dwLeft);
         if (!dwUsed) {
            // error
            delete pss;
            break;
         }
         
         // advance the pointer
         pbCur += dwUsed;
         dwLeft -= dwUsed;

         // add to list
         m_lPCSentenceSyllable.Add (&pss);
      }
   } // if found sentence syllable

   // NOTE: Don't bother getting m_lPCSentenceSyllableWord since automatic

   // get the phoneme pauses
   m_memPhonemePause.m_dwCurPosn = 0;
   m_memPhonemePause.m_dwCurPosn = MMLValueGetBinary (pNode, gpszPhonemePause, &m_memPhonemePause);

   // get the phoneme pauses
   // save the default length
   WCHAR szTemp[64];
   DWORD i;
   for (i = 0; i < TYPICALSYLINFO_NUM; i++) {
      swprintf (szTemp, L"TypicalSylInfo%d", (int)i);
      m_amemTYPICALSYLINFO[i].m_dwCurPosn = 0;
      m_amemTYPICALSYLINFO[i].m_dwCurPosn = MMLValueGetBinary (pNode, szTemp, &m_amemTYPICALSYLINFO[i]);
      if (m_amemTYPICALSYLINFO[i].m_dwCurPosn != SentenceLengthTotal () * sizeof(TYPICALSYLINFO))
         m_amemTYPICALSYLINFO[i].m_dwCurPosn = 0;   // must be the right length
   } // i


   // prosody Ngram
   memRLE.m_dwCurPosn = 0;
#ifndef NOMODS_DISABLEPROSODYNGRAM
   MMLValueGetBinary (pNode, gpszPROSODYNGRAMINFO, &memRLE);
   //psz = MMLValueGet (pNode, gpszNGram);
   if (memRLE.m_dwCurPosn /*psz*/) {
      //if (!memRLE.Required (wcslen(psz)/2))
      //   return FALSE;
      PBYTE pb = (PBYTE)memRLE.p;
      //DWORD dwSize = MMLBinaryFromString (psz, pb, memRLE.m_dwAllocated);
      size_t dwSize = memRLE.m_dwCurPosn;

      // RLE decode
      m_memPROSODYNGRAMINFO.m_dwCurPosn = 0;   // BUGFIX - Was just mem, wrong var
      size_t dwUsed;
      if (RLEDecode ((PBYTE)memRLE.p, dwSize, sizeof(float), &m_memPROSODYNGRAMINFO, &dwUsed))
         return FALSE;
      dwSize = m_memPROSODYNGRAMINFO.m_dwCurPosn;
      if (!dwSize)
         return FALSE;

      // make sure size is correct
      DWORD dwExpect = ProsodyNGramInfoCount() * sizeof(PROSODYNGRAMINFO);
      if (dwExpect != m_memPROSODYNGRAMINFO.m_dwCurPosn)
         m_memPROSODYNGRAMINFO.m_dwCurPosn = 0;   // invalid
   }
#endif // 0

   // get the hash syllable info
   MMLValueGetBinary (pNode, gpszHashDWORDWordSyl, &memRLE);
   if (memRLE.m_dwCurPosn) {
      PBYTE pb = (PBYTE)memRLE.p;
      size_t dwSize = memRLE.m_dwCurPosn;

      while (dwSize >= sizeof(DWORD)) {
         // get the number of bytes for the string
         DWORD dwSizeString = *((DWORD*)pb);
         pb += sizeof(DWORD);
         dwSize -= sizeof(DWORD);

         // get the string
         if (dwSize < dwSizeString)
            continue;
         PWSTR pszWord = (PWSTR)pb;
         pb += dwSizeString;
         dwSize -= dwSizeString;

         // get the data
         if (dwSize < sizeof(TTSPWORDSYLHEADER))
            continue;
         PTTSPWORDSYLHEADER pwsh = (PTTSPWORDSYLHEADER) pb;
         DWORD dwNeeded = sizeof(*pwsh) + pwsh->dwSyllables * sizeof(PROSODYTREND);
         if (dwSize < dwNeeded)
            break;   // error, shouldnt happen

         
         PTTSPWORDSYLHEADER pwshNew = WordSylGetInternal (pszWord, pwsh->dwSyllables, pwsh->dwStressBitsMulti, TRUE);
         if (!pwshNew)
            break;   // error

         memcpy (pwshNew, pwsh, dwNeeded);

         pb += dwNeeded;
         dwSize -= dwNeeded;
      } // dwSize
   }

   // get the lexicon
   PCMMLNode2 pSub;
   PWSTR psz;
   pSub = NULL;
   pNode->ContentEnum (pNode->ContentFind (gpszLexicon), &psz, &pSub);
   if (pSub)
      m_pLexInProsody->MMLFrom (pSub, pszSrcFile, FALSE);

   return TRUE;
}



/*************************************************************************************
CTTSProsody::CloneTo - Standard API
*/
BOOL CTTSProsody::CloneTo (CTTSProsody *pTo)
{
   // NOTE: Clone to not tested
   pTo->Clear();

   DWORD i;
   pTo->m_lPCSentenceSyllable.Init (sizeof(PCSentenceSyllable), m_lPCSentenceSyllable.Get(0), m_lPCSentenceSyllable.Num());
   PCSentenceSyllable* ppss = (PCSentenceSyllable*)pTo->m_lPCSentenceSyllable.Get(0);  // BUGFIX - Didn't have pTo->
   for (i = 0; i < pTo->m_lPCSentenceSyllable.Num(); i++)
      if (ppss[i])
         ppss[i] = ppss[i]->Clone();

   // NOTE: Don't bother copying m_lPCSentenceSyllableWord since automatic

   // clone the hashes
   // NOTE: Hashes clone not tested
   pTo->m_lPCHashStringWordSyl.Init (sizeof(PCHashString), m_lPCHashStringWordSyl.Get(0), m_lPCHashStringWordSyl.Num());
   PCHashString *pphd = (PCHashString*)pTo->m_lPCHashStringWordSyl.Get(0);
   for (i = 0; i < pTo->m_lPCHashStringWordSyl.Num(); i++)
      if (pphd[i])
         pphd[i] = pphd[i]->Clone();

   if (!pTo->m_memPhonemePause.Required(m_memPhonemePause.m_dwCurPosn))
      return FALSE;
   memcpy (pTo->m_memPhonemePause.p, m_memPhonemePause.p, m_memPhonemePause.m_dwCurPosn);
   pTo->m_memPhonemePause.m_dwCurPosn = m_memPhonemePause.m_dwCurPosn;

   for (i = 0; i < TYPICALSYLINFO_NUM; i++) {
      if (!pTo->m_amemTYPICALSYLINFO[i].Required(m_amemTYPICALSYLINFO[i].m_dwCurPosn))
         return FALSE;
      memcpy (pTo->m_amemTYPICALSYLINFO[i].p, m_amemTYPICALSYLINFO[i].p, m_amemTYPICALSYLINFO[i].m_dwCurPosn);
      pTo->m_amemTYPICALSYLINFO[i].m_dwCurPosn = m_amemTYPICALSYLINFO[i].m_dwCurPosn;
   }

   // ngram
   if (!pTo->m_memPROSODYNGRAMINFO.Required(m_memPROSODYNGRAMINFO.m_dwCurPosn))
      return FALSE;
   memcpy (pTo->m_memPROSODYNGRAMINFO.p, m_memPROSODYNGRAMINFO.p, m_memPROSODYNGRAMINFO.m_dwCurPosn);
   pTo->m_memPROSODYNGRAMINFO.m_dwCurPosn = m_memPROSODYNGRAMINFO.m_dwCurPosn;

   PCMLexicon pLex = m_pLexInProsody->Clone ();
   if (pLex) {
      delete pTo->m_pLexInProsody;
      pTo->m_pLexInProsody = pLex;
   }

   return TRUE;
}


/*************************************************************************************
CTTSProsody::Clone - Standard API
*/
CTTSProsody *CTTSProsody::Clone (void)
{
   // NOTE: Clone not tested
   PCTTSProsody pp = new CTTSProsody ();
   if (!pp)
      return NULL;

   // pp->LexiconSet (m_pLexTTS);

   if (!CloneTo(pp)) {
      delete pp;
      return NULL;
   }

   return pp;
}


/*************************************************************************************
CTTSProsody::Clear - Standard API
*/
void CTTSProsody::Clear (void)
{
   // free sentece syllables
   PCSentenceSyllable *ppss = (PCSentenceSyllable*)m_lPCSentenceSyllable.Get(0);
   DWORD i;
   for (i = 0; i < m_lPCSentenceSyllable.Num(); i++)
      if (ppss[i])
         delete ppss[i];
   m_lPCSentenceSyllable.Clear();

   ppss = (PCSentenceSyllable*)m_lPCSentenceSyllableWord.Get(0);
   for (i = 0; i < m_lPCSentenceSyllableWord.Num(); i++)
      if (ppss[i])
         delete ppss[i];
   m_lPCSentenceSyllableWord.Clear();

   // free hashes
   PCHashString *pphd = (PCHashString*)m_lPCHashStringWordSyl.Get(0);
   for (i = 0; i < m_lPCHashStringWordSyl.Num(); i++)
      if (pphd[i])
         delete pphd[i];
   m_lPCHashStringWordSyl.Clear();

   m_memPhonemePause.m_dwCurPosn = 0;
   for (i = 0; i < TYPICALSYLINFO_NUM; i++)
      m_amemTYPICALSYLINFO[i].m_dwCurPosn = 0;
   m_memPROSODYNGRAMINFO.m_dwCurPosn = 0;

   m_memPauseNGram.m_dwCurPosn = 0;
   m_memPROSODYTRENDS.m_dwCurPosn = 0;

   m_pPCSSRandom.Clear();  // since only pointers

   m_fSENTENCEINDEXValid = FALSE;
   m_fSENTENCEINDEXValidWord = FALSE;
   // free the lists
   for (i = 0; i < sizeof(m_aplSENTENCEINDEX) / sizeof(m_aplSENTENCEINDEX[0][0][0][0]); i++)
      if ((&m_aplSENTENCEINDEX[0][0][0][0])[i])
         delete (&m_aplSENTENCEINDEX[0][0][0][0])[i];
   for (i = 0; i < sizeof(m_aplSENTENCEINDEXWord) / sizeof(m_aplSENTENCEINDEXWord[0][0][0][0]); i++)
      if ((&m_aplSENTENCEINDEXWord[0][0][0][0])[i])
         delete (&m_aplSENTENCEINDEXWord[0][0][0][0])[i];
   memset (m_aplSENTENCEINDEX, 0, sizeof(m_aplSENTENCEINDEX));
   memset (m_aplSENTENCEINDEXWord, 0, sizeof(m_aplSENTENCEINDEXWord));

   PCMLexicon pLex = new CMLexicon;
   if (m_pLexInProsody) {
      delete m_pLexInProsody;
      m_pLexInProsody = pLex;
   }
}


/*************************************************************************************
CTTSProsody::CreateWordSentencesIfNeccssary - Makes sure that word-based versions
of all the syllable sentences are created.

inputs
   none
returns
   none
*/
void CTTSProsody::CreateWordSentencesIfNeccssary (void)
{
   // if smae number of syllables then assume no need to change
   if (m_lPCSentenceSyllable.Num() == m_lPCSentenceSyllableWord.Num())
      return;

   // free up existing list
   DWORD i;
   PCSentenceSyllable *ppss = (PCSentenceSyllable*)m_lPCSentenceSyllableWord.Get(0);
   ppss = (PCSentenceSyllable*)m_lPCSentenceSyllableWord.Get(0);
   for (i = 0; i < m_lPCSentenceSyllableWord.Num(); i++)
      if (ppss[i])
         delete ppss[i];
   m_lPCSentenceSyllableWord.Clear();

   // intialize to existing sullables
   m_lPCSentenceSyllableWord.Init (sizeof(PCSentenceSyllable), m_lPCSentenceSyllable.Get(0), m_lPCSentenceSyllable.Num());

   // create word versions
   ppss = (PCSentenceSyllable*)m_lPCSentenceSyllableWord.Get(0);
   for (i = 0; i < m_lPCSentenceSyllableWord.Num(); i++)
      ppss[i] = ppss[i]->ToWords();

}


/*************************************************************************************
CTTSProsody::CreateIndexIfNecessary - This creates the index of part-of-speech and stress
to sentences, if necessary.

inputs
   PCMLexicon     pLexTTS - Lexicon with phonemes in it
   BOOL           fWord - if TRUE then making sure the word-based sentences are used.
                     If FALSE, then syllable-based sentences
returns
   none
*/
void CTTSProsody::CreateIndexIfNecessary (PCMLexicon pLexTTS, BOOL fWord)
{
   if (fWord)
      CreateWordSentencesIfNeccssary ();

   BOOL *pfCheck = fWord ? &m_fSENTENCEINDEXValidWord : &m_fSENTENCEINDEXValid;
   PCListFixed plSent = fWord ? &m_lPCSentenceSyllableWord : &m_lPCSentenceSyllable;

   if (*pfCheck)
      return;

   // loop through all the sentences
   PCSentenceSyllable *ppss = (PCSentenceSyllable*)plSent->Get(0);
   DWORD i;
   for (i = 0; i < plSent->Num(); i++)
      if (ppss[i]) {
         PCListFixed *ppl = fWord ? &m_aplSENTENCEINDEXWord[0][0][0][0] : &m_aplSENTENCEINDEX[0][0][0][0];
         ppss[i]->AddToIndex (pLexTTS, ppl);
      }

   *pfCheck = TRUE;
}


/*************************************************************************************
CTTSProsody::FindAllMatches - Find all matches to the current sentence.

inputs
   PCMLexicon     pLexTTS - Lexicon with phonemes in it
   PCSentenceSyllable   pSS - Sentence
   int                  iStart - Starting point (from start of sentece) for the match. Must be < m_dwNum
   int                  iEnd - Ending point for the match. Must be > 0. iEnd - Start >= 2
   BOOL                 fMustMatchPhrase - If TRUE, then the match must be either the entire sentence, or an
                           exact phrase match.
   BOOL                 fWord - If TRUE matching against the word-based residitual. IF FALSE, the syllable-based ones.
   CTTSProsody          **ppCTTSProsody - This of prosody objects to use for the comparison,
                        including this one.
   DWORD                dwNum - Number of prosody objects to use. Must be at least one
   PCListFixed          plSENTENCEMATCH - Has appropriate SENTENCEMATCH structures appended
                        to it.
returns
   BOOL - TRUE if succes.
*/
BOOL CTTSProsody::FindAllMatches (PCMLexicon pLexTTS, PCSentenceSyllable pSS, int iStart, int iEnd, BOOL fMustMatchPhrase, BOOL fWord,
                                  CTTSProsody **ppCTTSProsody, DWORD dwNum, PCListFixed plSENTENCEMATCH)
{
   if (iStart >= (int)pSS->m_dwNum)
      return FALSE;
   if (iEnd <= 0)
      return FALSE;
   int iNum = iEnd - iStart;
   if (iNum < 2)
      return FALSE;

   // loop through all real starts looking for the combination of two units
   // with the LEAST number of matches, so that will speed up
   int iBestStart = -1000;
   DWORD dwBestStartScore = 0;
   DWORD adwBestPOS[2];
   DWORD adwBestStress[2];
   DWORD adwPOS[2];
   DWORD adwStress[2];
   DWORD dwOffset;
   DWORD i;
   DWORD dwPros;
   PCTTSProsody pTTSP;
   PCListFixed plSI, *pplSI;
   int iCur, iRealStart;
   for (iRealStart = iStart; iRealStart < iEnd - 1; iRealStart++) {
      // if iRealStart+1 < 0 then will just be two punctuations, so no match
      if (iRealStart + 1 < 0)
         continue;

      // if iRealStart >= m_dwNum, then will be two punctiaons, so no match
      if (iRealStart >= (int)pSS->m_dwNum)
         continue;

      for (dwOffset = 0; dwOffset < 2; dwOffset++) {
         iCur = iRealStart + (int)dwOffset;

         if ((iCur < 0) || (iCur >= (int)pSS->m_dwNum)) {
            // out of range
            adwPOS[dwOffset] = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
            adwStress[dwOffset] = 0;
         }
         else {
            adwPOS[dwOffset] = pSS->m_pabPOSStress[iCur] & 0x0f;
            adwStress[dwOffset] = (pSS->m_pabPOSStress[iCur] >> 4) & 0x0f;
         }
      } // dwOffset

      // loop through all the prosody models and sum up the number
      DWORD dwNumFind = 0;
      for (dwPros = 0; dwPros < dwNum; dwPros++) {
         pTTSP = ppCTTSProsody[dwPros];
         if (!pTTSP)
            continue;

         pTTSP->CreateIndexIfNecessary (pLexTTS, fWord);

         if (fWord)
            pplSI = &pTTSP->m_aplSENTENCEINDEXWord[adwPOS[0]][adwStress[0]][adwPOS[1]][adwStress[1]];
         else
            pplSI = &pTTSP->m_aplSENTENCEINDEX[adwPOS[0]][adwStress[0]][adwPOS[1]][adwStress[1]];
         plSI = *pplSI;
         
         dwNumFind += (plSI ? plSI->Num() : 0);
      } // dwPros

      // if find FEWER then keep that
      if ((iBestStart <= -1000) || (dwNumFind < dwBestStartScore)) {
         iBestStart = iRealStart;
         dwBestStartScore = dwNumFind;
         memcpy (adwBestPOS, adwPOS, sizeof(adwPOS));
         memcpy (adwBestStress, adwStress, sizeof(adwStress));
      }
   } // iRealStart
   if (iBestStart <= -1000)
      return FALSE;  // error

   // real start, so have something in the sentence to match
   iRealStart = iBestStart;
   int iRealStartDelta = iRealStart - iStart;
   memcpy (adwPOS, adwBestPOS, sizeof(adwPOS));
   memcpy (adwStress, adwBestStress, sizeof(adwStress));

   // search for these
   SENTENCEMATCH SM;
   DWORD j;
   memset (&SM, 0, sizeof(SM));
   for (dwPros = 0; dwPros < dwNum; dwPros++) {
      pTTSP = ppCTTSProsody[dwPros];
      if (!pTTSP)
         continue;

      // dont need to call here because already called: pTTSP->CreateIndexIfNecessary ();

      if (fWord)
         pplSI = &pTTSP->m_aplSENTENCEINDEXWord[adwPOS[0]][adwStress[0]][adwPOS[1]][adwStress[1]];
      else
         pplSI = &pTTSP->m_aplSENTENCEINDEX[adwPOS[0]][adwStress[0]][adwPOS[1]][adwStress[1]];
      plSI = *pplSI;

      plSENTENCEMATCH->Required (plSENTENCEMATCH->Num() + (plSI ? plSI->Num() : 0) );

      PSENTENCEINDEX pSI = plSI ? (PSENTENCEINDEX)plSI->Get(0) : NULL;
      if (plSI) for (i = 0; i < plSI->Num(); i++, pSI++) {
         int iCompareTo = pSI->iStart - iRealStartDelta;
         if (!pSS->CompareSequenceQuick (iStart, pSI->pSS, iCompareTo, (DWORD)iNum))
            continue;   // no match

         // if must match prhase then do some checks
         if (fMustMatchPhrase) {
            // if this matches an entire sentence then ok
            if (!iCompareTo && (iNum == (DWORD)pSI->pSS->m_dwNum))
               goto matched;

            // else, look through the phrases in the sentence for a match
            PSENTSYLPHRASE pSSP = (PSENTSYLPHRASE) pSI->pSS->m_lSENTSYLPHRASE.Get(0);
            for (j = 0; j < pSI->pSS->m_lSENTSYLPHRASE.Num(); j++, pSSP++)
               if ( ((int)pSSP->wStart == iCompareTo) && ((int)pSSP->wEnd == (iCompareTo + iNum)) )
                  break;
            if (j < pSI->pSS->m_lSENTSYLPHRASE.Num())
               goto matched;   // found a match

            // else no match
            continue;
         }

matched:
         // else, match
         SM.iStart = iCompareTo;
         SM.dwNum = iNum;
         SM.pSS = pSI->pSS;
         SM.pTTSProsody = pTTSP;
         plSENTENCEMATCH->Add (&SM);
      } // i
   } // dwPros

   return TRUE;
}



/*************************************************************************************
CTTSProsody::MaxJoinDistance - Returns the maximum join distance possible
given the TTS Quality.

inputs
   int               iTTSQuality - Typical TTS quality setting. Used to determine maximum
                        number of matches
                        0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
returns
   DWORD - Max number of joins.
*/
DWORD CTTSProsody::MaxJoinDistance (int iTTSQuality)
{
   iTTSQuality = max(iTTSQuality, 0);
   iTTSQuality = min(iTTSQuality, 3);
   return 1 + (DWORD)iTTSQuality;
}



/*************************************************************************************
CTTSProsody::MaxMinMatches - Calculate the maximum and minimum number of matches
given TTS quality

inputs
   int               iTTSQuality - Typical TTS quality setting. Used to determine maximum
                        number of matches
                        0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   DWORD          *pdwMax - Filled with the maximum number of matches. Can be NULL
   DWORD          *pdwMin - Filled with the minimum number of matches. Can be NULL;
returns
   none
*/
void CTTSProsody::MaxMinMatches (int iTTSQuality, DWORD *pdwMax, DWORD *pdwMin)
{
   DWORD dwMin = MINPROSODYSAMPLES;
   if (iTTSQuality >= 2)
      dwMin *= 2; // more minimums required for higher quality
#ifdef _DEBUG
   // dwMin = 1; // to test
#endif

   // truncate so not too many units
   iTTSQuality = max(iTTSQuality, 0);
   iTTSQuality = min(iTTSQuality, 3);
   DWORD dwMax = MINPROSODYSAMPLES * (DWORD)(iTTSQuality+2);

   if (pdwMax)
      *pdwMax = dwMax;
   if (pdwMin)
      *pdwMin = dwMin;
}


/*************************************************************************************
CTTSProsody::ScoreMatches - Takes a list of matches from FindAllMatches() and does the
following:

- If there aren't any matches then returns FALSE
- If there aren't enough matches (and fIgnoreNotEnough == FALSE) then returns
- The list is shuffled
- If there are too many matches then the list is truncated
- All matches are compared against one another, genrating a 2x2 matrix of comparisons.
- For each match, the scores are sorted, and the top 25% (?) weighted are used
   for the final scored, stored back in the SENTENCEMATCH structure. This
   indicates how "typical" then sequence is.

NOTE: This code WON'T work as well with real-time mixed prosody models because it's
not remapping all the word numbers together. To do so would be too slow.

inputs
   PCOMPARESYLINFO pInfo - Score penalties to use.
   PCListFixed       plSENTENCEMATCH - List of matches. Modified in place. The number
                     of matches is halved to reduce calculation. The best scorind ones
                     are kept.
   int               iTTSQuality - Typical TTS quality setting. Used to determine maximum
                        number of matches
                        0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   WORD              wPeriod - What word number to use for a period.
   BOOL              fIgnoreNotEnough - If TRUE, then even if there aren't enough matches
                        then go ahead and do processing.
   BOOL              fIgnoreProsody - Set to TRUE if duration, energy, F0 are unknown in at least one of the setneces
   BOOL                 fWord - If TRUE matching against the word-based residitual. IF FALSE, the syllable-based ones.
   BOOL              fTriangle - If TRUE then compare using a triangle window. FALSE then
                        compare using a square window.
   PCSentenceSyllable pSSCompare - If not NULL, then do a non-prosodic compare against this
                     sentence to determine how close the sentence matches are to the target.
                     Include this in the score
   int               iStartCompare - Where comparing to against the start, in syllables. Only used if pSSCompare
returns
   BOOL - TRUE if succes. FALSE if there aren't enough matches
*/

// SSMATCHSORT - Structure used to sort the matches
typedef struct {
   fp             fScore;     // score
   DWORD          dwOrig;     // original index
} SSMATCHSORT, *PSSMATCHSORT;

static int _cdecl SSMATCHSORTSortScore (const void *elem1, const void *elem2)
{
   SSMATCHSORT *pdw1, *pdw2;
   pdw1 = (SSMATCHSORT*) elem1;
   pdw2 = (SSMATCHSORT*) elem2;

   if (pdw1->fScore > pdw2->fScore)
      return 1;
   else if (pdw1->fScore < pdw2->fScore)
      return -1;
   else
      return 0;
}



static int _cdecl SENTENCEMATCHSortScore (const void *elem1, const void *elem2)
{
   SENTENCEMATCH *pdw1, *pdw2;
   pdw1 = (SENTENCEMATCH*) elem1;
   pdw2 = (SENTENCEMATCH*) elem2;

   if (pdw1->fScore > pdw2->fScore)
      return 1;
   else if (pdw1->fScore < pdw2->fScore)
      return -1;
   else
      return 0;
}



BOOL CTTSProsody::ScoreMatches (PCOMPARESYLINFO pInfo, PCListFixed plSENTENCEMATCH, int iTTSQuality, WORD wPeriod,
                                BOOL fIgnoreNotEnough, BOOL fIgnoreProsody, BOOL fWord, BOOL fTriangle,
                                PCSentenceSyllable pSSCompare, int iStartCompare)
{
   // if 0 matches then always FALSE
   if (!plSENTENCEMATCH->Num())
      return FALSE;

   DWORD dwMin, dwMax;
   MaxMinMatches (iTTSQuality, &dwMax, &dwMin);
   if (!fIgnoreNotEnough && (plSENTENCEMATCH->Num() < dwMin))
      return FALSE;

   // randomize this list
   PSENTENCEMATCH pSI = (PSENTENCEMATCH) plSENTENCEMATCH->Get(0);
   SENTENCEMATCH SITemp;
   DWORD i, j;
   for (i = 0; i < plSENTENCEMATCH->Num(); i++) {
      j = (DWORD)rand() % plSENTENCEMATCH->Num();

      // shuffle
      SITemp = pSI[i];
      pSI[i] = pSI[j];
      pSI[j] = SITemp;
   } // i

   // truncate so not too many units
   dwMax = min(dwMax, plSENTENCEMATCH->Num());
   if (dwMax < plSENTENCEMATCH->Num())
      plSENTENCEMATCH->Truncate (dwMax);
   pSI = (PSENTENCEMATCH) plSENTENCEMATCH->Get(0);

   // allocate memory for the comparisons
   DWORD dwNum = plSENTENCEMATCH->Num();
   CMem memScores;
   if (!memScores.Required (dwNum * dwNum * sizeof(SSMATCHSORT)))
      return FALSE;  // error
   PSSMATCHSORT paSSMATCHSORT = (PSSMATCHSORT)memScores.p;

   // make the window
   CMem memWindow;
   fp *pafWindow = pSI[0].pSS->CompareWindowGenerate (0, (int)pSI[0].dwNum, fTriangle, &memWindow);
   if (!pafWindow)
      return FALSE;  // error

   // loop over all combinations and generate the scores
   fp fScore;
   for (i = 0; i < dwNum; i++) {
      for (j = 0; j <= i; j++) {
         // if same unit, trivial match
         if (i == j) {
            paSSMATCHSORT[i * dwNum + j].fScore = 0.0;
            continue;
         }

         // else, compare
         fScore = pSI[i].pSS->CompareSequenceWindowed (pInfo, pSI[i].iStart, pSI[j].pSS, pSI[j].iStart, pSI[i].dwNum,
            wPeriod, fIgnoreProsody, fWord, pafWindow);

         // store this away
         paSSMATCHSORT[i * dwNum + j].fScore = fScore;
         paSSMATCHSORT[j * dwNum + i].fScore = fScore;
      } // j
   } // i

   // how many in the top
   DWORD dwTop = (dwNum + 3) / 4;   // take the top 25%
   dwTop = max(dwTop, 2);  // at least 2
   dwTop = min(dwTop, dwNum); // but no more than all of them

   // loop over all the scores: sort and weighted average the top
   for (i = 0; i < dwNum; i++) {
      // fill in the original ID
      for (j = 0; j < dwNum; j++)
         paSSMATCHSORT[i*dwNum + j].dwOrig = j;

      qsort (paSSMATCHSORT + (i * dwNum), dwNum, sizeof(SSMATCHSORT), SSMATCHSORTSortScore);

      // loop over the top elements and average their scores together
      fp fSum = 0.0;
      fp fWeightSum = 0.0;
      for (j = 0; j < dwTop; j++) {
         fp fWeight = dwTop - j + 1;
         fSum += paSSMATCHSORT[i*dwNum + j].fScore * fWeight;
         fWeightSum += fWeight;
      }

      // store weighted version away
      pSI[i].fScore = fSum / fWeightSum;

      // include comparison against target?
      if (pSSCompare) {
         pSI[i].fScore += pSSCompare->CompareSequenceWindowed (pInfo, iStartCompare,
            pSI[i].pSS, pSI[i].iStart, pSI[i].dwNum,
            wPeriod, TRUE, fWord, pafWindow);
               // NOTE: Always ignoring prosody in this case
      }

      // remember the second best
      if (dwNum >= 2) {
         // take the best one which isn't this
         DWORD dwRunnerUpIndex;
         if (paSSMATCHSORT[i*dwNum+0].dwOrig == i)
            dwRunnerUpIndex = paSSMATCHSORT[i*dwNum+1].dwOrig;
         else
            dwRunnerUpIndex = paSSMATCHSORT[i*dwNum+0].dwOrig;
         pSI[i].pSSRunnerUp = pSI[dwRunnerUpIndex].pSS;
         pSI[i].iStartRunnerUp = pSI[dwRunnerUpIndex].iStart;
      }
      else {
         pSI[i].pSSRunnerUp = NULL;
         pSI[i].iStartRunnerUp = 0;
      }
   } // i

   // sort all the score matches so the lower scores at top
   qsort (pSI, dwNum, sizeof(*pSI), SENTENCEMATCHSortScore);

   // halve this
   dwNum = (dwNum+1) / 2;
   plSENTENCEMATCH->Truncate (dwNum);
   
   // done
   return TRUE;
}


/*************************************************************************************
CTTSProsody::SubdivideAddAsSingle - Add as single trianglular-shaped sentence matches.

inputs
   PCSentenceSyllable         pSS - Sentence whose prosody is to be generated.
   DWORD                dwStartSyl - Starting syllable to process
   DWORD                dwEndSyl - End syllable (exclusive) to process
   DWORD                dwWindow - Size of the triangluar window, based on iTTSQuality
   PCListFixed          plPCSentenceMatch - List to which new PCSentenceMatch structures
                        are appended with appropriate search info.
returns
   none
*/
void CTTSProsody::SubdivideAddAsSingle (PCSentenceSyllable pSS, DWORD dwStartSyl, DWORD dwEndSyl,
                                        DWORD dwWindow, PCListFixed plPCSentenceMatch)
{
   DWORD i;
   PCSentenceMatch pSM;
   for (i = dwStartSyl; i < dwEndSyl; i++) {
      pSM = new CSentenceMatch;
      if (!pSM)
         return;  // error
      
      // fill in
      pSM->m_fIgnoreNotEnough = FALSE;
      pSM->m_fIgnoreProsody = FALSE;
      pSM->m_fTriangle = TRUE;
      pSM->m_iStartUse = (int)i;
      pSM->m_iEndUse = (int)pSM->m_iStartUse + 1;
      pSM->m_iEnd = pSM->m_iEndUse + (int)dwWindow;
      pSM->m_iStart = pSM->m_iStartUse - (int)dwWindow;
      pSM->m_fCompareAgainstTarget = TRUE;   // compare this against the target
      if (dwWindow <= 1)
         pSM->m_fIgnoreNotEnough = TRUE;  // down to the last dregs

      // add this to list
      plPCSentenceMatch->Add (&pSM);
   } // i
}


/*************************************************************************************
CTTSProsody::SubdivideSentenceByPhrases - This recusrively subdivides sentences
by phrases, and adds the phrases (and non-phrase bits) into plPCSentenceMatch.

inputs
   PCSentenceSyllable         pSS - Sentence whose prosody is to be generated.
   DWORD                dwStartSyl - Starting syllable to process
   DWORD                dwEndSyl - End syllable (exclusive) to process
   DWORD                dwWindow - Size of the triangluar window, based on iTTSQuality
   BOOL                 fCanIncludeAll - If TRUE, can include this entire range as a phrase.
   PCListFixed          plPCSentenceMatch - List to which new PCSentenceMatch structures
                        are appended with appropriate search info.
returns
   none
*/
void CTTSProsody::SubdivideSentenceByPhrases (PCSentenceSyllable pSS, DWORD dwStartSyl, DWORD dwEndSyl, DWORD dwWindow,
                                              BOOL fCanIncludeAll, PCListFixed plPCSentenceMatch)
{
   if (dwEndSyl <= dwStartSyl)
      return;  // too small

   // if this is the entire sentence, and we're allowed to include all, then do so
   PCSentenceMatch pSM;
   PSENTSYLPHRASE pSSPBest = NULL;
   SENTSYLPHRASE SSPHack;
   if (!dwStartSyl && (dwEndSyl == pSS->m_dwNum) && fCanIncludeAll) {
      SSPHack.wStart = (WORD)dwStartSyl;
      SSPHack.wEnd = (WORD)dwEndSyl;
      pSSPBest = &SSPHack;
      goto addphrasetolist;
   }

   // otherwise, loop through and find the largest parse phrase in the sentence
   // that also fits in the dwStartSyl to dwEndSyl range
   DWORD i;
   PSENTSYLPHRASE pSSP = (PSENTSYLPHRASE)pSS->m_lSENTSYLPHRASE.Get(0);
   DWORD dwBestLength = 0;
   for (i = 0; i < pSS->m_lSENTSYLPHRASE.Num(); i++, pSSP++) {
      // make sure it's in range
      if ((DWORD)pSSP->wEnd > dwEndSyl)
         continue;   // out of range
      if ((DWORD)pSSP->wStart < dwStartSyl)
         continue;
      if (pSSP->wEnd <= pSSP->wStart)
         continue;   // shouldnt happen, but just in case

      // if not allowed to take an exact match, and this is one, then skip
      if (!fCanIncludeAll && ((DWORD)pSSP->wStart == dwStartSyl) && ((DWORD)pSSP->wEnd == dwEndSyl))
         continue;

      // is this the longest
      DWORD dwLength = pSSP->wEnd - pSSP->wStart;
      if (!pSSPBest || (dwLength > dwBestLength)) {
         pSSPBest = pSSP;
         dwBestLength = dwLength;
      }
   } // i

   // if there aren't any matches, then add all
   if (!pSSPBest) {
      SubdivideAddAsSingle (pSS, dwStartSyl, dwEndSyl, dwWindow, plPCSentenceMatch);
      return;
   }
   
addphrasetolist:
   // else, found at least one matching phrase, add that
   pSM = new CSentenceMatch;
   if (!pSM)
      return;  // error
   
   // fill in
   pSM->m_fIgnoreNotEnough = FALSE;
   pSM->m_fIgnoreProsody = FALSE;
   pSM->m_fTriangle = FALSE;
   pSM->m_iStartUse = (int)pSSPBest->wStart;
   pSM->m_iEndUse = (int)pSSPBest->wEnd;
   pSM->m_iEnd = pSM->m_iEndUse;
   pSM->m_iStart = pSM->m_iStartUse;
   pSM->m_fCompareAgainstTarget = TRUE;   // compare this against the target

   // add this to list
   plPCSentenceMatch->Add (&pSM);

   // recurse, and add any bits to the left or right
   SubdivideSentenceByPhrases (pSS, dwStartSyl, pSSPBest->wStart, dwWindow, TRUE, plPCSentenceMatch);
   SubdivideSentenceByPhrases (pSS, pSSPBest->wEnd, dwEndSyl, dwWindow, TRUE, plPCSentenceMatch);

   // done
}


/*************************************************************************************
CTTSProsody::GenerateMatches - This takes a PCSentenceSyllable with the sentence
to synthesize. It then fills in two lists. The first is a list of PCSentenceMatch
covering the sentence from start to end, indicating what sequences from the prosody
model could be used to synthesize the prosody. The second is a list of PCSentenceMatch
that indicates reasonable joins between units.

NOTE: This doesn't do word # translation if there is more than one prosody model.
This means that muliple run-time prosodies won't work as well because of possible
word mismatches. However, doing the remapping would be too slow.

inputs
   PCMLexicon        pLexTTS - TTS With phonemes in it
   PCOMPARESYLINFO pInfo - Score penalties to use.
   PCSentenceSyllable         pSS - Sentence whose prosody is to be generated.
   int               iTTSQuality - Typical TTS quality setting. Used to determine maximum
                        number of matches
                        0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL           fWord - if TRUE then making sure the word-based sentences are used.
                     If FALSE, then syllable-based sentences
   CTTSProsody          **ppCTTSProsody - This of prosody objects to use for the comparison,
                        including this one.
   DWORD                dwNum - Number of prosody objects to use. Must be at least one
   DWORD                dwMultiPass - Pass number when generating several different versions of the
                        same sentence, and selecting the best one for TTS. Used to make the
                        random work better.
   PCListFixed          plResynth - Initialized to sizeof(PCSentenceMatch), and filled in
                        with list of matches covering entire sentence. (Some matches may NOT
                        have any matches in their list though.) This needs to be freed by the caller.
   PCListFixed          plJoin - List of PCSentenceMatch used to join plResynth[i-1] with plResythn[i].
                        There will be one more plJoin->Num() than plResynth()->Num() because of this.
                        Elements must be freed by the caller.
returns
   BOOL - TRUE if success
*/


static int _cdecl PCSentenceMatchSortScore (const void *elem1, const void *elem2)
{
   PCSentenceMatch pdw1, pdw2;
   pdw1 = *((PCSentenceMatch*) elem1);
   pdw2 = *((PCSentenceMatch*) elem2);

   return pdw1->m_iStartUse - pdw2->m_iStartUse;
}


BOOL CTTSProsody::GenerateMatches (PCMLexicon pLexTTS, PCOMPARESYLINFO pInfo, PCSentenceSyllable pSS, int iTTSQuality, BOOL fWord,
                                   CTTSProsody **ppCTTSProsody, DWORD dwNum, DWORD dwMultiPass, PCListFixed plResynth, PCListFixed plJoin)
{
   plResynth->Init (sizeof(PCSentenceMatch));
   plResynth->Required (pSS->m_dwNum);
   plJoin->Init (sizeof(PCSentenceMatch));
   plJoin->Required (pSS->m_dwNum+1);

   // default L/R match depends on quality
   DWORD dwWindow = MaxJoinDistance (iTTSQuality);

   // loop through all the language models making sure they've calculated all the indecies
   // before go multithreaded
   DWORD i;
   for (i = 0; i < dwNum; i++) {
      if (fWord)  // if doing word matching, make sure produced
         ppCTTSProsody[i]->CreateWordSentencesIfNeccssary ();
      ppCTTSProsody[i]->CreateIndexIfNecessary (pLexTTS, fWord);
   }

   // create all the sentence match, one per
   PCSentenceMatch pSM;
   CListFixed lTemp, lBad;
   lTemp.Init (sizeof(PCSentenceMatch));
   lBad.Init (sizeof(PCSentenceMatch));
   SubdivideSentenceByPhrases (pSS, 0, pSS->m_dwNum, dwWindow, TRUE, &lTemp);
   //for (i = 0; i < pSS->m_dwNum; i++) {
   //   pSM = new CSentenceMatch;
   //   if (!pSM)
   //      return FALSE;
      
   //   // fill in
   //   pSM->m_fIgnoreNotEnough = FALSE;
   //   pSM->m_fIgnoreProsody = FALSE;
   //   pSM->m_fTriangle = TRUE;
   //   pSM->m_iStartUse = (int)i;
   //   pSM->m_iEndUse = (int)pSM->m_iStartUse + 1;
   //   pSM->m_iEnd = pSM->m_iEndUse + (int)dwWindow;
   //   pSM->m_iStart = pSM->m_iStartUse - (int)dwWindow;
   //   pSM->m_fCompareAgainstTarget = TRUE;   // compare this against the target
   //   if (dwWindow <= 1)
   //      pSM->m_fIgnoreNotEnough = TRUE;  // down to the last dregs

   //   // add this to list
   //   lTemp.Add (&pSM);
   //} // i

#ifdef _DEBUG
   WCHAR szTemp[256];
#endif

   // repeat, calling multithreaded code until all matches have been found
   PCSentenceMatch *ppSM;

   // fill in multithreaded info
   EMTSENTENCEMATCH em;
   memset (&em, 0, sizeof(em));
   em.dwType = 100;
   em.pInfo = pInfo;
   em.plPCSentenceMatch = &lTemp;
   em.fWord = fWord;
   em.ppCTTSProsody = ppCTTSProsody;
   em.dwNum = dwNum;
   em.pSS = pSS;
   em.iTTSQuality = iTTSQuality;
   em.wPeriod = (WORD) m_pLexInProsody->WordFind (L".");
   em.dwMultiPass = dwMultiPass;
   em.pLexTTS = pLexTTS;

   // find matches for the syllables in the sentences
   while (lTemp.Num()) {
      // call
      ThreadLoop (0, lTemp.Num(), 1, &em, sizeof(em), NULL);

      // move ones that success over
      ppSM = (PCSentenceMatch*)lTemp.Get(0);
      for (i = 0; i < lTemp.Num(); i++) {
         pSM = ppSM[i];

#ifdef _DEBUG
         swprintf (szTemp, L"\r\nGenerateMatches - %s %s %d to %d (%d - %d, size=%d), %d matches",
            pSM->m_fTriangle ? L"Single-syllable" : L"Phrase",
            (pSM->m_fSuccess || pSM->m_fIgnoreNotEnough) ? L"Success!" : L"Failure",
            (int)pSM->m_iStartUse, (int)pSM->m_iEndUse, (int)pSM->m_iStart, (int)pSM->m_iEnd,
            (int)(pSM->m_iEnd - pSM->m_iStart), (int)pSM->m_lSENTENCEMATCH.Num());
         OutputDebugStringW (szTemp);
#endif
         // if succeded then move, or if last attempt
         if (pSM->m_fSuccess || pSM->m_fIgnoreNotEnough) {

            // add
            plResynth->Add (&pSM);

            // remove from this list
            lTemp.Remove (i);
            i--;
            ppSM = (PCSentenceMatch*)lTemp.Get(0);

            continue;
         }

         // else, didn't work! need to try a smaller search

         // if this is a phrase that didn't succede then add to lBad list and deal with in a moment
         if (!pSM->m_fTriangle) {
            lBad.Add (&pSM);
            lTemp.Remove (i);
            i--;
            ppSM = (PCSentenceMatch*)lTemp.Get(0);
            continue;
         }

         // narrow the search space
         int iToRight = pSM->m_iEnd - pSM->m_iEndUse;
         int iToLeft = pSM->m_iStartUse - pSM->m_iStart;
         if (iToRight > iToLeft)
            pSM->m_iEnd--;
         else if (iToRight < iToLeft)
            pSM->m_iStart++;
         else
            pSM->m_iEnd--; // decrease from the end first

         pSM->m_fIgnoreNotEnough = (pSM->m_iStart >= pSM->m_iStartUse - 1) && (pSM->m_iEnd <= pSM->m_iEndUse + 1);
      } // i

      // if any in bad list then subdivide them into smaller rules, or individual syllables
      ppSM = (PCSentenceMatch*)lBad.Get(0);
      for (i = 0; i < lBad.Num(); i++) {
         pSM = ppSM[i];

         SubdivideSentenceByPhrases (pSS, (DWORD) max(pSM->m_iStartUse, 0), (DWORD) min(pSM->m_iEndUse, (int)pSS->m_dwNum),
            dwWindow, FALSE, &lTemp);

         delete pSM;
      } // i
      lBad.Clear();
   } // while lTemp.Num();

   // sort by m_iStartUse so have in order of generation
   qsort (plResynth->Get(0), plResynth->Num(), sizeof(PCSentenceMatch), PCSentenceMatchSortScore);

   // generate joins
   ppSM = (PCSentenceMatch*)plResynth->Get(0);
   for (i = 0; i <= plResynth->Num(); i++) {
      pSM = new CSentenceMatch;
      if (!pSM)
         return FALSE;
      
      // fill in
      pSM->m_fIgnoreNotEnough = FALSE;
      pSM->m_fIgnoreProsody = FALSE;
      pSM->m_fTriangle = TRUE;
      pSM->m_iStartUse = i ? ppSM[i-1]->m_iEndUse : 0;
      pSM->m_iEndUse = (int)pSM->m_iStartUse;   // NOTE: NOT adding 1, want joins to be 0-sized
      pSM->m_iEnd = pSM->m_iEndUse + (int)dwWindow;
      pSM->m_iStart = pSM->m_iStartUse - (int)dwWindow;
      pSM->m_fCompareAgainstTarget = FALSE;  // don't compare against target, since need to compare against final audio
      if (dwWindow <= 1)
         pSM->m_fIgnoreNotEnough = TRUE;  // down to the last dregs

      // add this to list
      lTemp.Add (&pSM);
   } // i

   // find best joins
   while (lTemp.Num()) {
      // call
      ThreadLoop (0, lTemp.Num(), 1, &em, sizeof(em), NULL);

      // move ones that success over
      ppSM = (PCSentenceMatch*)lTemp.Get(0);
      for (i = 0; i < lTemp.Num(); i++) {
         pSM = ppSM[i];

#ifdef _DEBUG
         swprintf (szTemp, L"\r\nGenerateMatches - Joins - %s %d to %d (%d - %d, size=%d), %d matches",
            (pSM->m_fSuccess || pSM->m_fIgnoreNotEnough) ? L"Success!" : L"Failure",
            (int)pSM->m_iStartUse, (int)pSM->m_iEndUse, (int)pSM->m_iStart, (int)pSM->m_iEnd,
            (int)(pSM->m_iEnd - pSM->m_iStart), (int)pSM->m_lSENTENCEMATCH.Num());
         OutputDebugStringW (szTemp);
#endif
         // if succeded then move, or if last attempt
         if (pSM->m_fSuccess || pSM->m_fIgnoreNotEnough) {

            // add
            plJoin->Add (&pSM);

            // remove from this list
            lTemp.Remove (i);
            i--;
            ppSM = (PCSentenceMatch*)lTemp.Get(0);

            continue;
         }

         // else, didn't work! need to try a smaller search
         // narrow the search space
         int iToRight = pSM->m_iEnd - pSM->m_iEndUse;
         int iToLeft = pSM->m_iStartUse - pSM->m_iStart;
         if (iToRight > iToLeft)
            pSM->m_iEnd--;
         else if (iToRight < iToLeft)
            pSM->m_iStart++;
         else
            pSM->m_iEnd--; // decrease from the end first

         pSM->m_fIgnoreNotEnough = (pSM->m_iStart >= pSM->m_iStartUse - 1) && (pSM->m_iEnd <= pSM->m_iEndUse + 1);
      } // i
   } // while lTemp.Num();

   // resort joins
   qsort (plJoin->Get(0), plJoin->Num(), sizeof(PCSentenceMatch), PCSentenceMatchSortScore);

   // done
   return TRUE;
}


/*************************************************************************************
CTTSProsody::WordSylGetInternal - Internal method, given a string, this returns the TTSPWORDSYLHEADER
for it.

inputs
   PCWSTR         psz - String for the hash
   DWORD          dwSyllables - Number of syllables
   DWORD          dwStressBits - Stress bits to look for, as per TTSPWORDSYLHEADER.dwStressBits
   BOOL           fCreateIfNotExist - If TRUE, and can't find existing element, then
                  create one if it doesn't exist.
returns
   PTTSPWORDSYLHEADER - Information, or NULL if can't find. The pointer will become
      unvalid if add any more word syllables.
*/
PTTSPWORDSYLHEADER CTTSProsody::WordSylGetInternal (PCWSTR psz, DWORD dwSyllables,
                         DWORD dwStressBitsMulti, BOOL fCreateIfNotExist)
{
   // make sure has entry
   PCHashString phd;
   while (m_lPCHashStringWordSyl.Num() < dwSyllables) {
      if (!fCreateIfNotExist)
         return NULL;

      // create
      phd = new CHashString;
      if (!phd)
         return NULL;
      phd->Init (sizeof(TTSPWORDSYLHEADER) + dwSyllables * sizeof(PROSODYTREND));
      m_lPCHashStringWordSyl.Add (&phd);
   }

   PCHashString *pphd = (PCHashString*)m_lPCHashStringWordSyl.Get(0);
   phd = pphd[dwSyllables-1];

   // get the info
   PTTSPWORDSYLHEADER pwsh = (PTTSPWORDSYLHEADER) phd->Find ((PWSTR)psz);
   if (pwsh)
      return pwsh;
   if (!fCreateIfNotExist)
      return NULL;   // dont create

   // else, create
   CMem mem;
   if (!mem.Required (sizeof(TTSPWORDSYLHEADER) + dwSyllables * sizeof(PROSODYTREND)))
      return NULL;
   pwsh = (PTTSPWORDSYLHEADER)mem.p;
   memset (pwsh, 0, sizeof(TTSPWORDSYLHEADER) + dwSyllables * sizeof(PROSODYTREND));
   pwsh->dwStressBitsMulti = dwStressBitsMulti;
   pwsh->dwSyllables = dwSyllables;
   // pwsh->dwWordID = dwWordID;
   phd->Add ((PWSTR)psz, pwsh);
   pwsh = (PTTSPWORDSYLHEADER) phd->Find ((PWSTR)psz);
   return pwsh;
}


/*************************************************************************************
CTTSProsody::WordSylGet - Given a word string (or POS number) his returns the TTSPWORDSYLHEADER
for it.

inputs
   PCMLexicon     pLexTTS - TTS with phonemes in it
   PCWSTR         pszWord - String for the hash. If NULL, the use POS number
   DWORD          dwPOS - Only used if !pszWord. POS number, from 0..POS_MAJOR_NUMPLUSONE-1
   DWORD          dwSyllables - Number of syllables
   DWORD          dwStressBits - Stress bits to look for, as per TTSPWORDSYLHEADER.dwStressBits
   BOOL           fCreateIfNotExist - If TRUE, and can't find existing element, then
                  create one if it doesn't exist.
returns
   PTTSPWORDSYLHEADER - Information, or NULL if can't find. The pointer will become
      unvalid if add any more word syllables.
*/
PTTSPWORDSYLHEADER CTTSProsody::WordSylGet (PCMLexicon pLexTTS, PCWSTR pszWord, DWORD dwPOS, DWORD dwSyllables,
                         DWORD dwStressBitsMulti, BOOL fCreateIfNotExist)
{
   WCHAR szTemp[256];
   if (pszWord && (wcslen(pszWord) > sizeof(szTemp)/sizeof(WCHAR)/2))
      return NULL;   // word too large

   if ((dwSyllables <= 1) && !pLexTTS->ChineseUse())
      dwStressBitsMulti = 1; // just to make sure

   if (pszWord)
      swprintf (szTemp, L"%s:%d", pszWord, (int)dwStressBitsMulti);
   else {
      if (dwPOS == POS_MAJOR_EXTRACT(POS_MAJOR_UNKNOWN))
         dwPOS = POS_MAJOR_EXTRACT(POS_MAJOR_NOUN);  // if unknown then default to noun
      swprintf (szTemp, L"@%d:%d", (int)dwPOS, (int)dwStressBitsMulti);
   }

   return WordSylGetInternal (szTemp, dwSyllables, dwStressBitsMulti, fCreateIfNotExist);
}


/*************************************************************************************
CTTSProsody::WordSylTrain - Trains a wordsyl information (WordSylGet) based
on a SENTENCESYLLABLE.

inputs
   PCMLexicon     pLexTTS - Lexicon with phonemes in it
   DWORD          dwSyllables - Number of syllables
   PTYPICALSYLINFO pass - Array of dwSyllables TYPICALSYLINFO..
   PCWSTR         pszWord - String for the hash. If NULL, the use POS number
   DWORD          dwPOS - Only used if !pszWord. POS number, from 0..POS_MAJOR_NUMPLUSONE-1
   DWORD          dwStressBitsMulti - Stress bits to look for, as per TTSPWORDSYLHEADER.dwStressBitsMulti
returns
   BOOL - TRUE if success
*/
BOOL CTTSProsody::WordSylTrain (PCMLexicon pLexTTS, DWORD dwSyllables, PTYPICALSYLINFO pass, PCWSTR pszWord,
                                DWORD dwPOS, DWORD dwStressBitsMulti)
{
   PTTSPWORDSYLHEADER pwsh = WordSylGet (pLexTTS, pszWord, dwPOS, dwSyllables, dwStressBitsMulti, TRUE);
   if (!pwsh)
      return FALSE;

   // all the individual syllables
   DWORD i;
   PPROSODYTREND ppt = (PPROSODYTREND) (pwsh+1);
   for (i = 0; i < dwSyllables; i++, ppt++) {
      ppt->iCount ++;
      ppt->iDurPhone += (int)(pass[i].fDurPhoneSum / pass[i].fCount / log(2.0) * 50.0); // (int)(log((fp)pass[i].bDurPhone / 100.0) / log(2.0) * 50.0);
      ppt->iDurSkew += (int)(pass[i].fDurSkewSum / pass[i].fCount / log(2.0) * 100.0); // pass[i].cDurSkew;
      ppt->iDurSyl += (int)(pass[i].fDurSylSum / pass[i].fCount / log(2.0) * 50.0); // (int)(log((fp)pass[i].bDurSyl / 100.0) / log(2.0) * 50.0);
      ppt->iPitch += (int)(pass[i].fPitchSum / pass[i].fCount / log(2.0) * 100.0); // (int)(log((fp)pass[i].bPitch / 100.0) / log(2.0) * 100.0);
      ppt->iPitchBulge += (int)(pass[i].fPitchBulgeSum / pass[i].fCount / log(2.0) * 100.0); // pass[i].cPitchBulge;
      ppt->iPitchSweep += (int)(pass[i].fPitchSweepSum / pass[i].fCount / log(2.0) * 100.0); // pass[i].cPitchSweep;
      // ppt->iPitchRelative - not set
      ppt->iVol += (int)(pass[i].fVolumeSum / pass[i].fCount / log(2.0) * 50.0); // (int)(log((fp)pass[i].bVol / 100.0) / log(2.0) * 50.0);
   } // i

   return TRUE;
}


/*************************************************************************************
CTTSProsody::WordSylGetTYPICALSYLINFO - Gets the default prosody information
for the word and fills it into the SETENCESYLLABLE list.

inputs
   PCMLexicon     pLexTTS - Lexicon with phonemes in it
   PCWSTR         pszWord - String for the hash. If NULL, then assume unknown word
   DWORD          dwPOS - POS number, from 0..POS_MAJOR_NUMPLUSONE-1
   DWORD          dwSyllables - Number of syllables
   DWORD          dwStressBits - Stress bits to look for, as per TTSPWORDSYLHEADER.dwStressBits.

   CTTSProsody    **ppCTTSProsody - List of other prosody models, including this one
   DWORD          dwNum - Number of other prosody models

   PTYPICALSYLINFO pass - Array of dwSyllables sentence syllables that are filled in.
            NOTE: Count will ALWAYS be 1.0
returns
   BOOL - TRUE if success
*/
BOOL CTTSProsody::WordSylGetTYPICALSYLINFO (PCMLexicon pLexTTS, PCWSTR pszWord, DWORD dwPOS, DWORD dwSyllables,
                                              DWORD dwStressBitsMulti, CTTSProsody **ppCTTSProsody,
                                              DWORD dwNum, PTYPICALSYLINFO pass)
{
   // scratch memory
   BYTE abTempWord[sizeof(TTSPWORDSYLHEADER) + 16 * sizeof(PROSODYTREND)];
   BYTE abTempPOS[sizeof(TTSPWORDSYLHEADER) + 16 * sizeof(PROSODYTREND)];
   CMem memWord, memPOS;
   PTTSPWORDSYLHEADER pwshWord = (PTTSPWORDSYLHEADER) abTempWord;
   PTTSPWORDSYLHEADER pwshPOS = (PTTSPWORDSYLHEADER) abTempPOS;
   size_t dwNeed = sizeof(TTSPWORDSYLHEADER) + dwSyllables *sizeof(PROSODYTREND);
   if (dwNeed > sizeof(abTempWord)) {
      // if buffer not large enough then alloc
      if (!memWord.Required (dwNeed) || !memPOS.Required (dwNeed))
         return FALSE;
      pwshWord = (PTTSPWORDSYLHEADER)memWord.p;
      pwshPOS = (PTTSPWORDSYLHEADER)memPOS.p;
   }
   memset (pwshWord, 0, dwNeed);
   memset (pwshPOS, 0, dwNeed);

   // loop over all the prosody models getting the info
   DWORD dwUsePOS;
   DWORD i, j;
   PPROSODYTREND ppt, pptTo;
   PTTSPWORDSYLHEADER pwsh, pwshTo;
   for (i = 0; i < dwNum; i++)
      for (dwUsePOS = 0; dwUsePOS < 2; dwUsePOS++) {
         if (!dwUsePOS && !pszWord)
            continue;   // don't have a word string

         pwsh = ppCTTSProsody[i]->WordSylGet (pLexTTS, dwUsePOS ? NULL : pszWord, dwPOS,dwSyllables, dwStressBitsMulti, FALSE);
         if (!pwsh)
            continue;   // no reference found

         pwshTo = dwUsePOS ? pwshPOS : pwshWord;

         // sum in the weights
         ppt = (PPROSODYTREND) (pwsh+1);
         pptTo = (PPROSODYTREND) (pwshTo+1);

         for (j = 0; j < dwSyllables; j++, ppt++, pptTo++) {
            pptTo->iCount += ppt->iCount;
            pptTo->iDurPhone += ppt->iDurPhone;
            pptTo->iDurSkew += ppt->iDurSkew;
            pptTo->iDurSyl += ppt->iDurSyl;
            pptTo->iPitch += ppt->iPitch;
            pptTo->iPitchBulge += ppt->iPitchBulge;
            pptTo->iPitchRelative += ppt->iPitchRelative;
            pptTo->iPitchSweep += ppt->iPitchSweep;
            pptTo->iVol += ppt->iVol;
         } // j

      } // dwUsePOS

   // add in defaults to POS if not enough entries
   pwshTo = pwshPOS;
   pptTo = (PPROSODYTREND) (pwshTo+1);
   for (j = 0; j < dwSyllables; j++, pptTo++) {
      pptTo->iCount += WORDSENTSYL_MINEXAMPLES;

      // NOTE: Leave all the values as +0 since 0 * WORDSENTSYL_MINEXAMPLES == 0
      // and they're all stored as log
   }

   // scale so no more than WORDSENTSYL_MINEXAMPLES
   pwshTo = pwshPOS;
   pptTo = (PPROSODYTREND) (pwshTo+1);
   for (j = 0; j < dwSyllables; j++, pptTo++)
      if (pptTo->iCount > WORDSENTSYL_MINEXAMPLES) {
         pptTo->iDurPhone = (pptTo->iDurPhone * WORDSENTSYL_MINEXAMPLES) / pptTo->iCount;
         pptTo->iDurSkew = (pptTo->iDurSkew * WORDSENTSYL_MINEXAMPLES) / pptTo->iCount;
         pptTo->iDurSyl = (pptTo->iDurSyl * WORDSENTSYL_MINEXAMPLES) / pptTo->iCount;
         pptTo->iPitch = (pptTo->iPitch * WORDSENTSYL_MINEXAMPLES) / pptTo->iCount;
         pptTo->iPitchBulge = (pptTo->iPitchBulge * WORDSENTSYL_MINEXAMPLES) / pptTo->iCount;
         pptTo->iPitchRelative = (pptTo->iPitchRelative * WORDSENTSYL_MINEXAMPLES) / pptTo->iCount;
         pptTo->iPitchSweep = (pptTo->iPitchSweep * WORDSENTSYL_MINEXAMPLES) / pptTo->iCount;
         pptTo->iVol = (pptTo->iVol * WORDSENTSYL_MINEXAMPLES) / pptTo->iCount;
         pptTo->iCount = WORDSENTSYL_MINEXAMPLES;
      } // j
   
   // incorporate POS count into the word's count
   pwsh = pwshPOS;
   ppt = (PPROSODYTREND) (pwsh+1);
   pwshTo = pwshWord;
   pptTo = (PPROSODYTREND) (pwshTo+1);
   for (j = 0; j < dwSyllables; j++, ppt++, pptTo++) {
      pptTo->iCount += ppt->iCount;
      pptTo->iDurPhone += ppt->iDurPhone;
      pptTo->iDurSkew += ppt->iDurSkew;
      pptTo->iDurSyl += ppt->iDurSyl;
      pptTo->iPitch += ppt->iPitch;
      pptTo->iPitchBulge += ppt->iPitchBulge;
      pptTo->iPitchRelative += ppt->iPitchRelative;
      pptTo->iPitchSweep += ppt->iPitchSweep;
      pptTo->iVol += ppt->iVol;
   } // j

   // NOTE: Know there are at least WORDSENTSYL_MINEXAMPLES elements
   
   // fill in the SENTENCESYLLABLE entreis
   pwsh = pwshWord;
   ppt = (PPROSODYTREND) (pwsh+1);
   for (j = 0; j < dwSyllables; j++, ppt++, pass++) {
      memset (pass, 0, sizeof(*pass));

      pass->fCount = 1.0;

      pass->fDurPhoneSum = (fp)(ppt->iDurPhone / ppt->iCount) / 50.0 * log(2.0);
      pass->fDurSylSum = (fp)(ppt->iDurSyl / ppt->iCount) / 50.0 * log(2.0);
      pass->fVolumeSum = (fp)(ppt->iVol / ppt->iCount) / 50.0 * log(2.0);
      pass->fPitchSum = (fp)(ppt->iPitch / ppt->iCount) / 100.0 * log(2.0);
      pass->fDurSkewSum = ppt->iDurSkew / ppt->iCount / 100.0 * log(2.0);
      pass->fPitchBulgeSum = ppt->iPitchBulge / ppt->iCount / 100.0 * log(2.0);
      // pass->fPitchRelative - not used
      pass->fPitchSweepSum = ppt->iPitchSweep / ppt->iCount / 100.0 * log(2.0);
   } // j


   return TRUE;
}

#if 0 // not used
/*************************************************************************************
CTTSProsody::WordSylGetSENTENCESYLLABLE - Gets the default prosody information
for the word and fills it into the SETENCESYLLABLE list.

inputs
   PCWSTR         pszWord - String for the hash. If NULL, then assume unknown word
   DWORD          dwPOS - POS number, from 0..POS_MAJOR_NUMPLUSONE-1
   DWORD          dwSyllables - Number of syllables
   DWORD          dwStressBits - Stress bits to look for, as per TTSPWORDSYLHEADER.dwStressBits.

   CTTSProsody    **ppCTTSProsody - List of other prosody models, including this one
   DWORD          dwNum - Number of other prosody models

   PSENTENCESYLLABLE pass - Array of dwSyllables sentence syllables that are filled in.
returns
   BOOL - TRUE if success
*/
BOOL CTTSProsody::WordSylGetSENTENCESYLLABLE (PCWSTR pszWord, DWORD dwPOS, DWORD dwSyllables,
                                              DWORD dwStressBits, CTTSProsody **ppCTTSProsody,
                                              DWORD dwNum, PSENTENCESYLLABLE pass)
{
   // scratch
   TYPICALSYLINFO aTSI[16];
   PTYPICALSYLINFO pTSI = aTSI;
   CMem mem;
   size_t dwNeed = dwSyllables * sizeof(TYPICALSYLINFO);
   if (dwNeed > sizeof(aTSI)) {
      if (!mem.Required (dwNeed))
         return FALSE;
      pTSI = (PTYPICALSYLINFO) mem.p;
   }

   if (!WordSylGetTYPICALSYLINFO (pszWord, dwPOS, dwSyllables, dwStressBits, ppCTTSProsody, dwNum, pTSI))
      return FALSE;

   // conver over
   DWORD i;
   fp f;
   for (i = 0; i < dwSyllables; i++, pTSI++, pass++) {
      memset (pass, 0, sizeof(*pass));

      f = pow (2.0, pTSI->fDurPhoneSum) * 100.0; wrong - need to include log(2) for all of these
      f = max (f, 0);
      f = min (f, 255);
      pass->bDurPhone = (BYTE) f;

      f = pow (2.0, pTSI->fDurSylSum) * 100.0;
      f = max (f, 0);
      f = min (f, 255);
      pass->bDurSyl = (BYTE) f;

      f = pow (2.0, pTSI->fVolumeSum) * 100.0;
      f = max (f, 0);
      f = min (f, 255);
      pass->bVol = (BYTE) f;

      f = pow (2.0, pTSI->fPitchSum) * 100.0;
      f = max (f, 0);
      f = min (f, 255);
      pass->bPitch = (BYTE) f;

      f = pTSI->fDurSkewSum * 100.0;
      f = max (f, -127);
      f = min (f, 127);
      pass->cDurSkew = (char) f;

      f = pTSI->fPitchBulgeSum * 100.0;
      f = max (f, -127);
      f = min (f, 127);
      pass->cPitchBulge = (char) f;

      f = pTSI->fPitchSweepSum * 100.0;
      f = max (f, -127);
      f = min (f, 127);
      pass->cPitchSweep = (char) f;

   } // i

   return TRUE;
}
#endif // 0


/*************************************************************************************
CTTSProsody::ProsodyTrends - Given stress and POS, returns the PPROSODYTRENDS.

inputs
   PCMLexicon     pLexTTS - Lexicon with phonemes in it
   DWORD          dwStress - Stress level of this unit
   DWORD          dwPOS - Part of speech, 0..POS_MAJOR_NUMPLUSONE-1
returns
   PPROSODYTRENDS - Appropriate prosody trend, or NULL if error
*/
PPROSODYTRENDS CTTSProsody::ProsodyTrends (PCMLexicon pLexTTS, DWORD dwStress, DWORD dwPOS)
{
   CalcNGramIfNecessary(pLexTTS);
   PPROSODYTRENDS papt = (PPROSODYTRENDS) m_memPROSODYTRENDS.p;
   if (!papt)
      return NULL;

   return papt + (dwPOS * pLexTTS->Stresses() + dwStress);
}


/*************************************************************************************
CTTSProsody::ProsodyTrend - Extract the prosody trend from the PROSODYTRENDS list

inputs
   PCMLexicon     pLexTTS- Lexicon with phonemes in it
   DWORD          dwStress - Stress number, 0+
   DWORD          dwPOS - Part of speech, 0..POS_MAJOR_NUMPLUSONE-1
   DWORD          dwCommon - How common the word is, from 0..3
   DWORD          dwPhonemes - How many phonemes the syllable has (minus one), from 0..3
   DWORD          dwSyllable - What syllable index number (minus one), from 0..7
   DWORD          dwParseLevel - Location in the parse level, from 0..15
   PPROSODYTREND  ptCommon - Should intiially be filled with something. Values
                  from PROSODYTRENDS will be summed in
   PPROSODYTREND  ptPhonemes - As above
   PPROSODYTREND  ptSyllable - As above
   PPROSODYTREND  ptParseLevel - As above
   PPROSODYTREND  ptAll - Everything thats added into ptCommon, ptPhonemes, ptSyllable,
                  and ptParseLevel will be added into ptAll
returns
   BOOL - TRUE if success
*/
#ifdef USEPROSODYTREND
BOOL CTTSProsody::ProsodyTrend (PCMLexicon pLexTTS, DWORD dwStress, DWORD dwPOS, DWORD dwCommon, DWORD dwPhonemes,
                                 DWORD dwSyllable, DWORD dwParseLevel, PPROSODYTREND ptCommon,
                                 PPROSODYTREND ptPhonemes, PPROSODYTREND ptSyllable,
                                 PPROSODYTREND ptParseLevel, PPROSODYTREND ptAll)
{
   PPROSODYTRENDS ppt = ProsodyTrends (pLexTTS, dwStress, dwPOS);
   if (!ppt)
      return FALSE;

   DWORD i, j;
   int *piSource, *piDest;
   int *piAll = (int*)ptAll;
   for (i = 0; i < 4; i++) {
      switch (i) {
      case 0:  // common
         piSource = (int*)&ppt->aCommon[dwCommon];
         piDest = (int*)ptCommon;
         break;
      case 1:  // phonemes
         piSource = (int*)&ppt->aPhonemes[dwPhonemes];
         piDest = (int*)ptPhonemes;
         break;
      case 2:  // syllable
         piSource = (int*)&ppt->aSyllable[dwSyllable];
         piDest = (int*)ptSyllable;
         break;
      case 3:  // level
         piSource = (int*)&ppt->aParse[dwParseLevel];
         piDest = (int*)ptParseLevel;
         break;
      } // switch

      // copy them over
      for (j = 0; j < sizeof(PROSODYTREND)/sizeof(int); j++) {
         piDest[j] += piSource[j];
         piAll[j] += piSource[j];
      } // j
   } // i

   return TRUE;
}
#endif //USEPROSODYTREND

/*************************************************************************************
CTTSProsody::ProsodyTrend - Extract the prosody trend from the PROSODYTRENDS list

inputs
   PCMLexicon     pLexTTS - Lexicon with phonemes in it
   DWORD          dwStress - Stress number, 0+
   DWORD          dwPOS - Part of speech, 0..POS_MAJOR_NUMPLUSONE-1
   DWORD          dwCommon - How common the word is, from 0..3
   DWORD          dwPhonemes - How many phonemes the syllable has (minus one), from 0..3
   DWORD          dwSyllable - What syllable index number (minus one), from 0..7
   DWORD          dwParseLevel - Location in the parse level, from 0..15
   PPROSODYTREND  ptCommon - Should intiially be filled with something. Values
                  from PROSODYTRENDS will be summed in
   PPROSODYTREND  ptPhonemes - As above
   PPROSODYTREND  ptSyllable - As above
   PPROSODYTREND  ptParseLevel - As above
   PPROSODYTREND  ptAll - Everything thats added into ptCommon, ptPhonemes, ptSyllable,
                  and ptParseLevel will be added into ptAll
   CTTSProsody **ppCTTSProsody - List of other prosody models, including this one
   DWORD       dwNum - Number of other prosody models
returns
   BOOL - TRUE if success
*/
#ifdef USEPROSODYTREND
BOOL CTTSProsody::ProsodyTrend (PCMLexicon pLexTTS, DWORD dwStress, DWORD dwPOS, DWORD dwCommon, DWORD dwPhonemes,
                                 DWORD dwSyllable, DWORD dwParseLevel, PPROSODYTREND ptCommon,
                                 PPROSODYTREND ptPhonemes, PPROSODYTREND ptSyllable,
                                 PPROSODYTREND ptParseLevel, PPROSODYTREND ptAll,
                                 CTTSProsody **ppCTTSProsody, DWORD dwNum)
{
   DWORD i;
   for (i = 0; i < dwNum; i++)
      ppCTTSProsody[i]->ProsodyTrend (pLexTTS, dwStress, dwPOS, dwCommon, dwPhonemes,
         dwSyllable, dwParseLevel, ptCommon, ptPhonemes, ptSyllable,
         ptParseLevel, ptAll);

   return TRUE;
}
#endif

/*************************************************************************************
CTTSProsody::ProsodyTrend - Fill in the prosody trend adjustments

inputs
   PCMLexicon  pLexTTS - LExicon with phonemes in it
   BYTE        bPOSStressModel - Part of speech from the model in low 4 bits, stress in high 4 bits
   BYTE        bSylIndexModel - Syllable index in low 3 bits
   BYTE        bRuleDepdthModel - Rule depth from the model
   BYTE        bPOSStressWant - Part of speech that want in low 4 bits, stress in high 4 bits
   BYTE        bSylIndexWant - Syllable index in low 3 bits
   BYTE        bRuleDepthWant - Rule depth that want
   PPROSODYTREND  ptMods - Filled in the the prosodytrend information for how to
               modify the model to get it to simulate what want. Ignore the count
   CTTSProsody **ppCTTSProsody - List of other prosody models, including this one
   DWORD       dwNum - Number of other prosody models
returns
   BOOL - TRUE if success
*/
#ifdef USEPROSODYTREND
BOOL CTTSProsody::ProsodyTrend (PCMLexicon pLexTTS, BYTE bPOSStressModel, BYTE bSylIndexModel, BYTE bRuleDepthModel,
                                   BYTE bPOSStressWant, BYTE bSylIndexWant, BYTE bRuleDepthWant,
                                PPROSODYTREND ptMods,
                                CTTSProsody **ppCTTSProsody, DWORD dwNum)
{
   memset (ptMods, 0, sizeof(*ptMods));

   // trivial reject
   if ((bPOSStressModel == bPOSStressWant) && (bSylIndexModel == bSylIndexWant) && (bRuleDepthModel == bRuleDepthWant))
      return TRUE;

   PROSODYTREND aProsTrend[2][4];   // prosody trends
   PROSODYTREND ProsTrendAll[2];    // all
   memset (aProsTrend, 0, sizeof(aProsTrend));
   memset (ProsTrendAll, 0, sizeof(ProsTrendAll));

   // get the trends
   // model
   ProsodyTrend (
      pLexTTS,
      (bPOSStressModel >> 4) & 0x0f,  // stress
      bPOSStressModel & 0x0f, // POS
      (bRuleDepthModel >> 6) & 0x03,   // common
      (bRuleDepthModel >> 4) & 0x03,   // phonemes
      bSylIndexModel & 0x07,   // syllable number
      bRuleDepthModel & 0x0f, // rule depth
      &aProsTrend[0][0], &aProsTrend[0][1], &aProsTrend[0][2], &aProsTrend[0][3],
      &ProsTrendAll[0],
      ppCTTSProsody, dwNum);
   // what want
   ProsodyTrend (
      pLexTTS,
      (bPOSStressWant >> 4) & 0x0f,  // stress
      bPOSStressWant & 0x0f, // POS
      (bRuleDepthWant >> 6) & 0x03,   // common
      (bRuleDepthWant >> 4) & 0x03,   // phonemes
      bSylIndexWant & 0x07,   // syllable number
      bRuleDepthWant & 0x0f, // rule depth
      &aProsTrend[1][0], &aProsTrend[1][1], &aProsTrend[1][2], &aProsTrend[1][3],
      &ProsTrendAll[1],
      ppCTTSProsody, dwNum);

   // figure out the values
   DWORD i, j, k;
   int *piCur;
   int iCount;
   for (i = 0; i < 2; i++) {
      for (j = 0; j <= 4; j++) {
         piCur = (j < 4) ? (int*)&aProsTrend[i][j] : (int*)&ProsTrendAll[i];

         iCount = piCur[0];
         if (!iCount)
            continue;   // cant determine since would be divide by zero

         for (k = 1; k < sizeof(PROSODYTREND)/sizeof(int); k++)   // intentionally start at 1
            piCur[k] /= iCount;
      } // j
   } // i

   // determine the deltas
   int *piWant;
   for (j = 0; j <= 4; j++) {
      piCur = (j < 4) ? (int*)&aProsTrend[0][j] : (int*)&ProsTrendAll[0];
      piWant = (j < 4) ? (int*)&aProsTrend[1][j] : (int*)&ProsTrendAll[1];

      // if either the count for current or want are < MINPROSODYSAMPLES
      // then not enough data points, so wipe to zero
      if ((piCur[0] < MINPROSODYSAMPLES) || (piWant[0] < MINPROSODYSAMPLES)) {
         memset (piCur, 0, sizeof(PROSODYTREND));
         continue;
      }

      // else, take delta
      for (k = 1; k < sizeof(PROSODYTREND)/sizeof(int); k++)   // intentionally start at 1
         piCur[k] = piWant[k] - piCur[k];
   } // k

   // for case 1, sum up all the deltas from all 4 different models
   piWant = (int*) &aProsTrend[0][0];
   for (j = 1; j < 4; j++) {
      piCur = (int*) &aProsTrend[0][j];
      for (k = 1; k < sizeof(PROSODYTREND)/sizeof(int); k++)   // intentionally start at 1
         piWant[k] +=  piCur[k];
   } // j

   // average result from 4 models (summed), along with result from all models averaged
   // do this because sum of all 4 models assumes data is independent, while average
   // assumed all depdendent. Neither is completely true, so take mid case
   memcpy (ptMods, &aProsTrend[0][0], sizeof(*ptMods));
   piWant = (int*)ptMods;
   piCur = (int*)&ProsTrendAll[0];
   for (k = 1; k < sizeof(PROSODYTREND)/sizeof(int); k++)   // intentionally start at 1
      piWant[k] = (piWant[k] + piCur[k]) / 2;

   return TRUE;
}
#endif // USEPROSODYTREND

/*************************************************************************************
CTTSProsody::CalcNGramIfNecessary - Calculates information such as m_memPauseNGram
and m_memPROSODYTRENDS if it isn't already calcualted.

inputs
   PCMLexicon     pLexTTS - Lexicon with phonemes in it
*/
void CTTSProsody::CalcNGramIfNecessary (PCMLexicon pLexTTS)
{
   if (m_memPauseNGram.m_dwCurPosn)
      return;

   // how much need for NGram
   DWORD dwNeed = POS_MAJOR_NUMPLUSONE * POS_MAJOR_NUMPLUSONE * POS_MAJOR_NUMPLUSONE * POS_MAJOR_NUMPLUSONE *
      2 * sizeof(DWORD);
   if (!m_memPauseNGram.Required (dwNeed))
      return;
   m_memPauseNGram.m_dwCurPosn = dwNeed;
   memset (m_memPauseNGram.p, 0, dwNeed);
   DWORD *padwNGram = (DWORD*)m_memPauseNGram.p;

   // prosody trends
   dwNeed = pLexTTS->Stresses() * POS_MAJOR_NUMPLUSONE * sizeof(PROSODYTRENDS);
   if (!m_memPROSODYTRENDS.Required (dwNeed)) {
      m_memPauseNGram.m_dwCurPosn = 0;
      return;
   }
   m_memPROSODYTRENDS.m_dwCurPosn = dwNeed;
   memset (m_memPROSODYTRENDS.p, 0, dwNeed);
   PPROSODYTRENDS papt;
   PPROSODYTREND ppt;

   // loop over all sentences
   PCSentenceSyllable *ppss = (PCSentenceSyllable*)m_lPCSentenceSyllable.Get(0);
   DWORD i, j, k;
   DWORD dwOffset;
   fp f;
   for (i = 0; i < m_lPCSentenceSyllable.Num(); i++) {
      PCSentenceSyllable pss = ppss[i];

      BYTE abNGramPOS[4], abNGramPause[4];
      for (j = 0; j < 4; j++) {
         abNGramPOS[j] = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
         abNGramPause[j] = 0; // assume 0 pause
      }

      for (j = 0; j < pss->m_dwNum; j++) {
         PSENTENCESYLLABLE ps = &pss->m_paSyl[j];
         
         // pitch
         f = ps->bPitch ? (log((fp)ps->bPitch / (fp)100.0) / log((fp)2) * 100.0) : 0;
         f = max(f, -100);
         f = min(f, 100);
         char cPitch = (char)(int)f;

         // pitch relative
         char cPitchRelative = 0;
         if (j && ps[0].bPitch & ps[-1].bPitch) {
            f = log((fp)ps[0].bPitch / (fp)ps[-1].bPitch) / log((fp)2) * 100;
               // BUGFIX - Was ps[1].bPitch, but crashed, and realized should have been -1 all the time
            f = max(f, -100);
            f = min(f, 100);
            cPitchRelative = (char) (int) f;
         }

         // volume
         f = ps->bVol ? (log((fp)ps->bVol / (fp)100.0) / log((fp)2) * 50.0) : 0;
         f = max(f, -100);
         f = min(f, 100);
         char cVol = (char)(int)f;

         // phone duration
         f = ps->bDurPhone ? (log((fp)ps->bDurPhone / (fp)100.0) / log((fp)2) * 50.0) : 0;
         f = max(f, -100);
         f = min(f, 100);
         char cDurPhone = (char)(int)f;

         // phone duration
         f = ps->bDurSyl ? (log((fp)ps->bDurSyl / (fp)100.0) / log((fp)2) * 50.0) : 0;
         f = max(f, -100);
         f = min(f, 100);
         char cDurSyl = (char)(int)f;

         // duration skew
         char cDurSkew = ps->cDurSkew;

         // stuff done fo every syllable
         papt = ProsodyTrends (pLexTTS, (pss->m_pabPOSStress[j] >> 4) & 0x0f, pss->m_pabPOSStress[j] & 0x0f);
         if (papt) for (k = 0; k < 4; k++) {
            // sum into where
            switch (k) {
            case 0:  // how common word is
               ppt = &papt->aCommon[(pss->m_pabRuleDepth[j] >> 6) & 0x03];
               break;
            case 1:  // how many phonemes in syllable
               ppt = &papt->aPhonemes[(pss->m_pabRuleDepth[j] >> 4) & 0x03];
               break;
            case 2:  // what syllable number this is
               ppt = &papt->aSyllable[pss->m_pabSylIndex[j] & 0x07];
               break;
            case 3:  // location in the parse level
               ppt = &papt->aParse[pss->m_pabRuleDepth[j] & 0x0f];
               break;
            } // k

            ppt->iCount++;
            ppt->iDurPhone += (int)cDurPhone;
            ppt->iDurSyl += (int)cDurSyl;
            ppt->iDurSkew += (int)cDurSkew;
            ppt->iPitch += (int)cPitch;
            ppt->iPitchBulge += (int)ps->cPitchBulge;
            ppt->iPitchRelative += (int)cPitchRelative;
            ppt->iPitchSweep += (int)ps->cPitchSweep;
            ppt->iVol += (int)cVol;
         }

         // if its a new word then shift NGram and add
         if (pss->IsStartOfWord (j)) {
            memmove (abNGramPOS, abNGramPOS+1, sizeof(abNGramPOS)-sizeof(BYTE));
            memmove (abNGramPause, abNGramPause+1, sizeof(abNGramPause)-sizeof(BYTE));

            abNGramPOS[3] = pss->m_pabPOSStress[j] & 0x0f;
            abNGramPause[3] = pss->m_paSyl[j].bPauseProb & 0x0f;

            // add this
            dwOffset = ((( ( (((DWORD)abNGramPOS[0] * POS_MAJOR_NUMPLUSONE) +
               (DWORD)abNGramPOS[1]) * POS_MAJOR_NUMPLUSONE) +
               (DWORD)abNGramPOS[2]) * POS_MAJOR_NUMPLUSONE) +
               (DWORD)abNGramPOS[3]) * 2;
            padwNGram[dwOffset] += 1;
            padwNGram[dwOffset+1] += (DWORD)abNGramPause[2];
         }
      } // j, over each syllable

      // finish up the sentenace POS
      for (j = 0; j < 3; j++) {
         memmove (abNGramPOS, abNGramPOS+1, sizeof(abNGramPOS)-sizeof(BYTE));
         memmove (abNGramPause, abNGramPause+1, sizeof(abNGramPause)-sizeof(BYTE));

         abNGramPOS[3] = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
         abNGramPause[3] = 0;

         // add this
         dwOffset = ((( ( (((DWORD)abNGramPOS[0] * POS_MAJOR_NUMPLUSONE) +
            (DWORD)abNGramPOS[1]) * POS_MAJOR_NUMPLUSONE) +
            (DWORD)abNGramPOS[2]) * POS_MAJOR_NUMPLUSONE) +
            (DWORD)abNGramPOS[3]) * 2;
         padwNGram[dwOffset] += 1;
         padwNGram[dwOffset+1] += (DWORD)abNGramPause[2];
      } // j
   } // i, over all sentences

}


/*************************************************************************************
CTTSProsody::PauseNGram - Given a list of parts of speech, returns the pause NGram.

inputs
   PCMLexicon  pLexTTS - Lexicon with phonemes in it
   BYTE        bWord1 - First word in list. Low 4 bits are POS, upper 4 are 0. 2 words before potential pause
   BYTE        bWord2 - Second word.
   BYTE        bWord3 - Third word. Right after potential pause
   BYTE        bWord4 - Fourth word
returns
   DWORD * - [0] is the count. [1] is sum of pause probability scores. Can be NULL.
*/
DWORD *CTTSProsody::PauseNGram (PCMLexicon pLexTTS, BYTE bWord1, BYTE bWord2, BYTE bWord3, BYTE bWord4)
{
   CalcNGramIfNecessary (pLexTTS);
   DWORD *padwNGram = (DWORD*)m_memPauseNGram.p;
   if (!padwNGram)
      return NULL;

   DWORD dwOffset = ((( ( (((DWORD)bWord1 * POS_MAJOR_NUMPLUSONE) +
      (DWORD)bWord2) * POS_MAJOR_NUMPLUSONE) +
      (DWORD)bWord3) * POS_MAJOR_NUMPLUSONE) +
      (DWORD)bWord4) * 2;

   return padwNGram + dwOffset;
}



/*************************************************************************************
CTTSProsody::PauseNGram - Returns the pause probability given a list
of extra prosody models.

inputs
   PCMLexicon  pLexTTS - Lexicon with phonemes in it
   BYTE        bWord1 - First word in list. Low 4 bits are POS, upper 4 are 0. 2 words before potential pause
   BYTE        bWord2 - Second word.
   BYTE        bWord3 - Third word. Right after potential pause
   BYTE        bWord4 - Fourth word
   CTTSProsody **ppCTTSProsody - List of other prosody models, including this one
   DWORD       dwNum - Number of other prosody models
returns
   fp - Value, from 0.0 to 1.0. -1 if not enough information
*/
fp CTTSProsody::PauseNGram (PCMLexicon pLexTTS, BYTE bWord1, BYTE bWord2, BYTE bWord3, BYTE bWord4,
                            CTTSProsody **ppCTTSProsody, DWORD dwNum)
{
   DWORD dwCount = 0, dwSum = 0;
   DWORD *padw;
   DWORD i;
   for (i = 0; i < dwNum; i++) {
      padw = PauseNGram (pLexTTS, bWord1, bWord2, bWord3, bWord4);
      if (!padw)
         continue;

      dwCount += padw[0];
      dwSum += padw[1];
   } // i

   if (dwCount < MINPROSODYSAMPLES)
      return -1.0;   // not enough to make a decision

   // else
   return (fp)dwSum / (fp)dwCount / 15.0;
}

/*************************************************************************************
CTTSProsody::Save - Standard api
*/
BOOL CTTSProsody::Save (PWSTR pszFile)
{
   if (!pszFile)
      // m_pszFile = pszFile;
      return FALSE;

   PCMMLNode2 pNode = MMLTo();
   if (!pNode)
      return FALSE;
   BOOL fRet;
   fRet = MMLFileSave (pszFile, &GUID_TTSProsody, pNode);
   delete pNode;

   //if (fRet && (pszFile != m_szFile))
   //   wcscpy (m_szFile, pszFile);

   return fRet;
}

/*************************************************************************************
CTTSProsody::Open - Standard api
*/
BOOL CTTSProsody::Open (PWSTR pszFile)
{
   // BUGFIX - Ignore directory
   PCMMLNode2 pNode = MMLFileOpen (pszFile, &GUID_TTSProsody, NULL, TRUE);
   if (!pNode)
      return FALSE;

   if (!MMLFrom (pNode, pszFile)) {
      delete pNode;
      return FALSE;
   }

   // rembmeber the file
   // wcscpy (m_szFile, pszFile);

   delete pNode;
   return TRUE;
}


/*************************************************************************************
CTTSProsody::Merge - Merges another prosody module in with this one

inputs
   PCMLexicon        pLexTTS - LExicon with phonemes in it
   PCTTSProsody      pOther - Othre prosody module to merge in
returns
   BOOL - TRUE if success
*/
BOOL CTTSProsody::Merge (PCMLexicon pLexTTS, PCTTSProsody pOther)
{
   PCSentenceSyllable *ppss = (PCSentenceSyllable*)pOther->m_lPCSentenceSyllable.Get(0);
   DWORD i;
   for (i = 0; i < pOther->m_lPCSentenceSyllable.Num(); i++) {
      PCSentenceSyllable pClone = ppss[i]->Clone();
      if (!pClone)
         return FALSE;

      SentenceAdd (pLexTTS, pClone, pOther->m_pLexInProsody);
   } // i

   // NOTE: Don't bother with m_lPCSentenceSyllableWord, and no need to free since
   // will be cleared if not used

   if (m_memPhonemePause.m_dwCurPosn && (m_memPhonemePause.m_dwCurPosn == pOther->m_memPhonemePause.m_dwCurPosn)) {
      DWORD *pdw = (DWORD*)m_memPhonemePause.p;
      DWORD *pdwOther = (DWORD*)pOther->m_memPhonemePause.p;
      for (i = 0; i < m_memPhonemePause.m_dwCurPosn / sizeof(DWORD); i++, pdw++, pdwOther++)
         *pdw += *pdwOther;
   }
   else if (!m_memPhonemePause.m_dwCurPosn && m_memPhonemePause.Required(pOther->m_memPhonemePause.m_dwCurPosn)) {
      // copy over
      m_memPhonemePause.m_dwCurPosn = pOther->m_memPhonemePause.m_dwCurPosn;
      memcpy (m_memPhonemePause.p, pOther->m_memPhonemePause.p, m_memPhonemePause.m_dwCurPosn);
   }

   for (i = 0; i < TYPICALSYLINFO_NUM; i++) {
      if (m_amemTYPICALSYLINFO[i].m_dwCurPosn && (m_amemTYPICALSYLINFO[i].m_dwCurPosn == pOther->m_amemTYPICALSYLINFO[i].m_dwCurPosn)) {
         double *pf = (double*)m_amemTYPICALSYLINFO[i].p;
         double *pfOther = (double*)pOther->m_amemTYPICALSYLINFO[i].p;
         for (i = 0; i < m_amemTYPICALSYLINFO[i].m_dwCurPosn / sizeof(double); i++, pf++, pfOther++)
            *pf += *pfOther;
      }
      else if (!m_amemTYPICALSYLINFO[i].m_dwCurPosn && m_amemTYPICALSYLINFO[i].Required(pOther->m_amemTYPICALSYLINFO[i].m_dwCurPosn)) {
         // copy over
         m_amemTYPICALSYLINFO[i].m_dwCurPosn = pOther->m_amemTYPICALSYLINFO[i].m_dwCurPosn;
         memcpy (m_amemTYPICALSYLINFO[i].p, pOther->m_amemTYPICALSYLINFO[i].p, m_amemTYPICALSYLINFO[i].m_dwCurPosn);
      }
   } // i

   // NGram
   if (m_memPROSODYNGRAMINFO.m_dwCurPosn && (m_memPROSODYNGRAMINFO.m_dwCurPosn == pOther->m_memPROSODYNGRAMINFO.m_dwCurPosn)) {
      float *pf = (float*)m_memPROSODYNGRAMINFO.p;
      float *pfOther = (float*)pOther->m_memPROSODYNGRAMINFO.p;
      for (i = 0; i < m_memPROSODYNGRAMINFO.m_dwCurPosn / sizeof(float); i++, pf++, pfOther++)
         *pf += *pfOther;
   }
   else if (!m_memPROSODYNGRAMINFO.m_dwCurPosn && m_memPROSODYNGRAMINFO.Required(pOther->m_memPROSODYNGRAMINFO.m_dwCurPosn)) {
      // copy over
      m_memPROSODYNGRAMINFO.m_dwCurPosn = pOther->m_memPROSODYNGRAMINFO.m_dwCurPosn;
      memcpy (m_memPROSODYNGRAMINFO.p, pOther->m_memPROSODYNGRAMINFO.p, m_memPROSODYNGRAMINFO.m_dwCurPosn);
   }

   // loop through all the prosody per word
   PCHashString *pphd = (PCHashString*)pOther->m_lPCHashStringWordSyl.Get(0);
   PCHashString phd;
   PTTSPWORDSYLHEADER pwsh, pwshExist;
   DWORD j, k;
   for (i = 0; i < pOther->m_lPCHashStringWordSyl.Num(); i++) {
      phd = pphd[i];
      for (j = 0; j < phd->Num(); j++) {
         pwsh = (PTTSPWORDSYLHEADER) phd->Get(i);
         if (!pwsh)
            continue;

         PWSTR pszWord = phd->GetString (i);
         if (!pszWord)
            continue;

         // create new entry
         pwshExist = WordSylGetInternal (pszWord, pwsh->dwSyllables, pwsh->dwStressBitsMulti, TRUE);
         if (!pwshExist)
            continue;

         // add in new values
         PPROSODYTREND ppt = (PPROSODYTREND) (pwsh+1);
         PPROSODYTREND pptExist = (PPROSODYTREND) (pwshExist+1);
         for (k = 0; k < pwsh->dwSyllables; k++, ppt++, pptExist++) {
            pptExist->iCount += ppt->iCount;
            pptExist->iDurPhone += ppt->iDurPhone;
            pptExist->iDurSkew += ppt->iDurSkew;
            pptExist->iDurSyl += ppt->iDurSyl;
            pptExist->iPitch += ppt->iPitch;
            pptExist->iPitchBulge += ppt->iPitchBulge;
            pptExist->iPitchRelative += ppt->iPitchRelative;
            pptExist->iPitchSweep += ppt->iPitchSweep;
            pptExist->iVol += ppt->iVol;
         } // k

      } // j
   } // i

   return TRUE;
}

/*************************************************************************************
CTTSProsody::ProsodyNGramInfoGetInternal - Iternal function for getting values

inputs
   PCMLexicon              pLexTTS - Lexicon with phonemes in it
   PBYTE                   pabPOS - Array. POS in low 4 bits. High four bits indicates if stressed.
   DWORD                   dwNum - Number of entries in pabPOS
   DWORD                   dwIndex - Incex into pabPOS where the center is for the NGram.
   BOOL                    fCreateIfNotExist - If TRUE then create the data if it doesn't exist
returns
   PPROSODYNGRAMINFO - Pointer to the memory containing the data, or NULL if not there.
*/
#ifndef NOMODS_DISABLEPROSODYNGRAM
PPROSODYNGRAMINFO CTTSProsody::ProsodyNGramInfoGetInternal (PCMLexicon pLexTTS, PBYTE pabPOS, DWORD dwNum, DWORD dwIndex,
                                                            BOOL fCreateIfNotExist)
{
   // create if doesn't exist
   DWORD dwNeed = ProsodyNGramInfoCount(pLexTTS) * sizeof(PROSODYNGRAMINFO);
   if (m_memPROSODYNGRAMINFO.m_dwCurPosn < dwNeed) {
      if (!fCreateIfNotExist)
         return NULL;

      if (!m_memPROSODYNGRAMINFO.Required (dwNeed))
         return NULL;
      m_memPROSODYNGRAMINFO.m_dwCurPosn = dwNeed;
      memset (m_memPROSODYNGRAMINFO.p, 0, dwNeed);
   }

   // figure out the index
   int iCur;
   BYTE bPOS;
   DWORD dwOffset = 0;
   DWORD dwPOS;
   for (iCur = (int)dwIndex - (int)PROSODYNGRAMNUM; iCur <= (int)dwIndex + (int)PROSODYNGRAMNUM; iCur++) {
      if ((iCur < 0) || (iCur >= (int)dwNum))
         bPOS = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);   // | 0x00 - no stress for punct
      else
         bPOS = pabPOS[iCur];

      dwPOS = (DWORD)(bPOS & 0x0f);
      dwPOS += POS_MAJOR_NUMPLUSONE * (DWORD)((bPOS >> 4) & 0x0f);
      //if (bPOS & 0x80)
      //   dwPOS += POS_MAJOR_NUMPLUSONE;
      dwOffset = (dwOffset * PROSODYNGRAMRANGE) + dwPOS;
   }
   if (dwOffset * sizeof(PROSODYNGRAMINFO) >= dwNeed)
      return NULL;   // shouldnt happen

   return (PPROSODYNGRAMINFO) m_memPROSODYNGRAMINFO.p + dwOffset;
}
#endif



/*************************************************************************************
CTTSProsody::ProsodyNGramInfoGet - Iternal function for getting values

inputs
   PBYTE                   pabPOS - Array. POS in low 4 bits. High 4 bits indicates if stressed.
   DWORD                   dwNum - Number of entries in pabPOS
   DWORD                   dwIndex - Incex into pabPOS where the center is for the NGram.
   PTYPICALSYLINFO       pInfo - Filled in with the info.
returns
   none
*/
void CTTSProsody::ProsodyNGramInfoGet (PBYTE pabPOS, DWORD dwNum, DWORD dwIndex, PTYPICALSYLINFO pInfo)
{
#ifdef NOMODS_DISABLEPROSODYNGRAM
   // so won't use prosody N-gram in training
   memset (pInfo, 0, sizeof(*pInfo));
   return;
#else
   PPROSODYNGRAMINFO pCur = ProsodyNGramInfoGetInternal (pabPOS, dwNum, dwIndex, FALSE);
   if (!pCur) {
      memset (pInfo, 0, sizeof(*pInfo));
      return;
   }

   // else, convert from floats
   DWORD i;
   float *pafFrom = (float*)pCur;
   double *pafTo = (double*)pInfo;
   for (i = 0; i < sizeof(*pInfo)/sizeof(double); i++)
      pafTo[i] = pafFrom[i];
#endif
}


/*************************************************************************************
CTTSProsody::ProsodyNGramInfoGet - This fills in the typical syllable info.

inputs
   PBYTE                   pabPOS - Array. POS in low 4 bits. High 4 bits indicates if stressed.
   DWORD                   dwNumPOS - Number of entries in pabPOS
   DWORD                   dwIndex - Incex into pabPOS where the center is for the NGram.
   CTTSProsody    **ppCTTSProsody - This of prosody objects to use for the comparison,
                  including this one.
   DWORD          dwNum - Number of prosody objects to use. Must be at least one
   PTYPICALSYLINFO       pInfo - Filled in with the info.
returns
   none
*/
#ifndef NOMODS_DISABLEPROSODYNGRAM
void CTTSProsody::ProsodyNGramInfoGet (PBYTE pabPOS, DWORD dwNumPOS, DWORD dwIndex,
                                     CTTSProsody **ppCTTSProsody, DWORD dwNum, PTYPICALSYLINFO pInfo)
{
   DWORD i, j;
   TYPICALSYLINFO TSI;
   double *pfFrom = (double*)&TSI;
   double *pfTo = (double*)pInfo;
   for (i = 0; i < dwNum; i++) {
      if (!i) {
         ppCTTSProsody[i]->ProsodyNGramInfoGet (pabPOS, dwNumPOS, dwIndex, pInfo);
         continue;
      }

      // else, sum in
      ppCTTSProsody[i]->ProsodyNGramInfoGet (pabPOS, dwNumPOS, dwIndex, &TSI);

      for (j = 0; j < sizeof(TSI) / sizeof(double); j++)
         pfTo[j] += pfFrom[j];
   }
}
#endif




/*************************************************************************************
CTTSProsody::ProsodyNGramInfoTrain - Train the info

inputs
   PTYPICALSYLINFO         pInfo - Train this. All valid, except fCount ignored and treated as if 1.
   PBYTE                   pabPOS - Array. POS in low 4 bits. High 4 bits indicates if stressed.
   DWORD                   dwNum - Number of entries in pabPOS
   DWORD                   dwIndex - Index into pabPOS where the center is for the NGram.
returns
   none
*/
void CTTSProsody::ProsodyNGramInfoTrain (PTYPICALSYLINFO pInfo, PBYTE pabPOS, DWORD dwNum, DWORD dwIndex)
{
#ifdef NOMODS_DISABLEPROSODYNGRAM
   // don't want prosody N-gram info at all
   return;
#else
   PPROSODYNGRAMINFO pCur = ProsodyNGramInfoGetInternal (pabPOS, dwNum, dwIndex, TRUE);
   if (!pCur)
      return;

   pCur->fCount++;
   pCur->fDurPhoneSum += (float) pInfo->fDurPhoneSum;
   pCur->fDurSylSum += (float) pInfo->fDurSylSum;
   pCur->fDurSkewSum += (float) pInfo->fDurSkewSum;
   pCur->fPitchBulgeSum += (float) pInfo->fPitchBulgeSum;
   pCur->fPitchSweepSum += (float) pInfo->fPitchSweepSum;
   pCur->fPitchSum += (float)pInfo->fPitchSum;
   pCur->fVolumeSum += (float) pInfo->fVolumeSum;
#endif
}


/*************************************************************************************
CTTSProsody::TypicalSylInfoGetInternal - Iternal function for getting values

inputs
   DWORD                   dwSentenceType - TYPICALSYLINFO_XXX. If dwSentenceType != TYPICALSYLINFO_STATEMENT
                              then this recursively calls into itself and makes sure to include TYPICALSYLINFO_STATEMENT
                              data if there isn't enough data
   DWORD                   dwBin - Bin to use
   double                  fAlpha - Alpha, dwIndex / (dwSentenceLength-1)
   PTYPICALSYLINFO         pInfo - Filled in with the info.
returns
   none
*/
void CTTSProsody::TypicalSylInfoGetInternal (DWORD dwSentenceType, DWORD dwBin, double fAlpha, PTYPICALSYLINFO pInfo)
{
   // find the offset for the sentence
   DWORD dwStoredSentenceLength = SentenceLengthFromBin (dwBin);
   DWORD dwOffset = SentenceLengthTotal (dwBin);
   PTYPICALSYLINFO pTSI = (PTYPICALSYLINFO)m_amemTYPICALSYLINFO[dwSentenceType].p + dwOffset;

   // figure out which two elements get trained
   fAlpha *= (fp)(dwStoredSentenceLength-1);
   DWORD dwIndex = (DWORD)fAlpha;
   DWORD dwIndex2 = min(dwIndex+1, dwStoredSentenceLength -1);
   fAlpha -= (fp)dwIndex;
   double fAlphaInv = (1.0 - fAlpha);

   // zero this out
   memset (pInfo, 0, sizeof(*pInfo));

   if (dwOffset + dwIndex2 >= m_amemTYPICALSYLINFO[dwSentenceType].m_dwCurPosn / sizeof(TYPICALSYLINFO))
      goto tryrecurse;  // beyond end of data, so dont do
      // BUGFIX - Was >, should be >=

   // copy two alphas
   DWORD dwPass, i;
   double *pfTo = (double*)pInfo;
   double *pfFrom;
   double fScale;
   for (dwPass = 0; dwPass < 2; dwPass++) {
      pfFrom = (double*) (pTSI + (dwPass ? dwIndex2 : dwIndex));
      fScale = dwPass ? fAlpha : fAlphaInv;

      for (i = 0; i < sizeof(TYPICALSYLINFO)/sizeof(double); i++)
         if ((pfFrom[i] > -1000000000) && (pfFrom[i] < 1000000000))  // BUGFIX - make sure it's a valid number
            pfTo[i] += pfFrom[i] * fScale;
   } // dwPass

   // fall through
tryrecurse:
   // if a statement, have everything
   if (dwSentenceType == TYPICALSYLINFO_STATEMENT)
      return;

   // else, call into self asking for a statement
   TYPICALSYLINFO TSIState;
   memset (&TSIState, 0, sizeof(TSIState));
   TypicalSylInfoGetInternal (TYPICALSYLINFO_STATEMENT, dwBin, fAlpha, &TSIState);
   if (TSIState.fCount > MINPROSODYSAMPLES)
      fScale = (double)MINPROSODYSAMPLES / TSIState.fCount;
   else
      fScale = 1.0;

   // Add the statement into the score of question mark or exclamation mark, since they're unlikely
   // to have much data
   pfTo = (double*)pInfo;
   pfFrom = (double*) (&TSIState);
   for (i = 0; i < sizeof(TYPICALSYLINFO)/sizeof(double); i++)
      if ((pfFrom[i] > -1000000000) && (pfFrom[i] < 1000000000))  // BUGFIX - make sure it's a valid number
         pfTo[i] += pfFrom[i] * fScale;

}


/*************************************************************************************
CTTSProsody::TypicalSylInfoGet - This fills in the typical syllable info.

inputs
   DWORD                   dwSentenceType - TYPICALSYLINFO_XXX
   DWORD                   dwIndex - Syllable index of the word into the subsentence (with dwSentenceLength syllables)
   DWORD                   dwSentenceLength - Number of syllables in the sentence
   PTYPICALSYLINFO         pInfo - Filled in with the info.
   BOOL                    fAlsoSurround - If TRUE (Default), also gets surrounding bins just
                              to make sure there's some data.
returns
   none
*/
void CTTSProsody::TypicalSylInfoGet (DWORD dwSentenceType, DWORD dwIndex, DWORD dwSentenceLength, PTYPICALSYLINFO pInfo,
                                     BOOL fAlsoSurround)
{
   // find the offset for the sentence
   DWORD dwBin = SentenceLengthToBin (dwSentenceLength);
   double fAlpha = (fp) dwIndex / (fp)((dwSentenceLength >= 2) ? (dwSentenceLength-1) : 1);

   TypicalSylInfoGetInternal (dwSentenceType, dwBin, fAlpha, pInfo);

   if (!fAlsoSurround)
      return;

   // surrounding
   int iOffset, iUse;
   TYPICALSYLINFO TSI;
   double *pfFrom = (double*)&TSI;
   double *pfTo = (double*)pInfo;
   DWORD i;
   for (iOffset = -1; iOffset <= 1; iOffset += 2) {
      iUse = iOffset + (int)dwBin;
      if ((iUse < 0) || (iUse >= SENTENCELENGTHTOBINNUM))
         continue;   // out of range

      TypicalSylInfoGetInternal (dwSentenceType, (DWORD)iUse, fAlpha, &TSI);

      for (i = 0; i < sizeof(TYPICALSYLINFO) / sizeof(double); i++)
         pfTo[i] += pfFrom[i] * 0.1;  // 10% of left/right
   } // iOffset
}



/*************************************************************************************
CTTSProsody::TypicalSylInfoGet - This fills in the typical syllable info.

inputs
   DWORD                   dwSentenceType - TYPICALSYLINFO_XXX
   DWORD                   dwIndex - Syllable index of the word into the subsentence (with dwSentenceLength syllables)
   DWORD                   dwSentenceLength - Number of syllables in the sentence
   CTTSProsody    **ppCTTSProsody - This of prosody objects to use for the comparison,
                  including this one.
   DWORD          dwNum - Number of prosody objects to use. Must be at least one
   PTYPICALSYLINFO         pInfo - Filled in with the info.
   BOOL                    fAlsoSurround - If TRUE (Default), also gets surrounding bins just
                              to make sure there's some data.
returns
   none
*/
void CTTSProsody::TypicalSylInfoGet (DWORD dwSentenceType, DWORD dwIndex, DWORD dwSentenceLength,
                                     CTTSProsody **ppCTTSProsody, DWORD dwNum, PTYPICALSYLINFO pInfo,
                                     BOOL fAlsoSurround)
{
   DWORD i, j;
   TYPICALSYLINFO TSI;
   double *pfFrom = (double*)&TSI;
   double *pfTo = (double*)pInfo;
   for (i = 0; i < dwNum; i++) {
      if (!i) {
         ppCTTSProsody[i]->TypicalSylInfoGet (dwSentenceType, dwIndex, dwSentenceLength, pInfo, fAlsoSurround);
         continue;
      }

      // else, sum in
      ppCTTSProsody[i]->TypicalSylInfoGet (dwSentenceType, dwIndex, dwSentenceLength, &TSI, fAlsoSurround);

      for (j = 0; j < sizeof(TYPICALSYLINFO) / sizeof(double); j++)
         pfTo[j] += pfFrom[j];
   }
}



/*************************************************************************************
CTTSProsody::TypicalSylInfoTrain - Trains a typical syllable information.

inputs
   DWORD                   dwSentenceType - TYPICALSYLINFO_XXX
   PTYPICALSYLINFO         pInfo - Info, except that all XXXCount are assumed to be 1.0
   DWORD                   dwIndex - Syllable index of the word into the subsentence (with dwSentenceLength syllables)
   DWORD                   dwSentenceLength - Number of syllables in the sentence
returns
   BOOL - TRUE if success
*/
BOOL CTTSProsody::TypicalSylInfoTrain (DWORD dwSentenceType, PTYPICALSYLINFO pInfo, DWORD dwIndex, DWORD dwSentenceLength)
{
   // make sure there's some info
   if (!m_amemTYPICALSYLINFO[dwSentenceType].m_dwCurPosn) {
      DWORD dwSize = SentenceLengthTotal () * sizeof(TYPICALSYLINFO);
      if (!m_amemTYPICALSYLINFO[dwSentenceType].Required (dwSize))
         return FALSE;
      m_amemTYPICALSYLINFO[dwSentenceType].m_dwCurPosn = dwSize;
      memset (m_amemTYPICALSYLINFO[dwSentenceType].p, 0, dwSize);
   }

   // find the offset for the sentence
   DWORD dwBin = SentenceLengthToBin (dwSentenceLength);
   DWORD dwStoredSentenceLength = SentenceLengthFromBin (dwBin);
   DWORD dwOffset = SentenceLengthTotal (dwBin);
   PTYPICALSYLINFO pTSI = (PTYPICALSYLINFO)m_amemTYPICALSYLINFO[dwSentenceType].p + dwOffset;

   // figure out which two elements get trained
   double fAlpha = (fp) dwIndex / (fp)((dwSentenceLength >= 2) ? (dwSentenceLength-1) : 1);
   fAlpha *= (fp)(dwStoredSentenceLength-1);
   dwIndex = (DWORD)fAlpha;
   DWORD dwIndex2 = min(dwIndex+1, dwStoredSentenceLength -1);
   fAlpha -= (fp)dwIndex;
   double fAlphaInv = (1.0 - fAlpha);

   pTSI[dwIndex].fPitchSum += pInfo->fPitchSum * fAlphaInv;
   pTSI[dwIndex].fPitchSweepSum += pInfo->fPitchSweepSum * fAlphaInv;
   pTSI[dwIndex].fPitchBulgeSum += pInfo->fPitchBulgeSum * fAlphaInv;
   pTSI[dwIndex].fVolumeSum += pInfo->fVolumeSum * fAlphaInv;
   pTSI[dwIndex].fDurPhoneSum += pInfo->fDurPhoneSum * fAlphaInv;
   pTSI[dwIndex].fDurSylSum += pInfo->fDurSylSum * fAlphaInv;
   pTSI[dwIndex].fDurSkewSum += pInfo->fDurSkewSum * fAlphaInv;

   pTSI[dwIndex].fCount += fAlphaInv;

   pTSI[dwIndex2].fPitchSum += pInfo->fPitchSum * fAlpha;
   pTSI[dwIndex2].fPitchSweepSum += pInfo->fPitchSweepSum * fAlpha;
   pTSI[dwIndex2].fPitchBulgeSum += pInfo->fPitchBulgeSum * fAlpha;
   pTSI[dwIndex2].fVolumeSum += pInfo->fVolumeSum * fAlpha;
   pTSI[dwIndex2].fDurPhoneSum += pInfo->fDurPhoneSum * fAlpha;
   pTSI[dwIndex2].fDurSylSum += pInfo->fDurSylSum * fAlpha;
   pTSI[dwIndex2].fDurSkewSum += pInfo->fDurSkewSum * fAlpha;

   pTSI[dwIndex2].fCount += fAlpha;

   return TRUE;
}

   
/*************************************************************************************
CTTSProsody::PhonemePauseGet - Gets the memory thats used for phoneme pauses.

inputs
   DWORD          dwPhoneLeft - Phoneme on the left. (Unsorted phoneme number)
   DWORD          dwPhoneRight - Phoneme on the right. (Unsorted phoneme number)
   BOOL           fCreateIfNotExist - Create if doesn't exist
   PCMLexicon     pLex - Used to get the number of phonemes
returns
   DWORD * -   if dwPhoneLeft == 0 and dwPhoneRight == 0, an
               Array of dwPhones (left) x dwPhones (right) x 2 DWORDs.
               DWORD [0] = total count encountered, [1] = count with pauses between them

               Otherwise, end up pointing to 2 DWORDs, [0] = total encountered, [1] = count between pauses
               If dwPhoneLeft or dwPhoneRight exceed pLex->PhonemeNum() then will return NULL
*/
DWORD *CTTSProsody::PhonemePauseGet (DWORD dwPhoneLeft, DWORD dwPhoneRight, BOOL fCreateIfNotExist, PCMLexicon pLex)
{
   DWORD dwPhones = pLex->PhonemeNum();
   if ((dwPhoneLeft >= dwPhones) || (dwPhoneRight >= dwPhones))
      return NULL;

   DWORD dwNeed = dwPhones * dwPhones * 2 * sizeof(DWORD);
   if (!m_memPhonemePause.m_dwCurPosn) {
      if (!m_memPhonemePause.Required(dwNeed))
         return NULL;
      m_memPhonemePause.m_dwCurPosn = dwNeed;
      memset (m_memPhonemePause.p, 0, dwNeed);
   }

   if (m_memPhonemePause.m_dwCurPosn != dwNeed)
      return NULL;

   return (DWORD*)m_memPhonemePause.p + (dwPhoneLeft * dwPhones + dwPhoneRight) * 2;
}


/*************************************************************************************
CTTSProsody::Randomize - This randomizes all the sentences in the lexicon to
ensure that a search won't always produce the same results, and there
algorithm will never get "stuck".

Call this before instigating a seach... or is this done internally?
*/
void CTTSProsody::Randomize (void)
{
   m_pPCSSRandom.Init (sizeof(PCSentenceSyllable), m_lPCSentenceSyllable.Get(0), m_lPCSentenceSyllable.Num());

   // NOTE: No point randomizing m_lPCSentenceSyllableWord

   // loop
   DWORD i;
   PCSentenceSyllable *ppss = (PCSentenceSyllable*)m_pPCSSRandom.Get(0);
   PCSentenceSyllable *ppssOrig = (PCSentenceSyllable*)m_lPCSentenceSyllable.Get(0);
   for (i = 0; i < m_pPCSSRandom.Num(); i++) {
#ifdef _DEBUG
      ppssOrig[i]->m_dwSentIndex = i;  // for test
#endif

      DWORD dwIndex = (DWORD)rand() % m_pPCSSRandom.Num();
      PCSentenceSyllable pTemp = ppss[i];
      ppss[i] = ppss[dwIndex];
      ppss[dwIndex] = pTemp;
   } // i
}


/*************************************************************************************
CTTSProsody::SentenceAdd - This adds a PCSentenceSyllable to the list.

inputs
   PCMLexicon              pLexTTS - Lexicon with phonemes in it
   PCSentenceSyllable      pss - Sentence to add. The actual object is taken
                              over by the CTTSProsody object.
   PCMLexicon              pLex - Lexicon that's used to determine the
                              word index numbers.
returns
   BOOL - TRUE if success
*/
BOOL CTTSProsody::SentenceAdd (PCMLexicon pLexTTS, PCSentenceSyllable pss, PCMLexicon pLex)
{
   // remap the words
   pss->RemapWords (pLex, m_pLexInProsody, TRUE, &m_lPCSentenceSyllable);

   // add
   m_lPCSentenceSyllable.Add (&pss);
   m_pPCSSRandom.Clear();
   
   return TRUE;
}

/*************************************************************************************
CTTSProsody::CompareSweepSequence - This finds all matches of this sentence in
the prosody test sentences. NOTE: The test sentences should have been Randomized().

inputs
   PCMLexicon     pLexTTS - Lexicon with phonemes in it
   PCOMPARESYLINFO pInfo - Score penalties to use.
   PCSentenceSyllable      pThis - Current sentence being tested. This does NOT
                           have extra punctuation added, NOR is it necessarily
                           in the same lexicon.
   int            iOffsetThis - offset, in syllables, into THIS sentence that
                     will be the start. Can be negative or beyond edge of sentence
   PCMLexicon     pLex - Lexicon that pThis uses
   PCListFixed    plBESTSENTSWEEP - This should be filled in with a set of
                     BESTSENTSWEEP that are already known for dwOffsetThis.
                     They should be in sorted order, from highest score to
                     lowest.
                     
                     If a candidate is already represented on
                     plBESTSENTSWEEP, AND the right dwOffset is there,
                     then this won't bother doing a sweep for it.

                     If a comparison is successful AND its score is better
                     than the worse score (or there are empty slots) then
                     it will be added.
   DWORD          dwSlots - Number of slots allowed in plBESTSENTSWEEP.
                     Basically, keep the best N of these.
   PCListFixed    plBESTSENTSWEEPExclude - If find a match for any of these
                     then don't bother adding them to plBESTSENTSWEEP.
                     Can be NULL.
returns
   none
*/
#define PUNCTEXTRA         2        // allow 2 extra slots for punctuation, to left and right
void CTTSProsody::CompareSweepSequence (PCMLexicon pLexTTS, PCOMPARESYLINFO pInfo, PCSentenceSyllable pThis, int iOffsetThis, PCMLexicon pLex,
                                      PCListFixed plBESTSENTSWEEP, DWORD dwSlots,
                                      PCListFixed plBESTSENTSWEEPExclude)
{
   // make a clone of the sentence, convert words, and add punctuation
   PCSentenceSyllable pClone = pThis->Clone();
   if (!pClone)
      return;
   pClone->RemapWords (pLex, m_pLexInProsody, FALSE, NULL);

   WORD wPeriod = (WORD) m_pLexInProsody->WordFind (L".");

#if 0 // no longer needed
   // potentially add functuation at end
   DWORD i, dwPunctAtEnd = 0;
   DWORD dwPunctWord = (DWORD)-1;
   for (i = pClone->m_dwNum-1; i < pClone->m_dwNum; i++)
      if (pClone->m_pabPOS[i] == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION)) {
         // if there is punctuation at end, also extend it a few more
         if (!dwPunctAtEnd)
            dwPunctWord = pClone->m_paSyl[i].wWord;
         dwPunctAtEnd ++;
      }
      else
         break;
   while (dwPunctAtEnd < PUNCTEXTRA) { // extra punctuation at end
      SENTSYLEMPH Emph;
      memset (&Emph, 0, sizeof(Emph));
      Emph.fDurPhone = Emph.fDurSyl = Emph.fPitch = Emph.fVolume = 1;
      pClone->Add (dwPunctWord, POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION), 0, &Emph, FALSE, 0, 0, 0, 0, 0);
      dwPunctAtEnd++;
   }
#endif

   // loop
   PCSentenceSyllable *ppss = (PCSentenceSyllable*)m_pPCSSRandom.Get(0);
   DWORD i;
   for (i = 0; i < m_pPCSSRandom.Num(); i++)
      pClone->CompareSweepSequence (pInfo, iOffsetThis, ppss[i], wPeriod, TRUE, plBESTSENTSWEEP, dwSlots, plBESTSENTSWEEPExclude);
   
   // clean up
   delete pClone;
}


// BEAMSEARCHHYP - Beam search hypothesis
#define BEAMSEARCHHYP_HISTORY       10     // remember 10 syllables back
#define BEAMSEARCHHYP_MAX           100   // maximum hypothesis to keep.
// #define BEAMSEARCHHYP_VERYBADSCORE  (BEAMSEARCHHYP_HISTORY * COMPARESINGLESYLLABLE_CROSSSENTENCEPENALTY)

typedef struct {
   DWORD       adwHistory[BEAMSEARCHHYP_HISTORY];  // history of the last 5 syllables, indecies into
                                                   // plSyl. Reverse order, so most recent is at [0]
   fp          fScore;                             // score. Lower is better
} BEAMSEARCHHYP, *PBEAMSEARCHHYP;


/*************************************************************************************
CompareSENTENCESYLLABLE - Compares two SENTENCESYLLABLE structures for
an "acoustic" distance.

inputs
   PSENTENCESYLLABLE pssThis - This one
   PSENTENCESYLLABLE pssTest - Test one
returns
   DWORD - Score. Higher is worse
*/

// #define MAXCOMPARESENTENCESYLLABLE     (256 * 6 + 256/4)      // maximum value that expect to get from CompareSENTENCESYLLABLE

#if 0 // old code
__inline DWORD CompareSENTENCESYLLABLE (PSENTENCESYLLABLE pssThis, PSENTENCESYLLABLE pssTest)
{
   return
#ifdef USEDURSYL
      (DWORD)abs((int)pssThis->bDurPhone - (int)pssTest->bDurPhone) +
      (DWORD)abs((int)pssThis->bDurSyl - (int)pssTest->bDurSyl) +
#else
      // BUGFIX - Since ignoring bDurSyl when synthesize now, since didn't sound as good,
      // make sure to double weight of bDurPhone, and ignore bDurSyl for this calculation
      (DWORD)abs((int)pssThis->bDurPhone - (int)pssTest->bDurPhone) * 2 +
#endif
      (DWORD)abs((int)pssThis->bPitch - (int)pssTest->bPitch) * 2 +  // emphasize pitch a bit more
      (DWORD)abs((int)pssThis->bVol - (int)pssTest->bVol) / 4 +   // BUGFIX - demphasize volume
      (DWORD)abs((int)pssThis->cPitchBulge - (int)pssTest->cPitchBulge) +
      (DWORD)abs((int)pssThis->cPitchSweep - (int)pssTest->cPitchSweep) +
      (DWORD)abs((int)pssThis->cDurSkew - (int)pssTest->cDurSkew)
      ;
}
#endif // 0

/*************************************************************************************
CTTSProsody::BeamSearchSwitchSentencePenalty - Figure out the penalty for
switching from one sentence to another.

inputs
   PCOMPARESYLINFO pInfo - Score penalties to use.
   PCSentenceSyllable      pssCur - Current sentence syllable
   int                     iOffsetCur - Offset into current sentence for the pre-switch syllable
   PCSentenceSyllable      pssTo - Switching to this sentenc syllable
   int                     iOffsetTo - Offset into To sentence, for the pre-switch syllable.
   WORD                    wPeriod - Definition of the period word, so sentence start/end match better
returns
   fp - Score to add
*/
fp CTTSProsody::BeamSearchSwitchSentencePenalty (PCOMPARESYLINFO pInfo, PCSentenceSyllable pssCur, int iOffsetCur,
                                                  PCSentenceSyllable pssTo, int iOffsetTo, WORD wPeriod)
{
#define SWITCHPENALTYDIST        3     // compare three syllables to left
   int iOffset;
   fp fSum = 0.0;
   for (iOffset = -SWITCHPENALTYDIST; iOffset < SWITCHPENALTYDIST; iOffset++) {
      fp fScore = pssCur->CompareSingleSyllable (pInfo, iOffsetCur + iOffset,
         pssTo, iOffsetTo + iOffset, wPeriod, TRUE, FALSE, FALSE);

      fp fWeight = SWITCHPENALTYDIST - abs(iOffset) + ((iOffset < 0) ? 1 : 0);
      fWeight /= (fp)SWITCHPENALTYDIST;   // so weight goes from 1.0 to 0.0

      fSum += fScore * fWeight;
   } // iOffset
   
   return fSum;

#if 0 // old code
   // return COMPARESINGLESYLLABLE_CROSSSENTENCEPENALTY * BEAMSEARCHSWITCHPENALTY;

   PSENTENCESYLLABLE psCur, psTo;
   SENTENCESYLLABLE sDefault;

   if (!pssCur || !pssTo) {
      memset (&sDefault, 0, sizeof(sDefault));
      sDefault.bPitch = 100;
      sDefault.bVol = 100;
      sDefault.bDurPhone = 100;
      sDefault.bDurSyl = 100;
      // NOTE: Don't bother with cDurSkew since defaults to 0
   }

   int i;
   int iErr = 0;
   int iErrWeight = 0;
   // loop over this syllable and the next one
   iOffsetCur--;  // so start before
   iOffsetTo--;
   for (i = 0; i < 4; i++, iOffsetCur++, iOffsetTo++) {
      int iWeight = ((i >= 1) && (i <= 2)) ? 2 : 1;
      iErrWeight += iWeight;

      // figure out the SENTENCESYLLABLE to use
      if (pssCur) {
         if ((iOffsetCur >= 0) && (iOffsetCur < (int) pssCur->m_dwNum)) {
            if ((pssCur->m_pabPOS[iOffsetCur] & 0x0f) == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION))
               psCur = NULL;  // since punctuation
            else
               psCur = &pssCur->m_paSyl[iOffsetCur];
         }
         else
            psCur = NULL;  // since beyond edge of setnence, so must be punctuation
      }
      else // default, so no real change
         psCur = &sDefault;

      if (pssTo) {
         if ((iOffsetTo >= 0) && (iOffsetTo < (int) pssTo->m_dwNum)) {
            if ((pssTo->m_pabPOS[iOffsetTo] & 0x0f) == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION))
               psTo = NULL;  // since punctuation
            else
               psTo = &pssTo->m_paSyl[iOffsetTo];
         }
         else
            psTo = NULL;  // since beyond edge of setnence, so must be punctuation
      }
      else // default, so no real change
         psTo = &sDefault;

      // see if either is NULL
      if (!psCur || !psTo) {
         // if both POS then no penalty
         if (!psCur && !psTo) {
            iErr += iWeight * MAXCOMPARESENTENCESYLLABLE / BEAMSEARCHSWITCHSENTENCEPENALTY_LESSFORPOS;
            continue;
         }

         // if only one POS then max penalty
         iErr += iWeight * MAXCOMPARESENTENCESYLLABLE;
         continue;
      }

      // else, add
      iErr += iWeight * (int) CompareSENTENCESYLLABLE (psCur, psTo);
   } // i

   // else, return comparison
   return iErr / iErrWeight;
#endif // 0
}

/*************************************************************************************
CTTSProsody::BeamSearch - This does a beam search through all the syllables,
looking for the highest score.

inputs
   PCOMPARESYLINFO pInfo - Score penalties to use.
   DWORD             dwThread - 0..MAXRAYTHREAD-1
   PCListFixed       plSyl - One entry per syllable (including PUNCTEXTRA at beginning
                        and end). Each entry is a PCListFixed of BESTSENTWEEP. Each
                        list MUST have at least one entry.
   fp                *pfScore - Filled in with the score of the match
   fp                fAccuracy - Use 1.0 for normal accuracy (10,000 units), 2.0 for higher, etc.
                        More accurate is slower
   DWORD             dwRandomness - How much to randomize the match. Defaults to 1. Use 2 if
                        doing multiple pass synthesis.
returns
   PCListFixed - List of BESTSENTWEEP structures. One entry per syllable in plSyl MINUS
         2 * PUNCTEXTRA, so extra punctation at start/end excluded.
         You must delete the returned list.
*/


static int _cdecl BEAMSEARCHHYPSortScore (const void *elem1, const void *elem2)
{
   BEAMSEARCHHYP *pdw1, *pdw2;
   pdw1 = (BEAMSEARCHHYP*) elem1;
   pdw2 = (BEAMSEARCHHYP*) elem2;

   if (pdw1->fScore > pdw2->fScore)
      return 1;
   else if (pdw1->fScore < pdw2->fScore)
      return -1;
   else
      return 0;
   // return (int)pdw1->iScore - (int)pdw2->iScore;
}



static int _cdecl BEAMSEARCHHYPSortMatch(const void *elem1, const void *elem2)
{
   BEAMSEARCHHYP *pdw1, *pdw2;
   pdw1 = (BEAMSEARCHHYP*) elem1;
   pdw2 = (BEAMSEARCHHYP*) elem2;

   int iRet = memcmp (&pdw1->adwHistory[0], &pdw2->adwHistory[0], sizeof(pdw1->adwHistory));
   if (iRet)
      return iRet;

   // else, compare by score
   if (pdw1->fScore > pdw2->fScore)
      return 1;
   else if (pdw1->fScore < pdw2->fScore)
      return -1;
   else
      return 0;
   // return (int)pdw1->iScore - (int)pdw2->iScore;
}

PCListFixed CTTSProsody::BeamSearch (PCOMPARESYLINFO pInfo, DWORD dwThread, PCListFixed plSyl, fp *pfScore, fp fAccuracy, DWORD dwRandomness)
{
#if 0 // def _DEBUG
   DWORD dwStartTime = GetTickCount();
#endif
   *pfScore = 0;
   // start out with a default hypothesis
   BEAMSEARCHHYP bsh;
   memset (&bsh, 0, sizeof(bsh));

   WORD wPeriod = (WORD) m_pLexInProsody->WordFind (L".");

   // ping-pong buffers
   CListFixed alPingPong[2];
   alPingPong[0].Init (sizeof(BEAMSEARCHHYP));
   alPingPong[1].Init (sizeof(BEAMSEARCHHYP));
   alPingPong[0].Add (&bsh);

   CListFixed lIndexToKeep;
   lIndexToKeep.Init (sizeof(DWORD));

   DWORD dwMaxHyp = (DWORD)((fp)BEAMSEARCHHYP_MAX * fAccuracy);

   // loop over all syllabled
   DWORD dwSyl, i;
   PCListFixed *ppl = (PCListFixed*)plSyl->Get(0);
   DWORD dwPingFrom, dwPingTo;
   PCListFixed plPingFrom, plPingTo;
   PBEAMSEARCHHYP pBSH;
   for (dwSyl = 0; dwSyl < plSyl->Num(); dwSyl++) {
      // what pingpong buffer from/to
      dwPingFrom = dwSyl % 2;
      dwPingTo = (dwSyl+1) %2;
      plPingFrom = &alPingPong[dwPingFrom];
      plPingTo = &alPingPong[dwPingTo];

      // sort by score
      qsort (plPingFrom->Get(0), plPingFrom->Num(), sizeof(BEAMSEARCHHYP), BEAMSEARCHHYPSortScore);

      // what is the index to use
      pBSH = (PBEAMSEARCHHYP) plPingFrom->Get(0);
      DWORD dwIndexToKeep = pBSH->adwHistory[BEAMSEARCHHYP_HISTORY-1];
      lIndexToKeep.Add (&dwIndexToKeep);

      // get rid of any results whose oldest match is NOT the same is the syllable
      // index to keep
      for (i = plPingFrom->Num()-1; i < plPingFrom->Num(); i--)
         if (pBSH[i].adwHistory[BEAMSEARCHHYP_HISTORY-1] != dwIndexToKeep) {
            plPingFrom->Remove (i);
            pBSH = (PBEAMSEARCHHYP) plPingFrom->Get(0);  // just in case changed
         }


      // if there are too many hypothesis then prune down
      if (plPingFrom->Num() > dwMaxHyp) {
         plPingFrom->Truncate (dwMaxHyp);
         pBSH = (PBEAMSEARCHHYP) plPingFrom->Get(0);  // just in case changed
      }

      // remove any score that's really bad
      for (i = 1; i < plPingFrom->Num(); i++)
         if (pBSH[i].fScore > pBSH[0].fScore + pInfo->fVeryBadScore)
            break;
      if (i < plPingFrom->Num()) {
         plPingFrom->Truncate (i);
         pBSH = (PBEAMSEARCHHYP) plPingFrom->Get(0);  // just in case changed
      }


#if 0 // never does anything so dont bother
      // get rid of any identical matches and keep the best score
      // NOTE: This code never seems to do anything, but it may not need to the way I'm eliminating
      // any hypothesis that don't match the best
      qsort (plPingFrom->Get(0), plPingFrom->Num(), sizeof(BEAMSEARCHHYP), BEAMSEARCHHYPSortMatch);
      for (i = plPingFrom->Num()-2; i < plPingFrom->Num(); i--) {
         if (pBSH[i].adwHistory[0] == pBSH[i+1].adwHistory[0])
            continue;   // different

         // else, the same, so keep the lower score
         if (pBSH[i].iScore <= pBSH[i+1].iScore)
            plPingFrom->Remove (i+1);
         else
            plPingFrom->Remove (i);
         pBSH = (PBEAMSEARCHHYP) plPingFrom->Get(0);  // just in case changed
      }
#endif

      // hypothesize
      plPingTo->Clear();
      PCListFixed plBESTSENTSWEEP = ppl[dwSyl];
      PBESTSENTSWEEP pBSS = (PBESTSENTSWEEP) plBESTSENTSWEEP->Get(0);

      fp fRandomAmount = pInfo->fRandomize * (fp) (1+dwRandomness) / 2.0;

      // add jitter so won't choose same result all the time
      for (i = 0; i < plBESTSENTSWEEP->Num(); i++)
         pBSS[i].afScoreSylWithRand[dwThread] = pBSS[i].fScoreSyl + randf(0.0, fRandomAmount);

      pBSH = (PBEAMSEARCHHYP) plPingFrom->Get(0);  // just in case changed

#if 0 // swap the loops to make faster
      for (i = 0; i < plPingFrom->Num(); i++, pBSH++) {
         int iScoreBase = pBSH->iScore;
         DWORD dwLastIndex = pBSH->adwHistory[0];
         PCListFixed plBESTSENTSWEEPLast = dwSyl ? ppl[dwSyl-1] : 0;
         PBESTSENTSWEEP pBSSLast = plBESTSENTSWEEPLast ? (PBESTSENTSWEEP) plBESTSENTSWEEPLast->Get(dwLastIndex) : NULL;

         // move all the bits up so can insert new
         memmove (&pBSH->adwHistory[1], &pBSH->adwHistory[0], sizeof(DWORD)*(BEAMSEARCHHYP_HISTORY-1));


         // loop over all indecies
         DWORD dwIndex;
         for (dwIndex = 0; dwIndex < plBESTSENTSWEEP->Num(); dwIndex++) {
            // hypothesize jumping to this index
            pBSH->adwHistory[0] = dwIndex;
            pBSH->iScore = iScoreBase + pBSS[dwIndex].iScoreSylWithRand;

            // penalty for switching sentences
            if (pBSSLast) {
               if ((pBSSLast->pSent != pBSS[dwIndex].pSent) || (pBSSLast->iOffsetTest+1 != pBSS[dwIndex].iOffsetTest))
                  pBSH->iScore += COMPARESINGLESYLLABLE_CROSSSENTENCEPENALTY;
               else
                  pBSH->iScore += 0;   // so can test a contiguous block
            }

            plPingTo->Add (pBSH);
         } // dwIndex
      } // i
#endif // 0

      // do a memmove for all existing hypothesis
      for (i = 0; i < plPingFrom->Num(); i++) {
         // move all the bits up so can insert new
         memmove (&pBSH[i].adwHistory[1], &pBSH[i].adwHistory[0], sizeof(DWORD)*(BEAMSEARCHHYP_HISTORY-1));
      } // i

      // swap the loops to make faster
      DWORD dwIndex;
      PCListFixed plBESTSENTSWEEPLast = dwSyl ? ppl[dwSyl-1] : 0;
      PBESTSENTSWEEP pBSSLast = plBESTSENTSWEEPLast ? (PBESTSENTSWEEP) plBESTSENTSWEEPLast->Get(0) : NULL;
      for (dwIndex = 0; dwIndex < plBESTSENTSWEEP->Num(); dwIndex++) {
         DWORD dwBestIndex = (DWORD)-1;
         fp fBestScore = 0;

         for (i = 0; i < plPingFrom->Num(); i++) {
            fp fScore = pBSH[i].fScore + pBSS[dwIndex].afScoreSylWithRand[dwThread];

            // penalty for switching sentences
            if (pBSSLast) {
               DWORD dwLastIndex = pBSH[i].adwHistory[1];
               if ((pBSSLast[dwLastIndex].pSent != pBSS[dwIndex].pSent) || (pBSSLast[dwLastIndex].iOffsetTest+1 != pBSS[dwIndex].iOffsetTest))
                  fScore += BeamSearchSwitchSentencePenalty (pInfo, pBSSLast[dwLastIndex].pSent, pBSSLast[dwLastIndex].iOffsetTest,
                     pBSS[dwIndex].pSent, pBSS[dwIndex].iOffsetTest-1, wPeriod); // / BEAMSEARCHSWITCHPENALTY;
               else
                  fScore += 0;   // so can test a contiguous block
            }

            // keep the best
            if ((dwBestIndex == (DWORD)-1) || (fScore < fBestScore)) {
               dwBestIndex = i;
               fBestScore = fScore;
            }
         } // i

         // add the best to the hypothesis
         if (dwBestIndex != (DWORD)-1) {
            pBSH[dwBestIndex].fScore = fBestScore;
            pBSH[dwBestIndex].adwHistory[0] = dwIndex;
            plPingTo->Add (&pBSH[dwBestIndex]);
         }
      } //dwIndex

   } // dwSyl

   // find the best result and keep that
   dwPingFrom = dwSyl % 2;
   plPingFrom = &alPingPong[dwPingFrom];
   qsort (plPingFrom->Get(0), plPingFrom->Num(), sizeof(BEAMSEARCHHYP), BEAMSEARCHHYPSortScore);
   pBSH = (PBEAMSEARCHHYP) plPingFrom->Get(0);
   for (i = BEAMSEARCHHYP_HISTORY-1; i < BEAMSEARCHHYP_HISTORY; i--)
      lIndexToKeep.Add (&pBSH->adwHistory[i]);  // so have it added to keep

   // create the list of BESTSENTSWEEP. Exclude zero's at beginning, as well as PUNCTEXTRA and beginning and end
   *pfScore = pBSH->fScore;
   PCListFixed plRet = new CListFixed;
   if (!plRet)
      return NULL;
   plRet->Init (sizeof(BESTSENTSWEEP));
   DWORD *padwIndexToKeep = (DWORD*)lIndexToKeep.Get(0);
   for (i = lIndexToKeep.Num() - plSyl->Num() + PUNCTEXTRA; i < lIndexToKeep.Num() - PUNCTEXTRA; i++) {
      int iSyl = (int)i - (int)(lIndexToKeep.Num() - plSyl->Num());
      if (iSyl < 0)
         continue;   // zero index

      PCListFixed plBESTSENTSWEEP = ppl[iSyl];
      PBESTSENTSWEEP pBSS = (PBESTSENTSWEEP) plBESTSENTSWEEP->Get(padwIndexToKeep[i]);

      plRet->Add (pBSS);
   } // i

#if 0 // def _DEBUG
   WCHAR szTemp[64];
   swprintf (szTemp, L"\r\nBeamSearch time=%d", (int)(GetTickCount() - dwStartTime));
   OutputDebugStringW (szTemp);
#endif

   // done
   return plRet;
}


/*************************************************************************************
CTTSProsody::BeamSearchHypToSentenceSyllable - This takes the output
from BeamSearch() and fills in a SentenceSyllable().

inputs
   PCListFixed       plBESTSENTSWEEP - List of BESTSENTSWEEP from BeamSearch().
returns
   PCSentenceSyllable - New sentence syllable object. It must be deleted by the
      caller
*/
PCSentenceSyllable CTTSProsody::BeamSearchHypToSentenceSyllable (PCListFixed plBESTSENTSWEEP)
{
   PBESTSENTSWEEP pBSS = (PBESTSENTSWEEP) plBESTSENTSWEEP->Get(0);
   DWORD dwNum = plBESTSENTSWEEP->Num();

   PCSentenceSyllable pSS = new CSentenceSyllable;
   if (!pSS)
      return NULL;

   DWORD i;
   for (i = 0; i < dwNum; i++, pBSS++) {
      PCSentenceSyllable pSent = pBSS->pSent;

      // if beyond edge then null.
      if ((pBSS->iOffsetTest < 0) || !pSent || (pBSS->iOffsetTest >= (int)pSent->m_dwNum)) {
         SENTSYLEMPH Emph;
         memset (&Emph, 0, sizeof(Emph));
         Emph.fPitch = Emph.fVolume = Emph.fDurPhone = Emph.fDurSyl = 1;
         // NOTE: Not modifying fDurSkew because should be 0

         pSS->Add (
            (DWORD)-1, 
            POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION),
            0, // sylindex
            0, // rule depth
            &Emph, FALSE,
            0, // NOTE: with punctuation must be syllable 0 and no phonemes
            0, // NOTE: With functuation, always in most common "words"
            0,
            0);
         continue;
      }

      pSS->Append (pSent, (DWORD)pBSS->iOffsetTest, (DWORD)pBSS->iOffsetTest+1);
   } // i

   return pSS;
}


/*************************************************************************************
CTTSProsody::SentenceSyllablesCombineWithProsody - Combine one or more
sentence syllables together, and add generic prosody rules.

inputs
   PCMLexicon              pLexTTS - Lexicon with phonemes in it
   PCSentenceSyllable      pThis - Should be the same length as the sentences
                           to average. Will be modified in place, so can
                           be returned from FindBestMatch. Should already have POS
                           properly filled in. (Basically, passed in through
                           FindBestMatch())
   PCSentenceSyllable      *papSS - Pointer to an array of sentence syllables to combine
   DWORD                   dwNumSent - Number to combine
   PCMLexicon     pLex - Lexicon that pThis uses
   CTTSProsody    **ppCTTSProsody - This of prosody objects to use for the comparison,
                  including this one.
   DWORD          dwNum - Number of prosody objects to use. Must be at least one
returns
   none... although it changes the values. NOTE: bPauseProb will be filled with 0..15,
      where 0 is no microsilnece, 15 is always microsilence
*/

#define RELATIVEPITCHWEIGHT   0.5   // how much to weight the relative pitch with absolute pitch
#define RPWINDOWSIZE       40       // filter window size, in syllables, to prevent too great a pitch change

void CTTSProsody::SentenceSyllablesCombineWithProsody (PCMLexicon pLexTTS, PCSentenceSyllable pThis,
                                                       PCSentenceSyllable *papSS, DWORD dwNumSent,
                                                       PCMLexicon pLex,
                                 CTTSProsody **ppCTTSProsody, DWORD dwNum)
{
   // just to test, make sure have right number of words
   if (pThis->m_dwNum != papSS[0]->m_dwNum)
      return;  // error

   // now that have a lot of templates for each word, blend them all together, weighting
   // by the dwscore... that way, if there are bad recordings, they will tend to be
   // counteracted by having lots of data

   DWORD i, j;

   // loop through and blend the results of the best ones
   CMem memRelative;
   SYLEMPH Emph;
   fp fWeight;
   fp fMicroSilence, fMicroSilenceSum;
   if (!memRelative.Required (pThis->m_dwNum * sizeof(fp) * 3))
      return;  // not likely to happen
   fp *pafRelative = (fp*)memRelative.p;
   fp *pafRelativeSum = pafRelative + pThis->m_dwNum;
   fp *pafFilter = pafRelativeSum + pThis->m_dwNum;
   memset (pafRelative, 0, pThis->m_dwNum * sizeof(fp) * 3);
   fp fPitchAverage = 0;

#if 0 // to test
#ifdef _DEBUG
   FILE *file = fopen ("c:\\test.txt", "wt");
#else
   FILE *file = fopen ("c:\\testr.txt", "wt");
#endif
#endif // 0

   // look ahead and determine the word parts of speech
   BYTE abNGramPOS[4];
   DWORD dwNextPOSSyl = 0;
   for (j = 0; j < 4; j++) {
      if (j < 3) {
         abNGramPOS[j] = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
         continue;
      }

      for ( ; (dwNextPOSSyl < pThis->m_dwNum) && !pThis->IsStartOfWord(dwNextPOSSyl); dwNextPOSSyl++);

      if (dwNextPOSSyl < pThis->m_dwNum) {
         abNGramPOS[j] = pThis->m_pabPOSStress[dwNextPOSSyl] & 0x0f;
         dwNextPOSSyl++;
      }
      else
         abNGramPOS[j] = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);   // beyond the end
   }

   // figure out which subsentence a word is in, and what the index is, as well as how long the subsentence is
   CListFixed lFBMSUBSENT;
   FBMSUBSENT fss;
   FBMSUBSENT *pfss;
   lFBMSUBSENT.Init (sizeof(FBMSUBSENT));
   WORD wPeriod = (WORD) m_pLexInProsody->WordFind (L".");
   WORD wQuestion = (WORD) m_pLexInProsody->WordFind (L"?");
   WORD wExclamation = (WORD) m_pLexInProsody->WordFind (L"!");
   DWORD dwSubSentence = 0;
   DWORD dwIndex = 0;
   DWORD dwSentenceType = TYPICALSYLINFO_STATEMENT;
   for (i = 0; i < pThis->m_dwNum; i++) {
      if ( ((pThis->m_pabPOSStress[i] & 0x0f) == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION)) ) {
         // if it's a sentence boundary then set some stuff
         if (
            (pThis->m_paSyl[i].wWord != (WORD)-1) &&
            ( (pThis->m_paSyl[i].wWord == wPeriod) || (pThis->m_paSyl[i].wWord == wQuestion) || (pThis->m_paSyl[i].wWord == wExclamation) ) ) {

               // loop back over everything have written for this sentence and change the subsentence
               if (pThis->m_paSyl[i].wWord == wQuestion)
                  dwSentenceType = TYPICALSYLINFO_QUESTION;
               else if (pThis->m_paSyl[i].wWord == wExclamation)
                  dwSentenceType = TYPICALSYLINFO_EXCLAMATION;
               pfss = (PFBMSUBSENT) lFBMSUBSENT.Get(0);
               for (j = 0; j < lFBMSUBSENT.Num(); j++, pfss++)
                  if (pfss->dwSubSentence == dwSubSentence)
                     pfss->dwSentenceType = dwSentenceType;

               dwSubSentence++;
               dwIndex = 0;

               // revert
               dwSentenceType = TYPICALSYLINFO_STATEMENT;;
            };

   
         fss.dwIndex = fss.dwSubSentenceLength = 0;
         fss.dwSubSentence = (DWORD)-1;
         fss.dwSentenceType = dwSentenceType;
         lFBMSUBSENT.Add (&fss);

         // ignore punctuation
         continue;
      }

      // else, add
      fss.dwSubSentenceLength = 0;
      fss.dwSubSentence = dwSubSentence;
      fss.dwIndex = dwIndex;
      fss.dwSentenceType = dwSentenceType;
      dwIndex++;
      lFBMSUBSENT.Add (&fss);
   } // i

   // go back over and calculate total length
   pfss = (PFBMSUBSENT) lFBMSUBSENT.Get(0);
   for (i = 0; i < lFBMSUBSENT.Num(); i++) {
      if (pfss[i].dwSubSentence == (DWORD)-1)
         continue;

      if (pfss[i].dwSubSentenceLength)
         continue;   // length already calculated

      DWORD dwCount  = 0;
      for (j = i; j < lFBMSUBSENT.Num(); j++)
         if (pfss[i].dwSubSentence == pfss[j].dwSubSentence)
            dwCount++;
      for (j = i; j < lFBMSUBSENT.Num(); j++)
         if (pfss[i].dwSubSentence == pfss[j].dwSubSentence)
            pfss[j].dwSubSentenceLength = dwCount;
   }

   PSENTENCESYLLABLE pss;
   PROSODYTREND ProsTrend;
   CMem memTYPICALSYLINFO;
   PTYPICALSYLINFO paTSI = NULL;
   DWORD dwWordStart = 0;
   DWORD dwSyllables = 0;
   for (i = 0; i < pThis->m_dwNum; i++) {
      // if its a new word then shift NGram and add
      if (pThis->IsStartOfWord(i)) {
         dwWordStart = i;
         memmove (abNGramPOS, abNGramPOS+1, sizeof(abNGramPOS)-sizeof(BYTE));

         // find the next POS
         for ( ; (dwNextPOSSyl < pThis->m_dwNum) && !pThis->IsStartOfWord(dwNextPOSSyl); dwNextPOSSyl++);

         // get the prosody info
         dwSyllables = dwNextPOSSyl - i;

         size_t dwNeed = sizeof(TYPICALSYLINFO) * dwSyllables;
         if (!memTYPICALSYLINFO.Required (dwNeed))
            paTSI = NULL;
         else
            paTSI = (PTYPICALSYLINFO) memTYPICALSYLINFO.p;
         if (paTSI) {
            DWORD dwStressBitsMulti = 0;
            DWORD dwScale = 1;
            for (j = 0; j < dwSyllables; j++, dwScale *= pLexTTS->Stresses())
               dwStressBitsMulti += (DWORD)((pThis->m_pabPOSStress[j+1] >> 4) & 0x0f) * dwScale;
               // if (pThis->m_pabPOS[j+i] & 0x80)
               //   dwStressBits |= (1 << j);

            PCWSTR pszWord = NULL;
            WCHAR szWord[256];
            if ((pThis->m_paSyl[i].wWord != (WORD)-1) && pLexTTS) {
               if (m_pLexInProsody->WordGet (pThis->m_paSyl[i].wWord, szWord, sizeof(szWord), NULL))
                  pszWord = szWord;
            }
            if (!WordSylGetTYPICALSYLINFO (pLexTTS, pszWord, pThis->m_pabPOSStress[i] & 0x0f, dwSyllables, dwStressBitsMulti, ppCTTSProsody, dwNum, paTSI))
               paTSI = NULL;
         }

         if (dwNextPOSSyl < pThis->m_dwNum) {
            abNGramPOS[3] = pThis->m_pabPOSStress[dwNextPOSSyl] & 0x0f;
            dwNextPOSSyl++;
         }
         else
            abNGramPOS[3] = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);   // beyond the end
      } // if new word

      // do a weighted sum of all the surrounding bits
      memset (&Emph, 0, sizeof(Emph));
      fMicroSilence = fMicroSilenceSum = 0;


      // blend the elements in the stack
      for (j = 0; j < dwNumSent; j++) {
         fWeight = 1.0; // equal blend

         // else, add, weighting the scores of the blend
         int iOffsetTemp = i;
         PCSentenceSyllable pSent = papSS[j];

         pss = pSent->m_paSyl + iOffsetTemp;

         memset (&ProsTrend, 0, sizeof(ProsTrend));

#ifdef USEPROSODYTREND // don't call ProsodyTrend() because prosody incorporated earlier so better comparisons
         // determine the prosody trend
         ProsodyTrend (
            pSent->m_pabPOS[iOffsetTemp], pSent->m_pabRuleDepth[iOffsetTemp],
            pThis->m_pabPOS[i], pThis->m_pabRuleDepth[i],
            &ProsTrend,
            ppCTTSProsody, dwNum);
#endif

         Emph.Emph.fPitch +=
            ( log((fp)pss->bPitch / 100.0) + (fp)ProsTrend.iPitch / (fp)100.0 * log((fp)2) ) * fWeight;
         Emph.Emph.fPitchSweep +=
            ( (fp)pss->cPitchSweep / 100.0 + (fp)ProsTrend.iPitchSweep / 100.0 ) * fWeight;
         Emph.Emph.fPitchBulge +=
            ( (fp)pss->cPitchBulge / 100.0 + (fp)ProsTrend.iPitchBulge / 100.0 ) * fWeight;
         Emph.Emph.fVolume +=
            ( log((fp)pss->bVol / 100.0) + (fp)ProsTrend.iVol / (fp)50.0 * log((fp)2) ) * fWeight;
         Emph.Emph.fDurPhone +=
            ( log((fp)pss->bDurPhone / 100.0) + (fp)ProsTrend.iDurPhone / (fp)50.0 * log((fp)2) ) * fWeight;
         Emph.Emph.fDurSyl +=
            ( log((fp)pss->bDurSyl / 100.0) + (fp)ProsTrend.iDurSyl / (fp)50.0 * log((fp)2) ) * fWeight;
         Emph.Emph.fDurSkew +=
            ( (fp)pss->cDurSkew / 100.0 + (fp)ProsTrend.iDurSkew / 100.0 ) * fWeight;
         Emph.fMultiMisc += fWeight;

         // BUGFIX - look at the POS for only the first syllable to see if should include
         BYTE bSylIndex = pSent->m_pabSylIndex[iOffsetTemp];
            // NOTE: Ignoring blending of bRuleDepth
         if (!(bSylIndex & 0x7)) {
            // this is the start of a word
            fMicroSilenceSum += fWeight;
            fMicroSilence += fWeight * (fp)(pss->bPauseProb & 0x0f) / 15.0;
         }

         // if there's a previous word, and its pitch isnt' 0, and this one's
         // pithc isn't 0, then determine relative pitch
         if (iOffsetTemp && pss->bPitch && pss[-1].bPitch) {
            pafRelative[i] +=
               ( log((fp)pss->bPitch / (fp)pss[-1].bPitch) + (fp)ProsTrend.iPitchRelative / (fp)100.0 * log((fp)2) ) * fWeight;

            // NOTE: ProsTrend.iPitchRelative will never get used, even when call ProsodyTrend() previously,
            // but should be ok because implicitely included

#ifdef NOMODS_DISABLERESIDUAL  // so no relative pitch component for test
            pafRelative[i] = 0;
#endif // _DEBUG

            // BUGFIX - Was just afRelativeSum, but should be pafRelativeSum
            pafRelativeSum[i] += fWeight;
         }
      } // j, over templates for the word

      // if there's no weight then make a neutral case
      if (Emph.fMultiMisc) {
         fp fScale = 1.0 / Emph.fMultiMisc;

         Emph.Emph.fPitch = exp(Emph.Emph.fPitch * fScale);
         Emph.Emph.fPitchSweep *= fScale;
         Emph.Emph.fPitchBulge *= fScale;
         Emph.Emph.fVolume = exp(Emph.Emph.fVolume * fScale);
         Emph.Emph.fDurPhone = exp(Emph.Emph.fDurPhone * fScale);
         Emph.Emph.fDurSyl = exp(Emph.Emph.fDurSyl * fScale);
         Emph.Emph.fDurSkew *= fScale;

         if (fMicroSilenceSum)
            fMicroSilence = fMicroSilence / fMicroSilenceSum;
         else
            fMicroSilence = 0.0;
         //if (fMicroSilence > fMicroSilenceSum * fMicroPauseThreshhold)
         //   fMicroSilence = TRUE;
         //else
         //   fMicroSilence = FALSE;
      }
      else {
         Emph.Emph.fPitchSweep = 0;
         Emph.Emph.fPitchBulge = 0;
         Emph.Emph.fDurSkew = 0;
         Emph.Emph.fPitch = Emph.Emph.fVolume = Emph.Emph.fDurPhone = Emph.Emph.fDurSyl = 1;
         fMicroSilence = 0.0;   // no microsilnce
      }

#ifdef NOMODS_DISABLERESIDUAL  //  zero out to test typical info
      Emph.Emph.fPitchSweep = 0;
      Emph.Emph.fPitchBulge = 0;
      Emph.Emph.fDurSkew = 0;
      Emph.Emph.fPitch = Emph.Emph.fVolume = Emph.Emph.fDurPhone = Emph.Emph.fDurSyl = 1;
#endif

      // restore typical info
      fp fWeightCur = pafRelativeSum[i];
      if (!fWeightCur)
         fWeightCur = 1;

#ifndef NOMODS_DISABLETYPICALSYLINFO
      if (pfss[i].dwSubSentence != (DWORD)-1) {
         TYPICALSYLINFO TSI, TSILast;
         TypicalSylInfoGet (pfss[i].dwSentenceType, pfss[i].dwIndex, pfss[i].dwSubSentenceLength, ppCTTSProsody, dwNum, &TSI);
         BOOL fUseRelative = (i && (pfss[i-1].dwSubSentence != (DWORD)-1));
         if (fUseRelative)
            TypicalSylInfoGet (pfss[i-1].dwSentenceType, pfss[i-1].dwIndex, pfss[i-1].dwSubSentenceLength, ppCTTSProsody, dwNum, &TSILast);

         if (TSI.fCount) {
            Emph.Emph.fPitch *= exp(TSI.fPitchSum / TSI.fCount);
            Emph.Emph.fVolume *= exp(TSI.fVolumeSum / TSI.fCount);
            Emph.Emph.fDurPhone *= exp(TSI.fDurPhoneSum / TSI.fCount);
            Emph.Emph.fDurSyl *= exp(TSI.fDurSylSum / TSI.fCount);
            Emph.Emph.fDurSkew += TSI.fDurSkewSum / TSI.fCount;
            Emph.Emph.fPitchBulge += TSI.fPitchBulgeSum / TSI.fCount;
            Emph.Emph.fPitchSweep += TSI.fPitchSweepSum / TSI.fCount;

            // relative
            if (fUseRelative && TSI.fCount && TSILast.fCount) {
               fWeight = fWeightCur;
               pafRelative[i] += ((TSI.fPitchSum / TSI.fCount) - (TSILast.fPitchSum / TSILast.fCount)) * fWeight;
               pafRelativeSum[i] += fWeight;
            }
         }
      } // typical info
#endif // DISABLETYPICALSYLINFO

#ifndef NOMODS_DISABLEWORDSYL
      if ((pfss[i].dwSubSentence != (DWORD)-1) && (i >= dwWordStart) && (i < dwWordStart + dwSyllables)) {
         // already have the syllable info in paTSI
         PTYPICALSYLINFO pTSI = paTSI + (i - dwWordStart);

         // know that pTSI->fCount == 1
         Emph.Emph.fPitch *= exp(pTSI->fPitchSum);
         Emph.Emph.fVolume *= exp(pTSI->fVolumeSum);
         Emph.Emph.fDurPhone *= exp(pTSI->fDurPhoneSum);
         Emph.Emph.fDurSyl *= exp(pTSI->fDurSylSum);
         Emph.Emph.fDurSkew += pTSI->fDurSkewSum;
         Emph.Emph.fPitchBulge += pTSI->fPitchBulgeSum;
         Emph.Emph.fPitchSweep += pTSI->fPitchSweepSum;

         // NOTE: NOT doing relative for individual words because no way to get equivalent
         // of TSILast for previous word
      }
#endif

      // include prosody ngram
#ifndef NOMODS_DISABLEPROSODYNGRAM
      if (pfss[i].dwSubSentence != (DWORD)-1) {
         TYPICALSYLINFO TSI, TSILast;
         ProsodyNGramInfoGet (pThis->m_pabPOS, pThis->m_dwNum, i, ppCTTSProsody, dwNum, &TSI);
         BOOL fUseRelative = (i && (pfss[i-1].dwSubSentence != (DWORD)-1));
         if (fUseRelative)
            ProsodyNGramInfoGet (pThis->m_pabPOS, pThis->m_dwNum, i - 1, ppCTTSProsody, dwNum, &TSILast);

         if (TSI.fCount) {
            Emph.Emph.fPitch *= exp(TSI.fPitchSum / TSI.fCount);
            Emph.Emph.fVolume *= exp(TSI.fVolumeSum / TSI.fCount);
            Emph.Emph.fDurPhone *= exp(TSI.fDurPhoneSum / TSI.fCount);
            Emph.Emph.fDurSyl *= exp(TSI.fDurSylSum / TSI.fCount);
            Emph.Emph.fDurSkew += TSI.fDurSkewSum / TSI.fCount;
            Emph.Emph.fPitchBulge += TSI.fPitchBulgeSum / TSI.fCount;
            Emph.Emph.fPitchSweep += TSI.fPitchSweepSum / TSI.fCount;

            // relative
            if (fUseRelative && TSI.fCount && TSILast.fCount) {
               fWeight = fWeightCur;
               pafRelative[i] += ((TSI.fPitchSum / TSI.fCount) - (TSILast.fPitchSum / TSILast.fCount)) * fWeight;
               pafRelativeSum[i] += fWeight;
            }
         }
      } // prosody NGram
#endif

      // write the values in
      pss = pThis->m_paSyl + i;

      // store this away
      fp f;
      f = Emph.Emph.fPitch * 100.0;
      f = max(f, 25);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 254);  // dont be too restrtive.. and shouldnt happen anyway
      pss->bPitch = (BYTE)(f+0.5);

      f = Emph.Emph.fPitchSweep * 100.0;
      f = max(f, -126);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 126);  // dont be too restrtive.. and shouldnt happen anyway
      pss->cPitchSweep = (char)(int)floor(f+0.5);

      f = Emph.Emph.fPitchBulge * 100.0;
      f = max(f, -126);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 126);  // dont be too restrtive.. and shouldnt happen anyway
      pss->cPitchBulge = (char)(int)floor(f+0.5);

      f = Emph.Emph.fVolume * 100.0;
      f = max(f, 25);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 254);  // dont be too restrtive.. and shouldnt happen anyway
      pss->bVol = (BYTE)(f+0.5);

      f = Emph.Emph.fDurPhone * 100.0;
      f = max(f, 25);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 254);  // dont be too restrtive.. and shouldnt happen anyway
      pss->bDurPhone = (BYTE)(f+0.5);

      f = Emph.Emph.fDurSyl * 100.0;
      f = max(f, 25);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 254);  // dont be too restrtive.. and shouldnt happen anyway
      pss->bDurSyl = (BYTE)(f+0.5);

      f = Emph.Emph.fDurSkew * 100.0;
      f = max(f, -126);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 126);  // dont be too restrtive.. and shouldnt happen anyway
      pss->cDurSkew = (char)(int)floor(f+0.5);

      // given the part of speech, determine the location in the N gram
      // average the N-gram probability in with the value that have stored
      fp fPauseNGram = PauseNGram (pLexTTS, abNGramPOS[0], abNGramPOS[1], abNGramPOS[2], abNGramPOS[3],
         ppCTTSProsody, dwNum);
      if (fPauseNGram >= 0)
         fMicroSilence = (fMicroSilence + fPauseNGram) / 2.0;


      // NOTE: bPauseProb used as microsilnce value... if 0 NEVER insert, if 15 always insert
      fMicroSilence = max(fMicroSilence, 0);
      fMicroSilence = min(fMicroSilence, 1);
      pss->bPauseProb = (BYTE)(fMicroSilence*15.0 + 0.5);   // 0..15 only

      // scale sum
      if (pafRelativeSum[i])
         pafRelative[i] /= pafRelativeSum[i];
      if (i)
         pafRelative[i] += pafRelative[i-1]; // so pitch achored from previous pitch
      else
         pafRelative[i] = 0;  // no relative pitch for first entry
      fPitchAverage += pafRelative[i]; // so cancalulate the average
   } // i

   // loop through all the pitch scale values and make sure average is 0
   fPitchAverage /= (fp)max(pThis->m_dwNum,1);
   fp f, fSum;
   for (i = 0; i < pThis->m_dwNum; i++)
      pafRelative[i] -= fPitchAverage; // so average around speakingpitch

   // filter so there isn't too much of a pitch delta
   for (i = 0; i < pThis->m_dwNum; i++) {
      int iWindow, iCur;
      f = fSum = 0;
      for (iWindow = -(RPWINDOWSIZE/2); iWindow <= (RPWINDOWSIZE/2); iWindow++) {
         iCur = iWindow + (int)i;
         if ((iCur < 0) || (iCur >= (int)pThis->m_dwNum))
            continue;

         fWeight = RPWINDOWSIZE/2 - abs(iWindow) + 1;
         f += fWeight;
         fSum += pafRelative[iCur] * fWeight;
      } // iCur

      if (f)
         fSum /= f;
      pafFilter[i] = fSum;
   } // i 

   
   // recobine into main pitch
   for (i = 0; i < pThis->m_dwNum; i++) {
      f = pafRelative[i] - pafFilter[i]; // so average around speakingpitch
      f = exp(f); // so no longer log
      f *= 100.0; // sine 100 is typical value

      pss = pThis->m_paSyl + i;
      f = RELATIVEPITCHWEIGHT * f + (1.0 - RELATIVEPITCHWEIGHT) * (fp)pss->bPitch;
      f = max(f,25);
      f = min(f,255);
      pss->bPitch = (BYTE) f;
   } // i
}


/*************************************************************************************
CTTSProsody::EscMultiThreadedCallback - Standard call
*/
void CTTSProsody::EscMultiThreadedCallback (PVOID pParams, DWORD dwParamSize, DWORD dwThread)
{
   DWORD *padw = (DWORD*)pParams;
   DWORD dwStart = padw[0];
   DWORD dwEnd = padw[1];
   DWORD dwType = padw[2];
   // DWORD i; //, j;

   switch (dwType) {
   case 100: // Sentence match
      {
         PEMTSENTENCEMATCH pe = (PEMTSENTENCEMATCH) pParams;
         PCListFixed plPCSentenceMatch = pe->plPCSentenceMatch;
         PCSentenceSyllable pSS = pe->pSS;
         CTTSProsody **ppCTTSProsody = pe->ppCTTSProsody;
         DWORD dwNum = pe->dwNum;
         PCOMPARESYLINFO pInfo = pe->pInfo;
         int iTTSQuality = pe->iTTSQuality;
         WORD wPeriod = pe->wPeriod;
         DWORD dwMultiPass = pe->dwMultiPass;
         BOOL fWord = pe->fWord;
         PCMLexicon pLexTTS = pe->pLexTTS;

         DWORD dwBeam;

         // since using rand, and rand per thread, create a sizeed based on the time and dwStart
         srand (GetTickCount() + dwStart * 1234 + dwMultiPass * 4321);

         for (dwBeam = dwStart; dwBeam < dwEnd; dwBeam++) {
            PCSentenceMatch pSM = *((PCSentenceMatch*)plPCSentenceMatch->Get(dwBeam));

#ifdef TURNOFFRANDOM
            // to make reproducable must random seed based on beam
            srand (pSM->m_iStart + 1000 * pSM->m_iEnd + dwMultiPass * 4321);
#endif

            // compare
            pSM->m_fSuccess = pSM->FindAndScoreMatches (pLexTTS, pInfo, pSS, ppCTTSProsody, dwNum, iTTSQuality, fWord, wPeriod);

         } // dwBeam

      }
      return;

#ifdef TEMPLATEPROOSDYMODEL
   case 20: // prosody beam search
      _ASSERTE (FALSE);
      return;
#else
      not tested with changes for chinese stresses
   case 20: // prosody beam search
      {
         PEMTFINDBESTMATCH pe = (PEMTFINDBESTMATCH) pParams;

         PCListFixed plPerSyl = pe->plPerSyl;
         fp fAccuracy = pe->fAccuracy;
         DWORD dwRandomness = pe->dwRandomness;
         PCSentenceSyllable pThis = pe->pThis;
         CTTSProsody **ppCTTSProsody = pe->ppCTTSProsody;
         DWORD dwNum = pe->dwNum;
         PCListFixed plBEAMDIFFERENCE = pe->plBEAMDIFFERENCE;
         PCOMPARESYLINFO pInfo = pe->pInfo;
         DWORD dwMultiPass = pe->dwMultiPass;
         PCMLexicon pLexTTS = pe->pLexTTS; 


         DWORD dwBeam;
         PROSODYTREND ProsTrend;
         BEAMDIFFERENCE bd, bdBlank;
         memset (&bd, 0, sizeof(bd));
         memset (&bdBlank, 0, sizeof(bdBlank));

         // since using rand, and rand per thread, create a sizeed based on the time and dwStart
         srand (GetTickCount() + dwStart * 1234 + dwMultiPass * 4321);

         for (dwBeam = dwStart; dwBeam < dwEnd; dwBeam++) {

#ifdef TURNOFFRANDOM
            // to make reproducable must random seed based on beam
            srand (dwBeam + dwMultiPass * 4321);
#endif

            // do a beam search to find the best
            fp fScoreBeamSearch;
            PCListFixed plBeamSearch;
            plBeamSearch = BeamSearch (pInfo, dwThread, plPerSyl, &fScoreBeamSearch, fAccuracy, dwRandomness);
            // NOTE: Should ALWAYS have something, unless ran out of memory
            if (!plBeamSearch)
               continue;

            // convert the info to a sentnece syllable
            PCSentenceSyllable pSSBeam = BeamSearchHypToSentenceSyllable (plBeamSearch);
            if (!pSSBeam) {
               delete plBeamSearch;
               continue;
            }

            // apply some prosody fine-tuning to this so more accurate
            for (i = 0; i < pSSBeam->m_dwNum; i++) {
               ProsodyTrend (pLexTTS,
                  pSSBeam->m_pabPOSStress[i], pSSBeam->m_pabSylIndex[i], pSSBeam->m_pabRuleDepth[i],
                  pThis->m_pabPOSStress[i], pThis->m_pabSylIndex[i], pThis->m_pabRuleDepth[i],
                  &ProsTrend,
                  ppCTTSProsody, dwNum);

               // incorporate this prosdy trend in
               PSENTENCESYLLABLE pss = &pSSBeam->m_paSyl[i];
               fp f;
               int iSum;

               // pitch
               f = (fp)pss->bPitch * pow (2.0, (fp)ProsTrend.iPitch / 100.0);
               f = max(f, 0);
               f = min(f, 255);
               pss->bPitch = (BYTE) f;

               // pitch sweep
               iSum = (int)pss->cPitchSweep + ProsTrend.iPitchSweep;
               iSum = max(iSum, -127);
               iSum = min(iSum, 127);
               pss->cPitchSweep = (char)iSum;

               // pitch bulge
               iSum = (int)pss->cPitchBulge + ProsTrend.iPitchBulge;
               iSum = max(iSum, -127);
               iSum = min(iSum, 127);
               pss->cPitchBulge = (char)iSum;

               // volume
               f = (fp)pss->bVol * pow (2.0, (fp)ProsTrend.iVol / 50.0);
               f = max(f, 0);
               f = min(f, 255);
               pss->bVol = (BYTE) f;

               // dur phone
               f = (fp)pss->bDurPhone * pow (2.0, (fp)ProsTrend.iDurPhone / 50.0);
               f = max(f, 0);
               f = min(f, 255);
               pss->bDurPhone = (BYTE) f;

               // dur syl
               f = (fp)pss->bDurSyl * pow (2.0, (fp)ProsTrend.iDurSyl / 50.0);
               f = max(f, 0);
               f = min(f, 255);
               pss->bDurSyl = (BYTE) f;

               // pitch sweep
               iSum = (int)pss->cDurSkew + ProsTrend.iDurSkew;
               iSum = max(iSum, -127);
               iSum = min(iSum, 127);
               pss->cDurSkew = (char)iSum;

            } // i

            bd.pSS = pSSBeam;
            bd.fScore = fScoreBeamSearch;

            EnterCriticalSection (&m_csProsody);

            // BUGFIX - Need to write them into plBEAMDIFFERENCE in the order of
            // dwBeam so can be reproducible in debug
            while (plBEAMDIFFERENCE->Num() <=dwBeam)
               plBEAMDIFFERENCE->Add (&bdBlank);

            PBEAMDIFFERENCE pFill = (PBEAMDIFFERENCE) plBEAMDIFFERENCE->Get(dwBeam);
            *pFill = bd;
            // plBEAMDIFFERENCE->Add (&bd);

         #ifdef _DEBUG
            PBESTSENTSWEEP pBSS;
            // display the beam search
            WCHAR szTemp[256];
            swprintf (szTemp, L"\r\nBeamSearch score=%g: ", (double)fScoreBeamSearch);
            OutputDebugStringW (szTemp);
            pBSS = (PBESTSENTSWEEP) plBeamSearch->Get(0);
            for (i = 0; i < plBeamSearch->Num(); i++) {
               // if changed sentences then display new one
               if (!i || (pBSS[i-1].pSent != pBSS[i].pSent) ) {
                  swprintf (szTemp, L" [New sent = %x]", (int)(__int64)pBSS[i].pSent);
                  OutputDebugStringW (szTemp);
               }

               // show the number and the score
               swprintf (szTemp, L"%d (score=%g) ", (int)pBSS[i].iOffsetTest, (double)pBSS[i].fScoreSyl);
               OutputDebugStringW (szTemp);
            } // i
         #endif

            LeaveCriticalSection (&m_csProsody);

            delete plBeamSearch;
         } // dwBeam      
      }
      return;
#endif

   } // switch
}


/*************************************************************************************
CTTSProsody::BeamSearchMatches - This does a beam search using sentence matches.

inputs
   PCMLexicon     pLexTTS - Lexicon with phonemes
   PCOMPARESYLINFO pInfo - Score penalties to use.
   PCSentenceSyllable      pThis - Current sentence being tested. This does NOT
                           have extra punctuation added, NOR is it necessarily
                           in the same lexicon.
   PCMLexicon     pLex - Lexicon that pThis uses
   CTTSProsody    **ppCTTSProsody - This of prosody objects to use for the comparison,
                  including this one.
   DWORD          dwNum - Number of prosody objects to use. Must be at least one
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL           fWord - if TRUE then making sure the word-based sentences are used.
                     If FALSE, then syllable-based sentences
   fp             fAccuracy - How accurate to make the calculations. 1.0 = 10K units, 2.0 = 100K units, etc.
   DWORD          dwRandomness - Use 1 for normal amount of random. 2 for very random prosody, used
                     with multipass TTS to maximize acoustic scores
   DWORD                dwMultiPass - Pass number when generating several different versions of the
                        same sentence, and selecting the best one for TTS. Used to make the
                        random work better.

returns
   BOOL - TRUE if success
*/

static int _cdecl PCTTSProsodyMatchHypSort (const void *elem1, const void *elem2)
{
   PCTTSProsodyMatchHyp *pdw1, *pdw2;
   pdw1 = (PCTTSProsodyMatchHyp*) elem1;
   pdw2 = (PCTTSProsodyMatchHyp*) elem2;

   return pdw1[0]->Compare (pdw2[0], TRUE);
}


static int _cdecl PCTTSProsodyMatchHypSortScore (const void *elem1, const void *elem2)
{
   PCTTSProsodyMatchHyp *pdw1, *pdw2;
   pdw1 = (PCTTSProsodyMatchHyp*) elem1;
   pdw2 = (PCTTSProsodyMatchHyp*) elem2;

   if (pdw1[0]->m_fScore > pdw2[0]->m_fScore)
      return 1;
   else if (pdw1[0]->m_fScore < pdw2[0]->m_fScore)
      return -1;
   else
      return 0;
}

BOOL CTTSProsody::BeamSearchMatches (PCMLexicon pLexTTS, PCOMPARESYLINFO pInfo, PCSentenceSyllable pThis, PCMLexicon pLex,
                                 CTTSProsody **ppCTTSProsody, DWORD dwNum, int iTTSQuality, BOOL fWord, fp fAccuracy, DWORD dwRandomness,
                                 DWORD dwMultiPass)
{
   BOOL fRet = FALSE;
   // synthesize matches
   CListFixed alPingPong[2];
   CListFixed lResynth, lJoin;
   if (!GenerateMatches (pLexTTS, pInfo, pThis, iTTSQuality, fWord, ppCTTSProsody, dwNum, dwMultiPass, &lResynth, &lJoin))
      goto done;  // error

   // min/max matches
   WORD wPeriod = (WORD) m_pLexInProsody->WordFind (L".");
   DWORD dwMaxJoin = MaxJoinDistance (iTTSQuality);
   DWORD dwMaxMatch;
   MaxMinMatches (iTTSQuality, &dwMaxMatch, NULL);

   // determine the maximum number of hypothesis
   DWORD dwMaxHyp = dwMaxMatch * dwMaxMatch;
   if (iTTSQuality >= 2)
      dwMaxHyp *= max(1, dwMaxMatch / 4); // BUGFIX - so not too many

   // set up a ping-poing
   PCTTSProsodyMatchHyp *ppPMH;
   PCTTSProsodyMatchHyp pPMH;
   alPingPong[0].Init (sizeof(PCTTSProsodyMatchHyp));
   alPingPong[1].Init (sizeof(PCTTSProsodyMatchHyp));
   pPMH = new CTTSProsodyMatchHyp;
   if (!pPMH)
      goto done;
   pThis->CloneTo (&pPMH->m_SS); // starting sentence
   alPingPong[0].Add (&pPMH); // add to list

   // how much to randomize
   fp fRandomAmount = pInfo->fRandomize * (fp) (1+dwRandomness) / 2.0;

   // loop over all matches
   DWORD i, j;
   PCSentenceMatch *ppSM = (PCSentenceMatch*) lResynth.Get(0);
   DWORD dwSynth;
   DWORD dwPing = 0, dwPong = 1;
   for (dwSynth = 0; dwSynth < lResynth.Num(); dwSynth++, dwPing = !dwPing, dwPong = !dwPong) {
      // clear out pong
      ppPMH = (PCTTSProsodyMatchHyp*)alPingPong[dwPong].Get(0);
      for (i = 0; i < alPingPong[dwPong].Num(); i++)
         delete ppPMH[i];
      alPingPong[dwPong].Clear();

      // advance everything in ping
      ppPMH = (PCTTSProsodyMatchHyp*)alPingPong[dwPing].Get(0);
      for (i = 0; i < alPingPong[dwPing].Num(); i++)
         ppPMH[i]->Expand (pInfo, dwSynth, &lResynth, wPeriod, &alPingPong[dwPong]);

      // bring all the joins up to date
      ppPMH = (PCTTSProsodyMatchHyp*)alPingPong[dwPong].Get(0);
      for (i = 0; i < alPingPong[dwPong].Num(); i++)
         ppPMH[i]->IncludeJoinCosts (pInfo, dwSynth+1, &lResynth, &lJoin, dwMaxJoin, fWord, wPeriod);

      // sort this so exact matches can be eliminated
      qsort (ppPMH, alPingPong[dwPong].Num(), sizeof(PCTTSProsodyMatchHyp), PCTTSProsodyMatchHypSort);

      // eliminate exact matches
      for (i = alPingPong[dwPong].Num()-1; i && (i < alPingPong[dwPong].Num()); i--) {   // intitionally starting at 1
         // if they're different then continue
         if (ppPMH[i-1]->Compare (ppPMH[i], FALSE))
            continue;

         // else, the same except for score, so delete the second one
         _ASSERT (ppPMH[i-1]->m_fScore <= ppPMH[i]->m_fScore);
         delete ppPMH[i];
         alPingPong[dwPong].Remove (i);
         // i--;
         ppPMH = (PCTTSProsodyMatchHyp*)alPingPong[dwPong].Get(0);
      } // i

      // sort so best scores at top
      qsort (ppPMH, alPingPong[dwPong].Num(), sizeof(PCTTSProsodyMatchHyp), PCTTSProsodyMatchHypSortScore);

      // eliminate low scores
      if (alPingPong[dwPong].Num() > dwMaxHyp) {
         for (i = dwMaxHyp; i < alPingPong[dwPong].Num(); i++)
            delete ppPMH[i];
         alPingPong[dwPong].Truncate (dwMaxHyp);
         ppPMH = (PCTTSProsodyMatchHyp*)alPingPong[dwPong].Get(0);
      } // if too many hyp

      // randomize what's left
      if ((dwSynth < lResynth.Num()) && fRandomAmount) {
         DWORD dwRandomizeTimes = (DWORD)(ppSM[dwSynth]->m_iEndUse - ppSM[dwSynth]->m_iStartUse);
         for (i = 0; i < alPingPong[dwPong].Num(); i++)
            for (j = 0; j < dwRandomizeTimes; j++)
               ppPMH[i]->m_fScore += randf (0, fRandomAmount);
      }
   } // dwSynth

   // when gets here, dwPing will have the best match at the top of the list.
   // copy that back into the setnce
   ppPMH = (PCTTSProsodyMatchHyp*)alPingPong[dwPing].Get(0);
   _ASSERTE (alPingPong[dwPing].Num() == 1);
   ppPMH[0]->m_SS.CloneTo (pThis);

   // if got here then success
   fRet = TRUE;

done:
   ppSM = (PCSentenceMatch*) lResynth.Get(0);
   for (i = 0; i < lResynth.Num(); i++)
      delete ppSM[i];
   ppSM = (PCSentenceMatch*) lJoin.Get(0);
   for (i = 0; i < lJoin.Num(); i++)
      delete ppSM[i];

   // delete from the pingpong
   for (j = 0; j < 2; j++) {
      ppPMH = (PCTTSProsodyMatchHyp*)alPingPong[j].Get(0);
      for (i = 0; i < alPingPong[j].Num(); i++)
         delete ppPMH[i];
   }

   return fRet;
}

/*************************************************************************************
CTTSProsody::FindBestMatch - This takes a sentence split into syllables, which
will be spoken by TTS, and compares it against a list of sentences in the database.
It then finds the best matching sentences and uses them as templates to fill in
this sentences bpitch, pvolume, bduration, and microsilence.

inputs
   PCMLexicon     pLexTTS - TTS with phonemes in it
   PCOMPARESYLINFO pInfo - Score penalties to use.
   PCSentenceSyllable      pThis - Current sentence being tested. This does NOT
                           have extra punctuation added, NOR is it necessarily
                           in the same lexicon.
   PCMLexicon     pLex - Lexicon that pThis uses
   CTTSProsody    **ppCTTSProsody - This of prosody objects to use for the comparison,
                  including this one.
   DWORD          dwNum - Number of prosody objects to use. Must be at least one
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   fp             fAccuracy - How accurate to make the calculations. 1.0 = 10K units, 2.0 = 100K units, etc.
   DWORD          dwRandomness - Use 1 for normal amount of random. 2 for very random prosody, used
                     with multipass TTS to maximize acoustic scores
   DWORD                dwMultiPass - Pass number when generating several different versions of the
                        same sentence, and selecting the best one for TTS. Used to make the
                        random work better.
returns
   none... although it changes the values. NOTE: bPauseProb will be filled with 0..15,
      where 0 is no microsilnece, 15 is always microsilence
*/
#define  MATCHSLOTS           10        // keep the top 5 matches for each slot
                                          // BUGFIX - Upped from 5 to 10
#define  MATCHPOWER           10.0      // how much to raise power to for weighting, higher numbers cause only top-ranked to be used
   // BUGFIX - Used to be 2.0. Upped to 10.0 so much steeper cutoff
#define  MATCHUNWEIGHTSCORE   5.0      // the higher this number, the more the original score is unweighted,
                                       // and the more the smoothing effect (for MATCHPOWER) is used

#define RANKTENTSIZE       2        // size of the rank tent-filter, in syllables
      // BUGFIX - RANKTENTSIZE used to be 4. lowered down

static int _cdecl BEAMDIFFERENCESort (const void *elem1, const void *elem2)
{
   BEAMDIFFERENCE *pdw1, *pdw2;
   pdw1 = (BEAMDIFFERENCE*) elem1;
   pdw2 = (BEAMDIFFERENCE*) elem2;

   if (pdw1->fCompareRegion > pdw2->fCompareRegion)
      return 1;
   else if (pdw1->fCompareRegion < pdw2->fCompareRegion)
      return -1;
   else
      return 0;
   // return (int)pdw1->dwCompareRegion - (int)pdw2->dwCompareRegion;
}

static int _cdecl BESTSENTSWEEPSort (const void *elem1, const void *elem2)
{
   BESTSENTSWEEP *pdw1, *pdw2;
   pdw1 = (BESTSENTSWEEP*) elem1;
   pdw2 = (BESTSENTSWEEP*) elem2;

   return (int)pdw1->dwCompareRegion - (int)pdw2->dwCompareRegion;
}

static int _cdecl BESTSENTSWEEPSortRank (const void *elem1, const void *elem2)
{
   BESTSENTSWEEP *pdw1, *pdw2;
   pdw1 = (BESTSENTSWEEP*) elem1;
   pdw2 = (BESTSENTSWEEP*) elem2;

   if (pdw1->fRank > pdw2->fRank)
      return 1;
   else if (pdw1->fRank < pdw2->fRank)
      return -1;
   else
      return 0;
}

void CTTSProsody::FindBestMatch (PCMLexicon pLexTTS, PCOMPARESYLINFO pInfo, PCSentenceSyllable pThis, PCMLexicon pLex,
                                 CTTSProsody **ppCTTSProsody, DWORD dwNum, int iTTSQuality, fp fAccuracy, DWORD dwRandomness,
                                 DWORD dwMultiPass)
{
#ifdef TEMPLATEPROOSDYMODEL
   // new way of doing prosody
   // search for best combination of matches
   CSentenceSyllable SSTemp;
   pThis->CloneTo (&SSTemp);

   BOOL fWord = FALSE;

   PCSentenceSyllable pSSWord = NULL;
#ifndef NOMODS_DISABLEPROSODYWORDRESIDUAL
   fWord = TRUE;
   pSSWord = pThis->ToWords();
   if (pSSWord) {
      pSSWord->CloneTo (&SSTemp);
      delete pSSWord;
   }
   else
      fWord = FALSE;
#endif

#ifdef _DEBUG
   // iTTSQuality = 3;  // to test - Just for testing purposes
#endif
   BeamSearchMatches (pLexTTS, pInfo, &SSTemp, pLex, ppCTTSProsody, dwNum, iTTSQuality, fWord, fAccuracy, dwRandomness, dwMultiPass);

   // convert back to syllable-based prosody
   if (fWord) {
      pSSWord = SSTemp.FromWords (pThis);
      if (pSSWord) {
         pSSWord->CloneTo (&SSTemp);
         delete pSSWord;
      }
   }

   // combine (only one sentence) and apply extra prosody models
   PCSentenceSyllable apSS[1];
   apSS[0] = &SSTemp;
   SentenceSyllablesCombineWithProsody (pLexTTS, pThis, apSS, 1, pLex, ppCTTSProsody, dwNum);

   // done
   return;
#else


   // don't turn off random here since want to use for muliple passes
//#ifdef TURNOFFRANDOM
//   srand (0);
//#endif // 0

   // keep a list of lists
   CListFixed lPerSyl;
   lPerSyl.Init (sizeof(PCListFixed));

   // randomize all the prosodies
   DWORD i, j;
   for (i = 0; i < dwNum; i++)
      ppCTTSProsody[i]->Randomize();

   // accuracy
   DWORD dwMatchSlots = (DWORD)((fp)MATCHSLOTS * fAccuracy);

   // loop through all the syllables and find the best match amongst them
   PCListFixed pl;
   PCListFixed *ppl;
   PBESTSENTSWEEP pBSS;
   lPerSyl.Required (pThis->m_dwNum);
   int iCur;
   CListFixed lTemp;
   lTemp.Init (sizeof(BESTSENTSWEEP));
   for (iCur = -PUNCTEXTRA; iCur < (int)pThis->m_dwNum + PUNCTEXTRA; iCur++) {
      // if this is the first entry then create a new list, else
      // clone previous list and adjust offsets
      pl = new CListFixed;
      if (!pl)
         return;   // error
      lPerSyl.Add (&pl);
      if (iCur > -PUNCTEXTRA) {
         // had previous entry, so initialize this with the previous once so don't
         // bother recalculating score
         ppl = (PCListFixed*)lPerSyl.Get(0);
         pl->Init (sizeof(BESTSENTSWEEP), ppl[iCur+PUNCTEXTRA-1]->Get(0), ppl[iCur+PUNCTEXTRA -1]->Num());

         // wipe out old score syllable lists
         pBSS = (PBESTSENTSWEEP)ppl[iCur+PUNCTEXTRA-1]->Get(0);
         for (j = 0; j < ppl[iCur+PUNCTEXTRA -1]->Num(); j++, pBSS++)
            pBSS->plfScoreSyl = NULL;

         pBSS = (PBESTSENTSWEEP)pl->Get(0);
         for (j = 0; j < pl->Num(); j++) {
            // if offset would go beyond edge of sentence, or down to 0 matches,
            // then remove from the list
            pBSS[j].iOffsetTest++;
            if ((pBSS[j].dwSylMatch <= 1) || (pBSS[j].iOffsetTest >= (int)pBSS[j].pSent->m_dwNum + PUNCTEXTRA) || !pBSS[j].plfScoreSyl ) {
               // end of the line, so delete this
               if (pBSS[j].plfScoreSyl)
                  delete pBSS[j].plfScoreSyl;
               pl->Remove (j);
               j--;
               pBSS = (PBESTSENTSWEEP)pl->Get(0);
               continue;
            }
            pBSS[j].dwSylMatch--;  // reduce number of matches
         } // i
      }
      else
         pl->Init (sizeof(BESTSENTSWEEP));

      // loop through all the prosody modules and see what they have to add
      lTemp.Clear();
      for (j = 0; j < dwNum; j++)
         ppCTTSProsody[j]->CompareSweepSequence (pInfo, pThis, iCur, pLex, &lTemp, dwMatchSlots, pl);
            // NOTE: Always allow previous matches to continue on so they're not
            // unintentionally pushed out by something that's temporarily better

      // add everything in lTemp to pl
      pBSS = (PBESTSENTSWEEP) lTemp.Get(0);
      for (j = 0; j < lTemp.Num(); j++, pBSS++)
         pl->Add (pBSS);

      // look through all the slots and calculate the score for the specific syllable
      pBSS = (PBESTSENTSWEEP)pl->Get(0);
      for (j = 0; j < pl->Num(); j++, pBSS++) {
         // just in case, make sure that have list
         if (!pBSS->plfScoreSyl || !pBSS->plfScoreSyl->Num()) {
            if (pBSS->plfScoreSyl) {
               delete pBSS->plfScoreSyl;
               pBSS->plfScoreSyl = NULL;
            }
            pBSS->fScoreSyl = COMPARESINGLESYLLABLE_NOMATCH;   // since don't know
            continue;
         }

         // get first score on the list
         pBSS->fScoreSyl = *((fp*)pBSS->plfScoreSyl->Get(0));
#ifdef _DEBUG
         if (pBSS->fScoreSyl == COMPARESINGLESYLLABLE_NOMATCH)
            pBSS->fScoreSyl = COMPARESINGLESYLLABLE_NOMATCH;
#endif
         pBSS->plfScoreSyl->Remove (0);

         // clear the score list if it's empty, of if we're at the end of the checks
         if (!pBSS->plfScoreSyl->Num() || (iCur+1 >= (int)pThis->m_dwNum+PUNCTEXTRA) ) {
            delete pBSS->plfScoreSyl;
            pBSS->plfScoreSyl = NULL;
         }
      }
   } // i

   // if any of the lists are blank then add a dummy hypothesis that will have no pitch or inflection
   BESTSENTSWEEP bs;
   memset (&bs, 0, sizeof(bs));
   bs.iOffsetTest = 0;
   bs.fScoreAvg = 0.0; // BUGFIX - was 1, but not sure that should use 1 with new floating point values;
   bs.pSent = NULL;
   bs.fScoreSyl = COMPARESINGLESYLLABLE_NOMATCH;
   ppl = (PCListFixed*)lPerSyl.Get(0);
   for (i = 0; i < lPerSyl.Num(); i++) {
      pl = ppl[i];
      if (!pl->Num())
         pl->Add (&bs);
   } // i

   // PROSODYTREND ProsTrend;
   DWORD dwNumBeamSearch = (DWORD) ((fp)FINDBESTMATCH_BEAMSEARCHNUM * fAccuracy);
   dwNumBeamSearch = max(dwNumBeamSearch, FINDBESTMATCH_SEARCHGROUP);   // must have enough for a few searches
      // BUGFIX - Was FINDBESTMATCH_SEARCHGROUP*2, but changed to FINDBESTMATCH_SEARCHGROUP so can get ultra-fast on low quality voice
   // DWORD dwBeam;
   CListFixed lBEAMDIFFERENCE;
   lBEAMDIFFERENCE.Init (sizeof(BEAMDIFFERENCE));
   // BEAMDIFFERENCE bd;
   // memset (&bd, 0, sizeof(bd));

#ifdef _DEBUG
   DWORD dwStartTime = GetTickCount();
#endif

   // multithreaded
   EMTFINDBESTMATCH em;
   memset (&em, 0, sizeof(em));
   em.dwType = 20;
   em.fAccuracy = fAccuracy;
   em.dwRandomness = dwRandomness;
   em.dwNum = dwNum;
   em.plBEAMDIFFERENCE = &lBEAMDIFFERENCE;
   em.plPerSyl = &lPerSyl;
   em.ppCTTSProsody = ppCTTSProsody;
   em.pThis = pThis;
   em.pInfo = pInfo;
   em.dwMultiPass = dwMultiPass;
   em.pLexTTS = pLexTTS;

   ThreadLoop (0, dwNumBeamSearch, 1, &em, sizeof(em), NULL);

   // make sure no blank ones
   PBEAMDIFFERENCE pBD = (PBEAMDIFFERENCE) lBEAMDIFFERENCE.Get(0);
   BEAMDIFFERENCE bdBlank;
   memset (&bdBlank, 0, sizeof(bdBlank));
   for (i = lBEAMDIFFERENCE.Num()-1; i < lBEAMDIFFERENCE.Num(); i--)
      if (!memcmp (pBD + i, &bdBlank, sizeof(bdBlank))) {
         lBEAMDIFFERENCE.Remove (i);
         pBD = (PBEAMDIFFERENCE) lBEAMDIFFERENCE.Get(0); // just in case
      }

#if 0 // replaced by multithreaded
   for (dwBeam = 0; dwBeam < dwNumBeamSearch; dwBeam++) {
      // do a beam search to find the best
      int iScoreBeamSearch;
      PCListFixed plBeamSearch;
      plBeamSearch = BeamSearch (&lPerSyl, &iScoreBeamSearch, fAccuracy);
      // NOTE: Should ALWAYS have something, unless ran out of memory
      if (!plBeamSearch)
         goto done;

   #ifdef _DEBUG
      // display the beam search
      WCHAR szTemp[256];
      swprintf (szTemp, L"\r\nBeamSearch score=%d: ", (int)iScoreBeamSearch);
      OutputDebugStringW (szTemp);
      pBSS = (PBESTSENTSWEEP) plBeamSearch->Get(0);
      for (i = 0; i < plBeamSearch->Num(); i++) {
         // if changed sentences then display new one
         if (!i || (pBSS[i-1].pSent != pBSS[i].pSent) ) {
            swprintf (szTemp, L" [New sent = %x]", (int)(__int64)pBSS[i].pSent);
            OutputDebugStringW (szTemp);
         }

         // show the number and the score
         swprintf (szTemp, L"%d (score=%d) ", (int)pBSS[i].iOffsetTest, (int)pBSS[i].iScoreSyl);
         OutputDebugStringW (szTemp);
      } // i
   #endif

      // convert the info to a sentnece syllable
      PCSentenceSyllable pSSBeam = BeamSearchHypToSentenceSyllable (plBeamSearch);
      delete plBeamSearch;
      if (!pSSBeam)
         goto done;

      // apply some prosody fine-tuning to this so more accurate
      for (i = 0; i < pSSBeam->m_dwNum; i++) {
         ProsodyTrend (
            pSSBeam->m_pabPOS[i], pSSBeam->m_pabRuleDepth[i],
            pThis->m_pabPOS[i], pThis->m_pabRuleDepth[i],
            &ProsTrend,
            ppCTTSProsody, dwNum);

         // incorporate this prosdy trend in
         PSENTENCESYLLABLE pss = &pSSBeam->m_paSyl[i];
         fp f;
         int iSum;

         // pitch
         f = (fp)pss->bPitch * pow (2.0, (fp)ProsTrend.iPitch / 100.0);
         f = max(f, 0);
         f = min(f, 255);
         pss->bPitch = (BYTE) f;

         // pitch sweep
         iSum = (int)pss->cPitchSweep + ProsTrend.iPitchSweep;
         iSum = max(iSum, -127);
         iSum = min(iSum, 127);
         pss->cPitchSweep = (char)iSum;

         // pitch bulge
         iSum = (int)pss->cPitchBulge + ProsTrend.iPitchBulge;
         iSum = max(iSum, -127);
         iSum = min(iSum, 127);
         pss->cPitchBulge = (char)iSum;

         // volume
         f = (fp)pss->bVol * pow (2.0, (fp)ProsTrend.iVol / 50.0);
         f = max(f, 0);
         f = min(f, 255);
         pss->bVol = (BYTE) f;

         // dur phone
         f = (fp)pss->bDurPhone * pow (2.0, (fp)ProsTrend.iDurPhone / 50.0);
         f = max(f, 0);
         f = min(f, 255);
         pss->bDurPhone = (BYTE) f;

         // dur syl
         f = (fp)pss->bDurSyl * pow (2.0, (fp)ProsTrend.iDurSyl / 50.0);
         f = max(f, 0);
         f = min(f, 255);
         pss->bDurSyl = (BYTE) f;

         NOTE: Not doing cDurSkew here
      } // i

      bd.pSS = pSSBeam;
      bd.iScore = iScoreBeamSearch;
      lBEAMDIFFERENCE.Add (&bd);
   } // dwBeam
#endif // 0, multithreaded

#ifdef _DEBUG
   WCHAR szTemp[64];
   swprintf (szTemp, L"\r\nTotal beamsearch time = %d", (int)(GetTickCount()-dwStartTime));
   OutputDebugStringW (szTemp);
#endif

   WORD wPeriod = (WORD) m_pLex->WordFind (L".");

   // group these together
#define MAXGROUPSIZE       20
   pBD = (PBEAMDIFFERENCE) lBEAMDIFFERENCE.Get(0);
   DWORD dwGroupSize = dwNumBeamSearch / FINDBESTMATCH_SEARCHGROUP;
   dwGroupSize = min(dwGroupSize, MAXGROUPSIZE);
   DWORD dwGroupStart;
   DWORD dwGroupStartBest = (DWORD)-1;
   fp fGroupScoreBest = 0;
   for (dwGroupStart = 0; dwGroupStart + dwGroupSize <= lBEAMDIFFERENCE.Num(); dwGroupStart += dwGroupSize) {
      // do a compare from dwGroupStart and on
      pBD[dwGroupStart].fCompareRegion = 0; // always 0 error with itself
      for (i = dwGroupStart+1; i < lBEAMDIFFERENCE.Num(); i++)
         pBD[i].fCompareRegion = pBD[dwGroupStart].pSS->CompareRegion (pInfo, 0, pBD[i].pSS, 0, wPeriod);

      // sort from group start and below, by the best compare
      qsort (pBD + dwGroupStart, lBEAMDIFFERENCE.Num() - dwGroupStart, sizeof(BEAMDIFFERENCE), BEAMDIFFERENCESort);

      // take the score of this group and store away
      fp fScoreTotal = 0;
      for (i = dwGroupStart; i < dwGroupStart + dwGroupSize; i++)
         fScoreTotal += pBD[i].fCompareRegion;

      // keep the best/closest match, so most similar sounding
      if ((dwGroupStartBest == (DWORD)-1) || (fScoreTotal < fGroupScoreBest)) {
         dwGroupStartBest = dwGroupStart;
         fGroupScoreBest = fScoreTotal;
      }
   } // dwGroupStart
   if (dwGroupStartBest == (DWORD)-1)
      goto done;  // shoudlnt happen

   // make a list of all the bits to combine
   PCSentenceSyllable papSS[MAXGROUPSIZE];
   for (i = 0; i < dwGroupSize; i++)
      papSS[i] = pBD[dwGroupStartBest + i].pSS;

   // combine and done with it
   SentenceSyllablesCombineWithProsody (pThis, papSS, dwGroupSize, pLex, ppCTTSProsody, dwNum);

   // deleat all the beams
   for (i = 0; i < lBEAMDIFFERENCE.Num(); i++)
      delete pBD[i].pSS;




#if 0 // no longer used because replaced by SentenceSyllablesCombineWithProsody()

   CMem memRelative;
   CListFixed lFBMSUBSENT;
   CListFixed lMATCHRANKFILTER;


   // clear all the bestsentsweep ranks to -1
   DWORD dwNumInStack;
   PBESTSENTSWEEP pStack;
   PBESTSENTSWEEP pBlendWith;
   for (i = 0; i < lPerSyl.Num(); i++) {
      dwNumInStack = ppl[i]->Num();
      pStack = (PBESTSENTSWEEP)ppl[i]->Get(0);
      for (j = 0; j < dwNumInStack; j++) {
         // blend with
         pBlendWith = pStack + j;
         pBlendWith->fRank = -1.0;
      } // j
   } // i

   // hack, remove starting/ending punct
   DWORD dwStart;
   for (dwStart = 0; dwStart < 2; dwStart++) {
      for (i = 0; i < PUNCTEXTRA; i++) {
         DWORD dwIndex = dwStart ? 0 : (lPerSyl.Num() - 1);
         delete ppl[dwIndex];
         lPerSyl.Remove (dwIndex);
         ppl = (PCListFixed*)lPerSyl.Get(0);
      } // i
   } // dwStart

   // loop through every item that appears in bestsentsweep and store the rankings away
   // sepearately so can filter. Filter them. And store filtered value back in fRank
   MATCHRANKFILTER mrf;
   PMATCHRANKFILTER pmrf;
   lMATCHRANKFILTER.Init (sizeof(MATCHRANKFILTER));
   DWORD k, m;
   for (i = 0; i < pThis->m_dwNum; i++) {
      dwNumInStack = ppl[i]->Num();
      pStack = (PBESTSENTSWEEP)ppl[i]->Get(0);
      for (j = 0; j < dwNumInStack; j++) {
         // blend with
         pBlendWith = pStack + j;

         if (pBlendWith->fRank >= 0)
            continue;   // already did this one

         // else, need to add it

         // set as lowest rank up until this point
         lMATCHRANKFILTER.Clear ();
         mrf.fRank = ppl[i]->Num(); // MATCHSLOTS;
         mrf.pBest = NULL;
         lMATCHRANKFILTER.Required (i+1);
         for (k = 0; k < i; k++)
            lMATCHRANKFILTER.Add (&mrf);

         // add this one
         mrf.fRank = j;
         mrf.pBest = pBlendWith;
         lMATCHRANKFILTER.Add (&mrf);

         // subsequent ones
         for (k = i+1; k < pThis->m_dwNum; k++) {
            DWORD dwNumInStack2 = ppl[k]->Num();
            PBESTSENTSWEEP pStack2 = (PBESTSENTSWEEP)ppl[k]->Get(0);
            for (m = 0; m < dwNumInStack2; m++) {
                     // BUGFIX - Was m < dwNumInStack, which is wrong, should be dwNumInStack2
               PBESTSENTSWEEP pBlendWith2 = pStack2 + m;
               if (pBlendWith2->pSent != pBlendWith->pSent)
                  continue;   // no match of original sentences
               if (pBlendWith2->iOffsetTest != pBlendWith->iOffsetTest + (int)(k - i))
                  continue;   // wrong offset

               // else, match
               break;
            } // m
            if (m >= dwNumInStack2) {  // BUGFIX - Changed dwNumInStack to dwNumInStack2
               // didn't find an occurance here
               mrf.fRank = ppl[i]->Num(); // MATCHSLOTS;
               mrf.pBest = NULL;
            }
            else {
               // found
               mrf.fRank = m;
               mrf.pBest = pStack2 + m;
            }
            lMATCHRANKFILTER.Add (&mrf);
         } // k

         // when get here, lMATCHRANKFILTER has been filled in, so need to do tent filter
         pmrf = (PMATCHRANKFILTER) lMATCHRANKFILTER.Get(0);
         fp fRankFirst = lMATCHRANKFILTER.Num() ? pmrf[0].fRank : (fp)ppl[i]->Num(); // MATCHSLOTS;
         fp fRankLast = lMATCHRANKFILTER.Num() ? pmrf[lMATCHRANKFILTER.Num()-1].fRank : (fp)ppl[i]->Num(); // MATCHSLOTS;
         for (k = 0; k < lMATCHRANKFILTER.Num(); k++) {
            if (!pmrf[k].pBest)
               continue;   // empty, so dont bother filling

            // sum for tent filter
            fp fSum = 0;
            DWORD dwCount = 0;
            int iTent;
            for (iTent = -RANKTENTSIZE; iTent <= RANKTENTSIZE; iTent++) {
               int iCur = (int)k + iTent;
               DWORD dwWeight = RANKTENTSIZE + 1 - (DWORD)abs(iTent);
               if (iCur < 0)
                  fSum += fRankFirst * (fp)dwWeight;
               else if (iCur >= (int)lMATCHRANKFILTER.Num())
                  fSum += fRankLast * (fp)dwWeight;
               else
                  fSum += pmrf[iCur].fRank * (fp)dwWeight;
               dwCount += dwWeight;
            } // iTent

            // store averaged rank
            if (dwCount)
               fSum /= (fp)dwCount;
            pmrf[k].pBest->fRank = fSum;
         } // k

      } // j, all in stack
   } // i

   // now that have a lot of templates for each word, blend them all together, weighting
   // by the dwscore... that way, if there are bad recordings, they will tend to be
   // counteracted by having lots of data

   // loop through and blend the results of the best ones
   SYLEMPH Emph;
   fp fWeight;
   fp fMicroSilence, fMicroSilenceSum;
   if (!memRelative.Required (pThis->m_dwNum * sizeof(fp) * 3))
      goto done;  // not likely to happen
   fp *pafRelative = (fp*)memRelative.p;
   fp *pafRelativeSum = pafRelative + pThis->m_dwNum;
   fp *pafFilter = pafRelativeSum + pThis->m_dwNum;
   memset (pafRelative, 0, pThis->m_dwNum * sizeof(fp) * 3);
   fp fPitchAverage = 0;

#if 0 // to test
#ifdef _DEBUG
   FILE *file = fopen ("c:\\test.txt", "wt");
#else
   FILE *file = fopen ("c:\\testr.txt", "wt");
#endif
#endif // 0

   // look ahead and determine the word parts of speech
   BYTE abNGramPOS[4];
   DWORD dwNextPOSSyl = 0;
   for (j = 0; j < 4; j++) {
      if (j < 3) {
         abNGramPOS[j] = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
         continue;
      }

      for ( ; (dwNextPOSSyl < pThis->m_dwNum) && !pThis->IsStartOfWord(dwNextPOSSyl); dwNextPOSSyl++);

      if (dwNextPOSSyl < pThis->m_dwNum) {
         abNGramPOS[j] = pThis->m_pabPOS[dwNextPOSSyl] & 0x0f;
         dwNextPOSSyl++;
      }
      else
         abNGramPOS[j] = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);   // beyond the end
   }

   // figure out which subsentence a word is in, and what the index is, as well as how long the subsentence is
   FBMSUBSENT fss;
   lFBMSUBSENT.Init (sizeof(FBMSUBSENT));
   WORD wPeriod = (WORD) m_pLex->WordFind (L".");
   WORD wQuestion = (WORD) m_pLex->WordFind (L"?");
   WORD wExclamation = (WORD) m_pLex->WordFind (L"!");
   DWORD dwSubSentence = 0;
   DWORD dwIndex = 0;
   for (i = 0; i < pThis->m_dwNum; i++) {
      if ( ((pThis->m_pabPOS[i] & 0x0f) == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION)) ) {
         // if it's a sentence boundary then set some stuff
         if (
            (pThis->m_paSyl[i].wWord != (WORD)-1) &&
            ( (pThis->m_paSyl[i].wWord == wPeriod) || (pThis->m_paSyl[i].wWord == wQuestion) || (pThis->m_paSyl[i].wWord == wExclamation) ) ) {

               dwSubSentence++;
               dwIndex = 0;
            };

   
         fss.dwIndex = fss.dwSubSentenceLength = 0;
         fss.dwSubSentence = (DWORD)-1;
         lFBMSUBSENT.Add (&fss);

         // ignore punctuation
         continue;
      }

      // else, add
      fss.dwSubSentenceLength = 0;
      fss.dwSubSentence = dwSubSentence;
      fss.dwIndex = dwIndex;
      dwIndex++;
      lFBMSUBSENT.Add (&fss);
   } // i

   // go back over and calculate total length
   FBMSUBSENT *pfss;
   pfss = (PFBMSUBSENT) lFBMSUBSENT.Get(0);
   for (i = 0; i < lFBMSUBSENT.Num(); i++) {
      if (pfss[i].dwSubSentence == (DWORD)-1)
         continue;

      if (pfss[i].dwSubSentenceLength)
         continue;   // length already calculated

      DWORD dwCount  = 0;
      for (j = i; j < lFBMSUBSENT.Num(); j++)
         if (pfss[i].dwSubSentence == pfss[j].dwSubSentence)
            dwCount++;
      for (j = i; j < lFBMSUBSENT.Num(); j++)
         if (pfss[i].dwSubSentence == pfss[j].dwSubSentence)
            pfss[j].dwSubSentenceLength = dwCount;
   }

   PSENTENCESYLLABLE pss;
   PROSODYTREND ProsTrend;
   for (i = 0; i < pThis->m_dwNum; i++) {
      // if its a new word then shift NGram and add
      if (pThis->IsStartOfWord(i)) {
         memmove (abNGramPOS, abNGramPOS+1, sizeof(abNGramPOS)-sizeof(BYTE));

         // find the next POS
         for ( ; (dwNextPOSSyl < pThis->m_dwNum) && !pThis->IsStartOfWord(dwNextPOSSyl); dwNextPOSSyl++);

         if (dwNextPOSSyl < pThis->m_dwNum) {
            abNGramPOS[3] = pThis->m_pabPOS[dwNextPOSSyl] & 0x0f;
            dwNextPOSSyl++;
         }
         else
            abNGramPOS[3] = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);   // beyond the end
      } // if new word

      // do a weighted sum of all the surrounding bits
      memset (&Emph, 0, sizeof(Emph));
      fMicroSilence = fMicroSilenceSum = 0;

#ifdef _DEBUG
      WCHAR szTemp[128];
      swprintf (szTemp, L"\r\n\r\nWord: %d", (int)i);
      OutputDebugStringW (szTemp);
#endif
#if 0
      fprintf (file, "\r\n\r\nWord: %d", (int)i);
#endif // 0

      dwNumInStack = ppl[i]->Num();
      pStack = (PBESTSENTSWEEP)ppl[i]->Get(0);

      // sort by fRank so the best is at the top
      qsort (pStack, dwNumInStack, sizeof(BESTSENTSWEEP), BESTSENTSWEEPSortRank);

      // determine the best rank and use that
      DWORD dwBestRank = 0;
      for (j = 0; j < dwNumInStack; j++) {   // inteinoally start at 1
         // calculate fRankScore
         _ASSERTE (pStack[j].fRank >= 0);
         pStack[j].fRankScore = (fp)j / (fp)dwNumInStack;
         // note: dont do pStack[j].fRankScore *= pStack[j].fRankScore; since shouldnt need
         pStack[j].fRankScore = pow(cos(pStack[j].fRankScore * PI/2),2);  // to demphasize ones at bottom
         // pStack[j].fRankScore = pow (0.75, pStack[j].fRank);
            // BUGFIX - Was pow (0.5). Reduced because also include weighting of similar-sounding areas
            // BUGFIX - Remove code for:  * (fp)pStack[j].dwScore;, since redundant with rank

         // determine the best rank
         if (pStack[j].fRank < pStack[dwBestRank].fRank)
            dwBestRank = j;
      }

      // see how much each of these different from the best rank
      for (j = 0; j < dwNumInStack; j++) {
         pStack[j].dwCompareRegion = (pStack[j].pSent && pStack[dwBestRank].pSent) ?
            pStack[j].pSent->CompareRegion (pStack[j].iOffsetTest, pStack[dwBestRank].pSent, pStack[dwBestRank].iOffsetTest) :
            MAXCOMPAREREGIONERRTOTAL;
      } // j

      // sort by dwCompareRegion so the closest matches are at the top
      qsort (pStack, dwNumInStack, sizeof(BESTSENTSWEEP), BESTSENTSWEEPSort);

      // blend the elements in the stack
      for (j = 0; j < dwNumInStack; j++) {
         // blend with
         pBlendWith = pStack + j;

         //fWeight = pow(0.5, pBlendWith->fRank);   // so lower ranked sentences are much lower
         //_ASSERTE (pBlendWith->fRank >= 0);
         //fWeight *= (fp) pBlendWith->dwScore;
         // BUGFIX - reduce the emphasis on the original ranking score, so that can emphasize the closeness
         // of the match from CompareRegion()
         fWeight = pBlendWith->fRankScore;
         fWeight = max(fWeight, EPSILON);
         fWeight = pow ((double)fWeight, 1.0 / (double)MATCHUNWEIGHTSCORE);
         

         // since sorted by how close they compare with the best, also include index in scale
         // using this ensures that the top-ranking sentence is mimiced fairly well,
         // but that if there are any wierdnesses in the sentence, they're ironed out by
         // overweighting other sentences that are similar to the top-ranked one
         fp fAlpha = (fp)j / (fp)dwNumInStack;
         // note: dont do fAlpha = sqrt(fAlpha);  // so only emphasizes most similar, and demphasizes others
         fWeight *= pow(cos (fAlpha * PI/2), MATCHPOWER); // * (1.0 - fAlpha);
            // use cos so ones at bottom are very de-emphasized

#ifdef _DEBUG
      swprintf (szTemp, L"\r\nBlend in word %d from sentence %d, orig weight %d, final = %g",
         (int)pBlendWith->iOffsetTest, pBlendWith->pSent ? (int)pBlendWith->pSent->m_dwSentIndex : -1, (int)pBlendWith->iScoreAvg,
         (double)fWeight);
      OutputDebugStringW (szTemp);
#endif
#if 0
      fprintf (file, "\r\nBlend in word %d from sentence %d, weight %d",
         (int)pBlendWith->dwOffset, pBlendWith->pSent ? (int)pBlendWith->pSent->m_dwSentIndex : -1, (int)pBlendWith->dwScore);
#endif // 0

         // if there isn't any available match then skip
         if (!pBlendWith->pSent)
            continue;

         // else, add, weighting the scores of the blend
         int iOffsetTemp = pBlendWith->iOffsetTest;
         iOffsetTemp = max(iOffsetTemp, 0);  // just in case, hack anyway
         iOffsetTemp = min(iOffsetTemp, (int)(pBlendWith->pSent->m_dwNum-1)); // hack anyway

         pss = pBlendWith->pSent->m_paSyl + iOffsetTemp;

         // determine the prosody trend
         ProsodyTrend (
            pBlendWith->pSent->m_pabPOS[iOffsetTemp], pBlendWith->pSent->m_pabRuleDepth[iOffsetTemp],
            pThis->m_pabPOS[i], pThis->m_pabRuleDepth[i],
            &ProsTrend,
            ppCTTSProsody, dwNum);

         Emph.Emph.fPitch +=
            ( log((fp)pss->bPitch / 100.0) + (fp)ProsTrend.iPitch / (fp)100.0 * log((fp)2) ) * fWeight;
         Emph.Emph.fPitchSweep +=
            ( (fp)pss->cPitchSweep / 100.0 + (fp)ProsTrend.iPitchSweep / 100.0 ) * fWeight;
         Emph.Emph.fPitchBulge +=
            ( (fp)pss->cPitchBulge / 100.0 + (fp)ProsTrend.iPitchBulge / 100.0 ) * fWeight;
         Emph.Emph.fVolume +=
            ( log((fp)pss->bVol / 100.0) + (fp)ProsTrend.iVol / (fp)50.0 * log((fp)2) ) * fWeight;
#ifdef _DEBUG
         swprintf (szTemp, L"\r\n\tVolume = %g", (double)Emph.Emph.fVolume);
         OutputDebugStringW (szTemp);
#endif
         Emph.Emph.fDurPhone +=
            ( log((fp)pss->bDurPhone / 100.0) + (fp)ProsTrend.iDurPhone / (fp)50.0 * log((fp)2) ) * fWeight;
         Emph.Emph.fDurSyl +=
            ( log((fp)pss->bDurSyl / 100.0) + (fp)ProsTrend.iDurSyl / (fp)50.0 * log((fp)2) ) * fWeight;
         NOTE: Not during fDurSkew
         Emph.fMisc += fWeight;

         // BUGFIX - look at the POS for only the first syllable to see if should include
         BYTE bPOS = pBlendWith->pSent->m_pabPOS[iOffsetTemp];
            // NOTE: Ignoring blending of bRuleDepth
         if (!(bPOS & 0x70)) {
            // this is the start of a word
            fMicroSilenceSum += fWeight;
            fMicroSilence += fWeight * (fp)(pss->bPauseProb & 0x0f) / 15.0;
         }

         // if there's a previous word, and its pitch isnt' 0, and this one's
         // pithc isn't 0, then determine relative pitch
         if (iOffsetTemp && pss->bPitch && pss[-1].bPitch) {
            pafRelative[i] +=
               ( log((fp)pss->bPitch / (fp)pss[-1].bPitch) + (fp)ProsTrend.iPitchRelative / (fp)100.0 * log((fp)2) ) * fWeight;

// #define DISABLERESIDUAL
#ifdef DISABLERESIDUAL  // so no relative pitch component for test
            pafRelative[i] = 0;
#endif // _DEBUG

            // BUGFIX - Was just afRelativeSum, but should be pafRelativeSum
            pafRelativeSum[i] += fWeight;
         }
      } // j, over templates for the word

      // if there's no weight then make a neutral case
      if (Emph.fMisc) {
         fp fScale = 1.0 / Emph.fMisc;

         Emph.Emph.fPitch = exp(Emph.Emph.fPitch * fScale);
         Emph.Emph.fPitchSweep *= fScale;
         Emph.Emph.fPitchBulge *= fScale;
         Emph.Emph.fVolume = exp(Emph.Emph.fVolume * fScale);
         Emph.Emph.fDurPhone = exp(Emph.Emph.fDurPhone * fScale);
         Emph.Emph.fDurSyl = exp(Emph.Emph.fDurSyl * fScale);
         NOTE: Not doing fDurSkew

         if (fMicroSilenceSum)
            fMicroSilence = fMicroSilence / fMicroSilenceSum;
         else
            fMicroSilence = 0.0;
         //if (fMicroSilence > fMicroSilenceSum * fMicroPauseThreshhold)
         //   fMicroSilence = TRUE;
         //else
         //   fMicroSilence = FALSE;
      }
      else {
         Emph.Emph.fPitchSweep = 0;
         Emph.Emph.fPitchBulge = 0;
         NOTE: Not doing fDurSkew
         Emph.Emph.fPitch = Emph.Emph.fVolume = Emph.Emph.fDurPhone = Emph.Emph.fDurSyl = 1;
         fMicroSilence = 0.0;   // no microsilnce
      }

#ifdef DISABLERESIDUAL  //  zero out to test typical info
      Emph.Emph.fPitchSweep = 0;
      Emph.Emph.fPitchBulge = 0;
      NOTE: Not doing fDurSkew
      Emph.Emph.fPitch = Emph.Emph.fVolume = Emph.Emph.fDurPhone = Emph.Emph.fDurSyl = 1;
#endif

      // restore typical info
      fp fWeightCur = pafRelativeSum[i];
      if (!fWeightCur)
         fWeightCur = 1;

// #define DISABLETYPICALSYLINFO
#ifndef DISABLETYPICALSYLINFO
      if (pfss[i].dwSubSentence != (DWORD)-1) {
         TYPICALSYLINFO TSI, TSILast;
         TypicalSylInfoGet (pfss[i].dwIndex, pfss[i].dwSubSentenceLength, ppCTTSProsody, dwNum, &TSI);
         BOOL fUseRelative = (i && (pfss[i-1].dwSubSentence != (DWORD)-1));
         if (fUseRelative)
            TypicalSylInfoGet (pfss[i-1].dwIndex, pfss[i-1].dwSubSentenceLength, ppCTTSProsody, dwNum, &TSILast);

         if (TSI.fCount) {
            Emph.Emph.fPitch *= exp(TSI.fPitchSum / TSI.fCount);
            Emph.Emph.fVolume *= exp(TSI.fVolumeSum / TSI.fCount);
            Emph.Emph.fDurPhone *= exp(TSI.fDurPhoneSum / TSI.fCount);
            Emph.Emph.fDurSyl *= exp(TSI.fDurSylSum / TSI.fCount);
            NOTE: Not doing fDurSkew
            Emph.Emph.fPitchBulge += TSI.fPitchBulgeSum / TSI.fCount;
            Emph.Emph.fPitchSweep += TSI.fPitchSweepSum / TSI.fCount;

            // relative
            if (fUseRelative && TSI.fCount && TSILast.fCount) {
               fWeight = fWeightCur;
               pafRelative[i] += ((TSI.fPitchSum / TSI.fCount) - (TSILast.fPitchSum / TSILast.fCount)) * fWeight;
               pafRelativeSum[i] += fWeight;
            }
         }
      } // typical info
#endif // DISABLETYPICALSYLINFO

      // include prosody ngram
// #define DISABLEPROSODYNGRAM
#ifndef DISABLEPROSODYNGRAM
      if (pfss[i].dwSubSentence != (DWORD)-1) {
         TYPICALSYLINFO TSI, TSILast;
         ProsodyNGramInfoGet (pThis->m_pabPOS, pThis->m_dwNum, i, ppCTTSProsody, dwNum, &TSI);
         BOOL fUseRelative = (i && (pfss[i-1].dwSubSentence != (DWORD)-1));
         if (fUseRelative)
            ProsodyNGramInfoGet (pThis->m_pabPOS, pThis->m_dwNum, i - 1, ppCTTSProsody, dwNum, &TSILast);

         if (TSI.fCount) {
            Emph.Emph.fPitch *= exp(TSI.fPitchSum / TSI.fCount);
            Emph.Emph.fVolume *= exp(TSI.fVolumeSum / TSI.fCount);
            Emph.Emph.fDurPhone *= exp(TSI.fDurPhoneSum / TSI.fCount);
            Emph.Emph.fDurSyl *= exp(TSI.fDurSylSum / TSI.fCount);
            NOTE: Not doing fDurSkew
            Emph.Emph.fPitchBulge += TSI.fPitchBulgeSum / TSI.fCount;
            Emph.Emph.fPitchSweep += TSI.fPitchSweepSum / TSI.fCount;

            // relative
            if (fUseRelative && TSI.fCount && TSILast.fCount) {
               fWeight = fWeightCur;
               pafRelative[i] += ((TSI.fPitchSum / TSI.fCount) - (TSILast.fPitchSum / TSILast.fCount)) * fWeight;
               pafRelativeSum[i] += fWeight;
            }
         }
      } // prosody NGram
#endif

      // write the values in
      pss = pThis->m_paSyl + i;

      // store this away
      fp f;
      f = Emph.Emph.fPitch * 100.0;
      f = max(f, 25);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 254);  // dont be too restrtive.. and shouldnt happen anyway
      pss->bPitch = (BYTE)(f+0.5);

      f = Emph.Emph.fPitchSweep * 100.0;
      f = max(f, -126);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 126);  // dont be too restrtive.. and shouldnt happen anyway
      pss->cPitchSweep = (char)(int)floor(f+0.5);

      f = Emph.Emph.fPitchBulge * 100.0;
      f = max(f, -126);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 126);  // dont be too restrtive.. and shouldnt happen anyway
      pss->cPitchBulge = (char)(int)floor(f+0.5);

      f = Emph.Emph.fVolume * 100.0;
      f = max(f, 25);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 254);  // dont be too restrtive.. and shouldnt happen anyway
      pss->bVol = (BYTE)(f+0.5);

      f = Emph.Emph.fDurPhone * 100.0;
      f = max(f, 25);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 254);  // dont be too restrtive.. and shouldnt happen anyway
      pss->bDurPhone = (BYTE)(f+0.5);

      f = Emph.Emph.fDurSyl * 100.0;
      f = max(f, 25);  // dont be too restrtive.. and shouldnt happen anyway
      f = min(f, 254);  // dont be too restrtive.. and shouldnt happen anyway
      pss->bDurSyl = (BYTE)(f+0.5);

      NOTE: Not doing fDurSkew

      // given the part of speech, determine the location in the N gram
      // average the N-gram probability in with the value that have stored
      fp fPauseNGram = PauseNGram (abNGramPOS[0], abNGramPOS[1], abNGramPOS[2], abNGramPOS[3],
         ppCTTSProsody, dwNum);
      if (fPauseNGram >= 0)
         fMicroSilence = (fMicroSilence + fPauseNGram) / 2.0;


      // NOTE: bPauseProb used as microsilnce value... if 0 NEVER insert, if 15 always insert
      fMicroSilence = max(fMicroSilence, 0);
      fMicroSilence = min(fMicroSilence, 1);
      pss->bPauseProb = (BYTE)(fMicroSilence*15.0 + 0.5);   // 0..15 only

      // scale sum
      if (pafRelativeSum[i])
         pafRelative[i] /= pafRelativeSum[i];
      if (i)
         pafRelative[i] += pafRelative[i-1]; // so pitch achored from previous pitch
      else
         pafRelative[i] = 0;  // no relative pitch for first entry
      fPitchAverage += pafRelative[i]; // so cancalulate the average
   } // i

   // loop through all the pitch scale values and make sure average is 0
   fPitchAverage /= (fp)max(pThis->m_dwNum,1);
   fp f, fSum;
   for (i = 0; i < pThis->m_dwNum; i++)
      pafRelative[i] -= fPitchAverage; // so average around speakingpitch

   // filter so there isn't too much of a pitch delta
   for (i = 0; i < pThis->m_dwNum; i++) {
      int iWindow, iCur;
      f = fSum = 0;
      for (iWindow = -(RPWINDOWSIZE/2); iWindow <= (RPWINDOWSIZE/2); iWindow++) {
         iCur = iWindow + (int)i;
         if ((iCur < 0) || (iCur >= (int)pThis->m_dwNum))
            continue;

         fWeight = RPWINDOWSIZE/2 - abs(iWindow) + 1;
         f += fWeight;
         fSum += pafRelative[iCur] * fWeight;
      } // iCur

      if (f)
         fSum /= f;
      pafFilter[i] = fSum;
   } // i 

   
   // recobine into main pitch
   for (i = 0; i < pThis->m_dwNum; i++) {
      f = pafRelative[i] - pafFilter[i]; // so average around speakingpitch
      f = exp(f); // so no longer log
      f *= 100.0; // sine 100 is typical value

      pss = pThis->m_paSyl + i;
      f = RELATIVEPITCHWEIGHT * f + (1.0 - RELATIVEPITCHWEIGHT) * (fp)pss->bPitch;
      f = max(f,25);
      f = min(f,255);
      pss->bPitch = (BYTE) f;
   } // i

#if 0 // to test
   for (i = 0; i < pThis->m_dwNum; i++) {
      pss = pThis->m_paSyl + i;
      fprintf (file, "\r\nSyl %d : %x,%x,%x,%x,%x,%x,%x,%x,%x,%x",
         (DWORD) i,
         (DWORD)pss->bDurPhone, (DWORD)pss->bDurSyl, (DWORD)pss->bPauseProb, (DWORD)pss->bPitch,
         (DWORD)pss->bVol, (DWORD)(BYTE)pss->cPitchSweep, (DWORD)(BYTE)pss->cPitchBulge, (DWORD)pss->wWord,
         (DWORD)pThis->m_pabRuleDepth[i], (DWORD)pThis->m_pabPOS[i]);
   } // i

   fclose (file);
#endif // 0
#endif 0 // no longer used because replaced by SentenceSyllablesCombineWithProsody()

done:
   // free the list of lists
   for (i = 0; i < lPerSyl.Num(); i++)
      delete ppl[i];

#endif // TEMPLATEPROOSDYMODEL
}



/*************************************************************************************
CTTSProsodyMatchHyp::Constructor and destructor
*/
CTTSProsodyMatchHyp::CTTSProsodyMatchHyp (void)
{
   m_dwNextJoinIndex = 0;
   m_fScore = 0;
   m_iResynthNextSyl = 0;
   m_iJoinNextSyl = 0;
}

CTTSProsodyMatchHyp::~CTTSProsodyMatchHyp (void)
{
   // do nothing
}



/*************************************************************************************
CTTSProsodyMatchHyp::CloneTo - Standard clone to

inputs
   PCTTSProsodyMatchHyp    pTo - Clone to
returns
   BOOL - TRUE if successful
*/
BOOL CTTSProsodyMatchHyp::CloneTo (CTTSProsodyMatchHyp *pTo)
{
   m_SS.CloneTo (&pTo->m_SS);
   pTo->m_dwNextJoinIndex = m_dwNextJoinIndex;
   pTo->m_fScore = m_fScore;
   pTo->m_iResynthNextSyl = m_iResynthNextSyl;
   pTo->m_iJoinNextSyl = m_iJoinNextSyl;

   return TRUE;
}

/*************************************************************************************
CTTSProsodyMatchHyp::Clone - Standard API

inputs
   none
returns
   PCTTSProsodyMatchHyp - New object, NULL if error
*/
CTTSProsodyMatchHyp *CTTSProsodyMatchHyp::Clone (void)
{
   PCTTSProsodyMatchHyp pNew = new CTTSProsodyMatchHyp;
   if (!pNew)
      return NULL;

   if (!CloneTo (pNew)) {
      delete pNew;
      return NULL;
   }

   return pNew;
}


/*************************************************************************************
CTTSProsodyMatchHyp::IncludeJoinCosts - Bring join-costs calculations up to date.

inputs
   PCOMPARESYLINFO   pInfo - Score penalties to use.
   DWORD             dwNextResynthIndex - Next resynth index (into plResynth) that will be
                     be doing. Use this to determine where the m_SS sentence is valid
                     up to.
   PCListFixed       plResynth - List of PCSentenceMatch with all the matches to generate
                     the sentence. From GenerateMatches()
   PCListFixed       plJoin - List of PCSentenceMatch with all the joins for the sentence.
                     From GenerateMatches().
   DWORD             dwMaxJoin - Max join distance, from MaxJoinDistance().
   BOOL           fWord - if TRUE then making sure the word-based sentences are used.
                     If FALSE, then syllable-based sentences
   WORD              wPeriod - Word ID for a period
returns
   BOOL - TRUE if success
*/
BOOL CTTSProsodyMatchHyp::IncludeJoinCosts (PCOMPARESYLINFO pInfo, DWORD dwNextResynthIndex, PCListFixed plResynth,
                                            PCListFixed plJoin, DWORD dwMaxJoin, BOOL fWord, WORD wPeriod)
{
   // figure out what syllable number is valid up to
   int iSylValid;
   PCSentenceMatch *ppSM;
   PCSentenceMatch pSM;
   if (dwNextResynthIndex >= plResynth->Num())
      iSylValid = 1000000000; // valid to the end
   else {
      ppSM = (PCSentenceMatch*) plResynth->Get(dwNextResynthIndex);
      pSM = ppSM[0];

      iSylValid = pSM->m_iStartUse;
   }

   // note that we're included scores up to this one
   m_iJoinNextSyl = max(m_iJoinNextSyl, iSylValid - (int)dwMaxJoin * 2 + 1);
      // this is the technical maximum

   // repeat, trying the next join to see if it's OK to process it
   ppSM = (PCSentenceMatch*) plJoin->Get(0);
   DWORD i;
   CMem memWeight;
   while (m_dwNextJoinIndex < plJoin->Num()) {
      pSM = ppSM[m_dwNextJoinIndex];

      // if end of join goes beyond what's been calculated as valid then
      // stop
      if (pSM->m_iEnd > iSylValid)
         break;

      // NOTE: Some joins are fewer units than others, so they won't all be
      // calculated at the same pace... which means that the score comparison
      // will be slightly erroneous in the short term... but, bad candidates
      // can be elimniated more quickly
      // The foolproff way is to use dwMaxJoin + m_pSM->m_iEndUse

      // if no entries, then join cost is 0, so just skip. UNlikely that this
      // will happen, but it might
      if (!pSM->m_lSENTENCEMATCH.Num()) {
         m_dwNextJoinIndex++;
         continue;
      }

      // use beginning of this as a maximum for joins that have goten up to
      // NOTE: Not 100% technically correct since this join could be extra
      // small, and the next one larger, resulting in some erroneous elinianation
      // of data
      m_iJoinNextSyl = max(m_iJoinNextSyl, pSM->m_iStart + 1);
         // Add +1 because the next time eliminate will have advanced at least one syllable

      PSENTENCEMATCH paSM = (PSENTENCEMATCH) pSM->m_lSENTENCEMATCH.Get(0);

      // calculate the join weight
      fp *pafWindow = paSM[0].pSS->CompareWindowGenerate (0, paSM[0].dwNum, TRUE, &memWeight);
      if (!pafWindow)
         break;   // error

      // if get here have a join that can calculate because all the data
      // is valid
      fp fBestScore = 0;
      DWORD dwBestScore = (DWORD)-1;
      for (i = 0; i < pSM->m_lSENTENCEMATCH.Num(); i++) {
         // include how different/alike the join is compared to what commonly happens
         fp fScore = paSM[i].fScore;

         // quick skip
         if ((dwBestScore != (DWORD)-1) && (fScore >= fBestScore))
            continue;   // already worse, so don't bother going further
         
         // calculate how close the produced audio is compared to the hypothesized join
         _ASSERTE ((int)paSM[i].dwNum == (pSM->m_iEnd - pSM->m_iStart));
         fScore += m_SS.CompareSequenceWindowed (pInfo, pSM->m_iStart, paSM[i].pSS, paSM[i].iStart, paSM[i].dwNum,
            wPeriod, FALSE, fWord, pafWindow);

         // if this is better then remember it
         if ((dwBestScore == (DWORD)-1) || (fScore < fBestScore)) {
            dwBestScore = i;
            fBestScore = fScore;
         }
      } // i

      // scale the score by a triangle window sized based on the join compare area
      fBestScore *= (fp)paSM[dwBestScore].dwNum / 2.0;
      m_fScore += fBestScore;
      m_dwNextJoinIndex++;
   } // join
   
   return TRUE;
}



/*************************************************************************************
CTTSProsodyMatchHyp::Expand - Modify and clone this to produce alternate prosodies.

inputs
   PCOMPARESYLINFO   pInfo - Score penalties to use.
   DWORD             dwNextResynthIndex - Next resynth index (into plResynth) that will be
                     be doing.
   PCListFixed       plResynth - List of PCSentenceMatch with all the matches to generate
                     the sentence. From GenerateMatches()
   WORD              wPeriod - Word ID for a period
   PCListFixed       plPCTTSProsodyMatchHyp - Append all expansions to this hyp.
returns
   BOOL - TRUE if success
*/
BOOL CTTSProsodyMatchHyp::Expand (PCOMPARESYLINFO pInfo, DWORD dwNextResynthIndex, PCListFixed plResynth,
                                  WORD wPeriod, PCListFixed plPCTTSProsodyMatchHyp)
{
   PCTTSProsodyMatchHyp pNew;

   // if there's nothing to expand then just copy over
   if (dwNextResynthIndex >= plResynth->Num()) {
      pNew = Clone();
      if (!pNew)
         return FALSE;
      plPCTTSProsodyMatchHyp->Add (&pNew);
      return TRUE;
   }

   // blank syllables out for now
   PCSentenceMatch *ppSM;
   PCSentenceMatch pSM;
   int iSyl;
   ppSM = (PCSentenceMatch*) plResynth->Get(dwNextResynthIndex);
   pSM = ppSM[0];

   PSENTENCESYLLABLE paSylNew, paSylFrom;
   for (iSyl = pSM->m_iStartUse; iSyl < pSM->m_iEndUse; iSyl++) {
      // make sure it's in range
      if ((iSyl < 0) || (iSyl >= (int)m_SS.m_dwNum))
         continue;   // out of range

      paSylNew = &m_SS.m_paSyl[iSyl];

      // set defaults
      paSylNew->bDurPhone = 100;
      paSylNew->bDurSyl = 100;
      paSylNew->bPauseProb = 0;
      paSylNew->bPitch = 100;
      paSylNew->bVol = 100;
      paSylNew->cDurSkew = 0;
      paSylNew->cPitchBulge = 0;
      paSylNew->cPitchSweep = 0;
   } // iSyl

   // note that have filled in new audio up to this point
   m_iResynthNextSyl = max(m_iResynthNextSyl, pSM->m_iEndUse);

   // if there aren't any hypothesis to expand, then blank the syllable settings to default
   // and add
   if (!pSM->m_lSENTENCEMATCH.Num()) {
      pNew = Clone();
      if (!pNew)
         return FALSE;
      // add
      plPCTTSProsodyMatchHyp->Add (&pNew);
      return TRUE;
   }


   // if get here, create lots of clones, each taking a different path
   // in the possible sentences

   // calculate the window
   PSENTENCEMATCH paSM = (PSENTENCEMATCH)pSM->m_lSENTENCEMATCH.Get(0);
   //CMem memWeight;
   //fp *pafWindow = paSM[0].pSS->CompareWindowGenerate (0, paSM[0].dwNum, pSM->m_fTriangle, &memWeight);
   //if (!pafWindow)
   //   return FALSE;   // error


   // try different paths
   DWORD i;
   int iSylFrom, iSylFromRunnerUp;
   fp fScore;
   for (i = 0; i < pSM->m_lSENTENCEMATCH.Num(); i++, paSM++) {
      pNew = Clone();
      if (!pNew)
         return FALSE;

      // calculate the score
      fScore = paSM->fScore; // include how like/unlike it is from the norm
      _ASSERTE ((int)paSM->dwNum == (pSM->m_iEnd - pSM->m_iStart));
      // NOTE: Don't need to do the comparison since already precalculated and included in paSM->fScore
      //fScore += pNew->m_SS.CompareSequenceWindowed (pInfo, pSM->m_iStart, paSM->pSS, paSM->iStart, paSM->dwNum,
      //      wPeriod, TRUE, pafWindow); // non-prosody compare

      fScore *= (fp)(pSM->m_iEndUse - pSM->m_iStartUse); // include volume
      // Don't do this becausing only including the score for the syllables that are repealced
      //if (pSM->m_fTriangle)
      //   fScore /= 2.0; // since triangle has half volume
      pNew->m_fScore += fScore;

      // copy over prosody
      for (iSyl = pSM->m_iStartUse, 
            iSylFrom = paSM->iStart + (pSM->m_iStartUse - pSM->m_iStart),
            iSylFromRunnerUp = paSM->iStartRunnerUp + (pSM->m_iStartUse - pSM->m_iStart);
         iSyl < pSM->m_iEndUse; 
         iSyl++, iSylFrom++, iSylFromRunnerUp++) {
         // make sure it's in range
         if ((iSyl < 0) || (iSyl >= (int)pNew->m_SS.m_dwNum))
            continue;   // out of range
         if ((iSylFrom < 0) || (iSylFrom >= (int)paSM->pSS->m_dwNum))
            continue;   // out of range

         _ASSERTE ( pNew->m_SS.m_pabPOSStress[iSyl] == paSM->pSS->m_pabPOSStress[iSylFrom]);
         // _ASSERTE ( (pNew->m_SS.m_pabPOS[iSyl] & 0x8f) == (paSM->pSS->m_pabPOS[iSylFrom] & 0x8f));

#ifdef NOMODS_DISABLEPROSODYWORDMATCH
         // only let entire phrase matches through
         if (pSM->m_fTriangle)
            continue;   // don't modify this, leave as defaults
#endif
         // quick pointers
         paSylNew = &pNew->m_SS.m_paSyl[iSyl];
         paSylFrom = &paSM->pSS->m_paSyl[iSylFrom];

         // copy the prosody values over
         paSylNew->bDurPhone = paSylFrom->bDurPhone;
         paSylNew->bDurSyl = paSylFrom->bDurSyl;
         paSylNew->bPauseProb = paSylFrom->bPauseProb;
         paSylNew->bPitch = paSylFrom->bPitch;
         paSylNew->bVol = paSylFrom->bVol;
         paSylNew->cDurSkew = paSylFrom->cDurSkew;
         paSylNew->cPitchBulge = paSylFrom->cPitchBulge;
         paSylNew->cPitchSweep = paSylFrom->cPitchSweep;

#ifndef NOMODS_DISABLEPROSODYMERGEMATCH
         // if there's a runner up, average in
         if (paSM->pSSRunnerUp && (iSylFromRunnerUp >= 0) && (iSylFromRunnerUp < (int)paSM->pSSRunnerUp->m_dwNum) ) {
            _ASSERTE ( pNew->m_SS.m_pabPOSStress[iSyl] == paSM->pSSRunnerUp->m_pabPOSStress[iSylFromRunnerUp]);
            //_ASSERTE ( (pNew->m_SS.m_pabPOS[iSyl] & 0x8f) == (paSM->pSSRunnerUp->m_pabPOS[iSylFromRunnerUp] & 0x8f));

            paSylFrom = &paSM->pSSRunnerUp->m_paSyl[iSylFromRunnerUp];

            paSylNew->bDurPhone = (BYTE)(sqrt((fp)paSylNew->bDurPhone * (fp)paSylFrom->bDurPhone) + 0.5);
            paSylNew->bDurSyl = (BYTE)(sqrt((fp)paSylNew->bDurSyl * (fp)paSylFrom->bDurSyl) + 0.5);
            paSylNew->bPauseProb = ((paSylNew->bPauseProb & 0x0f) + (paSylFrom->bPauseProb & 0x0f)) / 2 + (paSylNew->bPauseProb & 0xf0);
            paSylNew->bPitch = (BYTE)(sqrt((fp)paSylNew->bPitch * (fp)paSylFrom->bPitch) + 0.5);
            paSylNew->bVol = (BYTE)(sqrt((fp)paSylNew->bVol * (fp)paSylFrom->bVol) + 0.5);
            paSylNew->cDurSkew = (char) (((int)paSylNew->cDurSkew + (int)paSylFrom->cDurSkew) / 2 + 1);
            paSylNew->cPitchBulge = (char) (((int)paSylNew->cPitchBulge + (int)paSylFrom->cPitchBulge) / 2 + 1);
            paSylNew->cPitchSweep = (char) (((int)paSylNew->cPitchSweep + (int)paSylFrom->cPitchSweep) / 2 + 1);
         }
#endif
      } // iSyl

      // add
      plPCTTSProsodyMatchHyp->Add (&pNew);
   } // i

   // done
   return TRUE;
}



/*************************************************************************************
CTTSProsodyMatchHyp::Compare - Compares this hypothesis against another one, and returns
a signed number indicating which is higher in the list.

inputs
   CTTSProsodyMatchHyp     *pWith - Compare with
   BOOL                    fIncludeScore - If the unscored syllables at the end are
                           an exact match, then this will go on to compare the scores.
                           If FALSE, then scores are NOT compared.
returns
   int - Positive if this appears lower in list, negative if higher, 0 if exact match
*/
int CTTSProsodyMatchHyp::Compare (CTTSProsodyMatchHyp *pWith, BOOL fIncludeScore)
{
   if (m_iJoinNextSyl != pWith->m_iJoinNextSyl)
      return m_iJoinNextSyl - pWith->m_iJoinNextSyl;  // shouldnt happen
   if (m_iResynthNextSyl != pWith->m_iResynthNextSyl)
      return m_iResynthNextSyl - pWith->m_iResynthNextSyl;  // shouldnt happen

   int iStart = max(m_iJoinNextSyl, 0);
   int iEnd = min(m_iResynthNextSyl, (int)m_SS.m_dwNum);
   int iRet;
   if (iStart < iEnd) {
      // only need to compare m_paSyl since that's all that changed
      iRet = memcmp (&m_SS.m_paSyl[iStart], &pWith->m_SS.m_paSyl[iStart], (iEnd - iStart) * sizeof(m_SS.m_paSyl[iStart]));
      if (iRet)
         return iRet;   // found a difference
   }

   // compare score
   if (fIncludeScore) {
      if (m_fScore > pWith->m_fScore)
         return 1;
      else if (m_fScore < pWith->m_fScore)
         return -1;
   }

   // else, no differnece
   return 0;
}



/*************************************************************************************
CSentenceMatch::Constructor and destructor
*/
CSentenceMatch::CSentenceMatch (void)
{
   m_lSENTENCEMATCH.Init (sizeof(SENTENCEMATCH));

   m_iStart = 0;
   m_iEnd = 0;
   m_fTriangle = TRUE;
   m_fIgnoreNotEnough = FALSE;
   m_fIgnoreProsody = FALSE;
   m_fSuccess = FALSE;
   m_fCompareAgainstTarget = FALSE;
   m_iStartUse = 0;
   m_iEndUse = 0;
}

CSentenceMatch::~CSentenceMatch (void)
{
   // do nothing
}



/*************************************************************************************
CSentenceMatch::FindAndScoreMatches - Finds all matches to the given sentence
and creates a "how typical is it" score. This modifies m_lSENTENCEMATCH
with the matched sentences

inputs
   PCMLexicon        pLexTTS - TTS with phonemes in it
   PCOMPARESYLINFO   pInfo - Score penalties to use.
   PCSentenceSyllable   pSS - Sentence that matching against
   CTTSProsody          **ppCTTSProsody - This of prosody objects to use for the comparison,
                        including this one.
   DWORD                dwNum - Number of prosody objects to use. Must be at least one
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL           fWord - if TRUE then making sure the word-based sentences are used.
                     If FALSE, then syllable-based sentences
   WORD              wPeriod - Word that indicates the punctuation

   LOTS of proeprties, see "user-settable, used by FindAndScoreMatched()"
returns
   BOOL - TRUE if success, FALSE if not enough matches to create a model
*/
BOOL CSentenceMatch::FindAndScoreMatches (PCMLexicon pLexTTS, PCOMPARESYLINFO pInfo, PCSentenceSyllable pSS,
                                          CTTSProsody **ppCTTSProsody, DWORD dwNum, int iTTSQuality, BOOL fWord, WORD wPeriod)
{
   // clear, just in case
   m_lSENTENCEMATCH.Clear();
   m_fSuccess = FALSE;
   if (!dwNum)
      return FALSE;

   // enumerate
   if (!ppCTTSProsody[0]->FindAllMatches (pLexTTS, pSS, m_iStart, m_iEnd, !m_fTriangle, fWord, ppCTTSProsody, dwNum, &m_lSENTENCEMATCH))
            // NOTE: If !m_fTriagle then must have an exact phrase match
      return FALSE;  // error

   // do comparisons
   m_fSuccess = ppCTTSProsody[0]->ScoreMatches (pInfo, &m_lSENTENCEMATCH, iTTSQuality, wPeriod, m_fIgnoreNotEnough, m_fIgnoreProsody,
      fWord, m_fTriangle,
      m_fCompareAgainstTarget ? pSS : NULL, m_iStart);

   return m_fSuccess;
}

/*************************************************************************************
CSentenceSyllable::Construcor and destructor
*/
CSentenceSyllable::CSentenceSyllable (void)
{
   m_dwNum = 0;
   m_pabPOSStress = NULL;
   m_pabSylIndex = NULL;
   m_pabRuleDepth = NULL;
   m_paSyl = NULL;
   m_lPOSStress.Init (sizeof(BYTE));
   m_lSylIndex.Init (sizeof(BYTE));
   m_lRuleDepth.Init (sizeof(BYTE));
   m_lSENTSYLPHRASE.Init (sizeof(SENTSYLPHRASE));
   m_lSENTENCESYLLABLE.Init (sizeof(SENTENCESYLLABLE));
}

CSentenceSyllable::~CSentenceSyllable (void)
{
   // do nothing for now
}



/*************************************************************************************
CSentenceSyllable::MemoryTouch - Call this occasionally to keep TTS from being
cached out of memory
*/
DWORD CSentenceSyllable::MemoryTouch (void)
{
   DWORD dwRet = 0;

   if (!m_dwNum)
      return 0;   // error

   DWORD dwIndex = (DWORD)rand() % m_dwNum;
   dwRet += m_pabPOSStress[dwIndex];
   dwRet += m_pabSylIndex[dwIndex];
   dwRet += m_pabRuleDepth[dwIndex];
   dwRet += m_paSyl[dwIndex].bDurPhone;

   return dwRet;
}


/*************************************************************************************
CSentenceSyllable::Clear - Clears out the information
*/
void CSentenceSyllable::Clear (void)
{
   m_dwNum = 0;
   m_lPOSStress.Clear();
   m_lSylIndex.Clear();
   m_lRuleDepth.Clear();
   m_lSENTSYLPHRASE.Clear();
   m_lSENTENCESYLLABLE.Clear();
}



/*************************************************************************************
CSentenceSyllable::Append - Append a sentence syllable onto this. It DOESN'T do
any word remapping.

inputs
   PCSentenceSyllable         pssAppend - to append
   DWORD                      dwStartIndex - Starting index. If -1 then uses 0.
   DWORD                      dwEndIndex - Ending index to append, If -1 then uses pssAppend->m_dwNum
returns
   BOOL - TRUE if success
*/
BOOL CSentenceSyllable::Append (PCSentenceSyllable pssAppend, DWORD dwStartIndex, DWORD dwEndIndex)
{
   DWORD i;
   if (dwStartIndex == (DWORD)-1)
      dwStartIndex = 0;
   if (dwEndIndex == (DWORD)-1)
      dwEndIndex = pssAppend->m_dwNum;
   DWORD dwNum = dwEndIndex - dwStartIndex;

   m_lPOSStress.Required (m_lPOSStress.Num() + dwNum);
   m_lSylIndex.Required (m_lPOSStress.Num() + dwNum);
   m_lRuleDepth.Required (m_lRuleDepth.Num() + dwNum);
   m_lSENTENCESYLLABLE.Required (m_lSENTENCESYLLABLE.Num() + dwNum);
   for (i = dwStartIndex; i < dwEndIndex; i++) {
      m_lPOSStress.Add (pssAppend->m_pabPOSStress + i);
      m_lSylIndex.Add (pssAppend->m_pabSylIndex + i);
      m_lRuleDepth.Add (pssAppend->m_pabRuleDepth + i);
      m_lSENTENCESYLLABLE.Add (pssAppend->m_paSyl + i);
   } // i

   // append the parses
   PSENTSYLPHRASE pSSP = (PSENTSYLPHRASE) pssAppend->m_lSENTSYLPHRASE.Get(0);
   SENTSYLPHRASE SSP;
   for (i = 0; i < pssAppend->m_lSENTSYLPHRASE.Num(); i++, pSSP++) {
      if ( ((DWORD)pSSP->wStart < dwStartIndex) || ((DWORD)pSSP->wEnd > dwEndIndex) )
         continue;   // not in part that appended

      SSP = *pSSP;
      SSP.wStart = SSP.wStart - (WORD)pSSP->wStart + m_dwNum;
      SSP.wEnd = SSP.wEnd - (WORD)pSSP->wStart + m_dwNum;

      m_lSENTSYLPHRASE.Add (&SSP);
   }

   m_dwNum = m_lSENTENCESYLLABLE.Num();
   m_pabPOSStress = (PBYTE)m_lPOSStress.Get(0);
   m_pabSylIndex = (PBYTE)m_lSylIndex.Get(0);
   m_pabRuleDepth = (PBYTE)m_lRuleDepth.Get(0);
   m_paSyl = (PSENTENCESYLLABLE) m_lSENTENCESYLLABLE.Get(0);

   return TRUE;
}


/*************************************************************************************
CSentenceSyllable::PARSERULEDEPTHToSENTSYLPHRASE - This internal method is recurve.
It takes a list of PARSERULEDEPTH structures, and uses them to figure out where
the phrases in the sentence begin and end.

inputs
   PPARSERULEDEPTH         pPRD - Array of PARSERULEDEPTH, one for each syllable already in the sentnece
   DWORD                   dwNum - Number of syllables in entire sentence. Won't ever add entire sentence as a rule
                              just to reduce memory storage
   DWORD                   dwStart - Start parsing at syllable number. Initially pass in 0.
   DWORD                   dwEnd - Finish parsing at syllable number (exclusive). Initially pass in number of elements in the sentence
   PCListFixed             plSENTSYLPHRASE - List initialized to sizeof SENTSYLPHRASE.
                              Whenever a new phrase is found (that's unique),
                              the phrase is added.
returns
   none
*/
void CSentenceSyllable::PARSERULEDEPTHToSENTSYLPHRASE (PPARSERULEDEPTH pPRD, DWORD dwNum, DWORD dwStart, DWORD dwEnd, PCListFixed plSENTSYLPHRASE)
{
   // if no entries then exit, or if only one, then don't add
   if (dwStart + 2 > dwEnd)
      return;

   // always add this, so long as not entire sentence
   DWORD i;
   if (dwStart || (dwEnd != dwNum)) {
      SENTSYLPHRASE SSP;
      SSP.wStart = (WORD)dwStart;
      SSP.wEnd = (WORD)dwEnd;

      // make sure no match
      PSENTSYLPHRASE pSSP = (PSENTSYLPHRASE)plSENTSYLPHRASE->Get(0);
      for (i = 0; i < plSENTSYLPHRASE->Num(); i++, pSSP++)
         if (!memcmp (pSSP, &SSP, sizeof(SSP)))
            return;  // already there. shouldnt happen

      // add it
      plSENTSYLPHRASE->Add (&SSP);
   }

   // find the minimum and maximum depths
   BYTE bMinDepth = 255, bMaxDepth = 0;
   for (i = dwStart; i < dwEnd; i++) {
      // minimum
      bMinDepth = min(bMinDepth, pPRD[i].bAfter);
      bMinDepth = min(bMinDepth, pPRD[i].bBefore);
      bMinDepth = min(bMinDepth, pPRD[i].bDuring);

      // maximum
      bMaxDepth = max(bMaxDepth, pPRD[i].bAfter);
      bMaxDepth = max(bMaxDepth, pPRD[i].bBefore);
      bMaxDepth = max(bMaxDepth, pPRD[i].bDuring);
   }

   // loop from minimum depth to maximum, looking for portions
   // of the syllable that are above water
   for (; bMinDepth < bMaxDepth; bMinDepth++) {

      // figure out where starts breaking the water
      DWORD dwStartSub;
      DWORD dwEndSub = dwStart;
      BOOL fAdded = FALSE;
      while (dwEndSub < dwEnd) {
         for (dwStartSub = dwEndSub; dwStartSub < dwEnd; dwStartSub++)
            if (pPRD[dwStartSub].bDuring > bMinDepth)
               break;
         if (dwStartSub >= dwEnd)
            break;   // never breaks the water

         // find out where this ends
         for (dwEndSub = dwStartSub + 1; dwEndSub < dwEnd; dwEndSub++) {
            // if after had sunk down then ends
            if (dwEndSub && pPRD[dwEndSub-1].bAfter <= bMinDepth)
               break;   // ends here

            // if beginning is below then end... shouldnt happen
            if (pPRD[dwEndSub].bBefore <= bMinDepth)
               break;
         } // dwEndSub

         // if have selected entire sequence, then don't bother because
         // already did this (since recursing)
         if ((dwStartSub <= dwStart) && (dwEndSub >= dwEnd))
            break;

         // remember that found at least one sequence above water
         fAdded = TRUE;

         // make sure that there are at least two words in this
         DWORD dwWords = 0;
         _ASSERTE (IsStartOfWord(dwStartSub));
         for (i = dwStartSub; i < dwEndSub; i++)
            if (IsStartOfWord (i))
               dwWords++;
         if (dwWords < 2)
            continue;   // shouldnt have gotten this, but appears to be only one word here

         // recurse and add this
         PARSERULEDEPTHToSENTSYLPHRASE (pPRD, dwNum, dwStartSub, dwEndSub, plSENTSYLPHRASE);

         // continue after this end and see if any other rules to add
      } // while haven't come to the end

      // if added anything then done
      if (fAdded)
         break;
      // otherwise, increase bMinDepth and continue

   } // bMinDepth

   // done
}


/*************************************************************************************
CSentenceSyllable::SetPARSERULEDEPTH - This takes an array of PARSERULEDEPTH
and uses them to set m_lSENTSYLPHRASE for the sentence. Call this AFTER all the
syllables have been added.

inputs
   PPARSERULEDEPTH      pPRD - Array of rule depths, one per syllable
   DWORD                dwNum - Number of rule-depth elements
returns
   BOOL - TRUE if success. Fail if dwNum != m_dwNum
*/
BOOL CSentenceSyllable::SetPARSERULEDEPTH (PPARSERULEDEPTH pPRD, DWORD dwNum)
{
   if (dwNum != m_dwNum)
      return FALSE;

   // clear out existing list
   m_lSENTSYLPHRASE.Init (sizeof(SENTSYLPHRASE));

   // recurse and add
   PARSERULEDEPTHToSENTSYLPHRASE (pPRD, dwNum, 0, dwNum, &m_lSENTSYLPHRASE);

   return TRUE;
}


/*************************************************************************************
CSentenceSyllable::EnumWords - This fills in a list with all the words, their
starts, and their lengths in syllables.

inputs
   PCListFixed       plSSENUMWORDS - Initialized and filled in with one SSENUMWORDS
                     entry per word, in sequence
   PCListFixed       plRemap - Can be NULL. Intiialized and filled with one DWORD
                     per syllable. Each entry is filled with the word number.
returns
   none
*/
void CSentenceSyllable::EnumWords (PCListFixed plSSENUMWORDS, PCListFixed plRemap)
{
   plSSENUMWORDS->Init (sizeof(SSENUMWORDS));
   if (plRemap)
      plRemap->Init (sizeof(DWORD));

   DWORD i;
   SSENUMWORDS sew;
   PSSENUMWORDS pSEW;
   DWORD dwNumWords;
   memset (&sew, 0, sizeof(sew));
   for (i = 0; i < m_dwNum; i++) {
      // first one is always the start of a word, or text
      if (!i || IsStartOfWord(i)) {
         // add the entry
         sew.dwStart = i;
         sew.dwLength = 1;
         plSSENUMWORDS->Add (&sew);
      }
      else {
         // else, it's a continuation
         pSEW = (PSSENUMWORDS)plSSENUMWORDS->Get(plSSENUMWORDS->Num()-1);
         pSEW->dwLength++;
      }

         // add the remap
      if (plRemap) {
         dwNumWords = plSSENUMWORDS->Num()-1;
         plRemap->Add (&dwNumWords);
      }

   } // i
}


/*************************************************************************************
CSentenceSyllable::ToWords - Converts a sentence composed of syllables into
a sentence with one "syllable" entry per word.

NOTE: Because m_pabRuleDepth only stores 2 bits for the number of phonemes,
the high 4 bits of m_paSyl->bPauseProb will contain bits 2-6 of the number
of phonemes in the word.

returns
   PCSentenceSyllable - Word-only syllable. NULL if error
*/
CSentenceSyllable *CSentenceSyllable::ToWords (void)
{
   PCSentenceSyllable pSS = Clone();
   if (!pSS)
      return NULL;

   // enumerate the words and their mapping
   CListFixed lSSENUMWORDS, lRemap;
   EnumWords (&lSSENUMWORDS, &lRemap);

   // combine syllables together
   DWORD dwWord, dwSyl, dwCurSyl;
   PSSENUMWORDS pSEW = (PSSENUMWORDS)lSSENUMWORDS.Get(0);
   for (dwWord = 0; dwWord < lSSENUMWORDS.Num(); dwWord++, pSEW++) {
      DWORD dwPhonemesTotal = 0;

      // copy some bits over
      dwCurSyl = pSEW->dwStart;
      pSS->m_pabPOSStress[dwWord] = m_pabPOSStress[dwCurSyl] & 0x0f; // only keep POS. Toss out stress and syllable number
      pSS->m_pabSylIndex[dwWord] = 0;  // toss out syllable number
      pSS->m_pabRuleDepth[dwWord] = m_pabRuleDepth[dwCurSyl];  // keep all, but will change nubmer of syllables later
      pSS->m_paSyl[dwWord] = m_paSyl[dwCurSyl];

      // average a lot
      fp fWeightSum = 0.0;
      fp fPitch = 0.0, fPitchSweep = 0.0, fPitchBulge = 0.0, fVol = 0.0, fDurPhone = 0.0, fDurSyl = 0.0, fDurSkew = 0.0;

      PSENTENCESYLLABLE pSyl = &m_paSyl[dwCurSyl];
      for (dwSyl = 0; dwSyl < pSEW->dwLength; dwSyl++, dwCurSyl++, pSyl++) {
         DWORD dwPhonemesInThis = ((m_pabRuleDepth[dwCurSyl] >> 4) & 0x03) + 1;
         dwPhonemesTotal += dwPhonemesInThis;

         // weight
         fp fWeight = (fp)dwPhonemesInThis;
         fWeightSum += fWeight;
         fPitch += log((fp)pSyl->bPitch) / log(2.0) * fWeight;
         fPitchSweep += (fp)pSyl->cPitchSweep * fWeight;
         fPitchBulge += (fp)pSyl->cPitchBulge * fWeight;
         fVol += log((fp)pSyl->bVol) / log(2.0) * fWeight;
         fDurPhone += log((fp)pSyl->bDurPhone) / log(2.0) * fWeight;
         fDurSyl += log((fp)pSyl->bDurSyl) / log(2.0) * fWeight;
         fDurSkew += (fp)pSyl->cDurSkew * fWeight;
      } // dwSyl

      // Store back
      pSyl = &pSS->m_paSyl[dwWord];
      fWeightSum = 1.0 / fWeightSum;

      fPitch = pow(2.0, fPitch * fWeightSum) + 0.5;
      fPitch = max(fPitch, 0.0);
      fPitch = min(fPitch, 255.0);
      pSyl->bPitch = (BYTE)fPitch;

      fVol = pow(2.0, fVol * fWeightSum) + 0.5;
      fVol = max(fVol, 0.0);
      fVol = min(fVol, 255.0);
      pSyl->bVol = (BYTE)fVol;

      fDurPhone = pow(2.0, fDurPhone * fWeightSum) + 0.5;
      fDurPhone = max(fDurPhone, 0.0);
      fDurPhone = min(fDurPhone, 255.0);
      pSyl->bDurPhone = (BYTE)fDurPhone;

      fDurSyl = pow(2.0, fDurSyl * fWeightSum) + 0.5;
      fDurSyl = max(fDurSyl, 0.0);
      fDurSyl = min(fDurSyl, 255.0);
      pSyl->bDurSyl = (BYTE)fDurSyl;

      fPitchSweep = fPitchSweep * fWeightSum + 0.5;
      fPitchSweep = max(fPitchSweep, -128.0);
      fPitchSweep = min(fPitchSweep, 127.0);
      pSyl->cPitchSweep = (char)floor(fPitchSweep);

      fPitchBulge = fPitchBulge * fWeightSum + 0.5;
      fPitchBulge = max(fPitchBulge, -128.0);
      fPitchBulge = min(fPitchBulge, 127.0);
      pSyl->cPitchBulge = (char)floor(fPitchBulge);

      fDurSkew = fDurSkew * fWeightSum + 0.5;
      fDurSkew = max(fDurSkew, -128.0);
      fDurSkew = min(fDurSkew, 127.0);
      pSyl->cDurSkew = (char)floor(fDurSkew);

      // write out the number of phonemes
      dwPhonemesTotal--;   // so 0-based
      pSS->m_pabRuleDepth[dwWord] = (pSS->m_pabRuleDepth[dwWord] & 0xcf) | ((dwPhonemesTotal & 0x03) << 4);
      pSS->m_paSyl[dwWord].bPauseProb = (pSS->m_paSyl[dwWord].bPauseProb & 0x0f) | ((dwPhonemesTotal >> 2) << 4);
   } // dwWord

   // tuncate the list
   pSS->m_dwNum = lSSENUMWORDS.Num();
   pSS->m_lPOSStress.Truncate (pSS->m_dwNum);
   pSS->m_lSylIndex.Truncate (pSS->m_dwNum);
   pSS->m_lRuleDepth.Truncate (pSS->m_dwNum);
   pSS->m_lSENTENCESYLLABLE.Truncate (pSS->m_dwNum);
   // just in case was moved
   pSS->m_pabPOSStress = (PBYTE)pSS->m_lPOSStress.Get(0);
   pSS->m_pabSylIndex = (PBYTE)pSS->m_lSylIndex.Get(0);
   pSS->m_pabRuleDepth = (PBYTE)pSS->m_lRuleDepth.Get(0);
   pSS->m_paSyl = (PSENTENCESYLLABLE) pSS->m_lSENTENCESYLLABLE.Get(0);

   // fix phrase markings
   PSENTSYLPHRASE pSSP = (PSENTSYLPHRASE) pSS->m_lSENTSYLPHRASE.Get(0);
   DWORD *padwRemap = (DWORD*)lRemap.Get(0);
   DWORD i;
   for (i = 0; i < pSS->m_lSENTSYLPHRASE.Num(); i++, pSSP++) {
      pSSP->wStart = (WORD)padwRemap[pSSP->wStart];
      pSSP->wEnd = (WORD)padwRemap[pSSP->wEnd];
   }

   return pSS;
}


/*************************************************************************************
CSentenceSyllable::FromWords - Call this on a sentence made of words (from ToWords()),
to convert it back to syllables.

inputs
   PCSentenceSyllable   pOrig - Original sentence, which still has all the syllables.
returns
   PCSentenceSyllable - Copy of this converted back to syllables (from one "syllable" per word)
*/
CSentenceSyllable *CSentenceSyllable::FromWords (CSentenceSyllable *pOrig)
{
   // clone the original and just copy prosody info
   PCSentenceSyllable pSS = pOrig->Clone();
   if (!pSS)
      return NULL;

   // enumerate the words and their mapping
   CListFixed lSSENUMWORDS;
   pSS->EnumWords (&lSSENUMWORDS, NULL);

   // make sure match up. Shouldnt happen
   if (lSSENUMWORDS.Num() != m_dwNum) {
      delete pSS;
      return NULL;
   }

   PSSENUMWORDS pSEW = (PSSENUMWORDS) lSSENUMWORDS.Get(0);
   DWORD dwWord, dwCurSyl, dwSyl;
   for (dwWord = 0; dwWord < lSSENUMWORDS.Num(); dwWord++, pSEW++) {
      dwCurSyl = pSEW->dwStart;

      // copy the syllables in this word back
      PSENTENCESYLLABLE pSylSS = &pSS->m_paSyl[dwCurSyl];
      PSENTENCESYLLABLE pSylThis = &m_paSyl[dwWord];
      for (dwSyl = 0; dwSyl < pSEW->dwLength; dwSyl++, dwCurSyl++, pSylSS++) {
         pSylSS->bDurPhone = pSylThis->bDurPhone;
         pSylSS->bDurSyl = pSylThis->bDurSyl;
         pSylSS->bPauseProb = pSylThis->bPauseProb & 0x0f;  // 0x0f gets rid of high nibble with number of syllables in it
         pSylSS->bPitch = pSylThis->bPitch;
         pSylSS->bVol = pSylThis->bVol;
         pSylSS->cDurSkew = pSylThis->cDurSkew;
         pSylSS->cPitchBulge = pSylThis->cPitchBulge;
         pSylSS->cPitchSweep = pSylThis->cPitchSweep;
      } // dwSyl, in the word
   } // dwWord

   // done
   return pSS;
}

/*************************************************************************************
CSentenceSyllable::IsStartOfWord - Given an index, see if at the start of a word

inputs
   DWORD    dwIndex- Index from 0 .. m_dwNum-1
returns
   BOOL - TRUE if at start
*/
BOOL CSentenceSyllable::IsStartOfWord (DWORD dwIndex)
{
   // if first
   if (!dwIndex)
      return TRUE;

   // syllable 0
   if (m_pabSylIndex[dwIndex] & 0x7)
      return FALSE;
   else
      return TRUE;

#if 0 // not needed
   // if POS changed
   if ((m_pabPOS[dwIndex-1] & 0x0f) != (m_pabPOS[dwIndex] & 0x0f))
      return TRUE;

   // if any of the high-bits of rule depth info changed
   if ((m_pabRuleDepth[dwIndex-1] & 0xc0) != (m_pabRuleDepth[dwIndex] & 0xc0))
      return TRUE;

   // if words changed
   if (m_paSyl[dwIndex-1].wWord != m_paSyl[dwIndex].wWord)
      return TRUE;

   // NOTE: A series of two-syllable words with the same POS, same rule depth, could get through

   // else, not
   return FALSE;
#endif
}

/*************************************************************************************
CSentenceSyllable::CloneTo - Standard api
*/
BOOL CSentenceSyllable::CloneTo (CSentenceSyllable *pTo)
{
   pTo->m_lPOSStress.Init (sizeof(BYTE), m_lPOSStress.Get(0), m_lPOSStress.Num());
   pTo->m_lSylIndex.Init (sizeof(BYTE), m_lSylIndex.Get(0), m_lSylIndex.Num());
   pTo->m_lRuleDepth.Init (sizeof(BYTE), m_lRuleDepth.Get(0), m_lRuleDepth.Num());
   pTo->m_lSENTENCESYLLABLE.Init (sizeof(SENTENCESYLLABLE), m_lSENTENCESYLLABLE.Get(0), m_lSENTENCESYLLABLE.Num());
   pTo->m_lSENTSYLPHRASE.Init (sizeof(SENTSYLPHRASE), m_lSENTSYLPHRASE.Get(0), m_lSENTSYLPHRASE.Num());

   pTo->m_dwNum = pTo->m_lSENTENCESYLLABLE.Num();
   pTo->m_pabPOSStress = (PBYTE)pTo->m_lPOSStress.Get(0);
   pTo->m_pabSylIndex = (PBYTE)pTo->m_lSylIndex.Get(0);
   pTo->m_pabRuleDepth = (PBYTE)pTo->m_lRuleDepth.Get(0);
   pTo->m_paSyl = (PSENTENCESYLLABLE) pTo->m_lSENTENCESYLLABLE.Get(0);

   return TRUE;
}


/*************************************************************************************
CSentenceSyllable::Clone - Standard api
*/
CSentenceSyllable *CSentenceSyllable::Clone (void)
{
   PCSentenceSyllable pNew = new CSentenceSyllable;
   if (!pNew)
      return NULL;

   if (!CloneTo (pNew)) {
      delete pNew;
      return NULL;
   }

   return pNew;
}


/*************************************************************************************
CSentenceSyllable::RemapWords - Loop through all the word IDs and remap them
from one lexicon to the next. This is used when transferring the prosody model
from one TTS voice to the next

inputs
   PCMLexicon        pLexOrig - Lexicon that the word IDs currently come from
   PCMLexicon        pLexNew - New lexicon to use
   BOOL              fAddIfNotExist - If TRUE then add the word to pLexNew if
                     it doesn't exist.
   PCListFixed       plPCSentenceSyllable - If this is not NULL, then all the
                     sentence syllables will have their word ID's increased
                     if they're >= the added word. Ignored if !fAddIfNotExist.
returns
   none
*/
void CSentenceSyllable::RemapWords (PCMLexicon pLexOrig, PCMLexicon pLexNew,
                                    BOOL fAddIfNotExist, PCListFixed plPCSentenceSyllable)
{
   PSENTENCESYLLABLE pss = (PSENTENCESYLLABLE) m_lSENTENCESYLLABLE.Get(0);
   PSENTENCESYLLABLE pssOrig = pss;
   DWORD i, j, k;
   WCHAR szWord[256];
   CListVariable lForm;
   for (i = 0; i < m_lSENTENCESYLLABLE.Num(); i++, pss++) {
      if (pss->wWord == (WORD)-1)
         continue;   // nothing to remap

      if (!pLexOrig->WordGet (pss->wWord, szWord, sizeof(szWord), NULL)) {
         // cant find word in original, which shouldnt happen
         pss->wWord = (WORD)-1;
         continue;
      }

      // find it in the new one
      DWORD dwWord = pLexNew->WordFind (szWord);
      pss->wWord = (dwWord < 0xffff) ? (WORD)dwWord : (WORD)-1;

      if (pss->wWord != (WORD) -1)
         continue;

      // consider adding
      if (!fAddIfNotExist)
         continue;
      pLexNew->WordSet (szWord, &lForm);
      dwWord = pLexNew->WordFind (szWord);
      pss->wWord = (dwWord < 0xffff) ? (WORD)dwWord : (WORD)-1;

      // modify in this sentence
      for (k = 0; k < i; k++)
         if ((pssOrig[k].wWord != (WORD)-1) && (pssOrig[k].wWord >= pss->wWord))
            pssOrig[k].wWord++;  // since just inserted before it

      // modify in sentence syllable
      if (plPCSentenceSyllable) {
         PCSentenceSyllable *ppss = (PCSentenceSyllable*)plPCSentenceSyllable->Get(0);
         for (j = 0; j < plPCSentenceSyllable->Num(); j++) {
            PCSentenceSyllable pss2 = ppss[j];

            for (k = 0; k < pss2->m_dwNum; k++)
               if ((pss2->m_paSyl[k].wWord != (WORD)-1) && (pss2->m_paSyl[k].wWord >= pss->wWord))
                  pss2->m_paSyl[k].wWord++;  // since just inserted before it
         } // j
      } // if plPCSentenceSyllable
   } // i
}


/*************************************************************************************
CSentenceSyllable::PhoneGroupBitsCalc - Calculte the phone group bits.

inputs
   PBYTE          pabPhone - Array of phoneme numbers for the phonemes in the syllable.
   DWORD          dwNum - Number of phonemes
   PCMLexicon     pLex - Lexicon to use
returns
   DWORD - Value to pass into CSentenceSyllable::Add ()
*/
DWORD CSentenceSyllable::PhoneGroupBitsCalc (PBYTE pabPhone, DWORD dwNum, PCMLexicon pLex)
{
   DWORD wRet = 0;
   DWORD i;
   for (i = 0; i < dwNum; i++, pabPhone++) {
      PLEXPHONE plp = pLex->PhonemeGetUnsort (*pabPhone);
      if (!plp)
         continue;   // shouldnt happen

      PLEXENGLISHPHONE ple = MLexiconEnglishPhoneGet(plp->bEnglishPhone);
      if (!ple)
         continue;

      DWORD dwGroup = PIS_FROMPHONEGROUP(ple->dwShape);
      if (!dwGroup)
         continue;   // since silence
      dwGroup--;

      // set bit
      wRet |= (1 << dwGroup);
   } // i

   return wRet;
}

/*************************************************************************************
CSentenceSyllable::ReplaceUnknownPOSWithNoun - Loop through the sentence syllable
and replace any unknown parts of speech with "noun" parts of speech.
*/
void CSentenceSyllable::ReplaceUnknownPOSWithNoun (void)
{
   DWORD i;
   PBYTE pabPOSStress = m_pabPOSStress;
   for (i = 0; i < m_dwNum; i++, pabPOSStress++) {
      if ((pabPOSStress[0] & 0x0f) == POS_MAJOR_EXTRACT(POS_MAJOR_UNKNOWN))
         pabPOSStress[0] = (pabPOSStress[0] & 0xf0) | POS_MAJOR_EXTRACT(POS_MAJOR_NOUN);
   } // i
}

/*************************************************************************************
CSentenceSyllable::Add - Adds a new syllable onto the end of the sentence.

inputs
   DWORD          dwWord - Word index, into internal lexicon of words in the trianing
                           set. If the word isn't there, or is unknown, then use -1.
   BYTE           bPOSStress - Part of speech, in the low nibble.
   BYTE           bSylIndex - Low 3 bits are the syllable index
   BYTE           bRuleDepth - Rule depth in low nibble, as set of two 2-bit values.
   PSENTSYLEMPH   pEmph - Emphasis information.
   BYTE           bStress - Stress number, from 0+ for the phoneme
   // DWORD          dwSyllable - Syllable number. 0 = 1st syllable, 1 = 2nd, etc.
   DWORD          dwPhonemes - Number of phonemes in the syllable
   DWORD          dwWordRank - Word rank, in how common. 0 is the most common, 3 is the least.
                                       2 is used for a normally-3 word that was recently spoken
   DWORD          dwPauseProb - Probability of a pause before. 0 (none) to 15 (100%).
                                 Should have subtracted the micropause probability from this
   DWORD          dwPhonemeGroupBits - From PhoneGroupBitsCalc()
returns
   BOOL - TRUE if success
*/
BOOL CSentenceSyllable::Add (DWORD dwWord, BYTE bPOSStress, BYTE bSylIndex, BYTE bRuleDepth, PSENTSYLEMPH pEmph, BYTE bStress,
                             DWORD dwPhonemes, DWORD dwWordRank, DWORD dwPauseProb,
                             DWORD dwPhonemeGroupBits)
{
   // BUGFIX - was only going stressed in high bit... but instead store syllable inforamation
   // too.
   bPOSStress = (bPOSStress & 0x0f) | (bStress << 4);
   m_lPOSStress.Add (&bPOSStress);
   bSylIndex = (BYTE)bSylIndex & 0x07;
   m_lSylIndex.Add (&bSylIndex);
   if (dwPhonemes)
      dwPhonemes--;  // since everything should have at least one phoneme
   dwPhonemes = min(dwPhonemes, 3); // to bits
   dwWordRank = min(dwWordRank, 3); // to make sure
   bRuleDepth = (bRuleDepth & 0x0f) | ((BYTE)dwPhonemes << 4) | ((BYTE)dwWordRank << 6);
   m_lRuleDepth.Add (&bRuleDepth);

   SENTENCESYLLABLE ss;
   fp f;
   memset (&ss, 0, sizeof(ss));
   ss.wWord = (dwWord < 0xffff) ? (WORD)dwWord : (WORD)-1;
   ss.wPhoneGroupBits = (WORD)dwPhonemeGroupBits;
   ss.bPauseProb = (BYTE)dwPauseProb;

   // pitch
   f = pEmph->fPitch * 100.0;
   f = max(f, 50);
   f = min(f, 200);
   ss.bPitch = (BYTE)(f+0.5);

   // pitch sweep
   f = pEmph->fPitchSweep * 100.0;
   f = max(f, -120);
   f = min(f, 120);
   ss.cPitchSweep = (char)(int)floor(f+0.5);

   // pitch bulge
   f = pEmph->fPitchBulge * 100.0;
   f = max(f, -120);
   f = min(f, 120);
   ss.cPitchBulge = (char)(int)floor(f+0.5);

   // volume
   f = pEmph->fVolume * 100.0;
   f = max(f, 50);
   f = min(f, 200);
   ss.bVol = (BYTE)(f+0.5);

   // duration phone
   f = pEmph->fDurPhone * 100.0;
   f = max(f, 50);
   f = min(f, 200);
   ss.bDurPhone = (BYTE)(f+0.5);

   // duration, syllable
   f = pEmph->fDurSyl * 100.0;
   f = max(f, 50);
   f = min(f, 200);
   ss.bDurSyl = (BYTE)(f+0.5);

   // pitch sweep
   f = pEmph->fDurSkew * 100.0;
   f = max(f, -120);
   f = min(f, 120);
   ss.cDurSkew = (char)(int)floor(f+0.5);

   m_lSENTENCESYLLABLE.Add (&ss);

   m_dwNum = m_lSENTENCESYLLABLE.Num();
   m_pabPOSStress = (PBYTE)m_lPOSStress.Get(0);
   m_pabSylIndex = (PBYTE)m_lSylIndex.Get(0);
   m_pabRuleDepth = (PBYTE)m_lRuleDepth.Get(0);
   m_paSyl = (PSENTENCESYLLABLE) m_lSENTENCESYLLABLE.Get(0);

   return TRUE;
}


/*************************************************************************************
CSentenceSyllable::MMLToBinary - Converts this syllable information into binary
form and appends it onto the end of pMem. pMem's m_dwCurPosn is updated to include
the new memory
*/
BOOL CSentenceSyllable::MMLToBinary (PCMem pMem)
{
   // how much need
   SENTSYLHEADER SSH;
   SSH.dwNum = m_dwNum;
   SSH.dwPhrases = m_lSENTSYLPHRASE.Num();
   size_t dwNeed = sizeof(SSH) + m_dwNum * (sizeof(BYTE) + sizeof(BYTE) + sizeof(BYTE) + sizeof(SENTENCESYLLABLE)) +
      sizeof(SENTSYLPHRASE) * SSH.dwPhrases +
      pMem->m_dwCurPosn;
   if (!pMem->Required (dwNeed))
      return FALSE;

   // info
   PBYTE pbCur = (PBYTE)pMem->p + pMem->m_dwCurPosn;
   pMem->m_dwCurPosn = dwNeed;

   // copy number of syllables
   memcpy (pbCur, &SSH, sizeof(SSH));
   pbCur += sizeof(SSH);

   // copy syllable POS
   memcpy (pbCur, m_pabPOSStress, m_dwNum * sizeof(BYTE));
   pbCur += m_dwNum * sizeof(BYTE);

   // copy syllable sylindex
   memcpy (pbCur, m_pabSylIndex, m_dwNum * sizeof(BYTE));
   pbCur += m_dwNum * sizeof(BYTE);

   // copy syllable rule depth
   memcpy (pbCur, m_pabRuleDepth, m_dwNum * sizeof(BYTE));
   pbCur += m_dwNum * sizeof(BYTE);

   // copy syllable details
   memcpy (pbCur, m_paSyl, m_dwNum * sizeof(SENTENCESYLLABLE));
   pbCur += m_dwNum * sizeof(SENTENCESYLLABLE);

   // copy the phrases
   memcpy (pbCur, m_lSENTSYLPHRASE.Get(0), SSH.dwPhrases * sizeof(SENTSYLPHRASE));

   // done
   return TRUE;
}


/*************************************************************************************
CSentenceSyllable::MMLFromBinary - Reads in a sentence syllable from binary memory

inputs
   PBYTE       pabMem - Memory to read from
   DWORD       dwLeft - Number of bytes left in the memory
returns
   DWORD - Number of bytes actually used, or 0 if error
*/
size_t CSentenceSyllable::MMLFromBinary (PBYTE pabMem, size_t dwLeft)
{
   SENTSYLHEADER SSH;
   if (dwLeft < sizeof(SSH))
      return 0;

   memcpy (&SSH, pabMem, sizeof(SSH));
   pabMem += sizeof(SSH);
   dwLeft -= sizeof(SSH);
   DWORD dwUsed = sizeof(SSH);
   m_dwNum = SSH.dwNum;

   // make sure enough
   DWORD dwNeed = m_dwNum * (sizeof(BYTE) + sizeof(BYTE) + sizeof(BYTE) + sizeof(SENTENCESYLLABLE)) + SSH.dwPhrases * sizeof(SENTSYLPHRASE);
   if (dwLeft < dwNeed)
      return 0;
   dwUsed += dwNeed;

   // get the syllables
   m_lPOSStress.Init (sizeof(BYTE), pabMem, m_dwNum);
   pabMem += m_dwNum * sizeof(BYTE);
   m_lSylIndex.Init (sizeof(BYTE), pabMem, m_dwNum);
   pabMem += m_dwNum * sizeof(BYTE);
   m_lRuleDepth.Init (sizeof(BYTE), pabMem, m_dwNum);
   pabMem += m_dwNum * sizeof(BYTE);
   m_lSENTENCESYLLABLE.Init (sizeof(SENTENCESYLLABLE), pabMem, m_dwNum);
   pabMem += m_dwNum * sizeof(SENTENCESYLLABLE);
   m_lSENTSYLPHRASE.Init (sizeof(SENTSYLPHRASE), pabMem, SSH.dwPhrases);

   // update pointers
   m_pabPOSStress = (PBYTE)m_lPOSStress.Get(0);
   m_pabSylIndex = (PBYTE)m_lSylIndex.Get(0);
   m_pabRuleDepth = (PBYTE)m_lRuleDepth.Get(0);
   m_paSyl = (PSENTENCESYLLABLE) m_lSENTENCESYLLABLE.Get(0);

   return dwUsed;
}



/*************************************************************************************
CSentenceSyllable::AddToIndex - Method that causes the sentence to add
refernces to itself to an index of two sequential part-of-speech combinations (stressed
and unstressed). The items added to the index range from (-1,0) to (Num in sentence, Num
in sentence+1)

inputs
   PCMLexicon        pLexTTS - Lexicon to use
   PCListFixed       *ppaIndex - Pointer to anrray with [POS_MAJOR_NUMPLUSONE][MAXSTRESSES][POS_MAJOR_NUMPLUSONE][MAXSTRESSES] entries.
                              [POS of 1st element][Stress of 1st element][POS of 2nd element][Stress of 2nd element].
                              Each list should have been initialized to use a SENTENCEINDEX structure
returns
   BOOL - TRUE if success
*/
BOOL CSentenceSyllable::AddToIndex (PCMLexicon pLexTTS, PCListFixed *ppaIndex)
{
   int i, iCur;
   DWORD dwOffset;
   DWORD adwPOS[2];
   DWORD adwStress[2];
   SENTENCEINDEX si;
   memset (&si, 0, sizeof(si));
   // DWORD dwStresses = pLexTTS->Stresses();
   for (i = -1; i <= (int)m_dwNum; i++) { // intentionally using <=
      for (dwOffset = 0; dwOffset < 2; dwOffset++) {
         iCur = i + (int)dwOffset;

         if ((iCur < 0) || (iCur >= (int)m_dwNum)) {
            // out of range
            adwPOS[dwOffset] = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
            adwStress[dwOffset] = 0;
         }
         else {
            adwPOS[dwOffset] = m_pabPOSStress[iCur] & 0x0f;
            adwStress[dwOffset] = (m_pabPOSStress[iCur] >> 4) & 0x0f;
         }
      } // dwOffset

      si.iStart = i;
      si.pSS = this;

      DWORD dwIndex = (adwPOS[0] * MAXSTRESSES + adwStress[0]) * (POS_MAJOR_NUMPLUSONE*MAXSTRESSES) +
         (adwPOS[1] * MAXSTRESSES + adwStress[1]);
      if (!ppaIndex[dwIndex]) {
         ppaIndex[dwIndex] = new CListFixed;
         if (!ppaIndex[dwIndex])
            return FALSE;  // error
         ppaIndex[dwIndex]->Init (sizeof(SENTENCEINDEX));
      }
      ppaIndex[dwIndex]->Add (&si);
   } // i

   return TRUE;
}


/*************************************************************************************
CSentenceSyllable::CompareRegion - This compares a region of this sentence with
a region of another and determines how close (acoustically) the sentences are to
one another. The more different, the higher the score.

The acoustic comparison uses pitch, duration, and volume.

inputs
   PCOMPARESYLINFO pInfo - Score penalties to use.
   int                  iOffsetThis - Offset into this
   CSentenceSyllable    *pTest - Sentence to compare to
   int                  iOffsetTest - Offset into test
   BOOL           fWord - If TRUE then the sentence is a list of words, FALSE then list of syllables.
                     If list of words, duration of the phoneme is gotten slightly differently
   WORD                 wPeriod - Word that indicates the punctuation
returns
   fp - Score, from 0 +. Low scores are better
*/

fp CSentenceSyllable::CompareRegion (PCOMPARESYLINFO pInfo, int iOffsetThis, CSentenceSyllable *pTest, int iOffsetTest, BOOL fWord, WORD wPeriod)
{
   fp fScore = 0;
   fp fCount = 0;
   // BYTE bPOSThis, bPOSTest;
   // PSENTENCESYLLABLE pssThis, pssTest;
   fp fErr, fWeightThis;
   int iCur, iCurThis, iCurTest;
   for (iCur = -COMPAREREGIONSIZE; iCur <= COMPAREREGIONSIZE; iCur++) {
      iCurThis = iOffsetThis + iCur;
      iCurTest = iOffsetTest + iCur;

      fErr = CompareSingleSyllable (pInfo, iCurThis, pTest, iCurTest, wPeriod, TRUE, FALSE, fWord);

#if 0 // old code
      // get values
      if ((iCurThis < 0) || (iCurThis >= (int)m_dwNum)) {
         bPOSThis = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
         pssThis = NULL;
      }
      else {
         bPOSThis = m_pabPOS[iCurThis];
         pssThis = &m_paSyl[iCurThis];
      }
      if ((iCurTest < 0) || (iCurTest >= (int)pTest->m_dwNum)) {
               // BUGFIX - Was checking against m_dwNum, should have been pTest->m_dwNum
         bPOSTest = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
         pssTest = NULL;
      }
      else {
         bPOSTest = pTest->m_pabPOS[iCurTest];
         pssTest = &pTest->m_paSyl[iCurTest];
      }

      // figure out the unweighted error
      if ((bPOSTest & 0x8f) != (bPOSThis & 0x8f))
         dwErr = MAXCOMPAREREGIONERR;  // maximum error
      else if ((bPOSThis & 0x0f) == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION))
         dwErr = 0;  // assume no error
      else
         dwErr = CompareSENTENCESYLLABLE (pssThis, pssTest);
#endif // 0

      fWeightThis = COMPAREREGIONSIZE - (DWORD)abs(iCur) + 1;
      fCount += fWeightThis;
      fScore += fWeightThis * fErr;
   } // iCur

   return fScore / fWeightThis;
}

/*************************************************************************************
CSentenceSyllable::CompareSingleSyllable - This compares a single syllable
in this sentence against a single syllable in another.

NOTE: Assume that both the sentences are using the same lexicon.

inputs
   PCOMPARESYLINFO pInfo - Score penalties to use.
   int            iOffsetThis - Offset, in syllable, in this sentence. This can
                  be a negative number or >= the number of syllables, in which
                  case the last syllable is assumed to be the punctuation ('.', '!', '?')
                  for the sentence.
   PCSentenceSyllable pTest - Sentence to test agsint
   int            iOffsetTest - Offset into test, like iOffsetThis
   WORD           wPeriod - Word number for period, used as default punctiation
   BOOL           fIgnorePOS - If TRUE then ignore the part of speech mismatches
   BOOL           fIgnoreProsody - Set to TRUE if duration, energy, F0 are unknown in at least one of the setneces
   BOOL           fWord - If TRUE then the sentence is a list of words, FALSE then list of syllables.
                     If list of words, duration of the phoneme is gotten slightly differently

returns
   fp - Score. Lower is better. If this is >= COMPARESINGLESYLLABLE_NOMATCH
         then the syllables are different parts of speech, and not compared.
*/
// #define WORDMISMATCHPENALTY               2     // penalize for no word match
// #define PUNCTMISMATCHPENALTY              (WORDMISMATCHPENALTY*8)   // higher pentalty for punctuation mismatch
                                          // BUGFIX - Was *2, increase to *4 to encourage punctation match
                                          // BUGFIX - Was *4, increased to *8

fp CSentenceSyllable::CompareSingleSyllable (PCOMPARESYLINFO pInfo, int iOffsetThis, PCSentenceSyllable pTest,
                                              int iOffsetTest, WORD wPeriod, BOOL fIgnorePOS, BOOL fIgnoreProsody,
                                              BOOL fWord)
{
   // figure out parameters for this
   BYTE bPOSStressThis, bSylThis;
   WORD wWordThis;
   BYTE bDepthThis;
   PSENTENCESYLLABLE pSSThis;
   if ((iOffsetThis < 0) || (iOffsetThis >= (int)m_dwNum)) {
      // beyond the end of the sentences
      bPOSStressThis = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
      bSylThis = 0;
      if (m_dwNum && ((m_pabPOSStress[m_dwNum-1] & 0x0f) == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION)))
         wWordThis = m_paSyl[m_dwNum-1].wWord;
      else
         wWordThis = wPeriod;
      pSSThis = NULL;
      bDepthThis = 0;
   }
   else {
      bPOSStressThis = m_pabPOSStress[iOffsetThis];
      bSylThis = m_pabSylIndex[iOffsetThis] & 0x07;
      pSSThis = &m_paSyl[iOffsetThis];
      bDepthThis = m_pabRuleDepth[iOffsetThis];
      wWordThis = pSSThis->wWord;
   }

   // figure out the parameters for what comparing
   BYTE bPOSStressTest, bSylTest;
   WORD wWordTest;
   BYTE bDepthTest;
   PSENTENCESYLLABLE pSSTest;
   if ((iOffsetTest < 0) || (iOffsetTest >= (int)pTest->m_dwNum)) {
      // beyond the end of the sentences
      bPOSStressTest = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
      bSylTest = 0;
      if (pTest->m_dwNum && ((pTest->m_pabPOSStress[pTest->m_dwNum-1] & 0x0f) == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION)))
         wWordTest = pTest->m_paSyl[pTest->m_dwNum-1].wWord;
      else
         wWordTest = wPeriod;
      pSSTest = NULL;
      bDepthTest = 0;
   }
   else {
      bPOSStressTest = pTest->m_pabPOSStress[iOffsetTest];
      bSylTest = pTest->m_pabSylIndex[iOffsetTest];
      pSSTest = &pTest->m_paSyl[iOffsetTest];
      bDepthTest = pTest->m_pabRuleDepth[iOffsetTest];
      wWordTest = pSSTest->wWord;
   }

#if 0
   // BUGFIX - If low-nibble is punctation then make all punct
   if ((bPOSThis & 0x0f) == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION))
      bPOSThis &= 0x0f;
   if ((bPOSTest & 0x0f) == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION))
      bPOSTest &= 0x0f;
#endif // 0

   // BUGFIX - Put in asserts to double-check that have non-unknown POS for everything
   // disabling because dont need anymore
   // _ASSERTE (bPOSThis & 0x0f);
   // _ASSERTE (bPOSTest & 0x0f);

   // if syllable POS not the same, then max error
   if ((bPOSStressThis != bPOSStressTest) && (bSylThis != bSylTest) && !fIgnorePOS)
      return COMPARESINGLESYLLABLE_NOMATCH;

   // if it's just punctuation then simple test
   if ((bPOSStressTest == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION)) && (bPOSStressThis == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION))) {
      if (wWordThis == wWordTest)
         return 0;   // no error
      else
         return pInfo->fPunctMismatchPenalty; // since mismatched punctation
   }

   fp fError = 0.0;

   // word mismatch
   if ((wWordThis != wWordTest) || (wWordThis == (WORD)-1))
      fError += pInfo->fWordMismatchPenalty;


   // guestimate duration
   int iSylA, iSylB;
   if (fWord) {
      iSylA = ((bDepthThis & 0x30) >> 4) + ((pSSThis->bPauseProb >> 4) << 2) + 1;
      iSylB = ((bDepthTest & 0x30) >> 4) + ((pSSTest->bPauseProb >> 4) << 2) + 1;
   }
   else {
      iSylA = (int)((bDepthThis & 0x30) >> 4) + 1;
      iSylB = (int)((bDepthTest & 0x30) >> 4) + 1;
   }
   
   // convert to floating point
   fp fDurA = iSylA, fDurB = iSylB;
   if (pSSThis && pSSThis->bDurPhone && pSSThis->bDurSyl && !fIgnoreProsody)
      fDurA *= (pSSThis->bDurPhone + pSSThis->bDurSyl) / (100.0 * 2.0);
   if (pSSTest && pSSTest->bDurPhone && pSSTest->bDurSyl && !fIgnoreProsody)
      fDurB *= (pSSTest->bDurPhone + pSSTest->bDurSyl) / (100.0 * 2.0);
   fp fDurLog = log(fDurA / fDurB) / log(2.0);
   fError += fabs(fDurLog) * pInfo->fDuration;

   // duration bulge
   if (pSSThis && pSSTest && !fIgnoreProsody)
      fError += fabs((fp)pSSThis->cDurSkew - (fp)pSSTest->cDurSkew) / 100.0 * pInfo->fDuration;
      // NOTE: Not exactly the right value to use for duration bulge, but a guess


   // energy
   if (pSSThis && pSSTest && pSSThis->bVol && pSSTest->bVol && !fIgnoreProsody) {
      fp fEnergyLog = log((fp)pSSThis->bVol / (fp)pSSTest->bVol) / log(2.0);
      fError += fabs(fEnergyLog) * pInfo->fEnergy;
   }

   // pitch at 3 points
   if (pSSThis && pSSTest && !fIgnoreProsody) {
      if (pSSThis->bPitch && pSSTest->bPitch) {
         fp fPitchLog = log((fp)pSSThis->bPitch / (fp)pSSTest->bPitch) / log(2.0);
         fError += fabs(fPitchLog) * pInfo->fPitch;
      }
      fError += (fabs((fp)pSSThis->cPitchBulge - (fp)pSSTest->cPitchBulge) +
         fabs((fp)pSSThis->cPitchSweep - (fp)pSSTest->cPitchSweep)) / 100.0 * pInfo->fPitch;
   }

   // function word mistmatch
   int iRankA = (int)((bDepthThis & 0xc0) >> 6);
   int iRankB = (int)((bDepthTest & 0xc0) >> 6);
   if (iRankA != iRankB)
      fError += (fp) abs(iRankA - iRankB) * pInfo->fFuncWord * FUNCWORDGROUPPERPROSODYMODELCOMMON;

   // start of word mistmatch
   // BYTE bSylThis = (bPOSThis >> 4) & 0x07;
   // BYTE bSylTest = (bPOSTest >> 4) & 0x07;
   if ( (!bSylThis && bSylTest) || (!bSylTest && bSylThis) )
      fError += pInfo->fWordPosMismatchStart;   // mismatch at the start of the word

   // end of word mistmatch
   iOffsetThis++;
   iOffsetTest++;
   BYTE bSylThis2, bSylTest2;
   if ((iOffsetThis < 0) || (iOffsetThis >= (int)m_dwNum)) {
      // beyond the end of the sentences
      bPOSStressThis = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
      bSylThis2 = 0;
   }
   else {
      bPOSStressThis = m_pabPOSStress[iOffsetThis];
      bSylThis2 = m_pabSylIndex[iOffsetThis] & 0x07;
   }
   if ((iOffsetTest < 0) || (iOffsetTest >= (int)pTest->m_dwNum)) {
      // beyond the end of the sentences
      bPOSStressTest = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
      bSylTest2 = 0;
   }
   else {
      bPOSStressTest = pTest->m_pabPOSStress[iOffsetTest];
      bSylTest2 = pTest->m_pabSylIndex[iOffsetTest] & 0x07;
   }
   if ((bPOSStressThis & 0x0f) != (bPOSStressTest & 0x0f))
      fError += pInfo->fWordPosMismatchEnd;  // since different POS, know end of word
   else {
      // BYTE bSylThis2 = (bPOSThis >> 4) & 0x07;
      // BYTE bSylTest2 = (bPOSTest >> 4) & 0x07;

      if (bSylThis2 >= 7)
         bSylThis2++;   // since max out at 7
      if (bSylTest2 >= 7)
         bSylTest2++;   // since max out at 7

      BOOL fNewWordThis = (bSylThis2 <= bSylThis);
      BOOL fNewWordTest = (bSylTest2 <= bSylTest);
      if ( (fNewWordThis && !fNewWordTest) || (fNewWordTest && !fNewWordThis) )
         fError += pInfo->fWordPosMismatchEnd;  // changed syllable numbers so know at end
   }

#if 0 // no longer doing rule-depth comparisons
   // if rule depths are different then error
   int iDepthA1 = (int)(bDepthThis & 0x03);
   int iDepthA2 = (int)((bDepthThis & 0x0c) >> 2);
   int iDepthB1 = (int)(bDepthTest & 0x03);
   int iDepthB2 = (int)((bDepthTest & 0x0c) >> 2);
   iError += (abs(iDepthA1 - iDepthB1) + abs(iDepthA2 - iDepthB2));  // different depths
   iError += ((iDepthA1 - iDepthA2) - (iDepthB1 - iDepthB2)) * 2; // start/end indicator
#endif


#if 0 // no longer doing this
   // BUGFIX - Compare phonemes
   DWORD dwXOR = pSSThis->wPhoneGroupBits ^ pSSTest->wPhoneGroupBits;
   DWORD dwDiff;
   for (dwDiff = 0; dwXOR; dwDiff++, dwXOR = dwXOR & (dwXOR-1));
   iError += ((int)dwDiff+1)/2;  // so add one penalty per phoneme difference.
         // Use /2 since if two phonemes don't match then will (usually) get 2 points worth of error
#endif // 0

   return fError;
}


/*************************************************************************************
CSentenceSyllable::CompareSingleSyllableQuick - This quickly compares a single syllable
in this sentence against a single syllable in another.

NOTE: Assume that both the sentences are using the same lexicon.

inputs
   int            iOffsetThis - Offset, in syllable, in this sentence. This can
                  be a negative number or >= the number of syllables, in which
                  case the last syllable is assumed to be the punctuation ('.', '!', '?')
                  for the sentence.
   PCSentenceSyllable pTest - Sentence to test agsint
   int            iOffsetTest - Offset into test, like iOffsetThis

returns
   BOOL - TRUE if the same POS and stress, FALSE if different
*/

__inline fp CSentenceSyllable::CompareSingleSyllableQuick (int iOffsetThis, PCSentenceSyllable pTest, int iOffsetTest)
{
   // figure out parameters for this
   BYTE bPOSStressThis;
   if ((iOffsetThis < 0) || (iOffsetThis >= (int)m_dwNum))
      // beyond the end of the sentences
      bPOSStressThis = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
   else
      bPOSStressThis = m_pabPOSStress[iOffsetThis];

   // figure out the parameters for what comparing
   BYTE bPOSStressTest;
   if ((iOffsetTest < 0) || (iOffsetTest >= (int)pTest->m_dwNum))
      bPOSStressTest = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
   else
      bPOSStressTest = pTest->m_pabPOSStress[iOffsetTest];

   // NOTE: Ignroing syllable index, but ignored syllable index before
   return (bPOSStressThis == bPOSStressTest);
}


/*************************************************************************************
CSentenceSyllable::CompareSequence - Compares one sentence with another, based on offsets.

NOTE: Assume that both the sentences are using the same lexicon.

inputs
   PCOMPARESYLINFO pInfo - Score penalties to use.
   int            iOffsetThis - offset, in syllables, into THIS sentence that
                     will be the start.
   PCSentenceSyllable - Sentence to test against
   int            iOffsetTest - Offset, in syllables, into the TEST sentence.
   WORD           wPeriod - Word number for period, used as default punctiation. -1 if don't know
   BOOL           fIgnoreProsody - Set to TRUE if duration, energy, F0 are unknown in at least one of the setneces
   BOOL           fWord - If TRUE then the sentence is a list of words, FALSE then list of syllables.
                     If list of words, duration of the phoneme is gotten slightly differently
   PBESTSENTSWEEP pSweep - Filled in with information if there's a match.

returns
   BOOL - TRUE if success and pSweep is filled in, FALSE if no match
*/

BOOL CSentenceSyllable::CompareSequence (PCOMPARESYLINFO pInfo, int iOffsetThis, PCSentenceSyllable pTest,
                                 int iOffsetTest, WORD wPeriod, BOOL fIgnoreProsody, BOOL fWord, PBESTSENTSWEEP pSweep)
{
   fp fCompare;

   // quick test - iOffsetThis < 0, then make sure that compare is OK
   // when the sentence actually starts
   if (iOffsetThis < 0) {
      fCompare = CompareSingleSyllable (pInfo, 0, pTest, iOffsetTest - iOffsetThis, wPeriod, FALSE, fIgnoreProsody, fWord);
      if (fCompare >= COMPARESINGLESYLLABLE_NOMATCH)
         return FALSE;
   }

   // quick test - If iOffsetTest < 0, then make sure match at start
   if (iOffsetTest < 0) {
      fCompare = CompareSingleSyllable (pInfo, iOffsetThis - iOffsetTest, pTest, 0, wPeriod, FALSE, fIgnoreProsody, fWord);
      if (fCompare >= COMPARESINGLESYLLABLE_NOMATCH)
         return FALSE;
   }

   // loop
   int iOffsetCur;
   fp fScore = 0.0;
   for (iOffsetCur = iOffsetThis; iOffsetCur < (int)m_dwNum + PUNCTEXTRA; iOffsetCur++) {
      fCompare = CompareSingleSyllable (pInfo, iOffsetCur, pTest, iOffsetTest + iOffsetCur - iOffsetThis, wPeriod, FALSE, fIgnoreProsody, fWord);
      if (fCompare >= COMPARESINGLESYLLABLE_NOMATCH)
         break;   // end of match

      fScore += fCompare;
   } // iOffsetCur
   if (iOffsetCur <= iOffsetThis)
      return FALSE;  // no match at all

   // else, found something
   pSweep->iOffsetTest = iOffsetTest;
   pSweep->dwSylMatch = (DWORD)(iOffsetCur - iOffsetThis);
   fScore += pInfo->fCrossSentencePenalty; // always assume that crossed sentence at some point
   pSweep->fScoreAvg = fScore / (fp)pSweep->dwSylMatch;  // BUGFIX - Was multiplying by 16, but dont do know that using fp
      // NOTE: Multiplying iScoreAvg by 16 so more resolution
   pSweep->pSent = pTest;
   return TRUE;
}


/*************************************************************************************
CSentenceSyllable::CompareSequenceQuick - Qiuckly compares part of one sentence with another, based on offsets.

inputs
   int            iOffsetThis - offset, in syllables, into THIS sentence that
                     will be the start.
   PCSentenceSyllable - Sentence to test against
   int            iOffsetTest - Offset, in syllables, into the TEST sentence.
   DWORD          dwNum - Number of syllables to compare

returns
   BOOL - TRUE if the two match, FALSE if they're different
*/

BOOL CSentenceSyllable::CompareSequenceQuick (int iOffsetThis, PCSentenceSyllable pTest,
                                 int iOffsetTest, DWORD dwNum)
{
   DWORD i;
   for (i = 0; i < dwNum; i++, iOffsetThis++, iOffsetTest++)
      if (!CompareSingleSyllableQuick (iOffsetThis, pTest, iOffsetTest))
         return FALSE;

   return TRUE;
}


/*************************************************************************************
CSentenceSyllable::CompareWindowGenerate - Generates a window used to compare
two lists of syllables (for CompareSequenceWindowed()).

inputs
   int            iStart - Start
   int            iEnd - End (exclusive). iEnd > iStart.
   BOOL           fTriangle - If TRUE then create a triangle window. FALSE then a square window
   PCMem          pMem - Will be initialized to sizeof(fp) and filled with (iEnd - iStart) elements.
returns
   fp * - Start of the window (to pass into CompareSequenceWIndowed()), or NULL if error
*/
fp* CSentenceSyllable::CompareWindowGenerate (int iStart, int iEnd, BOOL fTriangle, PCMem pMem)
{
   if (iEnd <= iStart)
      return NULL;   // error
   DWORD dwNum = (DWORD)(iEnd - iStart);


   if (!pMem->Required (dwNum * sizeof(fp)))
      return FALSE;
   fp *pf = (fp*)pMem->p;

   DWORD i;
   fp fSum = 0.0;
   for (i = 0; i < dwNum; i++) {
      if (fTriangle)
         pf[i] = ((fp)i+0.5 > (fp)dwNum/2.0) ? ((fp)dwNum - ((fp)i+0.5)) : ((fp)i+0.5);
      else
         pf[i] = 1.0;

      fSum += pf[i];
   } // i

   // normalize
   fSum = 1.0 / fSum;
   for (i = 0; i < dwNum; i++)
      pf[i] *= fSum;

   return pf;
}



/*************************************************************************************
CSentenceSyllable::CompareSequenceWindowed - Compares one sentence with another, based on offsets.

NOTE: Assume that both the sentences are using the same lexicon.

inputs
   PCOMPARESYLINFO pInfo - Score penalties to use.
   int            iOffsetThis - offset, in syllables, into THIS sentence that
                     will be the start.
   PCSentenceSyllable - Sentence to test against
   int            iOffsetTest - Offset, in syllables, into the TEST sentence.
   DWORD          dwNum - Number of syllables to test.
   WORD           wPeriod - Word number for period, used as default punctiation. -1 if don't know
   BOOL           fIgnoreProsody - Set to TRUE if duration, energy, F0 are unknown in at least one of the setneces
   BOOL           fWord - If TRUE then the sentence is a list of words, FALSE then list of syllables.
                     If list of words, duration of the phoneme is gotten slightly differently
   fp             *pafWindow - From CompareWindowGenerate().

returns
   fp - Score
*/

fp CSentenceSyllable::CompareSequenceWindowed (PCOMPARESYLINFO pInfo, int iOffsetThis, PCSentenceSyllable pTest,
                                 int iOffsetTest, DWORD dwNum, WORD wPeriod, BOOL fIgnoreProsody, BOOL fWord, fp *pafWindow)
{
   fp fSum = 0.0;
   DWORD i;
   for (i = 0; i < dwNum; i++, iOffsetThis++, iOffsetTest++, pafWindow++)
      fSum += CompareSingleSyllable (pInfo, iOffsetThis, pTest, iOffsetTest, wPeriod, TRUE, fIgnoreProsody, fWord) * pafWindow[0];
   
   return fSum;
}


#if 0 // Old code, made obsolete when converted to beam search
/*************************************************************************************
CSentenceSyllable::Compare- Compares one sentence with another, based on offsets.

NOTE: Assume that both the sentences are using the same lexicon.

inputs
   DWORD          dwOffsetThis - offset, in syllables, into THIS sentence that
                     will be the start.
                  NOTE: This should have PUNCTEXTRA POS_MAJOR_PUNCTUATION syllables
                     already pre-attached to the end. This ends up causing
                     sentences that end together to have a higher score. The
                     same happens for ones beginning
   PCSentenceSyllable - Sentence to test against
   DWORD          dwOffsetTest - Offset, in syllables, into the TEST sentence.
   PBESTSENTSWEEP pSweep - Filled in with information if there's a match.

returns
   BOOL - TRUE if success and pSweep is filled in, FALSE if no match
*/

BOOL CSentenceSyllable::Compare (DWORD dwOffsetThis, PCSentenceSyllable pTest,
                                 DWORD dwOffsetTest, PBESTSENTSWEEP pSweep)
{
   // quick test, if the two central values don't match at all then
   // fail
   if (m_pabPOS[dwOffsetThis] != pTest->m_pabPOS[dwOffsetTest])
      return FALSE;

   // number of syllables left
   DWORD dwLeftThis = m_dwNum - dwOffsetThis;
   DWORD dwLeftTest = pTest->m_dwNum - dwOffsetTest + PUNCTEXTRA;
   DWORD dwLeft = min(dwLeftThis, dwLeftTest);
   DWORD i;
   DWORD dwCurThis = dwOffsetThis;
   DWORD dwCurTest = dwOffsetTest;
   DWORD dwWordMatch = 0;

#define MAXWORDERROR     10       // maximum number of error points before considers too different
      // BUGFIX - Upped from 8 because also testing for phoneme difference

   // figure out what punctuation is at the end for both of these sentences
   WORD wPunctTest = (WORD)-1, wPunctThis = (WORD)-1;
   if (pTest->m_dwNum && ((pTest->m_pabPOS[pTest->m_dwNum-1] & 0x0f) == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION)))
      wPunctTest = pTest->m_paSyl[pTest->m_dwNum-1].wWord;
   if (m_dwNum && ((m_pabPOS[m_dwNum-1] & 0x0f) == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION)))
      wPunctThis = m_paSyl[m_dwNum-1].wWord;

   DWORD dwErrors;
   for (i = 0; i < dwLeft; i++, dwCurThis++, dwCurTest++) {
      // errors
      dwErrors = 0;

      if (dwCurTest >= pTest->m_dwNum) {
         // pretend there's punctuation at the end
         if (m_pabPOS[dwCurThis] != POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION))
            break;
         else {
            // BUGFIX - If type of punctuation deosnt match then reduce amount
            if (m_paSyl[dwCurThis].wWord != wPunctTest)
               dwErrors += WORDMISMATCHPENALTY;

            dwWordMatch += MAXWORDERROR - dwErrors;
            continue;
         }
      }

      if (m_pabPOS[dwCurThis] != pTest->m_pabPOS[dwCurTest])
         break;


      // if not the same word, then error
      if ((m_paSyl[dwCurThis].wWord != pTest->m_paSyl[dwCurTest].wWord) || (m_paSyl[dwCurThis].wWord == (WORD)-1))
         dwErrors += WORDMISMATCHPENALTY;

      BYTE bDepthThis = m_pabRuleDepth[dwCurThis];
      BYTE bDepthTest = pTest->m_pabRuleDepth[dwCurTest];
      // if rule depths are different then error
      int iDepthA1 = (int)(bDepthThis & 0x03);
      int iDepthA2 = (int)((bDepthThis & 0x0c) >> 2);
      int iDepthB1 = (int)(bDepthTest & 0x03);
      int iDepthB2 = (int)((bDepthTest & 0x0c) >> 2);
      dwErrors += (DWORD) (abs(iDepthA1 - iDepthB1) + abs(iDepthA2 - iDepthB2));  // different depths
      dwErrors += (DWORD) ((iDepthA1 - iDepthA2) - (iDepthB1 - iDepthB2)) * 2; // start/end indicator

      // if different number of syllables then error
      int iSylA = (int)((bDepthThis & 0x30) >> 4);
      int iSylB = (int)((bDepthTest & 0x30) >> 4);
      dwErrors += (DWORD) abs(iSylA - iSylB);

      // compare word rank
      int iRankA = (int)((bDepthThis & 0xc0) >> 6);
      int iRankB = (int)((bDepthTest & 0xc0) >> 6);
      dwErrors += (DWORD) abs(iRankA - iRankB);

      // BUGFIX - Compare phonemes
      DWORD dwXOR = m_paSyl[dwCurThis].wPhoneGroupBits ^ pTest->m_paSyl[dwCurTest].wPhoneGroupBits;
      DWORD dwDiff;
      for (dwDiff = 0; dwXOR; dwDiff++, dwXOR = dwXOR & (dwXOR-1));
      dwErrors += (dwDiff+1)/2;  // so add one penalty per phoneme difference.
            // Use /2 since if two phonemes don't match then will (usually) get 2 points worth of error

      // if too much error then stop
      if (dwErrors >= MAXWORDERROR)
         break;

      // else, increase word match
      dwWordMatch += (MAXWORDERROR - dwErrors);
   } // i

   // BUGFIX - In case decided to abort right away
   if (!i)
      return FALSE;

   DWORD dwScore = dwWordMatch;
   if (!dwOffsetThis && !dwOffsetTest) {
      dwErrors = 0;
      if (wPunctTest != wPunctThis)
         dwErrors += WORDMISMATCHPENALTY;  // since not the right type of punctuation at end of sentence
                                          // and automatically transferring to beginning

      dwScore += (PUNCTEXTRA - dwErrors) * MAXWORDERROR;  // since both started at beginning of sentence
         // BUGFIX - dwScore was only incremented by PUNCEXTRA
   }
   // NOTE: PunctExtra already added at the end

   pSweep->dwOffset = dwOffsetTest;
   pSweep->dwScore = dwScore;   // NOTE: Squaring score so long sequences are encouraged
      // dwScore * dwScore
      // BUGFIX - Took out square because doing some different weighting by ranking
      // NOTE: Made a HUGE difference in quality when took out square!
   pSweep->dwSylMatch = i;
   pSweep->pSent = pTest;
   return TRUE;
}
#endif


/*************************************************************************************
CSentenceSyllable::CompareSweepSequence - This finds all matches of this sentence in
the test sentence, and adds any matches to plBESTSENTSWEEP.

inputs
   PCOMPARESYLINFO pInfo - Score penalties to use.
   int            iOffsetThis - offset, in syllables, into THIS sentence that
                     will be the start. Can be negative too, or beyond edge of sentnece
   PCSentenceSyllable pTest - Sentence to test against
   WORD           wPeriod - Word number for period, used as default punctiation. -1 if don't know
   BOOL           fIgnoreProsody - Set to TRUE if duration, energy, F0 are unknown in at least one of the setneces
   PCListFixed    plBESTSENTSWEEP - This should be filled in with a set of
                     BESTSENTSWEEP that are already known for dwOffsetThis.
                     They should be in sorted order, from LOWEST score to
                     HIGHEST.
                     
                     If pTest is already represented on
                     plBESTSENTSWEEP, AND the right dwOffset is there,
                     then this won't bother doing a sweep for it.

                     If a comparison is successful AND its score is better
                     than the worse score (or there are empty slots) then
                     it will be added.
   DWORD          dwSlots - Number of slots allowed in plBESTSENTSWEEP.
                     Basically, keep the best N of these.
   PCListFixed    plBESTSENTSWEEPExclude - If find a match for any of these
                     then don't bother adding them to plBESTSENTSWEEP.
                     Can be NULL.
returns
   none
*/
void CSentenceSyllable::CompareSweepSequence (PCOMPARESYLINFO pInfo, int iOffsetThis, PCSentenceSyllable pTest,
                                      WORD wPeriod, BOOL fIgnoreProsody, PCListFixed plBESTSENTSWEEP, DWORD dwSlots,
                                      PCListFixed plBESTSENTSWEEPExclude)
{
   // see if this sentence is mentioned at all in plBESTSENTSWEEP. If it isn't then
   // note that, so won't need to check again
   BOOL fIsMentioned = FALSE;
   DWORD i, j, k;
   PBESTSENTSWEEP pBSS = (PBESTSENTSWEEP) plBESTSENTSWEEP->Get(0);
   for (i = 0; i < plBESTSENTSWEEP->Num(); i++)
      if (pBSS[i].pSent == pTest)
         fIsMentioned = TRUE;
   PBESTSENTSWEEP pBSSExclude = plBESTSENTSWEEPExclude ? (PBESTSENTSWEEP) plBESTSENTSWEEPExclude->Get(0) : NULL;
   if (pBSSExclude) for (i = 0; i < plBESTSENTSWEEPExclude->Num(); i++)
      if (pBSSExclude[i].pSent == pTest)
         fIsMentioned = TRUE;

   // loop to see if matches any
   BESTSENTSWEEP Sweep;
   int iOffsetTest;
   for (iOffsetTest = -PUNCTEXTRA; iOffsetTest < (int)pTest->m_dwNum; iOffsetTest++) { // NOTE: NOT going beyond pTest->m_dwNum
      if (!CompareSequence (pInfo, iOffsetThis, pTest, iOffsetTest, wPeriod, fIgnoreProsody, FALSE, &Sweep))
         continue;   // no match

      // if this score is too low then stop now
      // check before suck up cycles with a rand() call
      if ((plBESTSENTSWEEP->Num() >= dwSlots) && (pBSS[dwSlots-1].fScoreAvg <= Sweep.fScoreAvg))
         continue;   // score too high

      // make sure this isn't already on the list
      if (fIsMentioned) {
         // try the existing senteces
         for (j = 0; j < plBESTSENTSWEEP->Num(); j++)
            if ((pBSS[j].pSent == pTest) && (pBSS[j].iOffsetTest == iOffsetTest))
               break;
         if (j < plBESTSENTSWEEP->Num())
            continue;   // already exists, so dont re-add

         // try the exclude
         if (plBESTSENTSWEEPExclude) {
            for (j = 0; j < plBESTSENTSWEEPExclude->Num(); j++)
               if ((pBSSExclude[j].pSent == pTest) && (pBSSExclude[j].iOffsetTest == iOffsetTest))
                  break;
            if (j < plBESTSENTSWEEPExclude->Num())
               continue;   // already exists, so dont re-add
         }
      }
      
      // else, is reasonable score, so want to add
      DWORD dwOldNum = plBESTSENTSWEEP->Num();
      if (dwOldNum < dwSlots) {
         plBESTSENTSWEEP->Add (&Sweep);   // temp
         pBSS = (PBESTSENTSWEEP) plBESTSENTSWEEP->Get(0);
      }

      // find where it fits and insert it
      for (j = 0; j < dwOldNum; j++)
         if (Sweep.fScoreAvg < pBSS[j].fScoreAvg)
            break;   // insert before point
      if (j >= plBESTSENTSWEEP->Num())
         continue;   // shouldnt happen

      Sweep.plfScoreSyl = new CListFixed;
      if (!Sweep.plfScoreSyl)
         continue;   // shouldnt happen
      Sweep.plfScoreSyl->Init (sizeof(Sweep.fScoreSyl));
      for (k = 0; k < Sweep.dwSylMatch; k++) {
         Sweep.fScoreSyl = CompareSingleSyllable (pInfo, iOffsetThis + (int)k, pTest, Sweep.iOffsetTest + (int)k, wPeriod,
            FALSE, fIgnoreProsody, FALSE);
         Sweep.plfScoreSyl->Add (&Sweep.fScoreSyl);
      }

      if (dwOldNum < dwSlots)
         memmove (pBSS + (j+1), pBSS + j, (dwOldNum - j) * sizeof(BESTSENTSWEEP));

      else {
         // delete the last one's list
         if (pBSS[dwOldNum-1].plfScoreSyl)
            delete pBSS[dwOldNum-1].plfScoreSyl;

         memmove (pBSS + (j+1), pBSS + j, (dwOldNum - j-1) * sizeof(BESTSENTSWEEP));   // dont move last one
      }
      memcpy (pBSS + j, &Sweep, sizeof(Sweep));
   } // i
}


#if 0 // old compare code
/*************************************************************************************
CSentenceSyllable::Compare - Compares one sentence syllable with another, returning
a score indicating how closely they match (higher numbers are better).

inputs
   DWORD          dwOffsetThis - Offset, in syllables, into THIS sentence that will
                  be the central/focal syllable for comparing
   CSentenceSyllable *pTest - Sentence to test against
   DWORD          dwOffsetTest - Offset, in syllables, into the test sentece for
                  the central/focal syllable.
returns
   DWORD - Score. 0 indicates there is no match. Higher values are better
*/
#define MAXCOMPAREDIST        5     // compare up to 5 syllables away on either side
__inline DWORD CSentenceSyllable::Compare (DWORD dwOffsetThis, CSentenceSyllable *pTest, DWORD dwOffsetTest)
{
   // quick test, if the two central values don't match at all then
   // fail
   if (m_pabPOS[dwOffsetThis] != pTest->m_pabPOS[dwOffsetTest])
      return 0;

   // determine the score, looping outward from the central point until reach
   // syllable that doesn't match at all, or until go beyond max
   DWORD dwScore = 0;
   DWORD dwDirection, i, dwTempScore;
   for (dwDirection = 0; dwDirection < 2; dwDirection++) {
      for (i = (dwDirection ? 1 : 0); i < MAXCOMPAREDIST; i++) {
         int iThis, iTest;
         BYTE bThis, bTest;
         if (dwDirection) {
            iThis = (int) dwOffsetThis + (int)i;
            iTest = (int) dwOffsetTest + (int)i;

            // NOTE: Dead code. ignoring bRuleDepth
            if (iThis < (int)m_dwNum)
               bThis = m_pabPOS[iThis];
            else
               bThis = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);

            if (iTest < (int)pTest->m_dwNum)
               bTest = pTest->m_pabPOS[iTest];
            else
               bTest = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
         }
         else {
            iThis = (int) dwOffsetThis - (int)i;
            iTest = (int) dwOffsetTest - (int)i;

            if (iThis >= 0)
               bThis = m_pabPOS[iThis];
            else
               bThis = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);

            if (iTest >= 0)
               bTest = pTest->m_pabPOS[iTest];
            else
               bTest = POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION);
         }

         // if they're not the same then break, since stop matching
         if (bThis != bTest)
            break;

         // temporary score
         dwTempScore = (MAXCOMPAREDIST - i) * 10;

         // else, need to compare word #s
         DWORD dwThis, dwTest;
         if (dwDirection) {
            if (iThis < (int)m_dwNum)
               dwThis = m_paSyl[iThis].dwWord;
            else
               dwThis = (DWORD)-2;  // intentionally not using -1

            if (iTest < (int)pTest->m_dwNum)
               dwTest = pTest->m_paSyl[iTest].dwWord;
            else
               dwTest = (DWORD)-2;  // intentionally not using -1
         }
         else {
            if (iThis >= 0)
               dwThis = m_paSyl[iThis].dwWord;
            else
               dwThis = (DWORD)-2;  // intentionally not using -1

            if (iTest >= 0)
               dwTest = pTest->m_paSyl[iTest].dwWord;
            else
               dwTest = (DWORD)-2;  // intentionally not using -1
         }
         if ((dwThis == dwTest) && (dwTest != (DWORD)-1))
            dwTempScore += dwTempScore / 2;  // exact word match creates a bonus score
                  // BUGFIX - higher score for exact word match

         dwScore += dwTempScore;
      } // i distance
   } // dwDirection

   return dwScore;
}
#endif // 0



#if 0 // old compare code
/*************************************************************************************
CSentenceSyllable::CompareSweep - Compares this sentence against a test sentences,
sweeping across all syllable positions in the test sentences. Any scores > 0 are
tested against the list of best scores and potentially inserted into the list.

inputs
   DWORD          dwOffsetThis - Offset, in syllables, into THIS sentence that will
                  be the central/focal syllable for comparing
   CSentenceSyllable *pTest - Sentence to test against
   DWORD          *pdwNum - Originally filled with the number of elements in pBESTSENTSWEEP.
                  This will be modified if new sentences are added.
   DWORD          dwMax - Maximum number of sentences alloed in pBESTSENTSWEEP. pdwNum
                  will not be modified beyond this
   PBESTSENTSWEEP pBESTSENTSWEEP - Sorted list of best-case matches for sentences, with
                  highest scores at the top of the list.
returns
   none
*/
void CSentenceSyllable::CompareSweep (DWORD dwOffsetThis, CSentenceSyllable *pTest,
                                      DWORD *pdwNum, DWORD dwMax, PBESTSENTSWEEP pBESTSENTSWEEP)
{
   DWORD i, dwScore;
   int iInsert;
   DWORD dwCurrentWorst = dwCurrentWorst = (*pdwNum < dwMax) ? 0 : pBESTSENTSWEEP[*pdwNum-1].dwScore;
      // BUGFIX - Was (*pdwNum) ? pBESTSENTSWEEP[*pdwNum-1].dwScore : 0;
   for (i = 0; i < pTest->m_dwNum; i++) {
      dwScore = Compare (dwOffsetThis, pTest, i);
      if (dwScore <= dwCurrentWorst)
         continue;   // no match at all

      // apply some randomization so that if there's a bad template at the start
      // of the list won't mar all the sentences from then on. Also
      // provides a bit of variety
      DWORD dwRandom = (DWORD)(rand() % 20) * dwScore / 100;   // 20% random
      if (dwRandom < dwScore)
         dwScore -= dwRandom;
      else
         dwScore = 1;   // so doesnt go to 0
      // recheck
      if (dwScore <= dwCurrentWorst)
         continue;   // no match at all

      // else, better than the current worst, so add it
      for (iInsert = (int)(*pdwNum) - 1; iInsert >= 0; iInsert--)
         if (dwScore <= pBESTSENTSWEEP[iInsert].dwScore)
            break;
      iInsert++;  // so know what to insert before

      DWORD dwMove = *pdwNum - (DWORD)iInsert;
      if (*pdwNum >= dwMax)
         dwMove--; // so will end up discarding the last one

      // move
      if (dwMove)
         memmove (pBESTSENTSWEEP + (iInsert+1), pBESTSENTSWEEP + iInsert, dwMove * sizeof(BESTSENTSWEEP));

      // fill in
      pBESTSENTSWEEP[iInsert].dwScore = dwScore;
      pBESTSENTSWEEP[iInsert].dwOffset = i;
      pBESTSENTSWEEP[iInsert].pSent = pTest;

      // new numbre
      if (*pdwNum < dwMax)
         *pdwNum = *pdwNum + 1;
      else
         *pdwNum = dwMax;
      dwCurrentWorst = (*pdwNum < dwMax) ? 0 : pBESTSENTSWEEP[*pdwNum-1].dwScore;
   } // i, over all syllable indecies
}
#endif // 0


#if 0 // old compare code
/*************************************************************************************
CSentenceSyllable::CompareSweep - This compares the test sentence against a list
of other test sentneces, filling in the best fit. See the ::CompareSweep() method
above for some details on paramters


inputs
   DWORD          dwOffsetThis - Offset, in syllables, into THIS sentence that will
                  be the central/focal syllable for comparing
   PCListFixed    plPCSentenceSyllable - List of PCSentenceSyllable to compare this
                  sentence against.
   DWORD          *pdwNum - Originally filled with the number of elements in pBESTSENTSWEEP.
                  This will be modified if new sentences are added.
   DWORD          dwMax - Maximum number of sentences alloed in pBESTSENTSWEEP. pdwNum
                  will not be modified beyond this
   PBESTSENTSWEEP pBESTSENTSWEEP - Sorted list of best-case matches for sentences, with
                  highest scores at the top of the list.
returns
   none
*/
void CSentenceSyllable::CompareSweep (DWORD dwOffsetThis, PCListFixed plPCSentenceSyllable,
                                      DWORD *pdwNum, DWORD dwMax, PBESTSENTSWEEP pBESTSENTSWEEP)
{
   PCSentenceSyllable *ppss = (PCSentenceSyllable*)plPCSentenceSyllable->Get(0);
   DWORD dwNum = plPCSentenceSyllable->Num();

   DWORD i;
   for (i = 0; i < dwNum; i++)
      CompareSweep (dwOffsetThis, ppss[i], pdwNum, dwMax, pBESTSENTSWEEP);
}
#endif // 0



#if 0 // old compare code
/*************************************************************************************
CSentenceSyllable::FindBestMatch - This takes a sentence split into syllables, which
will be spoken by TTS, and compares it against a list of sentences in the database.
It then finds the best matching sentences and uses them as templates to fill in
this sentences bpitch, pvolume, bduration, and microsilence.

inputs
   PCListFixed    plPCSentenceSyllable - List of PCSentenceSyllable to compare this
                  sentence against.
returns
   none... although it changes the values. NOTE: bFlags will be filled with 0..255,
      where 0 is no microsilnece, 255 is always microsilence
*/
#define MAXBESTSYLLABLE          5     // maximum number of best-matches to look for
#define SYLLABLEBLEND            3     // blend syllables this far around

void CSentenceSyllable::FindBestMatch (PCListFixed plPCSentenceSyllable)
{
   // keep a list of lists
   CListFixed lPerSyl;
   lPerSyl.Init (sizeof(PCListFixed));

   // loop through all the syllables and find the best match amongst them
   DWORD i, dwNumBest;
   BESTSENTSWEEP aBestSent[MAXBESTSYLLABLE];
   PCListFixed pl;
   for (i = 0; i < m_dwNum; i++) {
      dwNumBest = 0;
      CompareSweep (i, plPCSentenceSyllable, &dwNumBest, MAXBESTSYLLABLE, aBestSent);

      // create a new list and add these
      pl = new CListFixed;
      if (!pl)
         return;  // error
      pl->Init (sizeof(BESTSENTSWEEP), aBestSent, dwNumBest);

      lPerSyl.Add (&pl);
   } // i

   // go through all the matching sentences and see if they can be forward or
   // back-propogated to adjacent slots where they didn't match. This way there
   // will be as few template-sentence transitions as possible
   DWORD j, k, dwForward, dwDistance;
   PCListFixed *ppl = (PCListFixed*)lPerSyl.Get(0);
   BESTSENTSWEEP bs;
   for (i = 0; i < m_dwNum; i++) {
      pl = ppl[i];

      for (j = 0; j < pl->Num(); j++) {
         // get info
         PBESTSENTSWEEP pSweep = (PBESTSENTSWEEP) pl->Get(j);

         // forward/back
         for (dwForward = 0; dwForward < 2; dwForward++) for (dwDistance = 0; dwDistance < m_dwNum; dwDistance++) {
            // figure out the index into ppl that looking at
            int iThis;
            if (dwForward)
               iThis = (int)i + (int)dwDistance + 1;
            else
               iThis = (int)i - (int)dwDistance - 1;
            if ((iThis >= (int)m_dwNum) || (iThis < 0))
               break;   // beyond the edge of this sentence

           
            // see what testing against
            int iTest;
            if (dwForward)
               iTest = (int)pSweep->dwOffset + (int)dwDistance + 1;
            else
               iTest = (int)pSweep->dwOffset - (int)dwDistance - 1;
            if ((iTest >= (int)pSweep->pSent->m_dwNum) || (iTest < 0))
               break;   // dont test beyond edge of other one

            // if the current sweep sentence is already found in an adjacent slot
            // then stop going any further
            PBESTSENTSWEEP pAdjacent = (PBESTSENTSWEEP) ppl[iThis]->Get(0);
            for (k = 0; k < ppl[iThis]->Num(); k++, pAdjacent++)
               if ((pAdjacent->pSent == pSweep->pSent) && (pAdjacent->dwOffset == (DWORD)iTest))
                  break;
            if (k < ppl[iThis]->Num())
               break;   // stop since already have a matching version in that direction

            // get a comparison score
            bs.dwScore = Compare ((DWORD)iThis, pSweep->pSent, (DWORD)iTest);
            if (!bs.dwScore)
               break;   // got toa point where they no longer match, so abandon

            // else, these sentences still match up, so add to the list
            bs.dwOffset = (DWORD)iTest;
            bs.pSent = pSweep->pSent;
            ppl[iThis]->Add (&bs);
         } // dwForward
      } // j, over all good matches
   } // i, over all indecies
   
   // if any of the lists are blank then add a dummy hypothesis that will have no pitch or inflection
   bs.dwOffset = 0;
   bs.dwScore = 1;
   bs.pSent = NULL;
   for (i = 0; i < m_dwNum; i++) {
      pl = ppl[i];
      if (!pl->Num())
         pl->Add (&bs);
   } // i

   // now that have a lot of templates for each word, blend them all together, weighting
   // by the dwscore... that way, if there are bad recordings, they will tend to be
   // counteracted by having lots of data

   // loop through and blend the results of the best ones
   CPoint pSum; note - this wont work anymore
   fp fWeight;
   fp fMicroSilence, fMicroSilenceSum;
   for (i = 0; i < m_dwNum; i++) {
      // do a weighted sum of all the surrounding bits
      pSum.Zero();
      pSum.p[3] = 0;
      fMicroSilence = fMicroSilenceSum = 0;

      int iLook;
      PSENTENCESYLLABLE pss;
      for (iLook = (int)i-SYLLABLEBLEND; iLook <= (int)i+SYLLABLEBLEND; iLook++) {
         if ((iLook < 0) || (iLook >= (int)m_dwNum))
            continue; // blending too far back

         DWORD dwNumInStack = ppl[iLook]->Num();
         PBESTSENTSWEEP pStack = (PBESTSENTSWEEP)ppl[iLook]->Get(0);
         for (j = 0; j < dwNumInStack; j++) {
            // blend with
            PBESTSENTSWEEP pBlendWith = pStack + j;

            // if there isn't any available match then skip
            if (!pBlendWith->pSent)
               continue;

            // make sure that can get the appropriate value
            int iTest = (int) pBlendWith->dwOffset - (iLook - (int)i);
            if ((iTest < 0) || (iTest >= (int) pBlendWith->pSent->m_dwNum))
               continue;   // would be beyond the edge of that

            // else, add, weighting the scores of the blend
            pss = pBlendWith->pSent->m_paSyl + iTest;
            fWeight = (SYLLABLEBLEND - fabs(iLook - (int)i)) * (fp) pBlendWith->dwScore;
            pSum.p[0] += log((fp)pss->bPitch / 100.0) * fWeight;
            pSum.p[1] += log((fp)pss->bVol / 100.0) * fWeight;
            pSum.p[2] += log((fp)pss->bDur / 100.0) * fWeight;
            pSum.p[3] += fWeight;

            // BUGFIX - look at the POS for only the first syllable to see if should include
            BYTE bPOS = pBlendWith->pSent->m_pabPOS[iTest];
               // Dead code. Not dealing with bRuleDepth
            if (!(bPOS & 0x70)) {
               // this is the start of a word
               fMicroSilenceSum += fWeight;

               if (pss->bFlags & 0x01)
                  fMicroSilence += fWeight;
            }
         } // j, over templates for the word
      } // iLook, blend in

      // if there's no weight then make a neutral case
      if (pSum.p[3]) {
         pSum.Scale (1.0  / pSum.p[3]);
         pSum.p[0] = exp (pSum.p[0]);  // so pitch, duration, and volume
         pSum.p[1] = exp (pSum.p[1]);  // so pitch, duration, and volume
         pSum.p[2] = exp (pSum.p[2]);  // so pitch, duration, and volume
         if (fMicroSilenceSum)
            fMicroSilence = fMicroSilence / fMicroSilenceSum;
         else
            fMicroSilence = 0.0;
         //if (fMicroSilence > fMicroSilenceSum * fMicroPauseThreshhold)
         //   fMicroSilence = TRUE;
         //else
         //   fMicroSilence = FALSE;
      }
      else {
         pSum.p[0] = pSum.p[1] = pSum.p[2] = 1.0;
         fMicroSilence = 0.0;   // no microsilnce
      }

      // store this away
      for (j = 0; j < 3; j++) {
         pSum.p[j] *= 100.0;
         pSum.p[j] = max(pSum.p[j], 25);  // dont be too restrtive.. and shouldnt happen anyway
         pSum.p[j] = min(pSum.p[j], 255);  // dont be too restrtive.. and shouldnt happen anyway
      }

      // write the values in
      pss = m_paSyl + i;
      pss->bPitch = (BYTE)pSum.p[0];
      pss->bVol = (BYTE)pSum.p[1];
      pss->bDur = (BYTE)pSum.p[2];
      // NOTE: bFlags used as microsilnce value... if 0 NEVER insert, if 255 always insert
      fMicroSilence = max(fMicroSilence, 0);
      fMicroSilence = min(fMicroSilence, 1);
      pss->bFlags = (BYTE)(fMicroSilence*255.0);
   } // i

   // free the list of lists
   for (i = 0; i < lPerSyl.Num(); i++)
      delete ppl[i];
}
#endif // 0



/*************************************************************************************
GlobalStateToMML - Creates a CMMLNode2 and fills in the parameters for the global
state into it.

inputs
   PTTSGLOBALSTATE pState - Current state
returns
   PCMMLNode2 - Node of type gpszTTSGlobalState. This need to be freed by the calelr
*/
static PCMMLNode2 GlobalStateToMML (PTTSGLOBALSTATE pState)
{
   PCMMLNode2 pNode = new CMMLNode2;
   if (!pNode)
      return NULL;
   pNode->NameSet (gpszTTSGlobalState);

   WCHAR szTemp[32];

   // pitch
   MMLDoubleToString (pState->fProsodyAvgPitch, szTemp);
   pNode->AttribSetString (gpszAvgPitch, szTemp);

   // syllabledur
   //MMLDoubleToString (pState->fProsodyAvgSyllableDur, szTemp);
   //pNode->AttribSetString (gpszAvgSyllableDur, szTemp);

   // words per minute
   MMLDoubleToString (pState->fProsodyWPM, szTemp);
   pNode->AttribSetString (gpszWPM, szTemp);

   // volume
   MMLDoubleToString (pState->fProsodyVol, szTemp);
   pNode->AttribSetString (gpszVol, szTemp);

   // pitch expressieness
   MMLDoubleToString (pState->fProsodyPitchExpress, szTemp);
   pNode->AttribSetString (gpszPitchExpress, szTemp);

   // emotions
   MMLDoubleToString (pState->fEmotionWhisper, szTemp);
   pNode->AttribSetString (gpszEmotionWhisper, szTemp);

   // emotions
   MMLDoubleToString (pState->fEmotionShout, szTemp);
   pNode->AttribSetString (gpszEmotionShout, szTemp);

   // emotions
   MMLDoubleToString (pState->fEmotionQuiet, szTemp);
   pNode->AttribSetString (gpszEmotionQuiet, szTemp);

   // emotions
   MMLDoubleToString (pState->fEmotionHappy, szTemp);
   pNode->AttribSetString (gpszEmotionHappy, szTemp);

   // emotions
   MMLDoubleToString (pState->fEmotionSad, szTemp);
   pNode->AttribSetString (gpszEmotionSad, szTemp);

   // emotions
   MMLDoubleToString (pState->fEmotionAfraid, szTemp);
   pNode->AttribSetString (gpszEmotionAfraid, szTemp);

   // emotions
   MMLDoubleToString (pState->fEmotionDrunk, szTemp);
   pNode->AttribSetString (gpszEmotionDrunk, szTemp);

   return pNode;
}



/*************************************************************************************
GlobalStateFromMML - Takes a MML that's of type gpszTTSGlobalState (from GlobalStateToMML())
and pulls out the state information.

inputs
   PCMMLNode2         pNode - Node from GlobalStateToMML(). Can be NULL
   PCMTTSSubVoice     pSubVoice - Subvoice to use
   PTTSGLOBALSTATE   pState - Current state. Should have some valid values in case not all
      all attributes are read
*/
static void GlobalStateFromMML (PCMMLNode2 pNode, PCMTTSSubVoice pSubVoice, PTTSGLOBALSTATE pState)
{
   if (pNode) {
      // pitch
      PWSTR psz = pNode->AttribGetString (gpszAvgPitch);
      if (psz)
         pState->fProsodyAvgPitch = _wtof(psz);

      // syllable duration
      //psz = pNode->AttribGetString (gpszAvgSyllableDur);
      //if (psz)
      //   pState->fProsodyAvgSyllableDur = _wtof(psz);

      //wpm
      psz = pNode->AttribGetString (gpszWPM);
      if (psz)
         pState->fProsodyWPM = _wtof(psz);

      // volume
      psz = pNode->AttribGetString (gpszVol);
      if (psz)
         pState->fProsodyVol = _wtof(psz);

      // pitch expressieness
      psz = pNode->AttribGetString (gpszPitchExpress);
      if (psz)
         pState->fProsodyPitchExpress = _wtof(psz);

      // emotions
      if (psz = pNode->AttribGetString (gpszEmotionWhisper))
         pState->fEmotionWhisper = _wtof(psz);
      if (psz = pNode->AttribGetString (gpszEmotionShout))
         pState->fEmotionShout = _wtof(psz);
      if (psz = pNode->AttribGetString (gpszEmotionQuiet))
         pState->fEmotionQuiet = _wtof(psz);
      if (psz = pNode->AttribGetString (gpszEmotionHappy))
         pState->fEmotionHappy = _wtof(psz);
      if (psz = pNode->AttribGetString (gpszEmotionSad))
         pState->fEmotionSad = _wtof(psz);
      if (psz = pNode->AttribGetString (gpszEmotionAfraid))
         pState->fEmotionAfraid = _wtof(psz);
      if (psz = pNode->AttribGetString (gpszEmotionDrunk))
         pState->fEmotionDrunk = _wtof(psz);
   } // if pNode

   // start with prosody as set
   pState->fDerAvgPitch = pState->fProsodyAvgPitch;
   // pState->fDerAvgSyllableDur = pState->fProsodyAvgSyllableDur;
   pState->fDerWPM = pState->fProsodyWPM;
   pState->fDerVol = pState->fProsodyVol;
   pState->fDerPitchExpress = pState->fProsodyPitchExpress;
   pState->fDerDurationExpress = 1;
   pState->fDerVolumeExpress = 1;
   pState->fDerShout = 0;
   pState->fDerWhisper = 0;
   pState->fDerMicropauses = pSubVoice->m_fMicroPauseThreshhold;

   // apply emotions
   if (pState->fEmotionWhisper) {
      pState->fDerWhisper = pState->fEmotionWhisper / 100.0;
      pState->fDerPitchExpress *= 1.0 - (pState->fEmotionWhisper / 100.0) * 0.5;
      pState->fDerWPM /= 1.0 + (pState->fEmotionWhisper / 100) * 0.3;
   }
   if (pState->fEmotionShout) {
      pState->fEmotionShout = max(pState->fEmotionShout, 0);
      pState->fEmotionShout = min(pState->fEmotionShout, 100);
      pState->fDerShout = pState->fEmotionShout / 100.0;
      pState->fDerVol *= 1.0 + (pState->fEmotionShout / 100.0);
      pState->fDerMicropauses -= pState->fEmotionShout / 100.0 * 0.5;   // more pauses
      pState->fDerPitchExpress *= 1.0 - (pState->fEmotionShout / 100.0) * 0.5;
      pState->fDerDurationExpress *= 1.0 - (pState->fEmotionShout / 100.0) * 0.5; // less expressive duration
      pState->fDerAvgPitch *= 1.0 + (pState->fEmotionShout / 100.0) * 0.1; // slight increase in pitch
      pState->fDerWPM *= 1.0 + (pState->fEmotionShout / 100) * 0.2;
   }
   if (pState->fEmotionQuiet) {
      pState->fEmotionQuiet = max(pState->fEmotionQuiet, 0);
      pState->fEmotionQuiet = min(pState->fEmotionQuiet, 100);
      pState->fDerShout = -pState->fEmotionQuiet / 100.0;
      pState->fDerVol /= 1.0 + (pState->fEmotionQuiet / 100.0);
      pState->fDerPitchExpress *= 1.0 + (pState->fEmotionQuiet / 100.0) * 0.25;  // slightly more expressive
      pState->fDerAvgPitch /= 1.0 + (pState->fEmotionQuiet / 100.0) * 0.1; // slight decrease in pitch
      pState->fDerWPM /= 1.0 + (pState->fEmotionQuiet / 100) * 0.1;
   }
   if (pState->fEmotionHappy) {
      pState->fDerAvgPitch *= 1.0 + (pState->fEmotionHappy / 100.0) * 0.1; // slight increase in pitch
      pState->fDerVol *= 1.0 + (pState->fEmotionHappy / 100.0) * 0.3; // slight increase in volume
      pState->fDerWPM *= 1.0 + (pState->fEmotionHappy / 100.0) * 0.1; // slight increase in WPM
      pState->fDerPitchExpress *= 1.0 + (pState->fEmotionHappy / 100.0) * 0.5;   // more expressive pitch
      pState->fDerDurationExpress *= 1.0 + (pState->fEmotionHappy / 100.0) * 0.5; // more expressive duration
      pState->fDerVolumeExpress *= 1.0 + (pState->fEmotionHappy / 100.0) * 0.5;  // more expressive volume
   }
   if (pState->fEmotionSad) {
      pState->fDerAvgPitch /= 1.0 + (pState->fEmotionSad / 100.0) * 0.1; // slight decrease in pitch
      pState->fDerVol /= 1.0 + (pState->fEmotionSad / 100.0) * 0.3; // slight decrease in volume
      pState->fDerMicropauses += pState->fEmotionSad / 100.0 * 0.5;   // fewer pauses
      pState->fDerWPM /= 1.0 + (pState->fEmotionSad / 100.0)*0.5; // slight increase in WPM
      pState->fDerPitchExpress /= 1.0 + (pState->fEmotionSad / 100.0);   // less expressive pitch
      pState->fDerDurationExpress /= 1.0 + (pState->fEmotionSad / 100.0) * 2.0; // less expressive duration
      pState->fDerVolumeExpress /= 1.0 + (pState->fEmotionSad / 100.0) * 2.0;  // less expressive volume
      pState->fDerAvgPitch /= 1.0 + (pState->fEmotionSad / 100.0) * 0.1; // slight decrease in pitch
   }
   if (pState->fEmotionAfraid) {
      pState->fDerShout = pState->fEmotionAfraid / 100.0 * 0.5;   // some tension in the voice
      pState->fDerWhisper = pState->fEmotionAfraid / 100.0 * 0.25;   // some whispering in the voice
      pState->fDerWPM *= 1.0 + (pState->fEmotionAfraid / 100.0)*0.2; // slight increase in WPM
      pState->fDerAvgPitch *= 1.0 + (pState->fEmotionAfraid / 100.0) * 0.2; // slight higher in pitch
   }
   if (pState->fEmotionDrunk) {
      pState->fEmotionDrunk = max(pState->fEmotionDrunk, 0);
      pState->fEmotionDrunk = min(pState->fEmotionDrunk, 100);
      pState->fDerMicropauses += pState->fEmotionDrunk / 100.0 * 0.5;   // fewer pauses
      pState->fDerWPM /= 1.0 + (pState->fEmotionDrunk / 100.0); // slight increase in WPM
      pState->fDerPitchExpress *= 1.0 + (pState->fEmotionDrunk / 100.0);   // more expressive pitch
   }

   // min/max
   pState->fDerPitchExpress = max(pState->fDerPitchExpress, CLOSE);
   pState->fDerDurationExpress = max(pState->fDerDurationExpress, CLOSE);
   pState->fDerVolumeExpress = max(pState->fDerVolumeExpress, CLOSE);
   pState->fDerVol *= 0.66;    // BUGFIX - Volume was too loud after bug-fix to feature extraction, so made it quieter
   pState->fDerVol = max(pState->fDerVol, CLOSE);
   pState->fDerAvgPitch = max(pState->fDerAvgPitch, 1);
   //pState->fDerAvgSyllableDur = max(pState->fDerAvgSyllableDur, 0.01);
}


/****************************************************************************
CSVParse - This takes an attribute (such as TPVolRel) which is a comma
separated variable, and parses it into a list of fp. If any comma items
are blank then their value is filled with -1234.

inputs
   PWSTR                psz - String
   PCListFixed           plParse - Initialized to sizeof(fp), and filled with
                           one value per element parsed.
returns
   none
*/
static void CSVParse (PWSTR psz, PCListFixed plParse)
{
   plParse->Init (sizeof(fp));

   while (TRUE) {
      // find the next comma
      PWSTR p;
      for (p = psz; *p; p++)
         if (*p == L',')
            break;

      fp fVal;
      fVal = _wtof (psz);

      if (p == psz)
         fVal = -1234;  // since blank
      plParse->Add (&fVal);

      if (!p[0])
         break;   // all done since at end
      psz = p+1;  // next
   }
}

/****************************************************************************
CTTSPunctPros::construcotr and destructor
*/
CTTSPunctPros::CTTSPunctPros (void)
{
   DWORD i;
   for (i = 0; i < PUNCTPROS; i++) {
      m_apBefore[i].Zero();
      m_apAfter[i].Zero();
   }

   m_wPunct = m_wFuncWord = 0;
}

CTTSPunctPros::~CTTSPunctPros (void)
{
   // do nothing
}


/****************************************************************************
CTTSPunctPros::MMLTo - Standard API
*/
PCMMLNode2 CTTSPunctPros::MMLTo (void)
{
   PCMMLNode2 pNode = new CMMLNode2;
   if (!pNode)
      return NULL;
   pNode->NameSet (gpszPunctPros);

   WCHAR szTemp[64];
   DWORD i;
   for (i = 0; i < PUNCTPROS; i++) {
      swprintf (szTemp, L"Before%d", (int)i);
      MMLValueSet (pNode, szTemp, &m_apBefore[i]);

      swprintf (szTemp, L"After%d", (int)i);
      MMLValueSet (pNode, szTemp, &m_apAfter[i]);
   }

   MMLValueSet (pNode, gpszPunct, (int)m_wPunct);
   MMLValueSet (pNode, gpszFuncWord, (int)m_wFuncWord);

   return pNode;
}

/****************************************************************************
CTTSPunctPros::MMLFrom - Standard API
*/
BOOL CTTSPunctPros::MMLFrom (PCMMLNode2 pNode)
{
   WCHAR szTemp[64];
   DWORD i;
   for (i = 0; i < PUNCTPROS; i++) {
      swprintf (szTemp, L"Before%d", (int)i);
      MMLValueGetPoint (pNode, szTemp, &m_apBefore[i]);

      swprintf (szTemp, L"After%d", (int)i);
      MMLValueGetPoint (pNode, szTemp, &m_apAfter[i]);
   }

   m_wPunct = (WORD) MMLValueGetInt (pNode, gpszPunct, (int)0);
   m_wFuncWord = (WORD) MMLValueGetInt (pNode, gpszFuncWord, (int)0);

   return TRUE;
}

/****************************************************************************
CTTSPunctPros::Clone - Standard API
*/
CTTSPunctPros *CTTSPunctPros::Clone (void)
{
   PCTTSPunctPros pNew = new CTTSPunctPros;

   memcpy (pNew->m_apBefore, m_apBefore, sizeof(m_apBefore));
   memcpy (pNew->m_apAfter, m_apAfter, sizeof(m_apAfter));
   pNew->m_wFuncWord = m_wFuncWord;
   pNew->m_wPunct = m_wPunct;

   return pNew;
}


/*************************************************************************************
TTSCacheDefaultGet - Get the default TTS file.

inputs
   PWSTR          pszFile - Filled with the file name
   DWORD          dwChars - Number of characters in pws
returns
   none
*/
void TTSCacheDefaultGet (PWSTR pszFile, DWORD dwChars)
{
   // at least fill with null
   pszFile[0] = 0;

   HKEY  hKey = NULL;
   DWORD dwDisp;
   char szTemp[512];
   szTemp[0] = 0;
   RegCreateKeyEx (HKEY_CURRENT_USER, RegBase(), 0, 0, REG_OPTION_NON_VOLATILE,
      KEY_READ | KEY_WRITE, NULL, &hKey, &dwDisp);
   if (hKey) {
      DWORD dw, dwType;
      LONG lRet;
      dw = sizeof(szTemp);
      lRet = RegQueryValueEx (hKey, gszKeyTTSFile, NULL, &dwType, (LPBYTE) szTemp, &dw);
      RegCloseKey (hKey);

      if (lRet != ERROR_SUCCESS)
         szTemp[0] = 0;
   }
   MultiByteToWideChar (CP_ACP, 0, szTemp, -1, pszFile, dwChars);

}


/*************************************************************************************
TTSCacheDefaultGet - Get the default TTS file and write it in a control

inputs
   PCEscPage         pPage - Page
   PWSTR             pszControl - Control name
returns
   none
*/
void TTSCacheDefaultGet (PCEscPage pPage, PWSTR pszControl)
{
   PCEscControl pControl = pPage->ControlFind (pszControl);
   if (!pControl)
      return;

   WCHAR szFile[256];
   TTSCacheDefaultGet (szFile, sizeof(szFile) / sizeof(WCHAR));
   pControl->AttribSet (Text(), szFile[0] ? szFile : L"(No TTS file)");
}

/*************************************************************************************
TTSCacheDefaultSet - Set the default TTS file.

inputs
   PWSTR          pszFile - File name
returns
   none
*/
void TTSCacheDefaultSet (PWSTR pszFile)
{
   // save to registry
   HKEY  hKey = NULL;
   DWORD dwDisp;
   RegCreateKeyEx (HKEY_CURRENT_USER, RegBase(), 0, 0, REG_OPTION_NON_VOLATILE,
      KEY_READ | KEY_WRITE, NULL, &hKey, &dwDisp);

   if (hKey) {
      char szTemp[512];
      WideCharToMultiByte (CP_ACP, 0, pszFile, -1, szTemp, sizeof(szTemp), 0, 0);
      RegSetValueEx (hKey, gszKeyTTSFile, 0, REG_SZ, (BYTE*) szTemp,
         (DWORD)strlen(szTemp)+1);

      RegCloseKey (hKey);
   }
}



/*************************************************************************************
TTSCacheDefaultUI - UI to select a new TTS voice.

inputs
   HWND           hWnd - To display the window off of
returns
   BOOL - TRUE if changed
*/
BOOL TTSCacheDefaultUI (HWND hWnd)
{
   WCHAR szFile[256];
   TTSCacheDefaultGet (szFile, sizeof(szFile)/sizeof(WCHAR));

   if (!TTSFileOpenDialog (hWnd, szFile, sizeof(szFile)/sizeof(WCHAR), FALSE))
      return FALSE;

   // save the file
   TTSCacheDefaultSet (szFile);
   return TRUE;
}

/*************************************************************************************
TTSCacheMemoryTouch - Touches randomly selected memory in a randomly selected TTS
engine. Call this once a second to ensure that the TTS voices aren't cached out.
*/
DLLEXPORT void TTSCacheMemoryTouch (void)
{
   // must have TTS engine
   if (!glPCMTTS.Num())
      return;

   // pick one
   DWORD dwIndex = (DWORD)rand() % glPCMTTS.Num();

   PCMTTS *ppl = (PCMTTS*) glPCMTTS.Get(0);

   ppl[dwIndex]->MemoryTouch();

}

/*************************************************************************************
TTSCacheOpen - Opens a TTS using the TTS cache. If the item already
exists in memory then that one is used. If you open a TTS using this then
you should use MTTSCacheClose() instead of delete, so that several tools can
use the same TTS.

inputs
   PWSTR          pszFile - File to open. If this is NULL then the default TTS
                     voice is used, from TTSCacheDefaultGet().
   BOOL           fLoadIfNotExist - If TRUE (default) then load the TTS voice
                     if it isn't already loaded. If FALSE then fail.
returns
   PCMTTS - TTS, or NULL if cant open
*/
DLLEXPORT PCMTTS TTSCacheOpen (PWSTR pszFile, BOOL fLoadIfNotExist)
{
   WCHAR szDefault[256];
   if (!pszFile) {
      TTSCacheDefaultGet (szDefault, sizeof(szDefault)/sizeof(WCHAR));
      if (!szDefault[0])
         return NULL;
      pszFile = szDefault;
   }

   if (!gfPCMTTSValid) {
      gfPCMTTSValid = TRUE;
      glPCMTTS.Init (sizeof(PCMTTS));
   }

   // look through existing ones
   PCMTTS *ppl = (PCMTTS*) glPCMTTS.Get(0);
   DWORD i;
   for (i = 0; i < glPCMTTS.Num(); i++) {
      if (!_wcsicmp(pszFile, ppl[i]->m_szFile)) {
         // found
         ppl[i]->m_dwRefCount++;
         return ppl[i];
      }
   } // i

   // if not supposed to load, then fail here
   if (!fLoadIfNotExist)
      return NULL;

#ifdef _DEBUG
   DWORD dwStartTime = GetTickCount();
   __int64 iMem = EscMemoryAllocated (FALSE);
   OutputDebugStringW (L"\r\nTTSCacheOpen file = ");
   OutputDebugStringW (pszFile);
#endif

#if 0 // def _DEBUG
   WCHAR szTemp[128];
   swprintf (szTemp, L"\r\n\tCurMem A = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif
   // else cant find
   PCMTTS pNew;
   pNew = new CMTTS;
   if (!pNew)
      return NULL;
#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem B = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif
   if (!pNew->Open (pszFile)) {
      delete pNew;

#ifdef _DEBUG
   OutputDebugStringW (L"\r\n\tTTSCacheOpen failed");
#endif
      return NULL;
   }
#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem C = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif
#ifdef _DEBUG
   char szaTemp[128];
   sprintf (szaTemp, "\r\n\tTTSCacheOpen: mem = %d K, time = %d ms\r\n", 
      (int)(((__int64)EscMemoryAllocated(FALSE) - iMem) / 1024), (int)(GetTickCount()-dwStartTime));
   OutputDebugString (szaTemp);
#endif

   // ref count
   pNew->m_dwRefCount = 1;
   glPCMTTS.Add (&pNew);
   return pNew;
}


/*************************************************************************************
TTSCacheClose - Closes a TTS opened with MTTSCacheOpen()

NOTE: Because TTSs can take a very long time to load, this doesn't actually
free the TTS.

inputs
   PCMTTS        pTTS - TTS to close
returns
   BOOL - TRUE if found and closed
*/
DLLEXPORT BOOL TTSCacheClose (PCMTTS pTTS)
{
   // look through existing ones
   PCMTTS *ppl = (PCMTTS*) glPCMTTS.Get(0);
   DWORD i;
   for (i = 0; i < glPCMTTS.Num(); i++) {
      if (pTTS == ppl[i]) {
         // ref count
         if (pTTS->m_dwRefCount)
            pTTS->m_dwRefCount--;

#ifdef _DEBUG
         if (!pTTS->m_dwRefCount) {
            OutputDebugStringW (L"\r\nTTSCacheClose file = ");
            OutputDebugStringW (pTTS->m_szFile);
         }
#endif
         return TRUE;
      }
   } // i


   return FALSE;
}


/*************************************************************************************
TTSCacheErrorDisplay - Display and error that can't load the TTS.

inputs
   HWND              hWnd - Window
*/
void TTSCacheErrorDisplay (HWND hWnd)
{
   EscMessageBox (hWnd, L"Text-to-speech", L"The TTS voice can't be loaded.",
      L"Try selecting a TTS voice to use at the bottom of the page.", MB_OK);
}


/*************************************************************************************
TTSCacheSpellCheck - Use a TTS voice for spell checking

inputs
   PWSTR             pszSpeak - To spell check
   HWND              hWndProgress - Window to display the progress on. Will also display
                        an error if TTS couldn't be loaded.
returns
   BOOL - TRUE if success.
*/
BOOL TTSCacheSpellCheck (PWSTR pszSpeak, HWND hWndProgress)
{
   CTextParse TP;

   if (!pszSpeak)
      pszSpeak = L"";

   PCMTTS pTTS = TTSCacheOpen ();
   if (!pTTS) {
      TTSCacheErrorDisplay (hWndProgress);
      return FALSE;
   }

   PCMLexicon pLex = pTTS->Lexicon ();
   if (!pLex) {
      TTSCacheClose (pTTS);
      TTSCacheErrorDisplay (hWndProgress);
      return FALSE;
   }

   TP.Init (pLex->LangIDGet(), pLex);
   PCMMLNode2 pNode = TP.ParseFromText (pszSpeak, FALSE, FALSE);
   if (!pNode) {
      TTSCacheClose (pTTS);
      TTSCacheErrorDisplay (hWndProgress);
      return FALSE;
   }

   DWORD i;
   CMem mem;
   MemZero (&mem);
   for (i = 0; i < pNode->ContentNum(); i++) {
      PWSTR psz;
      PCMMLNode2 pElem;
      pElem = NULL;
      if (!pNode->ContentEnum (i, &psz, &pElem))
         break;
      if (!pElem)
         continue;

      // only care about words
      psz = pElem->NameGet();
      if (!psz || _wcsicmp(psz, TP.Word()))
         continue;   // not important

      psz = pElem->AttribGetString(TP.Text());
      if (!psz)
         continue;

      // see if unknown
      if (!pLex->WordExists(psz)) {
         if (((PWSTR)mem.p)[0])
            MemCat (&mem, L", ");
         MemCat (&mem, psz);
      }
   } // while pNode->ContentNum()
   delete pNode;


   TTSCacheClose (pTTS);

   // display list
   if (!((PWSTR)mem.p)[0]) {
      EscMessageBox (hWndProgress, L"Spell check", L"No misspelled words",
         L"All the words seem to be spelled correctly.", MB_OK);
      return TRUE;
   }

   EscMessageBox (hWndProgress, L"Spell check", L"The follow words are misspelled:",
      (PWSTR)mem.p, MB_OK);

   return TRUE;
}

/*************************************************************************************
TTSCacheSpeak - Speak using the default TTS voice.

inputs
   PWSTR             pszSpeak - To speak
   BOOL              fTagged - If TRUE, speak tagged text
   BOOL              fDisablePCM - If TRUE then disable PCM, FALSE (best) then use PCM.
   HWND              hWndProgress - Window to display the progress on. Will also display
                        an error if TTS couldn't be loaded.
returns
   BOOL - TRUE if success.
*/
BOOL TTSCacheSpeak (PWSTR pszSpeak, BOOL fTagged, BOOL fDisablePCM, HWND hWndProgress)
{
   if (!pszSpeak)
      pszSpeak = L"";

   PCMTTS pTTS = TTSCacheOpen ();
   if (!pTTS) {
      TTSCacheErrorDisplay (hWndProgress);
      return FALSE;
   }

   if (!gpTTSCacheSpeakWave)
      gpTTSCacheSpeakWave = new CM3DWave;
   if (!gpTTSCacheSpeakWave)
      return FALSE;  // shouldnt happen

   // clear
   gpTTSCacheSpeakWave->QuickPlayStop();
   gpTTSCacheSpeakWave->BlankWaveToSize (0, TRUE);


   // convert
   {
      CProgress Progress;
      Progress.Start (hWndProgress, "Synthesizing...");
      pTTS->SynthGenWave (gpTTSCacheSpeakWave, gpTTSCacheSpeakWave->m_dwSamplesPerSec, pszSpeak, fTagged, 1 /*iTTSQuality*/, fDisablePCM, &Progress);
   }
   TTSCacheClose (pTTS);

   // play
   gpTTSCacheSpeakWave->QuickPlay();
   return TRUE;
}


/*************************************************************************************
TTSCacheShutDown - Call this before the app shuts down. This frees up all
the TTSs loaded in the TTS cache.

NOTE: Call this before MLexiconCacheShutDown().
*/
DLLEXPORT void TTSCacheShutDown (void)
{
   // Will need special shutdown code so no problems with dependences,
   // shutting down ones with fewest ref counts first... of maybe derived ones
   // first
   static BOOL fIsShuttingDown = FALSE;
   if (fIsShuttingDown)
      return;  // do nothing because already shutting down
   fIsShuttingDown = TRUE;

   // stop speaking
   if (gpTTSCacheSpeakWave) {
      gpTTSCacheSpeakWave->QuickPlayStop();
      delete gpTTSCacheSpeakWave;
      gpTTSCacheSpeakWave = NULL;
   }

   // look through existing ones
   PCMTTS *ppl = (PCMTTS*) glPCMTTS.Get(0);
   DWORD i;
   for (i = 0; i < glPCMTTS.Num(); i++) {
      delete ppl[i];
      ppl[i] = NULL; // BUGFIX - Put in so dont crash when have subordinate lexs
   } // i


   glPCMTTS.Clear ();

   fIsShuttingDown = FALSE;
}


/*************************************************************************************
CMTTSTriPhoneAudio::Constructor and destructor
*/
CMTTSTriPhoneAudio::CMTTSTriPhoneAudio (void)
{
   m_dwWord = -1;
   m_wOrigWave = m_wOrigPhone = -1;
   m_bPhoneLeft = m_bPhoneRight = 0;
   memset (m_abRank, 0, sizeof(m_abRank));
   memset (m_aMMISpecific, 0, sizeof(m_aMMISpecific));
   m_dwMismatchAccuracy = 0;
   memset (m_abPhoneContiguous, 0, sizeof(m_abPhoneContiguous));
   m_dwTrimLeft = m_dwTrimRight = 0;
   m_wWordPos = 0;
   // m_wDuration = 0;
   //m_wFlags = 0;
   // m_iPitch = m_iPitchDelta = 0;
   m_fOrigPitch = 0;
   m_dwFuncWordGroup = 0;
   m_fEnergyAvg = 0;
   m_fPitchDelta = 1;
   m_fPitchBulge = 1;
   m_fPitchLeft = m_fPitchCenter = m_fPitchRight = 0;
   m_dwFeatureStart = m_dwFeatureEnd = 0;
   m_iFeatureAdd = 0;
//   m_dwNumSRFEATURE = 0;
//   m_fEnergyStart = m_fEnergyEnd = 0;
//   m_fEnergyIsValid = FALSE;
   m_fReviewed = FALSE;
   m_fCenterEnergy = m_fLeftPitch = m_fLeftEnergy = 0;
   m_dwLeftDuration = 0;

   m_iPitchLeft = m_iPitchRight = m_iPitchCenter = 0;

   m_dwUniqueID = (DWORD)-1;
   //m_wPhone = (WORD)-1;
   //m_wTriPhoneIndex = (WORD)-1;

//   m_fKeepMemory = FALSE;
//   m_pKeepMemoryCompressed = NULL;
//   m_dwKeepMemorySize = 0;

   m_fCached = FALSE;

//   m_pmemSRFEATURE = NULL;
//   m_pmemTTSFEATURECOMPEXTRA = NULL;

//   memset (m_aSRFeatBoundary, 0, sizeof(m_aSRFeatBoundary));
//   memset (m_afSRFeatBoundary, 0, sizeof(m_afSRFeatBoundary));

   DWORD i, j;
   for (j = 0; j < NUMJOINQUALITY; j++)
      for (i = 0; i < TTSDEMIPHONES; i++)
         m_alTPACONNECTIONERROR[j][i].Init (sizeof(TPACONNECTIONERROR));

}

CMTTSTriPhoneAudio::~CMTTSTriPhoneAudio (void)
{
//   if (m_pmemSRFEATURE) {
//      delete m_pmemSRFEATURE;
//      m_pmemSRFEATURE = NULL;
//   }
//   if (m_pmemTTSFEATURECOMPEXTRA) {
//      delete m_pmemTTSFEATURECOMPEXTRA;
//      m_pmemTTSFEATURECOMPEXTRA = NULL;
//   }
}



/*************************************************************************************
CMTTSTriPhoneAudio::MemoryTouch - Use to make sure TTS stays in memory
*/
DWORD CMTTSTriPhoneAudio::MemoryTouch (void)
{
   DWORD dwRet = 0;

   dwRet += m_wOrigWave;   // to touch this structure

   DWORD dwIndex = (DWORD)rand() % (sizeof(m_alTPACONNECTIONERROR) / sizeof(m_alTPACONNECTIONERROR[0][0]));
   DWORD dwIndex2;
   if (m_alTPACONNECTIONERROR[0][dwIndex].Num()) {
      dwIndex2 = (DWORD)rand() % m_alTPACONNECTIONERROR[0][dwIndex].Num();
      PTPACONNECTIONERROR ptce = (PTPACONNECTIONERROR)m_alTPACONNECTIONERROR[0][dwIndex].Get(dwIndex2);

      if (ptce)
#ifdef USESMALLTPACONNECTIONERROR
         dwRet += (DWORD) ptce->dwTCECompact;
#else
         dwRet += (DWORD) ptce->fValue;
#endif
   }

   return dwRet;
}

/*************************************************************************************
CMTTSTriPhoneAudio::Clone - Standard clone
*/
CMTTSTriPhoneAudio *CMTTSTriPhoneAudio::Clone (void)
{
   PCMTTSTriPhoneAudio pNew = new CMTTSTriPhoneAudio;
   if (!pNew)
      return NULL;

   pNew->m_dwFeatureStart = m_dwFeatureStart;
   pNew->m_dwFeatureEnd = m_dwFeatureEnd;
   pNew->m_iFeatureAdd = m_iFeatureAdd;
//   pNew->m_dwNumSRFEATURE = m_dwNumSRFEATURE;
   pNew->m_dwWord = m_dwWord;
   pNew->m_wOrigWave = m_wOrigWave;
   pNew->m_wOrigPhone = m_wOrigPhone;
   pNew->m_fReviewed = m_fReviewed;
//   pNew->m_fEnergyEnd = m_fEnergyEnd;
//   pNew->m_fEnergyStart = m_fEnergyStart;
//   pNew->m_fEnergyIsValid = m_fEnergyIsValid;
   pNew->m_bPhoneLeft = m_bPhoneLeft;
   memcpy (pNew->m_abPhoneContiguous, m_abPhoneContiguous, sizeof(m_abPhoneContiguous));
   pNew->m_bPhoneRight = m_bPhoneRight;
   pNew->m_dwTrimLeft = m_dwTrimLeft;
   pNew->m_dwTrimRight = m_dwTrimRight;
   memcpy (pNew->m_abRank, m_abRank, sizeof(m_abRank));
   memcpy (pNew->m_aMMISpecific, m_aMMISpecific, sizeof(m_aMMISpecific));
   pNew->m_dwMismatchAccuracy = m_dwMismatchAccuracy;
   // pNew->m_wDuration = m_wDuration;
   pNew->m_wWordPos = m_wWordPos;
   //pNew->m_wFlags = m_wFlags;
   pNew->m_iPitchLeft = m_iPitchLeft;
   pNew->m_iPitchRight = m_iPitchRight;
   pNew->m_iPitchCenter = m_iPitchCenter;
   // pNew->m_iPitch = m_iPitch;
   // pNew->m_iPitchDelta = m_iPitchDelta;
   pNew->m_dwUniqueID = (DWORD)-1;  // dont want to copy
   //pNew->m_wPhone = (WORD)-1; // dont want to copy
   //pNew->m_wTriPhoneIndex = (WORD)-1; // dont want to copy
   pNew->m_fOrigPitch = m_fOrigPitch;
   pNew->m_dwFuncWordGroup = m_dwFuncWordGroup;
   pNew->m_fEnergyAvg = m_fEnergyAvg;
   pNew->m_fPitchDelta = m_fPitchDelta;
   pNew->m_fPitchBulge = m_fPitchBulge;
   pNew->m_fPitchLeft = m_fPitchLeft;
   pNew->m_fPitchRight = m_fPitchRight;
   pNew->m_fPitchCenter = m_fPitchCenter;
   pNew->m_fCenterEnergy = m_fCenterEnergy;
   pNew->m_fLeftEnergy = m_fLeftEnergy;
   pNew->m_fLeftPitch = m_fLeftPitch;
   pNew->m_dwLeftDuration = m_dwLeftDuration;
   memcpy (pNew->m_awTriPhone, m_awTriPhone, sizeof(m_awTriPhone));

   // NOTE: NOT cloniing m_alTPCONNECTERRORCache

   // NOTE: Clone NOT cloning the compressed data. May not be an issue

//   if (m_pmemSRFEATURE) {
//      if (!pNew->m_pmemSRFEATURE)
//         pNew->m_pmemSRFEATURE = new CMem;
//      if (!pNew->m_pmemSRFEATURE) {
//         delete pNew;
//         return NULL;
//      }
//      if (!pNew->m_pmemSRFEATURE->Required (m_dwNumSRFEATURE * sizeof(SRFEATURE))) {
//         delete pNew;
//         return NULL;
//      }
//      memcpy (pNew->m_pmemSRFEATURE->p, m_pmemSRFEATURE->p,
//         m_dwNumSRFEATURE * sizeof(SRFEATURE));
//   }
//   else if (pNew->m_pmemSRFEATURE) {
//      delete pNew->m_pmemSRFEATURE;
//      pNew->m_pmemSRFEATURE = NULL;
//   }

//   if (m_pmemTTSFEATURECOMPEXTRA) {
//      if (!pNew->m_pmemTTSFEATURECOMPEXTRA)
//         pNew->m_pmemTTSFEATURECOMPEXTRA = new CMem;
//      if (!pNew->m_pmemTTSFEATURECOMPEXTRA) {
//         delete pNew;
//         return NULL;
//      }
//      if (!pNew->m_pmemTTSFEATURECOMPEXTRA->Required (m_dwNumSRFEATURE * sizeof(TTSFEATURECOMPEXTRA))) {
//         delete pNew;
//         return NULL;
//      }
//      memcpy (pNew->m_pmemTTSFEATURECOMPEXTRA->p, m_pmemTTSFEATURECOMPEXTRA->p,
//         m_dwNumSRFEATURE * sizeof(TTSFEATURECOMPEXTRA));
//   }
//   else if (pNew->m_pmemTTSFEATURECOMPEXTRA) {
//      delete pNew->m_pmemTTSFEATURECOMPEXTRA;
//      pNew->m_pmemTTSFEATURECOMPEXTRA = NULL;
//   }

//   memcpy (pNew->m_aSRFeatBoundary, m_aSRFeatBoundary, sizeof(m_aSRFeatBoundary));
//   memcpy (pNew->m_afSRFeatBoundary, m_afSRFeatBoundary, sizeof(m_afSRFeatBoundary));

   return pNew;
}


static int _cdecl TPACONNECTIONERRORSort (const void *elem1, const void *elem2)
{
   TPACONNECTIONERROR *pdw1, *pdw2;
   pdw1 = (TPACONNECTIONERROR*) elem1;
   pdw2 = (TPACONNECTIONERROR*) elem2;

#ifdef USESMALLTPACONNECTIONERROR
   int iRet = (int)TCEUNIQUEIDEXTRACT(pdw1->dwTCECompact) - (int)TCEUNIQUEIDEXTRACT(pdw2->dwTCECompact);
//   int iRet = (int)pdw1->bPhone - (int)pdw2->bPhone;
//   if (iRet)
//      return iRet;
//   iRet = (int)pdw1->wTriPhoneIndex - (int)pdw2->wTriPhoneIndex;
   return iRet;
#else
   if (pdw1->pTPA > pdw2->pTPA)
      return 1;
   else if (pdw1->pTPA < pdw2->pTPA)
      return -1;
   else
      return 0;
#endif
}

/*************************************************************************************
CMTTSTriPhoneAudio::ConnectErrorCacheFree - Frees up the cache for this triphone.
*/
void CMTTSTriPhoneAudio::ConnectErrorCacheFree (void)
{
   DWORD i, dwDemi;
   for (i = 0; i < NUMJOINQUALITY; i++)
      for (dwDemi = 0; dwDemi < TTSDEMIPHONES; dwDemi++)
         m_alTPACONNECTIONERROR[i][dwDemi].ClearCompletely();
}

/*************************************************************************************
CMTTSTriPhoneAudio::ConnectErrorCacheSet - Sets a cache value for how much
of a connection penalty there is between the two units.

inputs
   DWORD                   dwJoinQuality - From 0..NUMJOINQUALITY-1
   PCMTTSTriPhoneAudio     *papPTA - List of triphone that caching with (previous unit)
   fp                      *pafValue - List of values to write, one per papPTA
   DWORD                   dwNum -Number of values in papPTA, pafValue
   DWORD                   dwSubPhone - 0..(TTSDEMIPHONES-1)
   DWORD                   dwMaxCache - Max number cached
returns
   BOOL - TRUE if success
*/
BOOL CMTTSTriPhoneAudio::ConnectErrorCacheSet (DWORD dwJoinQuality, PCMTTSTriPhoneAudio *papPTA, fp *pafValue, DWORD dwNum, DWORD dwSubPhone,
                                               DWORD dwMaxCache)
{
   DWORD dwNumCache = m_alTPACONNECTIONERROR[dwJoinQuality][dwSubPhone].Num();   // remember since will be added unsorted ones

   // cant add any more than the max
   dwMaxCache = max(dwMaxCache, 10);   // at least some
   if (dwMaxCache < dwNum)
      dwMaxCache = max(dwMaxCache, dwNum);   // must always be able to fit at least this many in
   dwNum = min(dwNum, dwMaxCache);

   // delete
   // BUGFIX - Make sure won't create too large a list that uses all the memory
   // potentially delete some
   PTPACONNECTIONERROR pFound;
   if (dwNumCache + dwNum > dwMaxCache) {
      DWORD dwDelete = dwNumCache + dwNum - dwMaxCache;
#ifndef TURNOFFRANDOM   // cant do because random off
      DWORD dwStart = (dwNumCache - dwDelete) ? (DWORD)rand() % (dwNumCache - dwDelete) : 0;
#else
      DWORD dwStart = 0;   // delete early ones
#endif

      pFound = (PTPACONNECTIONERROR)m_alTPACONNECTIONERROR[dwJoinQuality][dwSubPhone].Get(0);
      memmove (pFound + dwStart, pFound + (dwStart+dwDelete), (dwNumCache - dwDelete - dwStart) * sizeof(TPACONNECTIONERROR));
      // NOTE: Deleteion will NOT mess up sorting

      m_alTPACONNECTIONERROR[dwJoinQuality][dwSubPhone].Truncate (dwNumCache - dwDelete);
   }

#if 0 // def _DEBUG  // to test min/max
   static fp fMin = 0, fMax = 0;
#endif

   // add several at once so that only need to do one qsort
   // see if can find
   TPACONNECTIONERROR tpaFind;
   dwNumCache = m_alTPACONNECTIONERROR[dwJoinQuality][dwSubPhone].Num();
   memset (&tpaFind, 0, sizeof(tpaFind));
   DWORD i;
   m_alTPACONNECTIONERROR[dwJoinQuality][dwSubPhone].Required (dwNumCache + dwNum); // to speed to alloc
      // BUGFIX - Was only (dwNumCache + dwNum), but this might cause reallocing
      // BUGFIX - Took out max(dwNumCache + dwNum,dwMaxCache) because used too much memory
   for (i = 0; i < dwNum; i++) {
#ifdef USESMALLTPACONNECTIONERROR
      _ASSERTE (m_dwUniqueID != (DWORD)-1);
      _ASSERTE (papPTA[i]->m_dwUniqueID != (DWORD)-1);
      //_ASSERTE (m_wPhone != (WORD)-1);
      //_ASSERTE (m_wTriPhoneIndex != (WORD)-1);
      //_ASSERTE (papPTA[i]->m_wPhone != (WORD)-1);
      //_ASSERTE (papPTA[i]->m_wTriPhoneIndex != (WORD)-1);
      // _ASSERTE (papPTA[i]->m_wPhone == (dwSubPhone ? m_wPhone : (WORD)m_bPhoneLeft));
      //tpaFind.wTriPhoneIndex = papPTA[i]->m_wTriPhoneIndex;
      //tpaFind.bPhone = (BYTE) papPTA[i]->m_wPhone;

      fp f = pafValue[i] / (fp)TCEVALUEMAXASFP * (fp)TCEVALUEMAXASINT;
      _ASSERTE (f >= 0.0);
      _ASSERTE (f < TCEVALUEMAXASINT*2.0);   // to make sure not trimming off too much
      f = max(f, 0);
      f = min(f, (fp)TCEVALUEMAXASINT);
      //tpaFind.bValue = (BYTE)f;
      tpaFind.dwTCECompact = TCECOMPACTCREATE((DWORD)f, papPTA[i]->m_dwUniqueID);
#else
      tpaFind.pTPA = papPTA[i];
      tpaFind.fValue = pafValue[i];
#endif
      pFound = (PTPACONNECTIONERROR) bsearch (&tpaFind, m_alTPACONNECTIONERROR[dwJoinQuality][dwSubPhone].Get(0), dwNumCache, sizeof(TPACONNECTIONERROR), TPACONNECTIONERRORSort);
      if (pFound) {
         *pFound = tpaFind;
         continue;
      }

      // else, add. Don't worry about sorting yet because will sort as a block
      m_alTPACONNECTIONERROR[dwJoinQuality][dwSubPhone].Add (&tpaFind);

#if 0 // def _DEBUG  // to test
      fMin = min(fMin, tpaFind.fValue);
      fMax = max(fMax, tpaFind.fValue);
#endif
   } // i

   // else, add and qsort
   // NOTE: QSort should be fast with only one new element added
   if (dwNumCache != m_alTPACONNECTIONERROR[dwJoinQuality][dwSubPhone].Num())
      // sort these
      qsort (m_alTPACONNECTIONERROR[dwJoinQuality][dwSubPhone].Get(0), m_alTPACONNECTIONERROR[dwJoinQuality][dwSubPhone].Num(), sizeof(TPACONNECTIONERROR), TPACONNECTIONERRORSort);

   return TRUE;
}



/*************************************************************************************
CMTTSTriPhoneAudio::ConnectErrorCacheGet - Gets a cache value for how much
of a connection penalty there is between the two units.

inputs
   DWORD                   dwJoinQuality - From 0..NUMJOINQUALITY-1
   PCMTTSTriPhoneAudio     pPTA - Previous triphone that caching with
   DWORD                   dwSubPhone - 0..(TTSDEMIPHONES-1)
   fp                      *pfValue - Filled in with the connection value if successful
returns
   BOOL - TRUE if success. FALSE if cant find cache of connection
*/
BOOL CMTTSTriPhoneAudio::ConnectErrorCacheGet (DWORD dwJoinQuality, PCMTTSTriPhoneAudio pPTA, DWORD dwSubPhone, fp *pfValue)
{
   // see if can find
   TPACONNECTIONERROR tpaFind;
   PTPACONNECTIONERROR pFound;
   //memset (&tpaFind, 0, sizeof(tpaFind));

#ifdef USESMALLTPACONNECTIONERROR
   _ASSERTE (m_dwUniqueID != (DWORD)-1);
   _ASSERTE (pPTA->m_dwUniqueID != (DWORD)-1);
   //_ASSERTE (m_wPhone != (WORD)-1);
   //_ASSERTE (m_wTriPhoneIndex != (WORD)-1);
   //_ASSERTE (pPTA->m_wPhone != (WORD)-1);
   //_ASSERTE (pPTA->m_wTriPhoneIndex != (WORD)-1);
   // _ASSERTE (pPTA->m_wPhone == (dwSubPhone ? m_wPhone : (WORD)m_bPhoneLeft));
   //tpaFind.wTriPhoneIndex = pPTA->m_wTriPhoneIndex;
   //tpaFind.bPhone = (BYTE) pPTA->m_wPhone;
   tpaFind.dwTCECompact = TCECOMPACTCREATE(0, pPTA->m_dwUniqueID);
#else
   tpaFind.pTPA = pPTA;
#endif
   //tpaFind.bValue = bValue;
   pFound = (PTPACONNECTIONERROR) bsearch (&tpaFind, m_alTPACONNECTIONERROR[dwJoinQuality][dwSubPhone].Get(0), m_alTPACONNECTIONERROR[dwJoinQuality][dwSubPhone].Num(), sizeof(TPACONNECTIONERROR), TPACONNECTIONERRORSort);
   if (!pFound)
      return FALSE;

   // else, found
#ifdef USESMALLTPACONNECTIONERROR
   *pfValue = (fp)TCEVALUEEXTRACT(pFound->dwTCECompact) / (fp)TCEVALUEMAXASINT * TCEVALUEMAXASFP;
#else
   *pfValue = pFound->fValue;
#endif
   return TRUE;
}


/*************************************************************************************
CMTTSTriPhoneAudio::SRFEATUREGetRange - This gets the SRFEATURE from the object, assumes
that Decompress() has already been called.

inputs
   PCMTTS               pTTS - TTS so can get the audio
   PCMem                pMem - Memory to fill features into. Doing this so can incorporate m_iFeatureAdd.
   DWORD                dwFeatureStart - Starting feature
   DWORD                dwFeatureEnd - Ending feature
   DWORD                *pdwNumFeat - Filled with the number of features
   BOOL                 *pfToLeft - Filled with TRUE if returns PSRFEATURE[-1] is valid.
                           Can be NULL
   float                *pfPitch - Filled with the pitch at the point. Can be NULL
   PTTSFEATURECOMPEXTRA  *ppaTFCA - Filled with a point to the location of the pitch point.
                                    Can be NULL.
returns
   PSRFEATURE - SRFEATURE to use.
*/
PSRFEATURE CMTTSTriPhoneAudio::SRFEATUREGetRange (PCMTTS pTTS, PCMem pMem, DWORD dwFeatureStart, DWORD dwFeatureEnd, DWORD *pdwNumFeat,
                                             BOOL *pfToLeft, float *pfPitch, PTTSFEATURECOMPEXTRA *ppaTFCA)
{
   if (ppaTFCA)
      *ppaTFCA = NULL;
   if (pfPitch)
      *pfPitch = 0.0;
   *pdwNumFeat = 0;  // in case exit
   if (pfToLeft)
      *pfToLeft = FALSE;

   PCTTSWave pTW = pTTS->TTSFindWave (m_wOrigWave);
   if (!pTW)
      return NULL;
   DWORD dwPrior, dwAfter;
   PTTSFEATURECOMPEXTRA pTFCE;
   PSRFEATURE pSRFGet = pTW->GetSRFEATURE (&pTTS->m_acsTTSWave[m_wOrigWave % MAXRAYTHREAD], dwFeatureStart, dwFeatureEnd, &dwPrior, &dwAfter, &pTFCE);
   if (!pSRFGet)
      return NULL;

   // include a left and right feature if possible
   DWORD dwNumGotten = dwFeatureEnd - dwFeatureStart;
   if (dwPrior) {
      pSRFGet--;
      dwNumGotten++;
   }
   if (dwAfter)
      dwNumGotten++;
   if (!pMem->Required (dwNumGotten * sizeof(SRFEATURE)))
      return NULL;
   PSRFEATURE pSRFMod = (PSRFEATURE)pMem->p;
   memcpy (pSRFMod, pSRFGet, dwNumGotten * sizeof(SRFEATURE));

   // modify
   PSRFEATURE psr = pSRFMod;
   int iTemp;
   DWORD i, j;
   for (i = 0; i < dwNumGotten; i++, psr++) {
      for (j = 0; j < SRDATAPOINTS; j++) {
         iTemp = (int)psr->acVoiceEnergy[j] + m_iFeatureAdd;
         iTemp = max(iTemp, -127);
         iTemp = min(iTemp, 127);
         psr->acVoiceEnergy[j] = (char)iTemp;

         iTemp = (int)psr->acNoiseEnergy[j] + m_iFeatureAdd;
         iTemp = max(iTemp, -127);   // BUGFIX - Make this -100 so that when do RLE
                                    // encoding on MMLTo output will get lots of compression
         iTemp = min(iTemp, 127);
         psr->acNoiseEnergy[j] = (char)iTemp;
      } // j
   } // i

   PSRFEATURE pSROrig = pSRFMod + (dwPrior ? 1 : 0);
   if (pdwNumFeat)
      *pdwNumFeat = dwFeatureEnd - dwFeatureStart;
   if (pfToLeft)
      *pfToLeft = (pSROrig > pSRFMod);
   if (pfPitch)
      *pfPitch = pTFCE->fPitch;
   if (ppaTFCA)
      *ppaTFCA = pTFCE;
   return pSROrig;
}

#if 0 // old implementation
/*************************************************************************************
CMTTSTriPhoneAudio::SRFEATUREGet - This gets the SRFEATURE from the object, assumes
that Decompress() has already been called.

inputs
   PCMTTS               pTTS - TTS so can get the audio
   PCMem                pMem - Memory to fill features into. Doing this so can incorporate m_iFeatureAdd.
   DWORD                dwSkip - Bit field of 0x01 if the m_dwSkipLeft can be usd,
                           0x02 if m_dwSkipRight can be used
   DWORD                dwDemiPhone - Demiphone number, or -1 if all
   DWORD                *pdwNumFeat - Filled with the number of features
   BOOL                 *pfToLeft - Filled with TRUE if returns PSRFEATURE[-1] is valid.
                           Can be NULL
   float                *pfPitch - Filled with the pitch at the point. Can be NULL
   PTTSFEATURECOMPEXTRA  *ppaTFCA - Filled with a point to the location of the pitch point.
                                    Can be NULL.
returns
   PSRFEATURE - SRFEATURE to use.
*/
PSRFEATURE CMTTSTriPhoneAudio::SRFEATUREGet (PCMTTS pTTS, PCMem pMem, DWORD dwSkip, DWORD dwDemiPhone, DWORD *pdwNumFeat,
                                             BOOL *pfToLeft, float *pfPitch, PTTSFEATURECOMPEXTRA *ppaTFCA)
{
   if (ppaTFCA)
      *ppaTFCA = NULL;
   if (pfPitch)
      *pfPitch = 0.0;
   *pdwNumFeat = 0;  // in case exit
   if (pfToLeft)
      *pfToLeft = FALSE;

   PCTTSWave pTW = pTTS->TTSFindWave (m_wOrigWave);
   if (!pTW)
      return NULL;
   DWORD dwPrior, dwAfter;
   PTTSFEATURECOMPEXTRA pTFCE;
   PSRFEATURE pSRFGet = pTW->GetSRFEATURE (&m_acsTTSWave[m_wOrigWave % MAXRAYTHREAD], m_dwFeatureStart, m_dwFeatureEnd, &dwPrior, &dwAfter, &pTFCE);
   if (!pSRFGet)
      return NULL;

   // include a left and right feature if possible
   DWORD dwNumGotten = m_dwFeatureEnd - m_dwFeatureStart;
   if (dwPrior) {
      pSRFGet--;
      dwNumGotten++;
   }
   if (dwAfter)
      dwNumGotten++;
   if (!pMem->Required (dwNumGotten * sizeof(SRFEATURE)))
      return NULL;
   PSRFEATURE pSRFMod = (PSRFEATURE)pMem->p;
   memcpy (pSRFMod, pSRFGet, dwNumGotten * sizeof(SRFEATURE));

   // modify
   PSRFEATURE psr = pSRFMod;
   int iTemp;
   DWORD i, j;
   for (i = 0; i < dwNumGotten; i++, psr++) {
      for (j = 0; j < SRDATAPOINTS; j++) {
         iTemp = (int)psr->acVoiceEnergy[j] + m_iFeatureAdd;
         iTemp = max(iTemp, -127);
         iTemp = min(iTemp, 127);
         psr->acVoiceEnergy[j] = (char)iTemp;

         iTemp = (int)psr->acNoiseEnergy[j] + m_iFeatureAdd;
         iTemp = max(iTemp, -127);   // BUGFIX - Make this -100 so that when do RLE
                                    // encoding on MMLTo output will get lots of compression
         iTemp = min(iTemp, 127);
         psr->acNoiseEnergy[j] = (char)iTemp;
      } // j
   } // i

   // BUGFIX - determine if can skip the left/right amount, to counteract segmentation vagueness
   BOOL fSkipLeft = (dwSkip & 0x01) ? TRUE : FALSE;
   BOOL fSkipRight = (dwSkip & 0x02) ? TRUE : FALSE;

   DWORD dwNumFeat = m_dwFeatureEnd - m_dwFeatureStart;
   if (!dwNumFeat)
      return NULL;  // shouldnt happen

   PSRFEATURE pSROrig = pSRFMod + (dwPrior ? 1 : 0);

   // skip
   if (fSkipLeft) {
      pSROrig += m_dwTrimLeft;
      dwNumFeat -= m_dwTrimLeft;
   }
   if (fSkipRight)
      dwNumFeat -= m_dwTrimRight;
   if (!dwNumFeat)
      return NULL;  // shouldnt happen

   // if have selected to get the entire wave then exit now
   if (dwDemiPhone == (DWORD)-1) {
      *pdwNumFeat = dwNumFeat;
      if (pfToLeft)
         *pfToLeft = (pSROrig > pSRFMod);

      // leave pitch as 0

      return pSROrig;
   }

   // else, figure out start and end
   DWORD dwSubStart = dwDemiPhone * dwNumFeat / TTSDEMIPHONES;
   DWORD dwSubEnd = (dwDemiPhone+1) * dwNumFeat / TTSDEMIPHONES;
   if (dwSubEnd <= dwSubStart)
      dwSubEnd = dwSubStart + 1; // so at least have soemthing
   if (dwSubEnd > dwNumFeat) {
      dwSubEnd = dwNumFeat;
      if (dwSubStart >= dwSubEnd)
         dwSubStart = dwSubEnd - 1;
   }
   pSROrig += dwSubStart;
   dwNumFeat = dwSubEnd - dwSubStart;
   if (!dwNumFeat)
      return NULL;  // shouldnt happen

   *pdwNumFeat = dwNumFeat;
   if (pfToLeft)
      *pfToLeft = (pSROrig > pSRFMod);

   if (pfPitch)
      *pfPitch = pTFCE[dwSubStart].fPitch;

   if (ppaTFCA)
      *ppaTFCA = pTFCE + dwSubStart;

   return pSROrig;
}
#endif // 0

/*************************************************************************************
CMTTSTriPhoneAudio::SRFEATURESet - Copies the SRFEATUREs from pSrc into the object.
In the process it normalizes based on fMaxEnergyForWave so that all the units will
have the same maximum energy. It also calculates the energy start and end.

Generally, when setting SRFEATUREs, should call this.

inputs
   PCMTTS               pTTS - TTS to use, where to get audio from
   DWORD                dwSentenceNum - Sentence number
   DWORD                dwFeatureStart - Start SRFEATURE.
   DWORD                dwFeatureEnd - Ending feature
   fp                   fMaxEnergyForWave - Maximum energy encountered in the training
                        data. Used to control boundary normalization
   fp                   fMaxEnergyForWaveMod - Potentially extra modifier. Used to normalize all.
//   PSRFEATURE           pLeft - SRFeature immediately before audio for triphone. If NULL, assume silence
//   PSRFEATURE           pRight - SRFeature immediately after audio for triphone. If NULL, assume silence

returns
   BOOL - TRUE if success
*/
BOOL CMTTSTriPhoneAudio::SRFEATURESet (PCMTTS pTTS, DWORD dwSentenceNum, DWORD dwFeatureStart, DWORD dwFeatureEnd,
                                       fp fMaxEnergyForWave, fp fMaxEnergyForWaveMod)
{
   // make sure exists
   PCTTSWave pTW = pTTS->TTSFindWave (dwSentenceNum);
   if (!pTW)
      return FALSE;
   DWORD dwPrior, dwAfter;
   PTTSFEATURECOMPEXTRA pTFCE;
   PSRFEATURE pSrc = pTW->GetSRFEATURE (&pTTS->m_acsTTSWave[dwSentenceNum % MAXRAYTHREAD],
      dwFeatureStart, dwFeatureEnd, &dwPrior, &dwAfter, &pTFCE);
   if (!pSrc)
      return FALSE;
   DWORD dwNum = dwFeatureEnd - dwFeatureStart;
   PSRFEATURE pLeft = dwPrior ? (pSrc - 1) : NULL;
   PSRFEATURE pRight = dwAfter ? (pSrc + dwNum) : NULL;



   // figure out how much to normalize by
   fMaxEnergyForWave = max(fMaxEnergyForWave, CLOSE);
   fp fScaleBy = THEORETICALMAXENERGY / fMaxEnergyForWave;
   fp fScaleByMod = THEORETICALMAXENERGY / fMaxEnergyForWaveMod;
   int iAdd = (int)(log10(fScaleByMod) * 20.0);

   // store away left/right audio so can make smoother transitions
   SRFEATURE cSilence;
   DWORD i; // , j;
   if (!pLeft || !pRight) {
      memset (&cSilence, 0, sizeof(cSilence));
      for (i = 0; i < SRDATAPOINTS; i++) {
         cSilence.acNoiseEnergy[i] = SRNOISEFLOOR;
         cSilence.acVoiceEnergy[i] = SRABSOLUTESILENCE;
      }

      if (!pLeft)
         pLeft = &cSilence;
      if (!pRight)
         pRight = &cSilence;
   }
   for (i = 0; i < (TTSDEMIPHONES+1)*2; i++) {
      PSRFEATURE psr, psrLeft;
      int iIndex = (int)(i/2) * (int)dwNum / (int)TTSDEMIPHONES;
      if (!(i%2))
         iIndex--;   // look back

      if (iIndex < 0) {
         psr = pLeft;
         psrLeft = NULL;
      }
      else if (iIndex >= (int)dwNum) {
         psr = pRight;
         psrLeft = dwNum ? (pSrc + (dwNum-1)) : pLeft;
      }
      else {
         psr = pSrc + iIndex;
         psrLeft = (iIndex ? &pSrc[iIndex-1] : pLeft);
      }

//      // store the energy away
//      SRFEATUREConvert (psr, psrLeft, &m_aSRFeatBoundary[i]);
//      m_afSRFeatBoundary[i] = SRFEATUREEnergySmall (TRUE, &m_aSRFeatBoundary[i], FALSE, TRUE);
//      m_afSRFeatBoundary[i] = max(m_afSRFeatBoundary[i], 1);   // so have something
//      SRFEATUREScale (&m_aSRFeatBoundary[i], PHONESAMPLENORMALIZED / m_afSRFeatBoundary[i]);
//      m_afSRFeatBoundary[i] *= fScaleBy;  // so all noramlized to what expected

   } // i

   m_dwFeatureStart = dwFeatureStart;
   m_dwFeatureEnd = dwFeatureEnd;
   m_iFeatureAdd = iAdd;

   // allocate memory for srfeature
//   if (!m_pmemSRFEATURE)
//      m_pmemSRFEATURE = new CMem;
//   if (!m_pmemSRFEATURE)
//      return FALSE;
//   m_memCompressed.m_dwCurPosn = 0; // since compression data will be invalid
//   m_dwKeepMemorySize = 0;

   // copy over
//   if (!m_pmemSRFEATURE->Required (dwNum * sizeof(SRFEATURE)))
//      return FALSE;
//   memcpy (m_pmemSRFEATURE->p, pSrc, dwNum * sizeof(SRFEATURE));
//   m_dwNumSRFEATURE = dwNum;
//   PSRFEATURE psr = (PSRFEATURE) m_pmemSRFEATURE->p;
//   int iTemp;
//   for (i = 0; i < dwNum; i++, psr++) {
//      for (j = 0; j < SRDATAPOINTS; j++) {
//         iTemp = (int)psr->acVoiceEnergy[j] + iAdd;
//         iTemp = max(iTemp, -127);
//         iTemp = min(iTemp, 127);
//         psr->acVoiceEnergy[j] = (char)iTemp;

//         iTemp = (int)psr->acNoiseEnergy[j] + iAdd;
//         iTemp = max(iTemp, -100);   // BUGFIX - Make this -100 so that when do RLE
                                    // encoding on MMLTo output will get lots of compression
//         iTemp = min(iTemp, 127);
//         psr->acNoiseEnergy[j] = (char)iTemp;
//      } // j
//   } // i

//   if (!m_pmemTTSFEATURECOMPEXTRA)
//      m_pmemTTSFEATURECOMPEXTRA = new CMem;
//   if (!m_pmemTTSFEATURECOMPEXTRA)
//      return FALSE;
//   if (!m_pmemTTSFEATURECOMPEXTRA->Required (dwNum * sizeof(TTSFEATURECOMPEXTRA)))
//      return FALSE;
//   PTTSFEATURECOMPEXTRA ptce = (PTTSFEATURECOMPEXTRA)m_pmemTTSFEATURECOMPEXTRA->p;
//   memset (ptce, 0, dwNum * sizeof(TTSFEATURECOMPEXTRA));
//   for (i = 0; i < dwNum; i++)
//      ptce[i].fPitch = pafPitch[i];

   // calculate the energy
   // BUGFIX - No longer used
   // CalcEnergy (); // let calcenergy recompress

   // done
   return TRUE;
}

/*************************************************************************************
TimeMaxCalc - Calculates time/phase max.

inputs
   DWORD          dwSkip - Amount to skip
   DWORD          dwSamples - Number of samples (m_dwNumSRFEATURE)
returns
   DWORD - Number of entries
*/
DWORD TimeMaxCalc (DWORD dwSkip, DWORD dwSamples)
{
   // if two or fewer, always that many
   if ((dwSamples <= 2) || (dwSkip <= 1))
      return dwSamples;

   return (dwSamples + (dwSkip-1)) / dwSkip + 1;
}

#if 0 // no longer support
/*************************************************************************************
CMTTSTriPhoneAudio::Compress - Compresses the memory in m_pmemSRFEATURE into m_memCompressed.
It then deletes m_pmemSRFEATURE. NOTE: This will NOT do anything if m_memCompressed
already has a m_dwCurPosn.

Also uses m_pmemTTSFEATURECOMPEXTRA.

returns
   BOOL - TRUE if success, FALSE if fail
*/
BOOL CMTTSTriPhoneAudio::Compress (void)
{
   if (!m_pmemSRFEATURE || !m_pmemTTSFEATURECOMPEXTRA)
      return TRUE;

   if (m_dwKeepMemorySize /*m_memCompressed.m_dwCurPosn*/) {
      // already data
      delete m_pmemSRFEATURE;
      m_pmemSRFEATURE = NULL;
      
      delete m_pmemTTSFEATURECOMPEXTRA;
      m_pmemTTSFEATURECOMPEXTRA = NULL;

      return TRUE;
   }

   // allocate a block large enough to compress to... which is basically
   // the size of the original data
   CMem mem;
   if (!mem.Required(m_dwNumSRFEATURE * (sizeof(SRFEATURE) + sizeof(TTSFEATURECOMPPCM) + sizeof(TTSFEATURECOMPEXTRA) )))
      return FALSE;

   // compression settings
   // BOOL fTimeCompress = (m_wFlags & TPMML_TIMECOMPRESS) ? TRUE : FALSE;
   // BOOL fTimePhaseCompress = FALSE;
   BOOL fFreqCompress;
   BOOL fIncludePCM;
   switch (m_wFlags & TPMML_FREQCOMPRESSMASK) {
   default:
   case TPMML_FREQCOMPRESS_0: // none
      fFreqCompress = FALSE;
      fIncludePCM = TRUE;
      break;
   case TPMML_FREQCOMPRESS_1: // some
      fFreqCompress = FALSE;
      fIncludePCM = FALSE;
      break;
   case TPMML_FREQCOMPRESS_2: // max
      fFreqCompress = TRUE;
      fIncludePCM = FALSE;
      break;
   } // switch

   // BUGFIX - More compression options
   DWORD dwTimeSkip = 1, dwTimePhaseSkip = 1;
   switch (m_wFlags & TPMML_TIMECOMPRESSMASK) {
   case TPMML_TIMECOMPRESS_0: // none
      dwTimeSkip = 1;
      dwTimePhaseSkip = 1;
      break;
   case TPMML_TIMECOMPRESS_1: // minimal
      dwTimeSkip = 2;
      dwTimePhaseSkip = 1;
      break;
   case TPMML_TIMECOMPRESS_2: // more
      dwTimeSkip = 3;
      dwTimePhaseSkip = 2;
      break;
   case TPMML_TIMECOMPRESS_3: // most
      dwTimeSkip = 4;
      dwTimePhaseSkip = 2;
      break;
   } // switch
   dwTimePhaseSkip = min(dwTimePhaseSkip, 2);   // this code can't handle a phase skip > 2

   // how much time
   DWORD dwTimeMax = TimeMaxCalc (dwTimeSkip, m_dwNumSRFEATURE);
   DWORD dwTimePhaseMax = TimeMaxCalc (dwTimePhaseSkip, m_dwNumSRFEATURE);

   // loop through all frequencies of voiced
   DWORD dwFreq, dwSize, dwTime;
   PSRFEATURE psr;
   char cAverage;
   dwFreq = fFreqCompress ? 3 : 0;
   while (dwFreq < SRDATAPOINTS) {
      // increase counter
      if (!fFreqCompress)
         dwSize = 1;   // no compression
      else if (dwFreq < SRDATAPOINTS/3)
         dwSize = 3;   // skip heaps in low frequencies
      else if (dwFreq < SRDATAPOINTS*2/3)
         dwSize = 2;   // skip some
      else
         dwSize = 1;   // high resolution

      // loop over all time
      for (dwTime = 0; dwTime < dwTimeMax; dwTime++) {
         psr = (PSRFEATURE) m_pmemSRFEATURE->p + ((dwTimeSkip>1) ?
            min(dwTime*dwTimeSkip, m_dwNumSRFEATURE-1) : dwTime);

         // get value
         switch (dwSize) {
         case 1:
            cAverage = psr->acVoiceEnergy[dwFreq];
            break;
         case 2:
            cAverage = AmplitudeToDb ((DbToAmplitude(psr->acVoiceEnergy[dwFreq-1]) + DbToAmplitude(psr->acVoiceEnergy[dwFreq])) / 2.0);
            break;
         case 3:
            cAverage = AmplitudeToDb ((DbToAmplitude(psr->acVoiceEnergy[dwFreq-1]) + DbToAmplitude(psr->acVoiceEnergy[dwFreq]) + 
               DbToAmplitude(psr->acVoiceEnergy[dwFreq+1])) / 3.0);
            break;
         }

         // write the value out
         ((char*)mem.p)[mem.m_dwCurPosn++] = cAverage;
      } // dwTime

      // increase counter
      dwFreq += dwSize;
   } // while dwFreq < SRDATAPOINTS

   // loop through all frequencies of unvoiced
   dwFreq = fFreqCompress ? 4 : 1;
   while (dwFreq < SRDATAPOINTS) {
      // increase counter
      if (!fFreqCompress)
         dwSize = 2;   // not much compression
      else if (dwFreq < SRDATAPOINTS/3)
         dwSize = 4;   // skip heaps in low frequencies
      else if (dwFreq < SRDATAPOINTS*2/3)
         dwSize = 3;   // skip some
      else
         dwSize = 2;   // high resolution

      // loop over all time
      for (dwTime = 0; dwTime < dwTimeMax; dwTime++) {
         psr = (PSRFEATURE) m_pmemSRFEATURE->p + ((dwTimeSkip>1) ?
            min(dwTime*dwTimeSkip, m_dwNumSRFEATURE-1) : dwTime);

         // get value
         switch (dwSize) {
         case 2:
            cAverage = AmplitudeToDb ((DbToAmplitude(psr->acNoiseEnergy[dwFreq-1]) + DbToAmplitude(psr->acNoiseEnergy[dwFreq])) / 2.0);
            break;
         case 3:
            cAverage = AmplitudeToDb ((DbToAmplitude(psr->acNoiseEnergy[dwFreq-1]) + DbToAmplitude(psr->acNoiseEnergy[dwFreq]) + 
               DbToAmplitude(psr->acNoiseEnergy[dwFreq+1])) / 3.0);
            break;
         case 4:
            cAverage = AmplitudeToDb ((DbToAmplitude(psr->acNoiseEnergy[dwFreq-2]) + DbToAmplitude(psr->acNoiseEnergy[dwFreq-1]) +
               DbToAmplitude(psr->acNoiseEnergy[dwFreq]) + DbToAmplitude(psr->acNoiseEnergy[dwFreq+1])) / 4.0);
            break;
         }

         // write the value out
         ((char*)mem.p)[mem.m_dwCurPosn++] = cAverage;
      } // dwTime

      // increase counter
      dwFreq += dwSize;
   } // while dwFreq < SRDATAPOINTS

   // loop through all frequencies of phase
   DWORD dwFreqMax = fFreqCompress ? (SRPHASENUM/2) : SRPHASENUM;
   for (dwFreq = 0; dwFreq < dwFreqMax; dwFreq++) {
      // loop over all time
      for (dwTime = 0; dwTime < dwTimePhaseMax; dwTime++) {
         psr = (PSRFEATURE) m_pmemSRFEATURE->p + ((dwTimePhaseSkip > 1) ?
            min(dwTime*dwTimePhaseSkip, m_dwNumSRFEATURE-1) : dwTime);

         // write the value out
         ((BYTE*)mem.p)[mem.m_dwCurPosn++] = psr->abPhase[dwFreq];
      } // dwTime
   } // dwFreq

   // write the pitch and PCM
   TTSFEATURECOMPEXTRA tce;
   TTSFEATURECOMPPCM tcp;
   memset (&tce, 0, sizeof(tce));
   memset (&tcp, 0, sizeof(tcp));
   for (dwTime = 0; dwTime < dwTimePhaseMax; dwTime++) {
      DWORD dwIndex = ((dwTimePhaseSkip > 1) ?
         min(dwTime*dwTimePhaseSkip, m_dwNumSRFEATURE-1) : dwTime);
      psr = (PSRFEATURE) m_pmemSRFEATURE->p + dwIndex;

      // write the pitch out
      tce.fPitch = ((PTTSFEATURECOMPEXTRA) m_pmemTTSFEATURECOMPEXTRA->p)[dwIndex].fPitch;
      memcpy ((BYTE*)mem.p + mem.m_dwCurPosn, &tce, sizeof(tce));
      mem.m_dwCurPosn += sizeof(tce);

      // write out the PCM
      if (fIncludePCM) {
         tcp.bPCMHarmFadeStart = psr->bPCMHarmFadeStart;
         tcp.bPCMHarmFadeFull = psr->bPCMHarmFadeFull;
         tcp.bPCMHarmNyquist = psr->bPCMHarmNyquist;
         tcp.bPCMFill = psr->bPCMFill;
         tcp.fPCMScale = psr->fPCMScale;
         memcpy (tcp.acPCM, psr->acPCM, sizeof(tcp.acPCM));

         memcpy ((BYTE*)mem.p + mem.m_dwCurPosn, &tcp, sizeof(tcp));
         mem.m_dwCurPosn += sizeof(tcp);
      }
   } // dwTime


   // compress
   m_memCompressed.m_dwCurPosn = m_dwKeepMemorySize = 0;
   if (RLEEncode ((PBYTE)mem.p, mem.m_dwCurPosn, 1, &m_memCompressed))
      return FALSE;
   m_dwKeepMemorySize = m_memCompressed.m_dwCurPosn;
   m_pKeepMemoryCompressed = m_memCompressed.p;
   m_fKeepMemory = FALSE;

   delete m_pmemSRFEATURE;
   m_pmemSRFEATURE = NULL;
   delete m_pmemTTSFEATURECOMPEXTRA;
   m_pmemTTSFEATURECOMPEXTRA = NULL;
   return TRUE;
}
#endif // 0 - no longer support


#if 0 // no longer support
/*************************************************************************************
CMTTSTriPhoneAudio::Decompress - Decompresses the memory in m_memCompressed into m_pmemSRFEATURE.
NOTE: This will NOT do anything if m_pmemSRFEATURE already has anything.

Also fils in m_pmemTTSFEATURECOMPEXTRA.


returns
   BOOL - TRUE if success, FALSE if fail
*/
BOOL CMTTSTriPhoneAudio::Decompress (void)
{
   if (m_pmemSRFEATURE || m_pmemTTSFEATURECOMPEXTRA)
      return TRUE;   // already data

   // create new memory
   m_pmemSRFEATURE = new CMem;
   if (!m_pmemSRFEATURE)
      return FALSE;

   m_pmemTTSFEATURECOMPEXTRA = new CMem;
   if (!m_pmemTTSFEATURECOMPEXTRA)
      return FALSE;

   if (!m_dwKeepMemorySize /*m_memCompressed.m_dwCurPosn*/)
      return TRUE;   // no data

   // allocate memory for srfeature
   if (!m_pmemSRFEATURE->Required (m_dwNumSRFEATURE * (sizeof(SRFEATURE) + sizeof(TTSFEATURECOMPPCM) + sizeof(TTSFEATURECOMPEXTRA) ) ))
      return FALSE;  // error
   
   if (!m_pmemTTSFEATURECOMPEXTRA->Required (m_dwNumSRFEATURE * sizeof(TTSFEATURECOMPEXTRA)))
      return FALSE;

   // compression settings
   // BOOL fTimeCompress = (m_wFlags & TPMML_TIMECOMPRESS) ? TRUE : FALSE;
   // BOOL fTimePhaseCompress = FALSE;
   BOOL fFreqCompress;
   BOOL fIncludePCM;
   switch (m_wFlags & TPMML_FREQCOMPRESSMASK) {
   default:
   case TPMML_FREQCOMPRESS_0: // none
      fFreqCompress = FALSE;
      fIncludePCM = TRUE;
      break;
   case TPMML_FREQCOMPRESS_1: // some
      fFreqCompress = FALSE;
      fIncludePCM = FALSE;
      break;
   case TPMML_FREQCOMPRESS_2: // max
      fFreqCompress = TRUE;
      fIncludePCM = FALSE;
      break;
   } // switch

   // BUGFIX - More compression options
   DWORD dwTimeSkip = 1, dwTimePhaseSkip = 1;
   switch (m_wFlags & TPMML_TIMECOMPRESSMASK) {
   case TPMML_TIMECOMPRESS_0: // none
      dwTimeSkip = 1;
      dwTimePhaseSkip = 1;
      break;
   case TPMML_TIMECOMPRESS_1: // minimal
      dwTimeSkip = 2;
      dwTimePhaseSkip = 1;
      break;
   case TPMML_TIMECOMPRESS_2: // more
      dwTimeSkip = 3;
      dwTimePhaseSkip = 2;
      break;
   case TPMML_TIMECOMPRESS_3: // most
      dwTimeSkip = 4;
      dwTimePhaseSkip = 2;
      break;
   } // switch
   dwTimePhaseSkip = min(dwTimePhaseSkip, 2);   // this code can't handle a phase skip > 2


   // create a remap table for voiced and unvoiced
   DWORD adwRemapVoiced[SRDATAPOINTS], adwRemapUnvoiced[SRDATAPOINTS];
   memset (adwRemapVoiced, 0, sizeof(adwRemapVoiced));
   memset (adwRemapUnvoiced, 0, sizeof(adwRemapUnvoiced));
   DWORD dwFreq, dwSize, dwVoiced, dwUnvoiced;
   dwFreq = fFreqCompress ? 3 : 0;
   dwVoiced = 0;
   while (dwFreq < SRDATAPOINTS) {
      // increase counter
      if (!fFreqCompress)
         dwSize = 1;   // no compression
      else if (dwFreq < SRDATAPOINTS/3)
         dwSize = 3;   // skip heaps in low frequencies
      else if (dwFreq < SRDATAPOINTS*2/3)
         dwSize = 2;   // skip some
      else
         dwSize = 1;   // high resolution

      adwRemapVoiced[dwVoiced++] = dwFreq;
      dwFreq += dwSize;
   }

   dwFreq = fFreqCompress ? 4 : 1;
   dwUnvoiced = 0;
   while (dwFreq < SRDATAPOINTS) {
      // increase counter
      if (!fFreqCompress)
         dwSize = 2;   // not much compression
      else if (dwFreq < SRDATAPOINTS/3)
         dwSize = 4;   // skip heaps in low frequencies
      else if (dwFreq < SRDATAPOINTS*2/3)
         dwSize = 3;   // skip some
      else
         dwSize = 2;   // high resolution

      adwRemapUnvoiced[dwUnvoiced++] = dwFreq;
      dwFreq += dwSize;
   }

   DWORD dwTimeMax = TimeMaxCalc (dwTimeSkip, m_dwNumSRFEATURE);
   DWORD dwTimePhaseMax = TimeMaxCalc (dwTimePhaseSkip, m_dwNumSRFEATURE);

   DWORD dwFreqMax = fFreqCompress ? (SRPHASENUM/2) : SRPHASENUM;

   // run-length decode
   size_t dwUsed;
   CMem mem;
   if (RLEDecode ((PBYTE)m_pKeepMemoryCompressed /*m_memCompressed.p*/, m_dwKeepMemorySize /*m_memCompressed.m_dwCurPosn*/, 1, &mem, &dwUsed))
      return FALSE;
   if (mem.m_dwCurPosn != dwTimeMax * (dwVoiced + dwUnvoiced) + dwTimePhaseMax * (dwFreqMax + sizeof(TTSFEATURECOMPEXTRA) + (fIncludePCM ? sizeof(TTSFEATURECOMPPCM) : 0)) ) {
      delete m_pmemSRFEATURE;
      m_pmemSRFEATURE = NULL;
      delete m_pmemTTSFEATURECOMPEXTRA;
      m_pmemTTSFEATURECOMPEXTRA = NULL;
      return FALSE;
   }

   // setup for loops
   char *pc = (char*)mem.p;
   PSRFEATURE psr = (PSRFEATURE)m_pmemSRFEATURE->p;
   DWORD i;

   // decompress voiced frequency wise
   DWORD dwTime, dwLast, dwThis, dwMap;
   for (dwFreq = 0; dwFreq < dwVoiced; dwFreq++) {
      dwLast = -1;
      for (dwTime = 0; dwTime < dwTimeMax; dwTime++) {
         dwThis = ((dwTimeSkip>1) ? min(dwTime*dwTimeSkip, m_dwNumSRFEATURE-1) : dwTime);
         psr = (PSRFEATURE) m_pmemSRFEATURE->p + dwThis;

         // write the value out
         dwMap = adwRemapVoiced[dwFreq];
         psr->acVoiceEnergy[dwMap] = *pc;

         // see if skipped entries
         if ((dwLast != (DWORD)-1) && (dwLast+1 < dwThis)) {
            DWORD dwDelta = dwThis - dwLast;
            for (i = 1; i < dwDelta; i++)
               psr[(int)i - (int)dwDelta].acVoiceEnergy[dwMap] = AmplitudeToDb (
                  DbToAmplitude(psr[-(int)dwDelta].acVoiceEnergy[dwMap]) * (fp)(dwDelta - i) / (fp)dwDelta +
                  DbToAmplitude(*pc) * (fp)i / (fp)dwDelta);
         }

         dwLast = dwThis;
         pc++;
      } // dwTime
   } // dwFreq

   // because decompress unvoiced may not fill in the highest value, do so
   for (dwTime = 0; dwTime < dwTimeMax; dwTime++) {
      dwThis = ((dwTimeSkip>1) ? min(dwTime*dwTimeSkip, m_dwNumSRFEATURE-1) : dwTime);
      psr = (PSRFEATURE) m_pmemSRFEATURE->p + dwThis;
      psr->acNoiseEnergy[SRDATAPOINTS-1] = 111;   // special code
   }
   // decompress unvoiced frequency wise
   for (dwFreq = 0; dwFreq < dwUnvoiced; dwFreq++) {
      dwLast = -1;
      for (dwTime = 0; dwTime < dwTimeMax; dwTime++) {
         dwThis = ((dwTimeSkip>1) ? min(dwTime*dwTimeSkip, m_dwNumSRFEATURE-1) : dwTime);
         psr = (PSRFEATURE) m_pmemSRFEATURE->p + dwThis;

         // write the value out
         dwMap = adwRemapUnvoiced[dwFreq];
         psr->acNoiseEnergy[dwMap] = *pc;

         // see if skipped entries
         if ((dwLast != (DWORD)-1) && (dwLast+1 < dwThis)) {
            DWORD dwDelta = dwThis - dwLast;
            for (i = 1; i < dwDelta; i++)
               psr[(int)i - (int)dwDelta].acNoiseEnergy[dwMap] = AmplitudeToDb (
                  DbToAmplitude(psr[-(int)dwDelta].acNoiseEnergy[dwMap]) * (fp)(dwDelta - i) / (fp)dwDelta +
                  DbToAmplitude(*pc) * (fp)i / (fp)dwDelta);
         }

         dwLast = dwThis;
         pc++;
      } // dwTime
   } // dwFreq

   // check last value
   for (dwTime = 0; dwTime < dwTimeMax; dwTime++) {
      dwThis = ((dwTimeSkip>1) ? min(dwTime*dwTimeSkip, m_dwNumSRFEATURE-1) : dwTime);
      psr = (PSRFEATURE) m_pmemSRFEATURE->p + dwThis;
      if (psr->acNoiseEnergy[SRDATAPOINTS-1] == 111)  // special code
         psr->acNoiseEnergy[SRDATAPOINTS-1] = psr->acNoiseEnergy[SRDATAPOINTS-2];
      else
         break;   // if -111 case didn't get called then never weill
   }

   // decompress phase frequency wise
   psr = (PSRFEATURE) m_pmemSRFEATURE->p;
   for (dwTime = 0; dwTime < m_dwNumSRFEATURE; dwTime++, psr++) {
      // BUGFIX - randomize phase instead of zeroing i
      //memset (psr->abPhase, 0, sizeof(psr->abPhase));
      psr->abPhase[0] = 0; // always

      for (dwFreq = 1; dwFreq < SRPHASENUM; dwFreq++)
         psr->abPhase[dwFreq] = (BYTE)rand();

   } // dwTime
   for (dwFreq = 0; dwFreq < dwFreqMax; dwFreq++) {
      dwLast = -1;
      for (dwTime = 0; dwTime < dwTimePhaseMax; dwTime++) {
         dwThis = ((dwTimePhaseSkip > 1) ? min(dwTime*dwTimePhaseSkip, m_dwNumSRFEATURE-1) : dwTime);
         psr = (PSRFEATURE) m_pmemSRFEATURE->p + dwThis;

         // write the value out
         psr->abPhase[dwFreq] = (BYTE)(*pc);

         // if last+2 == dwThis then skipped an entry, so write that in too
         if ((dwLast != (DWORD)-1) && (dwLast+2 == dwThis)) {
            DWORD dwA = (BYTE) psr[-2].abPhase[dwFreq];  // BUGFIX - was wrong
#if 0 // BUGFIX - DON'T interpolate phase, especially in this way
            DWORD dwA = (BYTE)(*pc);
            DWORD dwB = (BYTE) psr[-2].abPhase[dwFreq];  // BUGFIX - was wrong
            if (max(dwA,dwB) - min(dwA,dwB) >= 128) {
               // flipped a phase, so average
               if (dwA < dwB)
                  dwA += 0x100;
               else
                  dwB += 0x100;
            }
            dwA = (dwA + dwB) / 2;
#endif // 0
            psr[-1].abPhase[dwFreq] = (BYTE)dwA;
         }

         dwLast = dwThis;
         pc++;
      } // dwTime
   } // dwFreq

   // read the pitch and PCM
   PTTSFEATURECOMPEXTRA ptce;
   PTTSFEATURECOMPPCM ptcp;
   dwLast = (DWORD)-1;
   for (dwTime = 0; dwTime < dwTimePhaseMax; dwTime++) {
      dwThis = ((dwTimePhaseSkip > 1) ? min(dwTime*dwTimePhaseSkip, m_dwNumSRFEATURE-1) : dwTime);
      psr = (PSRFEATURE) m_pmemSRFEATURE->p + dwThis;

      // pitch
      ptce = (PTTSFEATURECOMPEXTRA)pc;
      pc += sizeof(*ptce);
      ((PTTSFEATURECOMPEXTRA) m_pmemTTSFEATURECOMPEXTRA->p)[dwThis] = *ptce;

      if (fIncludePCM) {
         // PCM
         ptcp = (PTTSFEATURECOMPPCM)pc;
         pc += sizeof(*ptcp);

         psr->bPCMHarmFadeStart = ptcp->bPCMHarmFadeStart;
         psr->bPCMHarmFadeFull = ptcp->bPCMHarmFadeFull;
         psr->bPCMHarmNyquist = ptcp->bPCMHarmNyquist;
         psr->bPCMFill = ptcp->bPCMFill;
         psr->fPCMScale = ptcp->fPCMScale;
         memcpy (psr->acPCM, ptcp->acPCM, sizeof(psr->acPCM));
      }
      else {
         psr->bPCMFill = psr->bPCMHarmFadeFull = psr->bPCMHarmFadeStart = psr->bPCMHarmNyquist = 0;
         psr->fPCMScale = 0;
         memset (psr->acPCM, 0, sizeof(psr->acPCM));
      }

      // if last+2 == dwThis then skipped an entry, so write that in too
      if ((dwLast != (DWORD)-1) && (dwLast+2 == dwThis)) {
         psr[-1].bPCMHarmFadeStart = psr[-2].bPCMHarmFadeStart;
         psr[-1].bPCMHarmFadeFull = psr[-2].bPCMHarmFadeFull;
         psr[-1].bPCMHarmNyquist = psr[-2].bPCMHarmNyquist;
         psr[-1].bPCMFill = psr[-2].bPCMFill;
         psr[-1].fPCMScale = psr[-2].fPCMScale;
         memcpy (psr[-1].acPCM, psr[-2].acPCM, sizeof(psr[-1].acPCM));

         ((PTTSFEATURECOMPEXTRA) m_pmemTTSFEATURECOMPEXTRA->p)[dwThis-1] = ((PTTSFEATURECOMPEXTRA) m_pmemTTSFEATURECOMPEXTRA->p)[dwThis-2];
      }

      dwLast = dwThis;
   } // dwTime


   // fill in gaps between frequencies
   psr = (PSRFEATURE) m_pmemSRFEATURE->p;
   int iLastValue, iThisValue;
   for (dwTime = 0; dwTime < m_dwNumSRFEATURE; dwTime++, psr++) {
      for (dwVoiced = 0; dwVoiced < 2; dwVoiced++) {
         DWORD *padwMap = dwVoiced ? adwRemapVoiced : adwRemapUnvoiced;
         char *pac = dwVoiced ? psr->acVoiceEnergy : psr->acNoiseEnergy;

         DWORD dwLast = (DWORD)-1, dwCur;
         iLastValue = -100;   // to silence
         for (dwMap = 0; dwMap < SRDATAPOINTS; dwMap++, dwLast = dwCur) {
            dwCur = padwMap[dwMap];
            if (dwCur <= dwLast+1)
               break;   // end of mapping, or already on 1-step so nothing to interpolate

            iThisValue = pac[dwCur];

            switch (dwCur - dwLast) {
            case 2:  // skipped one
               pac[dwCur-1] = AmplitudeToDb ((DbToAmplitude(iLastValue) + DbToAmplitude(iThisValue))/2.0);
               break;
            case 3:  // skipped two
               pac[dwCur-2] = AmplitudeToDb ((DbToAmplitude(iLastValue)*2 + DbToAmplitude(iThisValue))/3.0);
               pac[dwCur-1] = AmplitudeToDb ((DbToAmplitude(iLastValue) + DbToAmplitude(iThisValue)*2)/3.0);
               break;
            case 4:  // skipped three
               pac[dwCur-3] = AmplitudeToDb ((DbToAmplitude(iLastValue)*3 + DbToAmplitude(iThisValue)*1)/4.0);
               pac[dwCur-2] = AmplitudeToDb ((DbToAmplitude(iLastValue)*2 + DbToAmplitude(iThisValue)*2)/4.0);
               pac[dwCur-1] = AmplitudeToDb ((DbToAmplitude(iLastValue)*1 + DbToAmplitude(iThisValue)*3)/4.0);
               break;
            case 5:  // skipped four
               pac[dwCur-4] = AmplitudeToDb ((DbToAmplitude(iLastValue)*4 + DbToAmplitude(iThisValue)*1)/5.0);
               pac[dwCur-3] = AmplitudeToDb ((DbToAmplitude(iLastValue)*3 + DbToAmplitude(iThisValue)*2)/5.0);
               pac[dwCur-2] = AmplitudeToDb ((DbToAmplitude(iLastValue)*2 + DbToAmplitude(iThisValue)*3)/5.0);
               pac[dwCur-1] = AmplitudeToDb ((DbToAmplitude(iLastValue)*1 + DbToAmplitude(iThisValue)*4)/5.0);
               break;
            } // switch

            iLastValue = iThisValue;
         } // dwMap
      } // dwVoiced
   } // dwTime

   return TRUE;
}
#endif // 0 - no longer support


#if 0 // no longer used
/*************************************************************************************
CMTTSTriPhoneAudio::CalcEnergyIfNecessary - If the energy isn't valid,
m_fEnergyIsValid, then calls CalcEnergy()
*/
void CMTTSTriPhoneAudio::CalcEnergyIfNecessary (void)
{
   if (!m_fEnergyIsValid)
      CalcEnergy ();
}
#endif


#if 0 // no longer used
/*************************************************************************************
CMTTSTriPhoneAudio::CalcEnergy - Calculates the energy levels for the 1st and last
SR features so that when they're abutted against one another don't have any problems.
*/
void CMTTSTriPhoneAudio::CalcEnergy (void)
{
   if (!m_dwNumSRFEATURE || !Decompress()) {
      m_fEnergyStart = m_fEnergyEnd = 0;
      m_fEnergyIsValid = TRUE;
      return;
   }

   PSRFEATURE psr = (PSRFEATURE) m_pmemSRFEATURE->p;
   m_fEnergyStart = SRFEATUREEnergy (FALSE, psr);
   m_fEnergyEnd = SRFEATUREEnergy(FALSE, psr + (m_dwNumSRFEATURE-1));
   m_fEnergyIsValid = TRUE;

   // recompress the data
   Compress ();
}
#endif // 0

// WAVESEGMML - For MMLTo/From
typedef struct {
   DWORD             dwFeatureStart;   // start feature
   DWORD             dwFeatureEnd;     // end feature (exclusive)
   DWORD             dwSamplesPerSec;  // sampling rate
   WORD              wFlags;        // flags, TPMML_XXX
   WORD              wSRSkip;          // samples per SRFeature
} WAVESEGMML, *PWAVESEGMML;

// TPMML - For MMLTo/From.
typedef struct {
   DWORD             dwWord;      // word number this is specific to, or -1 if word independent
   float             fEnergyAvg;    // average energy for the unit, after some adjustment so that max energy in wave is PHONESAMPLENORMALIZED
   float             fOrigPitch;    // original pitch for the unit
   float             fPitchDelta;   // ratio of pitch on right of phoneme to pitch on left
   float             fPitchBulge;   // pitch bulge in center. ratio. 2 = octave above, 1 = no change, 1/2 = octave below
   float             fPitchLeft;    // left pitch, in hz, 1/6 of way through
   float             fPitchCenter;    // Center pitch, in hz, 3/6 of way through
   float             fPitchRight;    // Right pitch, in hz, 5/6 of way through
   float             fCenterEnergy; // energy of this, used for continuity
   float             fLeftEnergy;   // left unit energy, 0 if silence
   float             fLeftPitch;    // left unit pitch, 0 if silence
   DWORD             dwLeftDuration;   // left duration in SRFEATUREs, 0 if silence
   // WORD              wDuration;   // typical duration, in SRFEATURE units
   short             iPitch;      // pitch increase/decraase. 0=no change, 1000=1 octave higher, -1000=1 octave lower, etc.
   short             iPitchDelta;   // change in pitch over phoneme, same scale as iPitch
   short             iPitchBulge;   // bulge in pitch. Same scale as iPitch
   BYTE              abPhoneContiguous[8]; // array of 8 phonemes that immediately follow this one. Phone numbers
                                    // are +1 from unsort-phone number. phoneme 0 is blank (or end of list)
   BYTE              bPhoneLeft;    // phoneme to left
   BYTE              bPhoneRight;   // phoneme to right
   WORD              wWordPos;    // position within word, 0=middle, 1=start, 2=end, 4=start&end
   BYTE              abRank[TTSDEMIPHONES];         // rank, from 0..100, 0 = best sounding
   MISMATCHINFO      aMMISpecific[TRIPHONESPECIFICMISMATCH]; // scores to use if mismatch
   WORD              wMismatchAccuracy;  // how accurate the mismatch is
//   WORD              wElem;         // number of elements
//   WORD              wFlags;        // flags, TPMML_XXX
   WORD              wOrigWave;     // original wave this was in, so can keep adjacent units
   WORD              wOrigPhone;    // original phone index this was in, so can keep adhance units
   WORD              wFeatureStart; // starting feature of wave
   WORD              wFeatureEnd;   // ending feature of wave
   short             iFeatureAdd;   // dB to add to feature to normalize
   WORD              wTrimLeft;     // number of SRFEATURE units can trim left if unit all alone
   WORD              wTrimRight;    // number of SRFEATURE units can trim right if unit all alone
   WORD              wFuncWordGroup;   // function word classification 0..NUMFUNCWORDGROUP(inclusive)
//   SRFEATURESMALL    aSRFeatBoundary[(TTSDEMIPHONES+1)*2];   // SR features on the boundary. [0] = SR feat immediately before phone begins,
//   float             afSRFeatBoundary[(TTSDEMIPHONES+1)*2];   // energy before normalization of each of the boundaries
            // BUGFIX - Both of these values harcoded to 4! Should be (TTSDEMIPHONES+1)*2
   // followed by compressed data
} TPMML, *PTPMML;

/*************************************************************************************
CMTTSTriPhoneAudio::MMLToBinary - Like MMLTo, except this fills in a binary buffer
with information.

inputs
   PCMem       pmem - Memory to write to. Start at m_dwCurPosn and add on. Should
                     update m_dwCurPosn in the process
returns
   DWORD - Size of memory added, or 0 if error
*/
size_t CMTTSTriPhoneAudio::MMLToBinary (PCMem pmem)
{
   // make sure it's compressed
//   if (!Compress())
//      return FALSE;

   size_t dwNeed = sizeof(TPMML); // + m_dwKeepMemorySize; // m_memCompressed.m_dwCurPosn;
   if (!pmem->Required (pmem->m_dwCurPosn + dwNeed))
      return 0;
   PTPMML ptp = (PTPMML) ((PBYTE)pmem->p + pmem->m_dwCurPosn);
   PVOID psr = (PSRFEATURE) (ptp+1);
   pmem->m_dwCurPosn += dwNeed;

   memset (ptp, 0, sizeof(*ptp));
   ptp->dwWord = m_dwWord;
   //ptp->iPitch = m_iPitch;
   //ptp->iPitchDelta = m_iPitchDelta;
   ptp->fOrigPitch = m_fOrigPitch;
   ptp->wFuncWordGroup = (WORD) m_dwFuncWordGroup;
   ptp->fEnergyAvg = m_fEnergyAvg;
   ptp->fPitchDelta = m_fPitchDelta;
   ptp->fPitchBulge = m_fPitchBulge;
   ptp->fPitchLeft = m_fPitchLeft;
   ptp->fPitchCenter = m_fPitchCenter;
   ptp->fPitchRight = m_fPitchRight;
   ptp->fCenterEnergy = m_fCenterEnergy;
   ptp->fLeftEnergy = m_fLeftEnergy;
   ptp->fLeftPitch = m_fLeftPitch;
   ptp->dwLeftDuration = m_dwLeftDuration;
   // ptp->wDuration = m_wDuration;
   memcpy (ptp->abPhoneContiguous, m_abPhoneContiguous, sizeof(m_abPhoneContiguous));
   ptp->bPhoneLeft = m_bPhoneLeft;
   ptp->bPhoneRight = m_bPhoneRight;
   memcpy (ptp->abRank, m_abRank, sizeof(m_abRank));
   memcpy (ptp->aMMISpecific, m_aMMISpecific, sizeof(m_aMMISpecific));
   ptp->wMismatchAccuracy = (WORD) m_dwMismatchAccuracy;
   ptp->wWordPos = m_wWordPos;
   ptp->wFeatureStart = (WORD)m_dwFeatureStart;
   ptp->wFeatureEnd = (WORD)m_dwFeatureEnd;
   ptp->iFeatureAdd = (short)m_iFeatureAdd;
//   ptp->wElem = (WORD) m_dwNumSRFEATURE;
//   ptp->wFlags = m_wFlags;
   ptp->wOrigWave = m_wOrigWave;
   ptp->wOrigPhone = m_wOrigPhone;
   ptp->wTrimLeft = (WORD)m_dwTrimLeft;
   ptp->wTrimRight = (WORD)m_dwTrimRight;
//   memcpy (ptp->aSRFeatBoundary, m_aSRFeatBoundary, sizeof(m_aSRFeatBoundary));
//   memcpy (ptp->afSRFeatBoundary, m_afSRFeatBoundary, sizeof(m_afSRFeatBoundary));

//   memcpy (psr, m_pKeepMemoryCompressed /*m_memCompressed.p*/, m_dwKeepMemorySize /*m_memCompressed.m_dwCurPosn*/);
   
   return dwNeed;
}

/*************************************************************************************
CMTTSTriPhoneAudio::MMLFromBinary - Reads triphone information from binary memory.

inputs
   PVOID             pvMem - Memory to read from
   DWORD             dwSize - Number of bytes. This is the same value as returned from MMLToBinary()
   PCMLexicon        pLexicon - Lexicon to use for triphones
//   BOOL              fKeepMemory - If TRUE, can keep memory pointed to by pvMem. If FALSE, allocate new
returns
   BOOL - TRUE if success
*/
BOOL CMTTSTriPhoneAudio::MMLFromBinary (PVOID pMem, DWORD dwSize, PCMLexicon pLexicon)
{
//    m_fEnergyIsValid = FALSE;
   // delete existing SR feature
//   if (m_pmemSRFEATURE) {
//      delete m_pmemSRFEATURE;
//      m_pmemSRFEATURE = NULL;
//   }
//   if (m_pmemTTSFEATURECOMPEXTRA) {
//      delete m_pmemTTSFEATURECOMPEXTRA;
//      m_pmemTTSFEATURECOMPEXTRA = NULL;
//   }

   PTPMML ptp = (PTPMML) pMem;
//   PVOID psr = (PSRFEATURE) (ptp+1);

   m_fReviewed = FALSE;

   m_dwWord = ptp->dwWord;
   //m_wDuration = ptp->wDuration;
   //m_iPitch = ptp->iPitch;
   //m_iPitchDelta = ptp->iPitchDelta;
   m_fOrigPitch = ptp->fOrigPitch;
   m_dwFuncWordGroup = ptp->wFuncWordGroup;
   m_fEnergyAvg = ptp->fEnergyAvg;
   m_fPitchDelta = ptp->fPitchDelta;
   m_fPitchBulge = ptp->fPitchBulge;
   m_fPitchLeft = ptp->fPitchLeft;
   m_fPitchCenter = ptp->fPitchCenter;
   m_fPitchRight = ptp->fPitchRight;
   m_fCenterEnergy = ptp->fCenterEnergy;
   m_fLeftEnergy = ptp->fLeftEnergy;
   m_fLeftPitch = ptp->fLeftPitch;
   m_dwLeftDuration = ptp->dwLeftDuration;
   memcpy (m_abPhoneContiguous, ptp->abPhoneContiguous, sizeof(m_abPhoneContiguous));
   m_bPhoneLeft = ptp->bPhoneLeft;
   m_bPhoneRight = ptp->bPhoneRight;
   memcpy (m_abRank, ptp->abRank, sizeof(m_abRank));
   memcpy (m_aMMISpecific, ptp->aMMISpecific, sizeof(m_aMMISpecific));
   m_dwMismatchAccuracy = ptp->wMismatchAccuracy;
   m_wWordPos = ptp->wWordPos;
   m_dwFeatureStart = ptp->wFeatureStart;
   m_dwFeatureEnd = ptp->wFeatureEnd;
   m_iFeatureAdd = ptp->iFeatureAdd;
//   m_dwNumSRFEATURE = ptp->wElem;
//   m_wFlags = ptp->wFlags;
   m_wOrigWave = ptp->wOrigWave;
   m_wOrigPhone = ptp->wOrigPhone;
   m_dwTrimLeft = ptp->wTrimLeft;
   m_dwTrimRight = ptp->wTrimRight;
//   memcpy (m_aSRFeatBoundary, ptp->aSRFeatBoundary, sizeof(m_aSRFeatBoundary));
//   memcpy (m_afSRFeatBoundary, ptp->afSRFeatBoundary, sizeof(m_afSRFeatBoundary));


   CalcInfo (pLexicon);

   // copy over remaining
   dwSize -= sizeof(*ptp);

//   m_fKeepMemory = fKeepMemory;
//   m_dwKeepMemorySize = dwSize;
//   if (fKeepMemory)
//      m_pKeepMemoryCompressed = psr;
//   else {
//      if (!m_memCompressed.Required (dwSize))
//         return FALSE;
//      memcpy (m_memCompressed.p, psr, dwSize);
//      m_memCompressed.m_dwCurPosn = dwSize;
//
//      m_pKeepMemoryCompressed = m_memCompressed.p;
//   }

   // BUGFIX - no longer call CalcEnergy() here because slow loading
   //CalcEnergy();
   return TRUE;
}

/*************************************************************************************
CMTTSTriPhoneAudio::CalcInfo - Calculates some of the calculated variables
in the object
*/
void CMTTSTriPhoneAudio::CalcInfo (PCMLexicon pLexicon)
{
   DWORD j;
   for (j = 0; j < NUMTRIPHONEGROUP; j++)
      m_awTriPhone[j] = PhoneToTriPhoneNumber (m_bPhoneLeft, m_bPhoneRight, pLexicon, j);

   // BUGFIX - Use m_fPitchLeft, m_fPitchCenter, and m_fPitchRight
   m_iPitchLeft = log((fp)(m_fPitchLeft / SRBASEPITCH)) / log((fp)2) * 1000.0;
   m_iPitchCenter = log((fp)(m_fPitchCenter / SRBASEPITCH)) / log((fp)2) * 1000.0;
   m_iPitchRight = log((fp)(m_fPitchRight / SRBASEPITCH)) / log((fp)2) * 1000.0;

#if 0 // old code
   // convert the pitches
   fp fDelta = sqrt (m_fPitchDelta);
   fp fLeft = m_fOrigPitch / fDelta;
   fp fRight = m_fOrigPitch * fDelta;
   m_iPitchLeft = log((fp)(fLeft / SRBASEPITCH)) / log((fp)2) * 1000.0;
   m_iPitchRight = log((fp)(fRight / SRBASEPITCH)) / log((fp)2) * 1000.0;
   
   // center pitch
   fp fCenter = m_fOrigPitch * m_fPitchBulge;
   m_iPitchCenter = log((fp)(fCenter / SRBASEPITCH)) / log((fp)2) * 1000.0;

   // NOTE; Since was dealing with average, need to counterweight left/right upwards
   int iCenter = (int)(log(m_fPitchBulge) / log((fp)2) * 1000.0) / 2;
   m_iPitchLeft -= iCenter;
   m_iPitchRight -= iCenter;
#endif
}














/*************************************************************************************
CMTTSTriPhonePros::Constructor and destructor
*/
CMTTSTriPhonePros::CMTTSTriPhonePros (void)
{
   m_bPhoneLeft = m_bPhoneRight = 0;
   m_wWordPos = m_wDuration = 0;
   m_iPitch = m_iPitchDelta = m_iPitchBulge = 0;
   m_fEnergyAvg = 0;
   m_fCached = FALSE;
}

CMTTSTriPhonePros::~CMTTSTriPhonePros (void)
{
   // do nothing
}


/*************************************************************************************
CMTTSTriPhonePros::MemoryTouch - Use to make sure TTS stays in memory
*/
DWORD CMTTSTriPhonePros::MemoryTouch (void)
{
   return m_wDuration;  // since no sub-memory
}

/*************************************************************************************
CMTTSTriPhonePros::Clone - Standard clone
*/
CMTTSTriPhonePros *CMTTSTriPhonePros::Clone (void)
{
   PCMTTSTriPhonePros pNew = new CMTTSTriPhonePros;
   if (!pNew)
      return NULL;

   pNew->m_bPhoneLeft = m_bPhoneLeft;
   pNew->m_bPhoneRight = m_bPhoneRight;
   pNew->m_wDuration = m_wDuration;
   pNew->m_wWordPos = m_wWordPos;
   pNew->m_iPitch = m_iPitch;
   pNew->m_iPitchDelta = m_iPitchDelta;
   pNew->m_iPitchBulge = m_iPitchBulge;
   pNew->m_fEnergyAvg = m_fEnergyAvg;
   memcpy (pNew->m_awTriPhone, m_awTriPhone, sizeof(m_awTriPhone));


   return pNew;
}


// TPMMLPROS - For MMLTo/From.

typedef struct {
   WORD              wDuration;   // typical duration, in SRFEATURE units
   short             iPitch;      // pitch increase/decraase. 0=no change, 1000=1 octave higher, -1000=1 octave lower, etc.
   short             iPitchDelta;   // change in pitch over phoneme, same scale as iPitch
   short             iPitchBulge;   // bulge in pitch at center. Same scale as iPitch
   BYTE              bPhoneLeft;    // phoneme to left
   BYTE              bPhoneRight;   // phoneme to right
   WORD              wWordPos;    // position within word, 0=middle, 1=start, 2=end, 4=start&end
   float             fEnergyAvg;    // average energy
} TPMMLPROS, *PTPMMLPROS;

/*************************************************************************************
CMTTSTriPhonePros::MMLToBinary - Like MMLTo, except this fills in a binary buffer
with information.

inputs
   PCMem       pmem - Memory to write to. Start at m_dwCurPosn and add on. Should
                     update m_dwCurPosn in the process
returns
   DWORD - Size of memory added, or 0 if error
*/
DWORD CMTTSTriPhonePros::MMLToBinary (PCMem pmem)
{
   DWORD dwNeed = sizeof(TPMMLPROS);
   if (!pmem->Required (pmem->m_dwCurPosn + dwNeed))
      return 0;
   PTPMMLPROS ptp = (PTPMMLPROS) ((PBYTE)pmem->p + pmem->m_dwCurPosn);
   PVOID psr = (PSRFEATURE) (ptp+1);
   pmem->m_dwCurPosn += dwNeed;

   memset (ptp, 0, sizeof(*ptp));
   ptp->iPitch = m_iPitch;
   ptp->iPitchDelta = m_iPitchDelta;
   ptp->iPitchBulge = m_iPitchBulge;
   ptp->fEnergyAvg = m_fEnergyAvg;
   ptp->wDuration = m_wDuration;
   ptp->bPhoneLeft = m_bPhoneLeft;
   ptp->bPhoneRight = m_bPhoneRight;
   ptp->wWordPos = m_wWordPos;
   
   return dwNeed;
}

/*************************************************************************************
CMTTSTriPhonePros::MMLFromBinary - Reads triphone information from binary memory.

inputs
   PVOID             pvMem - Memory to read from
   DWORD             dwSize - Number of bytes. This is the same value as returned from MMLToBinary()
   PCMLexicon        pLexicon - Lexicon to use for triphones
returns
   BOOL - TRUE if success
*/
BOOL CMTTSTriPhonePros::MMLFromBinary (PVOID pMem, DWORD dwSize, PCMLexicon pLexicon)
{
   PTPMMLPROS ptp = (PTPMMLPROS) pMem;
   PVOID psr = (PSRFEATURE) (ptp+1);

   m_wDuration = ptp->wDuration;
   m_iPitch = ptp->iPitch;
   m_iPitchDelta = ptp->iPitchDelta;
   m_iPitchBulge = ptp->iPitchBulge;
   m_fEnergyAvg = ptp->fEnergyAvg;
   m_bPhoneLeft = ptp->bPhoneLeft;
   m_bPhoneRight = ptp->bPhoneRight;

   CalcInfo(pLexicon);

   return TRUE;
}


/*************************************************************************************
CMTTSTriPhonePros::CalcInfo - Calculates some of the calculated variables
in the object
*/
void CMTTSTriPhonePros::CalcInfo (PCMLexicon pLexicon)
{
   DWORD j;
   for (j = 0; j < NUMTRIPHONEGROUP; j++)
      m_awTriPhone[j] = PhoneToTriPhoneNumber (m_bPhoneLeft, m_bPhoneRight, pLexicon, j);
}








/*************************************************************************************
CMTTS::Construcotr and destructor
*/
CMTTS::CMTTS (void)
{
   m_dwRefCount = 0;
   m_szFile[0] = 0;
   m_dwTriPhoneGroup = 0;
   m_fKeepLog = FALSE;
   m_fFullPCM = FALSE;
   m_fAvgPitch = 100;   // BUGFIX - set to 100 so have something
   m_dwUnits = 0;
   m_fPauseLessOften = FALSE;
   m_dwWordsPerMinute = 100;  // BUGFIX - Set to 100 so have something
   m_fAvgSyllableDur = 100;   // so have something
   m_pLexTrainingWords = new CMLexicon;
   m_pLexWords = new CMLexicon;

#if 0 // old prosody
   m_pLexFuncWords = new CMLexicon;
   m_lPCTTSPunctPros.Init (sizeof(PCTTSPunctPros));
#endif // 0


   DWORD i, j;
#if 0 // old prosody
   m_pPunctAccentuate.Copy (&m_pPOSAccentuate);

   memset (m_apLexWordEmph, 0, sizeof(m_apLexWordEmph));
   for (i = 0; i < NUMLEXWORDEMPH+1; i++) {
      m_apLexWordEmphScale[i].Zero();
      m_apLexWordEmphScale[i].p[0] = 1;
      m_apLexWordEmphScale[i].p[1] = 1;
      m_apLexWordEmphScale[i].p[2] = 1;
   }
   for (i = 0; i < NUMPROSWORDLENGTH; i++) {
      m_apProsWordEmphFromWordLength[i].Zero();
      m_apProsWordEmphFromWordLength[i].p[0] = 1;
      m_apProsWordEmphFromWordLength[i].p[1] = 1;
      m_apProsWordEmphFromWordLength[i].p[2] = 1;
   }
#endif // 0
   for (i = 0; i < NUMPHONEEMPH*2; i++) for (j = 0; j < PHONEPOSBIN; j++) {
      m_apPhoneEmph[i][j].Zero();
      m_apPhoneEmph[i][j].p[0] = 1;
      m_apPhoneEmph[i][j].p[1] = 1;
      m_apPhoneEmph[i][j].p[2] = 1;
   }

   m_pCTTSProsody = new CTTSProsody;

   m_szLexicon[0] = 0;
   m_palPCMTTSTriPhoneAudio = NULL;
   m_palPCMTTSTriPhonePros = NULL;
   // m_pamemTriPhoneAudio = NULL;
   m_papObjectCachePCMTTSTriPhoneAudio = NULL;
   m_papObjectCachePCMTTSTriPhonePros = NULL;
   m_dwNumPhone = 0;
   m_pLexMain = NULL;
   m_lPCTTSWave.Init (sizeof(PCTTSWave));
   m_lPCPhaseModel.Init (sizeof(PCPhaseModel));

   m_fIsDerived = FALSE;
   m_szTTSMaster[0] = 0;
   m_pTTSMaster = NULL;

   memset (m_apLexFuncWord, 0, sizeof(m_apLexFuncWord));

   for (i = 0; i < NUMPROSODYTTS; i++)
      m_aszProsodyTTS[i][0] = 0;

   m_lPCMTTSSubVoice.Init (sizeof(PCMTTSSubVoice));

   InitializeCriticalSection (&m_csSynthBeamSearch);

   // clrea thread info
   InitializeCriticalSection (&m_csTTSWaveDecompress);
   for (i = 0; i < MAXRAYTHREAD; i++)
      InitializeCriticalSection (&m_acsTTSWave[i]);
   m_dwTTSWaveAnalyzing = 0;
   m_fTTSWaveCalcSRANALBLOCKWantToQuit = FALSE;
   m_fTTSWaveDisableCompress = FALSE;
   memset (m_aThreadWaveCalcInfo, 0, sizeof(m_aThreadWaveCalcInfo));
}

CMTTS::~CMTTS (void)
{
   // free up threads
   m_fTTSWaveCalcSRANALBLOCKWantToQuit = TRUE;
   DWORD i;
   for (i = 0; i < MAXRAYTHREAD; i++) {
      if (!m_aThreadWaveCalcInfo[i].hThread)
         continue;
      WaitForSingleObject (m_aThreadWaveCalcInfo[i].hThread, INFINITE);
      CloseHandle (m_aThreadWaveCalcInfo[i].hThread);
      m_aThreadWaveCalcInfo[i].hThread = NULL;
   }

   for (i = 0; i < MAXRAYTHREAD; i++)
      DeleteCriticalSection (&m_acsTTSWave[i]);
   DeleteCriticalSection (&m_csTTSWaveDecompress);

   DeleteCriticalSection (&m_csSynthBeamSearch);

   // free master
   if (m_pTTSMaster)
      TTSCacheClose (m_pTTSMaster);
   m_pTTSMaster = NULL;

   if (m_pLexTrainingWords)
      delete m_pLexTrainingWords;
   m_pLexTrainingWords = NULL;

   if (m_pLexWords)
      delete m_pLexWords;
   m_pLexWords = NULL;

   if (m_pLexMain)
      MLexiconCacheClose (m_pLexMain);
   m_pLexMain = NULL;

   FreeUnits();

   m_dwNumPhone = 0;

   for (i = 0; i < NUMFUNCWORDGROUP; i++) {
      if (m_apLexFuncWord[i])
         delete m_apLexFuncWord[i];
      m_apLexFuncWord[i] = NULL;
   }

#if 0 // old prosody
   if (m_pLexFuncWords)
      delete m_pLexFuncWords;
   m_pLexFuncWords = NULL;

   for (i = 0; i < NUMLEXWORDEMPH; i++) {
      if (m_apLexWordEmph[i])
         delete m_apLexWordEmph[i];
      m_apLexWordEmph[i] = NULL;
   }

   // delete punctionan prosody
   PCTTSPunctPros *ppp = (PCTTSPunctPros*)m_lPCTTSPunctPros.Get(0);
   for (i = 0; i < m_lPCTTSPunctPros.Num(); i++)
      if (ppp[i])
         delete ppp[i];
   m_lPCTTSPunctPros.Clear();
#endif // 0

   if (m_pCTTSProsody)
      delete m_pCTTSProsody;

   // free up sub-voices
   PCMTTSSubVoice *ppsv = (PCMTTSSubVoice*) m_lPCMTTSSubVoice.Get(0);
   for (i = 0; i < m_lPCMTTSSubVoice.Num(); i++)
      delete ppsv[i];
   m_lPCMTTSSubVoice.Clear();
}



/*************************************************************************************
CMTTS::PhaseModelGet - Given a phoneme, get the phase model for it.

inputs
   DWORD          dwPhoneme - Unsorted phoneme number
   BOOL           fCreateIfNotExist - If TRUE, then create if this doesn't exist
returns
   PCPhaseModel - Phase model
*/
PCPhaseModel CMTTS::PhaseModelGet (DWORD dwPhoneme, BOOL fCreateIfNotExist)
{
   // BUGFIX - disable phase models since not as good as psola, and use more memory
   // to use phases than old phase writeup.
   return NULL;

   PCPhaseModel *pppm = (PCPhaseModel*)m_lPCPhaseModel.Get(dwPhoneme);
   if (pppm)
      return pppm[0];
   
   // if don't want to create then exit where
   if (!fCreateIfNotExist)
      return NULL;

   while (dwPhoneme >= m_lPCPhaseModel.Num()) {
      PCPhaseModel pNew = new CPhaseModel;
      if (!pNew)
         return NULL;   // eror, shouldnt happen
      m_lPCPhaseModel.Add (&pNew);
   }

   pppm = (PCPhaseModel*)m_lPCPhaseModel.Get(dwPhoneme);
   return pppm[0];
}


/*************************************************************************************
CMTTS::FillInTriPhoneIndex - Loops through all the m_palPCMTTSTriPhoneAudio and
fills in m_wPhone and m_wTriPhoneIndex
*/
void CMTTS::FillInTriPhoneIndex (void)
{
   DWORD dwPhone, dwIndex;
   DWORD dwUniqueID = 0;
   for (dwPhone = 0; dwPhone < m_dwNumPhone; dwPhone++) {
      PCListFixed pl = m_palPCMTTSTriPhoneAudio ? m_palPCMTTSTriPhoneAudio[dwPhone] : NULL;
      if (!pl)
         continue;

      PCMTTSTriPhoneAudio *pptp = (PCMTTSTriPhoneAudio*)pl->Get(0);
      for (dwIndex = 0; dwIndex < pl->Num(); dwIndex++, pptp++) {
         pptp[0]->m_dwUniqueID = dwUniqueID++;
         //pptp[0]->m_wPhone = (WORD)dwPhone;
         //pptp[0]->m_wTriPhoneIndex = (WORD)dwIndex;
      }
   } // dwPhone

}

/*************************************************************************************
CMTTS::MemoryTouch - Randomly touches some memory in the TTS engine.
Call this once a second to ensure that TTS isn't cached out.
*/
DWORD CMTTS::MemoryTouch (void)
{
   // return a value so that C++ optimizer doesn't eliminate this code entirely
   DWORD dwRet = 0;

   // target costs
   DWORD dwIndex, dwIndex2;
   if (m_memTTSTARGETCOSTS.m_dwCurPosn / sizeof(DWORD)) {
      dwIndex = ((DWORD)rand() * 1000) % (DWORD)(m_memTTSTARGETCOSTS.m_dwCurPosn / sizeof(DWORD));
      dwRet += ((DWORD*)m_memTTSTARGETCOSTS.p)[dwIndex];
   }

   dwIndex = rand() % NUMFUNCWORDGROUP;
   if (m_apLexFuncWord[dwIndex])
      dwRet += m_apLexFuncWord[dwIndex]->MemoryTouch();

   if (m_dwNumPhone) {
      dwIndex = rand() % m_dwNumPhone;

      // triphone audio
      PCListFixed pl = m_palPCMTTSTriPhoneAudio ? m_palPCMTTSTriPhoneAudio[dwIndex] : NULL;
      if (pl) {
         dwIndex2 = rand() % pl->Num();
         PCMTTSTriPhoneAudio *pptp = (PCMTTSTriPhoneAudio*)pl->Get(dwIndex2);
         if (pptp)
            dwRet += pptp[0]->MemoryTouch();
      }

      // triphone prosody
      pl = m_palPCMTTSTriPhonePros ? m_palPCMTTSTriPhonePros[dwIndex] : NULL;
      if (pl) {
         dwIndex2 = rand() % pl->Num();
         PCMTTSTriPhonePros *pptp = (PCMTTSTriPhonePros*)pl->Get(dwIndex2);
         if (pptp)
            dwRet += pptp[0]->MemoryTouch();
      }
   }

   // touch the wave
   if (m_lPCTTSWave.Num()) {
      dwIndex = rand() % m_lPCTTSWave.Num();
      PCTTSWave *ppTW = (PCTTSWave*) m_lPCTTSWave.Get(dwIndex);
      if (ppTW && ppTW[0]) {
         EnterCriticalSection (&m_acsTTSWave[dwIndex % MAXRAYTHREAD]);
         dwRet += ppTW[0]->MemoryTouch();
         LeaveCriticalSection (&m_acsTTSWave[dwIndex % MAXRAYTHREAD]);
      }
   }

   // NOTE: Don't worry about touching m_lPCPhaseModel because they're small

   // touch a few more lexicons
   if (m_pLexTrainingWords)
      dwRet += m_pLexTrainingWords->MemoryTouch();
   if (m_pLexWords)
      dwRet += m_pLexWords->MemoryTouch();
   if (m_pLexMain)
      dwRet += m_pLexMain->MemoryTouch();

   // prosody
   if (m_pCTTSProsody)
      dwRet += m_pCTTSProsody->MemoryTouch();

   // master
   if (m_pTTSMaster)
      dwRet += m_pTTSMaster->MemoryTouch();

   return dwRet;
}

/*************************************************************************************
CMTTS::FreeUnits - Frees the memory allocated for the units
*/
void CMTTS::FreeUnits (void)
{

   // free up the wave memory
   DWORD i,j;
   PCTTSWave *ppTW = (PCTTSWave*) m_lPCTTSWave.Get(0);
   for (i = 0; i < m_lPCTTSWave.Num(); i++)
      if (ppTW[i])
         delete ppTW[i];
   m_lPCTTSWave.Clear();

   // free up triphones
   for (i = 0; i < m_dwNumPhone; i++) {
      PCListFixed pl = m_palPCMTTSTriPhoneAudio ? m_palPCMTTSTriPhoneAudio[i] : NULL;
      if (!pl)
         continue;

      PCMTTSTriPhoneAudio *pptp = (PCMTTSTriPhoneAudio*)pl->Get(0);
      for (j = 0; j < pl->Num(); j++)
         if (!pptp[j]->m_fCached)
            delete pptp[j];

      delete pl;
   } // i

   PCPhaseModel *pppm = (PCPhaseModel*)m_lPCPhaseModel.Get(0);
   for (i = 0; i < m_lPCPhaseModel.Num(); i++) {
      if (pppm[i])
         delete pppm[i];
   } // i
   m_lPCPhaseModel.Clear();

   // free up triphonem memory
//   if (m_pamemTriPhoneAudio) for (i = 0; i < m_dwNumPhone; i++)
//      if (m_pamemTriPhoneAudio[i])
//         delete m_pamemTriPhoneAudio[i];

   if (m_papObjectCachePCMTTSTriPhoneAudio) for (i = 0; i < m_dwNumPhone; i++)
      if (m_papObjectCachePCMTTSTriPhoneAudio[i])
         delete [] m_papObjectCachePCMTTSTriPhoneAudio[i];

   for (i = 0; i < m_dwNumPhone; i++) {
      PCListFixed pl = m_palPCMTTSTriPhonePros ? m_palPCMTTSTriPhonePros[i] : NULL;
      if (!pl)
         continue;

      PCMTTSTriPhonePros *pptp = (PCMTTSTriPhonePros*)pl->Get(0);
      for (j = 0; j < pl->Num(); j++)
         if (!pptp[j]->m_fCached)
            delete pptp[j];

      delete pl;
   } // i

   if (m_papObjectCachePCMTTSTriPhonePros) for (i = 0; i < m_dwNumPhone; i++)
      if (m_papObjectCachePCMTTSTriPhonePros[i])
         delete [] m_papObjectCachePCMTTSTriPhonePros[i];

   m_palPCMTTSTriPhoneAudio = NULL;
   m_palPCMTTSTriPhonePros = NULL;
//   m_pamemTriPhoneAudio = NULL;
   m_papObjectCachePCMTTSTriPhoneAudio = NULL;
   m_papObjectCachePCMTTSTriPhonePros = NULL;

   m_dwNumPhone = 0;
}


/*************************************************************************************
CMTTS::MakeSureEnoughPhone - This internal function makes sure that  m_palPCMTTSTriPhoneAudio & Pros
contains memory allocated for the number of phonemes.

inputs
   DWORD          dwNum - Number of phonemes needed. If -1 then use m_dwNumPhone and initialize
returns
   BOOL - TRUE if sueccess, FALSE if error
*/
BOOL CMTTS::MakeSureEnoughPhone (DWORD dwNum)
{
   DWORD dwOldNumPhone;
   if (dwNum == (DWORD)-1) {
      dwNum = m_dwNumPhone-1;
      dwOldNumPhone = 0;
   }
   else {
      if (dwNum < m_dwNumPhone)
         return TRUE;
      dwOldNumPhone = m_dwNumPhone;
   }

   // BUGFIX - make sure plenty of slots for phonemes
   PCMLexicon pLex = Lexicon();
   if (pLex)
      dwNum = max(dwNum, pLex->PhonemeNum());

   DWORD dwNewNumPhone = dwNum+1;

   // need to allocate more
   if (!m_memTriPhoneAudio.Required (dwNewNumPhone * sizeof(PCListFixed)))
      return FALSE;
   m_palPCMTTSTriPhoneAudio = (PCListFixed*) m_memTriPhoneAudio.p;
   memset (m_palPCMTTSTriPhoneAudio + dwOldNumPhone, 0, (dwNewNumPhone - dwOldNumPhone)*sizeof(PCListFixed*));

   // allocate for memory
//   if (!m_memTriPhoneAudioMem.Required (dwNewNumPhone * sizeof(PCMem)))
//      return FALSE;
//   m_pamemTriPhoneAudio = (PCMem*) m_memTriPhoneAudioMem.p;
//   memset (m_pamemTriPhoneAudio + dwOldNumPhone, 0, (dwNewNumPhone - dwOldNumPhone)*sizeof(PCMem));

   // need to allocate more
   if (!m_memTriPhonePros.Required (dwNewNumPhone * sizeof(PCListFixed)))
      return FALSE;
   m_palPCMTTSTriPhonePros = (PCListFixed*) m_memTriPhonePros.p;
   memset (m_palPCMTTSTriPhonePros + dwOldNumPhone, 0, (dwNewNumPhone - dwOldNumPhone)*sizeof(PCListFixed*));

   // allocate for object caches
   if (!m_memObjectCachePCMTTSTriPhonePros.Required (dwNewNumPhone * sizeof(PCMTTSTriPhonePros)))
      return FALSE;
   m_papObjectCachePCMTTSTriPhonePros = (PCMTTSTriPhonePros*)m_memObjectCachePCMTTSTriPhonePros.p;
   memset (m_papObjectCachePCMTTSTriPhonePros + dwOldNumPhone, 0, (dwNewNumPhone - dwOldNumPhone)*sizeof(PCMTTSTriPhonePros*));

   // allocate for object caches
   if (!m_memObjectCachePCMTTSTriPhoneAudio.Required (dwNewNumPhone * sizeof(PCMTTSTriPhoneAudio)))
      return FALSE;
   m_papObjectCachePCMTTSTriPhoneAudio = (PCMTTSTriPhoneAudio*)m_memObjectCachePCMTTSTriPhoneAudio.p;
   memset (m_papObjectCachePCMTTSTriPhoneAudio + dwOldNumPhone, 0, (dwNewNumPhone - dwOldNumPhone)*sizeof(PCMTTSTriPhoneAudio*));

   m_dwNumPhone = dwNewNumPhone;
   return TRUE;
}

/*************************************************************************************
CMTTS::Clone - Standard api
*/
CMTTS *CMTTS::Clone (void)
{
   PCMTTS pNew = new CMTTS;
   if (!pNew)
      return NULL;

   if (pNew->m_pLexMain)
      MLexiconCacheClose (pNew->m_pLexMain); // BUGFIX - forgot to put pNew in
   pNew->m_pLexMain = NULL;

   pNew->FreeUnits();

   wcscpy (pNew->m_szFile, m_szFile);
   pNew->m_dwTriPhoneGroup = m_dwTriPhoneGroup;
   pNew->m_fKeepLog = m_fKeepLog;
   pNew->m_fFullPCM = m_fFullPCM;
   pNew->m_fAvgPitch = m_fAvgPitch;
   pNew->m_dwUnits = m_dwUnits;
   pNew->m_fPauseLessOften = m_fPauseLessOften;
   pNew->m_fAvgSyllableDur = m_fAvgSyllableDur;
   pNew->m_dwWordsPerMinute = pNew->m_dwWordsPerMinute;
   wcscpy (pNew->m_szLexicon, m_szLexicon);
   pNew->m_dwNumPhone = m_dwNumPhone;
   pNew->m_dwRefCount = m_dwRefCount;

   if (pNew->m_pLexTrainingWords)
      delete m_pLexTrainingWords;
   pNew->m_pLexTrainingWords = m_pLexTrainingWords->Clone();

   if (pNew->m_pLexWords)
      delete pNew->m_pLexWords;
   pNew->m_pLexWords = m_pLexWords->Clone();


   pNew->m_memTTSTARGETCOSTS.m_dwCurPosn = m_memTTSTARGETCOSTS.m_dwCurPosn;
   if (pNew->m_memTTSTARGETCOSTS.Required(m_memTTSTARGETCOSTS.m_dwCurPosn))
      memcpy (pNew->m_memTTSTARGETCOSTS.p, m_memTTSTARGETCOSTS.p, m_memTTSTARGETCOSTS.m_dwCurPosn);
   else
      pNew->m_memTTSTARGETCOSTS.p = NULL;

   // note: not cloning or doing MMLTo/From the generic voice disguise

#if 0 // old prosody
   pNew->m_pPunctAccentuate.Copy (&m_pPunctAccentuate);
#endif // 0

   if (!pNew->MakeSureEnoughPhone ()) {
      delete pNew;
      return NULL;
   }

#if 0 // handled by pNew->MakeSureEnoughPhone
   // copy over triphones
   if (!pNew->m_memTriPhoneAudio.Required (pNew->m_dwNumPhone * sizeof(PCListFixed))) {
      delete pNew;
      return NULL;
   }
   pNew->m_palPCMTTSTriPhoneAudio = (PCListFixed*) pNew->m_memTriPhoneAudio.p;
#endif // 0
   memcpy (pNew->m_palPCMTTSTriPhoneAudio, m_palPCMTTSTriPhoneAudio,pNew->m_dwNumPhone * sizeof(PCListFixed));
   DWORD i, j;
   for (i = 0; i < m_dwNumPhone; i++) {
      PCListFixed pl = new CListFixed;
      if (!pl) {
         pNew->m_palPCMTTSTriPhoneAudio[i] = NULL;
         continue;
      }
      pl->Init (sizeof(PCMTTSTriPhoneAudio), m_palPCMTTSTriPhoneAudio[i]->Get(0),
         m_palPCMTTSTriPhoneAudio[i]->Num());
      pNew->m_palPCMTTSTriPhoneAudio[i] = pl;

      // go through this list
      PCMTTSTriPhoneAudio *pptp = (PCMTTSTriPhoneAudio*) pl->Get(0);
      for (j = 0; j < pl->Num(); j++)
         pptp[j] = pptp[j]->Clone();
   } // i

   // NOTE: Don't clone m_pamemTriPhoneAudio because memory invalid

   for (i = 0; i < NUMFUNCWORDGROUP; i++) {
      if (pNew->m_apLexFuncWord[i])
         delete pNew->m_apLexFuncWord[i];
      pNew->m_apLexFuncWord[i] = NULL;

      if (!m_apLexFuncWord[i])
         continue;
      pNew->m_apLexFuncWord[i] = m_apLexFuncWord[i]->Clone();
   }

   // copy over audio
   // NOT TESTED
   pNew->m_lPCTTSWave.Init (sizeof(PCTTSWave), m_lPCTTSWave.Get(0), m_lPCTTSWave.Num());
   PCTTSWave *ppTW = (PCTTSWave*)pNew->m_lPCTTSWave.Get(0);
   for (i = 0; i < pNew->m_lPCTTSWave.Num(); i++)
      if (ppTW[i])
         ppTW[i] = ppTW[i]->Clone();

   // NOT TESTED
   pNew->m_lPCPhaseModel.Init (sizeof(PCPhaseModel), m_lPCPhaseModel.Get(0), m_lPCPhaseModel.Num());
   PCPhaseModel *pppm = (PCPhaseModel*)pNew->m_lPCPhaseModel.Get(0);
   for (i = 0; i < pNew->m_lPCPhaseModel.Num(); i++)
      if (pppm[i])
         pppm[i] = pppm[i]->Clone();

   // copy over triphones
#if 0 // handled by pNew->MakeSureEnoughPhone
   if (!pNew->m_memTriPhonePros.Required (pNew->m_dwNumPhone * sizeof(PCListFixed))) {
      delete pNew;
      return NULL;
   }
   pNew->m_palPCMTTSTriPhonePros = (PCListFixed*) pNew->m_memTriPhonePros.p;
#endif // 0
   memcpy (pNew->m_palPCMTTSTriPhonePros, m_palPCMTTSTriPhonePros,pNew->m_dwNumPhone * sizeof(PCListFixed));
   for (i = 0; i < m_dwNumPhone; i++) {
      PCListFixed pl = new CListFixed;
      if (!pl) {
         pNew->m_palPCMTTSTriPhonePros[i] = NULL;
         continue;
      }
      pl->Init (sizeof(PCMTTSTriPhonePros), m_palPCMTTSTriPhonePros[i]->Get(0),
         m_palPCMTTSTriPhonePros[i]->Num());
      pNew->m_palPCMTTSTriPhonePros[i] = pl;

      // go through this list
      PCMTTSTriPhonePros *pptp = (PCMTTSTriPhonePros*) pl->Get(0);
      for (j = 0; j < pl->Num(); j++)
         pptp[j] = pptp[j]->Clone();
   } // i

#if 0 // old prosody
   if (pNew->m_pLexFuncWords)
      delete pNew->m_pLexFuncWords;
   pNew->m_pLexFuncWords = m_pLexFuncWords->Clone();

   for (i = 0; i < NUMLEXWORDEMPH; i++) {
      if (pNew->m_apLexWordEmph[i])
         delete pNew->m_apLexWordEmph[i];
      pNew->m_apLexWordEmph[i] = NULL;

      if (!m_apLexWordEmph[i])
         continue;
      pNew->m_apLexWordEmph[i] = m_apLexWordEmph[i]->Clone();
   }
   memcpy (pNew->m_apLexWordEmphScale, m_apLexWordEmphScale, sizeof(m_apLexWordEmphScale));
   memcpy (pNew->m_apProsWordEmphFromWordLength, m_apProsWordEmphFromWordLength, sizeof(m_apProsWordEmphFromWordLength));

   // punct pros
   PCTTSPunctPros *ppp = (PCTTSPunctPros*)m_lPCTTSPunctPros.Get(0);
   for (i = 0; i < m_lPCTTSPunctPros.Num(); i++)
      if (ppp[i])
         delete ppp[i];
   m_lPCTTSPunctPros.Clear();
   pNew->m_lPCTTSPunctPros.Init (sizeof(PCTTSPunctPros), m_lPCTTSPunctPros.Get(0), m_lPCTTSPunctPros.Num());
   ppp = (PCTTSPunctPros*)m_lPCTTSPunctPros.Get(0);
   for (i = 0; i < pNew->m_lPCTTSPunctPros.Num(); i++)
      if (ppp[i])
         ppp[i] = ppp[i]->Clone();
#endif // 0

   // NOTE: NOT cloning the prosody/audio object caches:
   //  m_papObjectCachePCMTTSTriPhoneAudio
   //  m_papObjectCachePCMTTSTriPhonePros

   // sentence samples
   // NOTE: Clone not tested
   m_pCTTSProsody->CloneTo (pNew->m_pCTTSProsody);

   // copy over micropauses
   //if (!pNew->m_memMicroPause.Required (m_memMicroPause.m_dwCurPosn)) {
   //   delete pNew;
   //   return NULL;
   //}
   //memcpy (pNew->m_memMicroPause.p, m_memMicroPause.p, m_memMicroPause.m_dwCurPosn);
   //pNew->m_memMicroPause.m_dwCurPosn = m_memMicroPause.m_dwCurPosn;

   // copy over energy-per-pitch
   if (!pNew->m_memEnergyPerPitch.Required (m_memEnergyPerPitch.m_dwCurPosn)) {
      delete pNew;
      return NULL;
   }
   memcpy (pNew->m_memEnergyPerPitch.p, m_memEnergyPerPitch.p, m_memEnergyPerPitch.m_dwCurPosn);
   pNew->m_memEnergyPerPitch.m_dwCurPosn = m_memEnergyPerPitch.m_dwCurPosn;

   // copy over energy-per-volume
   if (!pNew->m_memEnergyPerVolume.Required (m_memEnergyPerVolume.m_dwCurPosn)) {
      delete pNew;
      return NULL;
   }
   memcpy (pNew->m_memEnergyPerVolume.p, m_memEnergyPerVolume.p, m_memEnergyPerVolume.m_dwCurPosn);
   pNew->m_memEnergyPerVolume.m_dwCurPosn = m_memEnergyPerVolume.m_dwCurPosn;

#if 0 // old prosody
   // copy over ngram
   if (!pNew->m_memNGram.Required (m_memNGram.m_dwCurPosn)) {
      delete pNew;
      return NULL;
   }
   memcpy (pNew->m_memNGram.p, m_memNGram.p, m_memNGram.m_dwCurPosn);
   pNew->m_memNGram.m_dwCurPosn = m_memNGram.m_dwCurPosn;
#endif // 0

   pNew->m_fIsDerived = m_fIsDerived;
   wcscpy (pNew->m_szTTSMaster, m_szTTSMaster);
   if (pNew->m_pTTSMaster)
      TTSCacheClose (pNew->m_pTTSMaster);
   pNew->m_pTTSMaster = m_pTTSMaster;
   if (pNew->m_pTTSMaster)
      pNew->m_pTTSMaster->m_dwRefCount++;


   // NOTE: Clone not tested
   // free up sub-voices in pNew
   PCMTTSSubVoice *ppsv = (PCMTTSSubVoice*) pNew->m_lPCMTTSSubVoice.Get(0);
   for (i = 0; i < pNew->m_lPCMTTSSubVoice.Num(); i++)
      delete ppsv[i];
   pNew->m_lPCMTTSSubVoice.Clear();
   pNew->m_lPCMTTSSubVoice.Init (sizeof(PCMTTSSubVoice), m_lPCMTTSSubVoice.Get(0), m_lPCMTTSSubVoice.Num());
   ppsv = (PCMTTSSubVoice*) pNew->m_lPCMTTSSubVoice.Get(0);
   for (i = 0; i < pNew->m_lPCMTTSSubVoice.Num(); i++)
      ppsv[i] = ppsv[i]->Clone();

   return pNew;
}

static PWSTR gpszTTS = L"TTS";
static PWSTR gpszTriPhoneGroup = L"TriPhoneGroup";
static PWSTR gpszWordsPerMinute = L"WordsPerMinute";
static PWSTR gpszNumPhone = L"NumPhone";
static PWSTR gpszLexWords = L"LexWOrds";
static PWSTR gpszLexFuncWords = L"LexFuncWords";
static PWSTR gpszMicroPause = L"MicroPause";
static PWSTR gpszEnergyPerPitch = L"EnergyPerPitch";
static PWSTR gpszEnergyPerVolume = L"EnergyPerVolume";
static PWSTR gpszNGram = L"NGram";
static PWSTR gpszKeepLog = L"KeepLog";
static PWSTR gpszIsDerived = L"IsDerived";
static PWSTR gpszTTSMaster = L"TTSMaster";
static PWSTR gpszVoiceSynth = L"VoiceSynth";
static PWSTR gpszTTSAccentRule = L"TTSAccentRule";
static PWSTR gpszBlurPitch = L"BlurPitch";
static PWSTR gpszBlurVolume = L"BlurVolume";
static PWSTR gpszPhoneRiseAccentuate = L"PhoneRiseAccentuate";
static PWSTR gpszPhonePitchAccentuate = L"PhonePitchAccentuate";
static PWSTR gpszPOSAccentuate = L"POSAccentuate";
static PWSTR gpszPunctAccentuate = L"PunctAccentuate";
static PWSTR gpszDurWordStart = L"DurWordStart";
static PWSTR gpszDurWordEnd = L"DurWordEnd";
static PWSTR gpszDurPerPhone = L"DurPerPhone";
static PWSTR gpszLexTrainingWords = L"LexTrainingWords";
static PWSTR gpszSubVoice = L"SubVoice";
static PWSTR gpszUnits = L"Units";
static PWSTR gpszVersion = L"Version";
static PWSTR gpszFullPCM = L"FullPCM";
static PWSTR gpszTTSWave = L"TTSWave";
static PWSTR gpszTTSTARGETCOSTS = L"TTSTARGETCOSTS";
static PWSTR gpszPauseLessOften = L"PauseLessOften";
static PWSTR gpszCPhaseModel = L"CPhaseModel";

/*************************************************************************************
CMTTS::CMTTS - Standard api
*/
PCMMLNode2 CMTTS::MMLTo (void)
{
   PCMMLNode2 pNode = new CMMLNode2;
   if (!pNode)
      return NULL;
   pNode->NameSet (gpszTTS);

   // this is a bit unusual, but because only saving tts voice after building it,
   // do the calculation for words per minute here
   if (!m_fIsDerived)   // BUGFIX - Only calc words per minute if not derived
      m_dwWordsPerMinute = CalcWordsPerMinute ();

   MMLValueSet (pNode, gpszVersion, m_fIsDerived ? TTSVERSION_DERIVED : TTSVERSION_MASTER);

   MMLValueSet (pNode, gpszTriPhoneGroup, (int) m_dwTriPhoneGroup);
   MMLValueSet (pNode, gpszKeepLog, (int) m_fKeepLog);
   MMLValueSet (pNode, gpszFullPCM, (int) m_fFullPCM);
   MMLValueSet (pNode, gpszAvgPitch, m_fAvgPitch);
   MMLValueSet (pNode, gpszUnits, (int)m_dwUnits);
   MMLValueSet (pNode, gpszPauseLessOften, (int)m_fPauseLessOften);
   MMLValueSet (pNode, gpszAvgSyllableDur, m_fAvgSyllableDur);
   MMLValueSet (pNode, gpszWordsPerMinute, (int)m_dwWordsPerMinute);
   MMLValueSet (pNode, gpszNumPhone, (int) m_dwNumPhone);
   if (m_szLexicon[0])
      MMLValueSet (pNode, gpszLexicon, m_szLexicon);
   MMLValueSet (pNode, gpszIsDerived, (int)m_fIsDerived);
   if (m_szTTSMaster[0])
      MMLValueSet (pNode, gpszTTSMaster, m_szTTSMaster);

   //if (m_memMicroPause.m_dwCurPosn)
   //   MMLValueSet (pNode, gpszMicroPause, (PBYTE)m_memMicroPause.p, m_memMicroPause.m_dwCurPosn);

   if (m_memEnergyPerPitch.m_dwCurPosn)
      MMLValueSet (pNode, gpszEnergyPerPitch, (PBYTE)m_memEnergyPerPitch.p, m_memEnergyPerPitch.m_dwCurPosn);
   if (m_memEnergyPerVolume.m_dwCurPosn)
      MMLValueSet (pNode, gpszEnergyPerVolume, (PBYTE)m_memEnergyPerVolume.p, m_memEnergyPerVolume.m_dwCurPosn);


   if (m_memTTSTARGETCOSTS.m_dwCurPosn == sizeof(TTSTARGETCOSTS))
      MMLValueSet (pNode, gpszTTSTARGETCOSTS, (PBYTE)m_memTTSTARGETCOSTS.p, m_memTTSTARGETCOSTS.m_dwCurPosn);

   DWORD i;
   WCHAR szTemp[64];
   if (m_fIsDerived) for (i = 0; i < NUMPROSODYTTS; i++) {
      if (!m_aszProsodyTTS[i][0])
         continue;
      swprintf (szTemp, L"ProsodyTTS%d", (int)i);
      MMLValueSet (pNode, szTemp, m_aszProsodyTTS[i]);
   } // i

   // convert to sentence syllables
   PCMMLNode2 pSub = m_pCTTSProsody->MMLTo();
   if (pSub) {
      pSub->NameSet (gpszTTSProsody);
      pNode->ContentAdd (pSub);
   }

#if 0 // old prosody
   CMem  memRLE;
   mem.m_dwCurPosn = 0;
   if (m_memNGram.m_dwCurPosn) {
      // convert to RLE
      memRLE.m_dwCurPosn = 0;
      if (RLEEncode ((PBYTE)m_memNGram.p, m_memNGram.m_dwCurPosn, 1, &memRLE))
         return FALSE;
      DWORD dwRLESize = memRLE.m_dwCurPosn;
      if (!dwRLESize)
         return FALSE;

      // write to MML
      MMLValueSet (pNode, gpszNGram, (PBYTE)memRLE.p, memRLE.m_dwCurPosn);
   }
#endif // 0

   pSub = m_pLexTrainingWords->MMLTo();
   if (pSub) {
      pSub->NameSet (gpszLexTrainingWords);
      pNode->ContentAdd (pSub);
   }

   pSub = m_pLexWords->MMLTo();
   if (pSub) {
      pSub->NameSet (gpszLexWords);
      pNode->ContentAdd (pSub);
   }

   for (i = 0; i < NUMFUNCWORDGROUP; i++) {
      if (!m_apLexFuncWord[i])
         continue;

      WCHAR szTemp[64];
      swprintf (szTemp, L"FuncWordGroup%d", (int)i);
      pSub = m_apLexFuncWord[i]->MMLTo();
      if (pSub) {
         pSub->NameSet (szTemp);
         pNode->ContentAdd (pSub);
      }
   }

   // note: not cloning or doing MMLTo/From the generic voice disguise

#if 0 // old prosody
   MMLValueSet (pNode, gpszPunctAccentuate, &m_pPunctAccentuate);
#endif // 0

#if 0 // def _WIN64
   // to test really large voice
   DWORD dwMultiCopies = 100000 / m_dwUnits;
   dwMultiCopies = max(dwMultiCopies, 1);
#endif

   // loop through all the triphones and add them
   DWORD j;
   CMem mem;
   for (i = 0; i < m_dwNumPhone; i++) {
      // get the elem
      PCListFixed pl = m_palPCMTTSTriPhoneAudio[i];
      if (!pl)
         continue;
      PCMTTSTriPhoneAudio *pptp = (PCMTTSTriPhoneAudio*) pl->Get(0);

      // loop through triphones
      mem.m_dwCurPosn = 0;
#if 0 //def _WIN64
      // simulate a lot of copies
      DWORD dwCopy;
      for (dwCopy = 0; dwCopy < dwMultiCopies; dwCopy++)
#endif
      for (j = 0; j < pl->Num(); j++) {
         if (!pptp[j])
            continue;

         size_t dwSize = mem.m_dwCurPosn;
         size_t dwUsed;
         mem.m_dwCurPosn += sizeof(DWORD);
         dwUsed = pptp[j]->MMLToBinary (&mem);
         if (!dwUsed) {
            mem.m_dwCurPosn = dwSize;
            continue;
         }

         DWORD *pdw = (DWORD*)((PBYTE)mem.p + dwSize);
         pdw[0] = (DWORD) dwUsed;
      } // j

      // NOTE: Not using RLE encode here because MMLToBinary does the same
#if 0 // def _WIN64
      // randomize so compress problems
      DWORD k;
      for (k = 0; k < (DWORD)mem.m_dwCurPosn; k++)
         ((PBYTE)mem.p)[k] = (BYTE) rand();
#endif

      // write to MML
      WCHAR szTemp[64];
      swprintf (szTemp, L"TriPhoneAudio%d", (int)i);
      MMLValueSet (pNode, szTemp, (PBYTE)mem.p, mem.m_dwCurPosn);
   } // i

   for (i = 0; i < m_dwNumPhone; i++) {
      // get the elem
      PCListFixed pl = m_palPCMTTSTriPhonePros[i];
      if (!pl)
         continue;
      PCMTTSTriPhonePros *pptp = (PCMTTSTriPhonePros*) pl->Get(0);

      // loop through triphones
      mem.m_dwCurPosn = 0;
      for (j = 0; j < pl->Num(); j++) {
         if (!pptp[j])
            continue;

         size_t dwSize = mem.m_dwCurPosn;
         size_t dwUsed;
         mem.m_dwCurPosn += sizeof(DWORD);
         dwUsed = pptp[j]->MMLToBinary (&mem);
         if (!dwUsed) {
            mem.m_dwCurPosn = dwSize;
            continue;
         }

         DWORD *pdw = (DWORD*)((PBYTE)mem.p + dwSize);
         pdw[0] = (DWORD) dwUsed;
      } // j

      // NOTE: Not using RLE encode here because MMLToBinary does the same

      // write to MML
      WCHAR szTemp[64];
      swprintf (szTemp, L"TriPhonePros%d", (int)i);
      MMLValueSet (pNode, szTemp, (PBYTE)mem.p, mem.m_dwCurPosn);
   } // i

   // WCHAR szTemp[64];

#if 0 // old prosody
   // write out function words
   pSub = m_pLexFuncWords->MMLTo();
   if (pSub) {
      pSub->NameSet (gpszLexFuncWords);
      pNode->ContentAdd (pSub);
   }

   for (i = 0; i < NUMLEXWORDEMPH; i++) {
      if (!m_apLexWordEmph[i])
         continue;

      swprintf (szTemp, L"LexWordEmph%d", (int)i);
      pSub = m_apLexWordEmph[i]->MMLTo();
      if (pSub) {
         pSub->NameSet (szTemp);
         pNode->ContentAdd (pSub);
      }
   }
   for (i = 0; i < NUMLEXWORDEMPH+1; i++) {
      swprintf (szTemp, L"LexWordEmphScale%d", (int)i);
      MMLValueSet (pNode, szTemp, &m_apLexWordEmphScale[i]);
   }
   for (i = 0; i < NUMPROSWORDLENGTH; i++) {
      swprintf (szTemp, L"ProsFromWordLength%d", (int)i);
      MMLValueSet (pNode, szTemp, &m_apProsWordEmphFromWordLength[i]);
   }

   // write out the punctuation prosody
   PCTTSPunctPros *ppp = (PCTTSPunctPros*)m_lPCTTSPunctPros.Get(0);
   for (i = 0; i < m_lPCTTSPunctPros.Num(); i++) {
      if (!ppp[i])
         continue;
      pSub = ppp[i]->MMLTo();
      if (pSub)
         pNode->ContentAdd (pSub);
   } // i
#endif // 0
   for (i = 0; i < NUMPHONEEMPH*2; i++) for (j = 0; j < PHONEPOSBIN; j++) {
      swprintf (szTemp, L"PhoneEmp%dx%d", (int)i, (int)j);
      MMLValueSet (pNode, szTemp, &m_apPhoneEmph[i][j]);
   }

   // write out subvoices
   PCMTTSSubVoice *ppsv = (PCMTTSSubVoice*) m_lPCMTTSSubVoice.Get(0);
   for (i = 0; i < m_lPCMTTSSubVoice.Num(); i++) {
      pSub = ppsv[i]->MMLTo ();
      if (pSub) {
         pSub->NameSet (gpszSubVoice);
         pNode->ContentAdd (pSub);
      }
   } // i


   // write out the phase model
   PCPhaseModel *pppm = (PCPhaseModel*)m_lPCPhaseModel.Get(0);
   mem.m_dwCurPosn = 0;
   for (i = 0; i < m_lPCPhaseModel.Num(); i++) {
      _ASSERTE (pppm[i]);
      if (!pppm[i])  // shouldnt happen
         break;

      if (!pppm[i]->MMLToBinary (&mem))
         break;
   } //
   if ((i >= m_lPCPhaseModel.Num()) && mem.m_dwCurPosn)
      MMLValueSet(pNode, gpszCPhaseModel, (PBYTE) mem.p, mem.m_dwCurPosn);

   // write out the waves
   PCTTSWave *ppTW = (PCTTSWave*)m_lPCTTSWave.Get(0);
   for (i = 0; i < m_lPCTTSWave.Num(); i++) {
      if (!ppTW[i])
         continue;   // empty

      mem.m_dwCurPosn = 0;
      size_t dwSize;
      dwSize = ppTW[i]->MMLToBinary (&mem);
      if (!dwSize)
         continue;   // error

      pSub = pNode->ContentAddNewNode ();
      if (!pSub)
         continue;

      pSub->NameSet (gpszTTSWave);
      MMLValueSet(pSub, gpszTTSWave, (PBYTE) mem.p, dwSize);
   } // i

   return pNode;
}

/*************************************************************************************
CMTTS::MMLFrom - Standard api

inputs
   PCMMLNode2         pNode - Node to read from
   PWSTR             pszSrcFile - If the main lexicon doesnt exist, then the root
                           directory is taken from this and used
*/
BOOL CMTTS::MMLFrom (PCMMLNode2 pNode, PWSTR pszSrcFile)
{
   WCHAR szTemp[128];
#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem D = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif

   // clear out what have
   //m_memMicroPause.m_dwCurPosn = 0;
   m_memEnergyPerPitch.m_dwCurPosn = 0;
   m_memEnergyPerVolume.m_dwCurPosn = 0;
#if 0 // old prosody
   m_memNGram.m_dwCurPosn = 0;
#endif // 0
   m_pLexTrainingWords->Clear();
   m_pLexWords->Clear();
   if (m_pLexMain)
      MLexiconCacheClose (m_pLexMain);
   m_pLexMain = NULL;
   if (m_pTTSMaster)
      TTSCacheClose (m_pTTSMaster);
   m_pTTSMaster = NULL;

   DWORD i,j;
   for (i = 0; i < NUMFUNCWORDGROUP; i++) {
      if (m_apLexFuncWord[i])
         delete m_apLexFuncWord[i];
      m_apLexFuncWord[i] = NULL;
   }

   // free sentece syllables
   m_pCTTSProsody->Clear();

   // clear prosody info
   for (i = 0; i < NUMPROSODYTTS; i++)
      m_aszProsodyTTS[i][0] = 0;

   FreeUnits ();
#if 0 // dont need because handled by free units
   // free up triphones
   for (i = 0; i < m_dwNumPhone; i++) {
      PCListFixed pl = m_palPCMTTSTriPhoneAudio[i];
      if (!pl)
         continue;

      PCMTTSTriPhoneAudio *pptp = (PCMTTSTriPhoneAudio*)pl->Get(0);
      for (j = 0; j < pl->Num(); j++)
         delete pptp[j];

      delete pl;
   } // i
   for (i = 0; i < m_dwNumPhone; i++) {
      PCListFixed pl = m_palPCMTTSTriPhonePros[i];
      if (!pl)
         continue;

      PCMTTSTriPhonePros *pptp = (PCMTTSTriPhonePros*)pl->Get(0);
      for (j = 0; j < pl->Num(); j++)
         delete pptp[j];

      delete pl;
   } // i
   m_dwNumPhone = 0;
#endif // 0

#if 0 // old prosody
   for (i = 0; i < NUMLEXWORDEMPH; i++) {
      if (m_apLexWordEmph[i])
         delete m_apLexWordEmph[i];
      m_apLexWordEmph[i] = NULL;
   }

   // delete punctionan prosody
   PCTTSPunctPros *ppp = (PCTTSPunctPros*)m_lPCTTSPunctPros.Get(0);
   for (i = 0; i < m_lPCTTSPunctPros.Num(); i++)
      if (ppp[i])
         delete ppp[i];
   m_lPCTTSPunctPros.Clear();
#endif // 0

   // clear sub-voices
   PCMTTSSubVoice *ppsv = (PCMTTSSubVoice*) m_lPCMTTSSubVoice.Get(0);
   for (i = 0; i < m_lPCMTTSSubVoice.Num(); i++)
      delete ppsv[i];
   m_lPCMTTSSubVoice.Clear();

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem E = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif

   m_fIsDerived = (BOOL) MMLValueGetInt (pNode, gpszIsDerived, FALSE);
   DWORD dwVersion = (DWORD)MMLValueGetInt (pNode, gpszVersion, 0);
   if (dwVersion != (m_fIsDerived ? TTSVERSION_DERIVED : TTSVERSION_MASTER)) {
      return FALSE;
   }

   // read in
   m_dwTriPhoneGroup = (DWORD) MMLValueGetInt (pNode, gpszTriPhoneGroup, (int) 0);
   m_fKeepLog = (BOOL) MMLValueGetInt (pNode, gpszKeepLog, (int) 0);
   m_fFullPCM = (BOOL) MMLValueGetInt (pNode, gpszFullPCM, (int) 0);
   m_fAvgPitch = MMLValueGetDouble (pNode, gpszAvgPitch, 0);
   m_dwUnits = (DWORD)MMLValueGetInt (pNode, gpszUnits, OPTIMALNUMUNITS);
   m_dwUnits = max(m_dwUnits, 1);
   m_fPauseLessOften = (BOOL) MMLValueGetInt (pNode, gpszPauseLessOften, (int)FALSE);
   m_fAvgSyllableDur = MMLValueGetDouble (pNode, gpszAvgSyllableDur, 0);
   m_dwWordsPerMinute = (DWORD)MMLValueGetInt (pNode, gpszWordsPerMinute, (int)0);
   m_dwWordsPerMinute = max(m_dwWordsPerMinute, 1);
   m_dwNumPhone = (DWORD) MMLValueGetInt (pNode, gpszNumPhone, (int) 0);
   PWSTR psz = MMLValueGet (pNode, gpszLexicon);
   if (psz)
      wcscpy (m_szLexicon, psz);
   else
      m_szLexicon[0] = 0;

   psz = MMLValueGet (pNode, gpszTTSMaster);
   if (psz)
      wcscpy (m_szTTSMaster, psz);
   else
      m_szTTSMaster[0] = 0;

   if (m_fIsDerived) for (i = 0; i < NUMPROSODYTTS; i++) {
      swprintf (szTemp, L"ProsodyTTS%d", (int)i);
      psz = MMLValueGet (pNode, szTemp);
      if (psz)
         wcscpy (m_aszProsodyTTS[i], psz);
      else
         m_aszProsodyTTS[i][0] = 0;
   } // i

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem F = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif


   // target costs
   m_memTTSTARGETCOSTS.m_dwCurPosn = 0;
   MMLValueGetBinary (pNode, gpszTTSTARGETCOSTS, &m_memTTSTARGETCOSTS);


   PCMMLNode2 pSub;
   for (i = 0; i < NUMFUNCWORDGROUP; i++) {
      WCHAR szTemp[64];
      swprintf (szTemp, L"FuncWordGroup%d", (int)i);
      pSub = NULL;
      pNode->ContentEnum(pNode->ContentFind (szTemp), &psz, &pSub);
      if (!pSub)
         continue;

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem G%da = %d K", (int)i, (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif
      m_apLexFuncWord[i] = new CMLexicon;
      if (!m_apLexFuncWord[i])
         continue;
#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem G%db = %d K", (int)i, (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif
      m_apLexFuncWord[i]->MMLFrom (pSub, NULL, FALSE);
#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem G%dc = %d K", (int)i, (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif
   }

   // get the words...
#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem G = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif



   pSub = NULL;
   pNode->ContentEnum (pNode->ContentFind (gpszLexTrainingWords), &psz, &pSub);
   if (pSub)
      m_pLexTrainingWords->MMLFrom (pSub, NULL, FALSE);

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem H = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif

   pSub = NULL;
   pNode->ContentEnum (pNode->ContentFind (gpszLexWords), &psz, &pSub);
   if (pSub)
      m_pLexWords->MMLFrom (pSub, NULL, FALSE);

   // note: not cloning or doing MMLTo/From the generic voice disguise

   // tts accent
   CMem memRLE, mem;

#if 0 // old prosody
   m_pPunctAccentuate.Copy (&m_pPOSAccentuate);
   MMLValueGetPoint (pNode, gpszPunctAccentuate, &m_pPunctAccentuate);
#endif // 0

      // BUGFIX - Moved the lexicon code from the end of the load to this part
   if (!LexiconExists (m_szLexicon, pszSrcFile)) {
      if (!m_fIsDerived)
         return FALSE;
   }
   if (!LexiconRequired()) {   // if cant load the lexicon the fail altogether
      if (!m_fIsDerived)
         return FALSE;
   }

   // load in tts master
   // BUGFIX - Was LexiconExists(), but wrong call
   //LexiconExists (m_szTTSMaster, pszSrcFile);
   if (m_szTTSMaster[0]) {
      ResolvePathIfNotExist(m_szTTSMaster, pszSrcFile);
      m_pTTSMaster = TTSCacheOpen (m_szTTSMaster);
   }
   else
      m_pTTSMaster = NULL;

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem I = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif

   // set the lexicon
   // m_pCTTSProsody->LexiconSet (Lexicon(TRUE));

   if (!MakeSureEnoughPhone ())
      return FALSE;

#if 0 // handled by MakeSureEnoughPhone
   // allocate memory for triphones
   if (!m_memTriPhoneAudio.Required (m_dwNumPhone * sizeof(PCListFixed)))
      return FALSE;
   m_palPCMTTSTriPhoneAudio = (PCListFixed*) m_memTriPhoneAudio.p;
   memset (m_palPCMTTSTriPhoneAudio, 0, m_dwNumPhone * sizeof(PCListFixed));

   // allocate memory for triphones
   if (!m_memTriPhonePros.Required (m_dwNumPhone * sizeof(PCListFixed)))
      return FALSE;
   m_palPCMTTSTriPhonePros = (PCListFixed*) m_memTriPhonePros.p;
   memset (m_palPCMTTSTriPhonePros, 0, m_dwNumPhone * sizeof(PCListFixed));
#endif // 0

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem J = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif

   // loop through all the phones...
   PCMLexicon pLexicon = Lexicon();
   for (i = 0; i < m_dwNumPhone; i++) {
      WCHAR szTemp[64];
      swprintf (szTemp, L"TriPhoneAudio%d", (int)i);

      // try decompressing this into a large memory that can keep, for faster
      // loads and close down
      PCMem pMemToUse = NULL;
      pMemToUse = &mem;
      mem.m_dwCurPosn = 0;
      //if (!m_pamemTriPhoneAudio[i])
      //   pMemToUse = m_pamemTriPhoneAudio[i] = new CMem;
      //if (!pMemToUse)
      //   pMemToUse = &mem;

      // BUGFIX - Use new MMLValueGetbinary
      MMLValueGetBinary (pNode, szTemp, pMemToUse);
      //psz = MMLValueGet (pNode, szTemp);
      size_t dwSize = pMemToUse->m_dwCurPosn;
      if (!dwSize)
         continue;
      PBYTE pb = (PBYTE)pMemToUse->p;

      // make a list
      PCListFixed pl = new CListFixed;
      if (!pl)
         return FALSE;
      pl->Init (sizeof(PCMTTSTriPhoneAudio));

      // count the number of elements
      DWORD dwCur = 0;
      DWORD dwCount;
      for (dwCount = 0; dwCur+sizeof(DWORD) < dwSize; dwCount++) {
         DWORD dwElem = *((DWORD*)(pb + dwCur));
         dwCur += sizeof(DWORD);
         if (dwElem+dwCur > dwSize)
            break;
         DWORD dwOld = dwCur;
         dwCur += dwElem;
      } // while

      // make sure enough elements
      pl->Required (dwCount);

      // minimize the mallocs and frees necessary
      BOOL fCanCache = FALSE;
      if (!m_papObjectCachePCMTTSTriPhoneAudio[i]) {
         m_papObjectCachePCMTTSTriPhoneAudio[i] = new CMTTSTriPhoneAudio[dwCount];
         fCanCache = m_papObjectCachePCMTTSTriPhoneAudio[i] ? TRUE : FALSE;
      }

      // loop
      dwCur = 0;
      while (dwCur+sizeof(DWORD) < dwSize) {
         DWORD dwElem = *((DWORD*)(pb + dwCur));
         dwCur += sizeof(DWORD);
         if (dwElem+dwCur > dwSize)
            break;
         DWORD dwOld = dwCur;
         dwCur += dwElem;

         PCMTTSTriPhoneAudio ptp;
         if (fCanCache) {
            ptp = &m_papObjectCachePCMTTSTriPhoneAudio[i][pl->Num()];
            ptp->m_fCached = TRUE;
         }
         else
            ptp = new CMTTSTriPhoneAudio;
         if (!ptp)
            continue;
         if (!ptp->MMLFromBinary (pb + dwOld, dwElem, pLexicon /*, pMemToUse != &mem*/)) {
            if (!fCanCache)
               delete ptp;
            continue;
         }

         pl->Add (&ptp);
      }

      // fill in list
      m_palPCMTTSTriPhoneAudio[i] = pl;
   } // i

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem K = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif

   // all the prosody triphones
   for (i = 0; i < m_dwNumPhone; i++) {
      WCHAR szTemp[64];
      swprintf (szTemp, L"TriPhonePros%d", (int)i);


      // BUGFIX - Use new MMLValueGetbinary
      MMLValueGetBinary (pNode, szTemp, &mem);
      //psz = MMLValueGet (pNode, szTemp);
      size_t dwSize = mem.m_dwCurPosn;
      if (!dwSize)
         continue;
      PBYTE pb = (PBYTE)mem.p;

      // make a list
      PCListFixed pl = new CListFixed;
      if (!pl)
         return FALSE;
      pl->Init (sizeof(PCMTTSTriPhonePros));

      // count the number of elements
      DWORD dwCur = 0;
      DWORD dwCount;
      for (dwCount = 0; dwCur+sizeof(DWORD) < dwSize; dwCount++) {
         DWORD dwElem = *((DWORD*)(pb + dwCur));
         dwCur += sizeof(DWORD);
         if (dwElem+dwCur > dwSize)
            break;
         DWORD dwOld = dwCur;
         dwCur += dwElem;
      } // dwCount
      pl->Required (dwCount);

      // minimize the mallocs and frees necessary
      BOOL fCanCache = FALSE;
      if (!m_papObjectCachePCMTTSTriPhonePros[i]) {
         m_papObjectCachePCMTTSTriPhonePros[i] = new CMTTSTriPhonePros[dwCount];
         fCanCache = m_papObjectCachePCMTTSTriPhonePros[i] ? TRUE : FALSE;
      }

      // loop
      dwCur = 0;
      while (dwCur+sizeof(DWORD) < dwSize) {
         DWORD dwElem = *((DWORD*)(pb + dwCur));
         dwCur += sizeof(DWORD);
         if (dwElem+dwCur > dwSize)
            break;
         DWORD dwOld = dwCur;
         dwCur += dwElem;

         PCMTTSTriPhonePros ptp;
         if (fCanCache) {
            ptp = &m_papObjectCachePCMTTSTriPhonePros[i][pl->Num()];
            ptp->m_fCached = TRUE;
         }
         else
            ptp = new CMTTSTriPhonePros;
         if (!ptp)
            continue;
         if (!ptp->MMLFromBinary (pb + dwOld, dwElem, pLexicon)) {
            if (!fCanCache)
               delete ptp;
            continue;
         }

         pl->Add (&ptp);
      }

      // fill in list
      m_palPCMTTSTriPhonePros[i] = pl;
   } // i

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem L = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif

   // WCHAR szTemp[64];
#if 0 // old prosody
   for (i = 0; i < NUMLEXWORDEMPH; i++) {
      swprintf (szTemp, L"LexWordEmph%d", (int)i);
      pSub = NULL;
      pNode->ContentEnum(pNode->ContentFind (szTemp), &psz, &pSub);
      if (!pSub)
         continue;

      m_apLexWordEmph[i] = new CMLexicon;
      if (!m_apLexWordEmph[i])
         continue;
      m_apLexWordEmph[i]->MMLFrom (pSub, NULL);
   }
   for (i = 0; i < NUMLEXWORDEMPH+1; i++) {
      swprintf (szTemp, L"LexWordEmphScale%d", (int)i);
      MMLValueGetPoint (pNode, szTemp, &m_apLexWordEmphScale[i]);
   }
   for (i = 0; i < NUMPROSWORDLENGTH; i++) {
      swprintf (szTemp, L"ProsFromWordLength%d", (int)i);
      m_apProsWordEmphFromWordLength[i].p[0] = 
         m_apProsWordEmphFromWordLength[i].p[1] = 
         m_apProsWordEmphFromWordLength[i].p[2] = 1;
      MMLValueGetPoint (pNode, szTemp, &m_apProsWordEmphFromWordLength[i]);
   }
#endif // 0
   for (i = 0; i < NUMPHONEEMPH*2; i++) for (j = 0; j < PHONEPOSBIN; j++) {
      swprintf (szTemp, L"PhoneEmp%dx%d", (int)i, (int)j);
      m_apPhoneEmph[i][j].p[0] = m_apPhoneEmph[i][j].p[1] = m_apPhoneEmph[i][j].p[2] = 1;
      MMLValueGetPoint (pNode, szTemp, &m_apPhoneEmph[i][j]);
   }


#if 0 // old prosody
   // function words
   pSub = NULL;
   pNode->ContentEnum (pNode->ContentFind (gpszLexFuncWords), &psz, &pSub);
   if (pSub)
      m_pLexFuncWords->MMLFrom (pSub, NULL);
#endif // 0

   // get the phase model
   size_t dwSize = MMLValueGetBinary (pNode, gpszCPhaseModel, &mem);
   PBYTE pabCur = (PBYTE)mem.p;
   _ASSERTE (!m_lPCPhaseModel.Num());
   for (i = 0; dwSize; i++) {
      PCPhaseModel ppm = new CPhaseModel;
      if (!ppm)
         break;   // error, shouldnt happen
      size_t dwUsed = ppm->MMLFromBinary (pabCur, dwSize);
      if (!dwUsed) {
         delete ppm;
         break;
      }

      // add
      m_lPCPhaseModel.Add (&ppm);
      dwSize -= dwUsed;
      pabCur += dwUsed;
   } // i and dwSize
   _ASSERTE (!dwSize);

   // find misc stuff
   for (i = 0; i < pNode->ContentNum(); i++) {
      pSub = NULL;
      pNode->ContentEnum (i, &psz, &pSub);
      if (!pSub)
         continue;
      psz = pSub->NameGet();
      if (!psz)
         continue;

      if (!_wcsicmp(psz, gpszTTSWave)) {
         mem.m_dwCurPosn = 0;
         size_t dwSize = MMLValueGetBinary (pSub, gpszTTSWave, &mem);
         if (!dwSize)
            continue;

         PCTTSWave pTW = new CTTSWave;
         if (!pTW)
            continue;
         if (!pTW->MMLFromBinary (mem.p, (DWORD) dwSize)) {
            delete pTW;
            continue;
         }

         // while not enough elements add
         PCTTSWave pTWNULL = NULL;
         while (m_lPCTTSWave.Num() <= pTW->m_dwSentenceNum)
            m_lPCTTSWave.Add (&pTWNULL);

         PCTTSWave *ppTW = (PCTTSWave*)m_lPCTTSWave.Get(0);
         if (ppTW[pTW->m_dwSentenceNum])
            delete ppTW[pTW->m_dwSentenceNum];  // shouldnt happen
         ppTW[pTW->m_dwSentenceNum] = pTW;
         continue;
      }
      else if (!_wcsicmp(psz, gpszSubVoice)) {
         PCMTTSSubVoice pNew = new CMTTSSubVoice;
         if (!pNew)
            continue;
         if (!pNew->MMLFrom (pSub, pszSrcFile)) {
            delete pNew;
            continue;
         }
         m_lPCMTTSSubVoice.Add (&pNew);
         continue;
      }
      else if (!_wcsicmp(psz, gpszTTSProsody)) {
         m_pCTTSProsody->MMLFrom (pSub, pszSrcFile);
         continue;
      }
#if 0 // old prosody
      if (!_wcsicmp(psz, gpszPunctPros)) {
         PCTTSPunctPros pNew = new CTTSPunctPros;
         if (!pNew)
            continue;
         pNew->MMLFrom (pSub);
         m_lPCTTSPunctPros.Add (&pNew);
         continue;
      }
#endif // 0
   }

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem M = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif


   // micropauses
   // BUGFIX - Use new binary call
   //MMLValueGetBinary (pNode, gpszMicroPause, &m_memMicroPause);
   // psz = MMLValueGet (pNode, gpszMicroPause);
   //if (psz) {
   //   if (!m_memMicroPause.Required (wcslen(psz)/2))
   //      return FALSE;
   //   m_memMicroPause.m_dwCurPosn = MMLBinaryFromString(psz,
   //      (PBYTE)m_memMicroPause.p, m_memMicroPause.m_dwAllocated);
   //}

   // energy per pitch
   MMLValueGetBinary (pNode, gpszEnergyPerPitch, &m_memEnergyPerPitch);

   // energy per volume
   MMLValueGetBinary (pNode, gpszEnergyPerVolume, &m_memEnergyPerVolume);
#if 0 // old prosody
   // micropauses
   // BUGFIX - new binary call
   memRLE.m_dwCurPosn = 0;
   MMLValueGetBinary (pNode, gpszNGram, &memRLE);
   //psz = MMLValueGet (pNode, gpszNGram);
   if (memRLE.m_dwCurPosn /*psz*/) {
      //if (!memRLE.Required (wcslen(psz)/2))
      //   return FALSE;
      PBYTE pb = (PBYTE)memRLE.p;
      //DWORD dwSize = MMLBinaryFromString (psz, pb, memRLE.m_dwAllocated);
      DWORD dwSize = memRLE.m_dwCurPosn;

      // RLE decode
      m_memNGram.m_dwCurPosn = 0;   // BUGFIX - Was just mem, wrong var
      DWORD dwUsed;
      if (RLEDecode ((PBYTE)memRLE.p, dwSize, 1, &m_memNGram, &dwUsed))
         return FALSE;
      dwSize = m_memNGram.m_dwCurPosn;
      if (!dwSize)
         return FALSE;

      // make sure size is correct
      DWORD dwExpect = (DWORD)pow(POS_MAJOR_NUM+1, TTSPROSNGRAM*2+1) *
         (DWORD) pow(3, TTSPROSNGRAMBIT*2) * sizeof(TTSNGRAM);
      if (dwExpect != m_memNGram.m_dwCurPosn)
         m_memNGram.m_dwCurPosn = 0;   // invalid
   }
#endif // 0

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tCurMem N = %d K", (int)(EscMemoryAllocated(FALSE)/1024));
   OutputDebugStringW (szTemp);
#endif


   // precalc SRANALBLOCK
   if (m_lPCTTSWave.Num())
      TTSWaveCalcSRANALBLOCKCreateThreads ();

   // make sure filled in
   FillInTriPhoneIndex ();

   return TRUE;
}

/*************************************************************************************
CMTTS::Save - Standard api
*/
BOOL CMTTS::Save (PWSTR pszFile)
{
   if (!pszFile)
      pszFile = m_szFile;

   PCMMLNode2 pNode = MMLTo();
   if (!pNode)
      return FALSE;
   BOOL fRet;
   fRet = MMLFileSave (pszFile, &GUID_TTS, pNode);
   delete pNode;

   if (fRet && (pszFile != m_szFile))
      wcscpy (m_szFile, pszFile);

   return fRet;
}

/*************************************************************************************
CMTTS::Open - Standard api
*/
BOOL CMTTS::Open (PWSTR pszFile)
{
#ifdef _DEBUG
   DWORD dwTime = GetTickCount();
#endif

   // BUGFIX - Ignore directory
   PCMMLNode2 pNode = MMLFileOpen (pszFile, &GUID_TTS, NULL, TRUE);
   if (!pNode) {
      // BUGBUG - more or less temporary hack. can get rid of eventually
      pNode = MMLFileOpen (pszFile, &GUID_TTSOLD, NULL, TRUE);

      if (!pNode)
         return FALSE;

      // if old version, only accept derived
      if (!MMLValueGetInt (pNode, gpszIsDerived, FALSE)) {
         delete pNode;
         return FALSE;
      }

   } // old version

   if (!MMLFrom (pNode, pszFile)) {
      delete pNode;
      return FALSE;
   }

#ifdef _DEBUG
   WCHAR szTemp[64];
   swprintf (szTemp, L"\r\nTTSLoadTime = %d", (int) (GetTickCount() - dwTime));
   OutputDebugStringW (szTemp);
#endif
   // rembmeber the file
   wcscpy (m_szFile, pszFile);

   delete pNode;
   return TRUE;
}



/*************************************************************************************
CMTTS::LexiconRequired - Loads the lexicon if it isn't already loaded.
Returns TRUE if success, FALSE if error
*/
BOOL CMTTS::LexiconRequired (void)
{
   if (m_pLexMain)
      return TRUE;

   m_pLexMain = MLexiconCacheOpen(m_szLexicon, FALSE);
   return (m_pLexMain ? TRUE : FALSE);
}

/*************************************************************************************
CMTTS::LexiconSet - Sets a new lexicon to use

inputs
   PWSTR          pszLexicon - Lexicon
returns
   BOOL - TRUE if was able to open, FALSE if not
*/
BOOL CMTTS::LexiconSet (PWSTR pszLexicon)
{
   if (m_pLexMain)
      MLexiconCacheClose (m_pLexMain);
   m_pLexMain = NULL;
   wcscpy (m_szLexicon, pszLexicon);

   BOOL fRet = LexiconRequired ();


   return fRet;
}

/*************************************************************************************
CMTTS::LexiconGet - Returns a pointer to the lexicon string. DO NOT modify it.
*/
PWSTR CMTTS::LexiconGet (void)
{
   return m_szLexicon;
}

/*************************************************************************************
CMTTS::Lexicon - Returns a pointer to the lexicon to use for SR. NULL if cant open

inputs
   BOOL        fBackoffToMaster - If TRUE then backs off to the master lexicon if this
               happens to be a derived voice and has no lexicon of its own
*/
PCMLexicon CMTTS::Lexicon (BOOL fBackoffToMaster)
{
   LexiconRequired ();

   // BUGFIX - If this is a derived TTS voice and no lexicon of its own, use
   // its master
   if (m_fIsDerived && !m_pLexMain && m_pTTSMaster && fBackoffToMaster)
      return m_pTTSMaster->Lexicon();

   return m_pLexMain;
}



/*************************************************************************************
CMTTS::TTSWaveCompress - Compress all TTSWaves
*/
void CMTTS::TTSWaveCompress (void)
{
   // don't bother doing any compression if still analyzing and creating SRANALBLOCKS
   // because ends up slowing things way down
   if (m_dwTTSWaveAnalyzing)
      return;

   DWORD i;
   PCTTSWave *ppTW = (PCTTSWave*)m_lPCTTSWave.Get(0);
   for (i = 0; i < m_lPCTTSWave.Num(); i++)
      if (ppTW[i] && ppTW[i]->NeedToCompress()) {
         EnterCriticalSection (&m_acsTTSWave[i % MAXRAYTHREAD]);
         ppTW[i]->Compress();
         LeaveCriticalSection (&m_acsTTSWave[i % MAXRAYTHREAD]);
      }

}


/*************************************************************************************
CMTTS::TTSWaveCalcSRFEATURESMALL - Calculates the SRFEATURESMALL for all TTS Waves

inputs
   DWORD       dwInital - Inital wave number
   DWORD       dwModulo - Skip this number of waves. Used to to multthreaded calcs.
*/
void CMTTS::TTSWaveCalcSRANALBLOCK (DWORD dwInitial, DWORD dwModulo)
{
   EnterCriticalSection (&m_csTTSWaveDecompress);
   m_dwTTSWaveAnalyzing++;
   LeaveCriticalSection (&m_csTTSWaveDecompress);

   DWORD i;
   PCTTSWave *ppTW = (PCTTSWave*)m_lPCTTSWave.Get(0);
   for (i = dwInitial; i < m_lPCTTSWave.Num(); i += dwModulo)
      if (ppTW[i]) {
         ppTW[i]->CalcSRANALBLOCK(&m_acsTTSWave[i % MAXRAYTHREAD]);

         // compress back, assuming that allowed to
         EnterCriticalSection (&m_acsTTSWave[i % MAXRAYTHREAD]);
         if (!m_fTTSWaveDisableCompress)
            ppTW[i]->Compress();
         LeaveCriticalSection (&m_acsTTSWave[i % MAXRAYTHREAD]);

         // exit if flag set saying that want to quit
         if (m_fTTSWaveCalcSRANALBLOCKWantToQuit)
            break;

         // BUGFIX - Put a sleep for 10 milliseconds so acts as very low priority
         Sleep(10);
      }

   EnterCriticalSection (&m_csTTSWaveDecompress);
   m_dwTTSWaveAnalyzing--;
   LeaveCriticalSection (&m_csTTSWaveDecompress);

}

/*************************************************************************************
TTSWaveCalcSRANALBLOCKThread - Thread used for each wave segment.
*/
static DWORD WINAPI TTSWaveCalcSRANALBLOCKThread(LPVOID lpParameter)
{
   PTHREADWAVECALCINFO pInfo = (PTHREADWAVECALCINFO) lpParameter;

   pInfo->pThis->TTSWaveCalcSRANALBLOCK (pInfo->dwInitial, pInfo->dwModulo);

   return 0;
}

/*************************************************************************************
CMTTS::TTSWaveCalcSRANALBLOCKCreateThreads - This creates several threads
used to calculate all the features.
*/
void CMTTS::TTSWaveCalcSRANALBLOCKCreateThreads (void)
{
   if (m_aThreadWaveCalcInfo[0].hThread)
      return;  // shouldnt happen

   DWORD dwThreads = 1; // HowManyProcessors ();
      // BUGFIX - Don't allocate one per processor, just one thread to do the background
      // processing

   // set up the threads
   DWORD i;
   for (i = 0; i < dwThreads; i++) {
      m_aThreadWaveCalcInfo[i].pThis = this;
      m_aThreadWaveCalcInfo[i].dwInitial = i;
      m_aThreadWaveCalcInfo[i].dwModulo = dwThreads;

      m_aThreadWaveCalcInfo[i].hThread = CreateThread (NULL, 0, TTSWaveCalcSRANALBLOCKThread, &m_aThreadWaveCalcInfo[i], 0, &m_aThreadWaveCalcInfo[i].dwThreadID);
      SetThreadPriority (m_aThreadWaveCalcInfo[i].hThread, VistaThreadPriorityHack(THREAD_PRIORITY_BELOW_NORMAL));  // so doesnt suck up all CPU
         // BUGFIX - Try lowest instead of THREAD_PRIORITY_BELOW_NORMAL because added Sleep(10)
         // BUGFIX - Was THREAD_PRIORITY_LOWEST, but would cause hang-ups in TTS if this has audio
         // checked out at same time wants to access
   }

}


/*************************************************************************************
CMTTS::TTSWaveFind - Find the required CTTSWave

inputs
   DWORD                dwSentenceNum - Sentence number
returns
   PCTTSWave - Wave, or NULL if can't find
*/
PCTTSWave CMTTS::TTSFindWave (DWORD dwSentenceNum)
{
   if (dwSentenceNum >= m_lPCTTSWave.Num())
      return NULL;
   PCTTSWave *ppTW = (PCTTSWave*)m_lPCTTSWave.Get(0);
   return ppTW[dwSentenceNum];
}



/*************************************************************************************
CMTTS::TTSWaveAdd - Adds audio to the wave segment.

inputs
   WORD           wFlags - Compression flags, to be stored in CTTSWaveSegment.m_wFlags
   PCM3DWave      pWave - Wave to use. Must have valid pitch and SRFEATUREs
                  If the wave is to store away PCM (wFlags contains TPMML_PCMCOMPRESSMASK)
                  then this wave must contain PCM, and can't merely be cached
   DWORD          dwSentenceNum - Sentence number.
   DWORD          dwFeatureStart - Feature to use
   DWORD          dwFeatureEnd - Up to this feature (exclusive)
   PSRFEATURE     pSRFToUse - If NULL then get features from pWave. If not, use features
                  from this, assuming that pSRFToUse[0] is from dwFeatureStart.
returns
   BOOL - TRUE if success of if already exists
*/
BOOL CMTTS::TTSWaveAdd (WORD wFlags, PCM3DWave pWave, DWORD dwSentenceNum, DWORD dwFeatureStart, DWORD dwFeatureEnd, PSRFEATURE pSRFToUse)
{
   // fill up to the sentence number
   PCTTSWave pTWNULL = NULL;
   while (m_lPCTTSWave.Num() <= dwSentenceNum)
      m_lPCTTSWave.Add (&pTWNULL);

   PCTTSWave *ppTW = (PCTTSWave*)m_lPCTTSWave.Get(0);
   if (!ppTW[dwSentenceNum]) {
      PCTTSWave pTW = new CTTSWave;
      if (!pTW)
         return FALSE;

      pTW->m_dwSentenceNum = dwSentenceNum;
      ppTW[dwSentenceNum] = pTW;
   }

   // pass it down
   return ppTW[dwSentenceNum]->Add (wFlags, pWave, dwFeatureStart, dwFeatureEnd, pSRFToUse);
}

/*************************************************************************************
CMTTS::TriPhonAudioeSet - Sets a new triphone. If the existing triphone exists, it
is overwritten (assuming flag is set to check for already exists).

Before calling this, you mus have called TTSWaveAdd(), probably indirectly through
another function. The audio for the phone's dwFeatureStart to dwFeatureEnd must exist

inputs
   DWORD             dwOrigWave - Original wave number. Useful for debugging
   DWORD             dwOrigPhone - Original phoneme index into th eoriginal wave
   DWORD             dwPhone - Phoneme to set
   DWORD             dwWord - Word this is specific to, or -1 if for all words
   WORD              wWordPos - Word position, 0=middle, 1=start,2=end
   BYTE              bPhoneLeft - Phoneme to the left
   BYTE              bPhoneRight - Phoneme to the right
   DWORD             dwFuncWordGroup - How much of a function word this is, from 0..NUMFUNCWORDGROUP(inclusive)
   BYTE              *pabRank - Array of TTSDEMIPHONE ranks. Rank, from 0..100, where 0 is the best-sounding version
   PMISMATCHINFO     paMMI - Array of TRIPHONEMISMATCH mismatch info for alternate recognition values for similar triphones
   DWORD             dwMismatchAccuracy - What units the paMMI info is in. 0 = phoneme group, 1 = unstressed phone, 2 = phone
   WORD              wFlags - Flags TPMML_XXX
   float             fOrigPitch - Original pitch in the unit taken
   float             fPitchDelta - Ratio of right pitch to left pitch
   float             fPitchBulge - How much pitch bulges up/down in center (ratio)
   float             fCenterEnergy - Calculated energy
   float             fLeftPitch - Pitch of left unit, or 0 if silence... LeftXXX and fEnergy (and fOrigPitch) are used to ensure continuity
   float             fLeftEnergy - Energy of left unit, or 0 if sielnce
   DWORD             dwLeftDuration - Duration of the left unit (in SRFEATUREs)
   DWORD             dwFeatureStart - Starting SRFEATURE in the wave
   DWORD             dwFeatureEnd - Ending SRFEATURE in the wave
//   PSRFEATURE        pSRF - Pointer to SRFeatures to set
//   float             *pafPitch - Array of dwNum pitch (in Hz) entries
//   DWORD             dwNum - Number
//   BOOL              fCanUseLeft - If TRUE, pSRF[-1] is valid and can be used to smoothing audio
//   BOOL              fCanUseRight - If TRUE, pSRF[dwNum] is valid and can be used for smoothing audio
   DWORD             dwTrimLeft - Number of SRFEATURE units can trim from left if all alone, 0..dwNum-1
   DWORD             dwTrimRight - Number of SRFEATURE units can trim from right if all alone, 0..dwNum-1
   fp                fMaxEnergyInWave - Maximum energy in the wave (from wave)
   fp                fMaxEnergyInWaveMod - Potentially modified some more
   PBYTE             pabPhoneContigous - Pointer to an array of the next 8 phonemes in the wave (excluding silence).
                     Phoneme numbers are +1. Use 0 to indicate blank/end-of-string
   BOOL              fCheckForExist - If TRUE, look for an existing one and replace
                     that, if FALSE just add on because know there wont be an existing one
returns
   BOOL - TRUE if success
*/
BOOL CMTTS::TriPhoneAudioSet (DWORD dwOrigWave, DWORD dwOrigPhone, DWORD dwPhone, DWORD dwWord,
                         WORD wWordPos, BYTE bPhoneLeft, BYTE bPhoneRight,
                         DWORD dwFuncWordGroup,
                         BYTE *pabRank, PMISMATCHINFO paMMI, DWORD dwMismatchAccuracy,
                         // WORD wFlags,
                         float fOrigPitch, float fPitchDelta, float fPitchBulge,
                         float fCenterEnergy, float fLeftPitch, float fLeftEnergy, DWORD dwLeftDuration,
                         DWORD dwFeatureStart, DWORD dwFeatureEnd,
//                         PSRFEATURE pSRF, float *pafPitch, DWORD dwNum,
//                         BOOL fCanUseLeft, BOOL fCanUseRight,
                         DWORD dwTrimLeft, DWORD dwTrimRight,
                         fp fMaxEnergyInWave,
                         fp fMaxEnergyInWaveMod,
                         PBYTE pabPhoneContigous,
                         BOOL fCheckForExist)
{
   // if derived dont allow
   if (m_fIsDerived)
      return FALSE;

   // make sure this audio exists
   PCTTSWave pTW = TTSFindWave (dwOrigWave);
   if (!pTW)
      return FALSE;
   PTTSFEATURECOMPEXTRA pTFCE;
   PSRFEATURE pSRFGot = pTW->GetSRFEATURE (&m_acsTTSWave[dwOrigWave % MAXRAYTHREAD], dwFeatureStart, dwFeatureEnd, NULL, NULL, &pTFCE);
   if (!pSRFGot)
      return FALSE;

   // get the list
   if (!MakeSureEnoughPhone(dwPhone))
      return FALSE;
   PCListFixed pl = m_palPCMTTSTriPhoneAudio[dwPhone];
   if (!pl) {
      pl = m_palPCMTTSTriPhoneAudio[dwPhone] = new CListFixed;
      if (!pl)
         return FALSE;
      pl->Init (sizeof(PCMTTSTriPhoneAudio));
   }

   // if checkforexist see if exists
   DWORD i;
   PCMTTSTriPhoneAudio pNew = NULL;
   if (fCheckForExist) {
      PCMTTSTriPhoneAudio *pptp = (PCMTTSTriPhoneAudio*)pl->Get(0);
      for (i = 0; i < pl->Num(); i++) {
         if (pptp[i]->m_dwWord != dwWord)
            continue;
         if ((pptp[i]->m_bPhoneLeft != bPhoneLeft) || (pptp[i]->m_bPhoneRight != bPhoneRight))
            continue;
         if (pptp[i]->m_wWordPos != wWordPos)
            continue;

         // else found a match
         pNew = pptp[i];
         break;
      } // i
   }

   if (!pNew) {
      // create
      pNew = new CMTTSTriPhoneAudio;
      if (!pNew)
         return FALSE;
      pl->Add (&pNew);
   }

   // set
   pNew->m_wOrigWave = (WORD)dwOrigWave;
   pNew->m_wOrigPhone = (WORD)dwOrigPhone;
   pNew->m_fReviewed = FALSE;
   pNew->m_dwWord = dwWord;
   pNew->m_bPhoneLeft = bPhoneLeft;
   pNew->m_bPhoneRight = bPhoneRight;
   memcpy (pNew->m_abRank, pabRank, sizeof(pNew->m_abRank));
   memcpy (pNew->m_aMMISpecific, paMMI, sizeof(pNew->m_aMMISpecific));
   pNew->m_dwMismatchAccuracy = dwMismatchAccuracy;
   pNew->m_wWordPos = wWordPos;
   //pNew->m_wFlags = wFlags;
   pNew->SRFEATURESet (this, dwOrigWave, dwFeatureStart, dwFeatureEnd, fMaxEnergyInWave, fMaxEnergyInWaveMod);

   DWORD dwNum = dwFeatureEnd - dwFeatureStart;
   pNew->m_fPitchLeft = pTFCE[dwNum/6].fPitch;
   pNew->m_fPitchCenter = pTFCE[dwNum/2].fPitch;
   pNew->m_fPitchRight = pTFCE[dwNum*5/6].fPitch;

   // caculate average energy
   // pNew->Decompress ();
   fp fEnergy = 0;
   // fp fScale = PHONESAMPLENORMALIZED / max(fMaxEnergyInWaveMod, 1.0);
   // PSRFEATURE psr = (PSRFEATURE) pNew->m_pmemSRFEATURE->p;
   DWORD dwNumSRFEATURE = dwFeatureEnd - dwFeatureStart;
   for (i = 0; i < dwNumSRFEATURE; i++) {
      fp fEnergyThis = SRFEATUREEnergy (FALSE, pSRFGot + i);
      // fEnergyThis *= fScale;
      fEnergy += fEnergyThis;
   } // i
   // BUGFIX - scale energy accoding to iAdd
   fEnergy *= (fp)DbToAmplitude(pNew->m_iFeatureAdd) / (fp)DbToAmplitude(0);

   pNew->m_fEnergyAvg = fEnergy / (fp)dwNumSRFEATURE;
   // pNew->Compress();

   pNew->m_fOrigPitch = fOrigPitch;
   pNew->m_dwFuncWordGroup = dwFuncWordGroup;
   pNew->m_fPitchDelta = fPitchDelta;
   pNew->m_fPitchBulge = fPitchBulge;
   pNew->m_dwTrimLeft = dwTrimLeft;
   pNew->m_dwTrimRight = dwTrimRight;

   pNew->m_fCenterEnergy = fCenterEnergy;
   pNew->m_fLeftPitch = fLeftPitch;
   pNew->m_fLeftEnergy = fLeftEnergy;
   pNew->m_dwLeftDuration = dwLeftDuration;

   memcpy (pNew->m_abPhoneContiguous, pabPhoneContigous, sizeof(pNew->m_abPhoneContiguous));

   pNew->CalcInfo (Lexicon());

   return TRUE;
}



/*************************************************************************************
CMTTS::TriPhoneProsSet - Sets a new triphone. If the existing triphone exists, it
is overwritten (assuming flag is set to check for already exists)

inputs
   DWORD             dwPhone - Phoneme to set
   WORD              wWordPos - Word position, 0=middle, 1=start,2=end
   BYTE              bPhoneLeft - Phoneme to the left
   BYTE              bPhoneRight - Phoneme to the right
   WORD              wAvgDuration - Average duration for the unit (in SRFEATURE length)
   short             iPitch - How much pitch of unit varies from word. 0 = no change,
                     1000 = 1 octave higher, -1000 = 1 octave lower, et.
   short             iPitchDelta - Change in pitch over the phoneme, same units as iPitch
   short             iPitchBulge - How much pitch bulges up/down in center, 1000 = 1 octave higher,
                        -1000 = 1 octave lower
   fp                fEnergyAvg - Average energy for the triphone... all phonemes should
                     be normalized to this average energy
returns
   BOOL - TRUE if success
*/
BOOL CMTTS::TriPhoneProsSet (DWORD dwPhone, WORD wWordPos, BYTE bPhoneLeft, BYTE bPhoneRight,
                         WORD wAvgDuration, short iPitch, short iPitchDelta, short iPitchBulge,
                         fp fEnergyAvg,
                         BOOL fCheckForExist)
{
   // if derived dont allow
   if (m_fIsDerived)
      return FALSE;

   // get the list
   if (!MakeSureEnoughPhone(dwPhone))
      return FALSE;
   PCListFixed pl = m_palPCMTTSTriPhonePros[dwPhone];
   if (!pl) {
      pl = m_palPCMTTSTriPhonePros[dwPhone] = new CListFixed;
      if (!pl)
         return FALSE;
      pl->Init (sizeof(PCMTTSTriPhonePros));
   }

   // if checkforexist see if exists
   DWORD i;
   PCMTTSTriPhonePros pNew = NULL;
   if (fCheckForExist) {
      PCMTTSTriPhonePros *pptp = (PCMTTSTriPhonePros*)pl->Get(0);
      for (i = 0; i < pl->Num(); i++) {
         if ((pptp[i]->m_bPhoneLeft != bPhoneLeft) || (pptp[i]->m_bPhoneRight != bPhoneRight))
            continue;
         if (pptp[i]->m_wWordPos != wWordPos)
            continue;

         // else found a match
         pNew = pptp[i];
         break;
      } // i
   }

   if (!pNew) {
      // create
      pNew = new CMTTSTriPhonePros;
      if (!pNew)
         return FALSE;
      pl->Add (&pNew);
   }

   // set
   pNew->m_bPhoneLeft = bPhoneLeft;
   pNew->m_bPhoneRight = bPhoneRight;
   pNew->m_wWordPos = wWordPos;
   pNew->m_wDuration = wAvgDuration;
   pNew->m_iPitch = iPitch;
   pNew->m_iPitchDelta = iPitchDelta;
   pNew->m_iPitchBulge = iPitchBulge;
   pNew->m_fEnergyAvg = fEnergyAvg;

   pNew->CalcInfo (Lexicon());

   return TRUE;
}


/*************************************************************************************
CMTTS::TriPhoneClearWord - This looks through all the triphones and clears out
any entries specific to a given word. Use this when retraining a word

inputs
   DWORD             dwWord - Word that looking for
returns
   none
*/
void CMTTS::TriPhoneClearWord (DWORD dwWord)
{
   // NOTE: Dont bother with the prosody equivalent

   // if is derived dont allow
   if (m_fIsDerived)
      return;

   DWORD i, dwPhone;
   for (dwPhone = 0; dwPhone < m_dwNumPhone; dwPhone++) {
      PCListFixed pl = m_palPCMTTSTriPhoneAudio[dwPhone];
      if (!pl)
         continue;
      if (!pl->Num())
         continue;

      PCMTTSTriPhoneAudio *pptp = (PCMTTSTriPhoneAudio*)pl->Get(0);
      for (i = pl->Num()-1; i < pl->Num(); i--) {
         if (pptp[i]->m_dwWord == -1)
            continue;

         if (pptp[i]->m_dwWord != dwWord)
            continue;

         // else found a match
         delete pptp[i];
         pl->Remove (i);
      } // i
   } // dwPhone

   // done
}



/*************************************************************************************
CMTTS::SynthUnitCanSkip - Call this to see if the synth unit can skip on the left/right.

inputs
   DWORD                dwDemiPhone - Demiphone that this is for, from 0..TTSDEMIPHONES-1
   PCMTTSTriPhoneAudio   pCenter - Central unit to synthesize. If NULL then silence
   PCMTTSTriPhoneAudio   pLeft - Left unit or NULL (full phone, not just demiphone over)
   PCMTTSTriPhoneAudio   pLeftDemi - Demiphone over
   PCMTTSTriPhoneAudio   pRight - Right unit or null (full phone, not just demiphone over)
                        NOTE: pLeft and pRight must have ->Decompress() called before doing this
   BYTE                 bPhoneCenter - Phoneme in the center
   BYTE                 bPhoneLeft - Phoneme on the left (not just a demiphone over)
   BYTE                 bPhoneRight - Phoneme on the right (not just a demiphone over)
returns
   DWORD - Bit flag with 0x01 if can skip on left, 0x02 if skip on right,
            0x04 if need to use phase on left for blending(before start of this unit), 0x08 use phase on right for blending(at start of this unit)
*/

// BUGFIX - Because blending with SRDETAILEDPHASE, DON'T define ONLYPHASEONNONPLOSIVE
// #define ONLYPHASEONNONPLOSIVE          // if defined then only ask for phase blend on non-plosives

DWORD CMTTS::SynthUnitCanSkip (DWORD dwDemiPhone,
                               PCMTTSTriPhoneAudio pCenter,
                               PCMTTSTriPhoneAudio pLeft, PCMTTSTriPhoneAudio pLeftDemi,
                               PCMTTSTriPhoneAudio pRight,
                               BYTE bPhoneCenter, BYTE bPhoneLeft, BYTE bPhoneRight)
{
#ifdef NOMODS_CANSKIP
   return 0;   // cant skip
#endif

   PCMLexicon pLex = Lexicon ();
   PLEXPHONE plp;
   PLEXENGLISHPHONE ple;

   if (!pCenter)
      return 0;   // cant skip

   // BUGFIX - determine if can skip the left/right amount, to counteract segmentation vagueness
   BOOL fSkipLeft = pCenter->m_dwTrimLeft ? TRUE : FALSE;
   BOOL fBlendPhaseLeft = TRUE, fBlendPhaseRight=TRUE;
   if (!pLeft)
      fSkipLeft = FALSE;
   else if ((pLeft->m_wOrigWave == pCenter->m_wOrigWave) && (pLeft->m_wOrigPhone+1 == pCenter->m_wOrigPhone))
      fSkipLeft = FALSE;
   plp = pLex->PhonemeGetUnsort (bPhoneLeft);
   ple = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;
   if (!ple || (ple->dwCategory & PIC_PLOSIVE)) {
      fSkipLeft = FALSE;   // since if no trim then assume it's a plosive
      // BUGFIX - Dont do if (!dwDemiPhone)
      //   fBlendPhase = FALSE; // since can don't blend phase for plosive
   }

   // BUGFIX - need to take demiphone into account for phase
   if (!pLeftDemi)
      fBlendPhaseLeft = fBlendPhaseRight = FALSE;
   else if ((pLeftDemi->m_wOrigWave == pCenter->m_wOrigWave) && (pLeftDemi->m_wOrigPhone+(dwDemiPhone ? 0 : 1) == pCenter->m_wOrigPhone))
      fBlendPhaseLeft = fBlendPhaseRight = FALSE;  // adjacent, in same wave
   BYTE bPhoneLeftDemi = dwDemiPhone ? bPhoneCenter : bPhoneLeft;
   plp = pLex->PhonemeGetUnsort (bPhoneLeftDemi);
   ple = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;
#ifdef ONLYPHASEONNONPLOSIVE
   if (!ple || !(ple->dwCategory & PIC_VOICED) )
      fBlendPhaseLeft = FALSE; // dont blend for unvoiced

   // don't blend phase if this one isn't voiced
   if (fBlendPhaseRight) {
      plp = pLex->PhonemeGetUnsort (bPhoneCenter);
      ple = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;
      // BUGFIX - Dont do if (!ple || (ple->dwCategory & PIC_PLOSIVE))
      //    fBlendPhase = FALSE;   // since if no trim then assume it's a plosive
      if (!ple || !(ple->dwCategory & PIC_VOICED))
         fBlendPhaseRight = FALSE; // dont blend for unvoiced
   }
#endif

   BOOL fSkipRight = pCenter->m_dwTrimRight ? TRUE : FALSE;
   if (!pRight)
      fSkipRight = FALSE;
   else if ((pRight->m_wOrigWave == pCenter->m_wOrigWave) && (pRight->m_wOrigPhone == pCenter->m_wOrigPhone+1))
      fSkipRight = FALSE;
   plp = pLex->PhonemeGetUnsort (bPhoneRight);
   ple = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;
   if (!ple || (ple->dwCategory & PIC_PLOSIVE))
      fSkipRight = FALSE;   // since if no trim then assume it's a plosive

   return (fSkipLeft ? 0x01 : 0) | (fSkipRight ? 0x02 : 0) |
      (fBlendPhaseLeft ? 0x04 : 0) | (fBlendPhaseRight ? 0x08 : 0);
}



/*************************************************************************************
DetermineBlend - Determines how much to blend two units together.

inputs
   BOOL              fFullSRFEATURE - If TRUE, then psrfA and psrfB are full SRFEATURES.
                     If FALSE, they're SRFEATURESMALLs
   PSRFEATURE        psrfA - A feature, one to be modified
   PSRFEATURE        psrdB - B features, holding static
   fp                fScaleA - Amount that A is oringally scaled by
   fp                fScaleB - Amount that B is originally scaled by
   BOOL              fHalfWay - If TRUE, then all values in aiOctaveBend and afOctaveScale
                        will be halved/sqrted, assuming that the inverse transform will
                        be done for B
   int               *pafOctaveBend - Filled with an array of SROCTAVE integers, indicating the number of bins that the
                        psrfA is moved up/down by (per octave).
   fp                *pafOctaveScale - Filled with an array of SROCTAVE scaling, indicating how much
                        each octave is increased/decreased. fScakeA will automatically be incorporated
returns
   none
*/
void DetermineBlend (BOOL fFullSRFEATURE, PSRFEATURE psrfA, PSRFEATURE psrfB, fp fScaleA, fp fScaleB,
                            BOOL fHalfWay, fp *pafOctaveBend, fp *pafOctaveScale)
{
   DWORD i;

   fp afAMain[2][SRDATAPOINTS], afBMain[2][SRDATAPOINTS];
   fp afADelta[2][SRDATAPOINTS], afBDelta[2][SRDATAPOINTS];
   DWORD dwSweepMax = (SRPOINTSPEROCTAVE/2);
   DWORD dwSRDataPoints;
   if (fFullSRFEATURE) {
      dwSRDataPoints = SRDATAPOINTS;
      for (i = 0; i < SRDATAPOINTS; i++) {
         afAMain[0][i] = DbToAmplitude (psrfA->acVoiceEnergy[i]) * fScaleA;
         afAMain[1][i] = DbToAmplitude (psrfA->acNoiseEnergy[i]) * fScaleA;
         afBMain[0][i] = DbToAmplitude (psrfB->acVoiceEnergy[i]) * fScaleB;
         afBMain[1][i] = DbToAmplitude (psrfB->acNoiseEnergy[i]) * fScaleB;
      } // i

      memset (afADelta, 0, sizeof(afADelta));
      memset (afBDelta, 0, sizeof(afBDelta));
   }
   else {
      dwSweepMax /= SRSMALL;
      dwSRDataPoints = SRDATAPOINTSSMALL;

      PSRFEATURESMALL psrfAs = (PSRFEATURESMALL)psrfA;
      PSRFEATURESMALL psrfBs = (PSRFEATURESMALL)psrfB;

      for (i = 0; i < SRDATAPOINTSSMALL; i++) {
         afAMain[0][i] = DbToAmplitude (psrfAs->acVoiceEnergyMain[i]) * fScaleA;
         afAMain[1][i] = DbToAmplitude (psrfAs->acNoiseEnergyMain[i]) * fScaleA;
         afBMain[0][i] = DbToAmplitude (psrfBs->acVoiceEnergyMain[i]) * fScaleB;
         afBMain[1][i] = DbToAmplitude (psrfBs->acNoiseEnergyMain[i]) * fScaleB;

         afADelta[0][i] = DbToAmplitude (psrfAs->acVoiceEnergyDelta[i]) * fScaleA;
         afADelta[1][i] = DbToAmplitude (psrfAs->acNoiseEnergyDelta[i]) * fScaleA;
         afBDelta[0][i] = DbToAmplitude (psrfBs->acVoiceEnergyDelta[i]) * fScaleB;
         afBDelta[1][i] = DbToAmplitude (psrfBs->acNoiseEnergyDelta[i]) * fScaleB;
      } // i
   }

   // figure out values for each octave
   DWORD dwOctave;
#define MAXAMP          12
   for (dwOctave = 0; dwOctave < SROCTAVE; dwOctave++) {
      // do a sweep
      int iSweep;
      BOOL fFound = FALSE;
      fp fBest = 0;
      pafOctaveBend[dwOctave] = 0;  // default to no change
      pafOctaveScale[dwOctave] = fScaleA;
      fp fPow = 0.25 * pow((fp)(dwOctave+1) / (fp)(SROCTAVE), 2);
            // BUGFIX - Scale by (dwOctave+1)/SROCTAVE so bends more at lower
      for (iSweep = -(int)dwSweepMax; iSweep <= (int)dwSweepMax; iSweep++) {
         fp fEnergyA, fEnergyB;
         fp fCompare = SubSRFEATURECompare (
            dwSRDataPoints,
            afAMain[0], afAMain[1], afADelta[0], afADelta[1], (int)dwOctave * SRPOINTSPEROCTAVE, (int)(dwOctave+1)*SRPOINTSPEROCTAVE,
            afBMain[0], afBMain[1], afBDelta[0], afBDelta[1], (int)dwOctave * SRPOINTSPEROCTAVE + iSweep, (int)(dwOctave+1)*SRPOINTSPEROCTAVE + iSweep,
            &fEnergyA, &fEnergyB);

         // same-ness affected by energy difference between A and B
         fp fDelta = max(fEnergyA, CLOSE) / max(fEnergyB, CLOSE);
         fp fAmp = log10(fDelta)*20.0;
         fAmp = fabs(fAmp);

         // scale to determine total compre
         // make sure if needed to raise/lower more that 12 dB that 0 score
         // and if at edge of sweep then 0 score
         // but slight score if in center
         fCompare = fCompare * (1.0 - min(fAmp, MAXAMP) / (fp)MAXAMP);
         fCompare += pow(((int)dwSweepMax - abs(iSweep)) / (fp)dwSweepMax, fPow);  // so only roll off at the edges

         // if found match then keep
         if (!fFound || (fCompare > fBest)) {
            fBest = fCompare;
            fFound = TRUE;
            pafOctaveBend[dwOctave] = iSweep;
            pafOctaveScale[dwOctave] = fScaleA / fDelta;

            if (fHalfWay) {
               pafOctaveBend[dwOctave] /= 2.0;
               pafOctaveScale[dwOctave] = sqrt(pafOctaveScale[dwOctave]);
            }
         }
      }
   } // dwOctave

   // done
}

/*************************************************************************************
SRFEATUREBendAndScale - Applied both pitch band and scaling, copying the new
features over

inputs
   BOOL              fFullSRFEATURE - If TRUE, then psrfOrig and psrfMod are full SRFEATURES.
                     If FALSE, they're SRFEATURESMALLs
   PSRFEATURE        psrfOrig - Original
   PSRDETAILEDPHASE  pSDPOrig - Original detailed phase
   fp                *pafOctaveBend - Array of SROCTAVE bend amounts
   fp                *pafOctaveScale - Array of SROCTAVE scale amounts
   PSRFEATURE        psrfMod - Copy the modified information here
   PSRDETAILEDPHASE  pSDPMod - Filled in with modified detailed phase
returns
   none
*/
void SRFEATUREBendAndScale (BOOL fFullSRFEATURE, PSRFEATURE psrfOrig, PSRDETAILEDPHASE pSDPOrig,
                            fp *pafOctaveBend, fp *pafOctaveScale, PSRFEATURE psrfMod, PSRDETAILEDPHASE pSDPMod)
{
   // copy over intiially, since harmonic phase is the same
   if (pSDPOrig && pSDPMod)
      *pSDPMod = *pSDPOrig;

   DWORD dwSRPointPerOctave = SRPOINTSPEROCTAVE;
   DWORD dwSRDataPoints;
   PSRFEATURESMALL psrfOrigs, psrfMods;
   if (fFullSRFEATURE) {
      dwSRDataPoints = SRDATAPOINTS;

#ifdef _DEBUG
      psrfOrigs = psrfMods = NULL; // so dont use
#endif
      // copy over the phase, which doesn't exist in the small version
      memcpy (psrfMod->abPhase, psrfOrig->abPhase, sizeof(psrfOrig->abPhase));
   }
   else {
      dwSRPointPerOctave /= SRSMALL;
      dwSRDataPoints = SRDATAPOINTSSMALL;
      psrfOrigs = (PSRFEATURESMALL) psrfOrig;
      psrfMods = (PSRFEATURESMALL) psrfMod;
#ifdef _DEBUG
      psrfOrig = psrfMod = NULL; // so dont use
#endif
   }

   DWORD i;
   // figure out the locations or the original octaves, and their bends
   fp afOrig[SROCTAVE+1], afNew[SROCTAVE+1], afDeltaNew[SROCTAVE+1], afDeltaScale[SROCTAVE+1];
   for (i = 0; i < SROCTAVE+1; i++) {
      afOrig[i] = (fp)(i * dwSRPointPerOctave) + (fp)(dwSRPointPerOctave/2);
      afNew[i] = afOrig[i] + ((i < SROCTAVE) ? pafOctaveBend[i] : 0);
      if (i)
         afDeltaNew[i-1] = max(afNew[i] - afNew[i-1], CLOSE);
      if (i)
         afDeltaScale[i-1] = pafOctaveScale[i] - pafOctaveScale[i-1];
   }

   // loop over all the points
   fp f, fAlpha, fIndex, fScale;
   DWORD j;
   for (i = 0; i < dwSRDataPoints; i++) {
      // see where it is
      f = (fp)i;
      for (j = 0; j < SROCTAVE+1; j++)
         if (f <= afNew[j])
            break;
      j = min(j, SROCTAVE);   // so not too high

      // figure out the values
      if (!j) {
         // at the very top, above first element
         fAlpha = f / max(afNew[0],CLOSE);
         fIndex = fAlpha * afOrig[0];
         fScale = pafOctaveScale[0];
      }
      else if (j >= SROCTAVE) {
         fAlpha = (f - afNew[SROCTAVE-1]) / afDeltaNew[SROCTAVE-1];
         fIndex = fAlpha * (fp)dwSRPointPerOctave + afOrig[SROCTAVE-1];
         fScale = pafOctaveScale[SROCTAVE-1];
      }
      else {
         j--;
         fAlpha = (f - afNew[j]) / afDeltaNew[j];
         fIndex = fAlpha * (fp)dwSRPointPerOctave + afOrig[j];
         fScale = fAlpha * afDeltaScale[j] + pafOctaveScale[j];
      }


      DWORD dwIndex;
  
      if (!fFullSRFEATURE) {
         // interpolation version, but ends up blurring slightly
         DWORD dwIndex2;
         fp fOneMinus;
         // get value
         fIndex = max(fIndex, 0);
         fIndex = min(fIndex, dwSRDataPoints-1);
         dwIndex = (DWORD)fIndex;
         dwIndex2 = min(dwIndex+1, dwSRDataPoints-1);
         fAlpha = fIndex - (fp)dwIndex;
         fOneMinus = 1.0 - fAlpha;

         // values
         if (fFullSRFEATURE) {
            psrfMod->acVoiceEnergy[i] = AmplitudeToDb(
               (DbToAmplitude (psrfOrig->acVoiceEnergy[dwIndex]) * fOneMinus +
               DbToAmplitude (psrfOrig->acVoiceEnergy[dwIndex2]) * fAlpha) * fScale);
            psrfMod->acNoiseEnergy[i] = AmplitudeToDb(
               (DbToAmplitude (psrfOrig->acNoiseEnergy[dwIndex]) * fOneMinus +
               DbToAmplitude (psrfOrig->acNoiseEnergy[dwIndex2]) * fAlpha) * fScale);
         }
         else {
            psrfMods->acVoiceEnergyMain[i] = AmplitudeToDb(
               (DbToAmplitude (psrfOrigs->acVoiceEnergyMain[dwIndex]) * fOneMinus +
               DbToAmplitude (psrfOrigs->acVoiceEnergyMain[dwIndex2]) * fAlpha) * fScale);
            psrfMods->acNoiseEnergyMain[i] = AmplitudeToDb(
               (DbToAmplitude (psrfOrigs->acNoiseEnergyMain[dwIndex]) * fOneMinus +
               DbToAmplitude (psrfOrigs->acNoiseEnergyMain[dwIndex2]) * fAlpha) * fScale);
            psrfMods->acVoiceEnergyDelta[i] = AmplitudeToDb(
               (DbToAmplitude (psrfOrigs->acVoiceEnergyDelta[dwIndex]) * fOneMinus +
               DbToAmplitude (psrfOrigs->acVoiceEnergyDelta[dwIndex2]) * fAlpha) * fScale);
            psrfMods->acNoiseEnergyDelta[i] = AmplitudeToDb(
               (DbToAmplitude (psrfOrigs->acNoiseEnergyDelta[dwIndex]) * fOneMinus +
               DbToAmplitude (psrfOrigs->acNoiseEnergyDelta[dwIndex2]) * fAlpha) * fScale);
         }
      }
      else { // if fFullSRFEATURE
         // non-interpolated. no blurring. fast
         fIndex = floor(fIndex + 0.5);
         fIndex = max(fIndex, 0);
         fIndex = min(fIndex, dwSRDataPoints-1);
         dwIndex = (DWORD)fIndex;
         if (fFullSRFEATURE) {
            psrfMod->acVoiceEnergy[i] = AmplitudeToDb(
               DbToAmplitude (psrfOrig->acVoiceEnergy[dwIndex]) * fScale);
            psrfMod->acNoiseEnergy[i] = AmplitudeToDb(
               DbToAmplitude (psrfOrig->acNoiseEnergy[dwIndex]) * fScale);
         }
         else {
            psrfMods->acVoiceEnergyMain[i] = AmplitudeToDb(
               DbToAmplitude (psrfOrigs->acVoiceEnergyMain[dwIndex]) * fScale);
            psrfMods->acNoiseEnergyMain[i] = AmplitudeToDb(
               DbToAmplitude (psrfOrigs->acNoiseEnergyMain[dwIndex]) * fScale);
            psrfMods->acVoiceEnergyDelta[i] = AmplitudeToDb(
               DbToAmplitude (psrfOrigs->acVoiceEnergyDelta[dwIndex]) * fScale);
            psrfMods->acNoiseEnergyDelta[i] = AmplitudeToDb(
               DbToAmplitude (psrfOrigs->acNoiseEnergyDelta[dwIndex]) * fScale);
         }
      }
   } // i

#ifndef NOMODS_TURNOFFPHASEBEND
#if 0 // to test bending
   if (pSDPOrig) for (i = 0; i < SRDATAPOINTSDETAILED; i++) {
      // need a test to make sure this is changing stuff
      if (i < SRPHASENUM)
         pSDPMod->afHarmPhase[i][0] = pSDPMod->afHarmPhase[i][1] = 0.0; // mod on purpose
      fp fAngle = (fp)i / (fp)SRDATAPOINTSDETAILED * 2.0 * PI * 5.0;
      pSDPOrig->afVoicedPhase[i][0] = sin(fAngle);
      pSDPOrig->afVoicedPhase[i][1] = cos(fAngle);
   }
#endif
   // need to bend detailed phase too
   if (pSDPOrig && pSDPMod) for (i = 0; i < SRDATAPOINTSDETAILED; i++) {
      // see where it is
      f = (fp)i / (fp)SRDATAPOINTSDETAILED * (fp)dwSRDataPoints;
      for (j = 0; j < SROCTAVE+1; j++)
         if (f <= afNew[j])
            break;
      j = min(j, SROCTAVE);   // so not too high

      // figure out the values
      if (!j) {
         // at the very top, above first element
         fAlpha = f / max(afNew[0],CLOSE);
         fIndex = fAlpha * afOrig[0];
      }
      else if (j >= SROCTAVE) {
         fAlpha = (f - afNew[SROCTAVE-1]) / afDeltaNew[SROCTAVE-1];
         fIndex = fAlpha * (fp)dwSRPointPerOctave + afOrig[SROCTAVE-1];
      }
      else {
         j--;
         fAlpha = (f - afNew[j]) / afDeltaNew[j];
         fIndex = fAlpha * (fp)dwSRPointPerOctave + afOrig[j];
      }

      // need to scale the index
      fIndex *= (fp)SRDATAPOINTSDETAILED / (fp)dwSRDataPoints;


      DWORD dwIndex;
  

      // non-interpolated. no blurring. fast
      fIndex = floor(fIndex + 0.5);
      fIndex = max(fIndex, 0);
      fIndex = min(fIndex, SRDATAPOINTSDETAILED-1);
      dwIndex = (DWORD)fIndex;
      pSDPMod->afVoicedPhase[i][0] = pSDPOrig->afVoicedPhase[dwIndex][0];
      pSDPMod->afVoicedPhase[i][1] = pSDPOrig->afVoicedPhase[dwIndex][1];

#if 0
      // need a test to make sure this is changing stuff
      if (i < SRPHASENUM)
         pSDPMod->afHarmPhase[i][0] = pSDPMod->afHarmPhase[i][1] = 0.0;
      fp fAngle = (fp)i / (fp)SRDATAPOINTSDETAILED * 2.0 * PI * 5.0;
      pSDPMod->afVoicedPhase[i][0] = sin(fAngle);
      pSDPMod->afVoicedPhase[i][1] = cos(fAngle);
#endif
   } // i, bend phase
#endif
}


/*************************************************************************************
CMTTS::SythUnitCalcFeatureJoins - Calculate the feature joins (without doing any
actual join-error tests) for a unit.

inputs
   DWORD             dwDemiPhone - Demiphone to synthesize, from 0..TTSDEMIPHONES-1
   PCMTTSTriPhoneAudio  pTPA - Triphone
   DWORD             dwSkip - Skip values, from SynthUnitCanSkip()
   DWORD             *pdwLeft - Filled with left feature
   DWORD             *pdwRight - Filled with right feature
   DWORD             *pdwLeftIdeal - Filled with ideal left feature
   DWORD             *pdwRightIdeal - Filled with ideal eight feature
returns
   BOOL - TRUE if succes. FALSE if fails (such as NULL pTPA)
*/
BOOL CMTTS::SynthUnitCalcFeatureJoins (DWORD dwDemiPhone, PCMTTSTriPhoneAudio pTPA, DWORD dwSkip,
                                       DWORD *pdwLeft, DWORD *pdwRight,
                                       DWORD *pdwLeftIdeal, DWORD *pdwRightIdeal)
{
   // if silence then no joins
   if (!pTPA) {
      *pdwLeft = *pdwRight = *pdwLeftIdeal = *pdwRightIdeal = 0;
      return FALSE;
   }

   if (pTPA->m_dwFeatureStart >= pTPA->m_dwFeatureEnd) {
      *pdwLeft = *pdwRight = *pdwLeftIdeal = *pdwRightIdeal = pTPA->m_dwFeatureStart;
      return FALSE;
   }

   DWORD dwLeftIdeal = pTPA->m_dwFeatureStart;
   DWORD dwRightIdeal = pTPA->m_dwFeatureEnd;
   DWORD dwSize = pTPA->m_dwFeatureEnd - pTPA->m_dwFeatureStart;

   // BUGFIX - determine if can skip the left/right amount, to counteract segmentation vagueness
   BOOL fSkipLeft = (dwSkip & 0x01) ? TRUE : FALSE;
   BOOL fSkipRight = (dwSkip & 0x02) ? TRUE : FALSE;

   if (fSkipLeft)
      dwLeftIdeal += pTPA->m_dwTrimLeft;
   if (fSkipRight)
      dwRightIdeal -= pTPA->m_dwTrimRight;

   // which demiphone
   dwDemiPhone = dwDemiPhone % TTSDEMIPHONES;
   DWORD dwLeftToUse = pTPA->m_dwFeatureStart + dwSize * dwDemiPhone / TTSDEMIPHONES;
   DWORD dwRightToUse = pTPA->m_dwFeatureStart + dwSize * (dwDemiPhone+1) / TTSDEMIPHONES;
   // check for 0-length
   if (dwLeftToUse >= dwRightToUse) {
      dwRightToUse = dwLeftToUse + 1;

      // don't go beyond edge
      if (dwRightToUse > pTPA->m_dwFeatureEnd) {
         dwLeftToUse -= (dwRightToUse - pTPA->m_dwFeatureEnd);
         dwRightToUse = pTPA->m_dwFeatureEnd;
      }
   }

   *pdwLeft = dwLeftToUse;
   *pdwRight = dwRightToUse;
   *pdwLeftIdeal = (dwLeftToUse == pTPA->m_dwFeatureStart) ? dwLeftIdeal : dwLeftToUse;
   *pdwRightIdeal = (dwRightToUse == pTPA->m_dwFeatureEnd) ? dwRightIdeal : dwRightToUse;

   return TRUE;
}


/*************************************************************************************
CMTTS::SynthUnit - Synthesize a unit into a wave file.

inputs
   fp                fModDuration - If > 0/0, duration will be modified to exactly match
                     the duration in the original wave. 1.0 = full mods.
   DWORD             dwDemiPhone - Index into phonemes. Runs up to # of phonemes * TTSDEMIPHONES
   PCM3DWave         pWave - Wave to synthesize to. The SRFEATUREs must already
                        be allocated.
   PCListFixed       plSRDETAILEDPHASE - Pointer to list with an Array of SRDETAILEDPHASE, same as pWave->m_dwSRSamples. The same
                        portions of this is filled in as pWave->m_paSRSample. This may be expanded
   PCListFixed       plPitch - Pointer to a list with an Array of fp for pitch, in Hz, for ewach pWave->m_dwSRSamples.
                        This is initially filled in. Will be modified in place according to
                        the fSnapToPitch value. plPitch may be added to or removed

                        NOTE: I think has been changed to that it means the absolutely accurate pitch, and is initially
                        filled in with unknown values

   // fp                fSnapToPitch - How much to snap to the original pitch of the unit.
   //                      Use 0.0 for no snap, 1.0 for full snap
   PCMTTSTriPhoneAudio    pCenter - Central unit to synthesize. If NULL then silence
                        NOTE: pCenter must have pCenter->Deocompress() called before doing this
   PCMTTSTriPhonePros   pCenterPros - Prosody info of center, so know if need to scale energy
   DWORD             dwStart - Start time (in SR samples) to synthesize to. The
                        SR memory must already be allocated
   DWORD             dwEnd - End time in SR samples (exclusive) to synthesize to
   PCMTTSTriPhoneAudio    pLeft - Left unit. NULL if silence
   PCMTTSTriPhonePros   pLeftPros - Prosody info of left, so know if need to scale energy
   PCMTTSTriPhoneAudio    pRight - Right unit. NULL if sielnce
   PCMTTSTriPhonePros   pRightPros - Prosody info of right, so know if need to scale energy
                        NOTE: pLeft and pRight must have ->Decompress() called before doing this
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
   DWORD             dwSkip - Flags from SynthUnitCanSkip().
   DWORD             dwSkipLeft - Skip from the left
   DWORD             dwSkipRight - Skip from the right
   PCMTTSTriPhoneAudio  *ppLastTPAA - Initially fill this pointed-to-value in with NULL. SynthUnit() will update
                     it as necessary.
   PCMTTSTriPhoneAudio  *ppLastTPAB - Initially fill this pointed-to-value in with NULL. SynthUnit() will update
                     it as necessary.
   DWORD             *pdwLastFeatureA - Initially fill this pointed-to-value in with NULL. SynthUnit() will update
                     it as necessary.
   DWORD             *pdwLastFeatureB - Initially fill this pointed-to-value in with NULL. SynthUnit() will update
                     it as necessary.
   DWORD             *pdwLastTime - Initially fill this pointed-to-value in with NULL. SynthUnit() will update
                     it as necessary.returns
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   PSYNTHUNITJOININFO pSUJI - Precalulated join location for this demiphone
   PCListFixed       plPSOLASTRUCT - Has PSOLA information appended. Can be NULL.
   int               *piDurationMod - Filled in with the number of SRSAMPLES that the duration was increased or decreates
returns
   BOOL - TRUE if success
*/
BOOL CMTTS::SynthUnit (fp fModDuration,
                       DWORD dwDemiPhone, PCM3DWave pWave, PCListFixed plSRDETAILEDPHASE,
                       PCListFixed plPitch, // fp fSnapToPitch,
                       PCMTTSTriPhoneAudio pCenter, PCMTTSTriPhonePros pCenterPros,
                       DWORD dwStart, DWORD dwEnd,
                       PCMTTSTriPhoneAudio pLeft, PCMTTSTriPhonePros pLeftPros,
                       PCMTTSTriPhoneAudio pRight, PCMTTSTriPhonePros pRightPros,
                       PTTSVOICEMOD pVoiceMod,
                       DWORD dwSkip, DWORD dwSkipLeft, DWORD dwSkipRight,
                       PCMTTSTriPhoneAudio *ppLastTPAA, PCMTTSTriPhoneAudio *ppLastTPAB,
                       DWORD *pdwLastFeatureA, DWORD *pdwLastFeatureB, DWORD *pdwLastTime,
                       int iTTSQuality, PSYNTHUNITJOININFO pSUJI, PCListFixed plPSOLASTRUCT,
                       int *piDurationMod)
{
   *piDurationMod = 0;

   if ((dwEnd <= dwStart) || (dwEnd > pWave->m_dwSRSamples))
      return FALSE;

   PSRDETAILEDPHASE paSDP = (PSRDETAILEDPHASE) plSRDETAILEDPHASE->Get(0);
   fp *pafPitch = (fp*)plPitch->Get(0);

   DWORD dwDemiPhoneMod = dwDemiPhone % TTSDEMIPHONES;

   // determine how much need to scale center, left, and right
   fp fScaleCenter = 1, fScaleLeft = 1, fScaleRight = 1;
   if (pCenterPros && pCenter) {
      fScaleCenter = pCenterPros->m_fEnergyAvg / TriPhoneEnergy (pCenter);
      fScaleLeft = fScaleRight = fScaleCenter;
   }
   if (!dwDemiPhoneMod && pLeftPros && pLeft)   // BUGFIX only use pLeftPros here if start of demiphone
      fScaleLeft = pLeftPros->m_fEnergyAvg / TriPhoneEnergy (pLeft);
   if ((dwDemiPhoneMod == TTSDEMIPHONES-1) && pRightPros && pRight)  // BUGFIX - onlyuse pRightPros if end of demiphone
      fScaleRight = pRightPros->m_fEnergyAvg / TriPhoneEnergy (pRight);

   // BUGFIX - TTS coming out a bit quiet so make it louder
   fScaleCenter *= TTSOUTPUTVOLUMESCALE;
   fScaleRight *= TTSOUTPUTVOLUMESCALE;
   fScaleLeft *= TTSOUTPUTVOLUMESCALE;
   // BUGFIX

   // if all silence then easy
   DWORD i, j;
   if (!pCenter) {
      for (i = dwStart; i < dwEnd; i++) {
         PSRFEATURE psr = &pWave->m_paSRFeature[i];
         memset (psr,0, sizeof(*psr));

         for (j = 0; j < SRDATAPOINTS; j++)
            psr->acNoiseEnergy[j] = psr->acVoiceEnergy[j] = SRABSOLUTESILENCE;

      } // i

      // clear out phase
      memset (paSDP + dwStart, 0, (dwEnd - dwStart) * sizeof(SRDETAILEDPHASE));

      return TRUE;
   }

   // where are the joins for the left, center, and right?
   DWORD adwFeatureJoin[3][2];   // [0=left,1=center,2=right][0=left,1=right]
   DWORD adwFeatureJoinIdeal[3][2]; // like adwFeatureJoin, but ideal locations
   SynthUnitCalcFeatureJoins (dwDemiPhoneMod + TTSDEMIPHONES - 1 /* so modulo around */, pLeft, dwSkipLeft,
      &adwFeatureJoin[0][0], &adwFeatureJoin[0][1], &adwFeatureJoinIdeal[0][0], &adwFeatureJoinIdeal[0][1]);
   SynthUnitCalcFeatureJoins (dwDemiPhoneMod, pCenter, dwSkip,
      &adwFeatureJoin[1][0], &adwFeatureJoin[1][1], &adwFeatureJoinIdeal[1][0], &adwFeatureJoinIdeal[1][1]);
   SynthUnitCalcFeatureJoins (dwDemiPhoneMod + 1, pRight, dwSkipRight,
      &adwFeatureJoin[2][0], &adwFeatureJoin[2][1], &adwFeatureJoinIdeal[2][0], &adwFeatureJoinIdeal[2][1]);

   // look at history
   if (pLeft && pCenter && (*ppLastTPAA == pLeft) && (*ppLastTPAB == pCenter) && (*pdwLastTime + 1 == dwDemiPhone)) {
      // found a match for previous
      adwFeatureJoin[0][1] = adwFeatureJoinIdeal[0][1] = *pdwLastFeatureA;
      adwFeatureJoin[1][0] = adwFeatureJoinIdeal[1][0] = *pdwLastFeatureB;

#ifdef _DEBUG
      WCHAR szTemp[256];
      swprintf (szTemp, L"\r\nContinuing join from index %g,",
         (double)dwDemiPhone / 2.0 - 0.5);
      OutputDebugStringW (szTemp);
#endif
   }

   // see where the center unit joins up with the right
   if (pCenter && pRight && pSUJI && (pSUJI->dwBestA != (DWORD)-1) && (pSUJI->dwBestB != (DWORD)-1) ) {
      _ASSERTE (pSUJI);
      _ASSERTE (pSUJI->dwBestA != (DWORD)-1);
      _ASSERTE (pSUJI->dwBestB != (DWORD)-1);

#ifdef _DEBUG
      DWORD dwOldA = adwFeatureJoin[1][1];
      DWORD dwOldB = adwFeatureJoin[2][0];
#endif
      DWORD dwBestA, dwBestB;
      fp fJoinScore;

      dwBestA = pSUJI->dwBestA;
      dwBestB = pSUJI->dwBestB;
      fJoinScore = pSUJI->fJoinScore;

#if 0 // old code, not used because precalculated

      int iBestCompareQuality;
      int iJoinCompareQuality;
      if (iTTSQuality <= 0) {
         iBestCompareQuality = 1;
         iJoinCompareQuality = 0;
      }
      else if (    == 1) {
         iBestCompareQuality = 2;
         iJoinCompareQuality = 1;
      }
      else if (iTTSQuality == 2) {
         iBestCompareQuality = 3;
         iJoinCompareQuality = 2;
      }
      else {   // iTTSQUality >= 3
         iBestCompareQuality = 3;
         iJoinCompareQuality = 3;
      }

      // if have center phoneme and right phoneme, then ignore skip (because will get solved eventually)
      // and calculate the right error
      DWORD dwRangeA = (adwFeatureJoin[1][1] - adwFeatureJoin[1][0]) / 2;  // half a demiphone
      DWORD dwRangeB = (adwFeatureJoin[2][1] - adwFeatureJoin[2][0]) / 2; // half a demiphone
      dwRangeA = min(dwRangeA, MAXJOINRANGE);
      dwRangeB = min(dwRangeB, MAXJOINRANGE);
      DWORD dwHalfWindow = JOINHALFWINDOWSIZE;
      fJoinScore = JoinFindBest (&m_acsTTSWave[pCenter->m_wOrigWave % MAXRAYTHREAD], &m_acsTTSWave[pRight->m_wOrigWave % MAXRAYTHREAD],
         pCenter->m_wOrigWave, pRight->m_wOrigWave,
         adwFeatureJoin[1][1], adwFeatureJoin[2][0],
         dwRangeA, dwRangeB,
         adwFeatureJoinIdeal[1][1], adwFeatureJoinIdeal[2][1],
         dwHalfWindow,
         iBestCompareQuality, iBestCompareQuality,
         &dwBestA, &dwBestB);

#if 0 // to test
      dwBestA = adwFeatureJoinIdeal[1][1];
      dwBestB = adwFeatureJoinIdeal[2][0];
#endif
#endif // 0

      // only do if there's a join
      if ((adwFeatureJoin[1][1] != dwBestA) || (adwFeatureJoin[2][0] != dwBestB)) {
         // use these new values, and store them away for the next time that come around
         *pdwLastFeatureA = adwFeatureJoin[1][1] = max(adwFeatureJoin[1][0] + 1, dwBestA);
         *pdwLastFeatureB = adwFeatureJoin[2][0] = min(adwFeatureJoin[2][1] - 1, dwBestB);
         *ppLastTPAA = pCenter;
         *ppLastTPAB = pRight;
         *pdwLastTime = dwDemiPhone;


   #ifdef _DEBUG
         if ((dwOldA != adwFeatureJoin[1][1]) && (dwOldB != adwFeatureJoin[2][0])) {
            WCHAR szTemp[256];
            swprintf (szTemp, L"\r\nIn phoneme index %g, join score = %g",
               (double)dwDemiPhone / 2.0, (double)fJoinScore);
            OutputDebugStringW (szTemp);
            swprintf (szTemp, L"\r\n\tChanged border from wave %d sample %d to sample %d,",
               (int)pCenter->m_wOrigWave, (int)dwOldA, (int)adwFeatureJoin[1][1]);
            OutputDebugStringW (szTemp);
            swprintf (szTemp, L"\r\n\tand border from wave %d sample %d to sample %d,",
               (int)pRight->m_wOrigWave, (int)dwOldB, (int)adwFeatureJoin[2][0]);
            OutputDebugStringW (szTemp);
         }
   #endif
      } // if there's a joing
   }


#if 0 // no loger used
   if (pCenter)
      pCenter->CalcEnergyIfNecessary();

   // figure out how much to scale at beginning/end
   fp fScaleStart = fScaleCenter, fScaleEnd = fScaleCenter;
   fp fAverage;
   if (pLeft) {
      fAverage = (pLeft->m_fEnergyEnd * fScaleLeft + pCenter->m_fEnergyStart * fScaleCenter)/2.0;
      fAverage = max(fAverage, CLOSE);
      fScaleStart = fAverage / max(pCenter->m_fEnergyStart, CLOSE);

      // BUGFIX - if adjacent then return scale start to center
      if ((pLeft->m_wOrigWave == pCenter->m_wOrigWave) && (pLeft->m_wOrigPhone+(dwDemiPhone ? 0 : 1) == pCenter->m_wOrigPhone))
         fScaleStart = fScaleCenter;
   }
   fScaleStart = log10(fScaleStart)*20.0;

   if (pRight) {
      fAverage = (pCenter->m_fEnergyEnd * fScaleCenter + pRight->m_fEnergyStart * fScaleRight)/2.0;
      fAverage = max(fAverage, CLOSE);
      fScaleEnd = fAverage / max(pCenter->m_fEnergyEnd, CLOSE);

      // BUGFIX - if adjacent then return scale start to center
      if ((pRight->m_wOrigWave == pCenter->m_wOrigWave) && (pRight->m_wOrigPhone == pCenter->m_wOrigPhone+((dwDemiPhone == TTSDEMIPHONES-1) ? 1 : 0) ))
         fScaleEnd = fScaleCenter;
   }
   fScaleEnd = log10(fScaleEnd)*20.0;

#define MAXDBCHANGE        3           // BUGFIX - Was 6, but affects volumes of phones too much
   // dont allow to scale too much
   fScaleStart = min(fScaleStart, MAXDBCHANGE);
   fScaleStart = max(fScaleStart, -MAXDBCHANGE);
   fScaleEnd = min(fScaleEnd, MAXDBCHANGE);
   fScaleEnd = max(fScaleEnd, -MAXDBCHANGE);
#endif // 0

   // figure out the features
   DWORD dwNumFeat;
   BOOL fToLeft;
   PTTSFEATURECOMPEXTRA pTFCA;
   CMem memCenter, memLeft, memRight;
   PSRFEATURE pSROrig = pCenter->SRFEATUREGetRange (this, &memCenter,
      adwFeatureJoin[1][0], adwFeatureJoin[1][1], &dwNumFeat, &fToLeft, NULL, &pTFCA);
   if (!pSROrig || !dwNumFeat)
      return FALSE;

   DWORD dwNewEnd = dwEnd;
   DWORD dwOldEnd = dwEnd;
   if (fModDuration) {
      // NOTE: This may mess up transplanted prosody with absolute durations
      dwNewEnd = dwStart + (adwFeatureJoin[1][1] - adwFeatureJoin[1][0]);
      dwNewEnd = (DWORD) floor(fModDuration * (fp)dwNewEnd + (1.0 - fModDuration) * (fp)dwOldEnd + 0.5);
   }
   if (dwNewEnd != dwOldEnd) {
      // if have changed the length of the unit, then need to do a LOT of repair work
      dwEnd = dwNewEnd;
      DWORD dwSamplesOld = pWave->m_dwSamples;
      DWORD dwSRSamplesOld = pWave->m_dwSRSamples;
      DWORD dwPitchSamplesOld = pWave->m_adwPitchSamples[PITCH_F0];

      // wave
#if 0 // no point moving the wave info since will all be overwritten
      if (dwNewEnd < dwOldEnd) {
         // move down
         memmove (
            pWave->m_psWave + pWave->m_dwChannels * pWave->m_dwSRSkip * dwNewEnd,
            pWave->m_psWave + pWave->m_dwChannels * pWave->m_dwSRSkip * dwOldEnd,
            sizeof(short) * pWave->m_dwChannels * max((int)dwSamplesOld - (int)pWave->m_dwSRSkip * (int)dwOldEnd, 0));

         if (pWave->m_paSRFeature)
            memmove (
               pWave->m_paSRFeature + dwNewEnd,
               pWave->m_paSRFeature + dwOldEnd,
               sizeof(SRFEATURE) * max((int)dwSRSamplesOld - (int)dwOldEnd, 0));

         if (pWave->m_apPitch[PITCH_F0])
            memmove (
               pWave->m_apPitch[PITCH_F0] + pWave->m_dwChannels * dwNewEnd,
               pWave->m_apPitch[PITCH_F0] + pWave->m_dwChannels * dwOldEnd,
               sizeof(WVPITCH) * pWave->m_dwChannels * max((int)dwPitchSamplesOld - (int)dwOldEnd, 0));
      }
#endif // 0
      
      // change the memory
      pWave->Allocate ( (DWORD)((int)pWave->m_dwSamples + (int)pWave->m_dwSRSkip * ((int)dwNewEnd - (int)dwOldEnd)) );

      // move up
#if 0 // no point moving the wave info since will all be overwritten
      if (dwNewEnd > dwOldEnd) {
         // move up
         memmove (
            pWave->m_psWave + pWave->m_dwChannels * pWave->m_dwSRSkip * dwNewEnd,
            pWave->m_psWave + pWave->m_dwChannels * pWave->m_dwSRSkip * dwOldEnd,
            sizeof(short) * pWave->m_dwChannels * max((int)dwSamplesOld - (int)pWave->m_dwSRSkip * (int)dwOldEnd, 0));

         if (pWave->m_paSRFeature)
            memmove (
               pWave->m_paSRFeature + dwNewEnd,
               pWave->m_paSRFeature + dwOldEnd,
               sizeof(SRFEATURE) * max((int)dwSRSamplesOld - (int)dwOldEnd, 0));

         if (pWave->m_apPitch[PITCH_F0])
            memmove (
               pWave->m_apPitch[PITCH_F0] + pWave->m_dwChannels * dwNewEnd,
               pWave->m_apPitch[PITCH_F0] + pWave->m_dwChannels * dwOldEnd,
               sizeof(WVPITCH) * pWave->m_dwChannels * max((int)dwPitchSamplesOld - (int)dwOldEnd, 0));
      }
#endif // 0

      // detailed phase
      // don't bother copying stuff that move since nothing in it yet
      if (dwNewEnd > dwOldEnd) {
         SRDETAILEDPHASE sdp;
         memset (&sdp, 0, sizeof(sdp));
         for (i = 0; i < (dwNewEnd - dwOldEnd); i++)
            plSRDETAILEDPHASE->Add (&dwNewEnd);
      }
      else
         plSRDETAILEDPHASE->Truncate (plSRDETAILEDPHASE->Num() - (dwOldEnd - dwNewEnd));  // shrink
      // refresh value
      paSDP = (PSRDETAILEDPHASE) plSRDETAILEDPHASE->Get(0);

      // pitch (
      if (dwNewEnd > dwOldEnd) {
         fp fPitchUnk = pafPitch[dwStart];
         for (i = 0; i < (dwNewEnd - dwOldEnd); i++)
            plPitch->Add (&fPitchUnk);
      }
      else
         plPitch->Truncate (plPitch->Num() - (dwOldEnd - dwNewEnd));  // shrink
      // refresh value
      pafPitch = (fp*) plPitch->Get(0);

      // others
      *piDurationMod = (int)dwNewEnd - (int)dwOldEnd;
   }

   // get psola
   if (plPSOLASTRUCT) {
      PCTTSWave pTTSWave = TTSFindWave (pCenter->m_wOrigWave);
      DWORD dwPrior, dwAfter;
      PTTSFEATURECOMPEXTRA pTFCE;
      short *psWave;
      PSRFEATURE pSRFeature = pTTSWave ? pTTSWave->GetSRFEATURE (
         &m_acsTTSWave[pCenter->m_wOrigWave % MAXRAYTHREAD],
         adwFeatureJoin[1][0], adwFeatureJoin[1][1],
         &dwPrior, &dwAfter, &pTFCE, &psWave) : NULL;
      PCTTSWaveSegment pWaveSeg = pTTSWave ? pTTSWave->Find (adwFeatureJoin[1][0], adwFeatureJoin[1][1]) : NULL;

      if (pSRFeature && psWave && pWaveSeg) {
         // found PSOLA info
         PSOLASTRUCT PS;
         memset (&PS, 0, sizeof(PS));
         PS.dwFeatureStartSrc = dwPrior;
         PS.dwFeatureEndSrc = PS.dwFeatureStartSrc + (adwFeatureJoin[1][1] - adwFeatureJoin[1][0]);

         // make sure if modifying duration that end up being same length
         _ASSERTE ((fModDuration < 1.0) || ((PS.dwFeatureEndSrc - PS.dwFeatureStartSrc) == (dwEnd - dwStart)));

         PS.dwNumSRFEATURE = PS.dwFeatureEndSrc + dwAfter;
         PS.dwSRSkip = pWaveSeg->m_dwSRSkipUp;
         PS.dwSamplesPerSec = pWaveSeg->m_dwSamplesPerSecUp;
         PS.pasWave = psWave - dwPrior * pWaveSeg->m_dwSRSkipUp;
         PS.paTFCE = pTFCE - dwPrior;
         PS.iFeatureStartDest = (int)dwStart;
         PS.iFeatureEndDest = (int)dwEnd;

         plPSOLASTRUCT->Add (&PS);
      }
   }

   // while at it, figure out the features in the left/right contexts too
   DWORD dwNumFeatLeft = 0, dwNumFeatRight = 0;
   PSRFEATURE pSROrigLeft = NULL, pSROrigRight = NULL;
   if (pLeft)
      pSROrigLeft = pLeft->SRFEATUREGetRange (this, &memLeft,
         adwFeatureJoin[0][0], adwFeatureJoin[0][1], &dwNumFeatLeft, NULL, NULL, NULL);
   if (pRight)
      pSROrigRight = pRight->SRFEATUREGetRange (this, &memRight,
         adwFeatureJoin[2][0], adwFeatureJoin[2][1], &dwNumFeatRight, NULL, NULL, NULL);

   // determine how much to blend between left and right
   fp afOctaveBend[3][SROCTAVE];
   fp afOctaveScale[3][SROCTAVE];
   for (i = 0; i < SROCTAVE; i++) {
      afOctaveBend[0][i] = afOctaveBend[1][i] = 0;
      afOctaveScale[0][i] = afOctaveScale[1][i] = fScaleCenter;
   }

#ifndef NOMODS_BLENDUNITS
   // figure amount to blend by
   if (pSROrigLeft && dwNumFeatLeft)
      DetermineBlend (TRUE, pSROrig+0, pSROrigLeft+(dwNumFeatLeft-1), fScaleCenter, fScaleLeft,
         TRUE, afOctaveBend[0], afOctaveScale[0]);
   if (pSROrigRight && dwNumFeatRight)
      DetermineBlend (TRUE, pSROrig+(dwNumFeat-1), pSROrigRight+0, fScaleCenter, fScaleRight,
         TRUE, afOctaveBend[1], afOctaveScale[1]);
#endif


   // limit the scaling
#define MAXSCALE        2.0      // how much can add/remove to energy of formants
   fp fScaleMax = fScaleCenter * MAXSCALE;
   fp fScaleMin = fScaleCenter / MAXSCALE;
   for (j = 0; j < 2; j++) for (i = 0; i < SROCTAVE; i++) {
      afOctaveScale[j][i] = max(afOctaveScale[j][i], fScaleMin);
      afOctaveScale[j][i] = min(afOctaveScale[j][i], fScaleMax);
   }

   // do non-linear scaling, causing areas of the voice with high energy deltas
   // to be kept un-stretched as much as possible
   CMem memStretch;
   DWORD dwNewLength = dwEnd - dwStart;
   if (!memStretch.Required ((dwNumFeat * 2 + dwNewLength) * sizeof(fp)))
      return FALSE;
   fp *pafStretchEnergy = (fp*)memStretch.p;
   fp *pafStretchDelta = pafStretchEnergy + dwNumFeat;
   fp *pafStretchAlpha = pafStretchDelta + dwNumFeat;
   fp fEnergyMax = CLOSE;
   for (i = 0; i < dwNumFeat; i++) {
      pafStretchEnergy[i] = SRFEATUREEnergy (FALSE, pSROrig + i);
      fEnergyMax = max(fEnergyMax, pafStretchEnergy[i]);
   }
   fp fDeltaSum = 0;
   fp fDeltaMax = 0;
   for (i = 0; i < dwNumFeat; i++) {
      fp fDelta = 0;
      if (i)
         fDelta = max(fDelta, fabs(pafStretchEnergy[i-1] - pafStretchEnergy[i]));
      if (i+1 < dwNumFeat)
         fDelta = max(fDelta, fabs(pafStretchEnergy[i+1] - pafStretchEnergy[i]));

      pafStretchDelta[i] = fDelta;
      fDeltaSum += fDelta;
      fDeltaMax = max(fDeltaMax, fDelta);
   } // i
   // normalize deltas
   for (i = 0; i < dwNumFeat; i++)
      if (fDeltaMax) // was fDeltaSum
         pafStretchDelta[i] /= fDeltaMax; // was fDelta Sum
      else
         pafStretchDelta[i] = 0; // since all the same, no change
   // determine weighting
   fDeltaSum = 0;
   fDeltaMax /= fEnergyMax;
   for (i = 0; i < dwNumFeat; i++) {
      if (dwNewLength >= 2)
         pafStretchEnergy[i] = ((fp)dwNumFeat - (fp)dwNewLength) / (fp)(dwNewLength-1);
      else
         pafStretchEnergy[i] = 1;
      pafStretchEnergy[i] = pafStretchEnergy[i] * pafStretchDelta[i] * fDeltaMax + 1.0;
      pafStretchEnergy[i] = max(pafStretchEnergy[i], CLOSE);   // always some

      fDeltaSum += pafStretchEnergy[i];
   }
   // fill in representeed location
   fp fCurAlpha;
   for (i = 0, fCurAlpha = 0; i < dwNumFeat; i++) {
      pafStretchDelta[i] = fCurAlpha / fDeltaSum;  // so this will go from 0..1
      fCurAlpha += pafStretchEnergy[i];
   }
   // fill in the alpha values for the offset
   for (i = 0; i < dwNewLength; i++) {
#ifdef NOMODS_STRETCH
      pafStretchAlpha[i] = (fp)i / (fp)dwNewLength * (fp)dwNumFeat;
#else
      fCurAlpha = (fp)i / (fp)dwNewLength;
      for (j = 1; j < dwNumFeat; j++)
         if (fCurAlpha < pafStretchDelta[j])
            break;

      // write new values
      fp fLow = pafStretchDelta[j-1];
      fp fHigh = (j < dwNumFeat) ? pafStretchDelta[j] : 1.0;
      pafStretchAlpha[i] = (fp)(j-1) + (fCurAlpha - fLow) / (fHigh - fLow);
#endif

      // if modifying duration, no stretch whatsoever, since want exact copy
      if (fModDuration) {
         fp fNoMod = (fp)i / (fp)dwNewLength * (fp)dwNumFeat;
         pafStretchAlpha[i] = (1.0 - fModDuration) * pafStretchAlpha[i] + fModDuration * fNoMod;
         continue;
      }

   } // i

   SRDETAILEDPHASE SDP;
   fp fPitchThis;

   for (i = dwStart; i < dwEnd; i++) {
      // determine the current scaling/bending
      fp fAlpha = (dwEnd-dwStart-1) ? ((fp)(i - dwStart) / (fp)(dwEnd - dwStart - 1)) : 0.5;;
      fp fOneMinus = 1.0 - fAlpha;
      for (j = 0; j < SROCTAVE; j++) {
         afOctaveBend[2][j] = afOctaveBend[0][j] * fOneMinus + afOctaveBend[1][j] * fAlpha;
         afOctaveScale[2][j] = afOctaveScale[0][j] * fOneMinus + afOctaveScale[1][j] * fAlpha;
      } // j

      PSRFEATURE psr = &pWave->m_paSRFeature[i];


      // BUGFIX - Was doing interpolation of features based on alpha, but
      // took out because when interpolate two adjacent features they end
      // up loosing some of their clarity, resulting in over-all lower quality
      // of couse, the method of just skipping will fall apart if speak very
      // slowly (> 2x) but not likely
      DWORD dwOffset;
      //fAlpha = (fp)(i-dwStart) / (fp)(dwEnd-dwStart); // BUFIX - Was dwEnd-dwStart-1
      //dwOffset = (i-dwStart) * dwNumFeat / (dwEnd - dwStart);
      dwOffset = floor(pafStretchAlpha[i-dwStart] + 0.5);
      dwOffset = min(dwOffset, dwNumFeat-1);

      // make sure offset is increasing by one if modifying duration to exact match
      _ASSERTE ((fModDuration < 1.0) || (dwOffset == i - dwStart));

      // extract the phase information from the original
#ifdef NOMODS_INTERPPHASEDETAILED
      SRDETAILEDPHASEFromSRFEATURE (pSROrig + dwOffset, pTFCA[dwOffset].fPitch, &SDP);
      fPitchThis = pTFCA[dwOffset].fPitch;
#else
      SRDETAILEDPHASE SDP2;
      DWORD dwLeft = (DWORD)pafStretchAlpha[i-dwStart];
      DWORD dwRight = min(dwLeft+1, dwNumFeat-1);
      fAlpha =  pafStretchAlpha[i-dwStart] - (fp)dwLeft;
      fOneMinus = 1.0 - fAlpha;

      SRDETAILEDPHASEFromSRFEATURE (pSROrig + dwLeft, pTFCA[dwLeft].fPitch, &SDP);
      SRDETAILEDPHASEFromSRFEATURE (pSROrig + dwRight, pTFCA[dwRight].fPitch, &SDP2);

      fPitchThis = fOneMinus * pTFCA[dwLeft].fPitch + fAlpha * pTFCA[dwRight].fPitch;

      // interpolte
      for (j = 0; j < SRPHASENUM; j++) {
         SDP.afHarmPhase[j][0] = fOneMinus * SDP.afHarmPhase[j][0] + fAlpha * SDP2.afHarmPhase[j][0];
         SDP.afHarmPhase[j][1] = fOneMinus * SDP.afHarmPhase[j][1] + fAlpha * SDP2.afHarmPhase[j][1];
      }
      for (j = 0; j < SRDATAPOINTSDETAILED; j++) {
         SDP.afVoicedPhase[j][0] = fOneMinus * SDP.afVoicedPhase[j][0] + fAlpha * SDP2.afVoicedPhase[j][0];
         SDP.afVoicedPhase[j][1] = fOneMinus * SDP.afVoicedPhase[j][1] + fAlpha * SDP2.afVoicedPhase[j][1];
      }
#endif

#ifdef NOMODS_BLENDUNITS
      memcpy (psr, pSROrig+dwOffset, sizeof(*psr));
      memcpy (paSDP + i, &SDP, sizeof(SDP)); // BUGFIX
#else
      // BUGFIX - Do blend
      SRFEATUREBendAndScale (TRUE, pSROrig + dwOffset, &SDP, afOctaveBend[2], afOctaveScale[2], psr, paSDP + i);

      // copy over the PCM
      psr->bPCMHarmFadeStart = pSROrig[dwOffset].bPCMHarmFadeStart;
      psr->bPCMHarmFadeFull = pSROrig[dwOffset].bPCMHarmFadeFull;
      psr->bPCMHarmNyquist = pSROrig[dwOffset].bPCMHarmNyquist;
      psr->bPCMFill = pSROrig[dwOffset].bPCMFill;
      psr->fPCMScale = pSROrig[dwOffset].fPCMScale;

#ifdef SRFEATUREINCLUDEPCM_SHORT
      memcpy (psr->asPCM, pSROrig[dwOffset].asPCM, sizeof(psr->asPCM));
#else
      memcpy (psr->acPCM, pSROrig[dwOffset].acPCM, sizeof(psr->acPCM));
#endif

#endif

#ifdef NOMODS_DISABLEPCM
      memset (psr->acPCM, 0, sizeof(psr->acPCM));
      psr->bPCMFill = psr->bPCMHarmFadeFull = psr->bPCMHarmFadeStart = psr->bPCMHarmNyquist = 0;
      psr->fPCMScale = 0;
#endif

#ifndef NOMODS_INTERPPHASE
      // BUGFIX - Interpolate the phase... try this since it seems that when
      // stretch/shrink segments, the phase is messed up
      // I can't hear the difference, but it does show up as minor changes
      // on the spectrogram
      fp fOffset;
      fOffset = pafStretchAlpha[i-dwStart]; // fAlpha * (fp)dwNumFeat;
      dwOffset = (DWORD)floor(fOffset);
      fOffset -= (fp)dwOffset;
      if (dwOffset + 1 < dwNumFeat) {
         fp af[2];
         af[0] = 1.0 - fOffset;
         af[1] = fOffset;
         SRFEATUREInterpolatePhase (pSROrig + dwOffset, 2, af, psr);
      }
#endif

#if 0 // old code - take out blurring in time because it ends up blurring the
      // formants and reducing the overall quality of the audio

      // figure out weighting
      // fp fOffset, fAlpha;
      if ((dwNumFeat == 1) || (dwEnd-dwStart == 1))
         fOffset = fAlpha = 0;
      else {
         fAlpha = (fp)(i-dwStart) / (fp)(dwEnd-dwStart-1);
         fOffset = fAlpha * (fp)(dwNumFeat-1);
      }

      // if 0 offset then just copy
      if (fOffset == 0)
         memcpy (psr, pSROrig+0, sizeof(*psr));
      else if (fOffset+1 >= dwNumFeat)
         memcpy (psr, pSROrig+(dwNumFeat-1), sizeof(*psr));
      else {
         int iOffset = (int)floor(fOffset);
         fOffset -= (fp)iOffset;
         SRFEATUREInterpolate (pSROrig + iOffset, pSROrig + (iOffset+1), 1.0 - fOffset, psr);
      }
#endif // 0

#if 0 // no longer need to scale since doing it in SRFEATUREBendAndScale
      // scale by given db
      int iScale = (int)((1.0 - fAlpha) * fScaleStart + fAlpha * fScaleEnd);
      if (iScale) for (j = 0; j < SRDATAPOINTS; j++) {
         int iTemp;

         iTemp = iScale + (int)psr->acVoiceEnergy[j];
         iTemp = max(iTemp, -127);
         iTemp = min(iTemp, 127);
         psr->acVoiceEnergy[j] = (char)iTemp;

         iTemp = iScale + (int)psr->acNoiseEnergy[j];
         iTemp = max(iTemp, -127);
         iTemp = min(iTemp, 127);
         psr->acNoiseEnergy[j] = (char)iTemp;
      } // j
#endif // 0

      if (pafPitch)
         pafPitch[i] = fPitchThis;

      // snap to the pitch
      // BUGFIX - Moved this elsewhere
      //if (fSnapToPitch && pafPitch[i] && fPitchThis) {
      //   fp fOrigPitch = pVoiceMod->pSubVoice->m_fAvgPitch;
      //
      //   // if voice is permanently pitch shifted then take this into account
      //   fPitchThis = fPitchThis / max(fOrigPitch, 1.0) * max(m_fAvgPitch, 1.0);
      //
      //   pafPitch[i] = exp(fSnapToPitch * log(fPitchThis) + (1.0 - fSnapToPitch) * log(pafPitch[i]));
      //}

      // go through and apply the glottal pulse mods
      // BUGFIX - Dont bother calling glottal pulse change since it seems to
      // do very little, plus it's technically not correct since the pitch in the
      // original audio might be sweeping, and it doesnt account for this
      // BUGFIX - Put back in because affects very low voice, and female
      // BUGFIX - remove this since may be mucking up female too much, making sound
      // too nasal, since female's phonemes have pitches all over the place

      // BUGFIX - Put back in because have new and improved code that should hopefully work
#ifndef NOMODS_GLOTTALPULSECHANGE
      GlottalPulseChange (psr, /*pCenter->m_fOrigPitch * (*/pVoiceMod->pSubVoice->m_fAvgPitch /*/ m_fAvgPitch)*/,
        pafPitch[i], // BUGFIX - Was pWave->PitchAtSample (i*pWave->m_dwPitchSkip, 0),
        TRUE);
            // NOTE: Always passing in "voiced" flag, which is technically incorrect,
            // but which shouldnt have much perceptable effect to the final voice
            // since will result in slight unwanted changes to unvoiced values
#endif // 0
   } // i


#if 0 // this doesn't work right... need to blend phases over distance
   // BUGFIX - Make phase a delta of previous phases so that don't get any
   // wierd phasing in voice
   // NOTE: This delta phase may cause problems with plosives
   for (i = 0; i < SRPHASENUM; i++) {
      // what's the previous phase immediately before this first phse
      PSRFEATURE pfThisPrevious = fToLeft ? (pSROrig-1) : NULL;

      // what's the previous phase
      PSRFEATURE pfWavePrevious = dwStart ? &pWave->m_paSRFeature[dwStart-1] : NULL;

      // what's the phase delta
      BYTE bDelta;
      // first see how much should be moving
      if (pfThisPrevious)
         bDelta = pSROrig->abPhase[i] - pfThisPrevious->abPhase[i];  // since have the info
      else if (dwEnd > dwStart)
         bDelta = pWave->m_paSRFeature[dwStart+1].abPhase[i] - pWave->m_paSRFeature[dwStart].abPhase[i];  // make it up, interpolation
      else
         bDelta = 0; // dont know. nothing

      // base it off of previous phase
      bDelta -= (pfWavePrevious ? (pWave->m_paSRFeature[dwStart].abPhase[i] - pfWavePrevious->abPhase[i]) : 0);

      // modify all the phases
      for (j = dwStart; j < dwEnd; j++)
         pWave->m_paSRFeature[j].abPhase[i] += bDelta;
   } // i
#endif // 0

   if (pLeft && pCenter) {
   }
   return TRUE;
}


/*************************************************************************************
CMTTS::PhonemeBackoff - This gets the phoneme and backs off to an alternate
version if it doesn't exist... stressed or unstressed

inputs
   DWORD              bPhone - Phoneme
   PCMLexicon        pLex - Lexicon
   DWORD              bSilence - Silence phoneme
returns
   BYTE bPhone - Phoneme number if finds a backoff
*/
DWORD CMTTS::PhonemeBackoff (DWORD bPhone, PCMLexicon pLex, DWORD bSilence)
{
   if (bPhone == bSilence)
      return bPhone;

   PCListFixed pl = m_palPCMTTSTriPhoneAudio ? m_palPCMTTSTriPhoneAudio[bPhone] : NULL;
   if (pl && pl->Num())
      return bPhone; // ok

   // serious problem because have selected phoneme but no recordsing, therefore
   // try to find an alternate stress...
   DWORD i;
   PLEXPHONE plp = pLex->PhonemeGetUnsort(bPhone);
   DWORD bPhoneTemp = bSilence;
   if (plp && ((DWORD)plp->wPhoneOtherStress < pLex->PhonemeNum()))
      bPhoneTemp = (BYTE)plp->wPhoneOtherStress;
   DWORD dwNum = pLex->PhonemeNum();
   if (bPhoneTemp == bSilence) for (i = 0; i < dwNum; i++) {
      plp = pLex->PhonemeGetUnsort (i);
      if (!plp)
         continue;
      if (plp->wPhoneOtherStress == (WORD)bPhone) {
         bPhoneTemp = i;
         break;
      }
   } // i

   pl = (bPhoneTemp != bSilence) ? (m_palPCMTTSTriPhoneAudio ? m_palPCMTTSTriPhoneAudio[bPhoneTemp] : NULL) : NULL;
   if (pl && pl->Num())
      return bPhoneTemp;
   else
      return bPhone; // original
}



#if 0 // replaced by new code
/*************************************************************************************
ScoreCalcWeightBoundary - Calculates the weight boundary based on the phoneme
length. Longer phonemes weight the SR score more, while short phonemes care
about boundary conditions.

inputs
   DWORD       dwDurationPrev - Duration in SR features for previous (half) unit
   DWORD       dwDuration - Duration in SR features for new (half) unit
   WORD        wPosPrev - Word position for previous, used to determine if plosive (0x10) or voiced (0x20)
   WORD        wPos - Current word position
returns
   DWORD - Weighting, from 0 indicates no effect
*/
fp ScoreCalcWeightBoundary (DWORD dwDurationPrev, DWORD dwDuration, WORD wPosPrev, WORD wPos)
{
   fp fDur = (fp)(dwDurationPrev + dwDuration) / 2.0; // count penalty against half of each
   fDur = max(fDur, 1);
   fDur /= (fp)TTSDEMIPHONES; // since duration of demiphones count

   fDur = SCORECALCWEIGHTBOUNDARY * (fp)SRSAMPLESPERSEC / fDur;

   // if either of these are plosives, then (hack) scale up the boundary weight
   // to encourage plosives sticking next to vowels
   if ((wPosPrev & 0x10) || (wPos & 0x10))
      fDur *= SCORECALCWEIGHTBOUNDARY_SCALEPLOSIVE;
   else if (!(wPosPrev & 0x20) && !(wPos & 0x20))
      fDur *= SCORECALCWEIGHTBOUNDARY_SCALEUNVOICED;

   return fDur;
}
#endif

/*************************************************************************************
ScoreCalcWeightBoundary - Calculates the weight boundary

inputs
   fp             fEnergyPrev - Energy of the previous unit
   fp             fEnergyNew - Energy of the new unit
returns
   fp - Weighting
*/
__inline fp ScoreCalcWeightBoundary (fp fEnergyPrev, fp fEnergyNew)
{
   // basically, weight is .2 of a second * SRSAMPLESPERSEC, maxed with energy
   return max(fEnergyPrev, fEnergyNew) * JOINHALFWINDOWSIZE;
      // use JOINHALFWINDOWSIZE because really doing a tent-shape of JOINHALFWINDOWSIZE for each triangle,
      // and area under tent is JOINHALFWINDOWSIZE
//   return max(fEnergyPrev, fEnergyNew) * SCORECALCWEIGHTBOUNDARY * SRSAMPLESPERSEC;
}

/*************************************************************************************
ScoreCalcWeightSelf - Calculates the weight of self

inputs
   fp             fEnergy - Energy that this is supposed to be
   DWORD          dwDuration - Duration in SRSAMPLEs
returns
   fp - Weighting
*/
__inline fp ScoreCalcWeightSelf (fp fEnergy, DWORD dwDuration)
{
   return fEnergy * (fp)dwDuration / TTSDEMIPHONES;   // BUGFIX - reduce since several demiphones per
}

#if 0 // no longer used. Was hack attempt, but probably not a good idea
/*************************************************************************************
CMTTS::ScoreCalcContiguous - Score bonus for contiguous units.

inputs
   PCMTTSTriPhoneAudio     ptNew - The Triphone in question
   PBYTE                   pbPhone - Phonemes in the future, [0] is current phoneme
   DWORD                   dwPhoneValid - Number of phonemes valid. Thus, if only[0] is valid then this is 1
returns
   fp - score.
*/

__inline fp CMTTS::ScoreCalcContiguous (PCMTTSTriPhoneAudio ptNew, PBYTE pbPhone, DWORD dwPhoneValid)
{
   //if MAXNOTCONTGIOUSNUM==0 then do nothing
   if (!MAXNOTCONTGIOUSNUM)
      return 0;

   if (dwPhoneValid < 2)
      return HYPCONTIGUOUSUNITS * MAXNOTCONTGIOUSNUM;
   
   dwPhoneValid--;
   pbPhone++;

   DWORD i;
   for (i = 0; (i < NUMPHONECONTIGOUS) && dwPhoneValid; i++, pbPhone++, dwPhoneValid++) {
      if (!ptNew->m_abPhoneContiguous[i])
         break;   // end of data

      // if no match then stop
      if (ptNew->m_abPhoneContiguous[i] != (pbPhone[0]+1))
         break;

      // else, continue
      continue;
   } // i

#if 0 // def _DEBUG
   if (i >= 5)
      pbPhone -= i;
#endif
   
   int iScore = (int)MAXNOTCONTGIOUSNUM - i;
   iScore = max(iScore, 0);
   return (fp) iScore * HYPCONTIGUOUSUNITS;
}
#endif // 0
   
/*************************************************************************************
CMTTS::ScoreCalcBoundary - Calculate effects of the boundary on the score

inputs
   DWORD                   dwTime - Time. Most important is dwTime % TTSDEMIPHONES
   PCMTTSTriPhoneAudio     ptNew - The Triphone in question
   DWORD                   *pdwWord - Word history
   PBYTE                   pbWordPos - Word position flags hisotry
   PBYTE                   pbPhone - Phoneme history
   PBYTE                   pbTPhoneNoStress - Phoneme history, without stresses
   PBYTE                   pbTPhoneGroup - Phoneme group history
   BYTE                    bSilence - Silence phoneme
   DWORD                   *pdwPrevious - Used for the first option, if calling from GenerateUNITOPTION.
                                          NULL otherwise
   PVOID                   pahFrom - Used if called from HypExpand
   PCMTTSTriPhoneAudio     *paPCMTTSTriPhoneAudio - Used by HypExpand, from ph.aPCMTTSTriPhoneAudio
returns
   fp - score
*/
__inline fp CMTTS::ScoreCalcBoundary (DWORD dwTime, PCMTTSTriPhoneAudio ptNew, DWORD *pdwWord, PBYTE pbWordPos,
                                         PBYTE pbPhone, PBYTE pbTPhoneNoStress, PBYTE pbTPhoneGroup, BYTE bSilence,
                                         DWORD *pdwPrevious,
                                         PVOID pahFrom, PCMTTSTriPhoneAudio *paPCMTTSTriPhoneAudio)
{
   fp fScore = 0;
   int iPrevPhone = (ATSTARTOFPHONE ? -1 : 0);

#if 0 // no longer used because hackish code
   // BUGFIX - take syllable start and end into account
   BOOL fWordStart = /* ATSTARTOFPHONE && */ (*pbWordPos & 0x01);
   BOOL fSylStart = /* ATSTARTOFPHONE && */ (*pbWordPos & 0x04);

   fp fScoreLeft = 0;
      

   // less penalty for error at boundary
   fScoreLeft = CROSSWORDLESSPENALTYLEFT(fScoreLeft);


   // BUGFIX - take syllable start and end into account
   BOOL fWordEnd = /*ATENDOFPHONE &&*/ (*pbWordPos & 0x02);
   BOOL fSylEnd = /*ATENDOFPHONE &&*/ (*pbWordPos & 0x08);
   fp fScoreRight = 0;

   // NOTE - not sure about the fNotContiguous
   // was doing this unless exact match of phonemes
   BOOL fNotContiguous = TRUE;
   if (fNotContiguous) {
      fPlosive = (*pbWordPos & 0x10) || (pbWordPos[1] & 0x10);
      fScoreRight += HYPNOTCONTIGUOUS;
   }

   // less penalty for cross word at right
   fScoreRight = CROSSWORDLESSPENALTYRIGHT(fScoreRight);

   // weight the scores depending upon left/right
   fp fWeightRight, fWeightLeft;
   if (TTSDEMIPHONES <= 1)
      fWeightRight = fWeightLeft = 1;
   else {
      fWeightRight = dwTime % TTSDEMIPHONES;
      fWeightLeft = (TTSDEMIPHONES-1) - fWeightRight;
      fWeightRight += TTSDEMIPHONES/2;   // so that some weight given to opposite
      fWeightLeft += TTSDEMIPHONES/2; // so that some weight given to opposite
   }

   fScore = (fScoreLeft * fWeightLeft + fScoreRight * fWeightRight) * 2.0 / (fWeightLeft + fWeightRight);
#endif // 0

   PCMLexicon pLex = Lexicon();

   // BOOL fRightVoiced = pbWordPos[0] & 0x20;
   // BOOL fRightPlosive = pbWordPos[0] & 0x10;
   // BOOL fLeftVoiced = pbWordPos[iPrevPhone] & 0x20;
   // BOOL fLeftPlosive = pbWordPos[iPrevPhone] & 0x10;

   // non-contiguous penalty
   //BOOL fPlosive = (*pbWordPos & 0x10) || (pbWordPos[iPrevPhone] & 0x10);
      // BUGFIX - Look at both this one and previous one
   // BOOL fVoiced = (*pbWordPos & 0x20) && (pbWordPos[iPrevPhone] & 0x20);   // do && since using !fVoiced for HYPNOTCONTIGUOUS
   BOOL fUseScore = FALSE;
   if (ATSTARTOFPHONE) {
      if (pdwPrevious) { // calling from GenerateUNITOPTION
         if (ptNew->m_wOrigPhone != (WORD)-1) {
            DWORD dwIndex = MAKELONG ((WORD)((int)ptNew->m_wOrigPhone+iPrevPhone), ptNew->m_wOrigWave);
            if (*pdwPrevious != dwIndex)
               fUseScore = TRUE;  // match, but not contiguous
#ifdef _DEBUG
            else
               fScore += 0;
#endif
         }
      }
      else { // calling from HypExpand
         PCMTTSTriPhoneAudio pLeft;
         if (pLeft = paPCMTTSTriPhoneAudio[PHONEHISTORY-2-(dwTime%TTSDEMIPHONES)]) {
            if ((pLeft->m_wOrigWave != ptNew->m_wOrigWave) || ((int)pLeft->m_wOrigPhone+1 != (int)ptNew->m_wOrigPhone))
               fUseScore = TRUE;  // match, but not contiguous
         }
         // else, phoneme matches exactly what expected
            // NOTE: Assumes NUMTRIPHONEGROUP == 3
      }
   }
   else {
      // BUGFIX - If already in a unit, make sure that contiguous with existing unit
      if (pdwPrevious) { // calling from GenerateUNITOPTION
         DWORD dwIndex = MAKELONG (ptNew->m_wOrigPhone, ptNew->m_wOrigWave);
         if (*pdwPrevious != dwIndex)
            fUseScore = TRUE;  // match, but not contiguous
#ifdef _DEBUG
            else
               fScore += 0;
#endif
      }
      else { // calling from HypExpand
         if (paPCMTTSTriPhoneAudio[PHONEHISTORY-2] != ptNew)
            fUseScore = TRUE;  // match, but not contiguous
      }
   }

   // BUGFIX - Unit scores include some UnitScoreScoreLRMismatch() as well as UnitScoreScoreNonContiguous
   if (fUseScore)
      fScore += UnitScoreJoinEstimate (this, pbPhone[iPrevPhone], pbPhone[0], !iPrevPhone, pLex) / (fp)JOINHALFWINDOWSIZE;
         // BUGFIX - Was doing /(JOINHALFWINDOWSIZE*2), but this was wrong mathematically since UnitScoreJoinEstimate()
         // is already windowed by a tent of 2*JOINHALFWINDOWSIZE, so the average would be divided by
         // the area under the tent = 1/2 * (2*JOINHALFWINDOWSIZE)

   return fScore;
}


/*************************************************************************************
CMTTS::ScoreCalcSelfA and ScoreCalcSelfB - Calculate the score of the unit in relation to itself.
This ignores the units to the left/right.

ScoreCalcSelfA - Independent of exact triphone (tpPrev) that occurred before.
ScoreCalcSelfB - Dependent on exact triphone (tpPrev) that occurred before.

Thus, one can be precalced. Make sure to sume the values together.

inputs
   DWORD                   dwTime - Time. Most important is dwTime % TTSDEMIPHONES
   PCMTTSTriPhoneAudio     ptNew - The Triphone in question
   PCMTTSTriPhoneAudio     ptPrev - Previous triphone (by demitriphone), NULL if silence
   BOOL                    fUsePitch - Set to TRUE if phoneme has a pitch
   int                     iPitchLeft - Pitch at the left
   int                     iPitchCenter - Pitch at the center
   int                     iPitchRight - Pitch at the right
   DWORD                   *pdwWord - Word history
   PBYTE                   pbWordPos - Word position flags hisotry
   DWORD                   dwDuration - Duration in SRFEATURE units
   fp                      fEnergy - Energy of the unit, compared against the tri-phone's ideal
   DWORD                   dwFuncWordGroup - How much of a function word looking for, 0..NUMFUNCWORDGROUP (inclusive)
   PBYTE                   pbPhone - Phoneme history
   PBYTE                   pbTPhoneNoStress - Phoneme history, without stresses
   PBYTE                   pbTPhoneGroup - Phoneme group history
   BYTE                    bSilence - Silence phoneme
   DWORD                   *pdwPrevious - Used for the first option, if calling from GenerateUNITOPTION.
                                          NULL otherwise
   PVOID                   pahFrom - Used if called from HypExpand
   BOOL                    fDisablePCM - Set to TRUE if PCM is temporarily disabled (because user has
                           selected not to use it)
return
   fp - Scpre
*/


__inline fp CMTTS::ScoreCalcSelfA (DWORD dwTime, PCMTTSTriPhoneAudio ptNew, PCMTTSTriPhoneAudio ptPrev, BOOL fUsePitch,
                               int iPitchLeft, int iPitchCenter, int iPitchRight,
                               DWORD dwDuration, fp fEnergy,
                               DWORD dwFuncWordGroup,
                               DWORD *pdwWord, PBYTE pbWordPos,
                               PBYTE pbPhone, PBYTE pbTPhoneNoStress, PBYTE pbTPhoneGroup, BYTE bSilence,
                               DWORD *pdwPrevious, PVOID pahFrom,
                               BOOL fDisablePCM)
{
   fp fScoreLeft = 0, fScoreRight = 0;
   BOOL fWordStart = /* ATSTARTOFPHONE && */ (*pbWordPos & 0x01);
   BOOL fWordEnd = /*ATENDOFPHONE &&*/ (*pbWordPos & 0x02);
   //BOOL fPlosive = ((*pbWordPos) & 0x10);
   //BOOL fVoiced = ((*pbWordPos) & 0x20);

   PCMLexicon pLex = Lexicon();

   // left
   BOOL fMismatch = FALSE;
// BUGFIX - disable this #define USEBROADMATCH      // dont use
#ifdef USEBROADMATCH
   DWORD dwBroadMatch = 0;    // number of phonemes (left or right) that match broad category
#endif
   // if it's the start of a word, going from silence is ok
   // BUGFIX - Can only use this trick if the previous one ended in silence
   if (!pdwPrevious && (ptNew->m_bPhoneLeft == bSilence) && fWordStart && (pbPhone[-1] != bSilence) && ((PPHONEHYP)pahFrom)->fEndSilence) {
      // BUGFIX - Changed CROSSWORDLESSPENALTYLEFT (HYPINSERTSILENCE) to HYPINSERTSILENCE
      // since CROSSWORDLESSPENALTYLEFT would always multiply by 2/3
      fScoreLeft += HYPINSERTSILENCE;
      fMismatch = TRUE;
   }
   // if it's the start of a word, going from silence is ok
   // BUGFIX - Can only use this trick if the previous one ended in silence
   // various pentalities for how different the left and right groups are
   else if (LexPhoneGroupToMega(pbTPhoneGroup[-1]) != LexPhoneGroupToMega((BYTE)ptNew->m_awTriPhone[0])) {
      fScoreLeft += UnitScoreScoreLRMismatch (this, pbPhone[0], pbPhone[-1], pLex, FALSE, 5);
      fMismatch = TRUE;
   }
   else if (pbTPhoneGroup[-1] != (BYTE)ptNew->m_awTriPhone[0]) {
      // BUGFIX - Changed CROSSWORDLESSPENALTYLEFT (HYPBADGROUP) to just HYPBADGROUP
      // since was tending to change to bad unit at the start/end of word
      fScoreLeft += UnitScoreScoreLRMismatch (this, pbPhone[0], pbPhone[-1], pLex, FALSE, 4);
      fMismatch = TRUE;
   }
   else if (pbTPhoneNoStress[-1] != (BYTE)ptNew->m_awTriPhone[1]) { // right group, wrong phone
      fScoreLeft += UnitScoreScoreLRMismatch (this, pbPhone[0], pbPhone[-1], pLex, FALSE, 3);
      fMismatch = TRUE;
#ifdef USEBROADMATCH
      dwBroadMatch++;
#endif
   }
   else if (pbPhone[-1] != (BYTE)ptNew->m_awTriPhone[2]) {// right phone, wrong stress
      fMismatch = TRUE;
      fScoreLeft += UnitScoreScoreLRMismatch (this, pbPhone[0], pbPhone[-1], pLex, FALSE, 2);
#ifdef USEBROADMATCH
      dwBroadMatch++;
#endif
   }
#ifdef USEBROADMATCH
   else // perfect triphone match, so no error
      dwBroadMatch++;
#endif


   // if it's the end of a word, going to silence is ok
   // int iNextPhone = (ATENDOFPHONE ? 1 : 0);
   // BOOL fNotContiguous = TRUE;
   if ((ptNew->m_bPhoneRight == bSilence) && fWordEnd && (pbPhone[1] != bSilence)) {
      // BUGFIX - Changed CROSSWORDLESSPENALTYRIGHT (HYPINSERTSILENCE) to HYPINSERTSILENCE
      // since CROSSWORDLESSPENALTYRIGHT would always multiply by 2/3
      fScoreRight += HYPINSERTSILENCE;
      fMismatch = TRUE;
   }
   else if (LexPhoneGroupToMega(pbTPhoneGroup[1]) != LexPhoneGroupToMega((BYTE)(ptNew->m_awTriPhone[0]>>8))) {
      fScoreRight += UnitScoreScoreLRMismatch (this, pbPhone[0], pbPhone[1], pLex, TRUE, 5);
      fMismatch = TRUE;
   }
   else if (pbTPhoneGroup[1] != (BYTE)(ptNew->m_awTriPhone[0]>>8)) {
      // BUGFIX - Changed CROSSWORDLESSPENALTYRIGHT (HYPBADGROUP) to just HYPBADGROUP
      // since was tending to change to bad unit at the start/end of word
      fScoreRight += UnitScoreScoreLRMismatch (this, pbPhone[0], pbPhone[1], pLex, TRUE, 4);
      fMismatch = TRUE;
   }
   else if (pbTPhoneNoStress[1] != (BYTE)(ptNew->m_awTriPhone[1]>>8)) {
      fScoreRight += UnitScoreScoreLRMismatch (this, pbPhone[0], pbPhone[1], pLex, TRUE, 3);
      fMismatch = TRUE;
#ifdef USEBROADMATCH
      dwBroadMatch++;
#endif
   }
   else if (pbPhone[1] != (BYTE)(ptNew->m_awTriPhone[2]>>8)) {
      fScoreRight += UnitScoreScoreLRMismatch (this, pbPhone[0], pbPhone[1], pLex, TRUE, 2);
      fMismatch = TRUE;
#ifdef USEBROADMATCH
      dwBroadMatch++;
#endif
   }
#ifdef USEBROADMATCH
   else // perfect triphone match, so no error
      dwBroadMatch++;
#endif

   // if any of the units mismatched then see if can find exact match in m_aMMISpecific, and use that
   DWORD i;
   DWORD dwDemi = dwTime % TTSDEMIPHONES;
   if (fMismatch) {
      BYTE bLeft, bRight;
      fp fLeftHack, fRightHack;
      switch (ptNew->m_dwMismatchAccuracy) {
         case 0:  // by group
            bLeft = pbTPhoneGroup[-1];
            bRight = pbTPhoneGroup[1];

            // since not really sure how much of a mismatch in stress/group there
            // is, add half
            fLeftHack = UnitScoreScoreLRMismatch (this, pbPhone[0], pbPhone[-1], pLex, FALSE, 3) / 2.0;
            fRightHack = UnitScoreScoreLRMismatch (this, pbPhone[0], pbPhone[1], pLex, TRUE, 3) / 2.0;
            break;
         case 1:  // by stressed
            bLeft = pbTPhoneNoStress[-1];
            bRight = pbTPhoneNoStress[1];

            // since not really sure how much of a mismatch in stress/group there
            // is, add half
            fLeftHack = UnitScoreScoreLRMismatch (this, pbPhone[0], pbPhone[-1], pLex, FALSE, 2) / 2.0;
            fRightHack = UnitScoreScoreLRMismatch (this, pbPhone[0], pbPhone[1], pLex, TRUE, 2) / 2.0;
            break;
         case 2:  // exact
         default:
            bLeft = pbPhone[-1];
            bRight = pbPhone[1];

            fLeftHack = fRightHack = 0;
            break;
      } // switch

      PMISMATCHINFO pmmi = &ptNew->m_aMMISpecific[0];
      for (i = 0; i < TRIPHONESPECIFICMISMATCH; i++, pmmi++)
         if ((pmmi->bLeft == bLeft) && (pmmi->bRight == bRight) && pmmi->abRank) {
            // override the guestimated mismatch with the real thing
            fScoreLeft = fScoreRight = ((fp)pmmi->abRank[dwDemi] - (fp) RANKDBOFFSET) / (fp) RANKDBSCALE / 2.0;
            // BUGBUG - in the future, might look for parial matches of m_aMMISpecific that are still more
            // accurate than the main match, and then offset those. Not worth it at the moment

            fScoreLeft += fLeftHack;
            fScoreRight += fRightHack;
            break;
         }
   }

#if 0 // no longer used
   // if either
   // if it's not the proper word, and haven't incurred any penalty from mismatch,
   // then incorporate bad word mismatch
   BOOL fWordMismatch = ((*pdwWord != -1) && (*pdwWord != ptNew->m_dwWord));
   if (fWordMismatch) {
      fScoreLeft += HYPBADWORD;
      fScoreRight += HYPBADWORD;
   }
#endif


   // if mismatch in phoneme at start/end then add penalty
   // BUGFIX - Was doing all bits in bWordPos, but only want to do word start/end
   fScoreLeft += UnitScoreMismatchedWordPos (this, (*pbWordPos) & 0x01, ptNew->m_wWordPos & 0x01);
   fScoreRight += UnitScoreMismatchedWordPos (this, (*pbWordPos) & 0x02, ptNew->m_wWordPos & 0x02);

   // weight the scores depending upon left/right
   fp fWeightRight, fWeightLeft;
   if (TTSDEMIPHONES <= 1)
      fWeightRight = fWeightLeft = 1;
   else {
      fWeightRight = dwDemi;
      fWeightLeft = (TTSDEMIPHONES-1) - fWeightRight;
      fWeightRight += TTSDEMIPHONES/2;   // so that some weight given to opposite
      fWeightLeft += TTSDEMIPHONES/2; // so that some weight given to opposite
   }

   fp fScore = (fScoreLeft * fWeightLeft + fScoreRight * fWeightRight) * 2.0 / (fWeightLeft + fWeightRight);


   // error for pitch not being good match
   fp fErrorPitch;
   BOOL fFullPCM = fDisablePCM ? FALSE : m_fFullPCM;
#ifdef NOMODS_DISABLEPCM
      fFullPCM = FALSE;
#endif

   // BUGFIX - Phoneme always has a pitch: if (fUsePitch) {
   // BUGFIX - more accurate pitch calculations for phoneme
   fp afPhonemePitchDiff[3];
   afPhonemePitchDiff[0] = ptNew->m_iPitchLeft - iPitchLeft;
   afPhonemePitchDiff[1] = ptNew->m_iPitchCenter - iPitchCenter;
   afPhonemePitchDiff[2] = ptNew->m_iPitchRight - iPitchRight;

   fp fAlpha = (fp)dwDemi / (fp)TTSDEMIPHONES * 2.0;
   DWORD dwLeft = (DWORD)fAlpha;
   fAlpha -= (fp)dwLeft;
   DWORD dwRight = min(dwLeft+1, 3 - 1);

   // difference in the average
   fp fPitchDiff = (1.0 - fAlpha) * afPhonemePitchDiff[dwLeft] + fAlpha * afPhonemePitchDiff[dwRight];
   fErrorPitch = abs(fPitchDiff);
   fErrorPitch = min(fErrorPitch, 1500); // never more than 1.5 octaves, so not too much worse
   fErrorPitch *= UnitScorePitch(this, pbPhone[0], pLex, fPitchDiff >= 0, fFullPCM) / 1000.0;
   fErrorPitch = max (0, fErrorPitch - HYPPITCHPENALTYPEROCTAVEFORGIVE);   // forgive if close
   fScore += fErrorPitch;

   // difference in slope
   fPitchDiff = (1.0 - fAlpha) * afPhonemePitchDiff[dwLeft] - fAlpha * afPhonemePitchDiff[dwRight];
   fErrorPitch = abs(fPitchDiff);
   fErrorPitch = min(fErrorPitch, 1500); // never more than 1.5 octaves, so not too much worse
   fErrorPitch *= UnitScorePitch(this, pbPhone[0], pLex, fPitchDiff >= 0, fFullPCM) / 1000.0 * PITCHSWEEPCOSTSCALE;
   fErrorPitch = max (0, fErrorPitch - HYPPITCHPENALTYPEROCTAVEFORGIVE);   // forgive if close
   fScore += fErrorPitch;

#if 0 // old way of calculating
   // loop over 3 pitch points in demiphone
   for (i = 0; i < 3; i++) {
      fp fAlpha = ((fp)i / 2.0 + (fp)dwDemi) / (fp)TTSDEMIPHONES * 2.0;
      DWORD dwLeft = (DWORD)fAlpha;
      fAlpha -= (fp)dwLeft;
      DWORD dwRight = min(dwLeft+1, 3 - 1);

      fp fPitchDiff = (1.0 - fAlpha) * afPhonemePitchDiff[dwLeft] + fAlpha * afPhonemePitchDiff[dwRight];

      fErrorPitch = abs(fPitchDiff);
      fErrorPitch = min(fErrorPitch, 1500); // never more than 1.5 octaves, so not too much worse
      fErrorPitch *= UnitScorePitch(this, pbPhone[0], pLex, fPitchDiff >= 0, fFullPCM) / 1000.0;
      fErrorPitch = max (0, fErrorPitch - HYPPITCHPENALTYPEROCTAVEFORGIVE);   // forgive if close
      fScore += fErrorPitch / 3.0;
   }
#endif

   //fErrorPitch = abs(ptNew->m_iPitchLeft - iPitchLeft);
   //fErrorPitch = min(fErrorPitch, 1500);  // never more than 1.5 octaves, so not too much worse
   //fErrorPitch = fErrorPitch * UnitScorePitch(pbPhone[0], pLex, iPitchLeft > ptNew->m_iPitchLeft, fFullPCM) / 1000.0;
   //fErrorPitch = max (0, fErrorPitch - HYPPITCHPENALTYPEROCTAVEFORGIVE);   // forgive if close
   //fScoreLeft += fErrorPitch * 0.66666;
      // BUGFIX - Multiply by 0.6666 sinc also including center at 0.33333

   //fErrorPitch = abs(ptNew->m_iPitchRight - iPitchRight);
   //fErrorPitch = min(fErrorPitch, 1500);  // never more than 1.5 octaves, so not too much worse
   //fErrorPitch = fErrorPitch * UnitScorePitch(pbPhone[0], pLex, iPitchRight > ptNew->m_iPitchRight, fFullPCM) / 1000.0;
   //fErrorPitch = max (0, fErrorPitch - HYPPITCHPENALTYPEROCTAVEFORGIVE);   // forgive if close
   //fScoreRight += fErrorPitch * 0.66666;
      // BUGFIX - Multiply by 0.6666 sinc also including center at 0.33333

   // BUFIX - Pitch at center too
   //fErrorPitch = abs(ptNew->m_iPitchCenter - iPitchCenter);
   //fErrorPitch = min(fErrorPitch, 1500);  // never more than 1.5 octaves, so not too much worse
   //fErrorPitch = fErrorPitch * UnitScorePitch(pbPhone[0], pLex, iPitchCenter > ptNew->m_iPitchCenter, fFullPCM) / 1000.0;
   //fErrorPitch = max (0, fErrorPitch - HYPPITCHPENALTYPEROCTAVEFORGIVE);   // forgive if close
   //fScoreLeft += fErrorPitch * 0.33333;
   //fScoreRight += fErrorPitch * 0.33333;
   // BUGFIX - Phoneme always has a pitch}


   // add basic phone rank
   fScore += ((fp) ptNew->m_abRank[dwDemi] - (fp) RANKDBOFFSET) / (fp) RANKDBSCALE;
      // BUGFIX - Add RANKDBOFFSET so can include some negative scores

   // error for duration
   if (dwDuration && (ptNew->m_dwFeatureEnd - ptNew->m_dwFeatureStart)) { // BUGFIX - Add ptNew->m_dwNumSRFEATURE to prevent divide by zero
      fp fRelDur = log((fp)dwDuration / (fp)(ptNew->m_dwFeatureEnd - ptNew->m_dwFeatureStart)) / log(2.0);
      fScore += fabs(fRelDur) * UnitScoreDuration (this, pbPhone[0], pLex, fRelDur >= 0.0, fFullPCM);
      //DWORD dwDurWant = dwDuration; // BUGFIX - Pick duration with same length: fPlosive ? dwDuration : (dwDuration * 3 / 2);
         // BUGFIX - Try to pick units that are 50% longer than
         // the real thing since sounds better to shorten a long unit than lengthen a short one
         // NOTE: There is an equivalent calcualation in CTTSWork AnalysisTriPhone
      //DWORD dwDur = max(ptNew->m_dwNumSRFEATURE, dwDurWant) * 16 / min(ptNew->m_dwNumSRFEATURE, dwDurWant);
      //dwDur -= 16;   // so smame duration goes to 0
      
      // BUGFIX - Allow to be longer by a bit
      //if (ptNew->m_dwNumSRFEATURE > dwDurWant) {
      //   if (dwDur > HYPDURATIONLONGERLESS(16))
      //      dwDur -= HYPDURATIONLONGERLESS(16);
      //   else
      //      dwDur = 0;  // no penality is slightly longer
      //}
      //fScore += dwDur *
      //   (fPlosive ? HYPDURATIONPENALTYPLOSIVE(HYPSCOREDURDELTA) :
      //      (fVoiced ? HYPSCOREDURDELTA : HYPDURATIONPENALTYUNVOICED(HYPSCOREDURDELTA)  )) / 16.0;
   }

   // energy
   if (fEnergy && ptNew->m_fEnergyAvg) {
      fp fRelEnergy = log(fEnergy / ptNew->m_fEnergyAvg) / log(2.0);
      fScore += fabs(fRelEnergy) * UnitScoreEnergy (this, pbPhone[0], pLex, fRelEnergy >= 0);
   }

#ifdef USEBROADMATCH
   // BUGFIX - If neither left or right matches any of the broad phoneme category
   // then make a really bad score. Want at least one of them to match
   if (!dwBroadMatch)
      fScore += MAXBORDERERROR;
#endif

#ifndef NOMODS_DISABLEFUNCWORDGROUP
   fScore += UnitScoreFunc (this, pbPhone[0], pLex, ptNew->m_dwFuncWordGroup, dwFuncWordGroup);
#endif

   return fScore;
}

__inline fp CMTTS::ScoreCalcSelfB (DWORD dwTime, PCMTTSTriPhoneAudio ptNew, PCMTTSTriPhoneAudio ptPrev, BOOL fUsePitch,
                               int iPitchLeft, int iPitchCenter, int iPitchRight,
                               DWORD dwDuration, fp fEnergy,
                               DWORD dwFuncWordGroup,
                               DWORD *pdwWord, PBYTE pbWordPos,
                               PBYTE pbPhone, PBYTE pbTPhoneNoStress, PBYTE pbTPhoneGroup, BYTE bSilence,
                               DWORD *pdwPrevious, PVOID pahFrom,
                               BOOL fDisablePCM)
{
   fp fScore = 0;
   fp fErrorPitch;
   BOOL fFullPCM = fDisablePCM ? FALSE : m_fFullPCM;
#ifdef NOMODS_DISABLEPCM
   fFullPCM = FALSE;
#endif


   PCMLexicon pLex = Lexicon();

#if 0 // Wrong way to do it. Moved UnitScoreScoreLRMismatch to ScoreCalcBoundary
   //BOOL fPlosive = ((*pbWordPos) & 0x10);
   //BOOL fVoiced = ((*pbWordPos) & 0x20);

   // determine if contiguous triphones
   BOOL fContiguousTriphones = FALSE;
   if (ptPrev) {
      if (dwTime % TTSDEMIPHONES) {
         if (ptPrev == ptNew)
            fContiguousTriphones = TRUE;  // not on the first demiphone, and they're a match, so contiguous
         else
            fContiguousTriphones = FALSE; // not a match, so not contiguous
      }
      else {
         if ((ptPrev->m_wOrigWave == ptNew->m_wOrigWave) && (ptPrev->m_wOrigPhone+1 == ptNew->m_wOrigPhone))
            fContiguousTriphones = TRUE;  // crossing phonemes, but sequential
         else
            fContiguousTriphones = FALSE; // crossing phonemes and not sequential
      }
   }
   else {
      // no prior triphone, so is silence. As long as this triphone starts
      // with silence, then mark as contiguous
      if (ptNew->m_bPhoneLeft == bSilence)
         fContiguousTriphones = TRUE; // supposed to start silence, so contigous
      else
         fContiguousTriphones = FALSE; // not supposed to start silence, so assume not contiguous
   }

   if (!fContiguousTriphones) // BUGFIX - Was fContiguousTriphones
      fScore += (
         UnitScoreScoreLRMismatch (pbPhone[0], pbPhone[((dwTime+1)%TTSDEMIPHONES) ? 1 : 0], pLex, FALSE, 1) +
         UnitScoreScoreLRMismatch (pbPhone[0], pbPhone[(dwTime%TTSDEMIPHONES) ? 0 : -1], pLex, TRUE, 1)
         ) / 2.0 * TTSDEMIPHONES;
#endif // 0



#ifndef NOMODS_DISABLEUNITCONTINUITY
   // NOTE: I tried to get rid of this, but sounds better with it on, even though it's
   // a bit of a hack
   if ((ptPrev != ptNew) || !(dwTime % TTSDEMIPHONES) ) {
      // use above test, because will have 0 difference it (ptPrev == pNew) && (dwTime % TTSEMIPHONES)

      // BUGFIX - continuity so that will try to pick sequential units that
      // if not actually contiguous, will be reasonably close
      float fLeftEnergy;
      float fLeftPitch;
      DWORD dwLeftDuration;
      PBYTE pbLeftWordPos = (dwTime % TTSDEMIPHONES) ? pbWordPos : (pbWordPos - 1);   // whatever was to left
      // want whatever the left is
      if (ptPrev) {
         fLeftEnergy = ptPrev->m_fCenterEnergy;
         fLeftPitch = ptPrev->m_fPitchCenter;
         dwLeftDuration = ptPrev->m_dwFeatureEnd - ptPrev->m_dwFeatureStart;
      }
      else {
         // silence
         fLeftEnergy = fLeftPitch = 0;
         dwLeftDuration = 0;
      }

      float fLeftEnergyWant, fLeftPitchWant;
      DWORD dwLeftDurationWant;
      if (dwTime % TTSDEMIPHONES) {
         // part way through phoneme, so what want for previous = this
         fLeftEnergyWant = ptNew->m_fCenterEnergy;
         fLeftPitchWant = ptNew->m_fPitchCenter;
         dwLeftDurationWant = ptNew->m_dwFeatureEnd - ptNew->m_dwFeatureStart;
      }
      else {
         fLeftEnergyWant = ptNew->m_fLeftEnergy;
         fLeftPitchWant = ptNew->m_fLeftPitch;
         dwLeftDurationWant = ptNew->m_dwLeftDuration;
      }

      BOOL fLeftPlosive = ((*pbLeftWordPos) & 0x10);
      BOOL fLeftVoiced = ((*pbLeftWordPos) & 0x20);
      fp fErrorLeft = 0;   // error from left mismatch
      if (fUsePitch) {
         // calculate pitch
         fErrorPitch = log(max(fLeftPitch,CLOSE) / max(fLeftPitchWant, CLOSE)) / log(2.0);
         fErrorPitch = max(fErrorPitch, -2.0); // dont allow too much
         fErrorPitch = min(fErrorPitch, 2.0);

         fErrorLeft += fabs(fErrorPitch) * UnitScorePitch (this, pbPhone[-1], pLex, fErrorPitch > 0, fFullPCM);

         // NOTE: Not worrying about slope of pitch here. Don't think will be much of an issue
      }

      // calculate energy
      fErrorPitch = log(max(fLeftEnergy,CLOSE) / max(fLeftEnergyWant, CLOSE)) / log(2.0);
      fErrorPitch = max(fErrorPitch, -2.0); // dont allow too much
      fErrorPitch = min(fErrorPitch, 2.0);
      fErrorLeft += fabs(fErrorPitch) * UnitScoreEnergy (this, pbPhone[-1], pLex, fErrorPitch > 0);
      
      // calculate duration
      fErrorPitch = log((fp) max(dwLeftDuration,1) / (fp)max(dwLeftDurationWant, 1)) / log(2.0);
      fErrorPitch = max(fErrorPitch, -2.0); // dont allow too much
      fErrorPitch = min(fErrorPitch, 2.0);
      fErrorLeft += fabs(fErrorPitch) * UnitScoreDuration (this, pbPhone[-1], pLex, fErrorPitch > 0, fFullPCM);

      // include error discontinuity in the score
      fScore += fErrorLeft * SCORECALCDISCONTINUITYSCALE;
   } // if ptPrev != ptNew
#endif // NOMODS_DISABLEUNITCONTINUITY

   return fScore;
}

// EMTCERRORCACHECALC
typedef struct {
   // on all EMTCxxx
   DWORD          dwStart;       // start count
   DWORD          dwEnd;         // end count
   DWORD          dwType;        // type

   // used by both prelim score calc and boundary error calc
   DWORD          dwTime;

   // used by prelime score calc
   PCMTTSTriPhoneAudio *pptp;
   PCListFixed    plUNITOPTION;
   fp             fEnergy;
   DWORD          dwDurationX;
   DWORD          dwFuncWordGroup;
   fp             fEnergyPrev;
   BOOL           fUsePitch;
   int            iPitchLeft;
   int            iPitchCenter;
   int            iPitchRight;
   DWORD          *pdwWord;
   PBYTE          pbWordPos;
   PBYTE          pbPhone;
   PBYTE          pbTPhoneNoStress;
   PBYTE          pbTPhoneGroup;
   BYTE           bSilence;
   PCMem          pmemFrom;
   DWORD          dwPass;        // 0 for pass based on guestimates, 1 for pass based on previous scores

   // used by boundary error calc
   PUNITOPTION    pUnit;
   PCListFixed    plUNITOPTIONLast;
   fp             *paf;
   BOOL           *pafLastUsed;
   BOOL           *pafIsValidEnergy;
   fp             *pafLastEnergy;
   int            iTTSQuality;
   BOOL           fDisablePCM;
} EMTCERRORCACHECALC, *PEMTCERRORCACHECALC;

// EMTBEAMSEARCH
typedef struct {
   // on all EMTCxxx
   DWORD          dwStart;       // start count
   DWORD          dwEnd;         // end count
   DWORD          dwType;        // type

   PCListFixed    plUNITOPTION;
   PCMem          pmemFrom;
   PCMem          pmemTo;
   DWORD          dwTime;
   DWORD          *pdwWord;
   PBYTE          pbWordPos;
   PBYTE          pbPhone;
   PBYTE          pbTPhoneNoStress;
   PBYTE          pbTPhoneGroup;
   BYTE           bSilence;
   fp             *pafSmooth;
   PCListFixed    plUNITOPTIONLast;
   fp             fEnergy;
   DWORD          dwDurationX;
   DWORD          dwFuncWordGroup;
   fp             fEnergyPrev;
   BOOL           fUsePitch;
   int            iPitchLeft;
   int            iPitchCenter;
   int            iPitchRight;
   fp             fEnergyAverage;
   DWORD          dwNum;
   double         *pfCutOff;
   DWORD          *padwModulo;
   BOOL           fDisablePCM;
} EMTBEAMSEARCH, *PEMTBEAMSEARCH;

// EMTJOINFINDBEST
typedef struct {
   // on all EMTCxxx
   DWORD          dwStart;       // start count (demiphones)
   DWORD          dwEnd;         // end count
   DWORD          dwType;        // type

   DWORD          dwNum;         // number of phonemes
   DWORD          dwNumDemi;     // number of demiphones in the sentence
   PCMTTSTriPhoneAudio *pptp;    // Triphone audio, dwNumDemi
   PSYNTHUNITJOININFO   paSUJI;  // array of one per demiphone, dwNumDemiu num
   int            iTTSQuality;   // TTS quality to use
   DWORD          *padwSkip;     // skip info
} EMTJOINFINDBEST, *PEMTJOINFINDBEST;


/*************************************************************************************
CMTTS::EscMultiThreadedCallback - Standard call
*/
void CMTTS::EscMultiThreadedCallback (PVOID pParams, DWORD dwParamSize, DWORD dwThread)
{
   DWORD *padw = (DWORD*)pParams;
   DWORD dwStart = padw[0];
   DWORD dwEnd = padw[1];
   DWORD dwType = padw[2];
   DWORD i, j;

   switch (dwType) {
   case 30: // SynthUnit JoinFindBest
      {
         PEMTJOINFINDBEST pe = (PEMTJOINFINDBEST) pParams;

         PSYNTHUNITJOININFO paSUJI = pe->paSUJI;
         int iTTSQuality = pe->iTTSQuality;
         DWORD dwNum = pe->dwNum;
         PCMTTSTriPhoneAudio *pptp = pe->pptp;
         DWORD *padwSkip = pe->padwSkip;

         for (i = pe->dwStart; i < pe->dwEnd; i++) {

            paSUJI[i].dwBestA = paSUJI[i].dwBestB = (DWORD)-1;
            paSUJI[i].fJoinScore = 0;

            DWORD dwDemiPhone = i;
            DWORD dwCurDemiPhone = i;

            PCMTTSTriPhoneAudio pCenter = pptp[dwCurDemiPhone];
            PCMTTSTriPhoneAudio pLeft = dwCurDemiPhone ? pptp[dwCurDemiPhone-1] : NULL;
            PCMTTSTriPhoneAudio pRight = (dwCurDemiPhone+1 < dwNum*TTSDEMIPHONES) ? pptp[dwCurDemiPhone+1] : NULL;
            DWORD dwSkip = padwSkip[dwCurDemiPhone];
            DWORD dwSkipLeft = dwCurDemiPhone ? padwSkip[dwCurDemiPhone-1] : 0;
            DWORD dwSkipRight = (dwCurDemiPhone+1 < dwNum*TTSDEMIPHONES) ? padwSkip[dwCurDemiPhone+1] : 0;

            DWORD dwDemiPhoneMod = dwDemiPhone % TTSDEMIPHONES;

            // where are the joins for the left, center, and right?
            DWORD adwFeatureJoin[3][2];   // [0=left,1=center,2=right][0=left,1=right]
            DWORD adwFeatureJoinIdeal[3][2]; // like adwFeatureJoin, but ideal locations
            SynthUnitCalcFeatureJoins (dwDemiPhoneMod + TTSDEMIPHONES - 1 /* so modulo around */, pLeft, dwSkipLeft,
               &adwFeatureJoin[0][0], &adwFeatureJoin[0][1], &adwFeatureJoinIdeal[0][0], &adwFeatureJoinIdeal[0][1]);
            SynthUnitCalcFeatureJoins (dwDemiPhoneMod, pCenter, dwSkip,
               &adwFeatureJoin[1][0], &adwFeatureJoin[1][1], &adwFeatureJoinIdeal[1][0], &adwFeatureJoinIdeal[1][1]);
            SynthUnitCalcFeatureJoins (dwDemiPhoneMod + 1, pRight, dwSkipRight,
               &adwFeatureJoin[2][0], &adwFeatureJoin[2][1], &adwFeatureJoinIdeal[2][0], &adwFeatureJoinIdeal[2][1]);

            // see where the center unit joins up with the right
            if (!pCenter || !pRight)
               continue;

      #ifdef _DEBUG
            DWORD dwOldA = adwFeatureJoin[1][1];
            DWORD dwOldB = adwFeatureJoin[2][0];
      #endif

            int iBestCompareQuality;
            int iJoinCompareQuality;
            if (iTTSQuality <= 0) {
               iBestCompareQuality = 0; // BUGFIX - Was 1, but too slow on single-core
               iJoinCompareQuality = 0;
            }
            else if (iTTSQuality == 1) {
               iBestCompareQuality = 1;   // BUGFIX - Was 2, but changed to every 3rd feature
               iJoinCompareQuality = 1;
            }
            else if (iTTSQuality == 2) {
               iBestCompareQuality = 2;   // BUGFIX - Was 3, but changed to every other feature
               iJoinCompareQuality = 2;
            }
            else {   // iTTSQUality >= 3
               iBestCompareQuality = 3;
               iJoinCompareQuality = 3;
            }

            // if have center phoneme and right phoneme, then ignore skip (because will get solved eventually)
            // and calculate the right error
            DWORD dwRangeA = (adwFeatureJoin[1][1] - adwFeatureJoin[1][0] + JOINFINDBESTRANGE - 1) / JOINFINDBESTRANGE;  // half a demiphone
            DWORD dwRangeB = (adwFeatureJoin[2][1] - adwFeatureJoin[2][0] + JOINFINDBESTRANGE - 1) / JOINFINDBESTRANGE; // half a demiphone
               // BUGFIX - Instead of half a demiphone range, do 1/3 of a demiphone
            dwRangeA = min(dwRangeA, MAXJOINRANGE);
            dwRangeB = min(dwRangeB, MAXJOINRANGE);
            DWORD dwHalfWindow = JOINHALFWINDOWSIZE;
            fp fJoinScore = JoinFindBest (
               &m_acsTTSWave[pCenter->m_wOrigWave % MAXRAYTHREAD],
               &m_acsTTSWave[pRight->m_wOrigWave % MAXRAYTHREAD],
               pCenter->m_wOrigWave, pRight->m_wOrigWave,
               adwFeatureJoin[1][1], adwFeatureJoin[2][0],
               dwRangeA, dwRangeB,
               adwFeatureJoinIdeal[1][1], adwFeatureJoinIdeal[2][1],
               dwHalfWindow,
               iBestCompareQuality, iBestCompareQuality,
               &paSUJI[i].dwBestA, &paSUJI[i].dwBestB);

            paSUJI[i].fJoinScore = fJoinScore;

         } // i, over all joins
      }
      return;

   case 20: // beam search
      {
#if 0 // def _DEBUG
         DWORD dwStartTime = GetTickCount();
#endif

         PEMTBEAMSEARCH pe = (PEMTBEAMSEARCH) pParams;

         PCListFixed plUNITOPTION = pe->plUNITOPTION;
         PUNITOPTION puo = (PUNITOPTION) plUNITOPTION->Get(0);
         PCMem pmemFrom = pe->pmemFrom;
         PCMem pmemTo = pe->pmemTo;
         DWORD dwTime = pe->dwTime;
         DWORD *pdwWord = pe->pdwWord;
         PBYTE pbWordPos = pe->pbWordPos;
         PBYTE pbPhone = pe->pbPhone;
         PBYTE pbTPhoneNoStress = pe->pbTPhoneNoStress;
         PBYTE pbTPhoneGroup = pe->pbTPhoneGroup;
         BYTE bSilence = pe->bSilence;
         fp *pafSmooth = pe->pafSmooth;
         PCListFixed plUNITOPTIONLast = pe->plUNITOPTIONLast;
         fp fEnergy = pe->fEnergy;
         DWORD dwDuration = pe->dwDurationX;
         DWORD dwFuncWordGroup = pe->dwFuncWordGroup;
         fp fEnergyPrev = pe->fEnergyPrev;
         BOOL fUsePitch = pe->fUsePitch;
         int iPitchLeft = pe->iPitchLeft;
         int iPitchCenter = pe->iPitchCenter;
         int iPitchRight = pe->iPitchRight;
         fp fEnergyAverage = pe->fEnergyAverage;
         DWORD dwNum = pe->dwNum;
         double *pfCutOff = pe->pfCutOff;
         DWORD *padwModulo = pe->padwModulo;
         BOOL fDisablePCM = pe->fDisablePCM;

         DWORD dwBest;
         double fBestScore;
         PPHONEHYP pahFrom;
         DWORD dwNumFrom = (DWORD)pmemFrom->m_dwCurPosn / sizeof(PHONEHYP);
         PHONEHYP ph, phBest;
         PCMTTSTriPhoneAudio ptNew;
         // double fCutOff = 1000000000000;
            // NOTE: Because multithreaded, won't cut off as many units, but shouldn't
            // be much of a problem, especially because of speed gain due to multithreaded

         // pou += dwStart
         // for (j = dwStart; j < dwEnd; j++, puo++) {
         DWORD dwModulo;
         DWORD dwLastJ = 0;
         for (dwModulo = dwStart; dwModulo < dwEnd; dwModulo++) {
            j = padwModulo[dwModulo];
            puo += (j - dwLastJ);
            dwLastJ = j;

            // remember the best
            dwBest = (DWORD)-1;
            fBestScore = 0;

            // loop over all existing hypothesis and find the one that results
            // in the best final score
            pahFrom = (PPHONEHYP)pmemFrom->p;
            for (i = 0; i < dwNumFrom; i++, pahFrom++) {
               // fill in new info
               memcpy (ph.aPCMTTSTriPhoneAudio, &pahFrom->aPCMTTSTriPhoneAudio[1], (PHONEHISTORY-1) * sizeof(PCMTTSTriPhoneAudio));
               ph.fScoreWithEnergy = pahFrom->fScoreWithEnergy;
               ph.fScoreNoEnergy = pahFrom->fScoreNoEnergy;

               if (!puo->pTPA) {
               //if (!pptp) {
                  // if silence (or unknown phoneme) then just add and dont calc score
                  ptNew = NULL;
                  ph.fEndSilence = TRUE;
                  goto addit;
               }
               //ptNew = pptp[j];
               ptNew = puo->pTPA;

               // determine the boundary
               double fBoundaryTheoretical = ScoreCalcBoundary (dwTime, ptNew, pdwWord, pbWordPos, pbPhone,
                  pbTPhoneNoStress, pbTPhoneGroup, bSilence,
                  NULL, pahFrom, ph.aPCMTTSTriPhoneAudio);
               _ASSERTE (fBoundaryTheoretical < 10000);

               // calculate the blend
               BOOL fWordStart = (*pbWordPos & 0x01);
               BOOL fSylStart = (*pbWordPos & 0x04);
               double fBoundaryCalc = pafSmooth[plUNITOPTIONLast->Num() * j + pahFrom->dwPreviousIndex];
               //fBoundaryCalc = ATSTARTOFPHONE ? CROSSWORDLESSPENALTYLEFT(fBoundaryCalc) : fBoundaryCalc;
                  // BUGFIX - If not at the start of the phoneme, then CROSSWORDLESSPENALTYLEFT

               double fBoundary = SCORECALCWEIGHTTHEORETICALBOUNDARY * fBoundaryTheoretical +
                  (1.0 - SCORECALCWEIGHTTHEORETICALBOUNDARY) * fBoundaryCalc;
               double fWeightBoundary = ScoreCalcWeightBoundary (fEnergyPrev, fEnergy);
               double fWeightBoundaryNoEnergy = ScoreCalcWeightBoundary (1.0, 1.0);
                  //dwDurationPrev, dwDuration,
                  //(dwTime ? pbWordPos[(dwTime-1)/TTSDEMIPHONES] : 0),
                  //pbWordPos[dwTime/TTSDEMIPHONES] );

               ph.fScoreWithEnergy += fWeightBoundary * fBoundary;
               ph.fScoreNoEnergy += fWeightBoundaryNoEnergy * fBoundary;

               // BUGFIX - partial check to see if eliminate early
               if (ph.fScoreWithEnergy > *pfCutOff) // NOTE - No worry about thread safety since atmoic, and will only go down
                  continue;
               if ((dwBest != (DWORD)-1) && (ph.fScoreWithEnergy >= phBest.fScoreWithEnergy))
                  continue;
              


               // calculate weight for self
               double fScoreCalcWeightSelf = ScoreCalcWeightSelf (fEnergy, dwDuration);
               double fScoreCalcWeightSelfNoEnergy = ScoreCalcWeightSelf (1.0, SRSAMPLESPERSEC / 10);
                  // BUGFIX - Assume average phoneme is 1/10th of a second, so don't end up preferring short sentences
               double fSelfA =
                  ScoreCalcSelfA (dwTime, ptNew, NULL /*ph.aPCMTTSTriPhoneAudio[PHONEHISTORY-2]*/, fUsePitch, iPitchLeft, iPitchCenter, iPitchRight, dwDuration, fEnergy, dwFuncWordGroup,
                     pdwWord, pbWordPos, pbPhone, pbTPhoneNoStress, pbTPhoneGroup, bSilence, NULL, pahFrom,
                     fDisablePCM);
               _ASSERTE (fSelfA < 10000);
               ph.fScoreWithEnergy += fSelfA * fScoreCalcWeightSelf;
               ph.fScoreNoEnergy += fSelfA * fScoreCalcWeightSelfNoEnergy;
               if (ph.fScoreWithEnergy > *pfCutOff) // NOTE - No worry about thread safety since atmoic, and will only go down
                  continue;
               if ((dwBest != (DWORD)-1) && (ph.fScoreWithEnergy >= phBest.fScoreWithEnergy))
                  continue;

               // second part
               double fSelfB =
                  ScoreCalcSelfB (dwTime, ptNew, ph.aPCMTTSTriPhoneAudio[PHONEHISTORY-2], fUsePitch, iPitchLeft, iPitchCenter, iPitchRight, dwDuration, fEnergy, dwFuncWordGroup,
                     pdwWord, pbWordPos, pbPhone, pbTPhoneNoStress, pbTPhoneGroup, bSilence, NULL, pahFrom,
                     fDisablePCM);
               _ASSERTE (fSelfB < 10000);
               ph.fScoreWithEnergy += fSelfB * fScoreCalcWeightSelf;
               ph.fScoreNoEnergy += fSelfB * fScoreCalcWeightSelfNoEnergy;



               ph.fEndSilence = ATENDOFPHONE && (ptNew->m_bPhoneRight == bSilence);
                  // BUGFIX - endsielnce only if at end of this phone


      addit:
               // if this isn't the best score then don't bother
               if ((dwBest != (DWORD)-1) && (ph.fScoreWithEnergy >= phBest.fScoreWithEnergy))
                  continue;

               if (ph.fScoreWithEnergy > *pfCutOff) // NOTE - No worry about thread safety since atmoic, and will only go down
                  continue;

               EnterCriticalSection (&m_csSynthBeamSearch);
               // if this score isn't nearly as good as the best score then don't bother
               if (ph.fScoreWithEnergy <= *pfCutOff) {
                  // write this
                  phBest = ph;
                  phBest.aPCMTTSTriPhoneAudio[PHONEHISTORY-1] = ptNew;
                  phBest.dwPreviousIndex = j; // remember the location in this
                  dwBest = j;
                  *pfCutOff = phBest.fScoreWithEnergy + HYPAUTOCULL;
               }
               LeaveCriticalSection (&m_csSynthBeamSearch);
            } // i

            // if best then keep it
            if (dwBest != (DWORD)-1) {
               EnterCriticalSection (&m_csSynthBeamSearch);
               // make sure enough memory
               if (!pmemTo->Required (pmemTo->m_dwCurPosn + dwNum * sizeof(PHONEHYP)))
                  return;  // error
               memcpy ((PBYTE)pmemTo->p + pmemTo->m_dwCurPosn, &phBest, sizeof(phBest));
               pmemTo->m_dwCurPosn += sizeof(phBest);
               LeaveCriticalSection (&m_csSynthBeamSearch);
            }
         } // j, unit options

#if 0 // def _DEBUG
         WCHAR szTemp[64];
         swprintf (szTemp, L"[T %d = %d]", (int)dwStart, (int)(GetTickCount() - dwStartTime));
         OutputDebugStringW (szTemp);
#endif
      }
      return;

   case 9:  // prelim score calc
      {
         PEMTCERRORCACHECALC pe = (PEMTCERRORCACHECALC) pParams;

         PCMTTSTriPhoneAudio *pptp = pe->pptp;
         PCListFixed plUNITOPTION = pe->plUNITOPTION;
         fp fEnergy = pe->fEnergy;
         DWORD dwDuration = pe->dwDurationX;
         DWORD dwFuncWordGroup = pe->dwFuncWordGroup;
         fp fEnergyPrev = pe->fEnergyPrev;
         DWORD dwTime = pe->dwTime;
         BOOL fUsePitch = pe->fUsePitch;
         int iPitchLeft = pe->iPitchLeft;
         int iPitchCenter = pe->iPitchCenter;
         int iPitchRight = pe->iPitchRight;
         DWORD *pdwWord = pe->pdwWord;
         PBYTE pbWordPos = pe->pbWordPos;
         PBYTE pbPhone = pe->pbPhone;
         PBYTE pbTPhoneNoStress = pe->pbTPhoneNoStress;
         PBYTE pbTPhoneGroup = pe->pbTPhoneGroup;
         BYTE bSilence = pe->bSilence;
         PCMem pmemFrom = pe->pmemFrom;
         DWORD dwPass = pe->dwPass;
         int iTTSQuality = pe->iTTSQuality;
         BOOL fDisablePCM = pe->fDisablePCM;

         iTTSQuality = max(iTTSQuality, 0);
         iTTSQuality = min(iTTSQuality, NUMJOINQUALITY-1);

         UNITOPTION uo;
         PCMTTSTriPhoneAudio ptNew;
         DWORD dwNumPPHLast = (DWORD)pmemFrom->m_dwCurPosn / sizeof(PHONEHYP);
         PPHONEHYP pPPHLast = (PPHONEHYP) pmemFrom->p;

         for (j = dwStart; j < dwEnd; j++) {
            memset (&uo, 0, sizeof(uo));

            if (!pptp) {
               // if silence (or unknown phoneme) then just add and dont calc score
               // add empty UO
               EnterCriticalSection (&m_csSynthBeamSearch);
               plUNITOPTION->Add (&uo);
               LeaveCriticalSection (&m_csSynthBeamSearch);
               continue;
            }
            ptNew = pptp[j];

            DWORD dwLastPhone = 0;


            double fScoreCalcWeightSelf = ScoreCalcWeightSelf (fEnergy, dwDuration);
            double fWeightBoundary = ScoreCalcWeightBoundary (fEnergyPrev, fEnergy);
               //dwDurationPrev, dwDuration,
               //(dwTime ? pbWordPos[(dwTime-1)/TTSDEMIPHONES] : 0),
               //pbWordPos[dwTime/TTSDEMIPHONES] );

            // can precalc this part
            double fSelfA = ScoreCalcSelfA (dwTime, ptNew, NULL, fUsePitch, iPitchLeft, iPitchCenter, iPitchRight, dwDuration, fEnergy, dwFuncWordGroup,
               pdwWord, pbWordPos, pbPhone, pbTPhoneNoStress, pbTPhoneGroup, bSilence, &dwLastPhone, NULL,
               fDisablePCM);
            _ASSERTE (fSelfA < 10000);
            
            // loop over all existing hypothesis and see which ones would have the best score
            DWORD k;
            double fScoreBest = 0;
            double fScore;
            DWORD dwBest = (DWORD)-1;
            for (k = 0; k < dwNumPPHLast; k++) {
               fScore = pPPHLast[k].fScoreWithEnergy + fSelfA * fScoreCalcWeightSelf;

               // BUGFIX - Do ScoreCalcBoundary() first because faster than ScoreCalcSelfB, and produces larger values
               PCMTTSTriPhoneAudio pUnitKpTPA = pPPHLast[k].aPCMTTSTriPhoneAudio[PHONEHISTORY-1];
               if (pUnitKpTPA)
                  dwLastPhone = MAKELONG (pUnitKpTPA->m_wOrigPhone, pUnitKpTPA->m_wOrigWave);
               else
                  dwLastPhone = (DWORD)-1;

               double fBoundary;
               if (!pUnitKpTPA || !ptNew)
                  fBoundary = 0; // since silence
               else if ((dwTime % TTSDEMIPHONES) && (pUnitKpTPA == ptNew))
                  fBoundary = 0; // since same unit connecting to self
               else if (!(dwTime % TTSDEMIPHONES) &&
                  (ptNew->m_wOrigWave == pUnitKpTPA->m_wOrigWave) &&
                  (ptNew->m_wOrigPhone == pUnitKpTPA->m_wOrigPhone+1) )
                     fBoundary = 0; // since same unit connecting to self
               else if (dwPass) {
                  fp fValue;
                  // BUGFIX - Reversed order that passed to ConnectErrorCacheGet()
                  if (ptNew->ConnectErrorCacheGet((DWORD)iTTSQuality, pUnitKpTPA, (dwTime % TTSDEMIPHONES), &fValue))
                     fBoundary = fValue;
                  else // shouldnt happen
                     fBoundary = ScoreCalcBoundary (dwTime, ptNew, pdwWord, pbWordPos, pbPhone, pbTPhoneNoStress,
                        pbTPhoneGroup, bSilence, &dwLastPhone, NULL, NULL);
               }
               else
                  // first pass, so guestimate
                  fBoundary = ScoreCalcBoundary (dwTime, ptNew, pdwWord, pbWordPos, pbPhone, pbTPhoneNoStress,
                     pbTPhoneGroup, bSilence, &dwLastPhone, NULL, NULL);
               _ASSERTE (fBoundary < 10000);

               fScore += fWeightBoundary * fBoundary;

               // BUGFIX - fast eliminate
               if ((dwBest != (DWORD)-1) && (fScore >= fScoreBest))
                  continue;



               // BUGFIX - Because fSelf depends on hypothesized last triphone, moving ScoreCalcSelf() into
               // this loop
               double fSelfB = ScoreCalcSelfB (dwTime, ptNew, pUnitKpTPA, fUsePitch, iPitchLeft, iPitchCenter, iPitchRight, dwDuration, fEnergy, dwFuncWordGroup,
                  pdwWord, pbWordPos, pbPhone, pbTPhoneNoStress, pbTPhoneGroup, bSilence, &dwLastPhone, NULL,
                  fDisablePCM);
                        // NOTE: Exact value for dwLastPhone doesn't matter for ScoreCalcSelf
               _ASSERTE (fSelfB < 10000);
               fScore += fSelfB * fScoreCalcWeightSelf;


               // if this is better than the best score, then remember
               if ((dwBest == (DWORD)-1) || (fScore < fScoreBest)) {
                  dwBest = k;
                  fScoreBest = fScore;
               }
            } // k



            // remember the best of all possible scores
            uo.fScore = (dwBest != (DWORD)-1) ? fScoreBest : 1000000000000;

            // add this
            uo.pTPA = ptNew;

            EnterCriticalSection (&m_csSynthBeamSearch);
            plUNITOPTION->Add (&uo);
            LeaveCriticalSection (&m_csSynthBeamSearch);
         } // j      
      }
      return;

   case 10: // error-calc from GenerateUnitOption
      {
         PEMTCERRORCACHECALC pe = (PEMTCERRORCACHECALC) pParams;

         PUNITOPTION pUnit = pe->pUnit;
         PUNITOPTION pUnitI, pUnitLastJ = NULL;
         PCMTTSTriPhoneAudio pUnitIpTPA, pUnitLastJpTPA;
         DWORD dwTime = pe->dwTime;
         PCListFixed plUNITOPTIONLast = pe->plUNITOPTIONLast;
         fp *paf = pe->paf + dwStart * plUNITOPTIONLast->Num();
         BOOL *pafLastUsed = pe->pafLastUsed;
         BOOL *pafIsValidEnergy = pe->pafIsValidEnergy;
         fp *pafLastEnergy = pe->pafLastEnergy;
         int iTTSQuality = pe->iTTSQuality;
         DWORD dwPass = pe->dwPass;
         PCMem pmemFrom = pe->pmemFrom;
         DWORD dwNumPPHLast = (DWORD)pmemFrom->m_dwCurPosn / sizeof(PHONEHYP);
         PPHONEHYP pPPHLast = (PPHONEHYP) pmemFrom->p;

         int iBestCompareQuality;
         int iJoinCompareQuality;
         iTTSQuality = max(iTTSQuality, 0);
         iTTSQuality = min(iTTSQuality, NUMJOINQUALITY-1);
         if (iTTSQuality <= 0) {
            iBestCompareQuality = 0;
            iJoinCompareQuality = 0;
         }
         else if (iTTSQuality == 1) {
            iBestCompareQuality = 0;
            iJoinCompareQuality = 1;
         }
         else if (iTTSQuality == 2) {
            iBestCompareQuality = 1;
            iJoinCompareQuality = 1;
         }
         else {   // iTTSQUality >= 3
            iBestCompareQuality = 2;
            iJoinCompareQuality = 2;
         }

         //PSRFEATURESMALL apSRF[4];
         // fp afEnergy[4], afRealEnergy[4], afDB[4];
         CListFixed lTPA, lTPAScore;
         //SRFEATURESMALL srfSilence;
         //memset (&srfSilence, 0, sizeof(srfSilence));
         //for (i = 0; i < SRDATAPOINTSSMALL; i++) {
         //   srfSilence.acNoiseEnergyMain[i] = SRNOISEFLOOR;
         //   srfSilence.acVoiceEnergyMain[i] = SRABSOLUTESILENCE;
         //   srfSilence.acNoiseEnergyDelta[i] = SRABSOLUTESILENCE;
         //   srfSilence.acVoiceEnergyDelta[i] = SRABSOLUTESILENCE;
         //} // i
         //fp fSilenceEnergy = SRFEATUREEnergySmall (TRUE, &srfSilence, FALSE, TRUE);
         //SRFEATUREScale (&srfSilence, PHONESAMPLENORMALIZED / fSilenceEnergy);
         PUNITOPTION pUnitLast = (PUNITOPTION)plUNITOPTIONLast->Get(0);
         //DWORD k;
         //double fError;

         for (i = dwStart; i < dwEnd; i++) {
            pUnitI = &pUnit[i];
            pUnitIpTPA = pUnitI->pTPA;

            DWORD dwStartIndex = (dwTime % TTSDEMIPHONES)*2;
            // determine the comparison and energies
//            if (pUnitIpTPA) {
//               // remember two bits from start
//               apSRF[0] = &pUnitIpTPA->m_aSRFeatBoundary[dwStartIndex+0];
//               apSRF[1] = &pUnitIpTPA->m_aSRFeatBoundary[dwStartIndex+1];
//               afEnergy[0] = pUnitIpTPA->m_afSRFeatBoundary[dwStartIndex+0];
//               afEnergy[1] = pUnitIpTPA->m_afSRFeatBoundary[dwStartIndex+1];
//            }
//            else {
//               // this is silence, so nothing
//               apSRF[0] = apSRF[1] = &srfSilence;
//               afEnergy[0] = afEnergy[1] = fSilenceEnergy;
//            }

            // calculate the real energy for better tests. should
            // be close to PHONESAMPLENORMALIZED
//            afRealEnergy[0] = SRFEATUREEnergySmall (TRUE, apSRF[0], FALSE, TRUE);
//            afRealEnergy[1] = SRFEATUREEnergySmall (TRUE, apSRF[1], FALSE, TRUE);
//            afDB[0] = AmplitudeToDb(afEnergy[0] / THEORETICALMAXENERGY * (fp)0x8000);
//            afDB[1] = AmplitudeToDb(afEnergy[1] / THEORETICALMAXENERGY * (fp)0x8000);

            lTPA.Init (sizeof(PCMTTSTriPhoneAudio));
            lTPAScore.Init (sizeof(fp));

            // loop over the previous options
            DWORD dwMaxJ = dwPass ? plUNITOPTIONLast->Num() : dwNumPPHLast;
            for (j = 0; j < dwMaxJ; j++, paf++) {
               if (dwPass) {
                  // if not used then skip
                  if (!pafLastUsed[j])
                     continue;

                  pUnitLastJ = &pUnitLast[j];
                  pUnitLastJpTPA = pUnitLastJ->pTPA;
               }
               else
                  pUnitLastJpTPA = pPPHLast[j].aPCMTTSTriPhoneAudio[PHONEHISTORY-1];


               // BUGFIX - If missing either pUnitIpTPA or  pUnitLastJpTPA, then assume 0 error
               if (!pUnitIpTPA || !pUnitLastJpTPA) {
                  if (dwPass)
                     paf[0] = 0;
                  continue;
               }

               // if these are the same wave then error = 0
               if ((dwTime % TTSDEMIPHONES) && (pUnitIpTPA == pUnitLastJpTPA)) {
                  // optimiziation since will match against itself, so should be no error
                  if (dwPass)
                     paf[0] = 0;
                  continue;
               }
               else if (!(dwTime % TTSDEMIPHONES) && pUnitIpTPA && pUnitLastJpTPA &&
                  (pUnitIpTPA->m_wOrigWave == pUnitLastJpTPA->m_wOrigWave) &&
                  (pUnitIpTPA->m_wOrigPhone == pUnitLastJpTPA->m_wOrigPhone+1) ) {

                  // optimizations so score for contiguous is 0
                  if (dwPass)
                     paf[0] = 0;
                  continue;
               }


               fp fValue;
               // BUGFIX - Reversed order that passed to ConnectErrorCacheGet()
               if (pUnitIpTPA->ConnectErrorCacheGet((DWORD)iTTSQuality, pUnitLastJpTPA, (dwTime % TTSDEMIPHONES), &fValue)) {
                  // if not second pass then MUST add this in to ensure it's not flushed
                  if (!dwPass)
                     goto addin;

                  paf[0] = fValue;  // BUGFIX - unintentionally deleted this
                  continue;   // already cached
               }

               // find the join locations
               DWORD adwFeatureJoin[2][2];   // [0=left phone,1=right phone][0=left,1=right]
               DWORD adwFeatureJoinIdeal[2][2]; // like adwFeatureJoin, but ideal locations
               SynthUnitCalcFeatureJoins (dwTime + TTSDEMIPHONES - 1 /*left*/, pUnitLastJpTPA, 0 /* skip none*/,
                  &adwFeatureJoin[0][0], &adwFeatureJoin[0][1], &adwFeatureJoinIdeal[0][0], &adwFeatureJoinIdeal[0][1]);
               SynthUnitCalcFeatureJoins (dwTime /*right*/, pUnitIpTPA, 0 /* skip none*/,
                  &adwFeatureJoin[1][0], &adwFeatureJoin[1][1], &adwFeatureJoinIdeal[1][0], &adwFeatureJoinIdeal[1][1]);

               // how much to scan
               DWORD dwBestA, dwBestB;
               DWORD dwRangeA = (adwFeatureJoin[0][1] - adwFeatureJoin[0][0] + JOINFINDBESTRANGE - 1) / JOINFINDBESTRANGE;  // half a demiphone
               DWORD dwRangeB = (adwFeatureJoin[1][1] - adwFeatureJoin[1][0] + JOINFINDBESTRANGE - 1) / JOINFINDBESTRANGE; // half a demiphone
               dwRangeA = min(dwRangeA, MAXJOINRANGE);
               dwRangeB = min(dwRangeB, MAXJOINRANGE);
               DWORD dwHalfWindow = JOINHALFWINDOWSIZE;

               // calculate the difference
               fp fScoreBest = JoinFindBest (
                  &m_acsTTSWave[pUnitLastJpTPA->m_wOrigWave % MAXRAYTHREAD],
                  &m_acsTTSWave[pUnitIpTPA->m_wOrigWave % MAXRAYTHREAD],
                  pUnitLastJpTPA->m_wOrigWave, pUnitIpTPA->m_wOrigWave,
                  adwFeatureJoin[0][1], adwFeatureJoin[1][0],
                  dwRangeA, dwRangeB,
                  adwFeatureJoinIdeal[0][1], adwFeatureJoinIdeal[1][1],
                  dwHalfWindow,
                  iBestCompareQuality, iJoinCompareQuality,
                  &dwBestA, &dwBestB);

               fScoreBest /= (fp)JOINHALFWINDOWSIZE;  // because will be multiplied by this soon

               // write this
               if (dwPass)
                  paf[0] = fScoreBest;


#if 0 // old code for comparison, overruled by new JoinFindBest
               DWORD dwPrevIndex = (dwTime % TTSDEMIPHONES) ? dwStartIndex : (TTSDEMIPHONES * 2);


               // determine comparison and energies
               if (pUnitLastJpTPA) {
                  // remember two bits from start
                  apSRF[2] = &pUnitLastJpTPA->m_aSRFeatBoundary[dwPrevIndex+0];
                  apSRF[3] = &pUnitLastJpTPA->m_aSRFeatBoundary[dwPrevIndex+1];
                  afEnergy[2] = pUnitLastJpTPA->m_afSRFeatBoundary[dwPrevIndex+0];
                  afEnergy[3] = pUnitLastJpTPA->m_afSRFeatBoundary[dwPrevIndex+1];
               }
               else {
                  // this is silence, so nothing
                  apSRF[2] = apSRF[3] = &srfSilence;
                  afEnergy[2] = afEnergy[3] = fSilenceEnergy;
               }

               // calculate the real energy for better tests. should
               // be close to PHONESAMPLENORMALIZED
               // BUGFIX - Was testing for i, should be testing for valid energy
               EnterCriticalSection (&m_csSynthBeamSearch);
               if (pafIsValidEnergy[j]) {
                  afRealEnergy[2] = pafLastEnergy[j*4+0];
                  afRealEnergy[3] = pafLastEnergy[j*4+1];
                  afDB[2] = pafLastEnergy[j*4+2];
                  afDB[3] = pafLastEnergy[j*4+3];
               }
               else {
                  pafLastEnergy[j*4+0] = afRealEnergy[2] = SRFEATUREEnergySmall (TRUE, apSRF[2], FALSE, TRUE);
                  pafLastEnergy[j*4+1] = afRealEnergy[3] = SRFEATUREEnergySmall (TRUE, apSRF[3], FALSE, TRUE);
                  pafLastEnergy[j*4+2] = afDB[2] = AmplitudeToDb(afEnergy[2] / THEORETICALMAXENERGY * (fp)0x8000);
                  pafLastEnergy[j*4+3] = afDB[3] = AmplitudeToDb(afEnergy[3] / THEORETICALMAXENERGY * (fp)0x8000);
                  pafIsValidEnergy[j] = TRUE;
               }
               LeaveCriticalSection (&m_csSynthBeamSearch);

               fError = 0;

               for (k = 0; k < 2; k++) {
                  // compare the two
                  DWORD dwA = k+0;
                  DWORD dwB = k+2;
      #if 0 // def _DEBUG // to test and make sure energy calculation is right
                  afRealEnergy[dwA] = SRFEATUREEnergy(apSRF[dwA]);
                  afRealEnergy[dwB] = SRFEATUREEnergy(apSRF[dwB]);
      #endif
                  fp fCompare = SRFEATURECompareSmall (TRUE, apSRF[dwA], afRealEnergy[dwA], apSRF[dwB], afRealEnergy[dwB]);
                  
                  // BUGFIX - Just in case decides to get really wild, which does if very large energies
                  fCompare = max (fCompare, 0.0);
                  fCompare = min (fCompare, 1.0);
                  
                  // find the higher number of db
                  fp fMaxDb = max(afDB[dwA], afDB[dwB]);
                  fMaxDb = 1 + fMaxDb/((fp)-SRNOISEFLOOR);   // so that at -60 decibles max, fCompare won't count for anything
                  fMaxDb = max(fMaxDb, 0);
                  fMaxDb = min(fMaxDb, 1);

                  // total error
                  fCompare = (fCompare * SRCOMPAREWEIGHT + fabs(afDB[dwA] - afDB[dwB])) * fMaxDb;
                     // penalty for difference in volume only counts half
                  fError += fCompare;
               } // k

               // fit it into a byte
               fError *= BORDERDBSCALE;   // so average these two
               //fError = max(fError, 0);
               //fError = min(fError, 255);
               paf[0] = fError;
#endif // 0
               fValue = fScoreBest;
   
addin:
               // store in cache
               if (pUnitIpTPA) {
                  lTPA.Add (&pUnitLastJpTPA);
                  lTPAScore.Add (&fValue);
                  // pUnitIpTPA->ConnectErrorCacheSet(pUnitLastJpTPA, (dwTime % TTSDEMIPHONES), paf[0]);
               }
            } // j

            // add them all at once
            if (pUnitIpTPA && lTPA.Num()) {
               // figure out cache size
               DWORD dwMaxUnitOptionFirst, dwMaxUnitOptionSecond;
               UnitCacheSize (iTTSQuality + 1 /* since subtracted before sent */, &dwMaxUnitOptionFirst, &dwMaxUnitOptionSecond);
               DWORD dwCacheSize;
               if (dwPass)
                  dwCacheSize = dwMaxUnitOptionSecond;
               else
                  dwCacheSize = dwMaxUnitOptionFirst;

               // BUGFIX - Disable since using too much memory on high quality large voices
               // dwCacheSize = dwCacheSize * ((DWORD)max(iTTSQuality,0)+1); // so quality 1 is same as before
                  // since always using 1 less quality when passed in to iTTSQUality

               pUnitIpTPA->ConnectErrorCacheSet((DWORD)iTTSQuality, (PCMTTSTriPhoneAudio*)lTPA.Get(0), (fp*)lTPAScore.Get(0), lTPA.Num(),
                  (dwTime % TTSDEMIPHONES),
                  dwCacheSize );
                     // BUGFIX - Was /100, but quickly allocated too much memory with 260K units
                     // because o(n2)
            }
         } // i

      }
      return;
   } // switch
}


/*************************************************************************************
CMTTS::UnitCacheSize - Calculates the unit cache size.

inputs
   int            iTTSQuality - Text to speech qualuty
   DWORD          *pdwFirstPass - Filled with frst pass size
   DWORD          *pdwSecondPass - Filled with second pass size.
returns
   none
*/
void CMTTS::UnitCacheSize (int iTTSQuality, DWORD *pdwFirstPass, DWORD *pdwSecondPass)
{

   // OPTIMIZATION: find out where the best error, and only allow to exceed by so much
   // BUGFIX - MAXUNITOPTION depends on number of units
   fp fMaxUnitOption = sqrt((double)m_dwUnits / (double)OPTIMALNUMUNITS) * (double)MAXUNITOPTION;
   int iTTSQualityLimited = min (max(iTTSQuality, 0), 3);
   // BUGFIX - Greater difference in quality
   fMaxUnitOption *= (0.33 + 0.66 * (fp)iTTSQualityLimited / 3.0);
   *pdwSecondPass = min ((DWORD)(fMaxUnitOption + 0.5) + 1, MAXUNITOPTIONTOTAL);

   // if this is the first pass then more units
   // ttsquality affects this
   // was if (!dwPass)...
   DWORD dwScale = (DWORD) max(iTTSQuality, 1);
   dwScale = min(dwScale, NUMJOINQUALITY-1);
   dwScale++;
   dwScale = dwScale * FIRSTPASSMAXUNITOPTIONSSCALE / NUMJOINQUALITY;
   *pdwFirstPass = (*pdwSecondPass) * dwScale;
}

/*************************************************************************************
CMTTS::GenerateUNITOPTION - Fills a list in with UNITOPTION structures, which
are used to limit the search for HypExpand.

inputs
   DWORD          dwTime - Use dwTime % TTSDEMIPHONES to determine the demophone
   PCMem          pmemFrom - Memory with list of PHONEHYP. m_dwCurPosn = memory where last one is
   DWORD          dwPhoneValid - Number of valid phonemes including and after pbPhone[0]. Thus, is pbPhone[0]
                  and pbPhone[1] are valid, this is 2.
   BYTE           *pbPhone - Phoneme to use at [0]. Also need [-1] and [1] to be valid
   BYTE           *pbWordPos - Word psotion (start, end or word)
                  0x01 = start of word
                  0x02 = end of word
                  0x04 = start of syllable
                  0x08 = end of syllable
                  0x10 = plosive
                  0x20 = voiced
   BYTE        *pbTPhoneGroup - Phoneme into group of 16, also need [-1] and [1] to be valid
   BYTE        *pbTPhoneNoStress - Phoneme without stress, also need [-1] and [1] to be valid
         // NOTE: For optimization reasons this function assumes NUMTRIPHONEGROUP == 3
   DWORD       *pdwWord - Word number using, or -1 if not known word
   int         iPitchLeft - Left pitch
   int         iPitchCenter - Center pitch
   int         iPitchRight - Right pitch
   // DWORD       dwDurationPrev - Duration of the previous half phone, or 0 if unknown
   DWORD       dwDuration - Duration of the phone, or 0 if unknown
   fp          fEnergy - Energy of the destination unit, so can choose appropraiote units
   fp          fEnergyPrev - Energy of the previous unit, for boundary weight
   BYTE        bSilence - What phoneme is silence
   DWORD       dwFuncWordGroup - Which function-word-group this is in, 0..NUMFUNCWORDGROUP(inclusive)
   fp          fEnergyAverage - Average energy over all requested phonemes. Used for score calc

   PCListFixed    plUNITOPTION - Initialized to sizeof(UNITOPTION) and filled in
   PCListFixed    plUNITOPTIONLast - Last unit option list. Can be filled with just silence if there
                     was none
   PCMem          pMemInter - Filled with an array of plUNITOPTIONLast.Num() x plUNITOPTION.Num() fp
                     indicating a pentalty to add to the score based on how well the units blend
                     together.
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL              fDisablePCM - Set to TRUE if PSOLA has been temporarily disabled
*/

static int _cdecl UNITOPTIONSort (const void *elem1, const void *elem2)
{
   UNITOPTION *pdw1, *pdw2;
   pdw1 = (UNITOPTION*) elem1;
   pdw2 = (UNITOPTION*) elem2;

   if (pdw1->fScore > pdw2->fScore)
      return 1;
   else if (pdw1->fScore < pdw2->fScore)
      return -1;
   else
      return 0;
   //return (int)pdw1->dwScore - (int)pdw2->dwScore;
}

void CMTTS::GenerateUNITOPTION (DWORD dwTime, PCMem pmemFrom, DWORD dwPhoneValid, BYTE *pbPhone,
                       BYTE *pbWordPos, BYTE *pbTPhoneGroup, BYTE *pbTPhoneNoStress,
                       DWORD *pdwWord, int iPitchLeft, int iPitchCenter, int iPitchRight,
                       /*DWORD dwDurationPrev,*/ DWORD dwDuration, fp fEnergy, fp fEnergyPrev, BYTE bSilence,
                       DWORD dwFuncWordGroup,
                       fp fEnergyAverage,
                       PCListFixed plUNITOPTION, PCListFixed plUNITOPTIONLast,
                       PCMem pMemInter,
                       int iTTSQuality, BOOL fDisablePCM)
{
#if 0 // def _DEBUG
   DWORD dwStartTime = GetTickCount();
#endif

   // generate quickfollow and previous
   DWORD i;
   DWORD dwMax = 0;
   //CHashDWORD hPrevious;
   //hPrevious.Init (sizeof(PUNITOPTION));
   PUNITOPTION pUnit; //  = (PUNITOPTION) plUNITOPTIONLast->Get(0);
   //for (i = 0; i < plUNITOPTIONLast->Num(); i++, pUnit++) {
   //   if (!pUnit->pTPA)
   //      continue;

   //   // hash
   //   dwMax = MAKELONG (pUnit->pTPA->m_wOrigPhone, pUnit->pTPA->m_wOrigWave);
   //   hPrevious.Add (dwMax, &pUnit);
   //} // i

   // determine which phoneme units need to look through
   PCMLexicon pLex = Lexicon();
   BYTE bPhoneTemp = PhonemeBackoff(*pbPhone, pLex, bSilence);
   PCListFixed pl = (bPhoneTemp != bSilence) ? (m_palPCMTTSTriPhoneAudio ? m_palPCMTTSTriPhoneAudio[bPhoneTemp] : NULL) : NULL;
   PCMTTSTriPhoneAudio *pptp;
   CListFixed lPCMTTSTriPhoneAudio;
   lPCMTTSTriPhoneAudio.Init (sizeof(PCMTTSTriPhoneAudio));
   DWORD dwNum;
   if (!pl || !pl->Num()) {
      // serious problem because have selected phoneme but no recordsing, therefore
      // just set to NULL pptp
      pptp = NULL;
      dwNum = 1;
   }
   else {
      pptp = (PCMTTSTriPhoneAudio*) pl->Get(0);
      dwNum = pl->Num();
   }

   // ignore pitch
   BOOL fUsePitch = FALSE;
   if (pl && pLex) {
      PLEXPHONE plp = pLex->PhonemeGetUnsort(bPhoneTemp);
      PLEXENGLISHPHONE pe = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;
      if (pe) // BUGFIX - Use pitch even for unvoiced  && (pe->dwCategory & PIC_VOICED))
         fUsePitch = TRUE;
   }

   // figure out cache size
   DWORD dwMaxUnitOptionFirst, dwMaxUnitOptionSecond;
   UnitCacheSize (iTTSQuality, &dwMaxUnitOptionFirst, &dwMaxUnitOptionSecond);
   DWORD dwMaxUnitOptionFirstHalf = max(dwMaxUnitOptionFirst/2, 1);

   // potentially reduce the size of the list
   // only do this if not the best quality
   // must be first or last time slice in phoneme
   CListFixed lTTPAReduced;
   DWORD dwTimeSlice = dwTime % TTSDEMIPHONES;
   if (pl && (iTTSQuality <= 2) && (TTSDEMIPHONES >= 2) &&
      (dwNum >= dwMaxUnitOptionFirstHalf) && // if don't have enough units in the first place this pass won't matter
      (!dwTimeSlice || (dwTimeSlice == (TTSDEMIPHONES-1)) ) ) {

      lTTPAReduced.Init (sizeof(PCMTTSTriPhoneAudio));
      lTTPAReduced.Required (dwNum);

      BYTE bGroupThis = pbTPhoneGroup[dwTimeSlice ? 1 : -1];

      BYTE bCompare;
      for (i = 0; i < dwNum; i++) {
         if (dwTimeSlice)
            bCompare = (BYTE) (pptp[i]->m_awTriPhone[0] >> 8); // right triphone
         else
            bCompare = (BYTE) pptp[i]->m_awTriPhone[0]; // left triphone
         
         if (bCompare == bGroupThis)
            lTTPAReduced.Add (&pptp[i]);
      } // i

      // if there are enough entries after this trim down, then use those
      // and speed up the whole process
      if (lTTPAReduced.Num() >= dwMaxUnitOptionFirstHalf) {
         pl = &lTTPAReduced;
         pptp = (PCMTTSTriPhoneAudio*) pl->Get(0);
         dwNum = pl->Num();
      }

   }

   // DWORD j;
   // loop over all the units
   // UNITOPTION uo;
   // PCMTTSTriPhoneAudio ptNew;
   PPHONEHYP pPPHLast = (PPHONEHYP) pmemFrom->p;
   DWORD dwNumPPHLast = (DWORD)pmemFrom->m_dwCurPosn / sizeof(PHONEHYP);

   // multithreaded callback
   EMTCERRORCACHECALC em;

   // limit TTS quality
   iTTSQuality = max(iTTSQuality, 0);
   iTTSQuality = min(iTTSQuality, NUMJOINQUALITY-1);

   DWORD dwPass;
   for (dwPass = (iTTSQuality >= QUICKJOINTESTQUALITYDELTA) ? 0 : 1; dwPass < 2; dwPass++) {
      // clear the list
      plUNITOPTION->Init (sizeof(UNITOPTION));

      // fill multithreaded structure
      memset (&em, 0, sizeof(em));
      em.dwType = 9;
      em.dwTime = dwTime;
      em.pptp = pptp;
      em.plUNITOPTION = plUNITOPTION;
      em.fEnergy = fEnergy;
      em.dwDurationX = dwDuration;
      em.dwFuncWordGroup = dwFuncWordGroup;
      em.fEnergyPrev = fEnergyPrev;
      em.fUsePitch = fUsePitch;
      em.iPitchLeft = iPitchLeft;
      em.iPitchCenter = iPitchCenter;
      em.iPitchRight = iPitchRight;
      em.pdwWord = pdwWord;
      em.pbWordPos = pbWordPos;
      em.pbPhone = pbPhone;
      em.pbTPhoneNoStress = pbTPhoneNoStress;
      em.pbTPhoneGroup = pbTPhoneGroup;
      em.bSilence = bSilence;
      em.pmemFrom = pmemFrom;
      em.iTTSQuality = iTTSQuality - (int)QUICKJOINTESTQUALITYDELTA;   // always do -1 here
      em.fDisablePCM = fDisablePCM;
      em.dwPass = (iTTSQuality >= QUICKJOINTESTQUALITYDELTA) ? dwPass : 0;  // if very low TTS quality then treat as first pass

      ThreadLoop (0, dwNum, 1, &em, sizeof(em), NULL);

   #if 0 // replaced by multithreaded callback
      for (j = 0; j < dwNum; j++) {
         memset (&uo, 0, sizeof(uo));

         if (!pptp) {
            // if silence (or unknown phoneme) then just add and dont calc score
            // add empty UO
            plUNITOPTION->Add (&uo);
            continue;
         }
         ptNew = pptp[j];

         DWORD dwLastPhone = 0;


         double fScoreCalcWeightSelf = ScoreCalcWeightSelf (fEnergy, dwDuration);
         double fWeightBoundary = ScoreCalcWeightBoundary (fEnergyPrev, fEnergy);
            //dwDurationPrev, dwDuration,
            //(dwTime ? pbWordPos[(dwTime-1)/TTSDEMIPHONES] : 0),
            //pbWordPos[dwTime/TTSDEMIPHONES] );

         // can precalc this part
         double fSelfA = ScoreCalcSelfA (dwTime, ptNew, NULL, fUsePitch, iPitchLeft, iPitchCenter, iPitchRight, dwDuration, fEnergy,
            pdwWord, pbWordPos, pbPhone, pbTPhoneNoStress, pbTPhoneGroup, bSilence, &dwLastPhone, NULL);
         
         // loop over all existing hypothesis and see which ones would have the best score
         DWORD k;
         double fScoreBest = 0;
         double fScore;
         DWORD dwBest = (DWORD)-1;
         for (k = 0; k < dwNumPPHLast; k++) {
            fScore = pPPHLast[k].fScore + fSelfA * fScoreCalcWeightSelf;

            // BUGFIX - Do ScoreCalcBoundary() first because faster than ScoreCalcSelfB, and produces larger values
            if (pUnitKpTPA)
               dwLastPhone = MAKELONG (
                  pUnitKpTPA->m_wOrigPhone,
                  pUnitKpTPA->m_wOrigWave);
            else
               dwLastPhone = (DWORD)-1;

            double fBoundary = ScoreCalcBoundary (dwTime, ptNew, pdwWord, pbWordPos, pbPhone, pbTPhoneNoStress,
               pbTPhoneGroup, bSilence, &dwLastPhone, NULL, NULL);
            _ASSERTE (fBoundary < 10000);

            fScore += fWeightBoundary * fBoundary;

            // BUGFIX - fast eliminate
            if ((dwBest != (DWORD)-1) && (fScore >= fScoreBest))
               continue;



            // BUGFIX - Because fSelf depends on hypothesized last triphone, moving ScoreCalcSelf() into
            // this loop
            double fSelfB = ScoreCalcSelfB (dwTime, ptNew, pUnitKpTPA, fUsePitch, iPitchLeft, iPitchCenter, iPitchRight, dwDuration, fEnergy,
               pdwWord, pbWordPos, pbPhone, pbTPhoneNoStress, pbTPhoneGroup, bSilence, &dwLastPhone, NULL);
                     // NOTE: Exact value for dwLastPhone doesn't matter for ScoreCalcSelf
            fScore += fSelfB * fScoreCalcWeightSelf;


            // if this is better than the best score, then remember
            if ((dwBest == (DWORD)-1) || (fScore < fScoreBest)) {
               dwBest = k;
               fScoreBest = fScore;
            }
         } // k



         // remember the best of all possible scores
         uo.fScore = (dwBest != (DWORD)-1) ? fScoreBest : 1000000000000;

         // add this
         uo.pTPA = ptNew;
         plUNITOPTION->Add (&uo);
      } // j
   #endif // 0 - replaced by multithreaded callback

   #if 0 // def _DEBUG
      WCHAR szTemp[64];
      swprintf (szTemp, L"\r\nIn GenerateUNITOPTIONe=%d\r\n\tWeightCalc time=%d",
         (int)dwTime, (int)(GetTickCount() - dwStartTime));
      OutputDebugStringW (szTemp);
      dwStartTime = GetTickCount();
   #endif

      // need to sort the list
      pUnit = (PUNITOPTION)plUNITOPTION->Get(0);
      qsort (pUnit, plUNITOPTION->Num(), sizeof(UNITOPTION), UNITOPTIONSort);
      
      DWORD dwMaxUnitOption = dwPass ? dwMaxUnitOptionSecond : dwMaxUnitOptionFirst;

      double fBestScore = plUNITOPTION->Num() ? pUnit[0].fScore : 0.0;
      for (i = 0; i < min(dwMaxUnitOption, plUNITOPTION->Num()); i++)
         if (pUnit[i].fScore > fBestScore + HYPAUTOCULL) // BUGFIX - Was MAXBORDERERROR
            break;
            // NOTE: +MAXBORDERERROR used so that on large voice, i hits the border at between 50 and 100,
            // with dwMaxUnitOption currently being 50. On smaller voices, hits the border about
            // half that value

   #if 0 // def _DEBUG
      WCHAR szTemp[128];
      swprintf (szTemp, L"\r\nUnitOption, best=%d, at MAXUNITOPTION=%d, cutoff=%d",
         (int)dwBestScore,
         (plUNITOPTION->Num() >= dwMaxUnitOption) ? (int)pUnit[dwMaxUnitOption-1].dwScore : -1,
         (int) i);
      OutputDebugStringW (szTemp);
   #endif

      // if there are too many units then cut off
      plUNITOPTION->Truncate (min(i, dwMaxUnitOption));
      pUnit = (PUNITOPTION)plUNITOPTION->Get(0);
      

      // remember this for next time around
      if (!dwPass) {
         lPCMTTSTriPhoneAudio.Init (sizeof(PCMTTSTriPhoneAudio));
         lPCMTTSTriPhoneAudio.Required (plUNITOPTION->Num());
         for (i = 0; i < plUNITOPTION->Num(); i++)
            if (pUnit[i].pTPA)
               lPCMTTSTriPhoneAudio.Add (&pUnit[i].pTPA);

         if (lPCMTTSTriPhoneAudio.Num()) {
            pptp = (PCMTTSTriPhoneAudio*) lPCMTTSTriPhoneAudio.Get(0);
            dwNum = lPCMTTSTriPhoneAudio.Num();
         }
         else {
            // silence
            pptp = NULL;
            dwNum = 1;
         }
      } // !dwPass

      // figure out which current plUNITOPTIONLast are actually used
      CMem memLastUsed;
      DWORD dwNeed = plUNITOPTIONLast->Num() * (sizeof(BOOL) + sizeof(BOOL) + 4 * sizeof(fp));
      if (!memLastUsed.Required (dwNeed))
         return;  // shouldnt happen
      BOOL *pafLastUsed = (BOOL*)memLastUsed.p;
      BOOL *pafIsValidEnergy = pafLastUsed + plUNITOPTIONLast->Num();
      fp *pafLastEnergy = (fp*) (pafIsValidEnergy + plUNITOPTIONLast->Num());
      memset (pafLastUsed, 0, dwNeed);
      for (i = 0; i < dwNumPPHLast; i++, pPPHLast++)
         pafLastUsed[pPPHLast->dwPreviousIndex] = TRUE;
      pPPHLast = (PPHONEHYP) pmemFrom->p; // since modified in loop

      // will need to calculate quality of unit intersections between old and new
      // and store away
      //SRFEATURESMALL srfSilence;
      //memset (&srfSilence, 0, sizeof(srfSilence));
      //for (i = 0; i < SRDATAPOINTSSMALL; i++) {
      //   srfSilence.acNoiseEnergy[i] = SRNOISEFLOOR;
      //   srfSilence.acVoiceEnergy[i] = SRABSOLUTESILENCE;
      //} // i
      //fp fSilenceEnergy = SRFEATUREEnergy (&srfSilence, FALSE);
      //SRFEATUREScale (&srfSilence, PHONESAMPLENORMALIZED / fSilenceEnergy);
      dwNeed = plUNITOPTION->Num() * plUNITOPTIONLast->Num() * sizeof(fp);
      if (!pMemInter->Required (dwNeed))
         return;  // shouldnt happen
      fp *paf = (fp*)pMemInter->p;
      memset (paf, 0, dwNeed);   // default to 0
      // PSRFEATURESMALL apSRF[4];
      // fp afEnergy[4], afRealEnergy[4], afDB[4];
      // PUNITOPTION pUnitLast = (PUNITOPTION)plUNITOPTIONLast->Get(0);
      // DWORD k;
      // double fError;
      // CListFixed lTPA, lTPAScore;

      // EMTCERRORCACHECALC em;
      memset (&em, 0, sizeof(em));
      em.dwType = 10;
      em.pUnit = pUnit;
      em.dwTime = dwTime;
      em.plUNITOPTIONLast = plUNITOPTIONLast;
      em.iTTSQuality = iTTSQuality - (dwPass ? 0 : QUICKJOINTESTQUALITYDELTA);
      em.paf = paf;
      em.pafLastUsed = pafLastUsed;
      em.pafIsValidEnergy = pafIsValidEnergy;
      em.pafLastEnergy = pafLastEnergy;
      em.dwPass = dwPass;  // pass in proper pass number
      em.pmemFrom = pmemFrom;

      ThreadLoop (0, plUNITOPTION->Num(), 1, &em, sizeof(em), NULL);



   #if 0 // moved into multihreaded
      for (i = 0; i < plUNITOPTION->Num(); i++) {
         DWORD dwStartIndex = (dwTime % TTSDEMIPHONES)*2;
         // determine the comparison and energies
         if (pUnit[i].pTPA) {
            // remember two bits from start
            apSRF[0] = &pUnit[i].pTPA->m_aSRFeatBoundary[dwStartIndex+0];
            apSRF[1] = &pUnit[i].pTPA->m_aSRFeatBoundary[dwStartIndex+1];
            afEnergy[0] = pUnit[i].pTPA->m_afSRFeatBoundary[dwStartIndex+0];
            afEnergy[1] = pUnit[i].pTPA->m_afSRFeatBoundary[dwStartIndex+1];
         }
         else {
            // this is silence, so nothing
            apSRF[0] = apSRF[1] = &srfSilence;
            afEnergy[0] = afEnergy[1] = fSilenceEnergy;
         }

         // calculate the real energy for better tests. should
         // be close to PHONESAMPLENORMALIZED
         afRealEnergy[0] = SRFEATUREEnergy (apSRF[0], FALSE);
         afRealEnergy[1] = SRFEATUREEnergy (apSRF[1], FALSE);
         afDB[0] = AmplitudeToDb(afEnergy[0] / THEORETICALMAXENERGY * (fp)0x8000);
         afDB[1] = AmplitudeToDb(afEnergy[1] / THEORETICALMAXENERGY * (fp)0x8000);

         lTPA.Init (sizeof(PCMTTSTriPhoneAudio));
         lTPAScore.Init (sizeof(fp));

         // loop over the previous options
         for (j = 0; j < plUNITOPTIONLast->Num(); j++, paf++) {
            // if not used then skip
            if (!pafLastUsed[j])
               continue;

            // if these are the same wave then error = 0
            if ((dwTime % TTSDEMIPHONES) && (pUnit[i].pTPA == pUnitLast[j].pTPA)) {
               // optimiziation since will match against itself, so should be no error
               paf[0] = 0;
               continue;
            }
            else if (!(dwTime % TTSDEMIPHONES) && pUnit[i].pTPA && pUnitLast[j].pTPA &&
               (pUnit[i].pTPA->m_wOrigWave == pUnitLast[j].pTPA->m_wOrigWave) &&
               (pUnit[i].pTPA->m_wOrigPhone == pUnitLast[j].pTPA->m_wOrigPhone+1) ) {

               // optimizations so score for contiguous is 0
               paf[0] = 0;
               continue;
            }

            if (pUnit[i].pTPA && pUnit[i].pTPA->ConnectErrorCacheGet(pUnitLast[j].pTPA, (dwTime % TTSDEMIPHONES), paf))
               continue;   // already cached

            DWORD dwPrevIndex = (dwTime % TTSDEMIPHONES) ? dwStartIndex : (TTSDEMIPHONES * 2);


            // determine comparison and energies
            if (pUnitLast[j].pTPA) {
               // remember two bits from start
               apSRF[2] = &pUnitLast[j].pTPA->m_aSRFeatBoundary[dwPrevIndex+0];
               apSRF[3] = &pUnitLast[j].pTPA->m_aSRFeatBoundary[dwPrevIndex+1];
               afEnergy[2] = pUnitLast[j].pTPA->m_afSRFeatBoundary[dwPrevIndex+0];
               afEnergy[3] = pUnitLast[j].pTPA->m_afSRFeatBoundary[dwPrevIndex+1];
            }
            else {
               // this is silence, so nothing
               apSRF[2] = apSRF[3] = &srfSilence;
               afEnergy[2] = afEnergy[3] = fSilenceEnergy;
            }

            // calculate the real energy for better tests. should
            // be close to PHONESAMPLENORMALIZED
            // BUGFIX - Was testing for i, should be testing for valid energy
            if (pafIsValidEnergy[j]) {
               afRealEnergy[2] = pafLastEnergy[j*4+0];
               afRealEnergy[3] = pafLastEnergy[j*4+1];
               afDB[2] = pafLastEnergy[j*4+2];
               afDB[3] = pafLastEnergy[j*4+3];
            }
            else {
               pafLastEnergy[j*4+0] = afRealEnergy[2] = SRFEATUREEnergy (apSRF[2], FALSE);
               pafLastEnergy[j*4+1] = afRealEnergy[3] = SRFEATUREEnergy (apSRF[3], FALSE);
               pafLastEnergy[j*4+2] = afDB[2] = AmplitudeToDb(afEnergy[2] / THEORETICALMAXENERGY * (fp)0x8000);
               pafLastEnergy[j*4+3] = afDB[3] = AmplitudeToDb(afEnergy[3] / THEORETICALMAXENERGY * (fp)0x8000);
               pafIsValidEnergy[j] = TRUE;
            }

            fError = 0;

            for (k = 0; k < 2; k++) {
               // compare the two
               DWORD dwA = k+0;
               DWORD dwB = k+2;
   #if 0 // def _DEBUG // to test and make sure energy calculation is right
               afRealEnergy[dwA] = SRFEATUREEnergy(apSRF[dwA]);
               afRealEnergy[dwB] = SRFEATUREEnergy(apSRF[dwB]);
   #endif
               fp fCompare = SRFEATURECompare (apSRF[dwA], afRealEnergy[dwA], apSRF[dwB], afRealEnergy[dwB]);
               
               // BUGFIX - Just in case decides to get really wild, which does if very large energies
               fCompare = max (fCompare, 0.0);
               fCompare = min (fCompare, 1.0);
               
               // find the higher number of db
               fp fMaxDb = max(afDB[dwA], afDB[dwB]);
               fMaxDb = 1 + fMaxDb/((fp)-SRNOISEFLOOR);   // so that at -60 decibles max, fCompare won't count for anything
               fMaxDb = max(fMaxDb, 0);
               fMaxDb = min(fMaxDb, 1);

               // total error
               fCompare = (fCompare * SRCOMPAREWEIGHT + fabs(afDB[dwA] - afDB[dwB])) * fMaxDb;
                  // penalty for difference in volume only counts half
               fError += fCompare;
            } // k

            // fit it into a byte
            fError *= BORDERDBSCALE;   // so average these two
            //fError = max(fError, 0);
            //fError = min(fError, 255);
            paf[0] = fError;

            // store in cache
            if (pUnit[i].pTPA) {
               lTPA.Add (&pUnitLast[j].pTPA);
               lTPAScore.Add (&paf[0]);
               // pUnit[i].pTPA->ConnectErrorCacheSet(pUnitLast[j].pTPA, (dwTime % TTSDEMIPHONES), paf[0]);
            }
         } // j

         // add them all at once
         if (pUnit[i].pTPA)
            pUnit[i].pTPA->ConnectErrorCacheSet((PCMTTSTriPhoneAudio*)lTPA.Get(0), (fp*)lTPAScore.Get(0), lTPA.Num(), (dwTime % TTSDEMIPHONES) );
      } // i
   #endif // 0
   } // dwPass

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tConnectErrortime=%d", (int)(GetTickCount() - dwStartTime));
   OutputDebugStringW (szTemp);
   dwStartTime = GetTickCount();
#endif


   // done
}


/*************************************************************************************
CMTTS::HypExpand - Expand all the hypothesis in one list into another, using the
new phoneme.

inputs
   DWORD       dwTime - Time index. Important part is dwTime % TTSDEMIPHONES
   PCMem       pmemFrom - Memory with list of PHONEHYP. m_dwCurPosn = memory where last one is
   PCMem       pmemTo - Meory to will with PHONEHYP. m_dwCurPosn = memory where to add to
   DWORD          dwPhoneValid - Number of valid phonemes including and after pbPhone[0]. Thus, is pbPhone[0]
                  and pbPhone[1] are valid, this is 2.
   BYTE        *pbPhone - Phoneme to use, also need [-1] and [1] to be valid
   BYTE        *pbWordPos - Word position (start, end or word)
                  0x01 = start of word
                  0x02 = end of word
                  0x04 = start of syllable
                  0x08 = end of syllable
                  0x10 = plosive
                  0x20 = voiced
   BYTE        *pbTPhoneGroup - Phoneme into group of 16, also need [-1] and [1] to be valid
   BYTE        *pbTPhoneNoStress - Phoneme without stress, also need [-1] and [1] to be valid
         // NOTE: For optimization reasons this function assumes NUMTRIPHONEGROUP == 3
   DWORD       *pdwWord - Word number using, or -1 if not known word
   int         iPitchLeft - Left pitch
   int         iPitchCenter - Center pitch
   int         iPitchRight - Right pitch
   // DWORD       dwDurationPrev - Duration of the previous half phone, or 0 if unknown
   DWORD       dwDuration - Duration of the phone, or 0 if unknown
   fp          fEnergy - Energy of the phone, so can select units based on energy
   fp          fEnergyPrev - Energy of the previous phone, for unit weighting
   BYTE        bSilence - What phoneme is silence
   DWORD       dwFuncWordGroup - Which function-word-group this is in, 0..NUMFUNCWORDGROUP(inclusive)
   fp          fEnergyAverage - Average energy over all requested phonemes. Used for score calc
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL        fDisablePCM - Set to TRUE if PSOLA is temporarily disabled

   PCListFixed plUNITOPTIONLast - Unit options from the last list. If there wasn't one, then
               leave this with 0 elements and it will automatically be filled with silence
   PCListFixed plUNITOPTION - Filled with the current unit options
returns
   none
*/

void CMTTS::HypExpand (DWORD dwTime, PCMem pmemFrom, PCMem pmemTo, DWORD dwPhoneValid, BYTE *pbPhone,
                       BYTE *pbWordPos, BYTE *pbTPhoneGroup, BYTE *pbTPhoneNoStress,
                       DWORD *pdwWord, int iPitchLeft, int iPitchCenter, int iPitchRight,
                       /*DWORD dwDurationPrev,*/ DWORD dwDuration, fp fEnergy, fp fEnergyPrev, BYTE bSilence,
                       DWORD dwFuncWordGroup,
                       fp fEnergyAverage, int iTTSQuality, BOOL fDisablePCM,
                       PCListFixed plUNITOPTIONLast, PCListFixed plUNITOPTION)
{
   // make sure there's a last
   if (!plUNITOPTIONLast->Num()) {
      // fill with silence
      UNITOPTION uo;
      memset (&uo, 0, sizeof(uo));
      plUNITOPTIONLast->Init (sizeof(uo), &uo, 1);
   }

#if 0 // def _DEBUG
   DWORD dwTimeStart = GetTickCount();
   WCHAR szTemp[64];
#endif

   // fill in this list
   CMem memSmooth;
   GenerateUNITOPTION (dwTime, pmemFrom, dwPhoneValid, pbPhone, pbWordPos, pbTPhoneGroup, pbTPhoneNoStress, pdwWord,
      iPitchLeft, iPitchCenter, iPitchRight, /*dwDurationPrev,*/ dwDuration, fEnergy, fEnergyPrev, bSilence, dwFuncWordGroup, fEnergyAverage,
      plUNITOPTION, plUNITOPTIONLast,
      &memSmooth, iTTSQuality, fDisablePCM);
   fp *pafSmooth = (fp*)memSmooth.p;

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\nHyp time: %d\r\n\tGenerateUNITOPTION time = %d",
      (int)dwTime, (int)(GetTickCount() - dwTimeStart));
   OutputDebugStringW (szTemp);
#endif

   // determine which phoneme units need to look through
   PCMLexicon pLex = Lexicon();
   BYTE bPhoneTemp = PhonemeBackoff(*pbPhone, pLex, bSilence);
   //PCListFixed pl = (bPhoneTemp != bSilence) ? m_palPCMTTSTriPhoneAudio[bPhoneTemp] : NULL;
   //PCMTTSTriPhoneAudio *pptp;
   DWORD dwNum;
   //if (!pl || !pl->Num()) {
   //   // serious problem because have selected phoneme but no recordsing, therefore
   //   // just set to NULL pptp
   //   pptp = NULL;
   //   dwNum = 1;
   //}
   //else {
   //   pptp = (PCMTTSTriPhoneAudio*) pl->Get(0);
   //   dwNum = pl->Num();
   //}
   dwNum = plUNITOPTION->Num();

   // ignore pitch
   BOOL fUsePitch = FALSE;
   if ((bPhoneTemp != bSilence) && pLex) {   // BUGFIX - Was check for pl, but using pl anymore
      PLEXPHONE plp = pLex->PhonemeGetUnsort(bPhoneTemp);
      PLEXENGLISHPHONE pe = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;
      if (pe) // BUGFIX - Use pitch even for unvoiced && (pe->dwCategory & PIC_VOICED))
         fUsePitch = TRUE;
   }

   // loop over existing hypothesis and expand

#if 0 // def _DEBUG
   dwTimeStart = GetTickCount();
#endif

   // loop over existing unit options
   // can reverse the i and j loops (and make faster) because the context for new phones
   // only depends on the phone immediately before
   double fCutOff = 1000000000000;

   // modulo index so each thread has a bit of the top and will
   // find a cutoff faster
   CMem memModulo;
   if (!memModulo.Required (sizeof(DWORD)*dwNum))
      return;
   DWORD *padwModulo = (DWORD*)memModulo.p;
   DWORD dwThreads = HowManyProcessors();
   DWORD dwLoops = dwThreads; // since passing 1 into ThreadLoop()
   DWORD dwLoopSize = (dwNum + (dwLoops-1)) / dwLoops;
   DWORD dwCur = 0, dwOffset;
   DWORD i;
   for (dwOffset = 0; dwOffset < dwLoopSize; dwOffset++)
      for (i = 0; i < dwLoops; i++) {
         // figure out where it should be going to
         DWORD dwIndex = i * dwLoopSize + dwOffset;
         if (dwIndex >= dwNum)
            continue;   // too large

         // if have reached maximum then stop
         if (dwCur >= dwNum)
            break;

         // write it in
         padwModulo[dwIndex] = dwCur;
         dwCur++;
      }

   EMTBEAMSEARCH em;
   memset (&em, 0, sizeof(em));
   em.dwType = 20;
   em.plUNITOPTION = plUNITOPTION;
   em.pmemFrom = pmemFrom;
   em.pmemTo = pmemTo;
   em.dwTime = dwTime;
   em.pdwWord = pdwWord;
   em.pbWordPos = pbWordPos;
   em.pbPhone = pbPhone;
   em.pbTPhoneNoStress = pbTPhoneNoStress;
   em.pbTPhoneGroup = pbTPhoneGroup;
   em.bSilence = bSilence;
   em.pafSmooth = pafSmooth;
   em.plUNITOPTIONLast = plUNITOPTIONLast;
   em.fEnergy = fEnergy;
   em.dwDurationX = dwDuration;
   em.dwFuncWordGroup = dwFuncWordGroup;
   em.fEnergyPrev = fEnergyPrev;
   em.fUsePitch = fUsePitch;
   em.iPitchLeft = iPitchLeft;
   em.iPitchCenter = iPitchCenter;
   em.iPitchRight = iPitchRight;
   em.fEnergyAverage = fEnergyAverage;
   em.dwNum = dwNum;
   em.pfCutOff = &fCutOff;
   em.padwModulo = padwModulo;
   em.fDisablePCM = fDisablePCM;

   ThreadLoop (0, dwNum, 1, &em, sizeof(em), NULL);

#if 0 // replaced by multithreaded
   PUNITOPTION puo;
   puo = (PUNITOPTION) plUNITOPTION->Get(0);
   PPHONEHYP pahFrom = (PPHONEHYP)pmemFrom->p;
   DWORD dwNumFrom = (DWORD)pmemFrom->m_dwCurPosn / sizeof(PHONEHYP);
   DWORD i, j;
   // fp fScoreOrig, fScore;
   fp fBestNewScore = 1000000000;
   double fCutOff = 1000000000000;
   PHONEHYP ph, phBest;
   DWORD dwBest;
   double fBestScore;
   PCMTTSTriPhoneAudio ptNew;
   for (j = 0; j < dwNum; j++, puo++) {

      // remember the best
      dwBest = (DWORD)-1;
      fBestScore = 0;

      // loop over all existing hypothesis and find the one that results
      // in the best final score
      pahFrom = (PPHONEHYP)pmemFrom->p;
      for (i = 0; i < dwNumFrom; i++, pahFrom++) {
         // fill in new info
         memcpy (ph.aPCMTTSTriPhoneAudio, &pahFrom->aPCMTTSTriPhoneAudio[1], (PHONEHISTORY-1) * sizeof(PCMTTSTriPhoneAudio));
         ph.fScore = pahFrom->fScore;

         if (!puo->pTPA) {
         //if (!pptp) {
            // if silence (or unknown phoneme) then just add and dont calc score
            ptNew = NULL;
            ph.fEndSilence = TRUE;
            goto addit;
         }
         //ptNew = pptp[j];
         ptNew = puo->pTPA;

         // determine the boundary
         double fBoundaryTheoretical = ScoreCalcBoundary (dwTime, ptNew, pdwWord, pbWordPos, pbPhone,
            pbTPhoneNoStress, pbTPhoneGroup, bSilence,
            NULL, pahFrom, ph.aPCMTTSTriPhoneAudio);
         _ASSERTE (fBoundaryTheoretical < 10000);

         // calculate the blend
         BOOL fWordStart = (*pbWordPos & 0x01);
         BOOL fSylStart = (*pbWordPos & 0x04);
         double fBoundaryCalc = pafSmooth[plUNITOPTIONLast->Num() * j + pahFrom->dwPreviousIndex];
         //fBoundaryCalc = ATSTARTOFPHONE ? CROSSWORDLESSPENALTYLEFT(fBoundaryCalc) : fBoundaryCalc;
            // BUGFIX - If not at the start of the phoneme, then CROSSWORDLESSPENALTYLEFT

         double fBoundary = SCORECALCWEIGHTTHEORETICALBOUNDARY * fBoundaryTheoretical +
            (1.0 - SCORECALCWEIGHTTHEORETICALBOUNDARY) * fBoundaryCalc;
         double fWeightBoundary = ScoreCalcWeightBoundary (fEnergyPrev, fEnergy);
            //dwDurationPrev, dwDuration,
            //(dwTime ? pbWordPos[(dwTime-1)/TTSDEMIPHONES] : 0),
            //pbWordPos[dwTime/TTSDEMIPHONES] );

         ph.fScore += fWeightBoundary * fBoundary;

         // BUGFIX - partial check to see if eliminate early
         if (ph.fScore > fCutOff)
            continue;
         if ((dwBest != (DWORD)-1) && (ph.fScore >= phBest.fScore))
            continue;
        


         // calculate weight for self
         double fScoreCalcWeightSelf = ScoreCalcWeightSelf (fEnergy, dwDuration);
         double fSelfA =
            ScoreCalcSelfA (dwTime, ptNew, NULL /*ph.aPCMTTSTriPhoneAudio[PHONEHISTORY-2]*/, fUsePitch, iPitchLeft, iPitchCenter, iPitchRight, dwDuration, fEnergy,
               pdwWord, pbWordPos, pbPhone, pbTPhoneNoStress, pbTPhoneGroup, bSilence, NULL, pahFrom);
         ph.fScore += fSelfA * fScoreCalcWeightSelf;
         if (ph.fScore > fCutOff)
            continue;
         if ((dwBest != (DWORD)-1) && (ph.fScore >= phBest.fScore))
            continue;

         // second part
         double fSelfB =
            ScoreCalcSelfB (dwTime, ptNew, ph.aPCMTTSTriPhoneAudio[PHONEHISTORY-2], fUsePitch, iPitchLeft, iPitchCenter, iPitchRight, dwDuration, fEnergy,
               pdwWord, pbWordPos, pbPhone, pbTPhoneNoStress, pbTPhoneGroup, bSilence, NULL, pahFrom);
         ph.fScore += fSelfB * fScoreCalcWeightSelf;



         ph.fEndSilence = ATENDOFPHONE && (ptNew->m_bPhoneRight == bSilence);
            // BUGFIX - endsielnce only if at end of this phone


addit:
         // if this score isn't nearly as good as the best score then don't bother
         if (ph.fScore > fCutOff)
            continue;

         // if this isn't the best score then don't bother
         if ((dwBest != (DWORD)-1) && (ph.fScore >= phBest.fScore))
            continue;

         // write this
         phBest = ph;
         phBest.aPCMTTSTriPhoneAudio[PHONEHISTORY-1] = ptNew;
         phBest.dwPreviousIndex = j; // remember the location in this
         dwBest = j;
         fCutOff = phBest.fScore + HYPAUTOCULL;
      } // i

      // if best then keep it
      if (dwBest != (DWORD)-1) {
         // make sure enough memory
         if (!pmemTo->Required (pmemTo->m_dwCurPosn + dwNum * sizeof(PHONEHYP)))
            return;  // error
         memcpy ((PBYTE)pmemTo->p + pmemTo->m_dwCurPosn, &phBest, sizeof(phBest));
         pmemTo->m_dwCurPosn += sizeof(phBest);
      }
   } // j, unit options
#endif // 0, replaced by multithreaded

#if 0 // def _DEBUG
   swprintf (szTemp, L"\r\n\tBeam search time = %d",
      (int)(GetTickCount() - dwTimeStart));
   OutputDebugStringW (szTemp);
#endif

   return;
}



/*************************************************************************************
CMTTS::HypKeepBestScore - Searches through all the hypothesis and figure out which
has the highest score. Then, discard all hypothesis that don't begin with the
best scoring one's first word.

In the process, this also sorts by the triphone memory and discards duplicates
with a worse score.

inputs
   PCMem       pmem - Memory with list of PHONEHYP. m_dwCurPosn = memory where last one is
   fp          fEnergyAverage - Average energy over all requested phonemes. Used for score calc
returns
   PCMTTSTriPhoneAudio - Best triphone.
*/
static int _cdecl PHONEHYPSort1 (const void *elem1, const void *elem2)
{
   PHONEHYP *pdw1, *pdw2;
   pdw1 = (PHONEHYP*) elem1;
   pdw2 = (PHONEHYP*) elem2;

   // BUGFIX - Since have demiphones now, need to do memcompare of the last TTSDEMIPHONES elements
   int iRet = memcmp (
      pdw1->aPCMTTSTriPhoneAudio + (PHONEHISTORY-TTSDEMIPHONES),
      pdw2->aPCMTTSTriPhoneAudio + (PHONEHISTORY-TTSDEMIPHONES),
      sizeof(pdw1->aPCMTTSTriPhoneAudio[0]) * TTSDEMIPHONES);
   if (iRet)
      return iRet;
   //if (pdw1->aPCMTTSTriPhoneAudio[PHONEHISTORY-1] < pdw2->aPCMTTSTriPhoneAudio[PHONEHISTORY-1])
   //   return 1;
   //else if (pdw1->aPCMTTSTriPhoneAudio[PHONEHISTORY-1] > pdw2->aPCMTTSTriPhoneAudio[PHONEHISTORY-1])
   //   return -1;

   // BUGFIX - The following was a bad way to do this
   //int iRet = memcmp (pdw1->aPCMTTSTriPhoneAudio, pdw2->aPCMTTSTriPhoneAudio, sizeof(pdw1->aPCMTTSTriPhoneAudio));
   //if (iRet)
   //   return iRet;

   // else by score
   if (pdw1->fScoreWithEnergy > pdw2->fScoreWithEnergy)
      return 1;
   else if (pdw1->fScoreWithEnergy < pdw2->fScoreWithEnergy)
      return -1;
   else
      return 0;
   // return (int)pdw1->dwScore - (int)pdw2->dwScore;
}

PCMTTSTriPhoneAudio CMTTS::HypKeepBestScore (PCMem pMem, fp fEnergyAverage)
{
   // find the best
   DWORD dwBest = -1;
   fp fBestScore = 1000000000000;
   DWORD dwNum = (DWORD)pMem->m_dwCurPosn / sizeof(PHONEHYP);
   PPHONEHYP pph = (PPHONEHYP) pMem->p;
   DWORD i;
   for (i = 0; i < dwNum; i++, pph++)
      if (pph->fScoreWithEnergy < fBestScore) {
         dwBest = i;
         fBestScore = pph->fScoreWithEnergy;
      }

   // what's the return for this
   if (dwBest == -1)
      return NULL;   // shouldnt happen
   pph = (PPHONEHYP) pMem->p;
   PCMTTSTriPhoneAudio pRet = pph[dwBest].aPCMTTSTriPhoneAudio[0];

   // remove all triphones that do not match the best
   DWORD j;
   fp fScoreElim = fBestScore + HYPAUTOCULL;
   for (i = 0, j = 0; i < dwNum; i++) {
      if (pph[i].aPCMTTSTriPhoneAudio[0] != pRet)
         continue;   // want to skip this

      // also, if the score is much worse than the best score then eliminate
      if (pph[i].fScoreWithEnergy > fScoreElim)
         continue;

      if (i != j)
         memcpy (pph + j, pph + i, sizeof(PHONEHYP));
      j++;
   } // i
   pMem->m_dwCurPosn = (dwNum = j) * sizeof(PHONEHYP);

   // sort by type, and then by score, so can remove duplicates
   qsort (pph, dwNum, sizeof(PHONEHYP), PHONEHYPSort1);

   // loop through and find duplicates
   DWORD k;
#ifdef _DEBUG
   DWORD dwDuplicates = 0;
#endif
   for (i = 0, j = 0; i < dwNum; /*i++*/) {
      // see how far can go until no longer have match
      for (k = i+1; k < dwNum; k++)
         // BUGFIX - Because using demiphones, need longer compare
         if (memcmp (
            pph[i].aPCMTTSTriPhoneAudio + (PHONEHISTORY-TTSDEMIPHONES),
            pph[k].aPCMTTSTriPhoneAudio + (PHONEHISTORY-TTSDEMIPHONES),
            sizeof(pph[k].aPCMTTSTriPhoneAudio[0]) * TTSDEMIPHONES))
         //if (pph[i].aPCMTTSTriPhoneAudio[PHONEHISTORY-1] != pph[k].aPCMTTSTriPhoneAudio[PHONEHISTORY-1])
               break;

      // copy over i
      if (i != j)
         memcpy (pph + j, pph + i, sizeof(PHONEHYP));
      j++;

#ifdef _DEBUG
      if (k != i+1)
         dwDuplicates++;
#endif

      // move to next
      i = k;
   } // i
   pMem->m_dwCurPosn = (dwNum = j) * sizeof(PHONEHYP);

   return pRet;
}

/*************************************************************************************
CMTTS::HypEliminateLowScores - Eliminates and low scores.
In the process, the list will be sorted by highest score first.


inputs
   PCMem       pmem - Memory with list of PHONEHYP. m_dwCurPosn = memory where last one is
   DWORD       dwMaxNum - Maximum number of hypothesis that can sit around
returns
   none
*/
static int _cdecl PHONEHYPSort2 (const void *elem1, const void *elem2)
{
   PHONEHYP *pdw1, *pdw2;
   pdw1 = (PHONEHYP*) elem1;
   pdw2 = (PHONEHYP*) elem2;

   // else by score
   if (pdw1->fScoreWithEnergy > pdw2->fScoreWithEnergy)
      return 1;
   else if (pdw1->fScoreWithEnergy < pdw2->fScoreWithEnergy)
      return -1;
   else
      return 0;
   //return (int)pdw1->dwScore - (int)pdw2->dwScore;
}
void CMTTS::HypEliminateLowScores (PCMem pMem, DWORD dwMaxNum)
{
   DWORD dwNum = (DWORD)pMem->m_dwCurPosn / sizeof(PHONEHYP);
   PPHONEHYP pph = (PPHONEHYP) pMem->p;


   // NOTE: Always sort since makes next step faster
   // sort by score so can keep best scores
   qsort (pph, dwNum, sizeof(PHONEHYP), PHONEHYPSort2);
      // BUGFIX - Replaced PHONEHYPSort1 with PHONEHYPSort2

   if (dwNum > dwMaxNum)
      pMem->m_dwCurPosn = dwMaxNum * sizeof(PHONEHYP);
}



/*************************************************************************************
CMTTS::SynthDetermineTriPhoneAudio - Given a list of phonemes and their duration, this
determines which units are to be used for each triphone.

inputs
   fp          fAvgPitch - Average pitch. Usually pass in m_fAvgPitch, but if this voice
               is modified, then pass in a higher value
   DWORD       *padwPhone - Pointer to an array of phonemes. Each phoneme is the
               unsorted phone number. The high byte (<< 24) contains 0 if the phone
               is in the middle of a word, 1 on left side, 2 on right side, 3 word by itself
   DWORD       *padwWord - Word (from m_pLexWords) associated with each phoneme, or -1 if no
               known word is associated
   DWORD       *padwDur - Array of phoneme durations, in SRFEATURE (1/100th sec) units
   fp          *pafVol - Array of volumes, one per phoneme. See fVolAbsolute
   BOOL        fVolAbsoluate - If TRUE pafVol is the absolute volume to use (so can get this
               from transplanted prosody); in which case it's the CalcSREnergyRange() of
               the phoneme. If FALSE, relative volume.
   PCListVariable plPitch - This list has one element per phoneme to indicate the
               fundamental pitch of the voice (in Hz). Each element is N * sizeof(fp),
               where N is from 0 to whatever. It indicates the number of pitch points
               stored per phoneme.
   DWORD       dwNum - Number of phonemes
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL        fDisablePCM - Set to TRUE if PCM temporarily disabled
   PCListFixed plPCMTTSTriPhoneAudio - Pointer to a list that is initialized to sizeof(PCMTTSTriPhoneAudio)
               and filled with a list of triphones, one of each phone x TTSDEMIPHONES.
   fp          *pfBestScore - Filled with the acoustic score.
   PCProgressSocket pProgress - Progress
returns
   BOOl - TRUE if success
*/

BOOL CMTTS::SynthDetermineTriPhoneAudio (fp fAvgPitch, DWORD *padwPhone, DWORD *padwWord,
                                         DWORD *padwDur, fp *pafVol, BOOL fVolAbsolute, PCListVariable plPitch, DWORD dwNum,
                                         int iTTSQuality, BOOL fDisablePCM,
                                         PCListFixed plPCMTTSTriPhoneAudio, fp *pfBestScore,
                                         PCProgressSocket pProgress)
{
   *pfBestScore = 0; // to blank out

   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster)
         return FALSE;
      return m_pTTSMaster->SynthDetermineTriPhoneAudio (fAvgPitch, padwPhone, padwWord, padwDur, pafVol, fVolAbsolute, plPitch, dwNum, iTTSQuality, fDisablePCM,
         plPCMTTSTriPhoneAudio, pfBestScore, pProgress);
   }

   // get silence
   PCMLexicon pLex = Lexicon();
   if (!pLex)
      return FALSE;
   BYTE bSilence = pLex->PhonemeFindUnsort (pLex->PhonemeSilence());

   // fill in volumes
   CMem memVol;
   if (!memVol.Required (dwNum * sizeof(fp) * 2))
      return FALSE;
   fp *pafVolTheory = (fp*)memVol.p;
   fp *pafVolWant = pafVolTheory + dwNum;
   DWORD i, j;
   fp fAvgTheory = 0;
   fp fAvgWant = 0;
   for (i = 0; i < dwNum; i++) {
      // theoretical
      PCMTTSTriPhonePros ptpp = SynthDetermineTriPhonePros (
         (BYTE)padwPhone[i], padwPhone[i] >> 24,
         i ? (BYTE)padwPhone[i-1] : bSilence,
         (i+1 < dwNum) ? (BYTE)padwPhone[i+1] : bSilence);

      pafVolTheory[i] = ptpp ? ptpp->m_fEnergyAvg : 0.0;
      fAvgTheory += pafVolTheory[i];

      // what want
      if (fVolAbsolute && pafVol)
         pafVolWant[i] = pafVol[i];
      else
         pafVolWant[i] = (pafVol ? pafVol[i] : 1.0) * pafVolTheory[i];
      fAvgWant += pafVolWant[i];
   } // i

   // normalize so that fAvgWant becomes vAvgTheory
   // figure out average energy too
   fp fScale = fAvgTheory / max(fAvgWant,1.0);
   fp fEnergyAverage = 0;
   DWORD dwEnergyAverageCount = 0;
   for (i = 0; i < dwNum; i++) {
      pafVolWant[i] *= fScale;

      if ((BYTE)padwPhone[i] != bSilence) {
         fEnergyAverage += pafVolWant[i] * (fp) padwDur[i];
         dwEnergyAverageCount += padwDur[i];
      }
   }
   if (dwEnergyAverageCount)
      fEnergyAverage /= (fp)dwEnergyAverageCount;
   fEnergyAverage = max(fEnergyAverage, CLOSE);  // so have something


   // create some memory where can store information, such as extra border around
   // phonemes
   DWORD dwNewNum = dwNum+2;
   CMem mem;
   if (!mem.Required (dwNewNum * ((2 + NUMTRIPHONEGROUP) * sizeof(BYTE) + 3 * sizeof(int) + 2*sizeof(DWORD) )))
      return FALSE;
   DWORD *padwNewWord = (DWORD*)mem.p;
   DWORD *padwNewFuncWordGroup = padwNewWord + dwNewNum;
   int *paiPitchLRC = (int*)(padwNewFuncWordGroup + dwNewNum);
   BYTE *pabNewPhone = (BYTE*)(paiPitchLRC + 3 * dwNewNum);
   BYTE *pabNewWordPos = pabNewPhone + dwNewNum;
   PBYTE apbTriPhone[NUMTRIPHONEGROUP];
   PBYTE pbCur;
   for (i = 0, pbCur = pabNewWordPos; i < NUMTRIPHONEGROUP; i++)
      pbCur = apbTriPhone[i] = pbCur + dwNewNum;

   // fill this in with information
   pabNewPhone[0] = pabNewPhone[dwNewNum-1] = bSilence;
   pabNewWordPos[0] = pabNewWordPos[dwNewNum-1] = 0;
   padwNewWord[0] = padwNewWord[dwNewNum-1] = -1;
   padwNewFuncWordGroup[0] = padwNewFuncWordGroup[dwNewNum-1] = 0;
   WCHAR szWord[256];
   DWORD dwFuncWordGroup;
   for (i = 0; i < dwNum; i++) {
      pabNewPhone[i+1] = (BYTE)padwPhone[i];
      pabNewWordPos[i+1] = (BYTE)(padwPhone[i] >> 24);
      
      // determine if it's a plosive
      PLEXPHONE plpThis = pLex->PhonemeGetUnsort (PhonemeBackoff(pabNewPhone[i+1], pLex, bSilence));
      PLEXENGLISHPHONE pe = plpThis ? MLexiconEnglishPhoneGet(plpThis->bEnglishPhone) : NULL;
      if (pe && (pe->dwCategory & PIC_PLOSIVE))
         pabNewWordPos[i+1] |= 0x10;   // note that it's plosive
      if (pe && (pe->dwCategory & PIC_VOICED))
         pabNewWordPos[i+1] |= 0x20;   // note that it's voiced
      
      padwNewWord[i+1] = padwWord[i];

      // determine which function word it is
      szWord[0] = 0;
      dwFuncWordGroup = NUMFUNCWORDGROUP; // backoff
      if (m_pLexWords && (padwWord[i] != (DWORD)-1) )
         m_pLexWords->WordGet (padwWord[i], szWord, sizeof(szWord), NULL);
      if (szWord[0]) {
         for (j = 0; j < NUMFUNCWORDGROUP; j++) {
            if (!m_apLexFuncWord[j])
               continue;

            if (m_apLexFuncWord[j]->WordExists (szWord)) {
               dwFuncWordGroup = j;
               break;
            }
         } // j
      } // if word
      padwNewFuncWordGroup[i+1] = dwFuncWordGroup;
   } // i

   // find the syllable boundaries
   CListFixed lTempPron, lBoundary;
   lTempPron.Init (sizeof(BYTE));
   lBoundary.Init (sizeof(DWORD));
   DWORD k;
   BYTE bTemp;
   for (i = 0; i < dwNum; i++) {
      if (pabNewPhone[i+1] == bSilence)
         continue;
      if (!(pabNewWordPos[i+1] & 0x01))
         continue;   // no word start

      // loop until word end
      for (j = i; j < dwNum; j++) {
         if (pabNewPhone[j+1] == bSilence)
            break;
         if (pabNewWordPos[j+1] & 0x02) {
            j++;
            break;   // word end
         }
      }

      if (j <= i+1) {
         // single phoneme word = single syllable word
         pabNewWordPos[i+1] |= 0x4 | 0x08;   // note that it's plosive
         continue;
      }

      // else, it's multiphoneme, so guess syllables
      lTempPron.Clear();
      if (j > i)
         lTempPron.Required (j - i);
      for (k = i; k < j; k++) {
         bTemp = pabNewPhone[k+1] + 1;
         lTempPron.Add (&bTemp);
      } // k
      bTemp = 0;
      lTempPron.Add (&bTemp);

      lBoundary.Clear();
      pLex->WordSyllables ((PBYTE)lTempPron.Get(0), NULL, &lBoundary);
         // NOTE: Not passing in word string, which may eventually cause problems for syllables

      // put in syllable markers
      pabNewWordPos[i+1] |= 0x04;   // start syllable
      pabNewWordPos[j+1-1] |= 0x08;   // end syllable
      DWORD *padwBoundry = (DWORD*)lBoundary.Get(0);
      for (k = 0; k < lBoundary.Num(); k++) {
         DWORD dwBound = (WORD)padwBoundry[k];
         if (dwBound)
            pabNewWordPos[i+1+dwBound-1] |= 0x08;   // start end
         if (i+1+dwBound < dwNum)
            pabNewWordPos[i+1+dwBound] |= 0x04;   // start syllable
      } // k

      i = j-1; // skip ahead
   } // i

   for (i = 0; i < dwNewNum; i++) for (j = 0; j < NUMTRIPHONEGROUP; j++)
      (apbTriPhone[j])[i] = (BYTE)PhoneToTriPhoneNumber(pabNewPhone[i], pabNewPhone[i], pLex, j); 

   // fill in the pitches
   int *pai = paiPitchLRC;
   // BUGFIX - Need to counteract the pitch values sent in here if doing voice mod,
   // to choose a pitch counteracts the voicemod pitch up/down, so get better TTS
   fp fPitchScaleToCounteractVoiceMod = m_fAvgPitch / fAvgPitch;
   for (i = 0; i < dwNewNum; i++, pai += 3) {
      int iThis = (int)i - 1;
      
      // find this
      fp *pfThis = (plPitch && (iThis >= 0)) ? (fp*) plPitch->Get((DWORD)iThis) : NULL;
      DWORD dwThisSize = pfThis ? ((DWORD)plPitch->Size((DWORD)iThis) / sizeof(fp)) : 0;
      fp fLeft = 0;
      fp fRight = 0;
      fp fCenter = 0;

      // BUGFIX - if have 3 or more points, then easy
      if (dwThisSize >= 3) {
         fLeft = pfThis[0] * fPitchScaleToCounteractVoiceMod;
         fRight = pfThis[dwThisSize-1] * fPitchScaleToCounteractVoiceMod;
         fCenter = pfThis[dwThisSize/2] * fPitchScaleToCounteractVoiceMod;
      }
      else if (dwThisSize == 2) {
         fLeft = pfThis[0] * fPitchScaleToCounteractVoiceMod;
         fRight = pfThis[dwThisSize-1] * fPitchScaleToCounteractVoiceMod;
         fCenter = (fLeft + fRight) / 2.0;
      }
      else if (dwThisSize)
         // can't really determine left and right yet
         fCenter = pfThis[0] * fPitchScaleToCounteractVoiceMod;

      // find the one to the right
      int iLook, iLeftIndex = -1000, iRightIndex = -1000;
      fp *pfRight = NULL;
      DWORD dwRightSize = 0;
      if (!fRight)
         for (iLook = iThis+1; iLook < (int)dwNewNum; iLook++) {
            pfRight = (plPitch && (iLook >= 0)) ? (fp*) plPitch->Get((DWORD)iLook) : NULL;
            if (!pfRight)
               continue;

            dwRightSize = pfRight ? ((DWORD)plPitch->Size((WORD)iLook) / sizeof(fp)) : 0;
            if (dwRightSize) {
               iRightIndex = iLook;
               break;
            }
         } // iLook

      // find the one to the left
      fp *pfLeft = NULL;
      DWORD dwLeftSize = 0;
      if (!fLeft)
         for (iLook = (int)iThis-1; iLook >= 0; iLook--) {
            pfLeft = (plPitch && (iLook >= 0)) ? (fp*) plPitch->Get((DWORD)iLook) : NULL;
            if (!pfLeft)
               continue;

            dwLeftSize = pfLeft ? ((DWORD)plPitch->Size((WORD)iLook) / sizeof(fp)) : 0;
            if (dwLeftSize) {
               iLeftIndex = iLook;
               break;
            }
         } // iLook

      // figure out pich on left side
      if (!fLeft && (iLeftIndex >= 0) && dwLeftSize) {
         // BUGFIX - If not immediately adjacent then just use the this value
         // otherwise, phoneme might be very distant, so an average is a bad
         // guestimate
         if (dwThisSize) {
            if ((int)iThis == iLeftIndex+1)
               fLeft = (pfThis[0] + pfLeft[dwLeftSize-1]) / 2 * fPitchScaleToCounteractVoiceMod;
            else
               fLeft = pfThis[0] * fPitchScaleToCounteractVoiceMod;
         }
         else
            fLeft = pfLeft[dwLeftSize-1] * fPitchScaleToCounteractVoiceMod;
      }
      //else if (dwThisSize)
      //   fLeft = pfThis[0];
      //else if (dwLeftSize)
      //   fLeft = pfLeft[dwLeftSize-1];

      // figure out pitch on right side
      if (!fRight && (iRightIndex >= 0) && dwRightSize) {
         // BUGFIX - If not immediately adjacent then just use the this value
         // otherwise, phoneme might be very distant, so an average is a bad
         // guestimate
         if (dwThisSize) {
            if ((int)iThis == iRightIndex-1)
               fRight = (pfThis[dwThisSize-1] + pfRight[0]) / 2 * fPitchScaleToCounteractVoiceMod;
            else
               fRight = pfThis[dwThisSize-1] * fPitchScaleToCounteractVoiceMod;
         }
         else
            fRight = pfRight[0] * fPitchScaleToCounteractVoiceMod;
      }
      //else if (dwThisSize)
      //   fRight = pfThis[dwThisSize-1];
      //else if (dwRightSize)
      //   fRight = pfRight[0];

      if (!fLeft) {
         if (fCenter)
            fLeft = fCenter;
         else if (fRight)
            fLeft = fRight;
         else
            fLeft = fAvgPitch;
      }

      if (!fRight) {
         if (fCenter)
            fRight = fCenter;
         else if (fLeft)
            fRight = fLeft;
         else
            fRight = fAvgPitch;
      }

      if (!fCenter)
         fCenter = (fLeft + fRight) / 2.0;   // since know left and right valid


      // convert to log
      fLeft = log((fp)(fLeft / SRBASEPITCH)) / log((fp)2) * 1000.0;
      fCenter = log((fp)(fCenter / SRBASEPITCH)) / log((fp)2) * 1000.0;
      fRight = log((fp)(fRight / SRBASEPITCH)) / log((fp)2) * 1000.0;

      pai[0] = (int)fLeft;
      pai[1] = (int)fCenter;
      pai[2] = (int)fRight;
   } // i

   // clear desintation
   plPCMTTSTriPhoneAudio->Init (sizeof(PCMTTSTriPhoneAudio));

   // start out with initial hypothesis
   PHONEHYP ph;
   CMem amemPHONEHYP[2];
   if (!amemPHONEHYP[0].Required (sizeof(PHONEHYP)))
      return FALSE; // error
   memset (&ph, 0, sizeof(ph));
   memcpy (amemPHONEHYP[0].p, &ph, sizeof(ph));
   amemPHONEHYP[0].m_dwCurPosn = sizeof(ph);

#ifdef _DEBUG
   DWORD dwStart = GetTickCount();
#endif

   PCMTTSTriPhoneAudio ptpBest = NULL;
   DWORD dwFrom = 0, dwTo = 1;
   DWORD dwMaxHyp = 0;
   CListFixed alUNITOPTION[2];   // use as ping-pong buffer
   // BUGFIX - MAXPHONEHYP dependent on number of units
   // DWORD dwMaxPhoneHyp = (DWORD)(sqrt((double)m_dwUnits / (double)OPTIMALNUMUNITS) * (double)MAXPHONEHYP) + 1;
   fp fMaxPhoneHyp = sqrt((double)m_dwUnits / (double)OPTIMALNUMUNITS) * (double)MAXPHONEHYP;
   int iTTSQualityLimited = min (max(iTTSQuality, 0), 3);
   // BUGFIX - Greatter difference in quality
   fMaxPhoneHyp *= (0.33 + 0.66 * (fp)iTTSQualityLimited / 3.0);
   DWORD dwMaxPhoneHyp = (DWORD)(fMaxPhoneHyp + 0.5) + 1;

   for (i = 0; i < dwNum * TTSDEMIPHONES; i++) {
      if (!(i%4) && pProgress)
         pProgress->Update ((fp)i / (fp)(dwNum * TTSDEMIPHONES));

      // clear the to-list
      dwFrom = i % 2;
      dwTo = (i+1)%2;
      amemPHONEHYP[dwTo].m_dwCurPosn = 0;;

      DWORD dwPhoneIndex = i / TTSDEMIPHONES + 1;
      DWORD dwPhoneIndexPrev = (i + TTSDEMIPHONES - 1) / TTSDEMIPHONES;

      // expand
      HypExpand (i, amemPHONEHYP + dwFrom, amemPHONEHYP + dwTo,
         dwNum - (dwPhoneIndex-1),
         pabNewPhone + dwPhoneIndex, pabNewWordPos + dwPhoneIndex,
         (apbTriPhone[0]) + dwPhoneIndex, (apbTriPhone[1]) + dwPhoneIndex,
         padwNewWord + dwPhoneIndex, paiPitchLRC[dwPhoneIndex*3+0], paiPitchLRC[dwPhoneIndex*3+1], paiPitchLRC[dwPhoneIndex*3+2],
               // BUGFIX - Was doing dwPhoneIndex*2 instead of dwPhoneINdex*3
         // (padwDur && (dwPhoneIndexPrev >= 1)) ? padwDur[dwPhoneIndexPrev-1] : 0,
         padwDur ? padwDur[dwPhoneIndex-1] : 0,
         pafVolWant[dwPhoneIndex-1],
         dwPhoneIndexPrev ? pafVolWant[dwPhoneIndexPrev-1] : 0,
         bSilence,
         padwNewFuncWordGroup[dwPhoneIndex],
         fEnergyAverage, iTTSQuality, fDisablePCM,
         &alUNITOPTION[i%2], &alUNITOPTION[(i+1)%2]);

      // keep the best score
      ptpBest = HypKeepBestScore (&amemPHONEHYP[dwTo], fEnergyAverage);
      plPCMTTSTriPhoneAudio->Add (&ptpBest);

      dwMaxHyp = max(dwMaxHyp, (DWORD)amemPHONEHYP[dwTo].m_dwCurPosn / sizeof(PHONEHYP));

      // eliminate the lowest scores if too many
      HypEliminateLowScores (&amemPHONEHYP[dwTo], dwMaxPhoneHyp); // BUGFIX - Went from 10000 to 1000
         // BUGFIX - Went from 1000 to 100
   } // i

#ifdef _DEBUG
   WCHAR szTemp[128];
   swprintf (szTemp, L"\r\nHypExpand time = %d", (int)(GetTickCount() - dwStart));
   OutputDebugStringW (szTemp);
#endif

   // loop through and find the best one. make sure to add the remaining phonemes
   DWORD dwBest = -1;
   fp fBestScore = 1000000000000;
   fp fBestScoreNoEnergy = 1000000000000;
   dwNewNum = (DWORD)amemPHONEHYP[dwTo].m_dwCurPosn / sizeof(PHONEHYP);
   PPHONEHYP pph = (PPHONEHYP)amemPHONEHYP[dwTo].p;
   for (i = 0; i < dwNewNum; i++)
      if (pph[i].fScoreWithEnergy < fBestScore) {
         fBestScore = pph[i].fScoreWithEnergy;
         fBestScoreNoEnergy = pph[i].fScoreNoEnergy;
         dwBest = i;
      }
   if (dwBest != -1) for (i = 1; i < PHONEHISTORY; i++)
      plPCMTTSTriPhoneAudio->Add (&pph[dwBest].aPCMTTSTriPhoneAudio[i]);
   // remove the first few since they're fake silences
   for (i = 0; i < PHONEHISTORY-1; i++)
      plPCMTTSTriPhoneAudio->Remove (0);

   // remember the best score
   *pfBestScore = fBestScoreNoEnergy;

   return TRUE;
}


/*************************************************************************************
CMTTS::SynthDetermineTriPhonePros - This determines the best prosody triphone to
use.

inputs
   BYTE        bPhone - Phone
   WORD        wWordPos - Bits to indicate word pos
   BYTE        bLeft - Phone to the left
   BYTE        bRight - Phone to right
returns
   PCMTTSTriPhonePros - Prosody triphone
*/
PCMTTSTriPhonePros CMTTS::SynthDetermineTriPhonePros (BYTE bPhone, WORD wWordPos,
                                                      BYTE bLeft, BYTE bRight)
{
   if (bPhone >= m_dwNumPhone)
      return NULL; // not a real phone

   PCMLexicon pLexicon = Lexicon();
   PCMLexicon pLex = pLexicon;
   BYTE bSilence = pLex->PhonemeFindUnsort (pLex->PhonemeSilence());
   PCListFixed pl = m_palPCMTTSTriPhonePros[PhonemeBackoff(bPhone, pLex, bSilence)];
   if (!pl)
      return NULL;

   PLEXPHONE plp = pLex->PhonemeGetUnsort (PhonemeBackoff(bPhone, pLex, bSilence));
   PLEXENGLISHPHONE ple = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;

   BOOL fVoiced = FALSE, fPlosive = FALSE;
   if (ple) {
      fVoiced = (ple->dwCategory & PIC_VOICED) ? TRUE : FALSE;
      fPlosive = (ple->dwCategory & PIC_PLOSIVE) ? TRUE : FALSE;
   }

   PCMTTSTriPhonePros *pptp = (PCMTTSTriPhonePros*)pl->Get(0);

   // determine triphone group
   DWORD j;
   WORD awPhoneGroup[NUMTRIPHONEGROUP];
   for (j = 0; j < NUMTRIPHONEGROUP; j++)
      awPhoneGroup[j] = PhoneToTriPhoneNumber (bLeft, bRight, pLexicon, j);

   // loop through all possibilities
   PCMTTSTriPhonePros pBest = NULL;
   fp fBestScore = 1000000000;
   for (j = 0; j < pl->Num(); j++) {
      PCMTTSTriPhonePros ptp = pptp[j];

      fp fScore = 0;

      // left
      if (LexPhoneGroupToMega((BYTE)awPhoneGroup[0]) != LexPhoneGroupToMega((BYTE)ptp->m_awTriPhone[0]))
         fScore += UnitScoreScoreLRMismatch (this, bPhone, bLeft, pLex, FALSE, 5);
      else if ((BYTE)awPhoneGroup[0] != (BYTE)ptp->m_awTriPhone[0])
         // BUGFIX - Changed CROSSWORDLESSPENALTYLEFT (HYPBADGROUP) to just HYPBADGROUP
         // since was tending to change to bad unit at the start/end of word
         fScore += UnitScoreScoreLRMismatch (this, bPhone, bLeft, pLex, FALSE, 4);
      else if ( /*(m_dwTriPhoneGroup >= 2) &&*/ ((BYTE)awPhoneGroup[1] != (BYTE)ptp->m_awTriPhone[1])) // right group, wrong phone
         fScore += UnitScoreScoreLRMismatch (this, bPhone, bLeft, pLex, FALSE, 3);
      else if ( /*(m_dwTriPhoneGroup >= 3) &&*/ ((BYTE)awPhoneGroup[2] != (BYTE)ptp->m_awTriPhone[2]))// right phone, wrong stress
         fScore += UnitScoreScoreLRMismatch (this, bPhone, bLeft, pLex, FALSE, 2);
      // else perfect triphone match, so no error
      // NOTE: Not calling UnitScoreLRMismatch (...., 0 or 1) because irrelevant

      // left
      //if ((BYTE)awPhoneGroup[0] != (BYTE)ptp->m_awTriPhone[0])
      //   dwScore += HYPBADGROUP;
      //else if (((BYTE)awPhoneGroup[1] != (BYTE)ptp->m_awTriPhone[1]) && (m_dwTriPhoneGroup >= 2))
            // BUGFIX - The (m_dwTriPhoneGroup >= 2) check was unintentionally left out
      //   dwScore += HYPBADSTRESS;
      // else, must be equal so no penalty
      // BUGFIX - Test for  && (m_dwTriPhoneGroup >= 2), so if triphone isn't supposed to be conscious of stress

      if (LexPhoneGroupToMega((BYTE)(awPhoneGroup[0]>>8)) != LexPhoneGroupToMega((BYTE)(ptp->m_awTriPhone[0]>>8)))
         fScore += UnitScoreScoreLRMismatch (this, bPhone, bRight, pLex, TRUE, 5);
      else if ((BYTE)(awPhoneGroup[0]>>8) != (BYTE)(ptp->m_awTriPhone[0]>>8))
         // BUGFIX - Changed CROSSWORDLESSPENALTYLEFT (HYPBADGROUP) to just HYPBADGROUP
         // since was tending to change to bad unit at the start/end of word
         fScore += UnitScoreScoreLRMismatch (this, bPhone, bRight, pLex, TRUE, 4);
      else if (/*(m_dwTriPhoneGroup >= 2) &&*/ ((BYTE)(awPhoneGroup[1]>>8) != (BYTE)(ptp->m_awTriPhone[1]>>8))) // right group, wrong phone
         fScore += UnitScoreScoreLRMismatch (this, bPhone, bRight, pLex, TRUE, 3);
      else if (/*(m_dwTriPhoneGroup >= 3) &&*/ ((BYTE)(awPhoneGroup[2]>>8) != (BYTE)(ptp->m_awTriPhone[2]>>8)))// right phone, wrong stress
         fScore += UnitScoreScoreLRMismatch (this, bPhone, bRight, pLex, TRUE, 2);
      // NOTE: Not calling UnitScoreLRMismatch (...., 0 or 1) because irrelevant
      // else perfect triphone match, so no error
      // right
      //if ((BYTE)(awPhoneGroup[0] >> 8) != (BYTE)(ptp->m_awTriPhone[0] >> 8))
      //   dwScore += HYPBADGROUP;
      //else if ((BYTE)(awPhoneGroup[1] >> 8) != (BYTE)(ptp->m_awTriPhone[1] >> 8) && (m_dwTriPhoneGroup >= 2))
      //   dwScore += HYPBADSTRESS;
      // else, must be equal so no penalty
      // BUGFIX - Test for  && (m_dwTriPhoneGroup >= 2), so if triphone isn't supposed to be conscious of stress

      // if mismatch in phoneme at start/end then add penalty
      fScore += UnitScoreMismatchedWordPos (this, wWordPos, ptp->m_wWordPos);

      // best score
      if (fScore < fBestScore) {
         fBestScore = fScore;
         pBest = ptp;
      }
   } // j

   return pBest;
}


/*************************************************************************************
CMTTS::SynthDetermineTriPhonePros - Given a list of phonemes and their duration, this
determines which units are to be used for each triphone.

inputs
   DWORD       *padwPhone - Pointer to an array of phonemes. Each phoneme is the
               unsorted phone number. The high byte (<< 24) contains 0 if the phone
               is in the middle of a word, 1 on left side, 2 on right side, 3 word by itself
   DWORD       dwNum - Number of phonemes
   PCListFixed plPCMTTSTriPhonePros - Pointer to a list that is initialized to sizeof(PCMTTSTriPhonePros)
               and filled with a list of triphones, one of each phone (NOT times TTSDEMIPHONES).
returns
   BOOl - TRUE if success
*/

BOOL CMTTS::SynthDetermineTriPhonePros (DWORD *padwPhone, DWORD dwNum,
                                    PCListFixed plPCMTTSTriPhonePros)
{
   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster)
         return FALSE;
      return m_pTTSMaster->SynthDetermineTriPhonePros (padwPhone, dwNum,
         plPCMTTSTriPhonePros);
   }

   // get silence
   PCMLexicon pLex = Lexicon();
   if (!pLex)
      return FALSE;
   BYTE bSilence = pLex->PhonemeFindUnsort (pLex->PhonemeSilence());

   // clear desintation
   plPCMTTSTriPhonePros->Init (sizeof(PCMTTSTriPhonePros));

   // loop
   DWORD i;
   plPCMTTSTriPhonePros->Required (dwNum);
   for (i = 0; i < dwNum; i++) {
      DWORD dwLeft = i ? padwPhone[i-1] : bSilence;
      DWORD dwRight = (i+1 < dwNum) ? padwPhone[i+1] : bSilence;

      PCMTTSTriPhonePros ptp = SynthDetermineTriPhonePros ((BYTE)padwPhone[i],
         (WORD)(padwPhone[0] >> 24), (BYTE)dwLeft, (BYTE)dwRight);
      plPCMTTSTriPhonePros->Add (&ptp);
   } // i

   return TRUE;
}


/*************************************************************************************
PitchLowPass - Does a low-pass filter on the pitch/volume settings. THis also
looks for values that are < 0 and ramps between them.

inputs
   fp             *pafVal - Pointer to array of pitch values
   DWORD          dwNum - Number
   DWORD          dwHalfSize - Size (in units) of half the low-pass window.
                     The window is triangular
   fp             fDefault - Default value if can't find left/right to ramp between
returns
   none
*/
void PitchLowPass (fp *pafVal, DWORD dwNum, DWORD dwHalfSize, fp fDefault)
{
   // look for places that need to ramp
   DWORD i, j;
   DWORD dwLast = 0;
   while (TRUE) {
      // find first < 0
      for (i = dwLast; i < dwNum; i++)
         if (pafVal[i] < 0)
            break;
      if (i >= dwNum)
         break;   // no more

      // find first > 0
      for (j = i+1; j < dwNum; j++)
         if (pafVal[j] >= 0)
            break;

      // left and right value
      fp fLeft = (i ? pafVal[i-1] : -1);
      fp fRight = ((j < dwNum) ? pafVal[j] : -1);
      if (fLeft < 0)
         fLeft = (fRight >= 0) ? fRight : fDefault;
      if (fRight < 0)
         fRight = (fLeft >= 0) ? fLeft : fDefault;

      // interp amount
      fp fDelta = (fRight - fLeft) / (fp)(j - i);
      fp fCur = fLeft + fDelta/2;
      for (; i < j; i++, fCur += fDelta)
         pafVal[i] = fCur;
      dwLast = j + 1;
   }

#ifdef NOMODS_LOWPASS
   return;
#endif

   // now low pass filter...

   // copy over
   CMem mem;
   if (!mem.Required (sizeof(fp) * dwNum))
      return;
   fp *pfOrig = (fp*)mem.p;
   memcpy (pfOrig, pafVal, sizeof(fp)*dwNum);

   // low pass
   fp fSum;
   int iDist, iCur;
   DWORD dwCount, dwStrength;
   for (i = 0; i < dwNum; i++) {
      fSum = 0;
      dwCount = 0;

      for (iDist = -(int)dwHalfSize; iDist <= (int)dwHalfSize; iDist++) {
         iCur = iDist + (int)i;
         if ((iCur < 0) || (iCur >= (int)dwNum))
            continue;

         dwStrength = dwHalfSize + 1 - (DWORD)abs(iDist);
         fSum += pfOrig[iCur] * (fp)dwStrength;
         dwCount += dwStrength;
      } // iDist
      if (dwCount)
         fSum /= (fp)dwCount;

      pafVal[i] = fSum;
   } // i

   // done
}


/*************************************************************************************
CMTTS::LogSpoken - Log what's spoken to the log file.

inputs
   PCM3DWave         pWave - Wave with the words in it that should be logged
returns
   BOOL - TRUE if success
*/
BOOL CMTTS::LogSpoken (PCM3DWave pWave)
{
   if (!m_fKeepLog)
      return FALSE;

   // creat the string
   CMem memW;
   MemZero (&memW);
   MemCat (&memW, L"\r\n");   // so have new line no matter what
   DWORD i;
   for (i = 0; i < pWave->m_lWVWORD.Num(); i++) {
      PWVWORD pw = (PWVWORD)pWave->m_lWVWORD.Get(i);
      PWSTR psz = (PWSTR)(pw+1);
      if (!psz[0] || psz[0] == L' ')
         continue;   // ignore spaces

      // add
      MemCat (&memW, psz);
      MemCat (&memW, L" ");   // so space separates elements
   }

   // convert this to ANSI in case need
   CMem memA;
   if (!memA.Required (wcslen((PWSTR)memW.p)*2+2))
      return FALSE;
   WideCharToMultiByte (CP_ACP, 0, (PWSTR)memW.p, -1, (char*)memA.p, (DWORD)memA.m_dwAllocated, 0, 0);

   // file name with text extension
   char szFile[256];
   WideCharToMultiByte (CP_ACP, 0, m_szFile, -1, szFile, sizeof(szFile), 0, 0);
   DWORD dwLen = (DWORD)strlen(szFile);
   if ((dwLen < 4) || (szFile[dwLen-4] != '.'))
      return FALSE;
   strcpy (szFile + (dwLen-3), "txt");

   // open existing
   OUTPUTDEBUGFILE (szFile);
   FILE *f = fopen (szFile, "r+b");
   BOOL fUnicode = TRUE;
   if (f) {
      WCHAR wUnicode = 0;
      fread (&wUnicode, sizeof(wUnicode), 1, f);
      if (wUnicode != 0xfeff)
         fUnicode = FALSE;

      fseek (f, 0, SEEK_END);
      if (ftell(f) > 10000000) {
         // file would be too large so dont add
         fclose (f);
         return FALSE;
      }
   }
   else {
      OUTPUTDEBUGFILE (szFile);
      f = fopen (szFile, "wb");
      if (!f)
         return FALSE;

      // write out incode header
      WCHAR wUnicode = 0xfeff;
      fwrite (&wUnicode, sizeof(wUnicode), 1, f);
   }

   // write out
   if (fUnicode)
      fwrite (memW.p, sizeof(WCHAR), wcslen((PWSTR)memW.p), f);
   else
      fwrite (memA.p, sizeof(char), strlen((char*)memA.p), f);

   fclose (f);
   return TRUE;
}


/*************************************************************************************
CMTTS::SynthGenFeatures - Given the phonemes, their durations, and the words they're
in, this fills in the wave's SRFEATUREs, phoneme, and word structures.

IMPORTANT: You must call:
   // will need to compress all units
   m_fTTSWaveDisableCompress = FALSE;
   TTSWaveCompress ();
Sometime after SynthGenFeatures() to re-enable background unit analysis and to
compress all the decompressed waves. DON'T call until after the audio has been synthesized.


inputs
   DWORD          dwCandidates - Number of PSYNGENFEATURESCANDIDATE
   PSYNGENFEATURESCANDIDATE paCandidates - List of candidates to try and synthesize. The candidate
                  with the best acoustic score is synthesized.

                  NOTE: The duration of the final wave might be expanded/contracted to ensure
                  that no time shift takes place

   PCM3DWave      pWave - To Synthesize to
   PCListFixed       plSRDETAILEDPHASE - Initialized and filled in with sRDETAILEDPHASE,
                        one per pWave->m_dwSRSamples.
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL              fDisablePCM - Set to TRUE if the player has temporarily disabled PSOLA
   PCListFixed    plPSOLASTRUCT - List pre-intialized to sizoef(PSOLASTRUCT), that will be appended to
                  with PSOLA information in case wish to synthesize PSOLA. Can be NULL.
   DWORD          *pdwBestCandidate - Filled in with the best candidate
   PCProgressSocket pProgress - Progress
returns
   BOOL - TRUE if success
*/


// BLENDPHASEINFO
typedef struct {
   DWORD             dwTime;        // time (in samples) into the wave where blend
   DWORD             dwSkip;        // skip value. 0x04 means to include phase from left, 0x08 includes phase from right
} BLENDPHASEINFO, *PBLENDPHASEINFO;

BOOL CMTTS::SynthGenFeatures (DWORD dwCandidates, PSYNGENFEATURESCANDIDATE paCandidates,
                              PCM3DWave pWave, PCListFixed plSRDETAILEDPHASE,
                              PTTSVOICEMOD pVoiceMod, int iTTSQuality, BOOL fDisablePCM, PCListFixed plPSOLASTRUCT,
                              DWORD *pdwBestCandidate, PCProgressSocket pProgress)
{
   *pdwBestCandidate = (DWORD)-1; // error

   // flag so can't check anything in background wise
   // BUGFIX - Go backwards so don't end up chasing background thread through
   // 16 different sentences
   DWORD i;
   for (i = 0; i < MAXRAYTHREAD; i++)
      EnterCriticalSection (&m_acsTTSWave[MAXRAYTHREAD - 1 - i]);
   m_fTTSWaveDisableCompress = TRUE;
      // NOTE: When set this to FALSE later don't need to worry about CS
   for (i = 0; i < MAXRAYTHREAD; i++)
      LeaveCriticalSection (&m_acsTTSWave[i]);

   plSRDETAILEDPHASE->Init (sizeof(SRDETAILEDPHASE));

   CListFixed lPCMTTSTriPhoneAudio, lPCMTTSTriPhoneAudioTemp, lPCMTTSTriPhonePros;
   if (pProgress)
      pProgress->Push(0.0, 0.5);
   
   // loop over all the candidates
   DWORD dwCand;
   DWORD dwBestCand = (DWORD)-1;
   fp fBestScore = 0;
   for (dwCand = 0; dwCand < dwCandidates; dwCand++) {
      if (pProgress)
         pProgress->Push ((fp)dwCand / (fp)dwCandidates, (fp)(dwCand+1) / (fp)dwCandidates);

      fp fScoreTemp;

      if (!SynthDetermineTriPhoneAudio (pVoiceMod->pSubVoice->m_fAvgPitch, paCandidates[dwCand].padwPhone, paCandidates[dwCand].padwWord, paCandidates[dwCand].padwDur,
         paCandidates[dwCand].pafVol, paCandidates[dwCand].fVolAbsolute, paCandidates[dwCand].plPitch,
         paCandidates[dwCand].dwNum, iTTSQuality, fDisablePCM, &lPCMTTSTriPhoneAudioTemp, &fScoreTemp, pProgress)) {

         if (pProgress) {
            pProgress->Pop();
            pProgress->Pop();
         }
         m_fTTSWaveDisableCompress = FALSE;
         return FALSE;
      }

#ifdef _DEBUG
      WCHAR szTemp[128];
      swprintf (szTemp, L"\r\nSynthGenFeatures candidate %d scores %g", (int)dwCand, (double)fScoreTemp);
      OutputDebugStringW (szTemp);
#endif

      // take the best one
      if ((dwBestCand == (DWORD)-1) || (fScoreTemp < fBestScore)) {
         dwBestCand = dwCand;
         fBestScore = fScoreTemp;
         lPCMTTSTriPhoneAudio.Init (sizeof(PCMTTSTriPhoneAudio), lPCMTTSTriPhoneAudioTemp.Get(0), lPCMTTSTriPhoneAudioTemp.Num());
      }


      if (pProgress)
         pProgress->Pop();
   }
   if (pProgress)
      pProgress->Pop();

   // remember the best andidate
   *pdwBestCandidate = dwBestCand;
   DWORD *padwPhone = paCandidates[dwBestCand].padwPhone;
   DWORD *padwDur = paCandidates[dwBestCand].padwDur;
   DWORD *padwWord = paCandidates[dwBestCand].padwWord;
   DWORD dwNum = paCandidates[dwBestCand].dwNum;
   PCListVariable plPitch = paCandidates[dwBestCand].plPitch;
   PWSTR *papszWord = paCandidates[dwBestCand].papszWord;
   BOOL fAbsPitch = paCandidates[dwBestCand].fAbsPitch;


   if (!SynthDetermineTriPhonePros (padwPhone, dwNum, &lPCMTTSTriPhonePros)) {
      m_fTTSWaveDisableCompress = FALSE;
      return FALSE;
   }
   PCMLexicon pLex = pVoiceMod->pLex;
   if (!pLex)
      pLex = Lexicon();
   if (!pLex) {
      m_fTTSWaveDisableCompress = FALSE;
      return FALSE;
   }

   PCMTTSTriPhoneAudio *pptp = (PCMTTSTriPhoneAudio*) lPCMTTSTriPhoneAudio.Get(0);
   PCMTTSTriPhonePros *pptpPros = (PCMTTSTriPhonePros*) lPCMTTSTriPhonePros.Get(0);
   

   BYTE bSilence = (BYTE)pLex->PhonemeFindUnsort(pLex->PhonemeSilence());
#ifdef _DEBUG
   // output the phonemes
   OutputDebugString ("\r\n:TTS Phone:");
   WORD wLastWave = (WORD)-1;
   WORD wLastPhone = (WORD)-1;
   WCHAR szTemp[64];
   for (i = 0 ; i < lPCMTTSTriPhoneAudio.Num(); i++) {
      PCMTTSTriPhoneAudio ptp = pptp[i];
      PLEXPHONE plp = pLex->PhonemeGetUnsort (PhonemeBackoff((BYTE)padwPhone[i/TTSDEMIPHONES], pLex, bSilence));

      if (ptp && ((ptp->m_wOrigWave != wLastWave) || (ptp->m_wOrigPhone != wLastPhone+((i%TTSDEMIPHONES) ? 0 : 1) ))) {
         // display wave and phone
         swprintf (szTemp, L" (%d:%d)", (int)ptp->m_wOrigWave, (int)ptp->m_wOrigPhone);
         OutputDebugStringW (szTemp);
      }

      if (ptp) {
         wLastWave = ptp->m_wOrigWave;
         wLastPhone = ptp->m_wOrigPhone;

         // display errors in triphones
         // mismatch in left phoneme
         BYTE bPrevPhone = (i >= TTSDEMIPHONES) ? (BYTE)padwPhone[i/TTSDEMIPHONES-1] : bSilence;
         if ((bPrevPhone != ptp->m_bPhoneLeft) && (!i || (pptp[i-1] != ptp)) ){
            PLEXPHONE plp2 = pLex->PhonemeGetUnsort (ptp->m_bPhoneLeft);
            if (plp2) {
               swprintf (szTemp, L" [!%s-]", plp2->szPhoneLong);
               OutputDebugStringW (szTemp);
            }
         }
      }

      // display this phoneme
      if (plp) {
         OutputDebugStringW (L" ");
         OutputDebugStringW (plp->szPhoneLong);
      }

      if (ptp) {
         // display errors in triphones
         BYTE bNextPhone = (i + TTSDEMIPHONES < lPCMTTSTriPhoneAudio.Num()) ? (BYTE)padwPhone[i/TTSDEMIPHONES+1] : bSilence;
         if ( (bNextPhone != ptp->m_bPhoneRight) && ((i+1 >= lPCMTTSTriPhoneAudio.Num()) || (pptp[i+1] != ptp)) ) {
            PLEXPHONE plp2 = pLex->PhonemeGetUnsort (ptp->m_bPhoneRight);
            if (plp2) {
               swprintf (szTemp, L" [!-%s]", plp2->szPhoneLong);
               OutputDebugStringW (szTemp);
            }
         }
      }

   } // i
   OutputDebugString ("\r\n");
#endif

   // figure out total duration
   DWORD dwTotalPreMod = 0;
   for (i = 0; i < dwNum; i++)
      dwTotalPreMod += padwDur[i];

   // make sure wave large enough
   pWave->m_dwSRSAMPLESPERSEC = SRSAMPLESPERSEC;
   DWORD dwSamples = pWave->m_dwSamplesPerSec / pWave->m_dwSRSAMPLESPERSEC;
   dwSamples = dwTotalPreMod * dwSamples;
   if (!pWave->BlankWaveToSize (dwSamples, TRUE)) {
      m_fTTSWaveDisableCompress = FALSE;
      return FALSE;
   }
   DWORD dwCur;

   // fill in the phases
   SRDETAILEDPHASE SDP;
   memset (&SDP, 0, sizeof(SDP));
   plSRDETAILEDPHASE->Required (pWave->m_dwSRSamples);
   for (i = 0; i < pWave->m_dwSRSamples; i++)
      plSRDETAILEDPHASE->Add (&SDP);
   PSRDETAILEDPHASE paSDP = (PSRDETAILEDPHASE) plSRDETAILEDPHASE->Get(0);

   DWORD dwNumCurve = pWave->m_adwPitchSamples[PITCH_F0];

   // make original pitch
   CListFixed lPitchOrig;
   lPitchOrig.Init (sizeof(fp));
   lPitchOrig.Required (dwNumCurve);
   fp fUnk = -1;
   for (i = 0; i < dwNumCurve; i++)
      lPitchOrig.Add (&fUnk);
   fp *pfPitchOrig = (fp*) lPitchOrig.Get(0);





   // will need to decompress all units
   // BUGFIX - Don't need to do because act of getting will decompress
   //for (i = 0; i < lPCMTTSTriPhoneAudio.Num(); i++)
   //   if (pptp[i])
   //      pptp[i]->Decompress();

   // precalculate can skip
   CListFixed lSkip;
   lSkip.Init (sizeof(DWORD));
   DWORD dwDemiPhone, dwCurDemiPhone;
   DWORD dwSkip;
   lSkip.Required (dwNum * TTSDEMIPHONES);
   for (i = 0; i < dwNum; i++) for (dwDemiPhone = 0; dwDemiPhone < TTSDEMIPHONES; dwDemiPhone++) {
      dwCurDemiPhone = i*TTSDEMIPHONES+dwDemiPhone;

      dwSkip = SynthUnitCanSkip (
         dwDemiPhone,
         pptp[dwCurDemiPhone],
         i ? pptp[(i-1) * TTSDEMIPHONES + (TTSDEMIPHONES-1)] : NULL,   // BUGFIX - Was dwCurDemiPhone-1
         dwCurDemiPhone ? pptp[dwCurDemiPhone-1] : NULL,
         (i+1 < dwNum) ? pptp[(i+1)*TTSDEMIPHONES] : NULL,
         (BYTE)padwPhone[i],
         i ? (BYTE) padwPhone[i-1] : bSilence,
         (i+1 < dwNum) ? (BYTE)padwPhone[i+1] : bSilence);

      lSkip.Add (&dwSkip);
   } // i

   // figure out how much to snap to pitch
   //fp fUnits = max(m_dwUnits,1);
   //fUnits = log(fUnits) - log(10000.0);   // so if 10,000 units then 0.0
   //fUnits /= (log(100000.0) - log(10000.0)); // so if 100,0000 units, then 1.0
   //fUnits = max(fUnits, 0.0); // limit
   //fUnits = min(fUnits, 1.0); // limit

   int   iSnapToPitch = 0; // 0 => use algorithsm, 1 = always snap to original, -1 no change (used desired pitch)
   BOOL fFullPCM = fDisablePCM ? FALSE : m_fFullPCM;

#ifdef NOMODS_DISABLEPCM
   fFullPCM = FALSE;
#endif

#ifdef NOMODS_SNAPTOPITCH
   iSnapToPitch = -1;
#endif
#ifdef NOMODS_ORIGPITCH
   iSnapToPitch = 1;
#endif

   // if specified absolute pitch then no snap-to-pitch
   if (fAbsPitch)
      iSnapToPitch = -1;
   DWORD *padwSkip = (DWORD*)lSkip.Get(0);

   // precalculate the joins
   CMem memSUJI;
   if (!memSUJI.Required (dwNum * TTSDEMIPHONES * sizeof(SYNTHUNITJOININFO))) {
      m_fTTSWaveDisableCompress = FALSE;
      return FALSE;
   }
   EMTJOINFINDBEST em;
   memset (&em, 0, sizeof(em));
   em.dwType = 30;
   em.dwNum = dwNum;
   em.dwNumDemi = dwNum * TTSDEMIPHONES;
   em.pptp = pptp;
   em.paSUJI = (PSYNTHUNITJOININFO) memSUJI.p;
   em.iTTSQuality = iTTSQuality;
   em.padwSkip = padwSkip;
   if (pProgress)
      pProgress->Push(0.5, 0.9);
   ThreadLoop (0, em.dwNumDemi, 1, &em, sizeof(em), pProgress);
   if (pProgress)
      pProgress->Pop ();

   // BUGFIX - Moved filling the wave in until after the pitch points
   // so can normalize the voice-box according to pitch
   // fill it in...
   CListFixed lBlendPhase;
   lBlendPhase.Init (sizeof(BLENDPHASEINFO));
   dwCur = 0;
   PCMTTSTriPhoneAudio apTPAHistory[2];
   DWORD adwHistory[3];
   memset (apTPAHistory, 0, sizeof(apTPAHistory));
   memset (adwHistory, 0, sizeof(adwHistory));
   if (pProgress)
      pProgress->Push(0.9, 1.0);

   // how many units, and how much allowed to hard-mod to the original
   fp fModAmount = log((fp)m_dwUnits) - log((fp)MODDURATION_UNITS_START);
   fModAmount /= (log((fp)MODDURATION_UNITS_STOP) - log((fp)MODDURATION_UNITS_START));
   fModAmount = max(fModAmount, 0.0);
   fModAmount = min(fModAmount, 1.0);
   fp fModDuration = fModAmount;
   fp fModPitch = fModAmount;


   int iDurationMod;

   for (i = 0; i < dwNum; dwCur += padwDur[i++]) {
      if (!(i%4) && pProgress)
         pProgress->Update ((fp)i / (fp)dwNum);

      // if is unvoiced then don't snap
      // fp fSnapToPitchThis = fSnapToPitch;
      BOOL fHasPitch = TRUE;
      PLEXPHONE plp = pLex ? pLex->PhonemeGetUnsort ((BYTE)padwPhone[i]) : NULL;
      PLEXENGLISHPHONE ple = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;
      if (!ple || !(ple->dwCategory & PIC_VOICED))
         fHasPitch = FALSE;
         // fSnapToPitchThis = 0;

      // precalculate the duration per individual demiphone
      DWORD adwDurPerDemiphone[TTSDEMIPHONES];
      for (dwDemiPhone = 0; dwDemiPhone < TTSDEMIPHONES; dwDemiPhone++) {
         DWORD dwLen = padwDur[i];
         adwDurPerDemiphone[dwDemiPhone] = dwLen * (dwDemiPhone+1) / TTSDEMIPHONES - dwLen * dwDemiPhone / TTSDEMIPHONES;
      }

      DWORD dwCurDemiPhoneOffset = dwCur;
      for (dwDemiPhone = 0; dwDemiPhone < TTSDEMIPHONES; dwCurDemiPhoneOffset += adwDurPerDemiphone[dwDemiPhone++]) {
         dwCurDemiPhone = i*TTSDEMIPHONES+dwDemiPhone;

         DWORD dwStart = dwCurDemiPhoneOffset; // dwLen * dwDemiPhone / TTSDEMIPHONES + dwCur;
         DWORD dwEnd = dwStart + adwDurPerDemiphone[dwDemiPhone]; // dwLen * (dwDemiPhone+1) / TTSDEMIPHONES + dwCur;
         if (dwEnd <= dwStart)
            continue;


         // sytnhesize
         if (!SynthUnit (fModDuration,
            dwCurDemiPhone, pWave, plSRDETAILEDPHASE,
            &lPitchOrig, // fSnapToPitchThis,
               // BUGFIX - Was using (fHasPitch ? pfPitchOrig : NULL), but just use pfPitchOrig for ALL
            pptp[dwCurDemiPhone], pptpPros[i],
            dwStart, dwEnd,
            dwCurDemiPhone ? pptp[dwCurDemiPhone-1] : NULL,
            i ? pptpPros[i-1] : NULL,
            (dwCurDemiPhone+1 < dwNum*TTSDEMIPHONES) ? pptp[dwCurDemiPhone+1] : NULL,
            (i+1 < dwNum) ? pptpPros[i+1] : NULL,
            pVoiceMod,
            padwSkip[dwCurDemiPhone],
            dwCurDemiPhone ? padwSkip[dwCurDemiPhone-1] : 0,
            (dwCurDemiPhone+1 < dwNum*TTSDEMIPHONES) ? padwSkip[dwCurDemiPhone+1] : 0,
            &apTPAHistory[0], &apTPAHistory[1],
            &adwHistory[0], &adwHistory[1], &adwHistory[2],
            iTTSQuality,
            (PSYNTHUNITJOININFO) memSUJI.p + dwCurDemiPhone,
            plPSOLASTRUCT,
            &iDurationMod)) {

               m_fTTSWaveDisableCompress = FALSE;
               return FALSE;
            }

         // some values may have been changed
         paSDP = (PSRDETAILEDPHASE) plSRDETAILEDPHASE->Get(0);
         pfPitchOrig = (fp*) lPitchOrig.Get(0);
         dwNumCurve = (DWORD)((int)dwNumCurve + iDurationMod);
         adwDurPerDemiphone[dwDemiPhone] = (DWORD)((int)adwDurPerDemiphone[dwDemiPhone] + iDurationMod);

         // if can skip the left then have a boundary that need to remember
         if (padwSkip[dwCurDemiPhone] & (0x04 | 0x08)) {
            BLENDPHASEINFO bpi;
            bpi.dwSkip = padwSkip[dwCurDemiPhone];
            bpi.dwTime = dwStart;
            lBlendPhase.Add (&bpi);
         }
      } // dwDemiPhone

      // since SynthUnit() may have modified the duration, go back and store
      // the new duration
      padwDur[i] = 0;
      for (dwDemiPhone = 0; dwDemiPhone < TTSDEMIPHONES; dwDemiPhone++)
         padwDur[i] += adwDurPerDemiphone[dwDemiPhone];

      // get the phoneme name
      plp = pLex->PhonemeGetUnsort (PhonemeBackoff((BYTE)padwPhone[i], pLex, bSilence));

      // add the phoneme
      WVPHONEME wp;
      memset (&wp, 0, sizeof(wp));
      if (plp)
         memcpy (wp.awcNameLong, plp->szPhoneLong, min((wcslen(plp->szPhoneLong)+1)*sizeof(WCHAR), sizeof(wp.awcNameLong)));
      wp.dwEnglishPhone = plp ? plp->bEnglishPhone : 0;
      wp.dwSample = dwCur * pWave->m_dwSRSkip;
      pWave->m_lWVPHONEME.Add (&wp);

      // add the word?
      if (papszWord) {
         if ((i == 0) || papszWord[i] != papszWord[i-1]) {
            BYTE abHuge[512];
            PWVWORD pww = (PWVWORD)abHuge;
            PWSTR psz = (PWSTR)(pww+1);
            psz[0] = 0;
            if (papszWord[i] && (wcslen(papszWord[i])*sizeof(WCHAR) < sizeof(abHuge)-sizeof(WVWORD)-1))
               wcscpy (psz, papszWord[i]);

            pww->dwSample = dwCur * pWave->m_dwSRSkip;

            pWave->m_lWVWORD.Add (abHuge, sizeof(WVWORD) + (wcslen(psz)+1)*sizeof(WCHAR));
         }
      }
      else {   // no words
         if ((i==0) || (padwWord[i] != padwWord[i-1]) ) {
            BYTE abHuge[512];
            PWVWORD pww = (PWVWORD)abHuge;
            PWSTR psz = (PWSTR)(pww+1);
            pww->dwSample = dwCur * pWave->m_dwSRSkip;
            psz[0] = 0;
            if (padwWord[i] != -1)
               m_pLexWords->WordGet (padwWord[i], psz, sizeof(abHuge)-sizeof(WVWORD), NULL);
            pWave->m_lWVWORD.Add (abHuge, sizeof(WVWORD) + (wcslen(psz)+1)*sizeof(WCHAR));
         }
      }
   } // i
   if (pProgress)
      pProgress->Pop();

   //for (i = 0; i < lPCMTTSTriPhoneAudio.Num(); i++)
   //   if (pptp[i])
   //      pptp[i]->Compress();

   // clear out any remaining audio with silence
   if (dwCur < pWave->m_dwSRSamples) {
      SynthUnit (fModDuration, 0, pWave, plSRDETAILEDPHASE, &lPitchOrig /*pfPitchOrig, fSnapToPitch*/, NULL, NULL, dwCur, pWave->m_dwSRSamples,
         NULL, NULL, NULL, NULL, pVoiceMod, 0, 0, 0,
         NULL, NULL, NULL, NULL, NULL,
         iTTSQuality, NULL, plPSOLASTRUCT, &iDurationMod);

      paSDP = (PSRDETAILEDPHASE) plSRDETAILEDPHASE->Get(0);
      pfPitchOrig = (fp*) lPitchOrig.Get(0);
      dwNumCurve = (DWORD)((int)dwNumCurve + iDurationMod);
   }



   // figure out the pitch points
   DWORD j;
   dwCur = 0;
   CListFixed lPitchCurve, lPhoneAtPitchCurve;
   lPitchCurve.Init (sizeof(fp));   // BUGFIX - Changed pitch curve to filtered, not spline
   lPhoneAtPitchCurve.Init (sizeof(DWORD));
   for (i = 0; i < plPitch->Num(); dwCur += padwDur[i++]) {
      DWORD dwSize = (DWORD)plPitch->Size(i);
      dwSize /= sizeof(fp);
      if (!dwSize)
         continue;   // no data
      fp *pfPitch = (fp*)plPitch->Get(i);

#if 0 // dont need this anymore def NOMODS_ORIGPITCH
      fp afPitchTemp[4];
      afPitchTemp[0] = afPitchTemp[1] = pptp[i*TTSDEMIPHONES+0] ? pptp[i*TTSDEMIPHONES+0]->m_fOrigPitch : 50;
      afPitchTemp[2] = afPitchTemp[3] = pptp[i*TTSDEMIPHONES+1] ? pptp[i*TTSDEMIPHONES+1]->m_fOrigPitch : 50;
      pfPitch = afPitchTemp;
      dwSize = sizeof(afPitchTemp) / sizeof(fp);
#endif

      // loop over sub-points
      for (j = 0; j < dwSize; j++) {
         fp fTime = (fp)dwCur + (fp)padwDur[i] / (fp)(dwSize+1) * (fp)(j+1);
         fp fVal = pfPitch[j];
         int iTime = (int)(fTime + .5);

         // while pitch curve doesn't include enough points, add -1 values
         // to list so that will be filled in later
         if (iTime >= 0) {
            lPitchCurve.Required ((DWORD)iTime+1);
            lPhoneAtPitchCurve.Required ((DWORD)iTime+1);
         }
         while (iTime > (int)lPitchCurve.Num()) {
            lPitchCurve.Add (&fUnk);
            lPhoneAtPitchCurve.Add (&padwPhone[i]);
         }

         // add final one, which is point
         if (iTime <= (int)lPitchCurve.Num()) {
            // BUGFIX - If pitch <= 0 then add Unknown
            lPitchCurve.Add ((fVal <= 0) ? &fUnk : &fVal);
            lPhoneAtPitchCurve.Add (&padwPhone[i]);
         }
      } // j
   } // i

   // extend the pitch curve so it's as large as pWave->m_adwPitchSamples[PITCH_F0]
   while (lPitchCurve.Num() < dwNumCurve) {
      lPitchCurve.Add (&fUnk);

      DWORD dw = bSilence;
      lPhoneAtPitchCurve.Add (&dw);
   }
   fp *pfPitch = (fp*) lPitchCurve.Get(0);
   DWORD *padwPhoneAtPitchCurve = (DWORD*) lPhoneAtPitchCurve.Get(0);



      
   // if there are any blanks in the original unit that aren't in the new one then
   // fill in
   for (i = 0; i < dwNumCurve; i++)
      if ((pfPitchOrig[i] < 0) && (pfPitch[i] >= 0))
         pfPitchOrig[i] = pfPitch[i];

   // smooth out the pitch curves
   PitchLowPass (pfPitchOrig, dwNumCurve,
         0,
         pVoiceMod->pSubVoice->m_fAvgPitch);
   PitchLowPass (pfPitch, dwNumCurve,
         0,
         pVoiceMod->pSubVoice->m_fAvgPitch);
      // BUGFIX - Changed from SRSAMPLESPERSEC/20 to 0

   // weight
   fp fOrigPitch = pVoiceMod->pSubVoice->m_fAvgPitch;

   // BUGFIX - If derived voice, then IGNORE snap-to-pitch since won't
   // make any difference anyhow
   if ((fOrigPitch / m_fAvgPitch < 0.98) || (fOrigPitch / m_fAvgPitch > 1.02)) {
      // large variation
      // BUGFIX - Leave snap-to-pitch on even if have disorted the voice. the snap-to-pitch
      // tends to make phonemes match their pitch angle/delta, which should improve quality
      //if (iSnapToPitch == 0)
      //   iSnapToPitch = -1;
   }
   else {
      if ((iSnapToPitch == 0) && (fModPitch > 0.90) )
         iSnapToPitch = 1; // always go right to the original
         // NOTE: This might mess up transplanted prosody with absolute pitch
   }


   for (i = 0; i < dwNumCurve; i++) {
      fp fPitchThis = pfPitch[i]; // BUGFIX - Was = pfPitchOrig[i]

      // if voice is permanently pitch shifted then take this into account
      fPitchThis = fPitchThis * max(m_fAvgPitch, 1.0) / max(fOrigPitch, 1.0);

      // so can get related to original pitch
      fPitchThis /= pfPitchOrig[i]; // BUGFIX - Was pfPitch[i]

      fp fLogPitchThis = log(fPitchThis) / log(2.0);
      fp fPerOctave = UnitScorePitch (this, (BYTE)padwPhoneAtPitchCurve[i], pLex, fLogPitchThis >= 0, fFullPCM);
      fp fScalePow = fabs(fLogPitchThis) * max(fPerOctave, 0.0)  / (fp)SNAPTOSCALEPITCH;
      fScalePow *= SNAPTOSCALEBYUNITS; // so more units, the more it snaps to
      fp fScale = pow ((fp)0.5, fScalePow);
      if (iSnapToPitch > 0)
         fScale = 0; // always go to original pitch
      else if (iSnapToPitch < 0)
         fScale = 1.0;  // always go to asked-for pitch

      pfPitch[i] = pow ((fp)2.0, fScale * fLogPitchThis) * pfPitchOrig[i];  // BUGFIX - Was * pfPitch[i]

      // reapply voice mods
      pfPitch[i] /= (max(m_fAvgPitch, 1.0) / max(fOrigPitch, 1.0));  // BUGFIX - Put this back in
   }

   PBLENDPHASEINFO paBlendPhaseAt;
   int iBlurCenter;
#ifndef NOMODS_ORIGPITCH
   // AWLAYS do blending at unit borders
   DWORD dwBlendHalf = pWave->m_dwSamplesPerSec / pWave->m_dwSRSkip / 40;  // 1/40th sec
   dwBlendHalf = max(dwBlendHalf, 1);

   // blend only the borders of non-contiguous units
   paBlendPhaseAt = (PBLENDPHASEINFO)lBlendPhase.Get(0);
   for (i = 0; i < lBlendPhase.Num(); i++, paBlendPhaseAt++) {
      iBlurCenter = (int) paBlendPhaseAt->dwTime;
      if ((iBlurCenter < 1) || (iBlurCenter >= (int)dwNumCurve))
         continue;   // cant blur here because at the edge already

      fp fAverage = (pfPitch[iBlurCenter-1] + pfPitch[iBlurCenter]) / 2.0;

      int iOffset, iCur;
      for (iOffset = -(int)dwBlendHalf; iOffset < (int)dwBlendHalf; iOffset++) {
         iCur = iOffset + iBlurCenter;
         if ((iCur < 0) || (iCur >= (int)dwNumCurve))
            continue;

         fp fAlpha = (iOffset >= 0) ? ((fp)iOffset+0.5) : (-iOffset - 0.5);
         fAlpha /= (fp)dwBlendHalf;

         pfPitch[iCur] = fAlpha * pfPitch[iCur] + (1.0 - fAlpha) * fAverage;
      } // iOffset
   } // i

   // sometimes do even more blending
   DWORD dwLowPass = SRSAMPLESPERSEC/40;
   dwLowPass = (DWORD)floor((1.0 - fModPitch) * (fp)dwLowPass + 0.0 * fModPitch + 0.5);
   if (dwLowPass)
      // blend everything
      // because doing fSnapToPitch, must to a bit of low-pass filtering
      PitchLowPass (pfPitch, dwNumCurve,
            dwLowPass,
            pVoiceMod->pSubVoice->m_fAvgPitch);
         // BUGFIX - Changed from SRSAMPLESPERSEC/20 to 0
#endif

   // loop through all the pitch points
   DWORD dwCurCurve = 0;
   for (i = 0; i < pWave->m_adwPitchSamples[PITCH_F0]; i++) {
      fp fPitch = pfPitch[i];
      fPitch = max(fPitch, 1);   // always at least some frequency..
      for (j = 0; j < pWave->m_dwChannels; j++) {
         pWave->m_apPitch[PITCH_F0][i*pWave->m_dwChannels+j].fFreq = fPitch;
         pWave->m_apPitch[PITCH_F0][i*pWave->m_dwChannels+j].fStrength = 1;
      } // j
   } // i
   pWave->m_afPitchMaxStrength[PITCH_F0] = 1;

   // add a final silence...
   // BYTE bSilence = (BYTE)pLex->PhonemeFindUnsort(pLex->PhonemeSilence());
   if (dwNum && ((BYTE)padwPhone[dwNum] != bSilence)) {
      PLEXPHONE plp = pLex->PhonemeGetUnsort (bSilence);

      WVPHONEME wp;
      memset (&wp, 0, sizeof(wp));
      if (plp)
         memcpy (wp.awcNameLong, plp->szPhoneLong, min((wcslen(plp->szPhoneLong)+1)*sizeof(WCHAR), sizeof(wp.awcNameLong)));
      wp.dwEnglishPhone = plp ? plp->bEnglishPhone : 0;
      wp.dwSample = dwCur * pWave->m_dwSRSkip;
      pWave->m_lWVPHONEME.Add (&wp);
      
      // final word
      BYTE abHuge[512];
      PWVWORD pww = (PWVWORD)abHuge;
      PWSTR psz = (PWSTR)(pww+1);
      pww->dwSample = dwCur * pWave->m_dwSRSkip;
      psz[0] = 0;
      pWave->m_lWVWORD.Add (abHuge, sizeof(WVWORD) + (wcslen(psz)+1)*sizeof(WCHAR));
   }

#ifdef NOMODS_SRDETAILEDPHASE
   plSRDETAILEDPHASE = NULL;
#endif

#ifndef NOMODS_ALIGNPCM
   // BUGFIX - Only do if full PCM because cause wierd boundaries at times
   if (fFullPCM && !(plPSOLASTRUCT && plPSOLASTRUCT->Num()) && !PhaseModelGet(0,FALSE) )
      pWave->SRFEATUREAlignPCM (fFullPCM, pLex, plSRDETAILEDPHASE);
#endif


#if 0 // test with no phase-per-octave
   for (i = 0; i < pWave->m_dwSRSamples; i++)
      memset (paSDP[i].afVoicedPhase, 0, sizeof(paSDP[i].afVoicedPhase));
#endif // 0

#if 0 // test with no phase-per-harmonic
   for (i = 0; i < pWave->m_dwSRSamples; i++)
      memset (paSDP[i].afHarmPhase, 0, sizeof(paSDP[i].afHarmPhase));
#endif // 0

   DWORD dwPhaseBlurDistance = (DWORD) ((fp)pWave->m_dwSRSAMPLESPERSEC * PHASEBLURWIDTH_BASE + 0.5);    // 1/32th of a second to left and right, for lowest
      // BUGFIX - Was doing /36, but * 0.3 is basically the same
   DWORD dwPhaseBlurDistanceTop = (DWORD) ((fp)pWave->m_dwSRSAMPLESPERSEC * PHASEBLURWIDTH_TOP + 0.5);
   paBlendPhaseAt = (PBLENDPHASEINFO)lBlendPhase.Get(0);
   for (i = 0; i < lBlendPhase.Num(); i++, paBlendPhaseAt++) {
      iBlurCenter = (int) paBlendPhaseAt->dwTime;
      if ((iBlurCenter < 1) || (iBlurCenter >= (int)pWave->m_dwSRSamples))
         continue;   // cant blur here because at the edge already

      BOOL fShift = TRUE, fBlend = TRUE;
#ifdef NOMODS_BLURPHASEDETAILED
      fBlend = FALSE;
#endif
#ifdef NOMODS_BENDPHASEDETAILED
      fShift = FALSE;
#endif
      SRDETAILEDPHASEShiftAndBlend (paSDP, pWave->m_dwSRSamples, (DWORD)iBlurCenter,
                                   dwPhaseBlurDistance, dwPhaseBlurDistanceTop, fShift, fBlend);

   } // i

   // blend in phases where units change
#define NUMPHASEBLUR       (SRPHASENUM/2)          // since dont need to blur all the way up 
   // BUGFIX - Was /4, but upped to /2
#ifndef NOMODS_BLURPHASE
   // BUGFIX - Only have one blur angle over the whole boundary and see how well works
   // since trying half for each side caused more problems
   fp afBlurAngle[NUMPHASEBLUR][2];
   fp afBlurAngleDetailed[NUMPHASEBLUR][2];  // used for detailed phase
   DWORD dwCount, dwWeightScale;
   DWORD dwPhaseBlurDistance = (DWORD) ((fp)pWave->m_dwSRSAMPLESPERSEC * PHASEBLURWIDTH_BASE + 0.5);    // 1/32th of a second to left and right, for lowest
      // BUGFIX - Was doing /36, but * 0.3 is basically the same
   DWORD dwPhaseBlurDistanceTop = (DWORD) ((fp)pWave->m_dwSRSAMPLESPERSEC * PHASEBLURWIDTH_TOP + 0.5);
      // BUGFIX - Up to 1/16th of a second since still getting phase problems
      // BUGFIX - 1/16th too large. Go to 1/24th
      // BUGFIX - Go to 1/36th (from 1/24th) of a second since put in SRFEATUREAlignPCM
   PBLENDPHASEINFO paBlendPhaseAt = (PBLENDPHASEINFO)lBlendPhase.Get(0);
   for (i = 0; i < lBlendPhase.Num(); i++, paBlendPhaseAt++) {
      int iBlurCenter = (int) paBlendPhaseAt->dwTime;
      if ((iBlurCenter < 1) || (iBlurCenter >= (int)pWave->m_dwSRSamples))
         continue;   // cant blur here because at the edge already

      // determine the angles
      DWORD dwSide, dwOffset,dwPhaseBlurDistThis, dwWeight;
      fp fAngle, fX, fY, fXDetailed, fYDetailed;
      int iPhaseCur;
      for (j = 0; j < NUMPHASEBLUR; j++) {
         dwPhaseBlurDistThis = (dwPhaseBlurDistance * (NUMPHASEBLUR-j) + dwPhaseBlurDistanceTop*j) / NUMPHASEBLUR;
         dwPhaseBlurDistThis = max(dwPhaseBlurDistThis, 1);

         fX = fY = fXDetailed = fYDetailed = 0;
         dwCount = 0;

         for (dwSide = 0; dwSide < 2; dwSide++) {
            // BUGFIX include wrong sides, but underweight, otherwise too many phase flips
            DWORD dwSkipFlag = dwSide ? 0x04 : 0x08;
            if (!(paBlendPhaseAt->dwSkip & dwSkipFlag))
               dwWeightScale = 1;   // dont use phase from this side
            else
               dwWeightScale = 2;

            for (dwOffset = 0; dwOffset < dwPhaseBlurDistThis; dwOffset++) {
               if (!dwSide)
                  iPhaseCur = iBlurCenter + (int)dwOffset;
               else
                  iPhaseCur = iBlurCenter - (int)dwOffset - 1;
               if ((iPhaseCur < 0) || (iPhaseCur >= (int)pWave->m_dwSRSamples))
                  continue;   // out of range

               dwWeight = (dwPhaseBlurDistThis - dwOffset) * dwWeightScale;

               fAngle = (fp)pWave->m_paSRFeature[iPhaseCur].abPhase[j] / 256.0 * 2.0 * PI;
               fX += sin(fAngle) * (fp)dwWeight;
               fY += cos(fAngle) * (fp)dwWeight;

               fXDetailed += paSDP[iPhaseCur].afHarmPhase[j][0] * (fp)dwWeight;
               fYDetailed += paSDP[iPhaseCur].afHarmPhase[j][1] * (fp)dwWeight;

               dwCount += dwWeight;
            } // dwOffset

         } // dwSide

         if (dwCount) {
            fX /= (fp)dwCount;
            fY /= (fp)dwCount;
            fXDetailed /= (fp)dwCount;
            fYDetailed /= (fp)dwCount;
         }
         afBlurAngle[j][0] = fX;
         afBlurAngle[j][1] = fY;

         afBlurAngleDetailed[j][0] = fXDetailed;
         afBlurAngleDetailed[j][1] = fYDetailed;
      } // j

      // loop over all phases
      for (j = 0; j < NUMPHASEBLUR; j++) {
         dwPhaseBlurDistThis = (dwPhaseBlurDistance * (NUMPHASEBLUR-j) + dwPhaseBlurDistanceTop*j) / NUMPHASEBLUR;
         dwPhaseBlurDistThis = max(dwPhaseBlurDistThis, 1);

         // loop over first left, then right
         for (dwSide = 0; dwSide < 2; dwSide++) {
            // if get here, blend in phase with both sides, even if no pitch

            for (dwOffset = 0; dwOffset < dwPhaseBlurDistThis; dwOffset++) {
               if (!dwSide)
                  iPhaseCur = iBlurCenter + (int)dwOffset;
               else
                  iPhaseCur = iBlurCenter - (int)dwOffset - 1;
               if ((iPhaseCur < 0) || (iPhaseCur >= (int)pWave->m_dwSRSamples))
                  continue;   // out of range

               // not detailed
               fAngle = (fp)pWave->m_paSRFeature[iPhaseCur].abPhase[j] / 256.0 * 2.0 * PI;
               fX = sin(fAngle);
               fY = cos(fAngle);

               fX = (fp)(dwOffset+1) * fX + (fp)(dwPhaseBlurDistThis-dwOffset) * afBlurAngle[j][0];
               fY = (fp)(dwOffset+1) * fY + (fp)(dwPhaseBlurDistThis-dwOffset) * afBlurAngle[j][1];

               fAngle = atan2(fX, fY);
               fAngle = myfmod(fAngle, 2.0 * PI);
               pWave->m_paSRFeature[iPhaseCur].abPhase[j] = (BYTE)(fAngle / 2.0 / PI * 256.0);

               // detailed
               paSDP[iPhaseCur].afHarmPhase[j][0] = 
                  ((fp)(dwOffset+1) * paSDP[iPhaseCur].afHarmPhase[j][0] + (fp)(dwPhaseBlurDistThis-dwOffset) * afBlurAngle[j][0]) /
                  (fp)(dwPhaseBlurDistThis+1);
               paSDP[iPhaseCur].afHarmPhase[j][1] = 
                  ((fp)(dwOffset+1) * paSDP[iPhaseCur].afHarmPhase[j][1] + (fp)(dwPhaseBlurDistThis-dwOffset) * afBlurAngle[j][1]) /
                  (fp)(dwPhaseBlurDistThis+1);
            } // dwOffset
         } // dwSide
      } // j

   // also blur the per-octave phase
#define NUMPHASEBLUROCTAVE       (SRDATAPOINTSDETAILED)          // blur all the way up
      fp afBlurAngleOctave[NUMPHASEBLUROCTAVE][2];  // used for detailed phase
      for (j = 0; j < NUMPHASEBLUROCTAVE; j++) {
         dwPhaseBlurDistThis = (dwPhaseBlurDistance * (NUMPHASEBLUROCTAVE-j) + dwPhaseBlurDistanceTop*j) / NUMPHASEBLUROCTAVE;
         dwPhaseBlurDistThis = max(dwPhaseBlurDistThis, 1);

         fXDetailed = fYDetailed = 0;
         dwCount = 0;

         for (dwSide = 0; dwSide < 2; dwSide++) {
            // BUGFIX include wrong sides, but underweight, otherwise too many phase flips
            DWORD dwSkipFlag = dwSide ? 0x04 : 0x08;
            if (!(paBlendPhaseAt->dwSkip & dwSkipFlag))
               dwWeightScale = 1;   // dont use phase from this side
            else
               dwWeightScale = 2;

            for (dwOffset = 0; dwOffset < dwPhaseBlurDistThis; dwOffset++) {
               if (!dwSide)
                  iPhaseCur = iBlurCenter + (int)dwOffset;
               else
                  iPhaseCur = iBlurCenter - (int)dwOffset - 1;
               if ((iPhaseCur < 0) || (iPhaseCur >= (int)pWave->m_dwSRSamples))
                  continue;   // out of range

               dwWeight = (dwPhaseBlurDistThis - dwOffset) * dwWeightScale;

               fXDetailed += paSDP[iPhaseCur].afVoicedPhase[j][0] * (fp)dwWeight;
               fYDetailed += paSDP[iPhaseCur].afVoicedPhase[j][1] * (fp)dwWeight;

               dwCount += dwWeight;
            } // dwOffset

         } // dwSide

         if (dwCount) {
            fXDetailed /= (fp)dwCount;
            fYDetailed /= (fp)dwCount;
         }

         afBlurAngleOctave[j][0] = fXDetailed;
         afBlurAngleOctave[j][1] = fYDetailed;
      } // j

      // loop over all phases
      for (j = 0; j < NUMPHASEBLUROCTAVE; j++) {
         dwPhaseBlurDistThis = (dwPhaseBlurDistance * (NUMPHASEBLUROCTAVE-j) + dwPhaseBlurDistanceTop*j) / NUMPHASEBLUROCTAVE;
         dwPhaseBlurDistThis = max(dwPhaseBlurDistThis, 1);

         // loop over first left, then right
         for (dwSide = 0; dwSide < 2; dwSide++) {
            // if get here, blend in phase with both sides, even if no pitch

            for (dwOffset = 0; dwOffset < dwPhaseBlurDistThis; dwOffset++) {
               if (!dwSide)
                  iPhaseCur = iBlurCenter + (int)dwOffset;
               else
                  iPhaseCur = iBlurCenter - (int)dwOffset - 1;
               if ((iPhaseCur < 0) || (iPhaseCur >= (int)pWave->m_dwSRSamples))
                  continue;   // out of range

               // detailed
               paSDP[iPhaseCur].afVoicedPhase[j][0] = 
                  ((fp)(dwOffset+1) * paSDP[iPhaseCur].afVoicedPhase[j][0] + (fp)(dwPhaseBlurDistThis-dwOffset) * afBlurAngleOctave[j][0]) /
                  (fp)(dwPhaseBlurDistThis+1);
               paSDP[iPhaseCur].afVoicedPhase[j][1] = 
                  ((fp)(dwOffset+1) * paSDP[iPhaseCur].afVoicedPhase[j][1] + (fp)(dwPhaseBlurDistThis-dwOffset) * afBlurAngleOctave[j][1]) /
                  (fp)(dwPhaseBlurDistThis+1);

            } // dwOffset
         } // dwSide
      } // j


   } // i

   // to test with no phase
   // for (i = 0; i <pWave->m_dwSRSamples; i++)
   //   memset (pWave->m_paSRFeature[i].abPhase, 0, sizeof(pWave->m_paSRFeature[i].abPhase));
#endif // ndef NOMODS_BLURPHASE

   // blur the edges
#define BLURSIZE     max(SRSAMPLESPERSEC/100,1)
      // BUGFIX - Was SRSAMPLESPERSEC/50, but made smaller so that better sounding voice
#if 0 // BUGFIX - remove blurring to try to get crisper consonants. helps slightly in female
   note - this wont work properly because have 3x the number of triphones
   dwCur = 0;
   for (i = 0; i < dwNum; dwCur += padwDur[i++]) {
      SRFEATURE asrTemp[BLURSIZE*2];
      if (!dwCur)
         continue;   // nothing to blur with

      // if either is silence then dont bother blurring
      if (((BYTE)padwPhone[i] == bSilence) || ((BYTE)padwPhone[i-1] == bSilence))
         continue;

      // BUGFIX - if adjacent waves then dont blur in
      PCMTTSTriPhoneAudio pLeft = pptp[i-1];
      PCMTTSTriPhoneAudio pRight = pptp[i];
      if (pLeft && pRight && (pLeft->m_wOrigWave == pRight->m_wOrigWave) && (pLeft->m_wOrigPhone+1 == pRight->m_wOrigPhone))
         continue;

      DWORD j;
      int iCur;
      for (j = 0; j < BLURSIZE*2; j++) {
         iCur = (int)dwCur - BLURSIZE + (int)j;
         if ((iCur < 0) || (iCur >= (int)pWave->m_dwSRSamples))
            continue;
         asrTemp[j] = pWave->m_paSRFeature[iCur];
      }

      // blend in
      for (j = 0; j < BLURSIZE*2; j++) {
         iCur = (int)dwCur - BLURSIZE + (int)j;
         if ((iCur < 0) || (iCur >= (int)pWave->m_dwSRSamples))
            continue;
         fp fWeight;
         if (j < BLURSIZE)
            fWeight = BLURSIZE - 1 - j;
         else
            fWeight = j - BLURSIZE;
         fWeight = (fWeight + BLURSIZE + 1) / (fp)(2*BLURSIZE+1);

         SRFEATUREInterpolate (&asrTemp[j],
            &asrTemp[(j < BLURSIZE) ? BLURSIZE : (BLURSIZE-1)],
            fWeight,
            &pWave->m_paSRFeature[iCur]);
      }

   }
#endif // 0

   // will need to compress all units
   // BUGFIX - Must be done later so that don't lose PCM data for psola
   // m_fTTSWaveDisableCompress = FALSE;
   // TTSWaveCompress ();

   return TRUE;
}


/*************************************************************************************
CMTTS::SynthAdjustVolumeRelative - This goes through a generated wave (using the PCM)
and adjusts the volume levels for each phoneme.

inputs
   PCM3DWave         pWave - Wave
   DWORD       *padwDur - Duration for each phone in SRFEATURE time-units (1/100th sec)
   fp          *pafVol - Volume for each phone, relative. 1.0 = no change, 2.0 = 2x as loud, etc.
   DWPRD       dwNum - Number of phonemes
returns
   BOOL - TRUE if success
*/
BOOL CMTTS::SynthAdjustVolumeRelative (PCM3DWave pWave, DWORD *padwDur, fp *pafVol,
                                       DWORD dwNum)
{
#ifdef NOMODS_VOLUME
   return TRUE;
#endif

   // figure out the inflection points
   DWORD i, j, dwCur;
   dwCur = 0;
   CListFixed lVolCurve;
   lVolCurve.Init (sizeof(fp));    // BUGFIX - Make volume curve interpolation
   fp fUnk = -1;
   for (i = 0; i < dwNum; dwCur += padwDur[i++]) {
      // fill in point
      fp fTime = (fp)dwCur + (fp)padwDur[i] / 2.0;  // mid way
      fp fVal = pafVol[i];
      int iTime = (int)(fTime + 0.5);

      if (iTime >= 0)
         lVolCurve.Required ((DWORD)iTime + 1);

      // add in unknowns until get to time
      while (iTime > (int)lVolCurve.Num())
         lVolCurve.Add (&fUnk);

      // add final one, which is point
      if (iTime <= (int)lVolCurve.Num())
         lVolCurve.Add (&fVal);
   } // i
   // extend the pitch curve so it's as large as pWave->m_adwPitchSamples[PITCH_F0]
   lVolCurve.Required (pWave->m_dwSRSamples+1);
   while (lVolCurve.Num() < pWave->m_dwSRSamples+1)
      lVolCurve.Add (&fUnk);


   // smooth this out...
   fp *pfVol = (fp*) lVolCurve.Get(0);
   DWORD dwNumCurve = lVolCurve.Num();
   PitchLowPass (pfVol, dwNumCurve, SRSAMPLESPERSEC / 20, 1);



   // now go through and adjust the volumes
   // BUGFIX - Change this so it scales the SRFEATUREs, not the wave
   fp *pafScale = pfVol;
   DWORD dwNumReg = dwNumCurve;
   for (i = 0; i < pWave->m_dwSRSamples; i++) {
      // how much to scale?
      DWORD dwLeft = i;
      dwLeft = min(dwLeft, dwNumReg-1);

      fp fScale = pafScale[dwLeft];
      fScale = max(fScale, CLOSE);  // so dont get error in log
      fScale = log10(fScale) * 20.0;
      fScale = max(fScale, -64);
      fScale = min(fScale, 64);
      int iScale = (int) fScale;

      PSRFEATURE psr = pWave->m_paSRFeature + i;
      for (j = 0; j < SRDATAPOINTS; j++) {
         int iCur;

         iCur = psr->acNoiseEnergy[j] + iScale;
         iCur = max(iCur, SRABSOLUTESILENCE);
         iCur = min(iCur, 127);
         psr->acNoiseEnergy[j] = (char)iCur;

         iCur = psr->acVoiceEnergy[j] + iScale;
         iCur = max(iCur, SRABSOLUTESILENCE);
         iCur = min(iCur, 127);
         psr->acVoiceEnergy[j] = (char)iCur;
      } // j
   } // i

   return TRUE;
}


/*************************************************************************************
CMTTS::SynthAdjustEnergyPerVolume - Goes through and adjusts by energy per volume,
to simulate louder/quieter voice.

inputs
   PCM3DWave         pWave - Wave
   DWORD       *padwPhone - Pointer to an array of phonemes. Each phoneme is the
               unsorted phone number. The high byte (<< 24) contains 0 if the phone
               is in the middle of a word, 1 on left side, 2 on right side, 3 word by itself
   DWORD       *padwDur - Duration for each phone in SRFEATURE time-units (1/100th sec)
   fp          *pafVol - Volume for each phone, relative. 1.0 = no change, 2.0 = 2x as loud, etc.
   DWPRD       dwNum - Number of phonemes
returns
   BOOL - TRUE if success

BUGBUG - If ever use this may have to counteract modifications in UnitSynth() with TTSOUTPUTVOLUMESCALE
*/
BOOL CMTTS::SynthAdjustEnergyPerVolume (PCM3DWave pWave, DWORD *padwPhone, DWORD *padwDur,
                                       DWORD dwNum)
{
   // NOTE: DON'T need a NOMODS_XXX since if the NOMODS_ENERGYPERVOLUMEGET is
   // set then this will fail anyway

   // lexicon
   PCMLexicon pLex = Lexicon();
   if (!pLex)
      return FALSE;

   // allocate memory to store the energies of all the voices phonemes
   CMem memEnergy;
   if (!memEnergy.Required (pWave->m_dwSRSamples * sizeof(fp)))
      return FALSE;
   fp *pafEnergy = (fp*)memEnergy.p;
   memset (pafEnergy, 0, pWave->m_dwSRSamples * sizeof(fp));
   DWORD i, j, k, dwCur;
   PLEXPHONE plp;
   PLEXENGLISHPHONE pe;
   double fAvgEnergyForVoiced = 0;
   DWORD dwAEFVCount = 0;
   for (i = 0, dwCur = 0; i < dwNum; i++) {
      // get the phoneme
      plp = pLex->PhonemeGetUnsort ((BYTE)padwPhone[i]);
      pe = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;

      // calc energy for each
      for (j = 0; j < padwDur[i]; j++, dwCur++) {
         if (dwCur >= pWave->m_dwSRSamples)
            continue;   // shouldnt happen

         pafEnergy[dwCur] = SRFEATUREEnergy (FALSE, pWave->m_paSRFeature + dwCur);

         // if it's voiced, then include in calculations
         if (pe && (pe->dwCategory & PIC_VOICED)) {
            fAvgEnergyForVoiced += pafEnergy[dwCur];
            dwAEFVCount++;
         }
      } // j
   } // i

   if (!dwAEFVCount)
      return TRUE;   // nothing to do
   fAvgEnergyForVoiced /= (double)dwAEFVCount;

   // BUGBUG - in future, shout and speak quietly should be handled by changing
   // calculated average energy, to get right tweaks for voice spectrum

   // loop over again and adjust energies
   char *pacConvertVolume;
   int iVal;
   for (i = 0, dwCur = 0; i < dwNum; i++) {
      // get the phoneme
      plp = pLex->PhonemeGetUnsort ((BYTE)padwPhone[i]);
      pe = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;

      // calc energy for each
      for (j = 0; j < padwDur[i]; j++, dwCur++) {
         // ignore if it's ont voiced
         if (!pe || !(pe->dwCategory & PIC_VOICED))
            continue;

         pacConvertVolume = EnergyPerVolumeGet (pafEnergy[dwCur] / fAvgEnergyForVoiced);
         if (!pacConvertVolume)
            continue;

         if (dwCur >= pWave->m_dwSRSamples)
            continue;   // shouldnt happen
         PSRFEATURE psrOrig = pWave->m_paSRFeature + dwCur;

         for (k = 0; k < SRDATAPOINTS; k++) {
            iVal = (int)psrOrig->acVoiceEnergy[k];
            if (iVal < SRABSOLUTESILENCE+10)
               continue;   // dont allow to change at all
            if (pacConvertVolume)
               iVal += (int)pacConvertVolume[k];
            iVal = max(iVal, SRABSOLUTESILENCE);
            iVal = min(iVal, SRMAXLOUDNESS);
            psrOrig->acVoiceEnergy[k] = (char)iVal;
         } // k

#ifndef NOMODS_ENERGYPERVOLUMETUNE
         // BUGFIX - if the energy has changed after doing the volume-based-energy
         // adjust then rescale
         fp fEnergyNew = SRFEATUREEnergy (psrOrig);
         fEnergyNew = pafEnergy[dwCur] / max(fEnergyNew, CLOSE);
         int iDelta = AmplitudeToDb (fEnergyNew * (fp)0x8000);

         iDelta = max(iDelta, -12); // dont make too much change
         iDelta = min(iDelta, 12);

         if (iDelta) for (k = 0; k < SRDATAPOINTS; k++) {
            iVal = (int)psrOrig->acVoiceEnergy[k];
            if (iVal < SRABSOLUTESILENCE+10)
               continue;   // dont allow to change at all
            iVal += iDelta;
            iVal = max(iVal, SRABSOLUTESILENCE);
            iVal = min(iVal, SRMAXLOUDNESS);
            psrOrig->acVoiceEnergy[k] = (char)iVal;
         } // k
#endif

      } // j
   } // i


   return TRUE;
}


/*************************************************************************************
CMTTS::SynthGenWaveInt - Generates a final wave for synhtesis.
Given the phonemes, their durations, and the words they're
in, this fills in the wave's wave, SRFEATUREs, phoneme, and word structures.

inputs
   DWORD             dwCandidates - Number of candidates to synhthesize. The candidate
                     with the best acoustic score is used.
   PSYNGENFEATURESCANDIDATE   paCandidates - Array of candidates. padwWord is NOT required
                     by SyntheGenWaveInt(), and will be modified by this call.
   DWORD             dwSamplesPerSec - Sampling rate
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL              fDisablePCM - If TRUE, then PCM is disabled for speakin.
   PCProgressSocket pProgress - To measure progress with
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
   PCProgressWaveTTS pProgressWave - This is where the audio samples are sent out to
returns
   BOOL - TRUE if success
*/

/* Used in PSYNGENFEATURESCANDIDATE
   DWORD       *padwPhone - Pointer to an array of phonemes. Each phoneme is the
               unsorted phone number. The high byte (<< 24) contains 0 if the phone
               is in the middle of a word, 1 on left side, 2 on right side, 3 word by itself
   PWSTR       *paszWord - Word string associated with each phoneme, or NULL if none associated.
               If two or more phonemes are from the same word they should point to
               the same word string.
   DWORD       *padwDur - Duration for each phone in SRFEATURE time-units (1/100th sec)
   PCListVariable plPitch - This list has one element per phoneme to indicate the
               fundamental pitch of the voice (in Hz). Each element is N * sizeof(fp),
               where N is from 0 to whatever. It indicates the number of pitch points
               stored per phoneme.
   fp          *pafVol - Volume for each phone, relative. 1.0 = no change, 2.0 = 2x as loud, etc.
               If this is NULL then no volume change is done
   BOOL        fVolAbsoluate - If TRUE pafVol is the absolute volume to use (so can get this
               from transplanted prosody); in which case it's the CalcSREnergyRange() of
               the phoneme. If FALSE, relative volume.
   BOOL        fAbsPitch - If TRUE absolute pitch. If FALSE, can fudge on pitch and choose one
               closer to unit.
   DWORD       dwNum - Number of phonemes

   PTTSGLOBALSTATE paTTSGS - Global state per phoneme. Can be NULL, but no emotion then.

   no padwWord!!!!
*/

BOOL CMTTS::SynthGenWaveInt (DWORD dwCandidates, PSYNGENFEATURESCANDIDATE paCandidates,
                             DWORD dwSamplesPerSec,
                             int iTTSQuality, BOOL fDisablePCM, PCProgressSocket pProgress,
                              PTTSVOICEMOD pVoiceMod, PCProgressWaveTTS pProgressWave)
{
   // if multipass, can't really decide on a candidate now because might mess up
   // prosody, so just pass on through
   if (dwCandidates >= 2)
      return SynthGenWaveIntNewWave (dwCandidates, paCandidates, dwSamplesPerSec,
         iTTSQuality, fDisablePCM, pProgress, pVoiceMod, pProgressWave);

   // silence
   PCMLexicon pLex = pVoiceMod ? pVoiceMod->pLex : NULL;
   if (!pLex)
      pLex = Lexicon();
   BYTE bSilence = (BYTE) pLex->PhonemeFindUnsort(pLex->PhonemeSilence());

   // else, search for silence
   DWORD dwStart = 0;
   DWORD i, j;
   SYNGENFEATURESCANDIDATE cNew;
   CListVariable lTemp;
   BOOL fRet;
   BOOL fSilenceAtStart = FALSE;
   while (dwStart < paCandidates->dwNum) {
      // find silence
      BOOL fSilenceAtEnd = FALSE;
      for (i = dwStart; i < paCandidates->dwNum; i++)
         if ((BYTE) paCandidates->padwPhone[i] == bSilence) {
            i++;  // to include the silence
            if (i < paCandidates->dwNum)
               fSilenceAtEnd = TRUE;
            break;
         }

      // if had some silence before then include half the silence in this segment
      // so no sudden pitch shifts
      DWORD dwStartWithSilence = dwStart;
      DWORD dwStartSilenceDur = 0;
      if (fSilenceAtStart) {
         dwStartWithSilence--;

         // cache away
         dwStartSilenceDur = paCandidates->padwDur[dwStartWithSilence];

         // use half the silence
         paCandidates->padwDur[dwStartWithSilence] -= (paCandidates->padwDur[dwStartWithSilence]/2);
      }

      // cache end silence
      DWORD dwEndSilenceDur = 0;
      if (fSilenceAtEnd) {
         // cache
         dwEndSilenceDur = paCandidates->padwDur[i-1];

         // halve this
         paCandidates->padwDur[i-1] /= 2;
      }

      // fill in lTemp
      lTemp.Clear();
      for (j = dwStartWithSilence; j < i; j++)
         lTemp.Add (paCandidates->plPitch->Get(j), paCandidates->plPitch->Size(j));

      // info
      cNew = paCandidates[0];
      cNew.dwNum = i - dwStartWithSilence;
      cNew.padwDur += dwStartWithSilence;
      cNew.padwPhone += dwStartWithSilence;
      cNew.padwWord += dwStartWithSilence;
      cNew.pafVol += dwStartWithSilence;
      cNew.papszWord += dwStartWithSilence;
      if (cNew.paTTSGS)
         cNew.paTTSGS += dwStartWithSilence;
      cNew.plPitch = &lTemp;
      

      if (pProgress)
         pProgress->Push ((fp)dwStart / (fp)paCandidates->dwNum, (fp)i / (fp)paCandidates->dwNum);

      // speak this
      fRet = SynthGenWaveIntNewWave (1, &cNew, dwSamplesPerSec, iTTSQuality, fDisablePCM,
         pProgress, pVoiceMod, pProgressWave);

      if (pProgress)
         pProgress->Pop();

      // restore silence at start
      if (fSilenceAtStart)
         paCandidates->padwDur[dwStartWithSilence] = dwStartSilenceDur;

      // restore silence at end
      if (fSilenceAtEnd)
         paCandidates->padwDur[i-1] = dwEndSilenceDur;

      if (!fRet)
         return FALSE;

      if (i >= paCandidates->dwNum)
         break;

      // go onto the ntext bit
      fSilenceAtStart = fSilenceAtEnd;
      dwStart = i;
   } // while start

   return TRUE;
}

/*************************************************************************************
CMTTS::SynthGenWaveIntNewWave - Generates individual segments from SynthGenWaveInt()
so that TTS can speak more quicly.
*/

BOOL CMTTS::SynthGenWaveIntNewWave (DWORD dwCandidates, PSYNGENFEATURESCANDIDATE paCandidates,
                             DWORD dwSamplesPerSec,
                             int iTTSQuality, BOOL fDisablePCM, PCProgressSocket pProgress,
                              PTTSVOICEMOD pVoiceMod, PCProgressWaveTTS pProgressWave)
{
   // keep track of formant shift for PSOLA
   fp fFormantShift = 0;

   TTSVOICEMOD VM;
   if (!pVoiceMod) {
      pVoiceMod = &VM;
      FillInVOICEMOD (pVoiceMod, NULL, NULL);
   }

   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster)
         return FALSE;
      return m_pTTSMaster->SynthGenWaveInt (dwCandidates, paCandidates, dwSamplesPerSec, iTTSQuality, fDisablePCM, pProgress, pVoiceMod, pProgressWave);
   }

   // allocate the wave
   PCM3DWave pWave = new CM3DWave;
   if (!pWave || !pWave->ConvertSamplesAndChannels (dwSamplesPerSec, 1, NULL) ) {
      if (pWave)
         delete pWave;
      return FALSE;
   }

#ifdef _DEBUG
   DWORD dwTimeCur, dwTimeStart = GetTickCount();
   WCHAR szTemp[128];
#endif

   // figure out the word indecies
   CListFixed lWSF, lWSFFFT;
   CListFixed alWords[MAXSYNGENFEATURESCANDIDATES];
   CListFixed lVol;
   DWORD dwCand;
   DWORD i;
   for (dwCand = 0; dwCand < dwCandidates; dwCand++) {
      alWords[dwCand].Init (sizeof(DWORD));
      alWords[dwCand].Required (paCandidates[dwCand].dwNum);
      for (i = 0; i < paCandidates[dwCand].dwNum; i++) {
         DWORD dwFind = paCandidates[dwCand].papszWord[i] ? m_pLexWords->WordFind (paCandidates[dwCand].papszWord[i]) : -1;
         alWords[dwCand].Add (&dwFind);
      }

      paCandidates[dwCand].padwWord = (DWORD*)alWords[dwCand].Get(0);
   } // dwCand

   // fill in the features
   CListFixed lSRDETAILEDPHASE, lPSOLASTRUCT;
   lPSOLASTRUCT.Init (sizeof(PSOLASTRUCT));
   DWORD dwBestCandidate;
   if (pProgress)
      pProgress->Push (0.0, 0.8);
   if (!SynthGenFeatures (dwCandidates, paCandidates, pWave, &lSRDETAILEDPHASE,
      pVoiceMod, iTTSQuality, fDisablePCM, &lPSOLASTRUCT, &dwBestCandidate, pProgress)) {

         if (pProgress)
            pProgress->Pop();
         goto failed;
   }
   if (pProgress)
      pProgress->Pop();
   PSRDETAILEDPHASE paSDP = (PSRDETAILEDPHASE) lSRDETAILEDPHASE.Get(0);
#ifdef NOMODS_SRDETAILEDPHASE
   paSDP = NULL;  // test turning off detailed phase
#endif

#ifdef _DEBUG
   dwTimeCur = GetTickCount();
   swprintf (szTemp, L"\r\nSynthGenFeatures = %d ms", (int)(dwTimeCur - dwTimeStart));
   dwTimeStart = dwTimeCur;
   OutputDebugStringW (szTemp);
#endif

   // remember
   BOOL fVolAbsolute = paCandidates[dwBestCandidate].fVolAbsolute;
   fp *pafVol = paCandidates[dwBestCandidate].pafVol;
   DWORD dwNum = paCandidates[dwBestCandidate].dwNum;
   DWORD *padwDur = paCandidates[dwBestCandidate].padwDur;
   DWORD *padwPhone = paCandidates[dwBestCandidate].padwPhone;
   PTTSGLOBALSTATE paTTSGS = paCandidates[dwBestCandidate].paTTSGS;

   // see if need to calculate the volume for each of the phonemes
   lVol.Init (sizeof(fp));
   if (fVolAbsolute && pafVol) {
      DWORD dwCur = 0;
      PCMLexicon pLex = pVoiceMod->pLex;
      if (!pLex)
         pLex = Lexicon();
      BYTE bSilence = (BYTE) pLex->PhonemeFindUnsort(pLex->PhonemeSilence());
      lVol.Required (lVol.Num() + dwNum);
      for (i = 0; i < dwNum; dwCur += padwDur[i++]) {
         fp fEnergy = pWave->CalcSREnergyRange (FALSE, dwCur * pWave->m_dwSRSkip,
            (dwCur + padwDur[i]) * pWave->m_dwSRSkip);
         fEnergy = max(fEnergy, 1);
         fEnergy = max(pafVol[i],1) / fEnergy;  // BUGFIX - put max pafVol too
         
         // put some limits on so dont get really extreme
         if (fEnergy > 3)
            fEnergy = 3;
         else if (fEnergy < 1.0 / 3.0)
            fEnergy = 1.0 / 3.0;

         // BUGFIX - If it's a silence phoneme then don't care about energy
         if ((BYTE)padwPhone[i] == bSilence)
            fEnergy = 1;

         // add
         lVol.Add (&fEnergy);
      } // i
      pafVol = (fp*)lVol.Get(0);
   }

   if (pafVol)
      if (!SynthAdjustVolumeRelative (pWave, padwDur, pafVol, dwNum))
         goto failed;

   // adjust by energypervolume
   SynthAdjustEnergyPerVolume (pWave, padwPhone, padwDur, dwNum);

   // produce the wave
   // NOTE: Shouldnt do pitch adjust here (except for emphasis) because the pitch
   // will have been set in the voice modifications info
   
#ifdef _DEBUG
   dwTimeCur = GetTickCount();
   swprintf (szTemp, L"\r\nSynthAdjustVolumeRelatie = %d ms", (int)(dwTimeCur - dwTimeStart));
   dwTimeStart = dwTimeCur;
   OutputDebugStringW (szTemp);
#endif

#ifndef NOMODS_VOICEDISGUISE
   // modify featrures first
   if (!pVoiceMod->pSubVoice->m_VoiceDisguise.ModifySRFEATUREInWave (pWave, paSDP, &fFormantShift))
      goto failed;
#endif

#ifdef _DEBUG
   dwTimeCur = GetTickCount();
   swprintf (szTemp, L"\r\nModifySRFEATUREInWave = %d ms", (int)(dwTimeCur - dwTimeStart));
   dwTimeStart = dwTimeCur;
   OutputDebugStringW (szTemp);
#endif

   BOOL fWhispering = FALSE;
#ifndef NOMODS_SHOUTWHISPER
   // go through and adjust for shouting or whisper
   DWORD j, k, dwSRFeat;
   PSRFEATURE psr = pWave->m_paSRFeature;
   if (paTTSGS) for (i = dwSRFeat = 0; i < dwNum; i++, paTTSGS++) {
      for (j = 0; j < padwDur[i]; j++, dwSRFeat++, psr++) {
         // make sure not beyoond the edge
         if (dwSRFeat >= pWave->m_dwSRSamples)
            break;   // shouldnt happen

         // if shouting then adjust
         if (paTTSGS->fDerShout) {
            int iDelta = (int) (paTTSGS->fDerShout / (fp)SRDATAPOINTS * 12.0 /*db*/ * (fp)0x10000);
            int iAdd = 0;
            for (k = 0; k < SRDATAPOINTS; k++, iAdd += iDelta) {
               int iCur = (int)psr->acVoiceEnergy[k];
               if (iCur <= -100)
                  continue;   // silence, so ignore

               iCur += (iAdd / 0x10000);
               iCur = max (iCur, SRABSOLUTESILENCE);
               iCur = min (iCur, SRMAXLOUDNESS);
               psr->acVoiceEnergy[k] = (char)iCur;
            } // k
         } // shout
         
         // if whisper then adjust
#define WHISPERSTART    (SRDATAPOINTS - SRPOINTSPEROCTAVE*4)
#define WHISPERSTOP     (SRDATAPOINTS - SRPOINTSPEROCTAVE*2)
         if (paTTSGS->fDerWhisper) {
            paTTSGS->fDerWhisper = max(paTTSGS->fDerWhisper, 0.0);
            paTTSGS->fDerWhisper = min(paTTSGS->fDerWhisper, 1.0);

            fp fOneMinus = 1.0 - paTTSGS->fDerWhisper;

            if (paTTSGS->fDerWhisper > 0.75)
               fWhispering = TRUE;

            for (k = 0; k < SRDATAPOINTS; k++) {
               fp fVoice = DbToAmplitude (psr->acVoiceEnergy[k]);
               fp fNoise = DbToAmplitude (psr->acNoiseEnergy[k]);
               fp fWhisperScale;
               if (k <= WHISPERSTART)
                  fWhisperScale = 0;
               else if (k >= WHISPERSTOP)
                  fWhisperScale = 1;
               else
                  fWhisperScale = (fp)(k - WHISPERSTART) / (fp)(WHISPERSTOP-WHISPERSTART);
               fp fWhisperTransfer = fWhisperScale * paTTSGS->fDerWhisper * fVoice;
               fp fVoiceAfter = fOneMinus * fVoice - fWhisperTransfer;
               fVoiceAfter = max(fVoiceAfter, 0);
               fNoise += fWhisperTransfer;

               psr->acVoiceEnergy[k] = AmplitudeToDb (fVoiceAfter);
               psr->acNoiseEnergy[k] = AmplitudeToDb (fNoise);
            } // k
         } // whisper

      } // j, duration of phoneme
   } // i, over phones
#endif


   // if disabling PCM then clear now
   // disable if whispering
   if (fDisablePCM || fWhispering)
      lPSOLASTRUCT.Clear();

   // get the phase as PCM
   fp fPitchScaleToCounteractVoiceMod = m_fAvgPitch / pVoiceMod->pSubVoice->m_fAvgPitch;
   if (lPSOLASTRUCT.Num() || !PhaseDetermine(pWave, fPitchScaleToCounteractVoiceMod, &lWSF))
      lWSF.Clear();
   // lWSF.Clear();  // uncomment to test old BUGBUG


   // FFT this
   PWAVESEGMENTFLOAT pwsfFFT = NULL;
   if (lWSF.Num() && lWSFFFT.Init (sizeof(WAVESEGMENTFLOAT), lWSF.Get(0), lWSF.Num())) {
      CSinLUT SinLUT;
      CMem memFFTScratch;
      pwsfFFT = (PWAVESEGMENTFLOAT) lWSFFFT.Get(0);
      for (i = 0; i < lWSFFFT.Num(); i++)
         FFTRecurseReal (&pwsfFFT[i].afPCM[0] - 1, SRFEATUREPCM, 1, &SinLUT, &memFFTScratch);
   }


   if (pProgress)
      pProgress->Push (0.8, 1.0);
   if (!pVoiceMod->pSubVoice->m_VoiceDisguise.SynthesizeFromSRFeature (iTTSQuality, pWave,
      lPSOLASTRUCT.Num() ? (PPSOLASTRUCT)lPSOLASTRUCT.Get(0) : NULL, lPSOLASTRUCT.Num(), fFormantShift,
      pwsfFFT ? &lWSFFFT : NULL,
      paSDP, !fWhispering, pProgress, FALSE, TRUE, NULL)) {
      if (pProgress)
         pProgress->Pop();
      goto failed;
   }
   if (pProgress)
      pProgress->Pop();

   // As SynthGenFeatures() specifies
   // will need to compress all units
   m_fTTSWaveDisableCompress = FALSE;
   TTSWaveCompress ();

#ifdef _DEBUG
   dwTimeCur = GetTickCount();
   swprintf (szTemp, L"\r\nSynthesizeFromSRFeature = %d ms", (int)(dwTimeCur - dwTimeStart));
   dwTimeStart = dwTimeCur;
   OutputDebugStringW (szTemp);
#endif

   // fill in PCM with original phase, mostly for test
   PhaseWriteToWave (pWave, &lWSF);

   // clear 10% of the units
   DWORD dwToClear = m_dwUnits / 10;
   for (i = 0; i < dwToClear; i++) {
      DWORD dwIndex, dwIndex2;
      dwIndex = rand() % m_dwNumPhone;

      // triphone audio
      PCListFixed pl = m_palPCMTTSTriPhoneAudio ? m_palPCMTTSTriPhoneAudio[dwIndex] : NULL;
      if (pl) {
         dwIndex2 = rand() % pl->Num();
         PCMTTSTriPhoneAudio *pptp = (PCMTTSTriPhoneAudio*)pl->Get(dwIndex2);
         if (pptp)
            pptp[0]->ConnectErrorCacheFree();
      }
   } // i

   // log this
   LogSpoken (pWave);

   // sent the wave up
   BOOL fRet = pProgressWave->TTSWaveData (pWave);
   delete pWave;

   // done
   return fRet;

failed:
   // will need to compress all units
   m_fTTSWaveDisableCompress = FALSE;
   TTSWaveCompress ();
   if (pWave)
      delete pWave;
   return FALSE;
}


/*************************************************************************************
CMTTS::PhaseWriteToWave - Fills int he wave's SRFEATURE PCM with the list of phases.

inputs
   PCM3DWave         pWave - Wave
   PCListFixed       plWSF - List of WAVESEGMENTFLOAT, was filled in by PhaseDetermine()
returns
   BOOL - TRUE if success
*/
BOOL CMTTS::PhaseWriteToWave (PCM3DWave pWave, PCListFixed plWSF)
{
   if (plWSF->Num() != pWave->m_dwSRSamples)
      return FALSE;

   PWAVESEGMENTFLOAT pWSF = (PWAVESEGMENTFLOAT) plWSF->Get(0);
   PSRFEATURE pSRF = pWave->m_paSRFeature;

   DWORD i, j;
   double fMax;
   for (i = 0; i < pWave->m_dwSRSamples; i++, pWSF++, pSRF++) {
      // figure out the maximum
      fMax = 0.0;
      for (j = 0; j < SRFEATUREPCM; j++)
         fMax = max(fabs(pWSF->afPCM[j]), fMax);
      if (fMax >= EPSILON)
         fMax = 1.0 / fMax;

      // normalize and fill in
#ifdef SRFEATUREINCLUDEPCM_SHORT
      fMax *= 32767;
      for (j = 0; j < SRFEATUREPCM; j++)
         pSRF->asPCM[j] = (short)floor(pWSF->afPCM[j] * fMax + 0.5);
      pSRF->fPCMScale = 1.0 / 256.0 / 256.0;
#else
      fMax *= 127;
      for (j = 0; j < SRFEATUREPCM; j++)
         pSRF->acPCM[j] = (char)floor(pWSF->afPCM[j] * fMax + 0.5);
      pSRF->fPCMScale = 1.0 / 256.0;
#endif
      pSRF->bPCMHarmFadeStart = 0;
      pSRF->bPCMHarmFadeFull = 0;
      pSRF->bPCMHarmNyquist = 255;
   } // i

   return TRUE;
}

/*************************************************************************************
CMTTS::PhaseDetermine - Figure out what phases are to be used for each sample.

inputs
   PCM3DWave         pWave - Wave
   fp fPitchScaleToCounteractVoiceMod - Multiplied by pitch that get from wave so can
                     counteract voice modifications
   PCListFixed       plWSF - List of WAVESEGMENTFLOAT that's filled in per SRFEATURE in pWave
returns
   BOOL - TRUE if success
*/

// PDPHONE - information
typedef struct {
   DWORD          dwPhone;    // phoneme
   DWORD          dwStart;    // start feature
} PDPHONE, *PPDPHONE;

BOOL CMTTS::PhaseDetermine (PCM3DWave pWave, fp fPitchScaleToCounteractVoiceMod, PCListFixed plWSF)
{
   plWSF->Init (sizeof(WAVESEGMENTFLOAT));

   if (!m_lPCPhaseModel.Num())
      return FALSE;

   // blank this
   WAVESEGMENTFLOAT wsf;
   memset (&wsf, 0, sizeof(wsf));
   plWSF->Required (pWave->m_dwSRSamples);
   DWORD i;
   for (i = 0; i < pWave->m_dwSRSamples; i++)
      plWSF->Add (&wsf);
   PWAVESEGMENTFLOAT pwsf = (PWAVESEGMENTFLOAT)plWSF->Get(0);

   // do SR
   CSRAnal SRAnal;
   fp fMaxSpeechWindow;
   PSRANALBLOCK pSAB = SRAnal.Init (pWave->m_paSRFeature, pWave->m_dwSRSamples, FALSE, &fMaxSpeechWindow);
   if (!pSAB)
      return FALSE;  // cant analyze

   // keep track of all the phoneme numbers
   PCMLexicon pLex = Lexicon();
   if (!pLex)
      return FALSE;
   BYTE bSilence = (BYTE)pLex->PhonemeFindUnsort(pLex->PhonemeSilence());
   CListFixed lPhonemes;
   PWVPHONEME pwp = (PWVPHONEME)pWave->m_lWVPHONEME.Get(0);
   lPhonemes.Init (sizeof(PDPHONE));
   WCHAR szTemp[sizeof (pwp->awcNameLong)/sizeof(WCHAR)];
   PDPHONE pdp;
   memset (&pdp, 0, sizeof(pdp));
   for (i = 0; i < pWave->m_lWVPHONEME.Num(); i++, pwp++) {
      memset (szTemp, 0, sizeof(szTemp));
      memcpy (szTemp, pwp->awcNameLong, sizeof(pwp->awcNameLong));
      pdp.dwPhone = pLex->PhonemeFindUnsort (szTemp);
      if (pdp.dwPhone == -1)
         pdp.dwPhone = bSilence;
      pdp.dwStart = pwp->dwSample / pWave->m_dwSRSkip;
      pdp.dwStart = min(pdp.dwStart, pWave->m_dwSRSamples);
      lPhonemes.Add (&pdp);
   }
   // final silence
   pdp.dwPhone = bSilence;
   pdp.dwStart = pWave->m_dwSRSamples;
   lPhonemes.Add (&pdp);

   // loop over the phonemes
   DWORD dwPhoneIndex;
   PPDPHONE ppdp = (PPDPHONE) lPhonemes.Get(0);
   PCPhaseModel pPM, pPMLeft, pPMRight, pPMBlend;
   fp fPitch;
   CListFixed lPWAVESEGMENTFLOAT;
   DWORD j;
   for (dwPhoneIndex = 0; dwPhoneIndex+1 < lPhonemes.Num(); dwPhoneIndex++, ppdp++) {
      pPM = PhaseModelGet (ppdp->dwPhone, FALSE);
      if (!pPM)
         continue;

      pPMLeft = dwPhoneIndex ? PhaseModelGet (ppdp[-1].dwPhone, FALSE) : NULL;
      pPMRight = (dwPhoneIndex+1 < lPhonemes.Num()) ? PhaseModelGet (ppdp[1].dwPhone, FALSE) : NULL;
      
      // loop over the samples
      DWORD dwDur = ppdp[1].dwStart - ppdp[0].dwStart;
      DWORD dwHalf = dwDur / 2;
      for (i = ppdp[0].dwStart; i < ppdp[1].dwStart; i++) {
         fPitch = pWave->PitchAtSample (PITCH_F0, i * pWave->m_dwSRSkip, 0) * fPitchScaleToCounteractVoiceMod;
            // need to adjust adverage pitch by voice mods

         // figure out if should blend in L/R phoneme
         DWORD dwOffset = i - ppdp[0].dwStart;
         fp fBlendWeight;
         if (dwOffset < dwHalf)
            pPMBlend = pPMLeft;
         else
            pPMBlend = pPMRight;
         fBlendWeight = 1.0 - (0.5 + cos ( ((fp)dwOffset / (fp)dwDur - 0.5) * PI ) * 0.5);

         // see if previous entry has a phase
         BOOL fPreviousValid = FALSE;
         if (i) for (j = 0; j < SRFEATUREPCM; j++)
            if (pwsf[i-1].afPCM[j]) {
               fPreviousValid = TRUE;
               break;
            }

         pPM->MatchingExampleFind (&pSAB[i].sr, pSAB[i].fEnergyAfterNormal,
            fPitch, m_fAvgPitch,
            pPMBlend, fBlendWeight,
            pwsf + i, fPreviousValid);
      } // i
   } // dwPhoneINdex

   // blur the phase to the left and right just a bit, just to make
   // sure that smooth
   CListFixed lCopy;
   if (!lCopy.Init (sizeof(WAVESEGMENTFLOAT), plWSF->Get(0), plWSF->Num()))
      return FALSE;
   PWAVESEGMENTFLOAT pwsfCopy = (PWAVESEGMENTFLOAT)lCopy.Get(0);
   memset (pwsf, 0, sizeof(WAVESEGMENTFLOAT) * plWSF->Num());
#define PHASEWINDOW     1
   double afPhaseWindowWeight[PHASEWINDOW*2+1];
   DWORD dwSample;
   for (i = 0; i < plWSF->Num(); i++, pwsf++, pwsfCopy++) {
      int iCur, iOffset;
      double fSum = 0;
      for (iOffset = -PHASEWINDOW; iOffset <= PHASEWINDOW; iOffset++) {
         afPhaseWindowWeight[PHASEWINDOW + iOffset] = PHASEWINDOW + 1 - abs(iOffset);
         fSum += afPhaseWindowWeight[PHASEWINDOW + iOffset];
      }
      fSum = 1.0 / fSum;
      for (iOffset = -PHASEWINDOW; iOffset <= PHASEWINDOW; iOffset++)
         afPhaseWindowWeight[PHASEWINDOW + iOffset] *= fSum;

      for (iOffset = -PHASEWINDOW; iOffset <= PHASEWINDOW; iOffset++) {
         iCur = iOffset + (int)i;
         if ((iCur < 0) || (iCur >= (int)plWSF->Num()))
            continue;

         for (dwSample = 0; dwSample < SRFEATUREPCM; dwSample++)
            pwsf->afPCM[dwSample] += pwsfCopy[iOffset].afPCM[dwSample] *
               afPhaseWindowWeight[PHASEWINDOW + iOffset];
      } // iOffset
   } // i

   return TRUE;
}

/*************************************************************************************
TTSWaveToTransPros - Takes a wave file and analyzes it for transplanted prosody.
The output it the transplanted prosody information that can then be passed into
TTS.

inputs
   PCM3DWave         pWave - Wave to analyze. This MUST have pitch, phone, and word
                     segmentation already done.
   PCMLexicon        pLex - Lexicon to use.
   DWORD             dwPitchSamples - Number of pitch values stored per phoneme.
   PCListFixed       plPhone - Will be initalized to sizeof(DWORD), and filled
                     with a list of phonemes (unsorted number). The high byte (<< 24)
                     will be filled with 0 if the phone is in the middle of the word,
                     1 at the start, 2 at the end, 3 is the entire word
   PCListFixed       plWord - Will be initialized to sizeof(PWSTR), and filled with
                     a pointer to the word for each phone. These pointers point
                     directly to pWave's data structures, so don't change pWave
                     after this or pointers will be invalid.
   PCListFixed       plDur - Initialized to sizeof(DWORD) and will be filled with
                     the duration of the phoneme in SRFEATURE units (1/100th of a sec)
   PCListVariable    plPitch - Will be filled with one entry per phoneme. Each one
                     will contain dwPitchSamples fp's for the pitch of the phoneme.
   PCListFixed       plVol - Initialized to sizoef(fp) and filled with one entry
                     per phoneme indicating its volume
   PCListFixed       plPCMTTSTriPhoneAudio - If not NULL, this will be filled in with
                     the triphones selected for each phoneme.
   PCMTTS            pTTS - Needed only of plPCMTTSTriPhoneAudio is requested
returns
   BOOL - TRUE if success
*/
BOOL TTSWaveToTransPros (PCM3DWave pWave, PCMLexicon pLex, DWORD dwPitchSamples,
                         PCListFixed plPhone, PCListFixed plWord, PCListFixed plDur,
                         PCListVariable plPitch, PCListFixed plVol,
                         PCListFixed plPCMTTSTriPhoneAudio, PCMTTS pTTS)
{
   // initialize lists
   plPhone->Init (sizeof(DWORD));
   plWord->Init (sizeof(PWSTR));
   plDur->Init (sizeof(DWORD));
   plPitch->Clear();
   plVol->Init (sizeof(fp));

   // if dont have any sr samples error
   if (!pWave->m_dwSRSamples)
      return FALSE;

   // make sure dont have too many pitch samples that cant calc all
   fp afPitch[8];
   dwPitchSamples = min(dwPitchSamples, sizeof(afPitch)/sizeof(fp));


   // silence
   BYTE bSilence = (BYTE)pLex->PhonemeFindUnsort(pLex->PhonemeSilence());

   // loop through all the phonemes, starting at phoneme -1
   int iPhone;
   DWORD dwNumPhone = pWave->m_lWVPHONEME.Num();
   DWORD j;
   for (iPhone = -1; iPhone < (int)dwNumPhone; iPhone++) {
      // get the phoneme
      PWVPHONEME pwp = (iPhone >= 0) ?
         (PWVPHONEME)pWave->m_lWVPHONEME.Get((DWORD)iPhone) :
         NULL;

      // get the next phoneme
      PWVPHONEME pwp2 = (iPhone+1 < (int)dwNumPhone) ?
         (PWVPHONEME)pWave->m_lWVPHONEME.Get((DWORD)(iPhone+1)) : NULL;

      // figure out the phoneme start and stop
      DWORD dwPhoneStart = pwp ? pwp->dwSample : NULL;
      DWORD dwPhoneEnd = pwp2 ? pwp2->dwSample : pWave->m_dwSamples;

      // if the phoneme end == start (or less than) then skip this phoneme
      if (dwPhoneEnd <= dwPhoneStart)
         continue;

      // figure out the phoneme
      WCHAR szTemp[sizeof (pwp->awcNameLong)/sizeof(WCHAR)];
      memset (szTemp, 0, sizeof(szTemp));
      if (pwp)
         memcpy (szTemp, pwp->awcNameLong, sizeof(pwp->awcNameLong));
      DWORD dwPhone = pLex->PhonemeFindUnsort (szTemp);
      if (dwPhone == -1)
         dwPhone = bSilence;
      dwPhone = (WORD)dwPhone;   // so doesnt interfere
      PLEXPHONE plp = pLex->PhonemeGetUnsort(pTTS ? pTTS->PhonemeBackoff(dwPhone, pLex, bSilence) : dwPhone);
      PLEXENGLISHPHONE pe = NULL;
      if (plp)
         pe = MLexiconEnglishPhoneGet(plp->bEnglishPhone);

      // figure out what word it's in...
      PWSTR pszWord = NULL;
      for (j = 0; j < pWave->m_lWVWORD.Num(); j++) {
         PWVWORD pw = (PWVWORD)pWave->m_lWVWORD.Get(j);
         PWVWORD pw2 = (PWVWORD)pWave->m_lWVWORD.Get(j+1);

         DWORD dwWordStart = pw ? pw->dwSample : 0;
         DWORD dwWordEnd = pw2 ? pw2->dwSample : pWave->m_dwSamples;

         if (dwWordEnd <= dwPhoneStart)
            continue;   // not in this word
         else if (dwWordStart >= dwPhoneEnd)
            break;   // went to far

         // else in this word
         pszWord = (PWSTR)(pw+1);
         if (dwWordStart == dwPhoneStart)
            dwPhone |= (1 << 24);   // start of word
         if (dwWordEnd == dwPhoneEnd)
            dwPhone |= (2 << 24);   // end of word
         break;
      } // j

      // calculate the pitch...
      // BUGFIX - Dont calculate pitch on unvoiced phones
      DWORD dwNumPitch = 0;
      if (((BYTE)dwPhone != bSilence) && pe && (pe->dwCategory & PIC_VOICED)) {
         dwNumPitch = dwPitchSamples;
         for (j = 0; j < dwNumPitch; j++)
            afPitch[j] = pWave->PitchAtSample (PITCH_F0, 
               (fp)dwPhoneStart + (fp)(j+1) / (fp)(dwNumPitch+1) * (fp)(dwPhoneEnd - dwPhoneStart),
               0);
      }

      // waht's the volume
      fp fVol = pWave->CalcSREnergyRange (FALSE, dwPhoneStart, dwPhoneEnd);

      // what's the duration in terms of sr units...
      dwPhoneStart = (dwPhoneStart + pWave->m_dwSRSkip/2) / pWave->m_dwSRSkip;
      dwPhoneEnd = (dwPhoneEnd + pWave->m_dwSRSkip/2) / pWave->m_dwSRSkip;
      if (dwPhoneEnd <= dwPhoneStart)
         continue;
      dwPhoneEnd -= dwPhoneStart;

      // add info..
      plPhone->Add (&dwPhone);
      plWord->Add (&pszWord);
      plDur->Add (&dwPhoneEnd);
      plPitch->Add (afPitch, dwNumPitch * sizeof(fp));
      plVol->Add (&fVol);
   } // over iPhone

   // triphones
   if (plPCMTTSTriPhoneAudio) {
      plPCMTTSTriPhoneAudio->Init (sizeof(PCMTTSTriPhoneAudio));

      // find out the words as appear in tts
      CListFixed lWord2;
      lWord2.Init (sizeof(DWORD));
      DWORD i;
      PWSTR *ppsz = (PWSTR*)plWord->Get(0);
      DWORD *padwPhone = (DWORD*)plPhone->Get(0);
      DWORD dwNum = plPhone->Num();
      lWord2.Required (dwNum);
      for (i = 0; i < dwNum; i++) {
         DWORD dwWord = -1;
         if (ppsz[i])
            dwWord = pTTS->LexWordsGet()->WordFind (ppsz[i]);
         lWord2.Add (&dwWord);
      } // i
      DWORD *padwWord2 = (DWORD*)lWord2.Get(0);
      fp fBestScore;
      pTTS->SynthDetermineTriPhoneAudio (pTTS->AvgPitchGet(), padwPhone, padwWord2,
         (DWORD*)plDur->Get(0), (fp*)plVol->Get(0), TRUE, plPitch, dwNum, 1 /*iTTSQuality*/,
         FALSE /*fDisablePCM*/, plPCMTTSTriPhoneAudio, &fBestScore, NULL);
      if (plPCMTTSTriPhoneAudio->Num() != dwNum * TTSDEMIPHONES)
         return 0;
   } // if triphones
   // done
   return TRUE;
}


/*************************************************************************************
CMTTS::CalcWordsPerMinute - Calculates the average words per minute given all the
phoneme units.

returns
   DWORD - Guetimated words per minute
*/
DWORD CMTTS::CalcWordsPerMinute (void)
{
   __int64 iSum = 0;
   int iCount = 0;

   DWORD i, j;
   for (i = 0; i < m_dwNumPhone; i++) {
      PCListFixed pl = m_palPCMTTSTriPhonePros[i];
      if (!pl)
         continue;

      PCMTTSTriPhonePros *pptp = (PCMTTSTriPhonePros*) pl->Get(0);
      for (j = 0; j < pl->Num(); j++) {
         iSum += (__int64)pptp[j]->m_wDuration;
         iCount++;
      }
   } // i

   if (!iCount)
      return 0;

   double fDur;
   fDur = (double)iSum / (double)iCount / (double)SRSAMPLESPERSEC;   // average sec per unit
   fDur /= 60.0;  // so know in terms of minutes
   fDur *= 5;  // so know minutes per word, assuming word=5 phonemes
   fDur = 1.0 / fDur;   // so know words per minte
   return (DWORD)fDur;
}



/*************************************************************************************
TTSFileOpenDialog - Dialog box for opening a CTTS

inputs
   HWND           hWnd - To display dialog off of
   PWSTR          pszFile - Pointer to a file name. Must be filled with initial file
   DWORD          dwChars - Number of characters in the file
   BOOL           fSave - If TRUE then saving instead of openeing. if fSave then
                     pszFile contains an initial file name, or empty string
returns
   BOOL - TRUE if pszFile filled in, FALSE if nothing opened
*/
BOOL TTSFileOpenDialog (HWND hWnd, PWSTR pszFile, DWORD dwChars, BOOL fSave)
{
   OPENFILENAME   ofn;
   char  szTemp[256];
   szTemp[0] = 0;
   WideCharToMultiByte (CP_ACP, 0, pszFile, -1, szTemp, sizeof(szTemp), 0, 0);
   memset (&ofn, 0, sizeof(ofn));
   
   // BUGFIX - Set directory
   char szInitial[256];
   strcpy (szInitial, gszAppDir);
   GetLastDirectory(szInitial, sizeof(szInitial)); // BUGFIX - get last dir
   ofn.lpstrInitialDir = szInitial;

   ofn.lStructSize = sizeof(ofn);
   ofn.hwndOwner = hWnd;
   ofn.hInstance = ghInstance;
   ofn.lpstrFilter = "TTS Voice (*.tts)\0*.tts\0\0\0";
   ofn.lpstrFile = szTemp;
   ofn.nMaxFile = sizeof(szTemp);
   ofn.lpstrTitle = fSave ? "Save the TTS Voice" :
      "Open TTS Voice";
   ofn.Flags = fSave ? (OFN_PATHMUSTEXIST | OFN_HIDEREADONLY) :
      (OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY);
   ofn.lpstrDefExt = "tts";
   // nFileExtension 

   if (fSave) {
      if (!GetSaveFileName(&ofn))
         return FALSE;
   }
   else {
      if (!GetOpenFileName(&ofn))
         return FALSE;
   }

   // BUGFIX - Save diretory
   strcpy (szInitial, ofn.lpstrFile);
   szInitial[ofn.nFileOffset] = 0;
   SetLastDirectory(szInitial);

   // copy over
   MultiByteToWideChar (CP_ACP, 0, ofn.lpstrFile, -1, pszFile, dwChars);
   return TRUE;
}


/*************************************************************************************
TTSProsodyFileOpenDialog - Dialog box for opening a CTTSProsody

inputs
   HWND           hWnd - To display dialog off of
   PWSTR          pszFile - Pointer to a file name. Must be filled with initial file
   DWORD          dwChars - Number of characters in the file
   BOOL           fSave - If TRUE then saving instead of openeing. if fSave then
                     pszFile contains an initial file name, or empty string
   BOOL           fIncludeTTS - If TRUE, then also allow for TTS voices, in addition to the
                     TTS prosody.
returns
   BOOL - TRUE if pszFile filled in, FALSE if nothing opened
*/
BOOL TTSProsodyFileOpenDialog (HWND hWnd, PWSTR pszFile, DWORD dwChars, BOOL fSave, BOOL fIncludeTTS)
{
   OPENFILENAME   ofn;
   char  szTemp[256];
   szTemp[0] = 0;
   WideCharToMultiByte (CP_ACP, 0, pszFile, -1, szTemp, sizeof(szTemp), 0, 0);
   memset (&ofn, 0, sizeof(ofn));
   
   // BUGFIX - Set directory
   char szInitial[256];
   strcpy (szInitial, gszAppDir);
   GetLastDirectory(szInitial, sizeof(szInitial)); // BUGFIX - get last dir
   ofn.lpstrInitialDir = szInitial;

   ofn.lStructSize = sizeof(ofn);
   ofn.hwndOwner = hWnd;
   ofn.hInstance = ghInstance;
   ofn.lpstrFilter = (!fIncludeTTS) ?
      "TTS Prosody (*.mpm)\0*.mpm\0\0\0" :
      "All\0*.mpm;*.tts\0TTS Prosody (*.mpm)\0*.mpm\0TTS Voice (*.tts)\0*.tts\0\0\0";
   ofn.lpstrFile = szTemp;
   ofn.nMaxFile = sizeof(szTemp);
   ofn.lpstrTitle = fSave ? "Save the TTS Prosody Model" :
      "Open TTS Prosody Model";
   ofn.Flags = fSave ? (OFN_PATHMUSTEXIST | OFN_HIDEREADONLY) :
      (OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY);
   ofn.lpstrDefExt = "mpm";
   // nFileExtension 

   if (fSave) {
      if (!GetSaveFileName(&ofn))
         return FALSE;
   }
   else {
      if (!GetOpenFileName(&ofn))
         return FALSE;
   }

   // BUGFIX - Save diretory
   strcpy (szInitial, ofn.lpstrFile);
   szInitial[ofn.nFileOffset] = 0;
   SetLastDirectory(szInitial);

   // copy over
   MultiByteToWideChar (CP_ACP, 0, ofn.lpstrFile, -1, pszFile, dwChars);
   return TRUE;
}

#if 0 // dead code - dont use splines anymore since cause to overshoot mark by large amounts
/*************************************************************************************
SplineValue - This takes a list containing an array of TEXTUREPOINT. .h is the
time, and .v is the value. Then, given a time, this returns the value.

inputs
   PCListFixed       plCurve - Curve to look at
   fp                fTime - Time looking for
returns
   fp - Value at the time
*/
static fp SplineValue (PCListFixed plCurve, fp fTime)
{
   PTEXTUREPOINT ptp = (PTEXTUREPOINT) plCurve->Get(0);
   DWORD dwNumCurve = plCurve->Num();

   if (!dwNumCurve)
      return 0;

   // if less than first location then done
   if (fTime <= ptp[0].h)
      return ptp[0].v;

   // of if greater than max time then done
   if (fTime >= ptp[dwNumCurve-1].h)
      return ptp[dwNumCurve-1].v;

   // find location
   DWORD i;
   for (i = 0; i+1 < dwNumCurve; i++)
      if ((fTime >= ptp[i].h) && (fTime <= ptp[i+1].h))
         break;

   if (i+1 >= dwNumCurve)
      return ptp[dwNumCurve-1].v;

   fp t, f1, f2, f3, f4;
   t = (fTime - ptp[i].h) / (ptp[i+1].h - ptp[i].h);

   f1 = i ? ptp[i-1].v : ptp[i].v;
   f2 = ptp[i].v;
   f3 = ptp[i+1].v;
   f4 = (i+2 < dwNumCurve) ? ptp[i+2].v : ptp[i+1].v;

   return HermiteCubic (t, f1, f2, f3, f4);
}
#endif // 0


/*************************************************************************************
CMTTS::TriPhoneEnergy - Calculates the average energy for a triphone. This is useful
for calculating absolute energy.

NOTE: The data MUST be DECOMPRESSEd already

inputs
   PCMTTSTriPhoneAudio       ptr - Triphone. This can be NULL
   DWORD                *pdwCount - If not NULL, this will be filled in with the number of SRFEATUREs
                        typically in the triphone
returns
   fp - Energy. Average SRFEATUREEnergy() per sample.
*/
fp CMTTS::TriPhoneEnergy (PCMTTSTriPhoneAudio pti, DWORD *pdwCount)
{
   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster)
         return FALSE;
      return m_pTTSMaster->TriPhoneEnergy (pti, pdwCount);
   }

   if (pdwCount)
      *pdwCount = 0;
   if (!pti || !(pti->m_dwFeatureEnd - pti->m_dwFeatureStart))  // BUGFIX - Added check for pti->m_pmemSRFEATURE
      return 0;

   fp fSum = 0;
   //if (!pti->Decompress()) // decompress larger
   //   return 0;
   PCTTSWave pTW = TTSFindWave (pti->m_wOrigWave);
   if (!pTW)
      return 0;
   PSRFEATURE psr = pTW->GetSRFEATURE (&m_acsTTSWave[pti->m_wOrigWave % MAXRAYTHREAD], pti->m_dwFeatureStart, pti->m_dwFeatureEnd);
   if (!psr)
      return 0;
   DWORD i;
   for (i = 0; i < (pti->m_dwFeatureEnd - pti->m_dwFeatureStart); i++, psr++) {
      fSum += SRFEATUREEnergy(FALSE, psr, FALSE);
   } // i
   //pti->Compress();  // compress back smaller
   if (pti->m_dwFeatureEnd - pti->m_dwFeatureStart)
      fSum /= (fp)(pti->m_dwFeatureEnd - pti->m_dwFeatureStart);

   // BUGFIX - Scale by m_iFeatureAdd
   fSum *= (fp)DbToAmplitude(pti->m_iFeatureAdd) / (fp)DbToAmplitude(0);

   // BUGFIX - If completely silent phone then white noise
   fSum = max(fSum, CLOSE);

   if (pdwCount)
      *pdwCount = pti->m_dwFeatureEnd - pti->m_dwFeatureStart;
   return fSum;
}

/*************************************************************************************
CMTTS::SynthArtificialProsody - Use this to generate the artifical prosody for
a sentence (or more) given the phonemes.

inputs
   DWORD       *padwPhone - Pointer to an array of phonemes. Each phoneme is the
               unsorted phone number. The high byte (<< 24) contains 0 if the phone
               is in the middle of a word, 1 on left side, 2 on right side, 3 word by itself
   PWSTR       *paszWord - Word string associated with each phoneme, or NULL if none associated.
               If two or more phonemes are from the same word they should point to
               the same word string.
   PCMMLNode2   *papMMLWord - Pointer to array of dwNum entries pointing back to the
               original word information. If this has prosody info then the
               prosody info is extracted and used. Prosody information would
               have been written by SynthProsodyTagsApply()
   PCPoint     paPhoneMod - Modifications to [0]=pitch, [1]=vol, [2]=dur for each
               phoneme. If NULL then don't modify
   PTTSGLOBALSTATE paTTSGLOBALSTATE - Pointer to an array of dwNum TTSGLOBALSTATE structures
               contaiining the global state information.
   DWORD       dwNum - Number of phonemes
   PCListFixed plDur - Will be initialized to sizeof(DWORD) and filled with dwNum entries
               for the duration in SRFEATURE time units (1/100th of a sec)
   PCListVariable plPitch - Will be initialized and filled with the frequency of
               each phoneme, in hz. Each element is N * sizeof(fp),
               where N is from 0 to whatever. It indicates the number of pitch points
               stored per phoneme.
   PCListFixed plVol - Will be initialized to sizeof (fp) and filled with relative volume,
               where 1.0 is no change, etc.
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
   BOOL        fDisablePCM - Set to TRUE if PSOLA temporarily disabled
   BOOL        *pfAbsPitch - Filled with TRUE if absolute pitch is requested, FALSE if
                  relative. Usually filled with FALSE
returns
   BOOL - TRUE if success
*/
#define MAXTPPITCH      5     // max control points that can have for tp
// PSTRESS - Used to calculate which side of phone stress occurs
typedef struct {
   PCMTTSTriPhonePros      ptp;     // triphone, for prosody
   fp                   fPitch;  // pitch points for triphone
   fp                   fPitchLeft; // pitch on left side
   fp                   fPitchRight; // pitch on right side
   fp                   fPitchCenter; // pitch in center
   BOOL                 fVoiced; // true if voiced
   BOOL                 fVowel;  // true is vowel
   WORD                 wStressImportance; // amount of stress, 0=none, 1=SECONDARY,2=PRIMARY,
   WORD                 wFill;   // nothing
   DWORD                dwPhone; // phoneme, including flags for start/end of word
} PSTRESS, *PPSTRESS;

#define VOWELONLY       // turn on so applies pitch to vowels only
   // BUGFIX - Put the vowel only back in since seems just a hair better than no vowel-only
   // and it makes more sense since vowels are pitch targets

BOOL CMTTS::SynthArtificialProsody (DWORD *padwPhone, PWSTR *paszWord, PCMMLNode2 *papMMLWord,
                                    PCPoint paPhoneMod,
                                    PTTSGLOBALSTATE paTTSGLOBALSTATE, DWORD dwNum,
                           PCListFixed plDur, PCListVariable plPitch, PCListFixed plVol,
                           PTTSVOICEMOD pVoiceMod, BOOL fDisablePCM, BOOL *pfAbsPitch)
{
   if (pfAbsPitch)
      *pfAbsPitch = FALSE;

   PCMLexicon pLex = pVoiceMod->pLex;
   if (!pLex)
      pLex = Lexicon();
   if (!pLex)
      return FALSE;

   plDur->Init (sizeof(DWORD));
   plPitch->Clear();
   plVol->Init (sizeof(fp));

   CListFixed lStressAll;  // list of variable stress over all words
   lStressAll.Init (sizeof(PSTRESS));

   // list of original durations so can calculate how fast should be
   CListFixed lDurOrig;
   lDurOrig.Init (sizeof(DWORD));

   // figure out the words
   CListFixed lWords;
   lWords.Init (sizeof(DWORD));
   DWORD i;
   lWords.Required (dwNum);
   for (i = 0; i < dwNum; i++) {
      DWORD dwFind = paszWord[i] ? m_pLexWords->WordFind (paszWord[i]) : -1;
      lWords.Add (&dwFind);
   }
   DWORD *padwWords = (DWORD*)lWords.Get(0);

   // determine the triphones
   CListFixed lTriPhone;
   if (!SynthDetermineTriPhonePros (padwPhone, dwNum, &lTriPhone))
      return FALSE;
   PCMTTSTriPhonePros *pptp = (PCMTTSTriPhonePros*)lTriPhone.Get(0);

   // snap to duration
   //fp fUnits = max(m_dwUnits,1);
   //fUnits = log(fUnits) - log(10000.0);   // so if 10,000 units then 0.0
   //fUnits /= (log(100000.0) - log(10000.0)); // so if 100,0000 units, then 1.0
   //fUnits = max(fUnits, 0.0); // limit
   //fUnits = min(fUnits, 1.0); // limit
   int iSnapToDuration = 0;   // 0 => a blend, 1 = always use the original, -1 = always used asked-for (synthesized) duration
   //fp fSnapToDuration = (1.0 - fUnits) * SNAPTODURATION_10000 + fUnits * SNAPTODURATION_100000;
   BOOL fFullPCM = fDisablePCM ? FALSE : m_fFullPCM;

#ifdef NOMODS_DISABLEPCM
   fFullPCM = FALSE;
#endif
#ifdef NOMODS_SNAPTODURATION
   iSnapToDuration = -1;
#endif

   // create one entry per phoneme using defaults
   DWORD dwWordStart, dwWordEnd;
   CListFixed lStress;
   lStress.Init (sizeof(PSTRESS));
   fp fAvgVowelPitch;
   DWORD dwVowelPitchCount;
   CListFixed lCSVPitch;      // pitch derived from CSV
   CListFixed lCSVDur;        // duration derived from CSV
   CListFixed lCSVVol;        // volume derived from CSV
   BYTE bSilence = (BYTE)pLex->PhonemeFindUnsort(pLex->PhonemeSilence());
   for (dwWordStart = 0; dwWordStart < dwNum; dwWordStart = dwWordEnd) {
      // reset detection of min/max pitch
      fAvgVowelPitch  = 0;
      dwVowelPitchCount = 0;

      // figure out end of word
      lStress.Clear();
      for (dwWordEnd = dwWordStart; dwWordEnd < dwNum; dwWordEnd++) {
         if (paszWord[dwWordEnd] != paszWord[dwWordStart])
            break;

         // keep track of stress info
         PSTRESS pt;
         memset (&pt, 0, sizeof(pt));
         pt.dwPhone = padwPhone[dwWordEnd];
         pt.ptp = pptp[dwWordEnd];
         PLEXPHONE plp = pt.ptp ? pLex->PhonemeGetUnsort (PhonemeBackoff((WORD)padwPhone[dwWordEnd], pLex, bSilence)) : NULL;
         PLEXENGLISHPHONE ple = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;

         if (ple) {
            pt.fVoiced = (ple->dwCategory & PIC_VOICED) ? TRUE : FALSE;
            pt.fVowel = ((ple->dwCategory & PIC_MAJORTYPE) == PIC_VOWEL);

            // if chinese then special case
            if (pLex->ChineseUse())
               pt.wStressImportance = pt.fVowel ? 2 : 0;
            else switch (plp->bStress) {  // for english
               default:
               case 0:
               //case 3:  // for chinese, shouldnt happen
               //case 4:  // for chinese, shouldnt happen
               //case 5:  // for chinese, shouldnt happen
                  pt.wStressImportance = 0;
                  break;
               case 1:
                  pt.wStressImportance = 2;
                  break;
               case 2:
                  pt.wStressImportance = 1;
                  break;
            }
         } // if ple

         short iPhonePitch = pt.ptp ? pt.ptp->m_iPitch : 0;
         short iPhonePitchDelta = pt.ptp ? pt.ptp->m_iPitchDelta : 0;
         short iPhonePitchBulge = pt.ptp ? pt.ptp->m_iPitchBulge : 0;

#ifdef NOMODS_DISABLETRIPHONEPITCH
         iPhonePitch = iPhonePitchDelta = iPhonePitchBulge = 0;
#endif

         // store pitch
         fp fPitchDelta, fPitchBulge;
         if (pt.fVoiced && pt.fVowel)  // BUGFIX - Only pitch on vowel so do chinese
            pt.fPitch = pow (2.0,
               pVoiceMod->pSubVoice->m_fPhonePitchAccentuate * (fp)iPhonePitch / 1000.0); // keep this relative
         else
            pt.fPitch = 1;

         // BUGFIX - Only pitch on vowel so do chinese
         fPitchDelta = (pt.fVoiced && pt.fVowel) ? sqrt(pow(2.0,
            pVoiceMod->pSubVoice->m_fPhoneRiseAccentuate * (fp)iPhonePitchDelta/ 1000.0)) : 1;
         fPitchBulge = (pt.fVoiced && pt.fVowel) ? pow(2.0,
            pVoiceMod->pSubVoice->m_fPhoneRiseAccentuate * (fp)iPhonePitchBulge/ 1000.0) : 1;

         pt.fPitchLeft = pt.fPitch / fPitchDelta / fPitchBulge;
         pt.fPitchRight = pt.fPitch * fPitchDelta / fPitchBulge;
            // NOTE: Dividing left/rigth by bulge so that phone will average the same
         pt.fPitchCenter = pt.fPitch * fPitchBulge;

#if 0 // disable so that chinese can include phonemes that are higher in pitch
         // keep track of max and min stress odunf
#ifdef VOWELONLY
         if (pt.fVoiced && pt.fVowel) {
#else
         if (pt.fVoiced) { // BUGFIX: include non-vowels too - either && pt.fVowel) {
#endif
            fAvgVowelPitch += pt.fPitch;
            dwVowelPitchCount++;
         }
#endif // 0

         // NOTE: Move the pitch adjustment until AFTER the calulation over average vowel pitch
#ifndef NOMODS_DISABLEPHONEMOD
         if (paPhoneMod) {
            pt.fPitch *= paPhoneMod[dwWordEnd].p[0];
            pt.fPitchLeft *= paPhoneMod[dwWordEnd].p[0];
            pt.fPitchRight *= paPhoneMod[dwWordEnd].p[0];
            pt.fPitchCenter *= paPhoneMod[dwWordEnd].p[0];
         }
#endif

         lStress.Add (&pt);
      } // dwWordEnd
      PPSTRESS pps = (PPSTRESS) lStress.Get(0);

      // see if can get CSV pitch for transplanted prosody
      DWORD dwPitchType = 0;
      DWORD dwDurType = 0;
      DWORD dwVolType = 0;
      DWORD j;
      fp *pafTPPitch, *pafTPDur, *pafTPVol;
      PWSTR psz = NULL;
      pafTPPitch = NULL;
      pafTPDur = NULL;
      pafTPVol = NULL;
      if (papMMLWord[dwWordStart]) {
         // try for relative pitch
         psz = papMMLWord[dwWordStart]->AttribGetString (gpszTPPitchRel);
         if (psz) {
            CSVParse (psz, &lCSVPitch);
            dwPitchType = 1;
            pafTPPitch = (fp*) lCSVPitch.Get(0);
            for (j = 0; j < lCSVPitch.Num(); j++)
               if (pafTPPitch[j] != -1234) {
                  if (paTTSGLOBALSTATE[dwWordStart].fDerPitchExpress != 1.0)
                     pafTPPitch[j] = pow(pafTPPitch[j], paTTSGLOBALSTATE[dwWordStart].fDerPitchExpress);

                  pafTPPitch[j] *= paTTSGLOBALSTATE[dwWordStart].fDerAvgPitch;
               }
         }

         // try for absolute pitch
         psz = papMMLWord[dwWordStart]->AttribGetString (gpszTPPitchAbs);
         if (psz) {
            CSVParse (psz, &lCSVPitch);
            dwPitchType = 2;
            pafTPPitch = (fp*) lCSVPitch.Get(0);

            // since requested absolute pitch for transpros, note this
            if (pfAbsPitch)
               *pfAbsPitch = TRUE;
         }

         // try for relative duration
         psz = papMMLWord[dwWordStart]->AttribGetString (gpszTPDurRel);
         if (psz) {
            CSVParse (psz, &lCSVDur);
            dwDurType = 1;
            pafTPDur = (fp*) lCSVDur.Get(0);
         }
         psz = papMMLWord[dwWordStart]->AttribGetString (gpszTPDurAbs);
         if (psz) {
            CSVParse (psz, &lCSVDur);
            dwDurType = 2;
            pafTPDur = (fp*) lCSVDur.Get(0);
         }
         if (lCSVDur.Num() < lStress.Num())
            pafTPDur = NULL;  // since not enough

         // also go for volume
         psz = papMMLWord[dwWordStart]->AttribGetString (gpszTPVolRel);
         if (psz) {
            CSVParse (psz, &lCSVVol);
            dwVolType = 1;
            pafTPVol = (fp*) lCSVVol.Get(0);
         }
         psz = papMMLWord[dwWordStart]->AttribGetString (gpszTPVolAbs);
         if (psz) {
            CSVParse (psz, &lCSVVol);
            dwVolType = 2;
            pafTPVol = (fp*) lCSVVol.Get(0);
         }
         if (lCSVVol.Num() < lStress.Num())
            pafTPVol = NULL;  // since not enough
      }

      // calculate the number of pitch points per phoneme
      DWORD dwTPPitchPerPhone;
      dwTPPitchPerPhone = 0;
      if (pafTPPitch && lStress.Num())
         dwTPPitchPerPhone = lCSVPitch.Num() / lStress.Num();

      // BUGFIX - loop over and hack the stress...
      if (dwVowelPitchCount)
         fAvgVowelPitch /= (fp) dwVowelPitchCount;
      else
         fAvgVowelPitch = 1;

      for (i = 0; i < lStress.Num(); i++) {
         pps[i].fPitch /= fAvgVowelPitch; // normalize pitch
         pps[i].fPitchLeft /= fAvgVowelPitch; // normalize pitch
         pps[i].fPitchRight /= fAvgVowelPitch; // normalize pitch
         pps[i].fPitchCenter /= fAvgVowelPitch; // normalize pitch
      }

#ifdef VOWELONLY // BUGFIX - doesnt reproduce the fact that pitch changes for non-vowels too
      // loop back over and modify the pitch of non-vowels to the closest vowel
      for (i = 0; i < lStress.Num(); i++) {
         if (!pps[i].fVoiced)
            continue;   // dont care
         if (pps[i].fVowel)
            continue;   // already know

         // look left/right
         int iLeft, iRight, iScoreLeft, iScoreRight;
         WORD wStressLeft, wStressRight;
         for (iLeft = (int)i-1; iLeft >= 0; iLeft--)
            if (pps[iLeft].fVowel && pps[iLeft].fVoiced)
               break;
         for (iRight = (int)i+1; iRight < (int)lStress.Num(); iRight++)
            if (pps[iRight].fVowel && pps[iRight].fVoiced)
               break;
         wStressLeft = wStressRight = 0;
         if (iLeft >= 0) {
            iScoreLeft = -((int)i - iLeft); // distance away
            wStressLeft = pps[iLeft].wStressImportance;
         }
         else
            iScoreLeft = -10000; // so dont choose
         if (iRight < (int)lStress.Num()) {
            iScoreRight = -(iRight - (int)i); // distance away
            wStressRight = pps[iRight].wStressImportance;
         }
         else
            iScoreRight = -10000; // so dont choose

         // choose the closest vowel for the pitch. If there are two close
         // vowels the choose the stressed one
         if (iScoreLeft > iScoreRight)
            pps[i].fPitch = pps[iLeft].fPitchRight;
         else if (iScoreRight > iScoreLeft)
            pps[i].fPitch = pps[iRight].fPitchLeft;
         else if (wStressLeft > wStressRight)
            pps[i].fPitch = pps[iLeft].fPitchRight;
         else if (wStressRight > wStressLeft)
            pps[i].fPitch = pps[iRight].fPitchLeft;
         else if (iScoreLeft == -10000)
            pps[i].fPitch = 1;   // since dont know
         else
            pps[i].fPitch = pps[iLeft].fPitchRight;  // cant decide so take left
         // NOTE: No doing anything with fPitchCenter (from pitchbulge)... but dont think I need to
      } // i
#endif // 0

      lStressAll.Required (lStressAll.Num() + lStress.Num());
      for (i = 0; i < lStress.Num(); i++) {
         lStressAll.Add (pps + i);

         PCMTTSTriPhonePros ptp = pps[i].ptp;
         DWORD dwDur, dwNumPitch;
         fp afPitch[3], fVol;
         if (!ptp) {
            PCMMLNode2 pThis = papMMLWord[i+dwWordStart];

            // silence
            dwDur = SRSAMPLESPERSEC / 8;  // default silence for comma
               // BUGFIX - Make comma 1/8 second from 1/4, which increases speed of period
            if (!paszWord[i+dwWordStart])
               dwDur = SRSAMPLESPERSEC / 25; // micropause
                  // BUGFIX - FAster, was 1/16th second
            else if ( ((paszWord[i+dwWordStart])[0] == L'.') ||
               ((paszWord[i+dwWordStart])[0] == L'?') || ((paszWord[i+dwWordStart])[0] == L'?') ||
               ((paszWord[i+dwWordStart])[0] == L';') )
               dwDur *= 2;
               // BUGFIX - Increased the durations for pauses.

            // scale duration by speaking rate
            dwDur = (DWORD)((fp)dwDur / paTTSGLOBALSTATE[i+dwWordStart].fDerWPM * (fp)m_dwWordsPerMinute + 0.5);
            dwDur = max(dwDur, 1);

            // if we have a tag then use that to determine the break
            PWSTR pszDur = NULL;
            if (pThis)
               pszDur = pThis->AttribGetString (gpszDurAbs);
            if (pszDur) {
               fp fDur = _wtof(pszDur);
               if (fDur > 0) {
                  dwDur = (DWORD)(fDur * SRSAMPLESPERSEC);
                  dwDur = max(dwDur, 1);
               }
            }

            // if we have a break then get duration from that
            pszDur = NULL;
            if (pThis)
               pszDur = pThis->NameGet();
            if (pszDur && !_wcsicmp(pszDur, gpszBreak)) {
               pszDur = pThis->AttribGetString(gpszTime);
               if (!pszDur)
                  dwDur = SRSAMPLESPERSEC / 2;
               else if (!_wcsicmp(pszDur, L"x-small"))
                  dwDur = SRSAMPLESPERSEC / 8;
               else if (!_wcsicmp(pszDur, L"small"))
                  dwDur = SRSAMPLESPERSEC / 4;
               else if (!_wcsicmp(pszDur, L"medium"))
                  dwDur = SRSAMPLESPERSEC / 2;
               else if (!_wcsicmp(pszDur, L"large"))
                  dwDur = SRSAMPLESPERSEC;
               else if (!_wcsicmp(pszDur, L"x-large"))
                  dwDur = SRSAMPLESPERSEC * 2;
               else {
                  DWORD dwLen = (DWORD)wcslen(pszDur);
                  fp fDur = _wtof(pszDur);
                  if ((dwLen > 2) &&
                     ((pszDur[dwLen-2] == L'm') || (pszDur[dwLen-2] == L'M')) &&
                     ((pszDur[dwLen-1] == L's') || (pszDur[dwLen-1] == L'S')))
                     fDur /= 1000.0;
                  if (fDur < 0)
                     fDur = .025;   // something

                  dwDur = (DWORD)(fDur * SRSAMPLESPERSEC);
                  dwDur = max(dwDur, 1);
               }
            }

            afPitch[0] = 0;
            fVol = 0;
            plDur->Add (&dwDur);
            lDurOrig.Add (&dwDur);
            plPitch->Add (afPitch, 0);    // 0 sized so pitch isn't fixed
            plVol->Add (&fVol);
            continue;
         }

         // else phoneme

         // decompress
         // BUGFIX - Removed ptp->Decompress();

         // figure out how much duration is modified by prosody hacks
         fp fDurDerive = 1;
         pVoiceMod->pSubVoice->m_fDurWordEnd = max(pVoiceMod->pSubVoice->m_fDurWordEnd, .01);
         pVoiceMod->pSubVoice->m_fDurWordStart = max(pVoiceMod->pSubVoice->m_fDurWordStart, .01);
         if ((pps[i].dwPhone & (1 << 24)) && (pps[i].dwPhone & (2 << 24)))
            fDurDerive = sqrt(pVoiceMod->pSubVoice->m_fDurWordEnd * pVoiceMod->pSubVoice->m_fDurWordStart);
         else if (pps[i].dwPhone & (1 << 24))
            fDurDerive = pVoiceMod->pSubVoice->m_fDurWordStart;
         else if (pps[i].dwPhone & (2 << 24))
            fDurDerive = pVoiceMod->pSubVoice->m_fDurWordEnd;

         if (paPhoneMod)
            fDurDerive *= paPhoneMod[i+dwWordStart].p[2];

         if ((DWORD)(BYTE)pps[i].dwPhone < pVoiceMod->pSubVoice->m_lDurPerPhone.Num()) {
            float f = *((float*)pVoiceMod->pSubVoice->m_lDurPerPhone.Get((BYTE)pps[i].dwPhone));
            f = max(f, .01);
            fDurDerive *= f;
         }

         // calculate the original duration, disregarding transplanted prosody and WPM
         dwDur = (DWORD)((fp)ptp->m_wDuration * fDurDerive + 0.5);
         lDurOrig.Add (&dwDur);

         // duration
         int iSnapToDurationThis = iSnapToDuration;
         fp fDur;
         BOOL fDurTP = FALSE;

         if (!pafTPDur) {
            // use original duration, scaled by WPM
            fDur = (fp)ptp->m_wDuration * fDurDerive;
            // BUGFIX - Not applying WPM here. Doing so below so that longer speech
            // will extend vowels, not everything

            //dwDur = (DWORD)((fp)ptp->m_wDuration / paTTSGLOBALSTATE[i+dwWordStart].fDerWPM
            //   * (fp)m_dwWordsPerMinute * fDurDerive + 0.5);
         }
         else if (dwDurType == 2) {
            // it's TP using absolute duration
            // BUGFIX - If absolute duration but has a global state of faster then do
            fDur = pafTPDur[i] * SRSAMPLESPERSEC;

            // NOTE: Don't need to affect snap to duration is TP absolute duration is somewhat flexible
            // iSnapToDurationThis = -1;   // fixed duration TP doesn't snap to

            // take into account speaking speed
            fDur = fDur / paTTSGLOBALSTATE[i+dwWordStart].fDerWPM
               * (fp)m_dwWordsPerMinute;
               // NOTE - On absolute duration NOT being affected by global state

            // NOTE: This causes transpros absolute duration to be somewhat flexible

            // NOTE: Not sure where to put the averaging so that when global speed-up or slow-down
            // occurs affects transpros correctly

            // BUGFIX - Make transplanted prosody absolte duration be a combination
            // of the requested duration, and the synthesized duration for the unit
            fDur = ((fp)ptp->m_wDuration * fDurDerive + fDur) / 2.0;

            fDurTP = TRUE;
         }
         else {
            // it's TP using relative duration
            fDur = (fp)ptp->m_wDuration * pafTPDur[i] / paTTSGLOBALSTATE[i+dwWordStart].fDerWPM
               * (fp)m_dwWordsPerMinute * fDurDerive;
            fDurTP = TRUE;
         }

#ifdef NOMODS_CHANGEDURATION
         iSnapToDurationThis = 1;
#endif

         fp fDurRatio = fDur / (fp)ptp->m_wDuration;
         fp fLogDurThis = log(fDurRatio) / log(2.0);
         fp fPerOctave = UnitScoreDuration (this, (BYTE)pps[i].dwPhone, pLex, fLogDurThis >= 0, fFullPCM);
         fp fScalePow = fabs(fLogDurThis) * max(fPerOctave, 0.0)  / (fp)SNAPTOSCALEDURATION;
         fScalePow *= SNAPTOSCALEBYUNITS; // so the more units, the more it snaps to
         fp fScale = pow ((fp)0.5, fScalePow);
         if (iSnapToDurationThis > 0)
            fScale = 0; // always go to original pitch
         else if (iSnapToDurationThis < 0)
            fScale = 1.0;  // always go to asked-for pitch

         fDur = pow ((fp)2.0, fScale * fLogDurThis) * (fp)ptp->m_wDuration;
         // NOTE: This duration might be further modified when combining units together
      

         dwDur = (DWORD) max(fDur + 0.5, 1.0);
         if (fDurTP)
            dwDur = dwDur | 0x80000000;   // so know its tp
         plDur->Add (&dwDur);

         if (!pafTPVol) {
            // BUGFIX - Volume per phoneme
            if (paPhoneMod)
               fVol = paPhoneMod[i+dwWordStart].p[1];
            else
               fVol = 1; // BUGFIX - Since already incorporate elsewhere... paTTSGLOBALSTATE[i+dwWordStart].fVol; // default volume
         }
         else if (dwVolType == 2) {
            // absoluste volume
            fVol = pafTPVol[i];
               // NOTE: Absolute volume NOT affected by global state

            // calculate the triphone volume
            // BUGFIX - Moved energy average into a triphone prosody feature
            fp fSum = ptp->m_fEnergyAvg;
            //fp fSum = 0;
            //if (ptp) {
            //   for (j = 0; j < ptp->m_dwNumSRFEATURE; j++)
            //      fSum += SRFEATUREEnergy ((PSRFEATURE)ptp->m_pmemSRFEATURE->p + j, FALSE);
            //   fSum /= (fp) ptp->m_dwNumSRFEATURE;
            //}
            if (fSum)
               fVol /= fSum;
            else
               fVol = 1;

            fVol *= (fp)SRDATAPOINTS;  // BUGFIX - Scale by SRDATAPOINTS so if change later wont have to change TP
            
            fVol *= -1; // so know its from TP
         }
         else
            fVol = -pafTPVol[i] * paTTSGLOBALSTATE[i+dwWordStart].fDerVol;    // negative volume to indicate it's from TP

         plVol->Add (&fVol);


         if (dwTPPitchPerPhone) {
            // if we have transplanted prosody info then see how many pitch points
            // we have
            fp *pfCur = pafTPPitch + dwTPPitchPerPhone * i;
            for (dwNumPitch = 0; dwNumPitch < dwTPPitchPerPhone; dwNumPitch++) {
               // if it's a symbol (-1234) indicating that there's no pitch
               if (pfCur[dwNumPitch] == -1234)
                  break;

               // else, flip the sign so know that it's a TP pitch
               pfCur[dwNumPitch] *= -1;
            }
            plPitch->Add (pfCur, dwNumPitch * sizeof(pfCur[0]));
         }
         else {
            // pitch
            afPitch[0] = pps[i].fPitchLeft;  // BUGFIX - include typical pitch shift for phoneme
            afPitch[1] = pps[i].fPitchCenter;
               // BUGFIX - Was using fPitch, but need to counterage left/right weight
            afPitch[2] = pps[i].fPitchRight;
            dwNumPitch = 0;
            if (pps[i].fVoiced) {
               dwNumPitch = 3;   // 3 pitch points for voiced
                  // BUGFIX - Was 3 for vowel, 1 for unvoiced

               // NOTE: If not vowel then no pitch inflection by phoneme
               if (!pps[i].fVowel) {
                  afPitch[0] = afPitch[2] = afPitch[1] = pps[i].fPitch;  // all set to median pitch
                        // BUGFIX - Was just setting all to afPitch[1], but since changed afPitch[1]
                        // to be pps[i].fPitchCenter, not pps[i].fPitch, need to change this
                  dwNumPitch = 1;   // BUGFIX - So non-vowels don't have as much resolution becase
                                    // no pitch assigned to them
               }
               //dwNumPitch = pps[i].fVowel ? 3 : 1; // BUGFIX - so vowel more likely to be constant pitch
            }

            plPitch->Add (afPitch + ((dwNumPitch == 1) ? 1 : 0), dwNumPitch * sizeof(afPitch[0]));
               // BUGFIX - If voiced then add one pitch mark, else if unvoiced then none
         }

         // compress
         // BUGFIX - Removed ptp->Compress();
      } // i, over lStress
   } // dwWordStart

   // get this
   DWORD *padwDur = (DWORD*)plDur->Get(0);

   DWORD j;

   // average syllable dur
   // BUGBUG - at some point may want a voice customization feature that allows more ephasis
   // on database's syllable duration based on phonemes, or based on time. Likewise, might
   // want option to always use same syllable duration (for poetry)
   fp fAvgSyllableDur = AvgSyllableDurGet(); // whatever is standard for this voice
   if (!fAvgSyllableDur)
      fAvgSyllableDur = 0.2;  // guess

#if 0 // to test
#ifdef _DEBUG
   FILE *file = fopen("c:\\pros.txt", "wt");
#else
   FILE *file = fopen("c:\\prosr.txt", "wt");
#endif
#endif // 0

   // go through all the phonemes and determine what syllable they're on
   PCMMLNode2 pLast = NULL;
   CListFixed lSylDurPhone, /*lSylDurSyl, lSylPitchSweep,*/ lSylVol, lSylPitch, lSylDurSkew;
#ifdef USEDURSYL
   CListFixed lSylDurSyl;
#endif
   CListFixed lDWORDDurPhone, lDWORDDurSyl, lDWORDPitchSweep, lDWORDVol, lDWORDPitch, lBoundary, lDWORDPitchBulge, lDWORDDurSkew;
   CListFixed lDWORDSylStart, lDWORDSylEnd;
   DWORD *padwBoundary = NULL;
   dwWordStart = 0;
   lDWORDDurPhone.Init (sizeof(DWORD));
   lDWORDDurSyl.Init (sizeof(DWORD));
   lDWORDDurSkew.Init (sizeof(DWORD));
   lDWORDPitchSweep.Init (sizeof(DWORD));
   lDWORDPitchBulge.Init (sizeof(DWORD));
   lDWORDVol.Init (sizeof(DWORD));
   lDWORDPitch.Init (sizeof(DWORD));
   lBoundary.Init (sizeof(DWORD));
   lSylDurPhone.Init (sizeof(fp));
   lSylDurSkew.Init (sizeof(fp));
#ifdef USEDURSYL
   lSylDurSyl.Init (sizeof(fp));
#endif
   lSylVol.Init (sizeof(fp));
   lSylPitch.Init (sizeof(fp));
   lDWORDSylStart.Init (sizeof(DWORD));
   lDWORDSylEnd.Init (sizeof(DWORD));
   // lSylPitchSweep.Init (sizeof(fp));
   fp f;
#define SYLPITCHDETAIL     3        // so pitch for syllables is more detailed
   DWORD k;
   DWORD *padwDurOrig = (DWORD*)lDurOrig.Get(0);
   fp fNextPitch = 0;   // next pitch to use when dont have one
   for (i = 0; i < dwNum; i++) {
      if (pLast != papMMLWord[i]) {
         pLast = papMMLWord[i];
         dwWordStart = i;

         // get the boundaries and duration of each syllable
         if (papMMLWord[i]) {
            AttribGetArray (papMMLWord[i], gpszSyllables, &lBoundary);
            AttribGetArray (papMMLWord[i], gpszSylDurPhone, &lDWORDDurPhone);
            AttribGetArray (papMMLWord[i], gpszSylDurSyl, &lDWORDDurSyl);
            AttribGetArray (papMMLWord[i], gpszSylDurSkew, &lDWORDDurSkew);
            AttribGetArray (papMMLWord[i], gpszSylPitch, &lDWORDPitch);
            AttribGetArray (papMMLWord[i], gpszSylPitchSweep, &lDWORDPitchSweep);
            AttribGetArray (papMMLWord[i], gpszSylPitchBulge, &lDWORDPitchBulge);
            AttribGetArray (papMMLWord[i], gpszSylVol, &lDWORDVol);
         }
         else {
            lBoundary.Clear();
            lDWORDDurPhone.Clear();
            lDWORDDurSyl.Clear();
            lDWORDDurSkew.Clear();
            lDWORDPitchSweep.Clear();
            lDWORDPitchBulge.Clear();
            lDWORDPitch.Clear();
            lDWORDVol.Clear();
         }
         padwBoundary = (DWORD*)lBoundary.Get(0);
      } // if new word

      if (!lBoundary.Num()) {
         // no syllables for this word, so hack in 1.0's
         f = 1.0;
         lSylDurPhone.Add (&f);
#ifdef USEDURSYL
         lSylDurSyl.Add (&f);
#endif
         lSylVol.Add (&f);
         for (k = 0; k < SYLPITCHDETAIL; k++) {
            f = fNextPitch;
            fNextPitch = 0;
            lSylPitch.Add (&f);  // BUGFIX - Was always adding 1. should have been 0
         }

#if 0 // to test
         fprintf (file, "\r\ni=%d: No syllables", (int)i);
#endif // 0

         //f = 0;   // so no pitch sweep
         //lSylPitchSweep.Add (&f);

         f = 0.0;
         lSylDurSkew.Add (&f);

         DWORD dwZero = 0;
         lDWORDSylStart.Add (&dwZero);
         lDWORDSylEnd.Add (&dwZero);

         continue;
      } // if no syllables in this word

      // try to find the apropriate syllable
      DWORD dwSyl;
      for (dwSyl = 0; dwSyl < lBoundary.Num(); dwSyl++)
         if (i - dwWordStart < padwBoundary[dwSyl])
            break;
      // NOTE: I think the bode for lBoundary and syllable stresses may mess up somewhat
      // if there's a phoneme substitution, but it shouldnt crash
      if (dwSyl >= lBoundary.Num())
         dwSyl = lBoundary.Num()-1;  // just to make sure dont go beyond edge

      // figure out the number ideal number of phonemes in this syllable
      DWORD dwSylStart = (dwSyl ? padwBoundary[dwSyl-1] : 0) + dwWordStart;
      DWORD dwSylEnd = padwBoundary[dwSyl] + dwWordStart;
      DWORD dwTotalOrigDur = 0, dwTotalOrigDurVowel = 0, dwTotalOrigDurPlosive = 0, dwTotalOrigDurConsonant = 0;
      DWORD j;
      PLEXPHONE plp;
      PLEXENGLISHPHONE ple;
      for (j = dwSylStart; j < dwSylEnd; j++) {
         dwTotalOrigDur += padwDurOrig[j];

         // get info
         plp = pLex->PhonemeGetUnsort (PhonemeBackoff((WORD)padwPhone[j], pLex, bSilence));
         ple = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;
         if (ple && ple->dwCategory & PIC_PLOSIVE)
            dwTotalOrigDurPlosive += padwDurOrig[j];
         else if (!ple || ((ple->dwCategory & PIC_MAJORTYPE) == PIC_VOWEL))
            dwTotalOrigDurVowel += padwDurOrig[j];
         else
            dwTotalOrigDurConsonant += padwDurOrig[j];
      }
      if (!dwTotalOrigDur) {
         dwTotalOrigDur = 1;
         dwTotalOrigDurVowel = 1;
      }

      // figure out the voiced section of the syllable starting and ending
      DWORD dwSylStartVoiced = -1;
      DWORD dwSylEndVoiced = 0;  // so have something
      PPSTRESS pps = (PPSTRESS) lStressAll.Get(0);
      for (j = dwSylStart; j < dwSylEnd; j++) {
         if (j >= lStressAll.Num())
            continue;   // error

         // if this is voiced, then remember as end. else skip
         if (!pps[j].fVoiced)
            continue;
         dwSylEndVoiced = j+1;   // since one extra

         if (dwSylStartVoiced == (DWORD)-1)
            dwSylStartVoiced = j;
      } // voiced start/end
      if (dwSylStartVoiced == (DWORD)-1)
         dwSylStartVoiced = dwSylEndVoiced;


      // how much do we want to stretch it?
      //fp fAvgSyllableDur = paTTSGLOBALSTATE[dwSylStart].fDerAvgSyllableDur;
      //if (!fAvgSyllableDur) {
      //   // shouldnt happen, but just in case
      //   fAvgSyllableDur = AvgSyllableDurGet();
      //   if (!fAvgSyllableDur)
      //      fAvgSyllableDur = 0.2;
      //}
      fp fStretch = (fp) *((DWORD*)lDWORDDurSyl.Get(dwSyl)) / (fp)0x10000 * fAvgSyllableDur;
         // which calculates how long this should be (in sec)
      fp fThisDur = (fp)dwTotalOrigDur / (fp)SRSAMPLESPERSEC;
      fStretch /= fThisDur;   // so stretch accordingly

      // write in the values
      f = (fp) *((DWORD*)lDWORDDurPhone.Get(dwSyl)) / (fp)0x10000;
         // BUGFIX - Disable the following line since sounds better with fStretch off
#ifdef USEDURSYL
      f = f * 0.75 + fStretch * 0.25; // average phoneme stretch, over ideal syllable length
         // which means include part phoneme duration, and part timing for syllables
         // BUGBUG - At some point might have an option for this, to get more poetic or not
         // BUGFIX - Only include average syllable length as 1/4, not 1/2
#endif

      // potentially stretch out for slow voice if not in transpros
      if (!(padwDur[i] & 0x80000000))
         f *= (fp)m_dwWordsPerMinute / paTTSGLOBALSTATE[i].fDerWPM;

      // how many units extra to duration?
#define STRETCHVOWEL       1.0
#define STRETCHCONSONANT   0.5
#define STRETCHPLOSIVE     0.25     // BUGFIX - Upped from 0.1 to 0.25
      fp fStretchSum =
         (fp)dwTotalOrigDurVowel * STRETCHVOWEL +
         (fp)dwTotalOrigDurConsonant * STRETCHCONSONANT +
         (fp)dwTotalOrigDurPlosive * STRETCHPLOSIVE;
      DWORD dwThisDur = padwDurOrig[i];
      fp fUnitsExtra = (f - 1.0) * (fp)dwTotalOrigDur;
      plp = pLex->PhonemeGetUnsort (PhonemeBackoff((WORD)padwPhone[i], pLex, bSilence));
      ple = plp ? MLexiconEnglishPhoneGet(plp->bEnglishPhone) : NULL;
      fp fStretchAmt;
      if (ple && ple->dwCategory & PIC_PLOSIVE)
         fStretchAmt = STRETCHPLOSIVE;
      else if (!ple || ((ple->dwCategory & PIC_MAJORTYPE) == PIC_VOWEL))
         fStretchAmt = STRETCHVOWEL;
      else
         fStretchAmt = STRETCHCONSONANT;
      fp fWeightThis = fStretchAmt * (fp)dwThisDur / fStretchSum;
      fThisDur = (fp)dwThisDur + fUnitsExtra * fWeightThis;
      fThisDur = max(fThisDur, 1);  // at least one unit
      f = fThisDur / (fp)dwThisDur; // so know how much to stretch this individual phoneme

      // add it
      lSylDurPhone.Add (&f);

      // add skew
      f = (fp) *((int*)lDWORDDurSkew.Get(dwSyl)) / (fp)0x10000;
      lSylDurSkew.Add (&f);
      lDWORDSylStart.Add (&dwSylStart);
      lDWORDSylEnd.Add (&dwSylEnd);

#ifdef USEDURSYL
      f = (fp) *((DWORD*)lDWORDDurSyl.Get(dwSyl)) / (fp)0x10000;
      lSylDurSyl.Add (&f);
#endif

      f = (fp) *((DWORD*)lDWORDVol.Get(dwSyl)) / (fp)0x10000;
      lSylVol.Add (&f);

      if ((i >= dwSylStartVoiced) && (i < dwSylEndVoiced)) {
         int ik, ikMinMax;

         // sweep over the voiced part of the syllable
         for (ik = -1; ik <= SYLPITCHDETAIL; ik++) {
            // NOTE: Have ik < 0, and ik >= SYLPITCHDETAIL to ensure that pitch sweep runs full range
            // only calculate < 0 if at the start of the voiced part, and have a pitch added already
            if ((ik < 0) && ((i != dwSylStartVoiced) || !lSylPitch.Num()) )
               continue;

            // only calculate == SYLPITCHDETAIL if i+1 == dwSylEndVoiced
            if ((ik >= SYLPITCHDETAIL) && (i+1 < dwSylEndVoiced))
               continue;

            // pitch sweep amount
            ikMinMax = max(min(ik, SYLPITCHDETAIL-1), 0);
            fp fAlpha = (fp)((int)i*SYLPITCHDETAIL + ikMinMax - (int)dwSylStartVoiced * SYLPITCHDETAIL) / 
               (fp)((dwSylEndVoiced - dwSylStartVoiced)*SYLPITCHDETAIL - 1);
            fAlpha = fAlpha - 0.5;  // to center in pitch
            fp fSweep = pow ((fp)2.0,(fp)( fAlpha * (fp) *((int*)lDWORDPitchSweep.Get(dwSyl)) / (fp)0x10000));

            // figure out bulge effect
            fp fBulge = 1.0 - 4.0 * fabs(fAlpha);
            fBulge *= (fp) *((int*)lDWORDPitchBulge.Get(dwSyl)) / (fp)0x10000;
            fSweep *= pow ((fp)2.0, (fp)fBulge);

            f = (fp) *((DWORD*)lDWORDPitch.Get(dwSyl)) / (fp)0x10000;
            f *= fSweep;   // so pitch sweep affects

            if (ik < 0) {
               fp *pfLast = (fp*)lSylPitch.Get(lSylPitch.Num()-1);
               if (*pfLast == 0)
                  *pfLast = f;
               fNextPitch = 0;   // just in case
            }
            else if (ik >= SYLPITCHDETAIL)
               // remember this for enxt time
               fNextPitch = f;
            else {
               lSylPitch.Add (&f);
               fNextPitch = 0; // just in case
            }

#if 0 // to test
            fprintf (file, "\r\ni=%d, k=%d: %d %d %.3g", (int)i, (int)ik,
               (int)dwSylStartVoiced, (int)dwSylEndVoiced, (double)f);
#endif // 0

         } // ik
      }
      else {
         // it's not voiced, so dont specify any pitch
         for (k = 0; k < SYLPITCHDETAIL; k++) {
            f = fNextPitch;
            fNextPitch = 0;
            lSylPitch.Add (&f);

#if 0 // to test
            fprintf (file, "\r\ni=%d, k=%d: %d %d %.3g", (int)i, (int)k,
               (int)dwSylStartVoiced, (int)dwSylEndVoiced, (double)f);
#endif // 0
         } // k
      }

      //f = (fp) *((int*)lDWORDPitchSweep.Get(dwSyl)) / (fp)0x10000;
      //lSylPitchSweep.Add (&f);
   } // i, over all phonemes
   fp *pafSylDurPhone = (fp*)lSylDurPhone.Get(0);
   fp *pafSylDurSkew = (fp*)lSylDurSkew.Get(0);
   DWORD *padwSylStart = (DWORD*)lDWORDSylStart.Get(0);
   DWORD *padwSylEnd = (DWORD*)lDWORDSylEnd.Get(0);
#ifdef USEDURSYL
   fp *pafSylDurSyl = (fp*)lSylDurSyl.Get(0);
#endif
   fp *pafSylPitch = (fp*)lSylPitch.Get(0);
   //fp *pafSylPitchSweep = (fp*)lSylPitchSweep.Get(0);
   fp *pafSylVol = (fp*)lSylVol.Get(0);


   // go back through and adjust the phoneme durations
   pLast = NULL;
   fp fErrorAccum = 0;
   fp fDur, fLastDur;
   BOOL fUsingAbsDur = FALSE;
   DWORD dwLastSylStart = (DWORD)-1, dwLastSylEnd = (DWORD)-1;
   fp fScaleSoSkewDoesntLengthen = 1;
   fp fSkewForSyllable = 1;
   DWORD dwMidPhone = 0;
   fp fMidPhonePercent = 0.5;
   fp fSkew;
   for (i = 0; i < dwNum; i++) {
      if (!fUsingAbsDur)
         fLastDur = pafSylDurPhone[i];


      if (pLast != papMMLWord[i]) {
         // PWSTR psz = papMMLWord[i] ? papMMLWord[i]->AttribGetString (gpszDurRel) : NULL;
         // fLastDur = psz ? _wtof (psz) : 1;
         pLast = papMMLWord[i];
         fUsingAbsDur = FALSE;

         // see if there's an absolute duration
         PWSTR psz = papMMLWord[i] ? papMMLWord[i]->AttribGetString (gpszDurAbs) : NULL;
         fp fDurAbs = 0;
         if (psz)
            fDurAbs = _wtof(psz);
         if (fDurAbs >= .01) {
            // loop until word ends and calculate duration
            fp fSum = 0;
            DWORD j;

            // BUGFIX - may want to multiply all the durations of individual phonemes
            // by the syllable info first, and then normalize. That way will be the right
            // duration, but will also create the right inflection. But NOT if TP flag
            for (j = i; (j < dwNum) && (papMMLWord[j] == pLast); j++) {
               if (HIWORD(padwDur[j]))
                  continue;   // transplanted prosody is set so don't adjust

               fp fDuration = (fp)LOWORD(padwDur[j]); // in case TP set
               fDuration *= pafSylDurPhone[j];
               fDuration += 0.5;
               fDuration = max(fDuration, 1);   // at least 1 length
               padwDur[j] = (DWORD)fDuration;   // dont worry about high bit since wouldnt set
            }

            for (j = i; (j < dwNum) && (papMMLWord[j] == pLast); j++)
               fSum += (fp)LOWORD(padwDur[j]);  // BUGFIX - Take LOWORD() just in case TP high bit set
            if (fSum)
               fLastDur = fDurAbs * (fp)SRSAMPLESPERSEC / fSum;
            fUsingAbsDur = TRUE;
         } // if absolute duration
      }

      // if the duration is flagged with the high bit then it's TP, so
      // just use whatever duration is there
      if (padwDur[i] & 0x80000000) {
         padwDur[i] &= ~0x80000000;
         continue;
      }

      // if different syllable then calculate
      if ((dwLastSylStart != padwSylStart[i]) || (dwLastSylEnd != padwSylEnd[i])) {
         dwLastSylStart = padwSylStart[i];
         dwLastSylEnd = padwSylEnd[i];

         // figure out if there's any skewing on this phoneme
         // figure out the theoretical length
         DWORD dwTheorDur = 0;
         fp fActualDur = 0;
         fp fDurTemp;
         PCMTTSTriPhonePros ptp;
         for (j = padwSylStart[i]; j < padwSylEnd[i]; j++) {
            ptp = pptp[j];
            dwTheorDur += ptp ? ptp->m_wDuration : 1;
            fDurTemp = (fp)padwDur[j] * fLastDur;
            fActualDur += fDurTemp;
         } // j

         // find mid-point in theoretical
         DWORD dwTheorDurHalf = dwTheorDur / 2;
         DWORD dwDur = 1;
         for (j = padwSylStart[i]; j < padwSylEnd[i]; j++) {
            ptp = pptp[j];
            dwDur = ptp ? ptp->m_wDuration : 1;
            if (dwTheorDurHalf < dwDur)
               break;

            dwTheorDurHalf -= dwDur;
         }
         dwMidPhone = j;
         fMidPhonePercent = (fp)dwTheorDurHalf / (fp)dwDur;

         // weight
         fSkew = pow((fp)2.0, pafSylDurSkew[i]);

         // find this mid-phoneme in the actual phoneme
         fp fDurAfterSkew = 0;
         for (j = padwSylStart[i]; j < padwSylEnd[i]; j++) {
            fDurTemp = (fp)padwDur[j] * fLastDur;
            if (j < dwMidPhone)
               fDurTemp *= 1.0 / fSkew;
            else if (j > dwMidPhone)
               fDurTemp *= fSkew;
            else
               fDurTemp *= (1.0 - fMidPhonePercent) * fSkew + fMidPhonePercent / fSkew;
            fDurAfterSkew += fDurTemp;
         }
         fScaleSoSkewDoesntLengthen = max(fActualDur,CLOSE) / max(fDurAfterSkew,CLOSE);
         if (dwLastSylStart == dwLastSylEnd)
            fScaleSoSkewDoesntLengthen = fSkew = 1.0;   // since is silence or something

         fSkewForSyllable = fSkew;
      }

      // what percentage of this phone is before the mid-point and after
      fSkew = fSkewForSyllable;
      if (i < dwMidPhone)
         fSkew = 1.0 / fSkew; // to shorten
      else if (i > dwMidPhone)
         fSkew = fSkew; // to keep same elngth
      else
         fSkew = (1.0 - fMidPhonePercent) * fSkew + fMidPhonePercent / fSkew; // part way for each
      fSkew *= fScaleSoSkewDoesntLengthen;   // so keep right length


      // scale the duration
      fDur = (fp)padwDur[i] * fLastDur * fSkew + fErrorAccum; // deal with roundoff error
#ifndef NOMODS_CHANGEDURATION
      // keep the original time
      padwDur[i] = (DWORD)fDur;
#endif
      padwDur[i] = max(padwDur[i], 1); // always at least some duration
      fErrorAccum = fDur - (fp)padwDur[i];
      fErrorAccum = max(fErrorAccum, 0); // BUGFIX - so dont go negative
   } // i



   // make a list of inflection points for the pitch and volume...
   CListFixed lPitchInflect, lVolInflect;
   lPitchInflect.Init (sizeof(fp));   // BUGFIX - Changed pitch and vol to be low-pass, not spline
   lVolInflect.Init (sizeof(fp));
   pLast = NULL;
   DWORD dwCur = 0;
   fp fUnk = -1;
   BOOL fAbsPitch, fAbsVol;
   for (i = 0; i < dwNum; dwCur += padwDur[i++]) {
      // if same as before nothing
      if (pLast == papMMLWord[i])
         continue;
      pLast = papMMLWord[i];
      if (!papMMLWord[i])
         continue;   // cant do

      // get the pitch, volume, and where it inflects
      PWSTR psz;
      fp fPitch, fVol;
      // int iInflect;
      fPitch = 1;
      fVol = 1;
      // not used: psz = pLast->AttribGet (gpszInflectPoint);
      // not used: iInflect = psz ? _wtoi(psz) : 0;

      // if there is an absoluate volume then deal with that
      psz = pLast->AttribGetString (gpszVolAbs);
      fp fVolAbs = psz ? _wtof(psz) : 0;
      if (fVolAbs > CLOSE) {
         fp fSum = 0;
         DWORD dwCount = 0;
         // figure out what this volume would be under normal volume

         pptp = (PCMTTSTriPhonePros*)lTriPhone.Get(0); // just in case was changed
         for (j = i; (j < dwNum) && (pLast == papMMLWord[j]); j++) {
            DWORD dwThisCount;

            // BUGFIX - Since keep energy stored in triphone prosody, deal with differently
            fp fThis = pptp[j]->m_fEnergyAvg;
            dwThisCount = pptp[j]->m_wDuration;
            //fp fThis = TriPhoneEnergy (pptp[j], &dwThisCount);

            // BUGFIX - was
            //DWORD dwWord = paszWord[j] ? m_pLexWords->WordFind (paszWord[j]) : -1;
            //fp fThis = TriPhoneEnergy (padwPhone, dwWord, dwNum, j, &dwThisCount);

            fSum += (fp)dwThisCount * fThis;
            dwCount += dwThisCount;
         } // j
         if (dwCount)
            fSum /= (fp)dwCount;

         // now have volume over entire word, so easy to figure out scale
         if (fSum > CLOSE)
            fVol = fVolAbs / fSum;
         fVol *= (fp)SRDATAPOINTS;  // BUGFIX - Scale so if change # of SRDATAPOINTS wont have to change
         fAbsVol = TRUE;
      } // if fVolAbs
      else {
         fVol *= paTTSGLOBALSTATE[i].fDerVol;   // relative volume
         fAbsVol = FALSE;
      }

      // see aboute absolute pitch
      psz = pLast->AttribGetString (gpszPitchAbs);
      if (psz) {
         fAbsPitch = TRUE;
         fPitch = _wtof(psz) / paTTSGLOBALSTATE[i].fDerAvgPitch;
      }
      else
         fAbsPitch = FALSE;

      // NOTE: Minor problem that wont fix. if have absolute pitch,
      // and adjust pitch expressiveness then the pitch will be modified
      // by the expressiveness. Not really worth fixing.

      // add in -1's until get to point, indicating pitch is indeterminant
      lPitchInflect.Required (dwCur);
      lVolInflect.Required (dwCur);
      while (lPitchInflect.Num() < dwCur) {
         lPitchInflect.Add (&fUnk);
         lVolInflect.Add (&fUnk);
      }

      // calculate the duration of this word...
      DWORD dwDur = 0;
      for (j = i; j < dwNum; j++) {
         if (pLast != papMMLWord[j])
            break;   // done with word

         dwDur += padwDur[j];

         fp fv = fVol;
         if (!fAbsVol)
            fv *= pafSylVol[j];  // include volume

         // add in pitch and volume
         if (lPitchInflect.Num() >= dwCur + dwDur)
            continue;   // shouldnt happen
         DWORD dwNumPoints = dwCur + dwDur - lPitchInflect.Num();
         for (k = 0; k < dwNumPoints; k++) {
            // pitch changes
            fp f = fPitch;
            fp fAlpha;
            DWORD dwIndex, dwIndex2;
            if (!fAbsPitch) {
               fAlpha = ((fp)j + (fp)k / (fp)dwNumPoints) * SYLPITCHDETAIL - 0.5;
               fAlpha = max(fAlpha, 0);
               fAlpha = min(fAlpha, (fp)(lSylPitch.Num()-1));
               dwIndex = (DWORD)fAlpha;
               dwIndex2 = dwIndex+1;
               dwIndex2 = min(dwIndex2, lSylPitch.Num()-1);
               fAlpha -= (fp)dwIndex;

               if (pafSylPitch[dwIndex] && pafSylPitch[dwIndex2])
                  f *= (1.0 - fAlpha) * pafSylPitch[dwIndex] + fAlpha * pafSylPitch[dwIndex2];
               else if (pafSylPitch[dwIndex])
                  f *= pafSylPitch[dwIndex];
               else if (pafSylPitch[dwIndex2])
                  f *= pafSylPitch[dwIndex2];
               else
                  f = fUnk;
            }
            if (f != fUnk) {
               f *= paTTSGLOBALSTATE[i].fDerAvgPitch;  // ok to use i, which is beginngng of word
               f = max(f, CLOSE);
            }
            lPitchInflect.Add (&f);

#if 0 // to test
            fprintf (file, "\r\ni=%d, j=%d, k=%d: %.3g %.3g %.3g %.3g %.3g %d",
               (int)i, (int)j, (int)k,
               (double)f, (double)fAlpha, (double)pafSylPitch[dwIndex], (double)pafSylPitch[dwIndex2],
               (double)paTTSGLOBALSTATE[i].fDerAvgPitch, (int)dwNumPoints);
#endif // 0

            // volume is the same for each
            lVolInflect.Add (&fv);
         } // k
      } // j, over indivual phonemes

   } // i

   // add -1 until get to the end of the info
   lPitchInflect.Required (dwCur);
   lVolInflect.Required (dwCur);
   while (lPitchInflect.Num() < dwCur) {
      lPitchInflect.Add (&fUnk);
      lVolInflect.Add (&fUnk);
   }

   // default pitch
   fp fDefPitch = dwNum ? paTTSGLOBALSTATE[0].fDerAvgPitch : pVoiceMod->pSubVoice->m_fAvgPitch;

   // smooth this out
   fp *pafPitch = (fp*)lPitchInflect.Get(0);
   fp *pafVolIn = (fp*)lVolInflect.Get(0);
   DWORD dwNumInflect = lPitchInflect.Num();

#if 0 // to test
   fprintf (file, "\r\n\r\n\r\n");
   for (i = 0; i < dwNumInflect; i++)
      fprintf (file, "\r\n%.3g", (double)pafPitch[i]);
#endif // 0

   int iBlur;
   iBlur = (int)(pVoiceMod->pSubVoice->m_fBlurPitch * (fp)SRSAMPLESPERSEC);
   if (iBlur > 0)
      PitchLowPass (pafPitch, dwNumInflect,
         (DWORD)iBlur, fDefPitch);
      // BUGFIX - Reduced from /5 to /10

#if 0 // to test
   fprintf (file, "\r\n\r\n\r\n");
   for (i = 0; i < dwNumInflect; i++)
      fprintf (file, "\r\n%.3g", (double)pafPitch[i]);
#endif // 0

   iBlur = (int)(pVoiceMod->pSubVoice->m_fBlurVolume * (fp)SRSAMPLESPERSEC);
   if (iBlur > 0)
      PitchLowPass (pafVolIn, dwNumInflect, (DWORD)iBlur, 1);
      // BUGFIX - Blur volume more because sounds too jumpy now with volume
      // increasing and decreasing too quickly


#if 0 // to test
   for (i = 0; i < dwNum; i++) {
      fprintf (file, "\r\nPhone %d : %x, %d, %.3g; ",
         (DWORD) i, padwPhone[i], *((DWORD*)plDur->Get(i)), (double) *((fp*)plVol->Get(i)));

      fp *paf = (fp*)plPitch->Get(i);
      DWORD dwNum2 = plPitch->Size(i) / sizeof(DWORD);
      for (j = 0; j < dwNum2; j++)
         fprintf (file, "%.3g ", (double)paf[j]);
   } // i
#endif // 0


   // adjust the pitch and volume
   dwCur = 0;
   fp fTime;
   int iTime;
   fp *pafVol = (fp*)plVol->Get(0);
   fp afPitchOne[3];
   for (i = 0; i < dwNum; dwCur += padwDur[i++]) {
      // adjust the pitch
      fp *pfPitch = (fp*)plPitch->Get(i);
      DWORD dwNumPitch = (DWORD)plPitch->Size(i) / sizeof(fp);

#if 0 // keep dwNumPitch the same as original was so that don't mess with pitch
      // note: Some concern that disabling this causes problems SynthDetermineTriPhoneAudio because
      // it uses the pitch, but it seems to find the closest left/right one and use that

      // prosody, or lack of it, from phonemes, causing pitch to be attributed
      // to silence and non-spoken

      // make sure have some pitch information so can do accurate prosody bend
      if (dwNumPitch == 0) {
         dwNumPitch = 3;
         afPitchOne[0] = afPitchOne[1] = afPitchOne[2] = 1.0;
         pfPitch = afPitchOne;
      }
      else if (dwNumPitch == 1) {
          dwNumPitch = 3;
         afPitchOne[0] = afPitchOne[1] = afPitchOne[2] = pfPitch[0];
         pfPitch = afPitchOne;
      }
      else if (dwNumPitch == 2) {
         dwNumPitch = 3;
         afPitchOne[0] = pfPitch[0];
         if ( ((pfPitch[0] > 0) && (pfPitch[1] > 0)) || ((pfPitch[0] < 0) && (pfPitch[1] < 0)) )
            afPitchOne[1] = (pfPitch[0] + pfPitch[1]) / 2;
         else
            afPitchOne[1] = 0;   // since cant really guess
         afPitchOne[2] = pfPitch[1];
         pfPitch = afPitchOne;
      }
#endif // 0

      for (j = 0; j < dwNumPitch; j++) {
         if (pfPitch[j] < 0) {
            // if < 0 it's a transplanted prosofy pitch, so use as absolute
            pfPitch[j] *= -1;
            continue;
         }

         // BUGFIX - If pfPitch[j] == 0 then don't bother adjusting, because
         // wont be used later
         if (!pfPitch[j])
            continue;

         fTime = (fp)dwCur + (fp)padwDur[i] * (fp)(j+1) / (fp)(dwNumPitch+1);
         iTime = (int)(fTime + .5);
         iTime = max(iTime, 0);
         if (iTime >= (int)dwNumInflect-1)  // BUGFIX - should be dwNumInflect-1
            iTime = (int)dwNumInflect-1;
         pfPitch[j] = ((iTime > 0) ? pafPitch[iTime] : fDefPitch) * pfPitch[j];

#if 0 // to test
         fprintf (file, "\r\n%d = %.3g", (int)iTime, (double)pafPitch[iTime]);
#endif // 0

         // apply pitch expressiveness
         if (paTTSGLOBALSTATE[i].fDerPitchExpress != 1) {
            pfPitch[j] /= paTTSGLOBALSTATE[i].fDerAvgPitch;
            pfPitch[j] = pow(pfPitch[j], paTTSGLOBALSTATE[i].fDerPitchExpress);
            pfPitch[j] *= paTTSGLOBALSTATE[i].fDerAvgPitch;
         }
      } // j

      // set back again
      if (pfPitch == afPitchOne)
         plPitch->Set (i, pfPitch, dwNumPitch * sizeof(*pfPitch));

      // adjust the volume
      if (pafVol[i] < 0)
         pafVol[i] *= -1;  // since negative volume used to indicate TP
      else {
         // volume modifies curve
         fTime = (fp)dwCur + (fp)padwDur[i]/2;
         iTime = (int)(fTime + .5);
         iTime = max(iTime, 0);
         iTime = min(iTime, (int)dwNumInflect);
         pafVol[i] *= ((iTime > 0) ? pafVolIn[iTime] : 1);
      }
   } // i

#if 0 // to test
   fprintf (file, "\r\n\r\n\r\n");
   for (i = 0; i < dwNum; i++) {
      fprintf (file, "\r\nPhone %d : %x, %d, %.3g; ",
         (DWORD) i, padwPhone[i], *((DWORD*)plDur->Get(i)), (double) *((fp*)plVol->Get(i)));

      fp *paf = (fp*)plPitch->Get(i);
      DWORD dwNum2 = plPitch->Size(i) / sizeof(DWORD);
      for (j = 0; j < dwNum2; j++)
         fprintf (file, "%.3g ", (double)paf[j]);
   } // i
   fclose (file);
#endif // 0

   // done
   return TRUE;
}

/*************************************************************************************
CMTTS::ApplyAccent - This loops through the list of phonemes, looking for patterns
in the phonemes and applies an accent based on the phoneme sequence.

inputs
   PCListFixed       plPhone - Will be filled in with a list of phonemes (DWORD), with
                              high byte (<< 24) filled in indicating start, middle,
                              end of word
   PCListFixed       plWord - Initialized to sizeof (PWSTR). Filled in with list of
                              pointers to strings (the strings stored in plStrings).
                              These are the words/punctuation at each phoneme.
   PCListFixed       plMMLWord - Initialized to sizeof(PCMMLNode2). Filled in with the
                              node for the word for each phoneme. If a word has several
                              phonemes they all point to the same node.
   PCListFixed       plPhoneMod - Initialized to sizeof (CPoint). FIlled in with the
                              phone-specific [0]=pitch, [1]=vol, [2]=dur for each,
                              phoneme.
   PCListFixed       plTTSGLOBALSTATE - Initialized to sizeof (TTSGLOBALSTATE) and then
                     filled with one TTSGLOBALSTATE entry per phoneme, so know how fast
                     should speak, etc.
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
returns
   BOOL - TRUE if success
*/
BOOL CMTTS::ApplyAccent (PCListFixed plPhone, PCListFixed plWord, PCListFixed plMMLWord,
                         PCListFixed plPhoneMod, PCListFixed plTTSGLOBALSTATE, PTTSVOICEMOD pVoiceMod)
{
   // if no accent to apply just exit here
   if (!pVoiceMod->pSubVoice->m_lTTSACCENTRULE.Num())
      return TRUE;

   PTTSACCENTRULE par = (PTTSACCENTRULE)pVoiceMod->pSubVoice->m_lTTSACCENTRULE.Get(0);
   DWORD dwNum = pVoiceMod->pSubVoice->m_lTTSACCENTRULE.Num();
   
   // loop through all the phonems
   DWORD i, j, k;
   for (i = 0; i < plPhone->Num(); i++) {
      // phonemes
      DWORD *padwPhone = (DWORD*)plPhone->Get(0);

      // see if find match...
      DWORD dwBestMatch = -1;
      DWORD dwMatchLen = 0;
      for (j = 0; j < dwNum; j++) {
         DWORD dwLen = (DWORD)strlen((char*)par[j].abOrig);
         if (dwLen + i > plPhone->Num())
            continue;
         if ((dwBestMatch != -1) && (dwLen <= dwMatchLen))
            continue;   // not long enough anyway

         // look for match, also seeing if word start/end
         for (k = 0; k < dwLen; k++)
            if (par[j].abOrig[k]-1 != (BYTE)padwPhone[i+k])
               break;
         if (k < dwLen)
            continue;   // no match

         // see if word start/end requirement
         if ((par[j].dwLoc == 1) && !(padwPhone[i+0] & (1 << 24)))
            continue;   // supposed to be at word start but isnt
         if ((par[j].dwLoc == 2) && !(padwPhone[i+dwLen-1] & (2 << 24)))
            continue;   // supposed to be at word start but isnt

         // else have match
         if ((dwBestMatch == -1) || (dwLen > dwMatchLen)) {
            dwBestMatch = j;
            dwMatchLen = dwLen;
         }
      } // j

      if (dwBestMatch == -1)
         continue;   // none found

      // fing out if there's a word start/end here
      DWORD dwWordStart = -1, dwWordEnd = -1;
      for (j = 0; j < dwMatchLen; j++) {
         if (padwPhone[i + j] & (1 << 24))
            dwWordStart = j;
         else if (padwPhone[i+j] & (2 << 24))
            dwWordEnd = j;
      } // j

      // insert/remove phonemes? this is somewhat stupid in that it
      // inserts/remove right from the current location
      DWORD dwLenInsert = (DWORD)strlen((char*)par[dwBestMatch].abNew);
      if (dwLenInsert > dwMatchLen) {
         // NOTE - Dont change dwWordStart or dwWord end because not really sure how
         DWORD dwPhoneInsert = 0;
         PWSTR pszWordInsert = *((PWSTR*)plWord->Get(i));
         PCMMLNode2 pszMMLInsert = *((PCMMLNode2*)plMMLWord->Get(i));
         TTSGLOBALSTATE gsInsert = *((PTTSGLOBALSTATE) plTTSGLOBALSTATE->Get(i));
         CPoint pMod;
         pMod.Copy ((PCPoint)plPhoneMod->Get(i));

         for (j = 0; j < dwLenInsert-dwMatchLen; j++) {
            plPhone->Insert (i, &dwPhoneInsert);
            plPhoneMod->Insert (i, &pMod);
            plWord->Insert (i, &pszWordInsert);
            plMMLWord->Insert (i, &pszMMLInsert);
            plTTSGLOBALSTATE->Insert (i, &gsInsert);
         } // j
      }
      else if (dwLenInsert < dwMatchLen) {
         // else remove
         DWORD dwDiff = dwMatchLen - dwLenInsert;
         if (dwWordStart != -1)
            dwWordStart = (dwWordStart >= dwDiff) ? (dwWordStart - dwDiff) : 0;
         if (dwWordEnd != -1)
            dwWordEnd = (dwWordEnd >= dwDiff) ? (dwWordEnd - dwDiff) : 0;
         for (j = 0; j < dwDiff; j++) {
            plPhone->Remove (i);
            plPhoneMod->Remove (i);
            plWord->Remove (i);
            plMMLWord->Remove (i);
            plTTSGLOBALSTATE->Remove (i);
         }
      }

      // reload the phonem pointer because with insertion and deletion may have messed up
      padwPhone = (DWORD*)plPhone->Get(0);

      // write new phonemes
      for (j = 0; j < dwLenInsert; j++) {
         DWORD dwVal = (DWORD)par[dwBestMatch].abNew[j];
         dwVal--; // so take out offset
         if (dwWordStart == j)
            dwVal |= (1 << 24);
         if (dwWordEnd == j)
            dwVal |= (2 << 24);
         padwPhone[i+j] = dwVal;
      }
      
      // continue after the current changes
      i += dwLenInsert - 1;
   } // i

   return TRUE;
}

   
/*************************************************************************************
CMTTS::SynthWordMMLToPhones - This takes MML from the text parser's call
(such as ParseFromMMLText), then:

1) calls ParseAddPronunciation() just to make sure every word has a pronunciation.
      NOTE: This modifies the original MML
2) Goes through each "word" looking for a punctuation and adds the word to the
      phoneme.
3) If it finds a punctuation it adds silence.
4) Adds tags to indicate what the prosody should be

inputs
   PCMMLNode2         pNode - MML node from ParseFromMMLText() or ilk. This is modified
                              to add pronunciations
   DWORD             dwNodeStart - Where to start processing in this node. Initially pass
                        in 0, but on later passes, use last *pdwNodeEnd.
   PCListFixed       plPhone - Will be filled in with a list of phonemes (DWORD), with
                              high byte (<< 24) filled in indicating start, middle,
                              end of word
   PCListFixed       plWord - Initialized to sizeof (PWSTR). Filled in with list of
                              pointers to strings (the strings stored in plStrings).
                              These are the words/punctuation at each phoneme.
   PCListFixed       plMMLWord - Initialized to sizeof(PCMMLNode2). Filled in with the
                              node for the word for each phoneme. If a word has several
                              phonemes they all point to the same node.
   PCListFixed       plPhoneMod - Initialized to sizeof (CPoint). FIlled in with the
                              phone-specific [0]=pitch, [1]=vol, [2]=dur for each,
                              phoneme.
   PCListVariable    plString - Scratch space used to store the strings pointed to
                              by plWords. Don't delete until not using plWords anymore.
   PTTSGLOBALSTATE   pState - Filled with the initial speaking state
   PCListFixed       plTTSGLOBALSTATE - Initialized to sizeof (TTSGLOBALSTATE) and then
                     filled with one TTSGLOBALSTATE entry per phoneme, so know how fast
                     should speak, etc.
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL              fTransPros - Set this to TRUE if speaking transplanted prosody, and will
                     generate syllables more quickly since they info is likely to be thrown
                     out anyway
   DWORD                dwMultiPass - Pass number when generating several different versions of the
                        same sentence, and selecting the best one for TTS. Used to make the
                        random work better.
   DWORD             *pdwNodeEnd - Filled in with the node that got up to processing (exclusive).
                        Pass this into dwNodeStart to process rest of sentence.
returns
   BOOL - TRUE if success, FALSE if no more to produce
*/
BOOL CMTTS::SynthWordMMLToPhones (PCMMLNode2 pNode, DWORD dwNodeStart, PCListFixed plPhone, PCListFixed plWord,
                                  PCListFixed plMMLWord, PCListFixed plPhoneMod, PCListVariable plString,
                                  PTTSGLOBALSTATE pState, PCListFixed plTTSGLOBALSTATE,
                                  PTTSVOICEMOD pVoiceMod, int iTTSQuality, BOOL fTransPros, DWORD dwMultiPass,
                                  DWORD *pdwNodeEnd)
{
   *pdwNodeEnd = (DWORD)-1;   // so something set

   plPhone->Init (sizeof(DWORD));
   plPhoneMod->Init (sizeof(CPoint));
   plWord->Init (sizeof(PWSTR));
   plMMLWord->Init (sizeof(PCMMLNode2));
   plTTSGLOBALSTATE->Init (sizeof(TTSGLOBALSTATE));
   plString->Clear();

   // no-op phone mod
   CPoint pPhoneModNOP;
   pPhoneModNOP.Zero();
   pPhoneModNOP.p[0] = pPhoneModNOP.p[1] = pPhoneModNOP.p[2] = 1;

   // keep track of current state
   TTSGLOBALSTATE gsCur = *pState;

   PCMLexicon pLex = pVoiceMod->pLex;
   if (!pLex)
      pLex = Lexicon();
   if (!pLex)
      return FALSE;
   DWORD dwNumPhone = pLex->PhonemeNum();
   //DWORD dwNeedMicro = (dwNumPhone * dwNumPhone + 7) / 8;
   //BOOL fMicroPause = (m_memMicroPause.m_dwCurPosn == dwNeedMicro);
   BYTE bSilence = (BYTE) pLex->PhonemeFindUnsort(pLex->PhonemeSilence());

   // add the proncunaitions
   CTextParse TextParse;
   if (!TextParse.Init (pLex->LangIDGet(), pLex))
      return FALSE;

#ifdef _DEBUG
   DWORD dwStartTime = GetTickCount();
#endif
   if (!dwNodeStart) {
      // BUGFIX - Only add prounciations if the first time through
      if (!TextParse.ParseAddPronunciation (pNode, (iTTSQuality >= 4) ))   // random pronunciations if multipass
         return FALSE;
   }
#ifdef _DEBUG
   WCHAR szTemp[64];
   swprintf (szTemp, L"\r\nParseAddPronunciation time = %d", (int)(GetTickCount() - dwStartTime));
   OutputDebugStringW (szTemp);
   dwStartTime = GetTickCount();
#endif
   // BUGFIX - Moved the prosody from the bottom to the top since need it
   // to set the micropause flag
   // add prosody
   if (!SynthProsodyTagsApply (pNode, dwNodeStart, &TextParse, pVoiceMod, iTTSQuality, fTransPros, dwMultiPass, pdwNodeEnd))
      return FALSE;
#ifdef _DEBUG
   swprintf (szTemp, L"\r\nSynthProsodyTagsApply time = %d", (int)(GetTickCount() - dwStartTime));
   OutputDebugStringW (szTemp);
#endif

   // loop through all the elements in the node
   DWORD i, j;
   PWSTR psz;
   PCMMLNode2 pSub;
   BYTE abPron[256];
   DWORD dwSize;
   DWORD dwPhone;
   DWORD dwLastPhone = -1; // last phoneme added, for micropause info
   for (i = dwNodeStart /*0*/; i < *pdwNodeEnd /*pNode->ContentNum()*/; i++) {
      pSub = NULL;
      psz = NULL;
      pNode->ContentEnum (i, &psz, &pSub);
      if (!pSub)
         continue;   // ignore straight text

      // will need to deal with embedded tags of various sorts
      psz = pSub->NameGet();
      if (!psz)
         continue;

      if (!_wcsicmp(psz, gpszTTSGlobalState)) {
         // get the state
         GlobalStateFromMML (pSub, pVoiceMod->pSubVoice, &gsCur);
         continue;
      }
      else if (!_wcsicmp(psz, TextParse.Word())) {
         // get the pronunciation
         psz = pSub->AttribGetString (TextParse.Pronunciation());
         if (!psz)
            continue;

         // else convert to binary
         dwSize = (DWORD)MMLBinaryFromString (psz, abPron, sizeof(abPron));
         if (!dwSize || (dwSize > sizeof(abPron)))
            continue;   // either nothing there or too large

         // get the text
         psz = pSub->AttribGetString(TextParse.Text());
         if (psz) {
            plString->Add (psz, (wcslen(psz)+1)*sizeof(WCHAR));
            psz = (PWSTR) plString->Get(plString->Num()-1);
         }

         // see if want to add pause because of Ngram
         int iValue = 0;
         double fdPauseLeft, fDerMicropauses;
         if (!pSub->AttribGetDouble (gpszPauseLeft, &fdPauseLeft))
            fdPauseLeft = 0.0;
         if (!pSub->AttribGetDouble (gpszDerMicropauses, &fDerMicropauses))
            fDerMicropauses = 0.5;

         BYTE abPOS[(TTSPROSNGRAMBIT+TTSPROSNGRAM)*2+1];
         FindSurroundingPOS (&TextParse, pNode, dwNodeStart, *pdwNodeEnd, i, abPOS);  // need for phoneme duration tweaks

#if 0 // old code
         CPoint pNGram;
         BYTE abPOS[(TTSPROSNGRAMBIT+TTSPROSNGRAM)*2+1];
         BOOL fPauseLeft, fPauseNGram;
         won't work because changed to partial parse of pNode
         NGramFindBackoff (&TextParse, pNode, i, &pNGram, &fdPauseLeft, abPOS);
         fPauseNGram = fPauseLeft;
#endif // 0

         // consider adding a micropause
         if ((abPron[0] < dwNumPhone) && (dwLastPhone < dwNumPhone)) {
            DWORD adwPause[2];
            DWORD dwSubPros;
            adwPause[0] = adwPause[1] = 0;
            for (dwSubPros = 0; dwSubPros <= TTSVOICEMODMAXPROSODY; dwSubPros++) {
               PCTTSProsody pPros = (dwSubPros < TTSVOICEMODMAXPROSODY) ? pVoiceMod->apTTSProsody[dwSubPros] : m_pCTTSProsody;
               if (!pPros)
                  continue;

               DWORD *padw = pPros->PhonemePauseGet (dwLastPhone, abPron[0], FALSE, pLex);
               if (padw) {
                  adwPause[0] += padw[0];
                  adwPause[1] += padw[1];
               }
            }

            // if have data points then affect prosody
            if (adwPause[0] >= MINPROSODYSAMPLES) {
               double fPausePhone = (double)adwPause[1] / (double)adwPause[0];
               fPausePhone *= fPausePhone;
                  // HACK - So doesn't pause so much when speaking with my voice.
                  // not technically correct
               fdPauseLeft = fdPauseLeft + fPausePhone - fdPauseLeft * fPausePhone;
            }
         } // if phonemes in range

         // old code
         //if (fMicroPause && (abPron[0] < dwNumPhone) && (dwLastPhone < dwNumPhone)) {
         //   DWORD dwBit = dwLastPhone * dwNumPhone + (DWORD)abPron[0];
         //   PBYTE pb = (PBYTE)m_memMicroPause.p + (dwBit / 8);

         //   if (pb[0] & (1 << (dwBit % 8)))
         //      fPauseLeft = TRUE;
         //}

         // account for dermicropauses
         fdPauseLeft -= (fDerMicropauses - 0.5);
         //fdPauseLeft = pow (fdPauseLeft, pow (2, fDerMicropauses*2.0 - 1.0) );

         // BUGFIX - If flat set in TTS voice to halve pauses then do so
         // use for my voice because of the way I recorded it
         if (m_fPauseLessOften)
            fdPauseLeft /= 2.0;

         BOOL fPauseLeft = (randf(0, 1.0) < fdPauseLeft);
         BOOL fPauseNGram = fPauseLeft;

         // if thinking about adding micropause, don't do this if we have
         // a transplanted prosody word, which measn TPPitchRel, etc.
         if (fPauseLeft) {
            if (pSub->AttribGetString (gpszTPPitchRel))
               fPauseLeft = FALSE;
            else if (pSub->AttribGetString (gpszTPPitchAbs))
               fPauseLeft = FALSE;
            else if (pSub->AttribGetString (gpszTPVolRel))
               fPauseLeft = FALSE;
            else if (pSub->AttribGetString (gpszTPVolAbs))
               fPauseLeft = FALSE;
            else if (pSub->AttribGetString (gpszTPDurRel))
               fPauseLeft = FALSE;
            else if (pSub->AttribGetString (gpszTPDurAbs))
               fPauseLeft = FALSE;
         }


         // add micropauise
         if (fPauseLeft && (abPron[0] < dwNumPhone) && (dwLastPhone < dwNumPhone)) {
            PWSTR pszNull = NULL;
            PCMMLNode2 pNull = NULL;
            dwPhone = bSilence;

            // BUGFIX - Skip microsilences, since too much
#if 0
            plPhone->Add (&dwPhone);
            plPhoneMod->Add (&pPhoneModNOP);
            plWord->Add (&pszNull);
            plMMLWord->Add (&pNull);
            plTTSGLOBALSTATE->Add (&gsCur);
#endif

            // BUGFIX - if pausing for an ngram then add two pauses
            // BUGFIX - because skipping microsilence above, the ngram silence only
            // gets one silence unit, which seems to work quite well
            if (fPauseNGram) {
               plPhone->Add (&dwPhone);
               plPhoneMod->Add (&pPhoneModNOP);
               plWord->Add (&pszNull);
               plMMLWord->Add (&pNull);
               plTTSGLOBALSTATE->Add (&gsCur);
            }
         }

         // add all these phonemes
         for (j = 0; j < dwSize; j++) {
            dwPhone = dwLastPhone = abPron[j];
            if (j == 0)
               dwPhone |= (1 << 24);
            if (j+1 == dwSize)
               dwPhone |= (2 << 24);
            plPhone->Add (&dwPhone);
            plWord->Add (&psz);
            plMMLWord->Add (&pSub);
            plTTSGLOBALSTATE->Add (&gsCur);

            // adjustment based on location of phoneme in word
            BYTE bPOSL = abPOS[TTSPROSNGRAMBIT+TTSPROSNGRAM-1];
            BYTE bPOSR = abPOS[TTSPROSNGRAMBIT+TTSPROSNGRAM+1];
            bPOSL = min(bPOSL, PHONEPOSBIN-1);
            bPOSR = min(bPOSR, PHONEPOSBIN-1);

            DWORD dwIndexL = j;
            DWORD dwIndexR = dwSize - j - 1;
            BOOL fLeft = (dwIndexL < NUMPHONEEMPH);
            BOOL fRight = (dwIndexR < NUMPHONEEMPH);
            dwIndexR = 2 * NUMPHONEEMPH - dwIndexR - 1;
            CPoint pMod;

            if (fLeft && !fRight)
               pMod.Copy (&m_apPhoneEmph[dwIndexL][bPOSL]);
            else if (fRight && !fLeft)
               pMod.Copy (&m_apPhoneEmph[dwIndexR][bPOSR]);
            else if (fRight && fLeft) {
               // multiply and sqrt
               pMod.p[0] = sqrt(m_apPhoneEmph[dwIndexL][bPOSL].p[0] *
                  m_apPhoneEmph[dwIndexR][bPOSR].p[0]);
               pMod.p[1] = sqrt(m_apPhoneEmph[dwIndexL][bPOSL].p[1] *
                  m_apPhoneEmph[dwIndexR][bPOSR].p[1]);
               pMod.p[2] = sqrt(m_apPhoneEmph[dwIndexL][bPOSL].p[2] *
                  m_apPhoneEmph[dwIndexR][bPOSR].p[2]);
            }
            else
               pMod.Copy (&pPhoneModNOP);

            plPhoneMod->Add (&pMod);
         }

         continue;
      }
      else if (!_wcsicmp(psz, TextParse.Punctuation())) {
         // get the text
         psz = pSub->AttribGetString(TextParse.Text());
         if (psz) {
            plString->Add (psz, (wcslen(psz)+1)*sizeof(WCHAR));
            psz = (PWSTR) plString->Get(plString->Num()-1);
         }

         // put in silence pause for punctuation
         dwPhone = bSilence;
         plPhone->Add (&dwPhone);
         plPhoneMod->Add (&pPhoneModNOP);
         plWord->Add (&psz);
         plMMLWord->Add (&pSub);
         plTTSGLOBALSTATE->Add (&gsCur);

         // because adding silence, not that last phoneme is -1 so
         // dont add another silence for micropause
         dwLastPhone = -1;
         continue;
      }
      else if (!_wcsicmp(psz, gpszBreak)) {
         // if it's none then ignore
         psz = pSub->AttribGetString (gpszTime);
         if (psz && !_wcsicmp(psz, L"none"))
            continue;

         // put in silence pause for the break
         dwPhone = bSilence;
         psz = NULL;
         plPhone->Add (&dwPhone);
         plPhoneMod->Add (&pPhoneModNOP);
         plWord->Add (&psz);
         plMMLWord->Add (&pSub);
         plTTSGLOBALSTATE->Add (&gsCur);

         // because adding silence, not that last phoneme is -1 so
         // dont add another silence for micropause
         dwLastPhone = -1;
         continue;
      }
   } // i

   // add the accent
   if (!ApplyAccent (plPhone, plWord, plMMLWord, plPhoneMod, plTTSGLOBALSTATE, pVoiceMod))
      return FALSE;

   return TRUE;
}


/*************************************************************************************
CMTTS::SynthTextToWordMML - This converts from text (either tagged or not) into
the WordMML, which can then be passed into SynthWordMMLToPhones() to generate
all the phones to be spoken.

inputs
   PWSTR          pszText - Text to speak.
   BOOL           fTagged - If it's tagged then it's in MML format, else it's just
                     raw text.
   PCMLexicon        pLex - Lexicon to use. If not specified then will use default lexicon.
returns
   PCMMLNode2 - Node containing the information, which must be freed by the caller.
               Returns NULL if error
*/
PCMMLNode2 CMTTS::SynthTextToWordMML (PWSTR pszText, BOOL fTagged, PCMLexicon pLex)
{
   // convert
   CTextParse TextParse;
   if (!TextParse.Init (pLex->LangIDGet(), pLex))
      return NULL;
   PCMMLNode2 pNode = TextParse.MMLToPreParse (pszText, fTagged);
   if (!pNode)
      return NULL;

   return SynthMMLToWordMML (pNode, pLex);
}


/*************************************************************************************
CMTTS::SynthMMLToWordMML - This takes MML outputted from CTextParse::MMLToPreParse()
   and converts it to MML with words.

inputs
   PCMMLNOde2     pNode - MML to modify. This is modified in place.
   PCMLexicon        pLex - Lexicon to use. If not specified then will use default lexicon.
returns
   PCMMLNode2 - Node containing the information, which must be freed by the caller.
               Returns NULL if error. Will be pNode. If NULL then pNode is deleted
*/
PCMMLNode2 CMTTS::SynthMMLToWordMML (PCMMLNode2 pNode, PCMLexicon pLex)
{
   if (!pLex)
      pLex = Lexicon();
   if (!pLex)
      return NULL;

   // add the proncunaitions
   CTextParse TextParse;
   if (!TextParse.Init (pLex->LangIDGet(), pLex)) {
      delete pNode;
      return NULL;
   }

   if (!TextParse.ParseFromMML (pNode, FALSE, FALSE)) {
      delete pNode;
      return NULL;
   }

   return pNode;
}


/*************************************************************************************
CMTTS::FillInVOICEMOD - This internal function fills in a VOICEMOD structure with
the relevent information

inputs
   PTTSVOICEMOD      pVoiceMod - To be filled in
   PCMTTSSubVoice    pSubVoice - Sub voice to use. If NULL then uses the generic voice,
                        or, if this is a derived voice, the first choice
   PCTTSProsody      *papCTTSProsody - Pointer to an array of TTSVOICEMODMAXPROSODY prosody
                     elements that will be filled in as this makes the subvoice. Some
                     may be left NULL. Should initially be cleared.
                     This is only used if pSubVoice is set.
returns
   none
*/
void CMTTS::FillInVOICEMOD (PTTSVOICEMOD pVoiceMod, PCMTTSSubVoice pSubVoice, PCTTSProsody *papCTTSProsody)
{
   memset (pVoiceMod, 0, sizeof(*pVoiceMod));
   if (pSubVoice) {
      pVoiceMod->pSubVoice = pSubVoice;
      memcpy (pVoiceMod->apTTSProsody, papCTTSProsody, sizeof(pVoiceMod->apTTSProsody));
   }
   else if (m_lPCMTTSSubVoice.Num()) {
      PCMTTSSubVoice *ppsv = (PCMTTSSubVoice*) m_lPCMTTSSubVoice.Get(0);
      pVoiceMod->pSubVoice = ppsv[0];
      pVoiceMod->apTTSProsody[0] = pVoiceMod->pSubVoice->m_pCTTSProsody;
   }
   else {
      // make sure generic has the master's settings for pitch, wmp
      m_SubVoiceGeneric.m_fAvgPitch = m_pTTSMaster ? m_pTTSMaster->AvgPitchGet() : AvgPitchGet();
      //m_SubVoiceGeneric.m_fAvgSyllableDur = m_pTTSMaster ? m_pTTSMaster->AvgSyllableDurGet() : AvgSyllableDurGet();
      m_SubVoiceGeneric.m_dwWordsPerMinute = m_pTTSMaster ? m_pTTSMaster->WordsPerMinuteGet() : WordsPerMinuteGet();

      pVoiceMod->pSubVoice = &m_SubVoiceGeneric;
      // since generic dont bother
   }

   // if this is derived then fill in the main one too
   DWORD i;
   if (m_fIsDerived) for (i = 0; i < TTSVOICEMODMAXPROSODY; i++)
      if (!pVoiceMod->apTTSProsody[i]) {
         pVoiceMod->apTTSProsody[i] = m_pCTTSProsody;
         break;
      }

   pVoiceMod->pLex = pVoiceMod->pSubVoice->Lexicon(TRUE, this);

   // make sure sub-voice puitch and WPM are ok
   pVoiceMod->pSubVoice->m_fAvgPitch = max(pVoiceMod->pSubVoice->m_fAvgPitch,1);
   //pVoiceMod->pSubVoice->m_fAvgSyllableDur = max(pVoiceMod->pSubVoice->m_fAvgSyllableDur,0.01);
   pVoiceMod->pSubVoice->m_dwWordsPerMinute = max(pVoiceMod->pSubVoice->m_dwWordsPerMinute,1);
}


/*************************************************************************************
CMTTS::SpeakNodeSubDivideText - Sees if text should be broken off.

inputs
   PWSTR             pszText - Text.
returns
   DWORD - Index into text where make the cut. If 0 then accept the whole text and
      keep on going. If wcslen(pszText) then break at the end of the text.
*/
DWORD CMTTS::SpeakNodeSubDivideText (PWSTR pszText)
{
   // look through the string
   BOOL fFoundNonSpace = FALSE;
   BOOL fIsWSpace;
   DWORD i;
   for (i = 0; pszText[i]; i++) {
      // remember if found non-whitespace
      fIsWSpace = iswspace (pszText[i]);
      fFoundNonSpace |= !fIsWSpace;

      // look for periods, etc.
      switch (pszText[i]) {
         case L'\r':
         case L'\n':
            // if we haven't had non-whitespace text then keep
            // processing
            if (!fFoundNonSpace)
               continue;

            // else, found some characters, so break this as a newline
            break;   // same basic code as punctuatuon

         case L'.':
         case L'!':
         case L'?':
            // will need to skip future whitespace
            break;

         default:
            continue;   // nothing interesting
      } // swtich

      // if get here had some sort of punctuation
      // only care about periods if they occur and the end of a block or have whitespace
      // following them, AND they aren't an abbreviation
      if (pszText[i] == L'.') {
         if (pszText[i+1] && !iswspace(pszText[i+1]))
            continue;   // probably a period between numbers, or something

         // if nothing before this then don't look in lex
         if (!i)
            goto countasbreak;
         int iLook;
         for (iLook = (int)i-1; iLook >= 0; iLook--)
            if (iswspace(pszText[iLook]))
               break;
         iLook++;
         if (iLook >= (int)i)
            goto countasbreak;

         // make the string
         CMem mem;
         for (; iLook <= (int)i; iLook++)
            mem.CharCat (pszText[iLook]);
         mem.CharCat (0);

         // BUGBUG - make sure not abbreviation
         PCMLexicon pLex = Lexicon();
         if (pLex && pLex->WordExists ((PWSTR)mem.p))
            continue;   // abbreviation, so don't stop here
      } // if period

countasbreak:
      // get rid of whitespace after this
      i++;
      for (; pszText[i] && iswspace(pszText[i]); i++);
      return i;
   } // i

   // if get here, then accept the entire text
   return 0;
}

/*************************************************************************************
CMTTS::SpeakNodeSubDivide - Subdivide the pNode passed into.

inputs
   PCMMLNode2        pNode - Original node, to clone (or partly clone)
   PCMMLNode2        pAppendTo - Append the results to this, as sub-node. This can be NULL, in which
      case a new node is created and filled into *ppClone.
   PCMMLNode2        *ppClone - Where clone of pNode is written into, in case caller cares.
                     Can be NULL.
   BOOL              *pfFoundContent - Originally pass in FALSE. Will be set to TRUE
                     if any of the searches found content.
returns
   BOOL - TRUE if should keep processing further. FALSE if came to a break in the text
      and have finished one pass
*/
BOOL CMTTS::SpeakNodeSubDivide (PCMMLNode2 pNode, PCMMLNode2 pAppendTo,
                                PCMMLNode2 *ppClone, BOOL *pfFoundContent)
{
   // assuming that if this method is called, the header is neutral
   PCMMLNode2 pClone = pNode->CloneHeader ();
   if (ppClone)
      *ppClone = pClone;
   if (!pClone)
      return FALSE;  // shouldnt happen
   if (pAppendTo)
      pAppendTo->ContentAdd (pClone);  // so it's on the add-to list

   // loop through all the children
   DWORD i;
   PWSTR psz;
   PCMMLNode2 pSub, pSubClone;
   BOOL fRet;
   CMem mem;
   for (i = 0; i < pNode->ContentNum(); i++) {
      if (!pNode->ContentEnum (i, &psz, &pSub))
         return TRUE;   // end of list

      // if have string, see how far get with it
      if (psz) {
         // found something that changes the output
         *pfFoundContent = TRUE;

         DWORD dwDivide = SpeakNodeSubDivideText(psz);
         DWORD dwLen = (DWORD) wcslen(psz);

         if (!dwDivide || (dwDivide >= dwLen)) {
            // entire text gets moved to copy.
            pClone->ContentAdd (psz);
            pNode->ContentRemove (i);
            i--;

            // see if came to breaking point and want to stop this
            // partial cloning
            if (dwDivide >= dwLen)
               return FALSE;

            // else, not a breaking point (end of sentence) so go further
            continue;
         }
         // else (dwDivide < dwLen)

         // add the first part to the clone
         MemZero (&mem);   // need to make copy to make sure memory not rewritten
         MemCat (&mem, psz);
         psz = (PWSTR)mem.p;
         WCHAR cTemp = psz[dwDivide];
         psz[dwDivide] = 0;
         pClone->ContentAdd (psz);
         psz[dwDivide] = cTemp;

         // remove the first part from this
         pNode->ContentInsert (i+1, psz + dwDivide);  // second half of this string
         pNode->ContentRemove (i);  // remove entire version of this string

         // need to process to here
         return FALSE;
      } // if text

      if (!pSub)
         continue;   // shouldn't happen
      psz = pSub->NameGet();
      if (!psz)
         continue;   // shouldn't happen

      // some nodes are copied entirely
      if (!_wcsicmp(psz, gpszBreak) || !_wcsicmp(psz, gpszTransPros) || !_wcsicmp(psz, gpszTTSWave)) {
         // found something that changes the output
         *pfFoundContent = TRUE;

         pNode->ContentRemove (i, FALSE);
         pClone->ContentAdd (pSub);
         i--;

         continue;   // keep processing after a break
      }
      else if (!_wcsicmp(psz, gpszTransPros) || !_wcsicmp(psz, gpszTTSWave)) {
         // found something that changes the output
         *pfFoundContent = TRUE;

         pNode->ContentRemove (i, FALSE);
         pClone->ContentAdd (pSub);
         i--;

         return FALSE;  // stop processing
      }
      else if (!_wcsicmp(psz, gpszSubVoice)) {
         // this affects everything after this, so clone into copy, but also keep
         // in original

         // if already have stuff to speak, and get a sub-voice message then done
         if (*pfFoundContent)
            return FALSE;

         // see if any other subvoices appear in the list. If they done, then erase them
         DWORD j;
         for (j = 0; j < pClone->ContentNum(); j++) {
            pSubClone = NULL;
            pClone->ContentEnum (j, &psz, &pSubClone);

            if (!pSubClone)
               continue;
            psz = pSubClone->NameGet();
            if (_wcsicmp(psz, gpszSubVoice))
               continue;   // not a sub-voice

            // else, it's a sub-voice, so remove
            pClone->ContentRemove (j);
            j--;
         } // j

         // clone this and add
         pSubClone = pSub->Clone();
         if (pSubClone)
            pClone->ContentAdd (pSubClone);

         continue;
      }
      // else
      // default behavior is to parse inside
      // <emotion>, <emphasis>, <prosody>, <phoneme>, <POS>

      // if there's nothing inside then delete these
      if (!pSub->ContentNum()) {
         pNode->ContentRemove (i);
         i--;
         continue;
      }

      fRet = SpeakNodeSubDivide (pSub, pClone, NULL, pfFoundContent);
      if (!fRet)
         return FALSE;  // found break within sub-tag, so continue that up

      // if get here, have "consumed" this node, so delete it
      pNode->ContentRemove (i);
      i--;
      // continue;
   } // i, over content

   // if get here, should keep processing further
   return TRUE;
}


/*************************************************************************************
CMTTS::SynthGenWaveNode - This is the main "speak" call that most apps will use.

inputs
   DWORD          dwSamplesPerSec - Samples per sec to produce for output
   PCMMLNode2     pNode - MML from TextParse::MMLToPreParse(). This may be modified
                  in place, and is ultimatele DELETED by this function.
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL              fDisablePCM - If TRUE, then PCM is disabled for speakin.
   PCProgressSocket pProgress - To show percent done
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
   PCProgressWaveTTS pProgressWave - This is the callback to paste the audio into.
returns
   BOOL - TRUE if success
*/
BOOL CMTTS::SynthGenWaveNode (DWORD dwSamplesPerSec, PCMMLNode2 pNode, int iTTSQuality, BOOL fDisablePCM,
                          PCProgressSocket pProgress, PTTSVOICEMOD pVoiceMod,
                          PCProgressWaveTTS pProgressWave)
{
   CListFixed lNodes;
   lNodes.Init (sizeof(PCMMLNode2));

   // pull out bits at a time and process those
   PCMMLNode2 pClone;
   BOOL fFoundContent, fRet;
   while (TRUE) {
      // start out with someplace to put copy
      fFoundContent = FALSE;
      pClone = NULL;
      fRet = SpeakNodeSubDivide (pNode, NULL, &pClone, &fFoundContent);

      // if found content, add clone
      if (fFoundContent && pClone)
         lNodes.Add (&pClone);
      else {
         // delete the clone since didn't amount to anything
         if (pClone)
            delete pClone;

         // since nothing found, stop
         break;
      }
   } // while (TRUE)

   // done with the original node
   delete pNode;

   // loop through all the chunks and synthesize them
   DWORD i;
   PCMMLNode2 *ppNode = (PCMMLNode2*)lNodes.Get(0);
   fRet = TRUE;
   for (i = 0; i < lNodes.Num(); i++, ppNode++) {
      if (pProgress)
         pProgress->Push ((fp)i / (fp)lNodes.Num(), (fp)(i+1) / (fp)lNodes.Num());

#ifdef _DEBUG
      CMem mem;
      mem.m_dwCurPosn = 0;
      if (MMLToMem (*ppNode, &mem)) {
         mem.CharCat (0);
         OutputDebugStringW (L"\r\nSub-string: ");
         OutputDebugStringW ((PWSTR)mem.p);
      }
#endif


      fRet = SynthGenWaveWithProgress (dwSamplesPerSec, *ppNode, iTTSQuality, fDisablePCM,
         pProgress, pVoiceMod, pProgressWave);
      *ppNode = NULL;

      if (pProgress)
         pProgress->Pop();

      if (!fRet)
         break;
   } // i, lNodes.Num()

   // delete all the nodes
   ppNode = (PCMMLNode2*)lNodes.Get(0);
   for (i = 0; i < lNodes.Num(); i++)
      if (ppNode[i])
         delete ppNode[i];

   return fRet;
}

/*************************************************************************************
CMTTS::SynthGenWaveWithProgress - This is the main "speak" call that most apps will use.

inputs
   DWORD          dwSamplesPerSec - Sampling rate
   PCMMLNode2     pNode - MML from TextParse::MMLToPreParse(). This may be modified
                  in place, and is ultimatele DELETED by this function.
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL              fDisablePCM - If TRUE, then PCM is disabled for speakin.
   PCProgressSocket pProgress - To show percent done
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
   PCProgressWaveTTS pProgressWave - This is the callback to paste the audio into.
returns
   BOOL - TRUE if success
*/
BOOL CMTTS::SynthGenWaveWithProgress (DWORD dwSamplesPerSec, PCMMLNode2 pNode, int iTTSQuality, BOOL fDisablePCM,
                          PCProgressSocket pProgress, PTTSVOICEMOD pVoiceMod,
                          PCProgressWaveTTS pProgressWave)
{

   TTSVOICEMOD VM;
   BOOL fRet = FALSE;

   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster) {
         delete pNode;
         return FALSE;
      }

      // potentially fill in voice mod with a mix
      PCMMLNode2 pSubVoiceNode = pVoiceMod ? NULL : FindSubVoice (pNode);
      BOOL fMustDelete = FALSE;
      PCTTSProsody apTTSProsody[TTSVOICEMODMAXPROSODY];
      memset (apTTSProsody, 0, sizeof(apTTSProsody));
      PCMTTSSubVoice pSubVoice = pSubVoiceNode ? MakeSubVoice (pSubVoiceNode, &fMustDelete, apTTSProsody) : NULL;
      if (pSubVoice) {
         // created a sub-voce, and only did that if no voice mod already
         pVoiceMod = &VM;
         FillInVOICEMOD (pVoiceMod, pSubVoice, apTTSProsody);
      }

      fRet = m_pTTSMaster->SynthGenWaveWithProgress (dwSamplesPerSec, pNode, iTTSQuality, fDisablePCM, pProgress, pVoiceMod,
         pProgressWave);

      if (fMustDelete)
         delete pSubVoice;

      return fRet;
   }

#ifdef _DEBUG
   DWORD dwTimeCur, dwTimeStart = GetTickCount();
   WCHAR szTemp[128];
#endif

   if (!pVoiceMod) {
      pVoiceMod = &VM;
      FillInVOICEMOD (pVoiceMod, NULL, NULL);
   }

   DWORD dwCandidates = (iTTSQuality >= 4) ? MAXSYNGENFEATURESCANDIDATES : 1;   // multipass if very high quality
   DWORD dwCand;
   DWORD i;
   dwCandidates = min(dwCandidates, MAXSYNGENFEATURESCANDIDATES);
   PCMMLNode2 apNode[MAXSYNGENFEATURESCANDIDATES];
   SYNGENFEATURESCANDIDATE aCandidates[MAXSYNGENFEATURESCANDIDATES];
   memset (apNode, 0, sizeof(apNode));
   memset (aCandidates, 0, sizeof(aCandidates));
   apNode[0] = pNode;

   TTSGLOBALSTATE aState[MAXSYNGENFEATURESCANDIDATES];
   CListFixed alPhone[MAXSYNGENFEATURESCANDIDATES], alWord[MAXSYNGENFEATURESCANDIDATES];
   CListFixed alMMLWord[MAXSYNGENFEATURESCANDIDATES], alTTSGLOBALSTATE[MAXSYNGENFEATURESCANDIDATES], alPhoneMod[MAXSYNGENFEATURESCANDIDATES];
   CListVariable alString[MAXSYNGENFEATURESCANDIDATES];
   CListFixed alDur[MAXSYNGENFEATURESCANDIDATES], alVol[MAXSYNGENFEATURESCANDIDATES];
   CListVariable alPitch[MAXSYNGENFEATURESCANDIDATES];
   BOOL afAbsPitch[MAXSYNGENFEATURESCANDIDATES];

   // need to fill in information for all the candidates, by filling in the first one
   // and cloning to make entries for the candidates
   apNode[0] = SynthMMLToWordMML (apNode[0], pVoiceMod->pLex);
   if (!apNode[0])
      goto done;

   #ifdef _DEBUG
      dwTimeCur = GetTickCount();
      swprintf (szTemp, L"\r\nSynthMMLToWordMML = %d ms", (int)(dwTimeCur - dwTimeStart));
      dwTimeStart = dwTimeCur;
      OutputDebugStringW (szTemp);
   #endif

   // convert some tags
   memset (&aState[0], 0 ,sizeof(aState[0]));
   aState[0].fProsodyAvgPitch = pVoiceMod->pSubVoice->m_fAvgPitch;
   //aState[0].fProsodyAvgSyllableDur = pVoiceMod->pSubVoice->m_fAvgSyllableDur;
   aState[0].fProsodyPitchExpress = 1;
   aState[0].fProsodyVol = 1;
   aState[0].fProsodyWPM = pVoiceMod->pSubVoice->m_dwWordsPerMinute;
   // leave emotions at 0
   // will need to fill in derviced values
   GlobalStateFromMML (NULL, pVoiceMod->pSubVoice, &aState[0]);

   BOOL fTransPros = FALSE;

   if (!SynthTextInterpretTags (apNode[0], &aState[0], pVoiceMod, &fTransPros))
      goto done;

#ifdef _DEBUG
   dwTimeCur = GetTickCount();
   swprintf (szTemp, L"\r\nSynthTextInterpretTags = %d ms", (int)(dwTimeCur - dwTimeStart));
   dwTimeStart = dwTimeCur;
   OutputDebugStringW (szTemp);
#endif
   
   // make copies of the other candidates
   // copy to candidates
   for (dwCand = 1; dwCand < dwCandidates; dwCand++) {
      apNode[dwCand] = apNode[0]->Clone();
      if (!apNode[dwCand])
         goto done;

      aState[dwCand] = aState[0];
   }


   // loop over all nodes
   DWORD dwNodeStart, dwNodeEnd;
   for (dwNodeStart = 0; TRUE /*dwNodeStart < apNode[0]->ContentNum()*/; dwNodeStart = dwNodeEnd) {


      for (dwCand = 0; dwCand < dwCandidates; dwCand++) {

         // clear out the lists
         alPhone[dwCand].Clear();
         alWord[dwCand].Clear();
         alMMLWord[dwCand].Clear();
         alTTSGLOBALSTATE[dwCand].Clear();
         alPhoneMod[dwCand].Clear();
         alString[dwCand].Clear();
         alDur[dwCand].Clear();
         alVol[dwCand].Clear();
         alPitch[dwCand].Clear();
         afAbsPitch[dwCand] = FALSE;

         // get phonemes
         DWORD dwNodeEndNew;
         if (!SynthWordMMLToPhones (apNode[dwCand], dwNodeStart, &alPhone[dwCand], &alWord[dwCand], &alMMLWord[dwCand], &alPhoneMod[dwCand],
            &alString[dwCand], &aState[dwCand], &alTTSGLOBALSTATE[dwCand], pVoiceMod, iTTSQuality, fTransPros, dwCand,
            dwCand ? &dwNodeEndNew : &dwNodeEnd)) {
            // error

            // if this is in candidate 0, then it's because there's nothing more to produce anywhere, so
            // just break
            if (!dwCand)
               break;

            // else, something bad happened
            goto done;
         }
         if (dwCand && (dwNodeEndNew != dwNodeEnd))
            goto done;

      #ifdef _DEBUG
         dwTimeCur = GetTickCount();
         swprintf (szTemp, L"\r\nSynthWordMMLToPhones = %d ms", (int)(dwTimeCur - dwTimeStart));
         dwTimeStart = dwTimeCur;
         OutputDebugStringW (szTemp);
      #endif

         // synthesize prosody
         if (!SynthArtificialProsody ((DWORD*)alPhone[dwCand].Get(0), (PWSTR*)alWord[dwCand].Get(0),
            (PCMMLNode2*)alMMLWord[dwCand].Get(0), (PCPoint)alPhoneMod[dwCand].Get(0), (PTTSGLOBALSTATE) alTTSGLOBALSTATE[dwCand].Get(0),
            alPhone[dwCand].Num(), &alDur[dwCand], &alPitch[dwCand], &alVol[dwCand], pVoiceMod, fDisablePCM, &afAbsPitch[dwCand]))

               goto done;

      #ifdef _DEBUG
         dwTimeCur = GetTickCount();
         swprintf (szTemp, L"\r\nSynthArtificialProsody = %d ms", (int)(dwTimeCur - dwTimeStart));
         dwTimeStart = dwTimeCur;
         OutputDebugStringW (szTemp);
      #endif

      #if 0 // to test
      #ifdef _DEBUG
         FILE *file = fopen("c:\\pros.txt", "wt");
      #else
         FILE *file = fopen("c:\\prosr.txt", "wt");
      #endif
         DWORD i, j;
         for (i = 0; i < alPhone[dwCand].Num(); i++) {
            fprintf (file, "\r\nPhone %d : %x, %d, %.3g; ",
               (DWORD) i, *((DWORD*)alPhone[dwCand].Get(i)), *((DWORD*)alDur[dwCand].Get(i)), (double) *((fp*)lVol.Get(i)));

            fp *paf = (fp*)lPitch.Get(i);
            DWORD dwNum = lPitch.Size(i) / sizeof(DWORD);
            for (j = 0; j < dwNum; j++)
               fprintf (file, "%.3g ", (double)paf[j]);
         } // i
         fclose (file);
      #endif // 0

         // remember values
         aCandidates[dwCand].dwNum = alPhone[dwCand].Num();
         aCandidates[dwCand].fAbsPitch = afAbsPitch[dwCand];
         aCandidates[dwCand].fVolAbsolute = FALSE;
         aCandidates[dwCand].padwDur = (DWORD*)alDur[dwCand].Get(0);
         aCandidates[dwCand].padwPhone = (DWORD*)alPhone[dwCand].Get(0);
         aCandidates[dwCand].pafVol = (fp*)alVol[dwCand].Get(0);
         aCandidates[dwCand].papszWord = (PWSTR*)alWord[dwCand].Get(0);
         aCandidates[dwCand].paTTSGS = (PTTSGLOBALSTATE) alTTSGLOBALSTATE[dwCand].Get(0);
         aCandidates[dwCand].plPitch = &alPitch[dwCand];
         // intentionally not setting aCandidates[dwCand].padwWord
      } // dwCand

      // if got to the end of the data then stop
      if (dwCand < dwCandidates)
         break;

      // generate the wave
      if (pProgress)
         pProgress->Push ((fp)dwNodeStart / (fp)apNode[0]->ContentNum(),
            (fp)dwNodeEnd / (fp)apNode[0]->ContentNum());

      if (!SynthGenWaveInt (dwCandidates, aCandidates, dwSamplesPerSec, iTTSQuality, fDisablePCM, pProgress, pVoiceMod, pProgressWave)) {
         if (pProgress)
            pProgress->Pop();
         goto done;
      }
      if (pProgress)
         pProgress->Pop();
   } // dwNodeStart

   // if got here then good
   fRet = TRUE;

done:
   // delete all the nodes
   for (i = 0; i < dwCandidates; i++)
      if (apNode[i]) delete apNode[i];
   return fRet;

}





/*************************************************************************************
CMTTS::SynthGenWave - This is the main "speak" call that most apps will use.

inputs
   PCM3DWave      pWave - Wave to generate to. This can be NULL, but then pProgressWave must be set.
   DWORD          dwSamplesPerSec - Sampling rate.
   PWSTR          pszText - Text to speak.
   BOOL           fTagged - If it's tagged then it's in MML format, else it's just
                     raw text.
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL              fDisablePCM - If TRUE, then PCM is disabled for speakin.
   PCProgressSocket pProgress - To show percent done
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
   PCProgressWaveTTS pProgressWave - Wave callpack. This must be NULL if pWave is not NULL.
returns
   BOOL - TRUE if success
*/
BOOL CMTTS::SynthGenWave (PCM3DWave pWave, DWORD dwSamplesPerSec, PWSTR pszText, BOOL fTagged, int iTTSQuality, BOOL fDisablePCM,
                          PCProgressSocket pProgress, PTTSVOICEMOD pVoiceMod,
                          PCProgressWaveTTS pProgressWave)
{
#ifdef TURNOFFRANDOM
   srand (0); // hack to always get the same results
   WordRankHistory(NULL);  // to clear for test
#endif // _DEBUG

#ifdef _DEBUG
   DWORD dwTimeStart = GetTickCount();
#endif

   if (!pProgressWave && !pWave)
      return FALSE;
   if (pWave && (pWave->m_dwSamplesPerSec != dwSamplesPerSec))
      return FALSE;

   // deal with NULL pProgressWave
   PCProgressWaveTTSToWave pToWave = NULL;
   if (pWave) {
      pToWave = new CProgressWaveTTSToWave;
      if (!pToWave)
         return FALSE;
      pToWave->m_pWave = pWave;
      pWave->BlankWaveToSize (0, TRUE);   // make sure empty
   }

   // convert the text to MML
   // convert
   CTextParse TextParse;
   PCMLexicon pLex = Lexicon();
   if (!TextParse.Init (pLex->LangIDGet(), pLex)) {
      if (pToWave)
         delete pToWave;
      return FALSE;
   }

   PCMMLNode2 pNode = TextParse.MMLToPreParse (pszText, fTagged);
   if (!pNode) {
      if (pToWave)
         delete pToWave;
      return FALSE;
   }

   // speak
   BOOL fRet = SynthGenWaveNode (dwSamplesPerSec, pNode, iTTSQuality, fDisablePCM, pProgress, pVoiceMod,
      pProgressWave ? pProgressWave : pToWave);

   if (pToWave)
      delete pToWave;

#ifdef _DEBUG
   DWORD dwTimeCur = GetTickCount();
   WCHAR szTemp[64];
   swprintf (szTemp, L"\r\nSynthGenWave = %d ms", (int)(dwTimeCur - dwTimeStart));
   dwTimeStart = dwTimeCur;
   OutputDebugStringW (szTemp);
#endif

   // delete text
   // dont delete since already deleted delete pNode;
   return fRet;
}

/****************************************************************************
FindAdjacentWord - Looks through the PCMMLNode2 and looks for a word (or punct) to
the left/right of the current word. If another tag is there it keeps moving
until it finds a match of the end of the data.

inputs
   PCTextParse       pParse - Text parse to use to identify word/punctuation
   PCMMLNode2         pNode; - Node to look through
   DWORD       dwNodeStart - Node where sentence starts. Before that is assumed to be out of sentence
   DWORD       dwNodeEnd - Node where sentnece ends (exclusive). At and after is not included
   BOOL              fRight - If TRUE looking to the right, else left
   BOOL              fPunct - If TRUE accept words of punctuation. If FALSE only words
   DWORD             *pdwCurLoc - This should be filled with the current location (element
                        in pNode). It will be incremented by the function
   PWSTR             *ppszText - If an element is found, this points to the text attribute of it
   BOOL              *pfIsPunct - If an element is found, filled with true if it's punctuation,
                        FALSE if its a word
   BYTE              *pbPOS - Filled in with the part of speech
returns
   BOOL - TRUE if found element, FALSE if went beyond edge
*/
static BOOL FindAdjacentWord (PCTextParse pParse, PCMMLNode2 pNode, DWORD dwNodeStart, DWORD dwNodeEnd, BOOL fRight,
                              BOOL fPunct, DWORD *pdwCurLoc, PWSTR *ppszText, BOOL *pfIsPunct,
                              BYTE *pbPOS = NULL)
{
   for (;; pdwCurLoc[0]++) {
      int iNext = (int)(*pdwCurLoc) + (fRight ? 1 : -1);
      if (iNext < (int)dwNodeStart)
         return FALSE;
      if (iNext >= (int)dwNodeEnd /*pNode->ContentNum()*/)
         return FALSE;

      // get the element
      PWSTR psz;
      PCMMLNode2 pSub;
      pSub = NULL;
      pNode->ContentEnum ((DWORD)iNext, &psz, &pSub);
      if (!pSub)
         continue;

      // get name
      psz = pSub->NameGet();
      if (!psz)
         continue;

      if (!_wcsicmp(psz, pParse->Word())) {
         psz = pSub->AttribGetString(pParse->Text());
         if (!psz)
            continue;   // word, but dont know what it is so ignore

         *ppszText = psz;
         *pfIsPunct = FALSE;

         // pos
         if (pbPOS) {
            psz = pSub->AttribGetString(pParse->POS());
            if (psz)
               pbPOS[0] = (BYTE)_wtoi(psz);
            else
               pbPOS[0] = 0;
         }
         pdwCurLoc[0] = (DWORD)iNext;   // BUGFIX - Increase pointer to next slot
         return TRUE;
      }
      else if (fPunct && !_wcsicmp(psz, pParse->Punctuation())) {
         psz = pSub->AttribGetString(pParse->Text());
         if (!psz)
            continue;   // word, but dont know what it is so ignore

         *ppszText = psz;
         *pfIsPunct = TRUE;
         if (pbPOS)
            *pbPOS = 0; // since punct
         pdwCurLoc[0] = (DWORD)iNext;   // BUGFIX - Increase pointer to next slot
         return TRUE;
      }
   }
}


#if 0 // old prosody

/*************************************************************************************
CMTTS::NGramFind - Given a pointer to an array of bytes (indicating the POS numbers
for the Ngram), this finds a pointer to the ngram. If it doesn't find one with data
it returns NULL.

inputs
   PBYTE       pabPOS - Pointer to an array of (TTSPROSNGRAMBIT+TTSPROSNGRAM)*2+1 POS. TTSPROSNGRAM+TTSPROSNGRAMBIT
                     is the center word
returns
   PTTSNGRAM - Ngram, or NULL if the Ngram doesn't have any relevent info
*/
PTTSNGRAM CMTTS::NGramFind (PBYTE pabPOS)
{
   // if no data then error
   if (!m_memNGram.m_dwCurPosn)
      return NULL;

   // what's the number
   DWORD dwBin = 0;
   DWORD i;
   for (i = 0; i < (TTSPROSNGRAM+TTSPROSNGRAMBIT)*2+1; i++) {
      if (!i || (i == (TTSPROSNGRAMBIT+TTSPROSNGRAM)*2)) {
         // trigram at very start or end, only care about unknown, word, or punctuation
         dwBin *= 3;
         if (!pabPOS[i])
            dwBin += 0;
         else if (pabPOS[i] == POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION))
            dwBin += 2;
         else
            dwBin += 1;
      }
      else {
         // main trigram
         dwBin *= (POS_MAJOR_NUM+1);
         dwBin += pabPOS[i];
      }
   }

   // get
   PTTSNGRAM png = (PTTSNGRAM)m_memNGram.p;
   png += dwBin;

   return png->bPitch ? png : NULL;
}

/*************************************************************************************
CMTTS::NGramFindBackoff - Given a pointer to an array of bytes (indicating the POS numbers
for the Ngram), this finds a pointer to the ngram. If it doesn't find one with data
it returns NULL.

This handles the backoff case.

inputs
   PBYTE       pabPOS - Pointer to an array of (TTSPROSNGRAMBIT+TTSPROSNGRAM)*2+1 POS.
                     TTSPROSNGRAMBIT+TTSPROSNGRAM
                     is the center word. NOTE: This data is modified in place as
                     it backoff.
   PCPoint     pPros - Filled with the prosody information for pitch, duration, and volume.
   BOOL        *pfPauseLeft - Filled with TRUE if should pause to the left because of the
                     N-gram.
*/
void CMTTS::NGramFindBackoff (PBYTE pabPOS, PCPoint pPros, BOOL *pfPauseLeft)
{
   // blank out just in case
   *pfPauseLeft = FALSE;
   pPros->p[0] = pPros->p[1] = pPros->p[2] = 1;

   PTTSNGRAM p1, p2;
   BYTE bTemp;
   p1 = p2 = NULL;

   DWORD i;
   for (i = TTSPROSNGRAM+TTSPROSNGRAMBIT; i <= TTSPROSNGRAM+TTSPROSNGRAMBIT; i--) {
      // find an exact match
      p1 = NGramFind (pabPOS);
      p2 = NULL;
      if (p1)
         break;

      // if on last straw and cant find one then just exit because nothing left
      if (i == 0)
         return;

      // try cutting out from the left or right
      bTemp = pabPOS[TTSPROSNGRAM+TTSPROSNGRAMBIT - i];
      pabPOS[TTSPROSNGRAM+TTSPROSNGRAMBIT - i] = 0; // to indicate backoff
      p1 = NGramFind (pabPOS);

      pabPOS[TTSPROSNGRAM+TTSPROSNGRAMBIT - i] = bTemp; // restore
      bTemp = pabPOS[TTSPROSNGRAM+TTSPROSNGRAMBIT + i];
      pabPOS[TTSPROSNGRAM+TTSPROSNGRAMBIT + i] = 0; // to indicate backoff
      p2 = NGramFind (pabPOS);
#ifdef _DEBUG
      pabPOS[TTSPROSNGRAM+TTSPROSNGRAMBIT + i] = bTemp; // restore
#endif
      if (p1 || p2)
         break;

      // wipe out since failed
      pabPOS[TTSPROSNGRAM+TTSPROSNGRAMBIT - i] = pabPOS[TTSPROSNGRAM+TTSPROSNGRAMBIT + i] = 0;
   }
   if (!p1 && !p2)
      return;

   // get the two weights
   CPoint w1, w2;
#ifdef _DEBUG
   char szTemp[256];
   WCHAR szwTemp[256];
   PWSTR paszPOS[POS_MAJOR_NUM+1] = {L"UNK", L"noun", L"pron", L"adj", L"prep", L"art",
      L"verb", L"adv", L"aux v", L"conj", L"inter", L"PUNCT"};

   szwTemp[0] = 0;
   for (i = 0; i < (TTSPROSNGRAM+TTSPROSNGRAMBIT)*2+1; i++) {
      if (i)
         wcscat (szwTemp, L" ");
      wcscat (szwTemp, paszPOS[pabPOS[i]]);
   }
   wcscat (szwTemp, L"\r\n");
   WideCharToMultiByte (CP_ACP, 0, szwTemp, -1, szTemp, sizeof(szTemp), 0, 0);
   OutputDebugString (szTemp);
#endif
   if (p1) {
      w1.p[0] = (fp)p1->bPitch / 100.0;
      w1.p[1] = (fp)p1->bVol / 100.0;
      w1.p[2] = (fp)p1->bDur / 100.0;

      if (p1->bFlags & 0x01)
         *pfPauseLeft = TRUE;
   }
   if (p2) {
      w2.p[0] = (fp)p2->bPitch / 100.0;
      w2.p[1] = (fp)p2->bVol / 100.0;
      w2.p[2] = (fp)p2->bDur / 100.0;

      if (p2->bFlags & 0x01)
         *pfPauseLeft = TRUE;
   }

   if (p1 && p2) {
      pPros->p[0] = sqrt(w1.p[0]) * sqrt(w2.p[0]);
      pPros->p[1] = sqrt(w1.p[1]) * sqrt(w2.p[1]);
      pPros->p[2] = sqrt(w1.p[2]) * sqrt(w2.p[2]);
#ifdef _DEBUG
   OutputDebugString ("\tCombi\r\n");
#endif
   }
   else if (p1) {
      pPros->Copy (&w1);

#ifdef _DEBUG
   OutputDebugString ("\tLeft or all\r\n");
#endif
   }
   else if (p2) {
      pPros->Copy (&w2);
#ifdef _DEBUG
   OutputDebugString ("\tRight\r\n");
#endif
   }

}


/*************************************************************************************
CMTTS::NGramFindBackoff - Finds the NGram information for the given word

This handles the backoff case.

inputs
   PCTextParse pParse - Text parser
   PCMMLNode2   pNode - Root node for the sentence being spoken
   DWORD       dwIndex - Index into pNode that's the current word
   PCPoint     pPros - Filled with the prosody information for pitch, duration, and volume.
   BOOL        *pfPauseLeft - Filled with TRUE if should pause to the left because of the
                     N-gram.
   BYTE        *pabPOS - If no NULL, (TTSPROSNGRAMBIT+TTSPROSNGRAM)*2+1 are copied to pabPOS with
                     the parts of speech for the surrounding words.
*/
void CMTTS::NGramFindBackoff (PCTextParse pParse, PCMMLNode2 pNode,
                              DWORD dwIndex, PCPoint pPros, BOOL *pfPauseLeft,
                              BYTE *pabPOS)
{
   // zero out info in case
   pPros->p[0] = pPros->p[1] = pPros->p[2] = 1;
   *pfPauseLeft = FALSE;

   BYTE abPOS[(TTSPROSNGRAM+TTSPROSNGRAMBIT)*2+1];
   if (!FindSurroundingPOS (pParse, pNode, dwIndex, abPOS))
      return;

   if (pabPOS)
      memcpy (pabPOS, abPOS, sizeof(abPOS));

   // determine the Ngram score
   NGramFindBackoff (abPOS, pPros, pfPauseLeft);
}
#endif // 0, old prosody


/*************************************************************************************
CMTTS::FindSurroundingPOS - Finds the surrounding POS.

This handles the backoff case.

inputs
   PCTextParse pParse - Text parser
   PCMMLNode2   pNode - Root node for the sentence being spoken
   DWORD       dwNodeStart - Node where sentence starts. Before that is assumed to be out of sentence
   DWORD       dwNodeEnd - Node where sentnece ends (exclusive). At and after is not included
   DWORD       dwIndex - Index into pNode that's the current word
   BYTE        *pabPOS - (TTSPROSNGRAMBIT+TTSPROSNGRAM)*2+1 are copied to pabPOS with
                     the parts of speech for the surrounding words.
returns
   BOOL - TRUE if success
*/
BOOL CMTTS::FindSurroundingPOS (PCTextParse pParse, PCMMLNode2 pNode, DWORD dwNodeStart, DWORD dwNodeEnd,
                              DWORD dwIndex, BYTE *pabPOS)
{
   PCMMLNode2 pSub = NULL;
   PWSTR psz;
   pNode->ContentEnum (dwIndex, &psz, &pSub);
   if (!pSub)
      return FALSE;

   // determine the POS for surrounding words..
   BYTE abPOS[(TTSPROSNGRAM+TTSPROSNGRAMBIT)*2+1];
   DWORD j;
   for (j = 0; j < (TTSPROSNGRAM+TTSPROSNGRAMBIT)*2+1; j++)
      abPOS[j] = POS_MAJOR_NUM;  // assume it's punctuation

   // center POS
   psz = pSub->AttribGetString(pParse->POS());
   abPOS[TTSPROSNGRAM+TTSPROSNGRAMBIT] = (BYTE)POS_MAJOR_EXTRACT(psz ? _wtoi(psz) : POS_MAJOR_NOUN);

   DWORD dwLeft;
   BOOL fIsPunct;
   BYTE bPOS;
   PWSTR pszText;
   for (dwLeft = 0; dwLeft < 2; dwLeft++) {
      DWORD dwCur = dwIndex;
      for (j = 0; j < TTSPROSNGRAM+TTSPROSNGRAMBIT; j++) {
         if (!FindAdjacentWord (pParse, pNode, dwNodeStart, dwNodeEnd, !dwLeft, TRUE, &dwCur, &pszText, &fIsPunct, &bPOS))
            break;   // no more

         // if it's punctuation then stop, since already have elements filled in assuming
         // theyre punctuation
         if (fIsPunct)
            break;

         // index
         DWORD dwIndex2;
         if (dwLeft)
            dwIndex2 = TTSPROSNGRAM+TTSPROSNGRAMBIT - j - 1;
         else
            dwIndex2 = TTSPROSNGRAM+TTSPROSNGRAMBIT + j + 1;
         abPOS[dwIndex2] = POS_MAJOR_EXTRACT(bPOS);
      } // j
   } // dwLeft

   // make sure within limits
   for (j = 0; j < (TTSPROSNGRAM+TTSPROSNGRAMBIT)*2+1; j++) {
      abPOS[j] = min(abPOS[j], abPOS[POS_MAJOR_NUM]); // so not too high
      if (!abPOS[j])
         abPOS[j] = POS_MAJOR_EXTRACT(POS_MAJOR_NOUN);  // assume noun
   }

   memcpy (pabPOS, abPOS, sizeof(abPOS));

   return TRUE;
}



/*************************************************************************************
CMTTS::FillInCOMPARESYLINFO - Fills in COMPARESYLINFO with appropriate values

inputs
   PCOMPARESYLINFO      pInfo - Filled in
returns
   none
*/
void CMTTS::FillInCOMPARESYLINFO (PCOMPARESYLINFO pInfo)
{
   memset (pInfo, 0, sizeof(*pInfo));

   PCMLexicon pLex = Lexicon();

   // determine phoneme for each group
   fp fWeight, fWeightSum;
   DWORD i, j;
   DWORD adwGroupPhone[PIS_PHONEGROUPNUM];
   for (i = 0; i < PIS_PHONEGROUPNUM; i++)
      adwGroupPhone[i] = pLex->PhonemeGroupToPhone (i, TRUE, NULL); 

   // just average for all phone groups


   // duration
   fWeightSum = 0.0;
   for (i = 0; i < PIS_PHONEGROUPNUM; i++)
      for (j = 0; j < 2; j++) {
         fWeight = 1.0;
         fWeightSum += fWeight;
         pInfo->fDuration += UnitScoreDuration (this, adwGroupPhone[i], pLex, j, FALSE) * fWeight;
      }
   pInfo->fDuration /= fWeightSum;

   // energy
   fWeightSum = 0.0;
   for (i = 0; i < PIS_PHONEGROUPNUM; i++)
      for (j = 0; j < 2; j++) {
         fWeight = 1.0;
         fWeightSum += fWeight;
         pInfo->fEnergy += UnitScoreEnergy (this, adwGroupPhone[i], pLex, j) * fWeight;
      }
   pInfo->fEnergy /= fWeightSum;

   // pitch
   fWeightSum = 0.0;
   for (i = 0; i < PIS_PHONEGROUPNUM; i++)
      for (j = 0; j < 2; j++) {
         fWeight = 1.0;
         fWeightSum += fWeight;
         pInfo->fPitch += UnitScorePitch (this, adwGroupPhone[i], pLex, j, FALSE) * fWeight;
      }
   pInfo->fPitch /= fWeightSum;

   // function word
   fWeightSum = 0.0;
   for (i = 0; i < PIS_PHONEGROUPNUM; i++)
      for (j = 0; j < 2; j++) {
         fWeight = 1.0;
         fWeightSum += fWeight;
         pInfo->fFuncWord += UnitScoreFunc (this, adwGroupPhone[i], pLex, 0, 1) * fWeight;
            // just one step in function word
      }
   pInfo->fFuncWord /= fWeightSum;

   pInfo->fWordPosMismatchStart = UnitScoreMismatchedWordPos (this, 0x00, 0x01) / 2.0;
   pInfo->fWordPosMismatchEnd = UnitScoreMismatchedWordPos (this, 0x00, 0x02) / 2.0;
      // NOTE - Dividing by 2.0 on the assumption that the average phoneme is two phonemes


   // derived from objectively calculated valyes
   pInfo->fWordMismatchPenalty = (pInfo->fWordPosMismatchStart + pInfo->fWordPosMismatchEnd) / 2.0;
   pInfo->fPunctMismatchPenalty = pInfo->fWordMismatchPenalty * 8.0;
   pInfo->fRandomize = pInfo->fWordMismatchPenalty / 2.0; // BUGFIX - Was using * 2.0;, but too much
      // BUGFIX - Added /2.0 to reduce the randomization s abit more
   pInfo->fCrossSentencePenalty = (pInfo->fDuration + pInfo->fEnergy + pInfo->fPitch) / 3.0; // not sure what this should be exactly
   pInfo->fVeryBadScore = BEAMSEARCHHYP_HISTORY * pInfo->fCrossSentencePenalty;
}


/*************************************************************************************
CMTTS::SynthProsodyCreateSyllablesInt - This loops through the sentence and figures
out the prosody based on the CSentenceSyllable information.

NOTE: This is an internal method that assumes the sentence has already been broken up onto
sentences.
inputs
   PCMMLNode2        pNode - List of words and puncutation.
   DWORD             dwNodeStart - Start index into the pNode
   DWORD             dwNodeEnd - End index into pNode
   PCTextParse       pParse - Just used for getting strings out
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL              fTransPros - Set this to TRUE if speaking transplanted prosody, and will
                     generate syllables more quickly since they info is likely to be thrown
                     out anyway
   DWORD                dwMultiPass - Pass number when generating several different versions of the
                        same sentence, and selecting the best one for TTS. Used to make the
                        random work better.
   PCListFixed       plNodeAssociate - This list is initialized to sizeof(PCMMLNode2),
                     and contains one element per syllable in PCSentenceSyllable.
                     Use this to link nodes with the returned object.
returns
   PCSentenceSyllable - An object with all the syllables from the sentence in it.
                     This object will need to be freed.
                     NOTE: bFlags is filled with 0 if no microsilence, 255 if always microsilence
*/
PCSentenceSyllable CMTTS::SynthProsodyCreateSyllablesInt (PCMMLNode2 pNode, DWORD dwNodeStart, DWORD dwNodeEnd, PCTextParse pParse,
                                                       PTTSVOICEMOD pVoiceMod, int iTTSQuality, BOOL fTransPros,
                                                       DWORD dwMultiPass, PCListFixed plNodeAssociate)
{
   PCSentenceSyllable pss = new CSentenceSyllable;
   plNodeAssociate->Init (sizeof(PCMMLNode2));

   PCMLexicon pLex = Lexicon();

   DWORD i, j, k;
   PCMMLNode2 pSub;
   PWSTR psz;
   SENTSYLEMPH Emph;
   CListFixed lBoundary;
   lBoundary.Init (sizeof(DWORD));
   memset (&Emph, 0, sizeof(Emph));
   // NOTE: fDurSkew is set to 0 properly
   Emph.fDurPhone = Emph.fDurSyl = Emph.fPitch = Emph.fVolume = 1;
   CListFixed lPARSERULEDEPTH;
   lPARSERULEDEPTH.Init (sizeof(PARSERULEDEPTH));
   PARSERULEDEPTH PRD, PRDOrig;

   for (i = dwNodeStart; i < dwNodeEnd; i++) {
      pSub = NULL;
      pNode->ContentEnum (i, &psz, &pSub);
      if (!pSub)
         continue;
      psz = pSub->NameGet();
      if (!psz)
         continue;

      // see if this is punctuation
      DWORD dwWord;
      if (!_wcsicmp(psz, pParse->Punctuation())) {
         psz = pSub->AttribGetString(pParse->Text());

         if (psz)
            dwWord = m_pLexTrainingWords->WordFind(psz); // get the word ID
         else
            dwWord = (DWORD)-1;  // no text

         // add this
         pss->Add (
            dwWord,
            POS_MAJOR_EXTRACT(POS_MAJOR_PUNCTUATION),
            0, // sylindex
            0,
            &Emph,
            FALSE,
            0, // NOTE: with punctuation must be syllable 0 and no phonemes
            0, // NOTE: With functuation, always in most common "words"
            0,
            0);
         plNodeAssociate->Add (&pSub);

         // parse depth
         psz = pSub->AttribGetString(pParse->ParseRuleDepth());
         memset (&PRD, 0, sizeof(PRD));
         if (psz)
            *((DWORD*)&PRD) = (DWORD)_wtoi(psz);
         lPARSERULEDEPTH.Add (&PRD);

         continue;
      } // if punctuation

      // else, only looking for words
      if (_wcsicmp(psz, pParse->Word()))
         continue;

      // get the prounciation
      PWSTR pszPron = pSub->AttribGetString (pParse->Pronunciation());
      DWORD dwPhonemes = 0;
      BYTE abPron[50];
      if (pszPron) {
         // else convert to binary
         dwPhonemes = (DWORD)MMLBinaryFromString (pszPron, abPron, sizeof(abPron));
         if (dwPhonemes >= sizeof(abPron))
            dwPhonemes = sizeof(abPron)-1;
         abPron[dwPhonemes] = 0; // to null terminate

         for (j = 0; j < dwPhonemes; j++)
            abPron[j]++;   // so that offset properly
      }
      else
         abPron[0] = 0;

      // get the text
      psz = pSub->AttribGetString(pParse->Text());
      PWSTR pszWord = psz;

      // figure out how many syllables
      lBoundary.Clear();
      pLex->WordSyllables (abPron, psz, &lBoundary);
      DWORD *padwBoundry = (DWORD*)lBoundary.Get(0);

      // restore abPron down so can use later
      for (j = 0; j < dwPhonemes; j++)
         abPron[j]--;

      // see if have a word match and use that
      dwWord = psz ? m_pLexTrainingWords->WordFind(psz) : (DWORD)-1; // get the word ID

      // get the part of speech
      BYTE bPOS, bRuleDepthLowDetail;
      psz = pSub->AttribGetString(pParse->POS());
      if (psz)
         bPOS = POS_MAJOR_EXTRACT ((BYTE)_wtoi(psz));
      else
         bPOS = POS_MAJOR_EXTRACT (POS_MAJOR_NOUN);
      psz = pSub->AttribGetString(pParse->RuleDepthLowDetail());
      if (psz)
         bRuleDepthLowDetail = (BYTE)_wtoi(psz);
      else
         bRuleDepthLowDetail = 0;

      // get the word commonality
      DWORD dwWordRank;
      if (!pszWord || (bPOS == POS_MAJOR_EXTRACT (POS_MAJOR_PUNCTUATION)))
         dwWordRank = 0;   // punctation
      else {
         dwWordRank = WordRank (pszWord, TRUE);
         WordRankHistory (pszWord);  // add word to speaking history
      }

      // BUGBUG - at some point in future might want to have <emphasis> tag
      // affect dwWordRank, but not right now

      // go through all the syllables and add them
      DWORD dwSyllablesAdded = 0;
      for (j = 0; j < lBoundary.Num(); j++) {
         DWORD dwStress = ((lBoundary.Num() > 1) || pLex->ChineseUse()) ? (padwBoundry[j] >> 24) : 1;
               // BUGFIX - single-syllable words are always treated as astressed
               // BUGFIX - With chinese, DON'T force stress for single-syllable words
         DWORD dwPhonemes = (padwBoundry[j] & 0xffff) - (j ? (padwBoundry[j-1] & 0xffff) : 0);

         // figure out the phoneme groups
         DWORD dwPhoneGroupBits = pss->PhoneGroupBitsCalc (
            abPron + (j ? (padwBoundry[j-1] & 0xffff) : 0),
            dwPhonemes,
            pLex);

         pss->Add (
            dwWord,
            bPOS,
            (BYTE)j,
            bRuleDepthLowDetail,
            &Emph,
            (BYTE)dwStress,
            dwPhonemes,
            dwWordRank,
            0,
            dwPhoneGroupBits);
         plNodeAssociate->Add (&pSub);
         dwSyllablesAdded++;

         padwBoundry[j] &= 0x00ffffff;   // so remove the high byte
      } // j

      // write the syllable boundaries... Note that the high-byte will have been removed above
      AttribSetArray (pSub, gpszSyllables, lBoundary.Num(), padwBoundry);

      // parse depth
      psz = pSub->AttribGetString(pParse->ParseRuleDepth());
      memset (&PRD, 0, sizeof(PRD));
      if (psz)
         *((DWORD*)&PRD) = (DWORD)_wtoi(psz);
      PRDOrig = PRD;
      // add a word entry for each syllable
      for (k = 0; k < dwSyllablesAdded; k++) {
         PRD = PRDOrig;
         if (dwSyllablesAdded >= 2) {
            if (k)
               PRD.bBefore = PRD.bDuring;
            if (k+1 < dwSyllablesAdded)
               PRD.bAfter = PRD.bDuring;
         }
         lPARSERULEDEPTH.Add (&PRD);
      } // k

   } // i

   // remember the parse rule depths
   pss->SetPARSERULEDEPTH ((PPARSERULEDEPTH) lPARSERULEDEPTH.Get(0), lPARSERULEDEPTH.Num());
   
   // BUGFIX - make sure there are no "unknown" parts of speech in the sentence syllable
   // because wont match. Particular problem with chinese, but would have been
   // a sizable (but unnoticed) problem with english
   pss->ReplaceUnknownPOSWithNoun ();

   // go through and figure out the best combination of templates to use
   // figure out a slot to put this voice in
   for (i = 0; i < TTSVOICEMODMAXPROSODY; i++)
      if (!pVoiceMod->apTTSProsody[i]) {
         pVoiceMod->apTTSProsody[i] = m_pCTTSProsody;
         break;
      }

   // how accuracy do we want this
   fp fUnits = max(m_dwUnits, 1);
   int iTTSQualityLimited = min (max(iTTSQuality, 0), 3);
   // BUGFIX - Greater difference in qualoty
   fUnits *= (0.33 + 0.66 * (fp)iTTSQualityLimited / 3.0); // for accuracy simulation
   fp fAccuracy = (log((double)fUnits) - log((double)10000)) / (log((double)100000) - log((double)10000));
   fAccuracy = pow((double)2.0, (double)fAccuracy);

   int iTTSQualityProsody = iTTSQuality;
   if (fTransPros) {
      iTTSQualityProsody--;
      fAccuracy /= 2.0; // half the accuracy if transplanted prosody
   }

   COMPARESYLINFO CSI;
   FillInCOMPARESYLINFO (&CSI);
   m_pCTTSProsody->FindBestMatch (pLex, &CSI, pss, m_pLexTrainingWords, pVoiceMod->apTTSProsody, i+1, iTTSQualityProsody, fAccuracy,
      (iTTSQuality >= 4) ? 2 : 1, dwMultiPass);  // randomness increased on multipass

   // restore
   if (i < TTSVOICEMODMAXPROSODY)
      pVoiceMod->apTTSProsody[i] = NULL;

   // BUGFIX - Loop through all the syllables and pitch normalize
   // NOTE: Cant determine syllable duration here
   double fPitchSum = 0;
   double fPitchCount = 0;
   fp fPitch, fDur;
   for (i = 0; i < pss->m_dwNum; i++) {
      fPitch = (fp)pss->m_paSyl[i].bPitch / 100.0;
      if (!fPitch)
         continue;

      fPitch = log(fPitch) / log((fp)2);

      // guestimate of duration
      fDur = pow((fp)pss->m_paSyl[i].bDurPhone * (fp)pss->m_paSyl[i].bDurSyl / 100.0 / 100.0, 0.5 * DURPHONEPOW);
         // BUGFIX - Was sqrt() to average the two, but also need to include DURPHONEPOW

      fPitchSum += fPitch * fDur;
      fPitchCount += fDur;
   } // i
   if (fPitchCount)
      fPitchSum /= fPitchCount;
   fPitchSum = pow(2.0, fPitchSum);

#ifdef _DEBUG
   WCHAR szTemp[128];
   swprintf (szTemp, L"\r\nPitch error = %g", (double)fPitchSum);
   OutputDebugStringW (szTemp);
#endif
   
   // actually scale, and hack to make difficult to go really low
#define HACKTOOLOW         0.9
   for (i = 0; i < pss->m_dwNum; i++) {
      fPitch = (fp)pss->m_paSyl[i].bPitch / 100.0;
      fPitch /= fPitchSum;

      // if too low then fix
      if (fPitch < HACKTOOLOW) {
         fPitch /= HACKTOOLOW;   // so that threshhold is 1
         fPitch = sqrt(fPitch);
         fPitch *= HACKTOOLOW;   // to restore
      }
      fPitch = fPitch * 100.0 + 0.5;
      fPitch = max(fPitch, 0);
      fPitch = min(fPitch, 255);
      pss->m_paSyl[i].bPitch = (BYTE)fPitch;
   } // i

   return pss;
}



/*************************************************************************************
CMTTS::SynthProsodyCreateSyllables - This loops through the sentence and figures
out the prosody based on the CSentenceSyllable information.


inputs
   PCMMLNode2        pNode - List of words and puncutation.
   DWORD             dwNodeStart - Starting node. Originally pass in 0, but then pass in last dwNode End
   PCTextParse       pParse - Just used for getting strings out
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL              fTransPros - Set this to TRUE if speaking transplanted prosody, and will
                     generate syllables more quickly since they info is likely to be thrown
                     out anyway
   DWORD                dwMultiPass - Pass number when generating several different versions of the
                        same sentence, and selecting the best one for TTS. Used to make the
                        random work better.
   PCListFixed       plNodeAssociate - This list is initialized to sizeof(PCMMLNode2),
                     and contains one element per syllable in PCSentenceSyllable.
                     Use this to link nodes with the returned object.
   DWORD             *pdwNodeEnd - Filled with the next node to start at.
returns
   PCSentenceSyllable - An object with all the syllables from the sentence in it.
                     This object will need to be freed.
                     NOTE: bFlags is filled with 0 if no microsilence, 255 if always microsilence
*/
PCSentenceSyllable CMTTS::SynthProsodyCreateSyllables (PCMMLNode2 pNode, DWORD dwNodeStart, PCTextParse pParse,
                                                       PTTSVOICEMOD pVoiceMod, int iTTSQuality, BOOL fTransPros,
                                                       DWORD dwMultiPass, PCListFixed plNodeAssociate, DWORD *pdwNodeEnd)
{
   // set, sjut in case
   *pdwNodeEnd = (DWORD)-1;

   if (dwNodeStart >= pNode->ContentNum())
      return NULL;   // no more data

   PCSentenceSyllable pss; // = new CSentenceSyllable;
   plNodeAssociate->Init (sizeof(PCMMLNode2));

   // split this into multiple sentences and pass those to individual prosody generation units
   // DWORD i;
   DWORD dwNodeEnd;
   // CListFixed lNodeAssociateTemp;
   // PCSentenceSyllable pssTemp;
   PCMMLNode2 pSub;
   // PCMMLNode2 *ppNode;
   PWSTR psz;
   //for (dwNodeStart = 0; dwNodeStart < pNode->ContentNum(); dwNodeStart = dwNodeEnd) {
   for (dwNodeEnd = dwNodeStart+1; dwNodeEnd < pNode->ContentNum(); dwNodeEnd++) {
      pSub = NULL;
      pNode->ContentEnum (dwNodeEnd, &psz, &pSub);
      if (!pSub)
         continue;
      psz = pSub->NameGet();
      if (!psz)
         continue;

      // only care about punctuation
      if (_wcsicmp(psz, pParse->Punctuation()))
         continue;

      psz = pSub->AttribGetString(pParse->Text());
      if (!psz)
         continue;   // error

      // if it's a period, exclamation point, or question mark then stop
      if (!_wcsicmp(psz, L".") || !_wcsicmp(psz, L"!") || !_wcsicmp(psz, L"?")) {
         // found it, so include this
         dwNodeEnd++;
         break;
      }

      // else, comma or seomthing that's part of a sentence
   } // dwNodeEnd

   *pdwNodeEnd = dwNodeEnd;

   // when get here, have complete sentence
   pss = SynthProsodyCreateSyllablesInt (pNode, dwNodeStart, dwNodeEnd,
      pParse, pVoiceMod, iTTSQuality, fTransPros, dwMultiPass, plNodeAssociate);
   if (!pss)
      return NULL;   // error

   // combine
   //ppNode = (PCMMLNode2*)lNodeAssociateTemp.Get(0);
   //for (i = 0; i < lNodeAssociateTemp.Num(); i++)
   //   plNodeAssociate->Add (ppNode + i);

   //pss->Append (pssTemp);
   //delete pssTemp;

//   } // while have data

   return pss;
}

/*************************************************************************************
CMTTS::SynthProsodyTagsApply - This loops through all the words in PCMMLNode2 (generated
from CTextParse::ParseFromMMLText (or equivalent). If there are no prosody
tags it fills some in, automatically generating prosody.

It writes tags for gpszPitchRel, gpszVolRel, gpszDurRel. This also sets gpszInflectPoint
to 1 if the punctuation is immediately to the right, or -1 if it's immediate to the left.

inputs
   PCMMLNode2         pNode - List of words and punctuation. This is modified in place.
   DWORD             dwNodeStart - Starting index into pNode. Initially pass in 0, but on
                        later passes pass last *pdwNodeEnd.
   PCTextParse       pParse - Just used for getting strings out
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
   int               iTTSQuality - TTS quality. 0 for fast, 1 for normal, 2 for slow, 3 for best, 4 for multipass
   BOOL              fTransPros - Set this to TRUE if speaking transplanted prosody, and will
                     generate syllables more quickly since they info is likely to be thrown
                     out anyway
   DWORD                dwMultiPass - Pass number when generating several different versions of the
                        same sentence, and selecting the best one for TTS. Used to make the
                        random work better.
   DWORD             *pdwNodeEnd - Filled in with node that processed up to. Pass this back into
                     the next dwNodeStart.
returns
   BOOL - TRUE if succes, FALSE if no more to speak
*/

BOOL CMTTS::SynthProsodyTagsApply (PCMMLNode2 pNode, DWORD dwNodeStart, PCTextParse pParse, PTTSVOICEMOD pVoiceMod, int iTTSQuality,
                                   BOOL fTransPros, DWORD dwMultiPass, DWORD *pdwNodeEnd)
{
   *pdwNodeEnd = (DWORD)-1;

#if 0 // old prosody
   PCTTSPunctPros *ppp = (PCTTSPunctPros*) m_lPCTTSPunctPros.Get(0);
   DWORD dwNumPunct = m_lPCTTSPunctPros.Num();
#endif // 0, old prosody

   // determine syllable boundaries
   CListFixed lNodeAssociate;
   PCSentenceSyllable pss = SynthProsodyCreateSyllables (pNode, dwNodeStart, pParse, pVoiceMod,
      iTTSQuality, fTransPros, dwMultiPass, &lNodeAssociate, pdwNodeEnd);
   if (!pss)
      return FALSE;
   PCMMLNode2 *ppNA = (PCMMLNode2*)lNodeAssociate.Get(0);

   // will need to initialize globalflags settings
   // convert some tags
   TTSGLOBALSTATE State;
   memset (&State, 0 ,sizeof(State));
   State.fProsodyAvgPitch = pVoiceMod->pSubVoice->m_fAvgPitch;
   //State.fProsodyAvgSyllableDur = pVoiceMod->pSubVoice->m_fAvgSyllableDur;
   State.fProsodyPitchExpress = 1;
   State.fProsodyVol = 1;
   State.fProsodyWPM = pVoiceMod->pSubVoice->m_dwWordsPerMinute;
   // leave emotions at 0
   // will need to fill in derviced values
   GlobalStateFromMML (NULL, pVoiceMod->pSubVoice, &State);


   DWORD i, j, k, dwSylStart, dwSylEnd, dwNumSyl, dw;
   // DWORD *padwBoundary;
   // CListFixed lBoundary;
   CListFixed lProsody, lDWORD;
   PCMMLNode2 pSub;
   PWSTR psz;
   SENTSYLEMPH Emph;
   PSENTSYLEMPH pProsody;
   lDWORD.Init (sizeof(DWORD));
   lProsody.Init (sizeof(SENTSYLEMPH));
   for (i = dwNodeStart /*0*/; i < *pdwNodeEnd /*pNode->ContentNum()*/; i++) {
      pSub = NULL;
      pNode->ContentEnum (i, &psz, &pSub);
      if (!pSub)
         continue;
      psz = pSub->NameGet();
      if (!psz)
         continue;

      // global state
      if (!_wcsicmp(psz, gpszTTSGlobalState)) {
         // get the state
         GlobalStateFromMML (pSub, pVoiceMod->pSubVoice, &State);
         continue;
      }
      
      // only care about word from here on out
      if (_wcsicmp(psz, pParse->Word()))
         continue;   // only accept words

      // get the word text
      PWSTR pszText = pSub->AttribGetString (pParse->Text());
      if (!pszText)
         continue;

      // find which syllable should be associated with
      for (dwSylStart = 0; dwSylStart < lNodeAssociate.Num(); dwSylStart++)
         if (ppNA[dwSylStart] == pSub)
            break;
      if (dwSylStart >= lNodeAssociate.Num())
         continue;   // couldnt find. This shouldnt happen
      for (dwSylEnd = dwSylStart+1; dwSylEnd < lNodeAssociate.Num(); dwSylEnd++)
         if (ppNA[dwSylEnd] != pSub)
            break;
      dwNumSyl = dwSylEnd - dwSylStart;

      // BUGFIX - remove because dont need
      // get the syllable boundaries
      //if (!AttribGetArray (pSub, gpszSyllables, &lBoundary))
      //   continue; // shouldnt happen
      //if (dwNumSyl != lBoundary.Num())
      //   continue;   // shouldnt happen
      //padwBoundary = (DWORD*) lBoundary.Get(0);

      // create lists for pitch, volume, and duration for each syllable
      lProsody.Clear();
      lProsody.Required (dwNumSyl);
      for (j = 0; j < dwNumSyl; j++) {
         Emph.fPitch = pow ((fp) pss->m_paSyl[dwSylStart + j].bPitch / 100.0, PITCHPOW);
         Emph.fPitchSweep =  (fp) pss->m_paSyl[dwSylStart + j].cPitchSweep / 100.0 * PITCHPOW;
         Emph.fPitchBulge =  (fp) pss->m_paSyl[dwSylStart + j].cPitchBulge / 100.0 * PITCHPOW;
         Emph.fDurPhone = pow ((fp) pss->m_paSyl[dwSylStart + j].bDurPhone / 100.0, DURPHONEPOW);
         Emph.fDurSyl = pow ((fp) pss->m_paSyl[dwSylStart + j].bDurSyl / 100.0, DURPHONEPOW);
         Emph.fVolume = pow ((fp) pss->m_paSyl[dwSylStart + j].bVol / 100.0, VOLUMEPOW);
         Emph.fDurSkew =  (fp) pss->m_paSyl[dwSylStart + j].cDurSkew / 100.0 * DURPHONEPOW;

         // apply voice mods
         Emph.fPitch = pow (Emph.fPitch, pVoiceMod->pSubVoice->m_pPOSAccentuate.p[0]);
         Emph.fPitchSweep *= pVoiceMod->pSubVoice->m_pPOSAccentuate.p[0];
         Emph.fPitchBulge *= pVoiceMod->pSubVoice->m_pPOSAccentuate.p[0];
         Emph.fVolume = pow (Emph.fVolume, pVoiceMod->pSubVoice->m_pPOSAccentuate.p[1] * State.fDerVolumeExpress);
         Emph.fDurPhone = pow (Emph.fDurPhone, pVoiceMod->pSubVoice->m_pPOSAccentuate.p[2] * State.fDerDurationExpress);
         Emph.fDurSyl = pow (Emph.fDurSyl, pVoiceMod->pSubVoice->m_pPOSAccentuate.p[2] * State.fDerDurationExpress);
         Emph.fDurSkew *= pVoiceMod->pSubVoice->m_pPOSAccentuate.p[2] * State.fDerDurationExpress;

         lProsody.Add (&Emph);
      } // j
      pProsody = (PSENTSYLEMPH)lProsody.Get(0);

      // note if have micropause
      // write out pause left
      pSub->AttribSetDouble (gpszPauseLeft, (fp)pss->m_paSyl[dwSylStart].bPauseProb / 15.0);

      // write out micropauses. Note: affected by WPM
      PCMTTS pMaster = TTSMasterGet2 ();
      if (!pMaster)
         pMaster = this;
      fp fSpeedUp = pMaster->m_dwWordsPerMinute ? 
         log(State.fDerWPM / (fp) pMaster->m_dwWordsPerMinute) / log((fp)2) * 0.5 : 0;
            // BUGFIX - was 50, which was totall incorrect. should have been 0.5
            // BUGIFX - Changed to 0.25 so less of an effect
            // BUGFIX - Changed back to 0.5 to greater effect.
      pSub->AttribSetDouble (gpszDerMicropauses, State.fDerMicropauses + fSpeedUp);

      // get the current tags
      CPoint pEmph;
      pEmph.Zero();
      pEmph.p[0] = pEmph.p[1] = pEmph.p[2] = 1;
      psz = pSub->AttribGetString (gpszPitchRel);
      if (psz)
         pEmph.p[0] = _wtof(psz);
      psz = pSub->AttribGetString (gpszVolRel);
      if (psz)
         pEmph.p[1] = _wtof(psz);
      psz = pSub->AttribGetString (gpszDurRel);
      if (psz)
         pEmph.p[2] = _wtof(psz);

      // write out the per-syllable pitch, volume, and duration
      for (j = 0; j < 7; j++) {
         lDWORD.Clear();
         lDWORD.Required (dwNumSyl);

         for (k = 0; k < dwNumSyl; k++) {
            // value
            fp f;
            switch (j) {
            case 0:  // pitch
               f = pProsody[k].fPitch;
               f *= pEmph.p[0];
               break;
            case 1:  // pitch sweep
               f = pProsody[k].fPitchSweep;
               break;
            case 2:  // volume
               f = pProsody[k].fVolume;
               f *= pEmph.p[1];
               break;
            case 3:  // duration, phone
               f = pProsody[k].fDurPhone;
               f *= pEmph.p[2];
               break;
            case 4:  // duration, syllable
               f = pProsody[k].fDurSyl;
               f *= pEmph.p[2];
               break;
            case 5:  // bulge
               f = pProsody[k].fPitchBulge;
               break;
            case 6:  // duration, skew
               f = pProsody[k].fDurSkew;
               f *= pEmph.p[2];
               break;
            } // j
               // this is a change from some of the old code for relative duraion, etc.

            if (j != 1)
               dw = (DWORD)(f * (fp)0x10000);
            else
               dw = (DWORD)(int)(f * (fp)0x10000);

            lDWORD.Add (&dw);
         } // k, all points

         // save
         PWSTR pszArray;
         switch (j) {
         case 0:  // pitch
            pszArray = gpszSylPitch;
            break;
         case 1:  // pitch sweep
            pszArray = gpszSylPitchSweep;
            break;
         case 2:  // volume
            pszArray = gpszSylVol;
            break;
         case 3:  // duration, phone
            pszArray = gpszSylDurPhone;
            break;
         case 4:  // duration, syllable
            pszArray = gpszSylDurSyl;
            break;
         case 5:
            pszArray = gpszSylPitchBulge;
            break;
         case 6:
            pszArray = gpszSylDurSkew;
            break;
         } // j

         AttribSetArray (pSub, pszArray, dwNumSyl, (DWORD*)lDWORD.Get(0));
      } // j


      // BUGFIX - the following code is now obsolete
#if 0 // old prosody
      // get N-gram
      CPoint pNGram;
      won't work anymore because of the way that handle pNode bit by bit
      NGramFindBackoff (pParse, pNode, i, &pNGram, &fPauseLeft, NULL);
      pEmph.p[0] *= pow (pNGram.p[0], pVoiceMod->pPOSAccentuate.p[0]);
      pEmph.p[1] *= pow (pNGram.p[1], pVoiceMod->pPOSAccentuate.p[1]);
      pEmph.p[2] *= pow (pNGram.p[2], pVoiceMod->pPOSAccentuate.p[2]);


      // figure out what category this word is in
      //BOOL fException;
      DWORD j, dwLeft;
      BOOL fIsPunct;
      for (j = 0; j < NUMLEXWORDEMPH; j++)
         if (m_apLexWordEmph[j] && (-1 != m_apLexWordEmph[j]->WordFind(pszText)))
            break;
      // BUGFIX - Since changed the way fundamentally works, don't use exceptions
      // fException = (-1 != m_pLexWords->WordFind(pszText));
      pEmph.p[0] *= m_apLexWordEmphScale[j].p[0];
      //if (!fException) {
         // only do this for words that aren't in the hardwired list, since already
         // have volume and duration taken care of
         pEmph.p[1] *= m_apLexWordEmphScale[j].p[1];
         pEmph.p[2] *= m_apLexWordEmphScale[j].p[2];
      //}

      // apply scaling by word length
      // get the pronunciation
      PWSTR pszPron = pSub->AttribGetString (pParse->Pronunciation());
      DWORD dwPhonemes = 0;
      if (pszPron) {
         // else convert to binary
         BYTE abPron[50];
         dwPhonemes = MMLBinaryFromString (pszPron, abPron, sizeof(abPron));
      }
      if (dwPhonemes) {
         dwPhonemes--;
         if (dwPhonemes >= NUMPROSWORDLENGTH)
            dwPhonemes = NUMPROSWORDLENGTH-1;
         pEmph.p[0] *= m_apProsWordEmphFromWordLength[dwPhonemes].p[0];
         pEmph.p[1] *= m_apProsWordEmphFromWordLength[dwPhonemes].p[1];
         pEmph.p[2] *= m_apProsWordEmphFromWordLength[dwPhonemes].p[2];
      }

      // look to the left and right for words that are function words
      for (dwLeft = 0; dwLeft < 2; dwLeft++) {
         DWORD dwCur = i;
         for (j = 0; j < PUNCTPROS; j++) {
            won't work anymore because of the way that handle pNode bit by bit
            if (!FindAdjacentWord (pParse, pNode, !dwLeft, FALSE, &dwCur, &pszText, &fIsPunct))
               break;   // no more

            // see if this is a function word
            WORD wFuncWord = (WORD)m_pLexFuncWords->WordFind (pszText);
            if (wFuncWord == -1)
               continue;   // not a function word

            // try to find it
            for (k = 0; k < dwNumPunct; k++)
               if ((ppp[k]->m_wFuncWord == wFuncWord) && !(ppp[k]->m_wPunct))
                  break;
            if (k >= dwNumPunct)
               break;   // not actually found, BUGFIX - Was conintue

            // figure out scaling...
            PCPoint pScale = dwLeft ? &ppp[k]->m_apAfter[j] : &ppp[k]->m_apBefore[j];
            pEmph.p[0] *= pow (pScale->p[0], pVoiceMod->pPunctAccentuate.p[0]);
            pEmph.p[1] *= pow (pScale->p[1], pVoiceMod->pPunctAccentuate.p[1]);
            pEmph.p[2] *= pow (pScale->p[2], pVoiceMod->pPunctAccentuate.p[2]);
         } // j, over PUNCTPROS
      } // dwLeft

      // now, look for punctuation...
      for (dwLeft = 0; dwLeft < 2; dwLeft++) {
         DWORD dwCur = i;
         DWORD dwWordSkip = 0;
         WCHAR wPunct = L'.';
         for (j = 0; dwWordSkip < PUNCTPROS; j++) {
            won't work anymore because of the way that handle pNode bit by bit
            if (!FindAdjacentWord (pParse, pNode, !dwLeft, TRUE, &dwCur, &pszText, &fIsPunct))
               goto assumepunct;   // no more

            // if it isn't punctuation then increase word skip and continue
            if (!fIsPunct) {
               dwWordSkip++;
               continue;
            }

            if (pszText[0])
               wPunct = pszText[0];

assumepunct:
            // if this punctuation is right next to the word then set a flag
            // so the inflection point of the prosody will be at the start/end
            // of the word rather than middle
            if ((dwWordSkip == 0) && !pSub->AttribGetString(gpszInflectPoint))
               pSub->AttribSetString (gpszInflectPoint, dwLeft ? L"-1" : L"1");

            // try to find it
            for (k = 0; k < dwNumPunct; k++)
               if (ppp[k]->m_wPunct == wPunct)
                  break;
            if (k >= dwNumPunct)
               break;   // not actually found

            // figure out scaling...
            PCPoint pScale = dwLeft ? &ppp[k]->m_apAfter[dwWordSkip] : &ppp[k]->m_apBefore[dwWordSkip];
            pEmph.p[0] *= pow (pScale->p[0], pVoiceMod->pPunctAccentuate.p[0]);
            pEmph.p[1] *= pow (pScale->p[1], pVoiceMod->pPunctAccentuate.p[1]);
            pEmph.p[2] *= pow (pScale->p[2], pVoiceMod->pPunctAccentuate.p[2]);

            // since was punctuation should breka
            break;
         } // j, over PUNCTPROS
      } // dwLeft

      // write out the tags
      // BUGFIX - Only write out tags if they're not already there
      WCHAR szTemp[32];
      if (!pSub->AttribGetString (gpszPitchRel)) {
         MMLDoubleToString (pEmph.p[0], szTemp);
         pSub->AttribSetString (gpszPitchRel, szTemp);
      }
      if (!pSub->AttribGetString (gpszVolRel)) {
         MMLDoubleToString (pEmph.p[1], szTemp);
         pSub->AttribSetString (gpszVolRel, szTemp);
      }
      if (!pSub->AttribGetString (gpszDurRel)) {
         MMLDoubleToString (pEmph.p[2], szTemp);
         pSub->AttribSetString (gpszDurRel, szTemp);
      }
#endif // 0, disabled because old code

   }

   // free up memory
   delete pss;

   return TRUE;
}


/*************************************************************************************
ProsValueParse - Parses a prosody value...

inputs
   PWSTR       psz - Input string
   DWORD       *pdwValMean - Filled with the value meaning...
                  0 - absolute change, just a number
                  1 - Number with "Hz" following it
                  2 - Percentage
                  3 - + or - a certain amount
                  4 - + or - semitones (followed by st)
                  5 - + or - a certain percent
                  6 - Unknown/error
returns
   fp - Value.
*/
fp ProsValueParse (PWSTR psz, DWORD *pdwValMean)
{
   *pdwValMean = 6;  // just in case need to breal

   // see if preceded by plus or minus
   int iPlus = 0;
   if (psz[0] == L'+') {
      iPlus = 1;
      psz++;
   }
   else if (psz[0] == L'-') {
      iPlus = -1;
      psz++;
   }

   // make sure a number
   if (!iswdigit(psz[0]) && (psz[0] != L'.'))
      return 0;

   // get the value
   fp fVal = _wtof (psz);

   // look at the end
   DWORD dwLen = (DWORD)wcslen(psz);

   if (dwLen && (psz[dwLen-1] == L'%')) {
      *pdwValMean = (iPlus ? 5 : 2);
      return fVal * ((iPlus == -1) ? -1 : 1);
   }

   if ((dwLen >= 2) && !_wcsnicmp(psz + (dwLen-2), L"hz", 2)) {
      *pdwValMean = (iPlus ? 3 : 1);
      return fVal * ((iPlus == -1) ? -1 : 1);
   }

   if ((dwLen >= 2) && !_wcsnicmp(psz + (dwLen-2), L"st", 2)) {
      *pdwValMean = 4;
      return fVal * ((iPlus == -1) ? -1 : 1);
   }

   // else, no ending
   *pdwValMean = (iPlus ? 3 : 0);
   return fVal * ((iPlus == -1) ? -1 : 1);
}


/*************************************************************************************
CMTTS::EmotionToGlobalState - Takes a prosody tag and interprets all the attributes
to figure out how the global state is modified.

inputs
   PCMMLNode2         pNode - Node whtat is a "prosody" tag
   PTTSGLOBALSTATE   pState - Initially filled in with valid values, and modified in place by tag
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
returns
   none
*/
void CMTTS::EmotionToGlobalState (PCMMLNode2 pNode, PTTSGLOBALSTATE pState, PTTSVOICEMOD pVoiceMod)
{
   PWSTR psz;

   // emotions
   if (psz = pNode->AttribGetString (gpszWhisper))
      pState->fEmotionWhisper = _wtof (psz);
   if (psz = pNode->AttribGetString (gpszShout))
      pState->fEmotionShout = _wtof (psz);
   if (psz = pNode->AttribGetString (gpszQuiet))
      pState->fEmotionQuiet = _wtof (psz);
   if (psz = pNode->AttribGetString (gpszHappy))
      pState->fEmotionHappy = _wtof (psz);
   if (psz = pNode->AttribGetString (gpszSad))
      pState->fEmotionSad = _wtof (psz);
   if (psz = pNode->AttribGetString (gpszAfraid))
      pState->fEmotionAfraid = _wtof (psz);
   if (psz = pNode->AttribGetString (gpszDrunk))
      pState->fEmotionDrunk = _wtof (psz);
}

/*************************************************************************************
CMTTS::ProsodyToGlobalState - Takes a prosody tag and interprets all the attributes
to figure out how the global state is modified.

inputs
   PCMMLNode2         pNode - Node whtat is a "prosody" tag
   PTTSGLOBALSTATE   pState - Initially filled in with valid values, and modified in place by tag
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
returns
   none
*/
void CMTTS::ProsodyToGlobalState (PCMMLNode2 pNode, PTTSGLOBALSTATE pState, PTTSVOICEMOD pVoiceMod)
{
   fp fVal;
   DWORD dwMean;
   PWSTR psz;

   // pitch
   psz = pNode->AttribGetString (gpszPitch);
   if (psz) {
      if (!_wcsicmp(psz, L"x-high"))
         pState->fProsodyAvgPitch = pVoiceMod->pSubVoice->m_fAvgPitch * 1.5;
      else if (!_wcsicmp(psz, L"high"))
         pState->fProsodyAvgPitch = pVoiceMod->pSubVoice->m_fAvgPitch * sqrt(1.5);
      else if (!_wcsicmp(psz, L"medium") || !_wcsicmp(psz, L"default"))
         pState->fProsodyAvgPitch = pVoiceMod->pSubVoice->m_fAvgPitch;
      else if (!_wcsicmp(psz, L"low"))
         pState->fProsodyAvgPitch = pVoiceMod->pSubVoice->m_fAvgPitch / sqrt(1.5);
      else if (!_wcsicmp(psz, L"x-low"))
         pState->fProsodyAvgPitch = pVoiceMod->pSubVoice->m_fAvgPitch / 1.5;
      else {
         fVal = ProsValueParse (psz, &dwMean);
         switch (dwMean) {
         case 0:  // absolute
         case 1:  // number followd by hz
            pState->fProsodyAvgPitch = fVal;
            break;

         case 2:  // percentage
            pState->fProsodyAvgPitch = fVal / 100.0 * pVoiceMod->pSubVoice->m_fAvgPitch;
            break;

         case 3:  // +/- certain amount
            pState->fProsodyAvgPitch += fVal;
            break;

         case 4:  // +/- semitones
            pState->fProsodyAvgPitch *= pow(2, fVal / 12.0);
            break;

         case 5:  // +/- percent
            pState->fProsodyAvgPitch += fVal / 100.0 * pState->fProsodyAvgPitch;
            break;

         case 6:  // error
            break;
         }
         pState->fProsodyAvgPitch = max(pState->fProsodyAvgPitch, 1);
      }
   } // if pitch

   psz = pNode->AttribGetString (gpszRange);
   if (psz) {
      if (!_wcsicmp(psz, L"x-high"))
         pState->fProsodyPitchExpress = 2;
      else if (!_wcsicmp(psz, L"high"))
         pState->fProsodyPitchExpress = 1.5;
      else if (!_wcsicmp(psz, L"medium") || !_wcsicmp(psz, L"default"))
         pState->fProsodyPitchExpress = 1;
      else if (!_wcsicmp(psz, L"low"))
         pState->fProsodyPitchExpress = 0.5;
      else if (!_wcsicmp(psz, L"x-low"))
         pState->fProsodyPitchExpress = 0;
      else {
         fVal = ProsValueParse (psz, &dwMean);
         switch (dwMean) {
         case 2:  // percentage
            pState->fProsodyPitchExpress = fVal / 100.0;
            break;

         case 5:  // +/- percent
            pState->fProsodyPitchExpress += fVal / 100.0;
            break;

         case 0:  // absolute
         case 1:  // number followd by hz
         case 3:  // +/- certain amount
         case 4:  // +/- semitones
         case 6:  // error
            break;
         }
      }
   } // if range

   // rate
   psz = pNode->AttribGetString (gpszRate);
   if (psz) {
      if (!_wcsicmp(psz, L"x-fast"))
         pState->fProsodyWPM = (fp)pVoiceMod->pSubVoice->m_dwWordsPerMinute * 2;
      else if (!_wcsicmp(psz, L"fast"))
         pState->fProsodyWPM = (fp)pVoiceMod->pSubVoice->m_dwWordsPerMinute * sqrt((fp)2);
      else if (!_wcsicmp(psz, L"medium") || !_wcsicmp(psz, L"default"))
         pState->fProsodyWPM = (fp)pVoiceMod->pSubVoice->m_dwWordsPerMinute;
      else if (!_wcsicmp(psz, L"slow"))
         pState->fProsodyWPM = (fp)pVoiceMod->pSubVoice->m_dwWordsPerMinute / sqrt((fp)2);
      else if (!_wcsicmp(psz, L"x-slow"))
         pState->fProsodyWPM = (fp)pVoiceMod->pSubVoice->m_dwWordsPerMinute / 2;
      else {
         fVal = ProsValueParse (psz, &dwMean);
         switch (dwMean) {
         case 0:  // absolute
            pState->fProsodyWPM = fVal;
            break;

         case 2:  // percentage
            pState->fProsodyWPM = fVal / 100.0 * (fp)pVoiceMod->pSubVoice->m_dwWordsPerMinute;
            break;

         case 3:  // +/- certain amount
            pState->fProsodyWPM += fVal;
            break;

         case 5:  // +/- percent
            pState->fProsodyWPM += fVal / 100.0 * pState->fProsodyWPM;
            break;

         case 1:  // number followd by hz
         case 4:  // +/- semitones
         case 6:  // error
            break;
         }
         pState->fProsodyWPM = max(pState->fProsodyWPM, 1);
      }
   } // if rate

   // volume
   psz = pNode->AttribGetString (gpszVolume);
   if (psz) {
      if (!_wcsicmp(psz, L"x-loud"))
         pState->fProsodyVol = 4;
      else if (!_wcsicmp(psz, L"loud"))
         pState->fProsodyVol = 2;
      else if (!_wcsicmp(psz, L"medium") || !_wcsicmp(psz, L"default"))
         pState->fProsodyVol = 1;
      else if (!_wcsicmp(psz, L"soft"))
         pState->fProsodyVol = 1.0 / 2;
      else if (!_wcsicmp(psz, L"x-soft"))
         pState->fProsodyVol = 1.0 / 4;
      else if (!_wcsicmp(psz, L"silent"))
         pState->fProsodyVol = 0;
      else {
         fVal = ProsValueParse (psz, &dwMean);
         switch (dwMean) {
         case 0:  // absolute
         case 2:  // percentage
            pState->fProsodyVol = fVal / 100.0;
            break;

         case 3:  // +/- certain amount
            pState->fProsodyVol += fVal / 100.0;
            break;

         case 5:  // +/- percent
            pState->fProsodyVol += fVal / 100.0 * pState->fProsodyVol;
            break;

         case 1:  // number followd by hz
         case 4:  // +/- semitones
         case 6:  // error
            break;
         }
         pState->fProsodyVol = max(pState->fProsodyVol, 0);
      }
   } // if rate

}


/*************************************************************************************
CMTTS::SynthTextInterpretTags - Loops through the MML contains various tags and
interprets some of them. Namely,
   <Phoneme>
   <Emphasis>
   <TransPros>

This also inserts gpszTTSGlobalState mml if the state is changed by the prosody
call.

inputs
   PCMMLNode2         pNode - node
   PTTSGLOBALSTATE   pState - Filled with the current state. This way prosody tags
                     can be relative
   PTTSVOICEMOD   pVoiceMod - Parameters controlling how the voice is modified by
                  the original. Generally, pass in NULL. Only internal functions
                  will pass in non-null.
   BOOL              *pfTransPros - Initially fill this in with FALSE. It will be
                     modified to TRUE if any transplanted prosody is found.
                     If transplanted prosody is found, prosody generation algorithms
                     are run in a faster mode.
returns
   BOOL - TRUE if sueccs
*/
BOOL CMTTS::SynthTextInterpretTags (PCMMLNode2 pNode, PTTSGLOBALSTATE pState,
                                    PTTSVOICEMOD pVoiceMod, BOOL *pfTransPros)
{
   PCMLexicon pLex = pVoiceMod->pLex;
   if (!pLex)
      pLex = Lexicon();
   if (!pLex)
      return FALSE;
   CTextParse TextParse;
   if (!TextParse.Init (pLex->LangIDGet(), pLex))
      return FALSE;

   DWORD i, j;
   PWSTR psz;
   PCMMLNode2 pSub;
   for (i = 0; i < pNode->ContentNum(); i++) {
      pSub = NULL;
      pNode->ContentEnum (i, &psz, &pSub);
      if (!pSub)
         continue;
      psz = pSub->NameGet();
      if (!psz)
         continue;

      if (!_wcsicmp(psz, gpszProsody) || !_wcsicmp(psz, gpszEmotion) ) {
         TTSGLOBALSTATE gsNew = *pState;
         if (!_wcsicmp(psz, gpszProsody))
            ProsodyToGlobalState (pSub, &gsNew, pVoiceMod);
         else
            EmotionToGlobalState (pSub, &gsNew, pVoiceMod);

         // insert tag so will return to current state
         PCMMLNode2 pNewState = GlobalStateToMML (pState);
         if (pNewState)
            pNode->ContentInsert (i+1, pNewState);


         // parse text
         if (!TextParse.ParseFromMML (pSub, FALSE, FALSE))
            return FALSE;

         // parse the contents of this
         if (!SynthTextInterpretTags (pSub, &gsNew, pVoiceMod, pfTransPros))
            return FALSE;

         // loop through and pull them out
         PCMMLNode2 pEmph;
         while (pSub->ContentNum()) {
            pEmph = NULL;
            psz = NULL;
            DWORD dwNum = pSub->ContentNum()-1;
            pSub->ContentEnum (dwNum, &psz, &pEmph);
            if (psz) {
               pNode->ContentInsert (i+1, psz);
               pSub->ContentRemove (dwNum);
               continue;
            }

            // if it's doesn't have a name or is origtext then just remove
            psz = pEmph->NameGet();
            if (!psz || !_wcsicmp(psz,  gpszOrigText)) {
               pSub->ContentRemove (dwNum);
               continue;
            }

            // remove from original but dont actually delete
            pSub->ContentRemove (dwNum, FALSE);

            // add
            pNode->ContentInsert (i+1, pEmph);
         } // while have sub elements

         // finally, remove this one
         pNode->ContentRemove (i);
         // dont need to do i-- since new node will have been evalatuated already

         // finally, insert tag so that will begin new state
         pNewState = GlobalStateToMML (&gsNew);
         if (pNewState)
            pNode->ContentInsert (i, pNewState);
         continue;
      }
      else if (!_wcsicmp(psz, L"phoneme")) {
         // get the pronuncaition
         PWSTR pszPhoneme = pSub->AttribGetString (gpszPh);
         BYTE abPhone[128];   // phonemes
         DWORD dwBadPhone;
         WCHAR szPron[sizeof(abPhone)*2+1];
         if (!pszPhoneme)
            continue;   // ignore this
         if (!pLex->PronunciationFromText (pszPhoneme, abPhone, sizeof(abPhone), &dwBadPhone))
            continue;   // error, so ignore

         // find the length
         DWORD dwLen = (DWORD)strlen((char*)abPhone);
         if (!dwLen)
            continue;

         // subtract one to each
         for (j = 0; j < dwLen; j++)
            abPhone[j]--;

         // create a new word
         PCMMLNode2 pNew = new CMMLNode2;
         if (!pNew)
            continue;
         MMLBinaryToString (abPhone, dwLen, szPron);
         pNew->NameSet (TextParse.Word());
         pNew->AttribSetString (TextParse.Pronunciation(), szPron);

         // text of word?
         PCMMLNode2 pJunk;
         psz = NULL;
         pSub->ContentEnum (0, &psz, &pJunk);
         pNew->AttribSetString (TextParse.Text(), psz ? psz : L"unknown word");

         // insert it...
         pNode->ContentInsert (i, pNew);

         // remove this
         pNode->ContentRemove (i+1);
         continue;
      }
      else if (!_wcsicmp(psz, gpszEmphasis)) {
         // figure what kind of emphasis...
         fp fPitchAbs = 0, fVolAbs = 0, fDurAbs = 0, fPitchRel = 0, fVolRel = 0, fDurRel = 0;

         // default to moderate...
         if (!pSub->AttribNum()) {
            fVolRel = fDurRel = 1.2;
            fPitchRel = 1.1;
         }
         
         // see if have level
         PWSTR psz;
         psz = pSub->AttribGetString (gpszLevel);
         if (psz && !_wcsicmp(psz, gpszStrong)) {
            fVolRel = fDurRel = 1.4;
            fPitchRel = 1.2;
         }
         else if (psz && !_wcsicmp(psz, gpszNone))
            fPitchRel = fVolRel = fDurRel = 1.0;
         else if (psz && !_wcsicmp(psz, gpszReduced)) {
            fVolRel = fDurRel = 0.7;
            fPitchRel = 0.9;
         }
         else if (psz) { // or if moderate && !_wcsicmp(psz, gpszModerate))
            fVolRel = fDurRel = 1.2;
            fPitchRel = 1.1;
         }

         // see if other numbers set
         psz = pSub->AttribGetString (gpszPitchAbs);
         if (psz)
            fPitchAbs = _wtof(psz);
         psz = pSub->AttribGetString (gpszVolAbs);
         if (psz)
            fVolAbs = _wtof(psz);
         psz = pSub->AttribGetString (gpszDurAbs);
         if (psz)
            fDurAbs = _wtof(psz);
         psz = pSub->AttribGetString (gpszPitchRel);
         if (psz)
            fPitchRel = _wtof(psz);
         psz = pSub->AttribGetString (gpszVolRel);
         if (psz)
            fVolRel = _wtof(psz);
         psz = pSub->AttribGetString (gpszDurRel);
         if (psz)
            fDurRel = _wtof(psz);

         // figure out the attribute strings to set
         WCHAR aszTemp[3][32];
         PWSTR paszSet[3];
         memset (paszSet, 0, sizeof(paszSet));
         if (fPitchAbs > CLOSE) {
            MMLDoubleToString (fPitchAbs, aszTemp[0]);
            paszSet[0] = gpszPitchAbs;
         }
         else if (fPitchRel > CLOSE) {
            MMLDoubleToString (fPitchRel, aszTemp[0]);
            paszSet[0] = gpszPitchRel;
         }
         if (fVolAbs > CLOSE) {
            MMLDoubleToString (fVolAbs, aszTemp[1]);
            paszSet[1] = gpszVolAbs;
         }
         else if (fVolRel > CLOSE) {
            MMLDoubleToString (fVolRel, aszTemp[1]);
            paszSet[1] = gpszVolRel;
         }
         if (fDurAbs > CLOSE) {
            MMLDoubleToString (fDurAbs, aszTemp[2]);
            paszSet[2] = gpszDurAbs;
         }
         else if (fDurRel > CLOSE) {
            MMLDoubleToString (fDurRel, aszTemp[2]);
            paszSet[2] = gpszDurRel;
         }

         // parse text
         if (!TextParse.ParseFromMML (pSub, FALSE, FALSE))
            return FALSE;

         // parse the contents of this
         if (!SynthTextInterpretTags (pSub, pState, pVoiceMod, pfTransPros))
            return FALSE;

         // loop through and pull them out
         PCMMLNode2 pEmph;
         while (pSub->ContentNum()) {
            pEmph = NULL;
            psz = NULL;
            DWORD dwNum = pSub->ContentNum()-1;
            pSub->ContentEnum (dwNum, &psz, &pEmph);
            if (psz) {
               pNode->ContentInsert (i+1, psz);
               pSub->ContentRemove (dwNum);
               continue;
            }

            // else, remove from original but dont actually delete
            pSub->ContentRemove (dwNum, FALSE);

            // set the emphasis strings
            DWORD k;
            for (k = 0; k < 3; k++)
               if (paszSet[k])
                  pEmph->AttribSetString (paszSet[k], aszTemp[k]);

            // add
            pNode->ContentInsert (i+1, pEmph);
         } // while have sub elements

         // finally, remove this one
         pNode->ContentRemove (i);
         // dont need to do i-- since new node will have been evalatuated already

         continue;
      }
      else if (!_wcsicmp(psz, gpszPOS)) {
         // figure what kind of POS
         DWORD dwPOS = -1;
         PWSTR psz = pSub->AttribGetString (gpszMajor);
         DWORD j, k;
         if (psz) for (j = 0; j < POS_MAJOR_NUM; j++) for (k = 0; k < 2; k++) {
            PWSTR pszComp = (PWSTR)pLex->POSToString (POS_MAJOR_MAKE(j), k ? TRUE : FALSE);
            if (!pszComp)
               continue;
            if (!_wcsicmp(pszComp, psz)) {
               dwPOS = POS_MAJOR_MAKE(j);
               break;
            }
         }

         // make string to set
         WCHAR szTemp[16];
         _itow ((int)dwPOS, szTemp, 10);

         // parse text
         if (!TextParse.ParseFromMML (pSub, FALSE, FALSE))
            return FALSE;

         // parse the contents of this
         if (!SynthTextInterpretTags (pSub, pState, pVoiceMod, pfTransPros))
            return FALSE;

         // loop through and pull them out
         PCMMLNode2 pEmph;
         while (pSub->ContentNum()) {
            pEmph = NULL;
            psz = NULL;
            DWORD dwNum = pSub->ContentNum()-1;
            pSub->ContentEnum (dwNum, &psz, &pEmph);
            if (psz) {
               pNode->ContentInsert (i+1, psz);
               pSub->ContentRemove (dwNum);
               continue;
            }

            // else, remove from original but dont actually delete
            pSub->ContentRemove (dwNum, FALSE);

            psz = pEmph->NameGet();
            if (psz && (dwPOS != -1) && !_wcsicmp(psz,TextParse.Word()))
               pEmph->AttribSetString (TextParse.POS(), szTemp);


            // add
            pNode->ContentInsert (i+1, pEmph);
         } // while have sub elements

         // finally, remove this one
         pNode->ContentRemove (i);
         // dont need to do i-- since new node will have been evalatuated already

         continue;
      }
      else if (!_wcsicmp(psz, gpszTransPros)) {
         // parse text
         if (!TextParse.ParseFromMML (pSub, FALSE, FALSE))
            return FALSE;

         // found transplanted prosody
         *pfTransPros = TRUE;

         // parse the contents of this
         if (!SynthTextInterpretTags (pSub, pState, pVoiceMod, pfTransPros))
            return FALSE;

         // loop through and pull them out
         PCMMLNode2 pEmph;
         while (pSub->ContentNum()) {
            pEmph = NULL;
            psz = NULL;
            DWORD dwNum = pSub->ContentNum()-1;
            pSub->ContentEnum (dwNum, &psz, &pEmph);
            if (psz) {
               pNode->ContentInsert (i+1, psz);
               pSub->ContentRemove (dwNum);
               continue;
            }

            // if it's doesn't have a name or is origtext then just remove
            psz = pEmph->NameGet();
            if (!psz || !_wcsicmp(psz,  gpszOrigText)) {
               pSub->ContentRemove (dwNum);
               continue;
            }

            // if it's a word then look for a phoneme tag
            if (!_wcsicmp(psz, TextParse.Word())) {
               PWSTR pszPhoneme = pEmph->AttribGetString (gpszPh);
               BYTE abPhone[128];   // phonemes
               DWORD dwBadPhone;
               WCHAR szPron[sizeof(abPhone)*2+1];
               if (!pszPhoneme)
                  goto nophone;   // ignore this
               if (!pLex->PronunciationFromText (pszPhoneme, abPhone, sizeof(abPhone), &dwBadPhone))
                  goto nophone;   // error, so ignore

               // find the length
               DWORD dwLen = (DWORD)strlen((char*)abPhone);
               if (!dwLen)
                  goto nophone;

               // subtract one to each
               for (j = 0; j < dwLen; j++)
                  abPhone[j]--;

               // create a new word
               MMLBinaryToString (abPhone, dwLen, szPron);
               pEmph->AttribSetString (TextParse.Pronunciation(), szPron);
            } // if word look for phoneme
nophone:

            // else, remove from original but dont actually delete
            pSub->ContentRemove (dwNum, FALSE);

            // add
            pNode->ContentInsert (i+1, pEmph);
         } // while have sub elements

         // finally, remove this one
         pNode->ContentRemove (i);
         // dont need to do i-- since new node will have been evalatuated already

         continue;
      }
   } // i


   return TRUE;
}



/*************************************************************************************
CMTTS::XXXGet/Set - These functions access member variables of the tts voice
that might be remapped if use a derived tts voice.
*/
BOOL CMTTS::TriPhoneGroupGet (void)
{
   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster)
         return FALSE;
      return m_pTTSMaster->TriPhoneGroupGet();
   }

   return m_dwTriPhoneGroup;
}

void CMTTS::TriPhoneGroupSet (DWORD dwTriPhoneGroup)
{
   if (m_fIsDerived)
      return;

   m_dwTriPhoneGroup = dwTriPhoneGroup;
}

BOOL CMTTS::KeepLogGet (void)
{
   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster)
         return FALSE;
      return m_pTTSMaster->KeepLogGet();
   }
   return m_fKeepLog;
}

void CMTTS::KeepLogSet (BOOL fKeepLog)
{
   // if this is a derived voice pass on down
   if (m_fIsDerived)
      return;

   m_fKeepLog = fKeepLog;
}

BOOL CMTTS::FullPCMGet (void)
{
   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster)
         return FALSE;
      return m_pTTSMaster->FullPCMGet();
   }

#ifdef NOMODS_DISABLEPCM
   return FALSE;
#endif

   return m_fFullPCM;
}


void CMTTS::TTSTARGETCOSTSSet (PTTSTARGETCOSTS pTarget)
{
   // if this is a derived voice pass on down
   if (m_fIsDerived)
      return;

   if (!m_memTTSTARGETCOSTS.Required (sizeof(TTSTARGETCOSTS)))
      return;
   m_memTTSTARGETCOSTS.m_dwCurPosn = sizeof(TTSTARGETCOSTS);
   memcpy (m_memTTSTARGETCOSTS.p, pTarget, sizeof(TTSTARGETCOSTS));
}


void CMTTS::FullPCMSet (BOOL fFullPCM)
{
   // if this is a derived voice pass on down
   if (m_fIsDerived)
      return;

   m_fFullPCM = fFullPCM;
}

fp CMTTS::AvgPitchGet (void)
{
   if (m_lPCMTTSSubVoice.Num()) {
      // ask average pitch with sub-voices
      PCMTTSSubVoice *ppsv = (PCMTTSSubVoice*) m_lPCMTTSSubVoice.Get(0);
      return ppsv[0]->m_fAvgPitch;
   }

   return m_fAvgPitch;
}

fp CMTTS::AvgSyllableDurGet (void)
{
   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster)
         return 0;
      return m_pTTSMaster->AvgSyllableDurGet();
   }

   return m_fAvgSyllableDur;
}


/*************************************************************************************
CMTTS::EnergyPerPitchSet - Takes an array of ENERGYPERPITCHNUM x SRDATAPOINT db values
for how much louder higher/lower pitch voiced SRFEATUREs are than one at the
average pitch.

inputs
   char           *pacEnergyPerPitch - As above
returns
   none
*/
void CMTTS::EnergyPerPitchSet (char *pacEnergyPerPitch)
{
   DWORD dwNeed = ENERGYPERPITCHNUM * SRDATAPOINTS;
   if (!m_memEnergyPerPitch.Required (dwNeed))
      return;

   memcpy (m_memEnergyPerPitch.p, pacEnergyPerPitch, dwNeed);
   m_memEnergyPerPitch.m_dwCurPosn = dwNeed;
}


/*************************************************************************************
CMTTS::EnergyPerPitchGet - Given a pitch (in hz), this returns a pointer to
SRDATAPOINTS chars indicating the number of dB to increase/decrease the pitch
by.

inputs
   fp       fPitch - Pitch in db
returns
   char * - Array of SRDATAPOINTS chars, or NULL if error
*/
char *CMTTS::EnergyPerPitchGet (fp fPitch)
{
#ifdef NOMODS_ENERGYPERPITCHGET
   return NULL;
#endif

   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster)
         return NULL;
      return m_pTTSMaster->EnergyPerPitchGet(fPitch);
   }

   if (fPitch <= 0)
      return NULL;   // error

   fPitch = log(fPitch / (fp)ENERGYPERPITCHBASE) / log((fp)2) * (fp)ENERGYPERPITCHPOINTSPEROCTAVE + 0.5;
   fPitch = max(fPitch, 0);
   fPitch = min(fPitch, (fp)ENERGYPERPITCHNUM-1);
   DWORD dwIndex = (DWORD) fPitch;

   if (((dwIndex + 1) * SRDATAPOINTS) > m_memEnergyPerPitch.m_dwCurPosn)
      return NULL;   // out of range

   // else
   return (char*)m_memEnergyPerPitch.p + dwIndex * SRDATAPOINTS;
}


/*************************************************************************************
CMTTS::EnergyPerVolumeSet - Takes an array of ENERGYPERVOLUMENUM x SRDATAPOINT db values
for how much louder higher/lower volume voiced SRFEATUREs are than one at the
average volume.

inputs
   char           *pacEnergyPerVolume - As above
returns
   none
*/
void CMTTS::EnergyPerVolumeSet (char *pacEnergyPerVolume)
{
   DWORD dwNeed = ENERGYPERVOLUMENUM * SRDATAPOINTS;
   if (!m_memEnergyPerVolume.Required (dwNeed))
      return;

   memcpy (m_memEnergyPerVolume.p, pacEnergyPerVolume, dwNeed);
   m_memEnergyPerVolume.m_dwCurPosn = dwNeed;
}


/*************************************************************************************
CMTTS::EnergyPerVolumeGet - Given a volume (in hz), this returns a pointer to
SRDATAPOINTS chars indicating the number of dB to increase/decrease the volume
by.

inputs
   fp       fEnergyRatio - Ratio of how loud this unit is compared to the average
returns
   char * - Array of SRDATAPOINTS chars, or NULL if error
*/
char *CMTTS::EnergyPerVolumeGet (fp fEnergyRatio)
{
#ifdef NOMODS_ENERGYPERVOLUMEGET
   return NULL;
#endif

   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster)
         return NULL;
      return m_pTTSMaster->EnergyPerVolumeGet(fEnergyRatio);
   }

   fEnergyRatio = max(fEnergyRatio, CLOSE);

   fEnergyRatio = log(fEnergyRatio) / log((fp)2) * (fp)ENERGYPERVOLUMEPOINTSPEROCTAVE + 0.5;
   fEnergyRatio += (fp)ENERGYPERVOLUMECENTER;
   fEnergyRatio = max(fEnergyRatio, 0.0);
   fEnergyRatio = min(fEnergyRatio, (fp)ENERGYPERVOLUMENUM-1);
   DWORD dwIndex = (DWORD) fEnergyRatio;

   if (((dwIndex + 1) * SRDATAPOINTS) > m_memEnergyPerVolume.m_dwCurPosn)
      return NULL;   // out of range

   // else
   return (char*)m_memEnergyPerVolume.p + dwIndex * SRDATAPOINTS;
}


void CMTTS::AvgPitchSet (fp fAvgPitch)
{
   m_fAvgPitch = max(fAvgPitch, 1);
}

void CMTTS::LexFuncWordsSet (PCMLexicon pLex, DWORD dwBin)
{
   if (m_fIsDerived)
      return;

   if (dwBin >= NUMFUNCWORDGROUP)
      return;

   if (m_apLexFuncWord[dwBin])
      delete m_apLexFuncWord[dwBin];
   m_apLexFuncWord[dwBin] = pLex ? pLex->Clone() : NULL;
}

void CMTTS::AvgSyllableDurSet (fp fAvgSyllableDur)
{
   m_fAvgSyllableDur = max(fAvgSyllableDur, .01);
}

DWORD CMTTS::WordsPerMinuteGet (void)
{
   return m_dwWordsPerMinute;
}

void CMTTS::WordsPerMinuteSet (DWORD dwWordsPerMinute)
{
   m_dwWordsPerMinute = max (dwWordsPerMinute, 1);
}

PCMLexicon CMTTS::LexWordsGet (void)
{
   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster)
         return NULL;
      return m_pTTSMaster->LexWordsGet();
   }

   return m_pLexWords;
}

PCMLexicon CMTTS::LexTrainingWordsGet (void)
{
   // if this is a derived voice pass on down
   if (m_fIsDerived) {
      if (!m_pTTSMaster)
         return NULL;
      return m_pTTSMaster->LexTrainingWordsGet();
   }

   return m_pLexTrainingWords;
}

BOOL CMTTS::LexWordsSet (PCMLexicon pNew)
{
   if (m_fIsDerived)
      return FALSE;

   if (m_pLexWords)
      delete m_pLexWords;
   m_pLexWords = pNew->Clone();

   return m_pLexWords ? TRUE : FALSE;
}

#if 0 // old prosody
BOOL CMTTS::LexWordEmphSet (PCMLexicon paLexWordEmph[NUMLEXWORDEMPH])
{
   if (m_fIsDerived)
      return FALSE;

   // transfer over the most common words for scaling
   DWORD i;
   for (i = 0; i < NUMLEXWORDEMPH; i++) {
      if (m_apLexWordEmph[i])
         delete m_apLexWordEmph[i];
      m_apLexWordEmph[i] = NULL;
      if (paLexWordEmph[i])
         m_apLexWordEmph[i] = paLexWordEmph[i]->Clone();
   }// i

   return TRUE;
}


BOOL CMTTS::LexFuncWordsSet (PCMLexicon pLexFuncWords)
{
   if (m_fIsDerived)
      return FALSE;

   if (m_pLexFuncWords)
      delete m_pLexFuncWords;
   m_pLexFuncWords = pLexFuncWords ? pLexFuncWords->Clone() : NULL;

   return TRUE;
}

BOOL CMTTS::LexWordEmphScaleSet (CPoint paLexWordEmphScale[NUMLEXWORDEMPH+1])
{
   if (m_fIsDerived)
      return FALSE;

   memcpy (m_apLexWordEmphScale, paLexWordEmphScale, sizeof(m_apLexWordEmphScale));
   return TRUE;
}

BOOL CMTTS::ProsWordEmphFromWordLength (CPoint paWordEmphFromWordLength[NUMPROSWORDLENGTH])
{
   memcpy (m_apProsWordEmphFromWordLength, paWordEmphFromWordLength, sizeof(m_apProsWordEmphFromWordLength));
   return TRUE;
}
#endif // 0

BOOL CMTTS::ProsPhoneEmph (CPoint paPhoneEmph[NUMPHONEEMPH*2][PHONEPOSBIN])
{
   memcpy (m_apPhoneEmph, paPhoneEmph, sizeof(m_apPhoneEmph));
   return TRUE;
}


#if 0 // micropauses now in prosody model
PCMem CMTTS::MemMicroPauseGet (void)
{
   if (m_fIsDerived)
      return FALSE;

   return &m_memMicroPause;
}
#endif // 0


#if 0 // old prosody
PCMem CMTTS::MemNGramGet (void)
{
   if (m_fIsDerived)
      return FALSE;

   return &m_memNGram;
}
#endif // 0


PCTTSProsody CMTTS::TTSProsodyGet (void)
{
   // BUGFIX - Allow to get prosody, so can edit derived voice
   // if (m_fIsDerived)
   //   return NULL;

   return m_pCTTSProsody;
}



// NOTE: pAdd is kept by the TTS engine
#if 0 // old prosody
BOOL CMTTS::PunctProsAdd (PCTTSPunctPros pAdd)
{
   if (m_fIsDerived)
      return FALSE;

   m_lPCTTSPunctPros.Add (&pAdd);
   return TRUE;
}
#endif // 0, old prosody

BOOL CMTTS::IsDerivedGet (void)
{
   return m_fIsDerived;
}

void CMTTS::IsDerivedSet (BOOL fDerived)
{
   m_fIsDerived = fDerived;
}


PWSTR CMTTS::TTSMasterGet (void)
{
   if (!m_fIsDerived)
      return NULL;

   return m_szTTSMaster;
}

CMTTS * CMTTS::TTSMasterGet2 (void)
{
   return m_pTTSMaster;
}

// TTSMasterSet - Note: Tries to load the new master. If it cant then errors
// out. If it can, but is a derived voice then errors out.
BOOL CMTTS::TTSMasterSet (PWSTR pszMaster)
{
   if (!m_fIsDerived)
      return FALSE;

   PCMTTS pMaster = TTSCacheOpen (pszMaster);
   if (!pMaster)
      return FALSE;
   if (pMaster->m_fIsDerived) {
      TTSCacheClose (pMaster);
      return FALSE;
   }

   // keep
   wcscpy (m_szTTSMaster, pszMaster);
   if (m_pTTSMaster)
      TTSCacheClose (m_pTTSMaster);
   m_pTTSMaster = pMaster;

   // remember new wpm and pitch
   m_dwWordsPerMinute = pMaster->m_dwWordsPerMinute;
   m_fAvgPitch = pMaster->m_fAvgPitch;
   m_fAvgSyllableDur = pMaster->m_fAvgSyllableDur;

   return TRUE;
}




/*************************************************************************************
CMTTS::GlottalPulseChange - This adjusts the voiced energy based on guestimates
for how it will change as the synthesized pitch is higher or lower than the recorded
pitch.

NOTE: These numbers were gotten experimenting with recordings of my voice.
As such, its not learned, but it should be prettly close for other voices.
At Pitch=0.66 of orig, need fund(1x) x .6, 2x x .8, 4x x 1, 8x x .6, 16x x .3, 32x x .2

BUGFIX - Put this in to hopeful improve the tts voice. It's noticable if
make it since, but it can't really be heard in speech, although some
changes can be seen in the energy spectrum.

inputs
   PSRFEATURE        psr - Feature to modify (voiced only). Modified in place
   fp                fOrigPitch - Original pitch (in Hz)
   fp                fNewPitch - New pitch (in Hz)
   BOOL              fIsVoiced - Set to TRUE if is voiced phoneme
returns
   none
*/
void CMTTS::GlottalPulseChange (PSRFEATURE psr, fp fOrigPitch, fp fNewPitch, BOOL fIsVoiced)
{
   // if it's not voiced then ignore
   if (!fIsVoiced)
      return;
   // what's the change
   fOrigPitch = max(fOrigPitch, 1);
   fNewPitch = max(fNewPitch, 1);
   fp fChange;

   // need average pitch in terms of this voice
   fChange = fNewPitch / fOrigPitch * m_fAvgPitch;
   char *pac = EnergyPerPitchGet (fChange);
   if (!pac)
      return;
   DWORD i;
   int iVal;
   for (i = 0; i < SRDATAPOINTS; i++) {
      iVal = (int)psr->acVoiceEnergy[i] + (int)pac[i];
      iVal = max(iVal, SRABSOLUTESILENCE);
      iVal = min(iVal, SRMAXLOUDNESS);
      psr->acVoiceEnergy[i] = (char)iVal;
   } // i

#if 0 // old code
   fChange = log(fNewPitch / fOrigPitch) / log(.66);

#define NUMPULSEBIN     6
   fp afScale[NUMPULSEBIN];
   afScale[0] = pow(.6, fChange);
   afScale[1] = pow(.8, fChange);
   afScale[2] = pow(1, fChange);
   afScale[3] = pow(.6, fChange);
   afScale[4] = pow(.3, fChange);
   afScale[5] = pow(.2, fChange);

   // normalize the scale so dont make it too loud/quiet
   DWORD i;
   fp fSum = 0;
   for (i = 0; i < NUMPULSEBIN; i++)
      fSum += afScale[i];
   fSum /= (fp)NUMPULSEBIN;
   if (fChange >= 0)
      fSum = 1;   // when go lower don't end up increasing volume
   for (i = 0; i < NUMPULSEBIN; i++) {
      afScale[i] /= fSum;

      // convert this to db
      afScale[i] = max(afScale[i], 0.001);
      afScale[i] = log10(afScale[i]) * 20.0;
   }

   // figure out frequencies where these occur
   fp afFreq[NUMPULSEBIN];
   for (i = 0; i < NUMPULSEBIN; i++) {
      afFreq[i] = fNewPitch * (fp)(1 << i);

      // convert into points on the SRFEATURE scale
      afFreq[i] = log(afFreq[i] / SRBASEPITCH) / log(2) * (fp)SRPOINTSPEROCTAVE;
   }

   // loop over the srdatapoints and interpolate
   DWORD dwLast = 0;
   for (i = 0; i < SRDATAPOINTS; i++) {
      int iScale;

      if ((fp)i <= afFreq[0])
         iScale = (int)afScale[0];
      else if ((fp)i >= afFreq[NUMPULSEBIN-1])
         iScale = (int)afScale[NUMPULSEBIN-1];
      else {
         while ((dwLast+1 < NUMPULSEBIN) && ((fp)i >= afFreq[dwLast+1]))
            dwLast++;

         fp fAlpha = ((fp)i - afFreq[dwLast]) / (afFreq[dwLast+1]-afFreq[dwLast]);
         iScale = (int)((1.0 - fAlpha) * afScale[dwLast] + fAlpha * afScale[dwLast+1]);
      }

      iScale += (int)psr->acVoiceEnergy[i];
      iScale = max(iScale, -127);
      iScale = min(iScale, 127);
      psr->acVoiceEnergy[i] = (char)iScale;
   } // i
#endif // 0
}


/*************************************************************************************
CMTTS::WordRank - This looks in m_apLexFuncWord's and figures out the word
rank for purposes of the prosody model.

inputs
   PWSTR          pszWord - Word
   BOOL           fUseHistory - If TRUE, also look in the history of recent words
                     as called by WordRankHistory(), to determine the rank
returns
   DWORD - RAnk, from 0 to NUMPROSODYMODELCOMMON-1. 0 being the most common.
*/
DWORD CMTTS::WordRank (PWSTR pszWord, BOOL fUseHistory)
{
   if (m_fIsDerived && m_pTTSMaster)
      return m_pTTSMaster->WordRank (pszWord, fUseHistory);

   // BUGFIX - If NULL word then return uncommon
   if (!pszWord)
      return NUMPROSODYMODELCOMMON-1;

   // look in each of the lexicons and determine a rank
   DWORD i;
   for (i = 0; i < NUMFUNCWORDGROUP; i++) {
      if (!m_apLexFuncWord[i])
         continue;

      if (m_apLexFuncWord[i]->WordExists (pszWord))
         return i / FUNCWORDGROUPPERPROSODYMODELCOMMON;
   } // i

   if (!fUseHistory)
      return NUMPROSODYMODELCOMMON-1;

   // else, didn't find, so look in the history
   for (i = 0; i < m_lWordRankHistory.Num(); i++)
      if (!_wcsicmp(pszWord, (PWSTR)m_lWordRankHistory.Get(i)))
         return NUMPROSODYMODELCOMMON-2;  // since spoke recently assume a slightly lower ranking

   // else, highest rank
   return NUMPROSODYMODELCOMMON-1;
}


/*************************************************************************************
CMTTS::WordRankHistory - Adds a word to the history of words recently spoken.
Any word that's recently spoken will be deemphasized.

inputs
   PWSTR          pszWord - Word. If this is a NULL string then clear the list
returns
   none
*/
#define NUMWORDRANKHISTORY    25       // number of non-function words kept in the word history
void CMTTS::WordRankHistory (PWSTR pszWord)
{
   if (m_fIsDerived && m_pTTSMaster)
      return m_pTTSMaster->WordRankHistory (pszWord);

   if (!pszWord) {
      m_lWordRankHistory.Clear();
      return;
   }

   // if this is already a common word then ignore
   if (WordRank (pszWord, FALSE) < NUMPROSODYMODELCOMMON-1)
      return;

   // if too many clear out
   while (m_lWordRankHistory.Num() >= NUMWORDRANKHISTORY)
      m_lWordRankHistory.Remove (0);

   // add this word
   m_lWordRankHistory.Add (pszWord, (wcslen(pszWord)+1)*sizeof(WCHAR));
}

/****************************************************************************
ProsodyModelInitPage - Call on init page to set text

inputs
   PCEscPage      pPage - Page
   WCHAR          aszProsodyTTS[NUMPROSODYTTS][256] - Prosody strings
*/
void ProsodyModelInitPage (PCEscPage pPage, WCHAR aszProsodyTTS[NUMPROSODYTTS][256])
{
   WCHAR szTemp[64];
   DWORD i;
   PCEscControl pControl;
   for (i = 0; i < NUMPROSODYTTS; i++) {
      swprintf (szTemp, L"prosodytts%d", (int) i);
      if (pControl = pPage->ControlFind (szTemp))
         pControl->AttribSet (Text(), aszProsodyTTS[i]);
   }

}

/****************************************************************************
ProsodyModelEdit - Trap button press calls for the prosody model.
Call this when get ESCN_BUTTONPRESS.

inputs
   PCMLexicon     pLexTTS - Lexicon with phonemes in it
   PCEscPage      pPage - Page
   PESCNBUTTONPRESS p - info
   WCHAR          aszProsodyTTS[NUMPROSODYTTS][256] - Prosody strings
   PCTTSProsody   pTTSProsody - To modify
returns
   BOOL - TRUE if trap, FALSE if should handle elsewhere
*/
BOOL ProsodyModelEdit (PCMLexicon pLexTTS, PCEscPage pPage, PESCNBUTTONPRESS p, WCHAR aszProsodyTTS[NUMPROSODYTTS][256],
                       PCTTSProsody pTTSProsody)
{
   PWSTR psz = p->pControl->m_pszName;
   if (!psz)
      return FALSE;

   PWSTR pszProsodyTTSOpen = L"prosodyttsopen";
   DWORD dwProsodyTTSOpenLen = (DWORD)wcslen(pszProsodyTTSOpen);
   if (_wcsnicmp(psz, pszProsodyTTSOpen, dwProsodyTTSOpenLen))
      return FALSE;  // not this

   DWORD dwNum = _wtoi(psz + dwProsodyTTSOpenLen);
   WCHAR szTemp[256];
   wcscpy (szTemp, aszProsodyTTS[dwNum]);

   if (TTSProsodyFileOpenDialog (pPage->m_pWindow->m_hWnd, szTemp, sizeof(szTemp)/sizeof(WCHAR), FALSE, TRUE))
      wcscpy (aszProsodyTTS[dwNum], szTemp);
   else
      aszProsodyTTS[dwNum][0] = 0;

   swprintf (szTemp, L"prosodytts%d", (int)dwNum);
   PCEscControl pControl;
   if (pControl = pPage->ControlFind (szTemp))
      pControl->AttribSet (Text(), aszProsodyTTS[dwNum]);

   // read and rebuild
   pTTSProsody->Clear();
   CMTTS TTSTemp;
   CTTSProsody TTSProsodyTemp;
   // TTSProsodyTemp.LexiconSet (pTTSProsody->LexiconGet());
   DWORD i;
   for (i = 0; i < NUMPROSODYTTS; i++) {
      psz = aszProsodyTTS[i];
      if (!psz[0])
         continue;   // empty

      BOOL fIsTTS = FALSE;
      DWORD dwLen = (DWORD)wcslen(psz);
      if ((dwLen >= 4) && !_wcsicmp(psz + (dwLen-4), L".tts"))
         fIsTTS = TRUE;

      PCTTSProsody pTemp = NULL;
      if (fIsTTS) {
         // get from tts voice
         if (TTSTemp.Open(psz))
            pTemp = TTSTemp.TTSProsodyGet();
      }
      else {
         // get from prosody model
         if (TTSProsodyTemp.Open (psz))
            pTemp = &TTSProsodyTemp;
      }

      if (!pTemp)
         pPage->MBWarning ( psz,
            L"The TTS voice (or prosody model) used for additional prosody couldn't be opened.",
            MB_ICONEXCLAMATION | MB_OK);
      else
         pTTSProsody->Merge (pLexTTS, pTemp);
   } // i

   return TRUE;
}



/****************************************************************************
TTSModifiedMainPage
*/
static BOOL TTSModifiedMainPage (PCEscPage pPage, DWORD dwMessage, PVOID pParam)
{
   PTTSMMP pTTSMP = (PTTSMMP) pPage->m_pUserData;
   PCMTTS pVF = pTTSMP->pTTS;

   switch (dwMessage) {
   case ESCM_INITPAGE:
      {
         // enable/disable controls
         PCEscControl pControl;
         BOOL fHaveMain = (pVF->TTSMasterGet2() ? TRUE : FALSE);
         if (pControl = pPage->ControlFind (L"synth"))
            pControl->Enable (fHaveMain);

         // set some sample text
         pControl = pPage->ControlFind (L"testspeak");
         if (pControl)
            pControl->AttribSet (Text(), L"This is a test.");

         ProsodyModelInitPage (pPage, pVF->m_aszProsodyTTS);
      }
      break;

   case ESCN_BUTTONPRESS:
      {
         PESCNBUTTONPRESS p = (PESCNBUTTONPRESS) pParam;

         if (ProsodyModelEdit (pVF->Lexicon(), pPage, p, pVF->m_aszProsodyTTS, pVF->TTSProsodyGet()))
            return TRUE;

         if (!p->pControl || !p->pControl->m_pszName)
            break;
         PWSTR psz;
         psz = p->pControl->m_pszName;

         PWSTR pszTestPlay = L"testplay", pszMoveUp = L"moveup", pszMoveDown = L"movedown",
            pszCopy = L"copy", pszDelete = L"delete", pszEditVoice = L"editvoice";
         DWORD dwTestPlayLen = (DWORD)wcslen(pszTestPlay), dwMoveUpLen = (DWORD)wcslen(pszMoveUp),
            dwMoveDownLen = (DWORD)wcslen(pszMoveDown), dwCopyLen = (DWORD)wcslen(pszCopy),
            dwDeleteLen = (DWORD)wcslen(pszDelete), dwEditVoiceLen = (DWORD)wcslen (pszEditVoice);

         if (!_wcsnicmp (psz, pszTestPlay, dwTestPlayLen)) {
            if (!pVF->TTSMasterGet2()) {
               pPage->MBWarning (L"You don't have a master TTS voice selected yet.");
               return TRUE;
            }

            DWORD dwNum = (DWORD)_wtoi(psz + dwTestPlayLen);

            WCHAR szTemp[256];
            szTemp[0] = 0;
            DWORD dwNeed;
            PCEscControl pControl = pPage->ControlFind (L"testspeak");
            if (!pControl)
               return TRUE;
            pControl->AttribGet (Text(), szTemp, sizeof(szTemp), &dwNeed);

            CProgress Progress;
            Progress.Start (pPage->m_pWindow->m_hWnd, "Synthesizing...");
            pTTSMP->pWave->QuickPlayStop();

            TTSVOICEMOD vm;
            PCMTTSSubVoice *ppsv = (PCMTTSSubVoice*) pVF->m_lPCMTTSSubVoice.Get(0);
            PCTTSProsody apTTSProsody[